import React from 'react';
import VideoCard from './VideoCard';
import UploadCard from './UploadCard';
import { getClient } from '../../lib/vhsclient';

class UniversalCard extends React.Component {
  constructor(props) {
    super(props);
    this.client = getClient();
    this.state = {
      video: props.video,
    };

  }

  uploadProcessed = (id) => {
    this.client
      .get('/videos/' + id)
      .then(r => {
        this.setState({ video: r.data })
      });
  }

  render() {
    if (this.state.video) {
      return <VideoCard video={this.state.video} onPlay={this.props.onPlay} handleDelete={this.props.handleVideoDelete} />;
    } else {
      return <UploadCard file={this.props.file} onProcessed={this.uploadProcessed} />;
    }
  }
}

export default UniversalCard;
