import React from 'react';
import Card, { CardContent, CardMedia } from 'material-ui/Card';
import Typography from 'material-ui/Typography';
import Uploader from '../../lib/uploader';
import { LinearProgress, CircularProgress } from 'material-ui/Progress';
import { withStyles } from 'material-ui/styles';
import { getClient } from '../../lib/vhsclient';

const styles = (t) => ({
  card: {
    display: "flex",
    flexDirection: "column",
    margin: 15,
    overflow: 'hidden',
    width: 360,
  },
  media: {
    minHeight: "12vw",
    minWidth: "12vw",
    position: "relative",
    display: "flex",
    justifyContent: "center",
    alignItems: "center",
  },
  title: {
    marginBottom: 10,
    flexGrow: 1,
  },
  progress: {
    textAlign: "center",
    marginTop: "auto",
  },
  content: {
    display: "flex",
    flexDirection: "column",
    height: "100%",
  },
  pendingTranscode: {
    color: t.palette.error.main,
  },
  transcoding: {
    color: t.palette.primary.main,
  }
});

class UploadCard extends React.Component {

  constructor(props) {
    super(props);

    this.client = getClient();
  }

  state = {
    progress: 0,
    error: false,
    errorMsg: "",
  }

  updateProgress = (p) => {
    this.setState({ progress: p });
  }

  onRefresh = (u) => {
    this.setState({ upload: u });
    if (u.status === "processed") {
      this.props.onProcessed(u.id);
    }
  }

  uploading = () => {
    var u = this.state.upload;
    if (u == null) {
      return true;
    }
    if ((u.status === "created") || (u.status === "uploading")) {
      return true;
    }
    return false;
  }

  pendingTranscode = () => {
    var u = this.state.upload;
    if (u == null) {
      return false;
    }
    if (u.status === "pendingTranscode") {
      return true;
    }
    return false;
  }

  transcoding = () => {
    var u = this.state.upload;
    if (u == null) {
      return false;
    }
    if (u.status === "transcoding") {
      return true;
    }
    return false;
  }

  failed = () => {
    if (this.state.error) {
      return true;
    }
    var u = this.state.upload;
    if (u == null) {
      return false;
    }
    if (u.status === "failed") {
      return true;
    }
    return false;
  }

  progressClass = () => {
    if (this.pendingTranscode()) {
      return this.props.classes.pendingTranscode;
    }
    return this.props.classes.transcoding;
  }

  onError = (err) => {
    this.setState({ error: true, errorMsg: JSON.stringify(err) });
  }

  componentDidMount() {
    var uploader = new Uploader(
      this.props.file, 
      this.updateProgress, 
      this.onRefresh, 
      this.onError);
    uploader.start()
      .then(r => { 
        uploader.poll();
      }).catch(e => { 
        this.setState({ error: true, errorMsg: JSON.stringify(e.response.data) }) 
      });
  }

  render() {
    const classes = this.props.classes;
    const error = 
      <Typography color="error">
        {this.state.errorMsg}
        {this.state.upload && this.state.upload.failureReason}
      </Typography>;

    const id = 
      <Typography className={classes.title} type="subheading">
        {this.state.upload && this.state.upload.id}
      </Typography>;

    const uploadProgress = 
      <LinearProgress 
        mode="determinate" 
        color="primary"
        value={this.state.progress} />;

    const transcodeProgress =
      <CircularProgress className={this.progressClass()} size={32} />

    const progress =
      <div className={classes.progress}>
        {this.uploading() && uploadProgress}
        {(this.transcoding() || this.pendingTranscode()) && transcodeProgress}
      </div>

    return (
      <Card className={classes.card}>
        <CardMedia 
          className={classes.media}
          image="/question.png">
        </CardMedia>
        <CardContent className={classes.content}>
          {id}
          {this.state.error && error}
          {this.failed() && error}
          {progress}
        </CardContent>
      </Card>
    );
  }
}

export default withStyles(styles)(UploadCard);
