import React from 'react';
import Card, { CardContent, CardMedia } from 'material-ui/Card';
import Typography from 'material-ui/Typography';
import PlayArrow from 'material-ui-icons/PlayArrow';
import Info from 'material-ui-icons/Info';
import Modal from 'material-ui/Modal';
import DeleteForever from 'material-ui-icons/DeleteForever';
import IconButton from 'material-ui/IconButton';
import VideoDetail from './VideoDetail';
import { withStyles } from 'material-ui/styles';
import { getClient } from '../../lib/vhsclient';
import * as settings from '../../lib/settings';

const styles = {
  card: {
    '&:hover $playArrow': {
      visibility: "visible",
    },
    '&:hover $jsbutton': {
      visibility: "visible",
    },
    margin: 15,
    overflow: 'hidden',
    position: "relative",
    width: 360,
  },
  content: {
    position: "relative",
  },
  media: {
    '&:hover': {
      cursor: "pointer",
    },
    minHeight: "12vw",
    position: "relative",
    display: "flex",
    justifyContent: "center",
    alignItems: "center",
  },
  playArrow: {
    visibility: "hidden",
    position: "absolute",
    height: 64,
    width: 64,
    opacity: 0.75,
    color: "#fff",
  },
  jsbutton: {
    visibility: "hidden",
    position: "absolute",
    right: 0,
    bottom: 0,
  },
}

class VideoCard extends React.Component {
  state = {
    showSource: false,
  }

  showSource = () => {
    var path = "/uploads/" + this.props.video.id;
    getClient()
      .get(path)
      .then(r => {
        this.setState({ showSource: true, upload: r.data });
      });
  }

  hideSource = () => {
    this.setState({ showSource: false });
  }

  thumbnailUrl = (v) => {
    var base = "//" + settings.getCloudFrontEndpoint() + "/";
    var thumb = v.thumbnails[0].path;
    return base + v.s3Prefix + "/" + thumb;
  }

  manifestUrl = (v) => {
    var base = "https://" + settings.getVHSEndpoint();
    var key = "/manifest/" + v.id;
    return base + key;
  }

  handlePlay = (e) => {
    this.props.onPlay(this.manifestUrl(this.props.video));
  }

  deleteVideo = (e) => {
    var path = "/videos/" + this.props.video.id;
    getClient()
      .delete(path)
      .then(() => {
        this.props.handleDelete(this.props.video.id);
      });
  }

  render() {
    const classes = this.props.classes;
    const v = this.props.video;
    return (
      <Card className={classes.card}>
        <CardMedia
          className={classes.media}
          image={this.thumbnailUrl(v)}
          title={v.id}
          onClick={this.handlePlay} >
          <PlayArrow className={classes.playArrow} />
        </CardMedia>
        <CardContent className={classes.content}>
          <Typography type="subheading" gutterBottom >{v.id}</Typography>
          <Typography noWrap type="caption">Create Time: {v.createTime}</Typography>
          <Typography noWrap type="caption">Duration: {v.duration} seconds</Typography>
          <Typography noWrap type="caption">Video Type: {v.videoType}</Typography>
          <div className={classes.jsbutton}>
            <IconButton className={classes.button} color="primary">
              <DeleteForever onClick={this.deleteVideo} />
            </IconButton>
            <IconButton className={classes.button} color="primary" onClick={this.showSource} >
              <Info />
            </IconButton>
          </div>
        </CardContent>
        <Modal
          open={this.state.showSource}
          onClose={this.hideSource}
          disableAutoFocus={true}
        >
          <VideoDetail video={v} upload={this.state.upload}/>
        </Modal>
      </Card>
    );
  }
}

export default withStyles(styles)(VideoCard);
