import React from 'react';
import Paper from 'material-ui/Paper';
import Divider from 'material-ui/Divider';
import Table, { TableBody, TableCell, TableHead, TableRow } from 'material-ui/Table';
import { withStyles } from 'material-ui/styles';
import pretty from 'pretty-time';
import bytes from 'bytes';
import TimeAgo from 'javascript-time-ago';
import en from 'javascript-time-ago/locale/en'
import * as settings from '../../lib/settings';

const styles = {
  source: {
    maxWidth: 960,
    margin: "auto",
    padding: 25,
  },
  row: {
    height: "2.5em",
  },
  head: {
    textAlign: "right",
    paddingRight: 30,
  },
}

class Cell extends React.Component {
  render() {
    return <TableCell type="body" padding="dense" style={{border: 0}} {...this.props} >{this.props.children}</TableCell>
  };
}

class VideoDetail extends React.Component {

  videoUrl = () => {
    var url = settings.getVHSEndpoint() + "/videos/" + this.props.video.id;
    return url;
  }

  cell = (head, content) => {
    const classes = this.props.classes;
    return <TableRow className={classes.row}>
      <TableCell className={classes.head} type="head">{head.toUpperCase()}</TableCell> 
      <TableCell type="body">{content}</TableCell>
    </TableRow>;
  }

  compare = (a,b) => {
    if (a.label < b.label)
      return -1;
    if (a.label > b.label)
      return 1;
    return 0;
  }

  transcodeTime = (times) => {
    var start = Date.parse(times["transcoding"]);
    var end = Date.parse(times["processed"]);
    var duration = end - start;
    return pretty(duration*1000000, 's');
  }

  createTime = (times) => {
    TimeAgo.locale(en)
    const timeAgo = new TimeAgo("en-US");
    var created = Date.parse(times["created"]);
    return timeAgo.format(created);
  }

  renditions = () => {
    var rows = this.props.video.renditions.sort(this.compare).map(r => {
      var audio = r.audioCodec.substring(0,r.audioCodec.indexOf("."));
      var video = r.videoCodec.substring(0,r.videoCodec.indexOf("."));
      
      return <TableRow key={r.label} style={{height: "1.5em" }}>
        <Cell>{r.label}</Cell>
        <Cell>{r.width} x {r.height}</Cell>
        <Cell>{r.fps}</Cell>
        <Cell>{r.bitrate}</Cell>
        <Cell>{video}</Cell>
        <Cell>{audio}</Cell>
      </TableRow>;
    });

    return <Table>
      <TableHead>
        <TableRow style={{height: "1.5em"}}>
          <TableCell>LABEL</TableCell>
          <TableCell>RESOLUTION</TableCell>
          <TableCell>FPS</TableCell>
          <TableCell>BITRATE</TableCell>
          <TableCell>VIDEO</TableCell>
          <TableCell>AUDIO</TableCell>
        </TableRow>
      </TableHead>
      <TableBody>
        {rows}
      </TableBody>
    </Table>
  }

  render() {
    const classes = this.props.classes;
    const v = this.props.video;
    const u = this.props.upload;
    return (
      <Paper className={classes.source}>
        <Table>
          <TableBody>
            {this.cell("ID", v.id)}
            {this.cell("Type", v.videoType)}
            {u && this.cell("Created", this.createTime(this.props.upload.statusTimes))}
            {this.cell("Duration", pretty(v.duration*1000000000, 's'))}
            {this.cell("Transcode Time", this.transcodeTime(this.props.upload.statusTimes))}
            {u && this.cell("Source Size", bytes(u.size))}
            {this.cell("URL", this.videoUrl())}
            {this.cell("S3 Bucket", v.s3Bucket)}
            {this.cell("S3 Prefix", v.s3Prefix)}
          </TableBody>
        </Table>
        <Divider style={{marginBottom: 20}}/>
        {this.renditions()}
      </Paper>
    );
  }
}

export default withStyles(styles)(VideoDetail);
