import React from 'react';
import UniversalCard from './UniversalCard';
import Player from '../Player/Player';
import { getClient } from '../../lib/vhsclient';
import { withStyles } from 'material-ui/styles';

const styles = {
  container: {
    display: "flex",
    flexWrap: "wrap",
    padding: "50px 0",
    justifyContent: "center",
  },
}

class Videos extends React.Component {
  state = {
    videos: [],
  }

  componentDidMount() {
    this.refreshVideos();
    window.addEventListener("upload", (e) => { this.handleUpload(e.detail) });
    window.addEventListener("refresh", () => { this.refreshVideos() });
  }

  updateSource = (s) => {
    var playEvent = new CustomEvent("play", { detail: s });
    window.dispatchEvent(playEvent);
  }

  handleUpload = (f) => {
    var upload = <UniversalCard
      key={this.state.videos.length}
      file={f}
      onPlay={this.updateSource} />;
    this.setState({ videos: [upload, ...this.state.videos] });
  }

  handleVideoDelete = (videoID) => {
    this.setState({
      videos: this.state.videos.filter((v) => v.props.video.id !== videoID)
    });
  }

  refreshVideos = () => {
    getClient().get('/videos')
      .then(res => {
        var videos = res.data.videos.map(v => {
          return <UniversalCard key={v.id} video={v} onPlay={this.updateSource} handleVideoDelete={this.handleVideoDelete}/>
        });
        this.setState({videos: videos});
      });
  }

  render() {
    const classes = this.props.classes;
    return (
      <div className={classes.container}>
        <Player />
        {this.state.videos}
      </div>
    );
  }
}

export default withStyles(styles)(Videos);
