import { getClient } from './vhsclient';

var player; 
var tech;

function logTracking(e) {
  console.log("TRACKING: "+JSON.stringify(e)); 
  var path = "/stats/" + e.name;
  getClient().post(path, e.properties);
}

function initPlayer() {
  window.registerTwitchTechForVideoJs(window.videojs);
  player = window.videojs("twitch-videojs", {
    techOrder: ["TwitchWhiteLabel"]
  }, function() { console.log('Player is ready to use') });

  player.enableTwitchPlugins();
  tech = window.videojs.getPlayers()["twitch-videojs"].tech_;
  tech.addEventListener(tech.PlayerEvent.TRACKING, logTracking);
  tech.addEventListener(tech.PlayerEvent.ERROR, logTracking);
}

export function getPlayer() {
  if (player == null) {
    initPlayer();
  }
  return player;
}

export function getPlayerTech() {
  return tech;
}
