import { getClient } from './vhsclient';
import * as settings from './settings';
import AWS from 'aws-sdk';

class Uploader {
  constructor(file, updateProgress, onRefresh, onError) {
    this.file = file;
    this.client = getClient();
    this.updateProgress = updateProgress;
    this.onRefresh = onRefresh;
    this.onError = onError;
  }

  start() {
    return this.createUpload()
  }

  poll() {
    this.intervalId = setInterval(this.refresh, 3000);
  }

  createUpload() {
    return this.client
      .post('/uploads')
      .then(r => {
        this.upload = r.data.upload;
        var s3 = new AWS.S3({credentials: r.data.credentials, region: settings.getVHSRegion()});
        var regex = new RegExp("^s3://"+this.upload.s3Bucket+"/");
        var s3key = r.data.s3Uri.replace(regex, '');
        var params = {Bucket: this.upload.s3Bucket, Key: s3key, ContentType: this.file.type, Body: this.file};
        s3.upload(params)
          .on('httpUploadProgress', this.progressCallback)
          .send(this.onError);
        this.onRefresh(this.upload);
      });
  }

  refresh = () => {
    return this.client
      .get('/uploads/' + this.upload.id)
      .then(r => {
        var upload = r.data;
        var iid = this.intervalId;
        this.upload = upload;
        if (iid != null) {
          if ((upload.status === "processed") || (upload.status === "failed")) {
            clearInterval(iid);
            this.intervalId = null;
          }
        }
        this.onRefresh(upload);
      });
  }

  progressCallback = (e) => {
    var percent = e.loaded / e.total * 100;
    this.updateProgress(percent);
  }

}

export default Uploader;
