package main

import (
	"time"

	"code.justin.tv/hygienic/distconf"
)

type config struct {
	awsRegion string

	// The port that the app listens on.
	servingPort int64

	// The bucket used by autoprof to store profiles.
	autoprofBucket string

	// Number of messages to send back to client
	numMessages int

	// Delay between messages sent to client, in seconds
	messageInterval time.Duration
}

// Configuration will be read from top to bottom of the readers list.
func loadConfig(log distconf.Logger) *config {
	readers := []distconf.Reader{&distconf.Env{}}
	d := &distconf.Distconf{Logger: log, Readers: readers}
	return &config{
		// servingPort defaults to development value.
		servingPort:     d.Int("SERVING_PORT", 8080).Get(),
		autoprofBucket:  d.Str("AUTOPROF_BUCKET", "").Get(),
		awsRegion:       d.Str("AWS_REGION", "us-west-2").Get(),
		numMessages:     int(d.Int("NUM_MESSAGES", 100).Get()),
		messageInterval: time.Duration(d.Int("MESSAGE_INTERVAL_SECONDS", 20).Get()) * time.Second,
	}
}
