package protocol

// Message (with additional metadata) from GQL subs to the client
type ServiceToClientMessage struct {
	SessionID string `json:"session_id"`
	Body      string
}

type DisconnectMessage struct {
	SessionID string `json:"session_id"`
}

// Message (with additional metadata) from the client to GQL subs.
type ClientToServiceMessage struct {
	// ID of the connection that the message came from.
	SessionID string `json:"session_id"`

	// The message as it came from the client.
	Body string

	// The IP the client connected from.
	ClientIP string `json:"client_ip"`

	// The address that the connection-owning host can be reached at.
	HostAddress string `json:"host_address"`
}
