# Autogenerated by https://code.justin.tv/terraform-modules/account_template/vpccreator
# Account: twitch-websocket-edge-dev (us-west-2/nonprod), CIDR: 10.207.132.0/22, Module: git-aws.internal.justin.tv/terraform-modules/account_template.git?ref=v2.0.0
#
terraform {
  backend "s3" {
    # This bucket must be created manually before this plan will run!
    bucket  = "twitch-websocket-edge-dev"
    key     = "tfstate/account_template/nonprod-us-west-2/terraform.tfstate"
    region  = "us-west-2" # this is where the bucket that contains the state file lives.
    profile = "twitch-websocket-edge-dev"
  }
}

module "us-west-2" {
  source             = "git::git+ssh://git@git-aws.internal.justin.tv/terraform-modules/account_template.git?ref=v2.0.0"
  region             = "us-west-2"
  environment        = "nonprod"
  vpc_cidr           = "10.207.132.0/22"
  credential_profile = "twitch-websocket-edge-dev"
  account_name       = "twitch-websocket-edge-dev"
  owner              = "twitch-websocket-edge-dev@amazon.com"
}

output "us_west_2_private_subnets" {
  value = "${module.us-west-2.private_subnets}"
}

output "us_west_2_public_subnets" {
  value = "${module.us-west-2.public_subnets}"
}

output "us_west_2_twitch_subnets_sg_id" {
  value = "${module.us-west-2.twitch_subnets_sg_id}"
}

output "us_west_2_vpc_id" {
  value = "${module.us-west-2.vpc_id}"
}