locals {
  region     = "us-west-2"
  account_id = "636874578776"
  vpc_cidr   = "10.207.16.0/22"
  name       = "twitch-websocket-edge-prod"
}

provider "aws" {
  version             = "~> 2.23.0"
  region              = "${local.region}"
  allowed_account_ids = ["${local.account_id}"]
}

terraform {
  required_version = "~> 0.11"

  backend "s3" {
    bucket = "twitch-websocket-edge-prod"
    key    = "tfstate/edge/twitch-websocket-edge-prod/account/terraform.tfstate"
    region = "us-west-2"
  }
}

module "constants" {
  source = "../../modules/constants"
}

# Create the server Docker repo for this account
# Need to login? Run "aws ecr get-login --no-include-email --region us-west-2" w/ aws creds
resource "aws_ecr_repository" "main" {
  name = "websocket-edge"
}

resource "aws_ecr_repository" "load_test" {
  name = "load-test"
}

resource "aws_ecr_repository" "mock_service" {
  name = "mock-service"
}

resource "aws_ecr_lifecycle_policy" "main_lifecycle_policy" {
  repository = "${aws_ecr_repository.main.name}"
  policy     = "${module.constants.ecr_lifecycle_policy}"
}

resource "aws_ecr_lifecycle_policy" "load_test_lifecycle_policy" {
  repository = "${aws_ecr_repository.load_test.name}"
  policy     = "${module.constants.ecr_lifecycle_policy}"
}

resource "aws_ecr_lifecycle_policy" "mock_service_lifecycle_policy" {
  repository = "${aws_ecr_repository.mock_service.name}"
  policy     = "${module.constants.ecr_lifecycle_policy}"
}
