locals {
  mock_service_count                    = 0
  mock_service_instance_type            = "c5n.9xlarge"
  mock_service_image_tag                = "bcb7464" # Ignored. See module/ecs/main.tf's aws_ecs_service.main.lifecycle.ignore_changes
  mock_service_task_cpu                 = 36864
  mock_service_task_memory              = 93533 # Not using the full 94533 MiB, to save space for the ECS agent.
  mock_service_cluster_name             = "${local.cluster_name}-mock-service"
  mock_service_message_interval_seconds = 20
  mock_service_serving_port             = 80
}

# TODO (nw): figure out how to ignore this cleanly
variable "mock_service_cluster_size" {
  default = {
    min     = 0
    max     = 0
    desired = 0
  }
}

module "mock_service" {
  source = "../../modules/mock_service"

  app_name                 = "${module.constants.app_name}-mock-service"
  cluster_name             = "${local.cluster_name}-mock-service"
  task_cpu                 = local.mock_service_task_cpu
  autoprof_bucket          = module.autoprof.s3_bucket
  app_image                = "${local.account_id}.dkr.ecr.${local.region}.amazonaws.com/mock-service:${local.mock_service_image_tag}"
  task_memory              = local.mock_service_task_memory
  environment              = local.environment
  disconnect_queue_url     = "https://sqs.${local.region}.amazonaws.com/${local.account_id}/${local.disconnect_queue_name}"
  disconnect_queue_arn     = aws_sqs_queue.disconnect_queue.arn
  num_messages             = local.shared_num_messages
  message_interval_seconds = local.shared_message_interval_seconds
  serving_port             = local.mock_service_serving_port
  app_count                = local.mock_service_count
  ec2_instance_type        = local.mock_service_instance_type
  cluster_size             = var.mock_service_cluster_size
  ecs_host_iam_id          = module.core_account.container_instance_profile_id
  subnets                  = data.terraform_remote_state.base_account.outputs.us_west_2_private_subnets
  security_groups          = [data.terraform_remote_state.base_account.outputs.us_west_2_twitch_subnets_sg_id]
  ldap_hosts               = module.constants.ldap_hosts
  ssh_sudoer_ldap_group    = module.constants.ssh_sudoer_ldap_group
  owner_email              = module.constants.owner_email
  service_iam_role         = module.core_account.service_iam_role
  vpc_id                   = data.terraform_remote_state.base_account.outputs.us_west_2_vpc_id
}

