# The name of the app.
output "app_name" {
  value = "websocket-edge"
}

output "load_test_name" {
  value = "load-test"
}

# The LDAP group that should have ssh and sudo access.
output "ssh_sudoer_ldap_group" {
  value = "team-api"
}

# Us, the team that develops the websocket edge.
output "team_name" {
  value = "edge-platform"
}

# Team email.
output "owner_email" {
  value = "edge-platform@twitch.tv"
}

# The AWS region that the websocket edge runs in.
output "region" {
  value = "us-west-2"
}

output "ldap_hosts" {
  value = {
    // TODO: set up dev LDAP
    twitch-websocket-edge-dev  = "ldap-websocket-edge-dev.internal.justin.tv"
    twitch-websocket-edge-prod = "ldap-websocket-edge-prod.internal.justin.tv"
  }
}

output "ecr_lifecycle_policy" {
  value = <<EOF
{
    "rules": [
        {
            "rulePriority": 1,
            "description": "Keep last 400 images, of any age, out of a max of 1000",
            "selection": {
                "tagStatus": "any",
                "countType": "imageCountMoreThan",
                "countNumber": 400
            },
            "action": {
                "type": "expire"
            }
        }
    ]
}
EOF
}

output "gql_subs_url_prod" {
  value = "http://internal-gql-subs-prod-546037423.us-west-2.elb.amazonaws.com"
}

output "gql_subs_url_dev" {
  value = "http://internal-websocket-edge-dev-mock-service-1484585785.us-west-2.elb.amazonaws.com"
}

output "dev_gqlsubs_task_role" {
  value = "arn:aws:iam::645130450452:role/ecs_task_role_gql-subs-staging"
}

output "dev_gqlsubs_account_role" {
  value = "arn:aws:iam::645130450452:root"
}

output "prod_gqlsubs_task_role" {
  value = "arn:aws:iam::787149559823:role/ecs_task_role_gql-subs-prod"
}

output "prod_gqlsubs_account_role" {
  value = "arn:aws:iam::787149559823:root"
}

output "prod_gql_subs_disconnect_queue_arn" {
  value = "arn:aws:sqs:*:787149559823:gql-subs-disconnection"
}

output "prod_gql_subs_disconnect_queue_url" {
  value = "https://sqs.us-west-2.amazonaws.com/787149559823/gql-subs-disconnection"
}
