# ECS Module Input Variables

# ECS Cluster Settings

variable "ec2_instance_type" {
  description = "Type of EC2 instance."
  type        = string
}

variable "cluster_size" {
  description = "The min, max, and desired number of EC2 instances to run."
  type        = map(string)
}

variable "app_count" {
  description = "Number of docker containers to run."
  type        = number
}

variable "ami" {
  description = "An ECS enabled AMI that these ASG hosts should run with.  If empty, will use the most recent AMI"
  type        = string
  default     = ""
}

variable "network_mode" {
  default     = "bridge"
  description = "The network mode used for the ECS tasks."
}

# dnsmasq settings

variable "dns_servers" {
  description = <<EOF
ONLY set this if you are NOT using the `twitch_dns_route53_resolver` module.

DNS servers for resolving twitch.tv and justin.tv domains.
If provided, allows dnsmasq to act as a DNS forwarder.
Find yours here: https://wiki.twitch.com/display/SYS/What+DNS+servers+should+be+used
EOF

  type    = list(string)
  default = []
}

# AWS security / role settings

variable "ecs_host_iam_id" {
  description = "The IAM role to use for the ECS host's instance profile."
  type        = string
}

variable "ldap_hosts" {
  description = "A map from AWS account alias to the LDAP host that should be used for ssh auth."
  type        = map(string)
}

variable "ssh_sudoer_ldap_group" {
  description = "Members of this LDAP group may sudo when ssh'd into the EC2 instances."
  type        = string
}

variable "service_iam_role" {
  description = "The ARN of the IAM role for the ECS service."
  type        = string
}

variable "ecs_task_role" {
  description = "The ARN of the ECS task role that allows the app to call other AWS services."
  type        = string
}

# General app/cluster settings

variable "app_name" {
  description = "The name of the application."
  type        = string
}

variable "cluster_name" {
  description = "The name of this ECS cluster."
  type        = string
}

variable "environment" {
  description = "Keep canary vs production resources separate with an environment name."
  type        = string
}

variable "owner_email" {
  description = "The email of the owning group, tagged in the ASG."
  type        = string
}

variable "app_port" {
  description = "The port that the application listens on for requests."
  type        = string
}

variable "container_definitions" {
  description = "The JSON document of container definitions for the containers that make up the ECS task."
  type        = string
}

# ECS container agent settings

variable "task_cleanup_wait_duration" {
  description = "Time duration to wait from when an ECS task is stopped until the Docker container is removed."
  type        = string
  default     = "30m"
}

variable "task_shutdown_wait_duration" {
  description = "Time duration to wait from when an ECS task is given a SIGTERM to when it is forcefully killed."
  type        = string
  default     = "30s"
}

# Default settings - no need to override

variable "team_name" {
  description = "The name of the team owning these resources."
  type        = string
  default     = "edge-platform"
}

variable "log_retention_days" {
  description = "The number of days to retain CloudWatch logs."
  type        = number
  default     = 30
}

# LB settings

variable "target_group_id" {
  description = "The target group that the ECS service should join."
  type        = string
}

variable "security_groups" {
  description = "The security groups that should be applied to the instances."
  type        = "list"
}

variable "subnets" {
  description = "The subnets the ASG should spin up instances in."
  type        = "list"
}
