# ECS Module
# Uses the "ecsasg" module in git-aws.internal.justin.tv/twitch/terraform to set up the
# ec2 auto-scaling group for ECS. The actual ECS cluster is created here.
#

# TODO: Replace this copy-pasted module with the actual edge/terraform module.  Before doing that we need to put in a PR to accept subnets/securitygroup/vpc(instead of using twitch_networking module).

data "aws_iam_account_alias" "current" {}
data "aws_caller_identity" "current" {}

### Logging

resource "aws_iam_role_policy_attachment" "allow_send_access_logs_policy" {
  role       = var.ecs_host_iam_id
  policy_arn = "arn:aws:iam::aws:policy/AWSOpsWorksCloudWatchLogs"
}

resource "aws_cloudwatch_log_group" "load_test_ecs_agent_logs" {
  name              = "${var.cluster_name}-ecs-agent-logs"
  retention_in_days = var.log_retention_days

  tags = {
    app     = var.app_name
    cluster = var.cluster_name
    env     = var.environment
  }
}

resource "aws_cloudwatch_log_group" "load_test_ecs_init_logs" {
  name              = "${var.cluster_name}-ecs-init-logs"
  retention_in_days = var.log_retention_days

  tags = {
    app     = var.app_name
    cluster = var.cluster_name
    env     = var.environment
  }
}

resource "aws_cloudwatch_log_group" "load_test_ssm_logs" {
  name              = "${var.cluster_name}-ssm-ec2-logs"
  retention_in_days = var.log_retention_days

  tags = {
    app     = var.app_name
    cluster = var.cluster_name
    env     = var.environment
  }
}

### Cluster ASG

# Set the internal LDAP host for EC2 ssh auth based on the current account
locals {
  acct             = data.aws_iam_account_alias.current.account_alias
  custom_ldap_host = "${lookup(var.ldap_hosts, local.acct)}"
}

# Define how our upcoming ECS cluster will get autoscaled & how the cluster's EC2's are deployed and configured
# Note: installs LDAP-AUTH on the ec2's pointing to our special LDAP hosts

### ECS Cluster

resource "aws_ecs_cluster" "main" {
  name = var.cluster_name
}

### ECS Service

resource "aws_iam_role" "ecs_load_test_task_execution_role" {
  name = "ecs_load_test_task_execution_${var.environment}"

  assume_role_policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Sid": "",
      "Effect": "Allow",
      "Principal": {
        "Service": "ecs-tasks.amazonaws.com"
      },
      "Action": "sts:AssumeRole"
    }
  ]
}
EOF
}

resource "aws_iam_role_policy_attachment" "ecs_load_test_task_execution_role" {
  role       = aws_iam_role.ecs_load_test_task_execution_role.id
  policy_arn = "arn:aws:iam::aws:policy/service-role/AmazonECSTaskExecutionRolePolicy"
}

resource "aws_ecs_task_definition" "app" {
  family                   = var.cluster_name
  network_mode             = "awsvpc"
  execution_role_arn       = aws_iam_role.ecs_load_test_task_execution_role.arn
  task_role_arn            = var.ecs_task_role
  container_definitions    = var.container_definitions
  requires_compatibilities = ["FARGATE"]

  # todo nw constant these here and in json filecpu = 256
  cpu    = 4096
  memory = 8192

  # has a cluster vpc (10.0.0.0/16)
  # has subnets (10.0.0.0/24)
  # has security groups
  lifecycle {
    ignore_changes = ["container_definitions"]
  }
}

resource "aws_ecs_service" "main" {
  name            = var.cluster_name
  cluster         = aws_ecs_cluster.main.id
  task_definition = aws_ecs_task_definition.app.arn
  desired_count   = var.app_count

  # iam_role        = "${var.service_iam_role}"
  launch_type = "FARGATE"

  network_configuration {
    subnets = var.subnets
  }

  lifecycle {
    ignore_changes = ["task_definition"]
  }
}
