provider "template" {
  version = "2.1.2"
}

terraform {
  required_version = ">= 0.12"
}

locals {
  task_definition = templatefile("${path.module}/load-test.json", {
    # Load Test container definition configuration
    app_image    = var.app_image
    cluster_name = var.cluster_name
    log_group    = aws_cloudwatch_log_group.load_test_logs.name
    region       = var.region
    task_cpu     = var.task_cpu
    task_memory  = var.task_memory

    # Load Test app configuration
    environment                   = var.environment
    autoprof_bucket               = var.autoprof_bucket
    max_users                     = var.max_users
    subscription_interval_seconds = var.subscription_interval_seconds
    user_interval_milliseconds    = var.user_interval_milliseconds
    num_messages                  = var.num_messages
    message_interval_seconds      = var.message_interval_seconds
  })
}

resource "aws_cloudwatch_log_group" "load_test_logs" {
  name              = "${var.cluster_name}-logs"
  retention_in_days = var.log_retention_days

  tags = {
    app = var.app_name
    env = var.environment
  }
}
