resource "aws_alb" "mock_service" {
  name            = var.cluster_name
  internal        = true
  subnets         = var.subnets
  security_groups = var.security_groups

  enable_deletion_protection = true
}

resource "aws_alb_target_group" "mock_service" {
  name     = var.cluster_name
  protocol = "HTTP"
  vpc_id   = var.vpc_id

  # The port is required, but overriden by ECS. Using a placeholder here.
  port = "1"

  health_check {
    protocol            = "HTTP"
    path                = "/health"
    healthy_threshold   = 3   # checks resulting in success
    unhealthy_threshold = 2   # checks resulting in failure
    timeout             = 2   # seconds
    interval            = 5   # seconds
    matcher             = 200 # status code
  }
}

resource "aws_alb_listener" "http" {
  load_balancer_arn = aws_alb.mock_service.id
  port              = "80"
  protocol          = "HTTP"

  default_action {
    type             = "forward"
    target_group_arn = aws_alb_target_group.mock_service.arn
  }
}
