module "ecs" {
  source = "../ecs"

  app_name              = var.app_name
  network_mode          = "host"
  cluster_name          = var.cluster_name
  environment           = var.environment
  app_count             = var.app_count
  ec2_instance_type     = var.ec2_instance_type
  cluster_size          = var.cluster_size
  ecs_host_iam_id       = var.ecs_host_iam_id
  target_group_id       = aws_alb_target_group.mock_service.id
  app_port              = local.app_port
  container_definitions = local.task_definition
  ecs_task_role         = aws_iam_role.ecs_task_role.arn
  ldap_hosts            = var.ldap_hosts
  ssh_sudoer_ldap_group = var.ssh_sudoer_ldap_group
  owner_email           = var.owner_email
  service_iam_role      = var.service_iam_role
  subnets               = var.subnets
  security_groups       = var.security_groups
}
