provider "template" {
  version = "2.1.2"
}

terraform {
  required_version = ">= 0.12"
}

locals {
  app_port = 80
}

# To have container definition changes get picked up by Terraform do: `terraform taint -module=mock_service.ecs aws_ecs_task_definition.app`
# Make sure an older image isn't being published, though!
locals {
  task_definition = templatefile("${path.module}/mock-service.json", {
    # HTTP Receiver Test container definition configuration
    app_image    = var.app_image
    cluster_name = var.cluster_name
    log_group    = aws_cloudwatch_log_group.http_receiver_logs.name
    region       = var.region
    task_cpu     = var.task_cpu
    task_memory  = var.task_memory
    app_port     = local.app_port

    # app configuration
    environment              = var.environment
    sqs_queue_url            = var.disconnect_queue_url
    autoprof_bucket          = var.autoprof_bucket
    serving_port             = var.serving_port
    num_messages             = var.num_messages
    message_interval_seconds = var.message_interval_seconds
  })
}


resource "aws_cloudwatch_log_group" "http_receiver_logs" {
  name              = "${var.cluster_name}-logs"
  retention_in_days = var.log_retention_days

  tags = {
    app = var.app_name
    env = var.environment
  }
}
