package main

import (
	"code.justin.tv/hygienic/distconf"
)

type config struct {
	awsRegion string

	// The port that the app listens on.
	servingPort int64

	// The URL of the queue we're using for disconnect events.
	sqsQueueURL string

	// The bucket used by autoprof to store profiles.
	autoprofBucket string

	// URL of GQL Subs. Inbound WS traffic is forwarded to this URL.
	gqlSubsURL string
}

// Configuration will be read from top to bottom of the readers list.
func loadConfig(log distconf.Logger) *config {
	readers := []distconf.Reader{&distconf.Env{}}
	d := &distconf.Distconf{Logger: log, Readers: readers}
	return &config{
		// servingPort defaults to development value.
		servingPort:    d.Int("SERVING_PORT", 9000).Get(),
		sqsQueueURL:    d.Str("SQS_QUEUE_URL", "").Get(),
		awsRegion:      d.Str("AWS_REGION", "us-west-2").Get(),
		autoprofBucket: d.Str("AUTOPROF_BUCKET", "").Get(),
		gqlSubsURL:     d.Str("GQL_SUBS_URL", "").Get(),
	}
}
