package metrics

import (
	"time"

	telemetry "code.justin.tv/amzn/TwitchTelemetry"
	telemetryPoller "code.justin.tv/amzn/TwitchTelemetryPollingCollector"
)

type poller struct {
	metricName string
	valueFn    func() float64
}

func (m poller) Fetch() ([]*telemetry.Sample, error) {
	samples := make([]*telemetry.Sample, 1)

	value := m.valueFn()

	samples[0] = &telemetry.Sample{
		MetricID: *telemetry.NewMetricID(m.metricName),
		Value:    value,
		Unit:     telemetry.UnitCount,
	}

	return samples, nil
}

func (s *statter) StartPoller(metricName string, valueFn func() float64, interval time.Duration) {
	job := poller{
		metricName: metricName,
		valueFn:    valueFn,
	}
	pc := telemetryPoller.NewPollingCollector(job, interval, s.sampleBuilder, s.observer, s.logger)
	pc.Start()
}
