package wsconnection

import (
	"net/http"
	"time"

	"github.com/gorilla/websocket"
)

// TODO: unexport this, and rename to wsconn or something to disambiguate from service-level connection type.
type Conn interface {
	Close() error
	WriteControl(messageType int, data []byte, deadline time.Time) error
	SetReadLimit(limit int64)
	SetReadDeadline(t time.Time) error
	SetPongHandler(h func(appData string) error)
	ReadMessage() (messageType int, p []byte, err error)
	SetWriteDeadline(t time.Time) error
	WriteMessage(messageType int, data []byte) error
}

type Upgrader interface {
	Upgrade(w http.ResponseWriter, r *http.Request, responseHeader http.Header) (Conn, error)
}

type Uwrapper struct {
	Upgrader *websocket.Upgrader
}

func (u Uwrapper) Upgrade(w http.ResponseWriter, r *http.Request, responseHeader http.Header) (Conn, error) {
	return u.Upgrader.Upgrade(w, r, responseHeader)
}
