package loadtestenv

import (
	"fmt"
	"math/rand"
	"time"

	"code.justin.tv/websocket-edge/server/internal/environment"
)

func WebsocketEdgeAddress() string {
	if environment.IsProd() {
		return "ws.internal.justin.tv"
	} else if environment.IsDev() {
		return "dev.websocket-edge.twitch.a2z.com"
	}

	// "load balance" between our 2 local servers.
	rand.Seed(time.Now().UnixNano())
	port := "9000"
	n := rand.Intn(2)
	if n == 0 {
		return fmt.Sprintf("server:%s", port)
	} else {
		return fmt.Sprintf("server2:%s", port)
	}
}

func ForwardAddress(hostIP string) string {
	// TODO (nw): pass in ports via environment variables
	if environment.IsLocal() {
		return fmt.Sprintf("http://%s:9000/v1/send", hostIP)
	} else {
		return fmt.Sprintf("http://%s:80/v1/send", hostIP)
	}
}

func WSScheme() string {
	if environment.IsLocal() {
		return "ws"
	} else {
		return "wss"
	}
}
