variable "subnets" {
  description = "The subnets this LB should use."
  type        = "list"
}

variable "domain_name" {
  description = "Domain name the ACM certificate uses."
}

variable "security_groups" {
  description = "The security groups to apply to the LB."
  type        = "list"
}

variable "slow_start_seconds" {
  default = 0

  description = <<EOD
  The time period during which the load balancer sends a newly registered target
  a linearly increasing share of the traffic to the target group.
  The range is 30-900 seconds. The default is 0 seconds (disabled).
EOD
}

variable "vpc_id" {
  description = "ID of the VPC this LB should join."
}

variable "cluster_name" {
  description = "The name of the LB. Also used to tag the ACM cert."
}

variable "app_name" {
  description = "The name of the app. Used to tag the ACM cert."
}

variable "environment" {
  description = "The name of the environment. Usxed to tag the ACM cert."
}

variable "logs_bucket" {
  description = "Which S3 bucket to store access logs in."
}

# TODO: Take in alarm settings & use them.

