terraform {
  required_version = ">= 0.12"
}

# ECS Cluster Settings

variable "app_count" {
  description = "Number of docker containers to run."
}

variable "ami" {
  default     = ""
  description = "An ECS enabled AMI that these ASG hosts should run with.  If empty, will use the most recent AMI"
}

# dnsmasq settings

variable "dns_servers" {
  description = <<EOF
ONLY set this if you are NOT using the `twitch_dns_route53_resolver` module.

DNS servers for resolving twitch.tv and justin.tv domains.
If provided, allows dnsmasq to act as a DNS forwarder.
Find yours here: https://wiki.twitch.com/display/SYS/What+DNS+servers+should+be+used
EOF

  type    = "list"
  default = []
}

# AWS security / role settings

variable "ecs_host_iam_id" {
  description = "The IAM role to use for the ECS host's instance profile. Should be created by the core_account module in twitch/terraform."
}

variable "ldap_hosts" {
  description = "A map from AWS account alias to the LDAP host that should be used for ssh auth."
  type        = "map"
}

variable "ssh_sudoer_ldap_group" {
  description = "Members of this LDAP group may sudo when ssh'd into the EC2 instances."
}

variable "service_iam_role" {
  description = "The ARN of the IAM role for the ECS service."
}

variable "ecs_task_role" {
  description = "The ARN of the ECS task role that allows the app to call other AWS services."
}

# General app/cluster settings

variable "app_name" {
  description = "The name of the application."
}

variable "cluster_name" {
  description = "The name of this ECS cluster."
}

variable "environment" {
  description = "TODO (nw): fix this description"
}

variable "owner_email" {
  description = "The email of the owning group, tagged in the ASG."
}

variable "container_definitions" {
  description = "The JSON document of container definitions for the containers that make up the ECS task."
}

# ECS container agent settings

variable "task_cleanup_wait_duration" {
  description = "Time duration to wait from when an ECS task is stopped until the Docker container is removed."
  default     = "30m"
}

# Default settings - no need to override

variable "team_name" {
  description = "The name of the team owning these resources."
  default     = "edge-platform"
}

variable "log_retention_days" {
  description = "The number of days to retain CloudWatch logs."
  default     = 30
}

variable "subnets" {
  description = "The subnets the ASG should spin up instances in."
  type        = "list"
}
