variable "app_name" {
  description = "The name of the application"
}

variable "cluster_name" {
  description = "The name of this ECS cluster"
}

variable "environment" {
  description = "TODO (nw): description for environment goes here"
}

variable "max_users" {
  description = "Number of users for the load test to simulate"
}

variable "subscription_interval_seconds" {
  description = "Interval at which each loadtest user should simulate a subscription request"
}

variable "user_interval_milliseconds" {
  description = "Interval between creation of each load test user"
}

variable "num_messages" {
  description = "Number of messages each user will receive from GQL subs"
}

variable "message_interval_seconds" {
  description = "Interval between each message sent from GQL subs"
}

variable "task_memory" {
  description = "The soft limit of memory (in MiB) to reserve for the Docker container"
}

variable "task_cpu" {
  description = "The number of CPU units to reserve for the Docker container (1 vCPU = 1024 CPU units)"
}

variable "region" {
  description = "The AWS region to create things in."
  default     = "us-west-2"
}

variable "app_image" {
  description = "Docker WebSocket Edge image to run in the ECS cluster"
}

variable "log_retention_days" {
  description = "The number of days to retain CloudWatch logs."
  default     = 30
}

variable "autoprof_bucket" {
  description = "The bucket used to store autoprof profiles."
}
