variable "app_name" {
  description = "The name of the application"
}

variable "cluster_name" {
  description = "The name of this ECS cluster"
}

variable "environment" {
  description = "The name of the environment that this module is being invoked from."
}

variable "num_messages" {
  description = "Number of messages to send to each loadtest client"
}

variable "message_interval_seconds" {
  description = "Interval between each message sent to the loadtest client"
}

variable "serving_port" {
  description = "The port that inbound requests will be received on"
}

variable "task_memory" {
  description = "The soft limit of memory (in MiB) to reserve for the Docker container"
}

variable "task_cpu" {
  description = "The number of CPU units to reserve for the Docker container (1 vCPU = 1024 CPU units)"
}

variable "region" {
  description = "The AWS region to create things in."
  default     = "us-west-2"
}

variable "app_image" {
  description = "Docker image to run in the ECS cluster"
}

variable "log_retention_days" {
  description = "The number of days to retain CloudWatch logs."
  default     = 30
}

variable "autoprof_bucket" {
  description = "The bucket used to store autoprof profiles."
}

# ECS Module Input Variables

# ECS Cluster Settings

variable "ec2_instance_type" {
  description = "Type of EC2 instance."
}

variable "cluster_size" {
  description = "The min, max, and desired number of EC2 instances to run."
  type        = "map"
}

variable "app_count" {
  description = "Number of docker containers to run."
}

variable "ami" {
  default     = ""
  description = "An ECS enabled AMI that these ASG hosts should run with.  If empty, will use the most recent AMI"
}

# AWS security / role settings

variable "ecs_host_iam_id" {
  description = "The IAM role to use for the ECS host's instance profile. Should be created by the core_account module in twitch/terraform."
}

variable "ldap_hosts" {
  description = "A map from AWS account alias to the LDAP host that should be used for ssh auth."
  type        = "map"
}

variable "ssh_sudoer_ldap_group" {
  description = "Members of this LDAP group may sudo when ssh'd into the EC2 instances."
}

variable "service_iam_role" {
  description = "The ARN of the IAM role for the ECS service."
}

variable "owner_email" {
  description = "The email of the owning group, tagged in the ASG."
}

# ECS container agent settings

variable "task_cleanup_wait_duration" {
  description = "Time duration to wait from when an ECS task is stopped until the Docker container is removed."
  default     = "30m"
}

# Default settings - no need to override

variable "team_name" {
  description = "The name of the team owning these resources."
  default     = "edge-platform"
}

# LB settings

variable "security_groups" {
  description = "The security groups that should be applied to the instances."
  type        = "list"
}

variable "subnets" {
  description = "The subnets the ASG should spin up instances in."
  type        = "list"
}

variable "disconnect_queue_url" {
  description = "The URL of the SQS queue used for disconnect events."
}

variable "disconnect_queue_arn" {
  description = "The ARN of the SQS queue used for disconnect events."
}

variable "vpc_id" {
  description = "ID of the VPC this service will operate in."
}
