locals {
  pagerduty_keys = {
    prod = {
      high_urgency = "5565b3f6875f4012a65853e45cbf276b" # https://twitchoncall.pagerduty.com/services/PDAD2TF
      low_urgency  = "0e512f320b7340499d2f1131094990b9" # https://twitchoncall.pagerduty.com/services/POULZTU
    }

    dev = {
      high_urgency = "df98885564954ca693b64339d5c6698f" # https://twitchoncall.pagerduty.com/services/P9YK13F
      low_urgency  = "990e65067db74744914cd87b864ba769" # https://twitchoncall.pagerduty.com/services/PVSOY1C
    }
  }
}

resource "aws_sns_topic" "pd_high_urgency" {
  name         = "websocket-edge-alarms-high-urgency-${var.environment}"
  display_name = "websocket-edge-alarms-high-urgency-${var.environment}"
}

resource "aws_sns_topic_subscription" "high" {
  protocol               = "https"
  endpoint_auto_confirms = true
  endpoint               = "https://events.pagerduty.com/integration/${lookup(local.pagerduty_keys["${var.environment}"], "high_urgency")}/enqueue"
  topic_arn              = aws_sns_topic.pd_high_urgency.arn
}

resource "aws_sns_topic" "pd_low_urgency" {
  name         = "websocket-edge-alarms-low-urgency-${var.environment}"
  display_name = "websocket-edge-alarms-low-urgency-${var.environment}"
}

resource "aws_sns_topic_subscription" "low" {
  protocol               = "https"
  endpoint_auto_confirms = true
  endpoint               = "https://events.pagerduty.com/integration/${lookup(local.pagerduty_keys["${var.environment}"], "low_urgency")}/enqueue"
  topic_arn              = aws_sns_topic.pd_low_urgency.arn
}
