locals {
  namespace                         = "websocket-edge/logs"
  max_warnings                      = 500
  max_errors                        = 10
  # TODO (nw): figure out how to add alarms around unhealthy hosts
  max_unhealthy_hosts               = 2
  max_p99_latency                   = 0.5             #seconds
  high_priority_period              = 180             #minutes
  high_priority_datapoints_to_alarm = 3

	metric_names = {
		error   = "ErrorsCount"
		warning = "WarningsCount"
	}
}

module "pagerduty" {
  source = "../pagerduty"

  environment = var.environment
}

resource "aws_cloudwatch_log_metric_filter" "websocket_edge_warnings" {
  log_group_name = aws_cloudwatch_log_group.app_logs.name
  name           = "websocket-edge-warning-${var.environment}"
  pattern        = "{$.level = \"warning\"}"

  metric_transformation {
    name      = local.metric_names.warning
    namespace = local.namespace
    value     = "1"
  }
}

resource "aws_cloudwatch_log_metric_filter" "websocket_edge_errors" {
  log_group_name = aws_cloudwatch_log_group.app_logs.name
  name           = "websocket-edge-errors-${var.environment}"
  pattern        = "{$.level = \"error\" || $.level = \"fatal\" || $.level = \"panic\"}"

  metric_transformation {
    name      = local.metric_names.error
    namespace = local.namespace
    value     = "1"
  }
}

resource "aws_cloudwatch_metric_alarm" "websocket_edge_warnings_alarm" {
  alarm_actions       = ["${module.pagerduty.pd_low_urgency_arn}"]
  alarm_name          = aws_cloudwatch_log_metric_filter.websocket_edge_warnings.name
  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods  = 3
  metric_name         = local.metric_names.warning
  namespace           = local.namespace
  ok_actions          = ["${module.pagerduty.pd_low_urgency_arn}"]
  period              = 60
  statistic           = "Sum"
  threshold           = local.max_warnings
}

resource "aws_cloudwatch_metric_alarm" "websocket_edge_errors_alarm" {
  alarm_actions       = ["${module.pagerduty.pd_high_urgency_arn}"]
  alarm_name          = aws_cloudwatch_log_metric_filter.websocket_edge_errors.name
  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods  = 3
  metric_name         = local.metric_names.error
  namespace           = local.namespace
  ok_actions          = ["${module.pagerduty.pd_high_urgency_arn}"]
  period              = 60
  statistic           = "Sum"
  threshold           = local.max_errors
}

resource "aws_cloudwatch_metric_alarm" "unhealthy_hosts" {
  alarm_actions       = ["${module.pagerduty.pd_high_urgency_arn}"]
  alarm_name          = "${var.cluster_name}-unhealthy-hosts"
  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods  = 1
  metric_name         = "UnHealthyHostCount"
  namespace           = "AWS/ApplicationELB"
  ok_actions          = ["${module.pagerduty.pd_high_urgency_arn}"]
  period              = 60
  statistic           = "Sum"
  threshold           = local.max_unhealthy_hosts

  dimensions = {
    TargetGroup = var.target_group_arn_suffix
    LoadBalancer = var.load_balancer_arn_suffix
  }
}
