resource "aws_iam_role" "ecs_task_role" {
  name = "ecs_task_role_${var.environment}"

  assume_role_policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Sid": "",
      "Effect": "Allow",
      "Principal": {
        "Service": "ecs-tasks.amazonaws.com"
      },
      "Action": "sts:AssumeRole"
    }
  ]
}
EOF
}

resource "aws_iam_policy" "cloudwatch_policy" {
  name        = "cloudwatch_put_metricdata_policy"
  description = "Allows PutMetricData access to Cloudwatdch."

  policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Effect": "Allow",
      "Action": [
        "cloudwatch:PutMetricData"
      ],
      "Resource": "*"
    }
  ]
}
EOF
}


resource "aws_iam_role_policy_attachment" "cloudwatch_role_attachment" {
  role       = aws_iam_role.ecs_task_role.id
  policy_arn = aws_iam_policy.cloudwatch_policy.arn
}

resource "aws_iam_policy" "sqs_policy" {
  name        = "sqs_disconnect_queue_policy"
  description = "Allows sending messages to the SQS disconnect queue."

  policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Effect": "Allow",
      "Action": [
        "sqs:SendMessage"
      ],
      "Resource": "${var.disconnect_queue_arn}"
    }
  ]
}
EOF
}

resource "aws_iam_role_policy_attachment" "sqs_role_attachment" {
  role       = aws_iam_role.ecs_task_role.id
  policy_arn = aws_iam_policy.sqs_policy.arn
}

resource "aws_iam_policy" "autoprof_writer" {
  name        = "autoprof_writer"
  description = "Allows writing to the autoprof bucket."

  policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Effect": "Allow",
      "Action": [
        "s3:PutObject"
      ],
      "Resource": "arn:aws:s3:::${var.autoprof_bucket}/*"
    }
  ]
}
EOF
}

resource "aws_iam_role_policy_attachment" "s3_role" {
  role       = aws_iam_role.ecs_task_role.id
  policy_arn = aws_iam_policy.autoprof_writer.arn
}
