provider "template" {
  version = "2.1.2"
}

terraform {
  required_version = ">= 0.12"
}

locals {
  // To change this do a `terraform taint module.ecs.aws_ecs_task_definition.app`
  task_definition = templatefile("${path.module}/websocket-edge.json", {
    # WebSocket Edge container definition configuration
    app_image    = var.app_image
    app_port     = var.app_port
    cluster_name = var.cluster_name
    log_group    = aws_cloudwatch_log_group.app_logs.name
    region       = var.region
    task_cpu     = var.task_cpu
    task_memory  = var.task_memory

    # WebSocket Edge app configuration
    environment     = var.environment
    serving_port    = var.serving_port
    sqs_queue_url   = var.disconnect_queue_url
    autoprof_bucket = var.autoprof_bucket
    gql_subs_url    = var.gql_subs_url
  })
}

resource "aws_cloudwatch_log_group" "app_logs" {
  name              = "${var.cluster_name}-logs"
  retention_in_days = var.log_retention_days

  tags = {
    app = var.app_name
    env = var.environment
  }
}
