variable "app_name" {
  description = "The name of the application"
}

variable "cluster_name" {
  description = "The name of this ECS cluster"
}

variable "environment" {
  description = "Keep canary vs production resources separate with an environment name"
}

variable "task_memory" {
  description = "The soft limit of memory (in MiB) to reserve for the Docker container"
}

variable "task_cpu" {
  description = "The number of CPU units to reserve for the Docker container (1 vCPU = 1024 CPU units)"
}

variable "region" {
  description = "The AWS region to create things in."
  default     = "us-west-2"
}

variable "app_image" {
  description = "Docker WebSocket Edge image to run in the ECS cluster"
}

variable "app_port" {
  description = "Port exposed by the docker image to redirect traffic to"
  default     = 80
}

variable "log_retention_days" {
  description = "The number of days to retain CloudWatch logs."
  default     = 30
}

variable "serving_port" {
  description = "The port the server will listen on."
  default     = 80
}

variable "disconnect_queue_url" {
  description = "The URL of the SQS queue used for disconnect events."
}

variable "disconnect_queue_arn" {
  description = "The ARN of the SQS queue used for disconnect events."
}

variable "autoprof_bucket" {
  description = "The ARN of the bucket used for autoprof profiles."
}

variable "gql_subs_url" {
  description = "The base URL for GraphQL Subsriptions. Used for forwarding incoming WS messages."
}

variable "target_group_id" {
  description = "The target group id for the websocket edge ALB"
}

variable "target_group_arn_suffix" {
  description = "The target group arn suffix for the websocket edge ALB"
}

variable "load_balancer_arn_suffix" {
  description = "The ALB arn suffix for the websocket edge"
}
