/*
 * Decompiled with CFR 0.152.
 */
package com.ganji.tungsten.replicator.applier;

import com.continuent.tungsten.replicator.ReplicatorException;
import com.continuent.tungsten.replicator.applier.RawApplier;
import com.continuent.tungsten.replicator.database.Table;
import com.continuent.tungsten.replicator.database.TableMetadataCache;
import com.continuent.tungsten.replicator.dbms.DBMSData;
import com.continuent.tungsten.replicator.dbms.LoadDataFileFragment;
import com.continuent.tungsten.replicator.dbms.OneRowChange;
import com.continuent.tungsten.replicator.dbms.RowChangeData;
import com.continuent.tungsten.replicator.dbms.RowIdData;
import com.continuent.tungsten.replicator.dbms.StatementData;
import com.continuent.tungsten.replicator.event.DBMSEvent;
import com.continuent.tungsten.replicator.event.ReplDBMSHeader;
import com.continuent.tungsten.replicator.event.ReplDBMSHeaderData;
import com.continuent.tungsten.replicator.plugin.PluginContext;
import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.Mongo;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialException;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;

public class MongoApplier
implements RawApplier {
    private static Logger logger = Logger.getLogger(MongoApplier.class);
    private int taskId;
    private String serviceSchema;
    private ReplDBMSHeader latestHeader;
    private String connectString = null;
    private boolean autoIndex = false;
    private Mongo m;
    private TableMetadataCache tableMetadataCache;

    public void setConnectString(String connectString) {
        this.connectString = connectString;
    }

    public void setAutoIndex(boolean autoIndex) {
        this.autoIndex = autoIndex;
    }

    public void apply(DBMSEvent event, ReplDBMSHeader header, boolean doCommit, boolean doRollback) throws ReplicatorException, InterruptedException {
        ArrayList dbmsDataValues = event.getData();
        for (DBMSData dbmsData : dbmsDataValues) {
            if (dbmsData instanceof StatementData) {
                if (!logger.isDebugEnabled()) continue;
                logger.error((Object)"Ignoring statement");
                continue;
            }
            if (dbmsData instanceof RowChangeData) {
                RowChangeData rd = (RowChangeData)dbmsData;
                for (OneRowChange orc : rd.getRowChanges()) {
                    RowChangeData.ActionType action = orc.getAction();
                    String table = orc.getTableName();
                    if (table.equals("user_friends")) {
                        table = "userFriends";
                    }
                    if (table.equals("userFriends")) {
                        this.changeUserFriends(action, orc);
                        continue;
                    }
                    if (table.equals("users_rel_premier")) {
                        this.changeExpectation(action, orc);
                        continue;
                    }
                    if (table.equals("user_social")) {
                        this.changeUserSocial(action, orc);
                        continue;
                    }
                    if (table.equals("user_last_visit")) {
                        this.changeUserLastVisit(action, orc);
                        continue;
                    }
                    if (table.equals("shop_user")) {
                        this.changeUserProfile(action, orc);
                        continue;
                    }
                    if (table.equals("subscribe")) {
                        this.changePersonSubscription(action, orc);
                        continue;
                    }
                    if (table.equals("forum")) {
                        try {
                            this.changeFilmReview(action, orc);
                        }
                        catch (SerialException e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    if (table.equals("users_rel_forum")) {
                        this.changeFilmReviewVote(action, orc);
                        continue;
                    }
                    if (table.equals("user_mustsee")) {
                        this.changeMyCobjectsAndSelections(action, orc);
                        continue;
                    }
                    if (table.equals("users_rel_vote")) {
                        this.changeFilmVote(action, orc);
                        continue;
                    }
                    if (table.equals("user_stars")) {
                        this.changeStarsPersonSubscription(action, orc);
                        continue;
                    }
                    if (table.equals("blog_comment")) {
                        try {
                            this.changeFilmReviewComments(action, orc);
                        }
                        catch (SerialException e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    if (table.equals("blog_comment_vote")) {
                        this.changeFilmReviewCommentVote(action, orc);
                        continue;
                    }
                    if (!table.equals("user_mustsee_type")) continue;
                    this.changeSelectionTitle(action, orc);
                }
                continue;
            }
            if (dbmsData instanceof LoadDataFileFragment) {
                if (!logger.isDebugEnabled()) continue;
                logger.error((Object)"Ignoring load data file fragment");
                continue;
            }
            if (dbmsData instanceof RowIdData) {
                if (!logger.isDebugEnabled()) continue;
                logger.error((Object)"Ignoring row ID data");
                continue;
            }
            logger.error((Object)("Unsupported DbmsData class: " + dbmsData.getClass().getName()));
        }
        this.latestHeader = header;
        if (doCommit) {
            this.commit();
        }
    }

    private void changeSelectionTitle(RowChangeData.ActionType action, OneRowChange orc) {
        DB db = this.m.getDB("kino-kp");
        DBCollection coll = db.getCollection("filmSelectionTitle");
        if (action.toString().equals("INSERT")) {
            logger.warn((Object)"IN insert filmSelectionTitle");
            ArrayList colSpecs = orc.getColumnSpec();
            Iterator colValues = orc.getColumnValues().iterator();
            while (colValues.hasNext()) {
                BasicDBObject updateQuery = new BasicDBObject();
                ArrayList row = (ArrayList)colValues.next();
                for (int i = 0; i < row.size(); ++i) {
                    Object o = ((OneRowChange.ColumnVal)row.get(i)).getValue();
                    if (o == null) {
                        return;
                    }
                    String value = o.toString();
                    String name = ((OneRowChange.ColumnSpec)colSpecs.get(i)).getName();
                    logger.warn((Object)("update: i=" + i + " column  = " + name + " value =" + value));
                    if (name.equals("type_id")) {
                        updateQuery.put("_id", (Object)Integer.valueOf(value));
                        continue;
                    }
                    if (!name.equals("name_x")) continue;
                    updateQuery.put("title", (Object)value);
                }
                logger.warn((Object)updateQuery);
                logger.warn((Object)coll.insert(new DBObject[]{updateQuery}));
            }
        } else if (action.toString().equals("DELETE")) {
            BasicDBObject updateQuery = new BasicDBObject();
            this.ensureIndexes(coll, orc);
            logger.warn((Object)"IN delete table= filmSelectionTitle");
            Long userId = 0L;
            ArrayList keySpecs = orc.getKeySpec();
            ArrayList keyValues = orc.getKeyValues();
            for (int row = 0; row < keyValues.size(); ++row) {
                List keyValuesOfRow = (List)keyValues.get(row);
                for (int i = 0; i < keyValuesOfRow.size(); ++i) {
                    String value = ((OneRowChange.ColumnVal)keyValuesOfRow.get(i)).getValue().toString();
                    String name = ((OneRowChange.ColumnSpec)keySpecs.get(i)).getName();
                    logger.warn((Object)(" name = " + name + " value  = " + value));
                    if (!name.equals("type_id")) continue;
                    updateQuery.put("_id", (Object)Long.valueOf(value));
                }
            }
            logger.warn((Object)updateQuery);
            logger.warn((Object)coll.remove((DBObject)updateQuery));
        }
    }

    private void changeFilmReviewCommentVote(RowChangeData.ActionType action, OneRowChange orc) {
        DB db = this.m.getDB("kino-kp");
        DBCollection coll = db.getCollection("filmReviewComment");
        if (action.toString().equals("INSERT")) {
            logger.warn((Object)("IN insert-if Processing row update: action=" + action + " schema=kino-kp table= userFriends"));
            ArrayList colSpecs = orc.getColumnSpec();
            Iterator colValues = orc.getColumnValues().iterator();
            while (colValues.hasNext()) {
                BasicDBObject updateQuery = new BasicDBObject();
                BasicDBObject vote = new BasicDBObject();
                Long userId = 0L;
                ArrayList row = (ArrayList)colValues.next();
                for (int i = 0; i < row.size(); ++i) {
                    if (((OneRowChange.ColumnVal)row.get(i)).getValue() == null) continue;
                    String value = ((OneRowChange.ColumnVal)row.get(i)).getValue().toString();
                    String name = ((OneRowChange.ColumnSpec)colSpecs.get(i)).getName();
                    logger.warn((Object)("IN insert-if Processing column  = " + name + " value =" + value));
                    if (name.equals("user_id")) {
                        userId = Long.valueOf(value);
                        vote.put("userId", (Object)Long.valueOf(value));
                    } else if (name.equals("comment_id")) {
                        updateQuery.put("_id", (Object)value);
                    } else if (name.equals("vector")) {
                        if (value == null) {
                            logger.warn((Object)("error in vote value : " + value));
                            return;
                        }
                        if (value.equals("up")) {
                            value = "POSITIVE";
                        } else if (value.equals("down")) {
                            value = "NEGATIVE";
                        } else {
                            logger.warn((Object)("bad value of vote : " + value));
                            return;
                        }
                        vote.put("type", (Object)value);
                    }
                    vote.put("created", (Object)new Date());
                }
                logger.warn((Object)("Adding document: doc=" + updateQuery));
                logger.warn((Object)("inserted:" + coll.update((DBObject)updateQuery, (DBObject)new BasicDBObject("$pull", (Object)new BasicDBObject("votes", (Object)new BasicDBObject("userId", (Object)userId))))));
                logger.warn((Object)("inserted:" + coll.update((DBObject)updateQuery, (DBObject)new BasicDBObject("$addToSet", (Object)new BasicDBObject("votes", (Object)vote)))));
            }
        } else if (action.toString().equals("UPDATE")) {
            this.ensureIndexes(coll, orc);
            ArrayList keySpecs = orc.getKeySpec();
            ArrayList colSpecs = orc.getColumnSpec();
            ArrayList keyValues = orc.getKeyValues();
            ArrayList columnValues = orc.getColumnValues();
            for (int row = 0; row < columnValues.size() || row < keyValues.size(); ++row) {
                Object o;
                int i;
                List keyValuesOfRow = (List)keyValues.get(row);
                List colValuesOfRow = (List)columnValues.get(row);
                BasicDBObject updateQuery = new BasicDBObject();
                BasicDBObject updateCommand = new BasicDBObject();
                BasicDBObject vote = new BasicDBObject();
                Long userId = 0L;
                for (i = 0; i < keyValuesOfRow.size(); ++i) {
                    o = ((OneRowChange.ColumnVal)keyValuesOfRow.get(i)).getValue();
                    if (o == null) continue;
                    String value = o.toString();
                    String name = ((OneRowChange.ColumnSpec)keySpecs.get(i)).getName();
                    logger.warn((Object)("Processing row update: column  = " + name + "  value = " + value));
                    if (name.equals("user_id")) {
                        userId = Long.valueOf(value);
                        vote.put("userId", (Object)Long.valueOf(value));
                        continue;
                    }
                    if (name.equals("comment_id")) {
                        updateQuery.put("_id", (Object)value);
                        continue;
                    }
                    if (!name.equals("vector")) continue;
                    if (value == null) {
                        logger.warn((Object)("error in vote value : " + value));
                        return;
                    }
                    if (value.equals("up")) {
                        value = "POSITIVE";
                    } else if (value.equals("down")) {
                        value = "NEGATIVE";
                    } else {
                        logger.warn((Object)("bad value of vote : " + value));
                        return;
                    }
                    vote.put("type", (Object)value);
                }
                for (i = 0; i < colValuesOfRow.size(); ++i) {
                    o = ((OneRowChange.ColumnVal)colValuesOfRow.get(i)).getValue();
                    if (o == null) continue;
                    String name = ((OneRowChange.ColumnSpec)colSpecs.get(i)).getName();
                    String value = o.toString();
                    if (name.equals("user_id")) {
                        userId = Long.valueOf(value);
                        vote.put("userId", (Object)Long.valueOf(value));
                    } else if (name.equals("comment_id")) {
                        updateQuery.put("_id", (Object)value);
                    } else if (name.equals("vector")) {
                        if (value == null) {
                            logger.warn((Object)("error in vote value : " + value));
                            return;
                        }
                        if (value.equals("up")) {
                            value = "POSITIVE";
                        } else if (value.equals("down")) {
                            value = "NEGATIVE";
                        } else {
                            logger.warn((Object)("bad value of vote : " + value));
                            return;
                        }
                        vote.put("type", (Object)value);
                    }
                    vote.put("created", (Object)new Date());
                }
                logger.warn((Object)("Adding document: doc=" + updateQuery));
                logger.warn((Object)("inserted:" + coll.update((DBObject)updateQuery, (DBObject)new BasicDBObject("$pull", (Object)new BasicDBObject("votes", (Object)new BasicDBObject("userId", (Object)userId))))));
                logger.warn((Object)("inserted:" + coll.update((DBObject)updateQuery, (DBObject)new BasicDBObject("$addToSet", (Object)new BasicDBObject("votes", (Object)vote)))));
            }
        } else if (action.toString().equals("DELETE")) {
            BasicDBObject updateQuery = new BasicDBObject();
            this.ensureIndexes(coll, orc);
            logger.warn((Object)("IN delete-if Processing row update: action=" + action + " schema=kino-kp table= userFriends"));
            Long userId = 0L;
            ArrayList keySpecs = orc.getKeySpec();
            ArrayList keyValues = orc.getKeyValues();
            for (int row = 0; row < keyValues.size(); ++row) {
                List keyValuesOfRow = (List)keyValues.get(row);
                for (int i = 0; i < keyValuesOfRow.size(); ++i) {
                    String value = ((OneRowChange.ColumnVal)keyValuesOfRow.get(i)).getValue().toString();
                    String name = ((OneRowChange.ColumnSpec)keySpecs.get(i)).getName();
                    logger.warn((Object)(" name = " + name + " value  = " + value));
                    if (name.equals("user_id")) {
                        userId = Long.valueOf(value);
                        continue;
                    }
                    if (!name.equals("comment_id")) continue;
                    updateQuery.put("_id", (Object)value);
                }
            }
            logger.warn((Object)("inserted:" + coll.update((DBObject)updateQuery, (DBObject)new BasicDBObject("$pull", (Object)new BasicDBObject("votes", (Object)new BasicDBObject("userId", (Object)userId))))));
            logger.warn((Object)(" deleted obj with query " + updateQuery));
        } else {
            logger.error((Object)("Unrecognized action type: " + action));
            return;
        }
    }

    private void changeFilmReviewComments(RowChangeData.ActionType action, OneRowChange orc) throws SerialException {
        DB db = this.m.getDB("kino-kp");
        DBCollection coll = db.getCollection("filmReviewComment");
        if (action.toString().equals("INSERT")) {
            logger.warn((Object)("IN insert-if Processing row update: action=" + action + " schema=kino-kp table= userFriends"));
            ArrayList colSpecs = orc.getColumnSpec();
            Iterator colValues = orc.getColumnValues().iterator();
            while (colValues.hasNext()) {
                BasicDBObject updateQuery = new BasicDBObject();
                ArrayList row = (ArrayList)colValues.next();
                for (int i = 0; i < row.size(); ++i) {
                    if (((OneRowChange.ColumnVal)row.get(i)).getValue() == null) continue;
                    String value = ((OneRowChange.ColumnVal)row.get(i)).getValue().toString();
                    String name = ((OneRowChange.ColumnSpec)colSpecs.get(i)).getName();
                    logger.warn((Object)("IN insert-if Processing column  = " + name + " value =" + value));
                    if (name.equals("user_id")) {
                        updateQuery.put("userId", (Object)Long.valueOf(value));
                    } else if (name.equals("id")) {
                        updateQuery.put("_id", (Object)value);
                    } else if (name.equals("parent_id")) {
                        updateQuery.put("parentId", (Object)Long.valueOf(value));
                    } else if (name.equals("comment")) {
                        Scanner s = new Scanner(((SerialBlob)((OneRowChange.ColumnVal)row.get(i)).getValue()).getBinaryStream()).useDelimiter("\\A");
                        value = s.next();
                        logger.warn((Object)"text value : ");
                        logger.warn((Object)value);
                        updateQuery.put("text", (Object)value);
                    } else if (name.equals("src_id")) {
                        updateQuery.put("filmReviewId", (Object)Long.valueOf(value));
                    } else if (name.equals("src_type") && !value.equals("user_review")) {
                        logger.warn((Object)("type must be film , but found : " + value));
                        return;
                    }
                    updateQuery.put("published", (Object)new Date());
                    updateQuery.put("isVerified", (Object)true);
                    updateQuery.put("banned", (Object)false);
                    updateQuery.put("claims", new ArrayList());
                    updateQuery.put("votes", new ArrayList());
                }
                logger.warn((Object)("Adding document: doc=" + updateQuery));
                logger.warn((Object)("inserted:" + coll.insert(new DBObject[]{updateQuery})));
            }
        } else if (action.toString().equals("UPDATE")) {
            this.ensureIndexes(coll, orc);
            ArrayList keySpecs = orc.getKeySpec();
            ArrayList colSpecs = orc.getColumnSpec();
            ArrayList keyValues = orc.getKeyValues();
            ArrayList columnValues = orc.getColumnValues();
            for (int row = 0; row < columnValues.size() || row < keyValues.size(); ++row) {
                Object o;
                int i;
                List keyValuesOfRow = (List)keyValues.get(row);
                List colValuesOfRow = (List)columnValues.get(row);
                BasicDBObject updateQuery = new BasicDBObject();
                BasicDBObject updateCommand = new BasicDBObject();
                for (i = 0; i < keyValuesOfRow.size(); ++i) {
                    o = ((OneRowChange.ColumnVal)keyValuesOfRow.get(i)).getValue();
                    if (o == null) continue;
                    String value = o.toString();
                    String name = ((OneRowChange.ColumnSpec)keySpecs.get(i)).getName();
                    logger.warn((Object)("Processing row update: column  = " + name + "  value = " + value));
                    if (!name.equals("id")) continue;
                    updateQuery.put("_id", (Object)value);
                }
                for (i = 0; i < colValuesOfRow.size(); ++i) {
                    o = ((OneRowChange.ColumnVal)colValuesOfRow.get(i)).getValue();
                    if (o == null) continue;
                    String name = ((OneRowChange.ColumnSpec)colSpecs.get(i)).getName();
                    String value = o.toString();
                    if (name.equals("user_id")) {
                        updateCommand.put("userId", (Object)Long.valueOf(value));
                        continue;
                    }
                    if (name.equals("parent_id")) {
                        updateCommand.put("parentId", (Object)Long.valueOf(value));
                        continue;
                    }
                    if (name.equals("comment")) {
                        Scanner s = new Scanner(((SerialBlob)((OneRowChange.ColumnVal)colValuesOfRow.get(i)).getValue()).getBinaryStream()).useDelimiter("\\A");
                        value = s.next();
                        logger.warn((Object)"text value : ");
                        logger.warn((Object)value);
                        updateCommand.put("text", (Object)value);
                        continue;
                    }
                    if (name.equals("src_id")) {
                        updateCommand.put("filmReviewId", (Object)Long.valueOf(value));
                        continue;
                    }
                    if (!name.equals("src_type") || value.equals("user_review")) continue;
                    logger.warn((Object)("type must be film , but found : " + value));
                    return;
                }
                logger.warn((Object)("Updating document: query=" + updateQuery + " doc=" + updateCommand));
                logger.warn((Object)("count " + coll.getCount((DBObject)updateQuery)));
                coll.update((DBObject)updateQuery, (DBObject)new BasicDBObject("$set", (Object)updateCommand));
            }
        } else if (action.toString().equals("DELETE")) {
            BasicDBObject updateQuery = new BasicDBObject();
            this.ensureIndexes(coll, orc);
            logger.warn((Object)("IN delete-if Processing row update: action=" + action + " schema=kino-kp table= userFriends"));
            ArrayList keySpecs = orc.getKeySpec();
            ArrayList keyValues = orc.getKeyValues();
            for (int row = 0; row < keyValues.size(); ++row) {
                List keyValuesOfRow = (List)keyValues.get(row);
                for (int i = 0; i < keyValuesOfRow.size(); ++i) {
                    String value = ((OneRowChange.ColumnVal)keyValuesOfRow.get(i)).getValue().toString();
                    String name = ((OneRowChange.ColumnSpec)keySpecs.get(i)).getName();
                    if (!name.equals("id")) continue;
                    updateQuery.put("_id", (Object)value);
                }
                coll.remove((DBObject)updateQuery);
            }
            logger.warn((Object)(" deleted obj with query " + updateQuery));
        } else {
            logger.warn((Object)("Unrecognized action type: " + action));
            return;
        }
    }

    private void changeStarsPersonSubscription(RowChangeData.ActionType action, OneRowChange orc) {
        DB db = this.m.getDB("kino-kp");
        DBCollection coll = db.getCollection("personSubscription");
        if (action.toString().equals("INSERT")) {
            logger.warn((Object)("IN changeStarsPersonSubscription Processing row update: action=" + action + " schema=kino-kp table= personSubscription"));
            ArrayList colSpecs = orc.getColumnSpec();
            Iterator colValues = orc.getColumnValues().iterator();
            while (colValues.hasNext()) {
                long time = System.nanoTime();
                BasicDBObject updateQuery = new BasicDBObject();
                ArrayList row = (ArrayList)colValues.next();
                for (int i = 0; i < row.size(); ++i) {
                    if (((OneRowChange.ColumnVal)row.get(i)).getValue() == null) continue;
                    String value = ((OneRowChange.ColumnVal)row.get(i)).getValue().toString();
                    String name = ((OneRowChange.ColumnSpec)colSpecs.get(i)).getName();
                    if (name.equals("user_id")) {
                        updateQuery.put("userId", (Object)Long.valueOf(value));
                        continue;
                    }
                    if (name.equals("id_actor")) {
                        updateQuery.put("personId", (Object)Long.valueOf(value));
                        continue;
                    }
                    if (!name.equals("mustsee_id")) continue;
                    updateQuery.put("mustSeeId", (Object)Long.valueOf(value));
                }
                updateQuery.put("date", (Object)new Date());
                logger.warn((Object)("time for query " + (System.nanoTime() - time)));
                time = System.nanoTime();
                coll.insert(new DBObject[]{updateQuery});
                logger.warn((Object)(" time " + (System.nanoTime() - time)));
            }
        } else if (action.toString().equals("UPDATE")) {
            this.ensureIndexes(coll, orc);
            ArrayList keySpecs = orc.getKeySpec();
            ArrayList colSpecs = orc.getColumnSpec();
            ArrayList keyValues = orc.getKeyValues();
            ArrayList columnValues = orc.getColumnValues();
            for (int row = 0; row < columnValues.size() || row < keyValues.size(); ++row) {
                Object o;
                int i;
                List keyValuesOfRow = (List)keyValues.get(row);
                List colValuesOfRow = (List)columnValues.get(row);
                BasicDBObject updateQuery = new BasicDBObject();
                BasicDBObject updateCommand = new BasicDBObject();
                for (i = 0; i < keyValuesOfRow.size(); ++i) {
                    o = ((OneRowChange.ColumnVal)keyValuesOfRow.get(i)).getValue();
                    if (o == null) continue;
                    String value = o.toString();
                    String name = ((OneRowChange.ColumnSpec)keySpecs.get(i)).getName();
                    logger.warn((Object)("Processing row update: column  = " + name + "  value = " + value));
                    if (!name.equals("mustsee_id")) continue;
                    updateQuery.put("mustSeeId", (Object)Long.valueOf(value));
                    updateCommand.put("mustSeeId", (Object)Long.valueOf(value));
                }
                for (i = 0; i < colValuesOfRow.size(); ++i) {
                    o = ((OneRowChange.ColumnVal)colValuesOfRow.get(i)).getValue();
                    if (o == null) continue;
                    String name = ((OneRowChange.ColumnSpec)colSpecs.get(i)).getName();
                    String value = o.toString();
                    logger.warn((Object)("Processing row update: column  = " + name + "  value = " + value));
                    if (name.equals("user_id")) {
                        updateCommand.put("userId", (Object)Long.valueOf(value));
                        continue;
                    }
                    if (!name.equals("id_actor")) continue;
                    updateCommand.put("personId", (Object)Long.valueOf(value));
                }
                updateCommand.put("date", (Object)new Date());
                logger.warn((Object)("Updating document: query=" + updateQuery + " doc=" + updateCommand));
                logger.warn((Object)("count " + coll.getCount((DBObject)updateQuery)));
                coll.remove((DBObject)updateQuery);
                coll.insert(new DBObject[]{updateCommand});
            }
        } else if (action.toString().equals("DELETE")) {
            ArrayList keySpecs = orc.getKeySpec();
            ArrayList keyValues = orc.getKeyValues();
            ArrayList columnValues = orc.getColumnValues();
            BasicDBObject updateQuery = new BasicDBObject();
            for (int row = 0; row < columnValues.size() || row < keyValues.size(); ++row) {
                List keyValuesOfRow = (List)keyValues.get(row);
                for (int i = 0; i < keyValuesOfRow.size(); ++i) {
                    Object o = ((OneRowChange.ColumnVal)keyValuesOfRow.get(i)).getValue();
                    if (o == null) continue;
                    String value = o.toString();
                    String name = ((OneRowChange.ColumnSpec)keySpecs.get(i)).getName();
                    logger.warn((Object)("Processing row delete: column  = " + name + "  value = " + value));
                    if (!name.equals("mustsee_id")) continue;
                    updateQuery.put("mustSeeId", (Object)Long.valueOf(value));
                }
            }
            coll.remove((DBObject)updateQuery);
            logger.warn((Object)("Deleting document: query=" + updateQuery));
        } else {
            logger.error((Object)("Unrecognized action type: " + action));
            return;
        }
    }

    private void changeFilmVote(RowChangeData.ActionType action, OneRowChange orc) {
        DB db = this.m.getDB("kino-kp");
        DBCollection coll = db.getCollection("filmVote");
        this.ensureIndexes(coll, orc);
        if (action.toString().equals("INSERT")) {
            logger.warn((Object)("IN insert-if Processing row update: action=" + action + " schema=kino-kp table=filmVote"));
            ArrayList colSpecs = orc.getColumnSpec();
            Iterator colValues = orc.getColumnValues().iterator();
            while (colValues.hasNext()) {
                BasicDBObject updateQuery = new BasicDBObject();
                ArrayList row = (ArrayList)colValues.next();
                for (int i = 0; i < row.size(); ++i) {
                    if (((OneRowChange.ColumnVal)row.get(i)).getValue() == null) continue;
                    String value = ((OneRowChange.ColumnVal)row.get(i)).getValue().toString();
                    String name = ((OneRowChange.ColumnSpec)colSpecs.get(i)).getName();
                    logger.warn((Object)("IN insert-if Processing column  = " + name + " value =" + value));
                    if (name.equals("id")) {
                        updateQuery.put("filmId", (Object)Long.valueOf(value));
                        continue;
                    }
                    if (name.equals("user_id")) {
                        updateQuery.put("userId", (Object)Long.valueOf(value));
                        continue;
                    }
                    if (!name.equals("vote")) continue;
                    Long rate = 0L;
                    rate = Long.valueOf(value).equals(rate) ? null : Long.valueOf(value);
                    updateQuery.put("rate", (Object)rate);
                }
                updateQuery.put("date", (Object)new Date());
                updateQuery.put("filmType", (Object)"MOVIE");
                logger.warn((Object)("Adding document: doc=" + updateQuery));
                logger.warn((Object)coll.count((DBObject)updateQuery));
            }
        } else if (action.toString().equals("UPDATE")) {
            ArrayList keySpecs = orc.getKeySpec();
            ArrayList colSpecs = orc.getColumnSpec();
            ArrayList keyValues = orc.getKeyValues();
            ArrayList columnValues = orc.getColumnValues();
            for (int row = 0; row < columnValues.size() || row < keyValues.size(); ++row) {
                Long rate;
                Object o;
                int i;
                List keyValuesOfRow = (List)keyValues.get(row);
                List colValuesOfRow = (List)columnValues.get(row);
                BasicDBObject updateQuery = new BasicDBObject();
                BasicDBObject updateCommand = new BasicDBObject();
                for (i = 0; i < keyValuesOfRow.size(); ++i) {
                    o = ((OneRowChange.ColumnVal)keyValuesOfRow.get(i)).getValue();
                    if (o == null) continue;
                    String value = o.toString();
                    String name = ((OneRowChange.ColumnSpec)keySpecs.get(i)).getName();
                    logger.warn((Object)("IN changeFilmVote Processing column  = " + name + " value =" + value));
                    if (name.equals("id")) {
                        updateQuery.put("filmId", (Object)Long.valueOf(value));
                        continue;
                    }
                    if (name.equals("user_id")) {
                        updateQuery.put("userId", (Object)Long.valueOf(value));
                        continue;
                    }
                    if (!name.equals("vote")) continue;
                    rate = 0L;
                    rate = Long.valueOf(value).equals(rate) ? null : Long.valueOf(value);
                    updateQuery.put("rate", (Object)rate);
                }
                for (i = 0; i < colValuesOfRow.size(); ++i) {
                    o = ((OneRowChange.ColumnVal)colValuesOfRow.get(i)).getValue();
                    if (o == null) continue;
                    String name = ((OneRowChange.ColumnSpec)colSpecs.get(i)).getName();
                    String value = o.toString();
                    logger.warn((Object)("IN insert-if Processing column  = " + name + " value =" + value));
                    if (name.equals("id")) {
                        updateCommand.put("filmId", (Object)Long.valueOf(value));
                        continue;
                    }
                    if (name.equals("user_id")) {
                        updateCommand.put("userId", (Object)Long.valueOf(value));
                        continue;
                    }
                    if (!name.equals("vote")) continue;
                    rate = 0L;
                    rate = Long.valueOf(value).equals(rate) ? null : Long.valueOf(value);
                    updateCommand.put("rate", (Object)rate);
                }
                updateCommand.put("date", (Object)new Date());
                updateCommand.put("filmType", (Object)"MOVIE");
                logger.warn((Object)("Adding document: doc=" + updateQuery + " command = " + updateCommand));
                coll.remove((DBObject)updateQuery);
                coll.insert(new DBObject[]{updateCommand});
            }
        } else if (action.toString().equals("DELETE")) {
            BasicDBObject updateQuery = new BasicDBObject();
            logger.warn((Object)("IN delete-if Processing row update: action=" + action + " schema=kino-kp table= userFriends"));
            ArrayList keySpecs = orc.getKeySpec();
            ArrayList keyValues = orc.getKeyValues();
            for (int row = 0; row < keyValues.size(); ++row) {
                List keyValuesOfRow = (List)keyValues.get(row);
                for (int i = 0; i < keyValuesOfRow.size(); ++i) {
                    String value = ((OneRowChange.ColumnVal)keyValuesOfRow.get(i)).getValue().toString();
                    String name = ((OneRowChange.ColumnSpec)keySpecs.get(i)).getName();
                    logger.warn((Object)(" name = " + name + " value  = " + value));
                    if (name.equals("id")) {
                        updateQuery.put("filmId", (Object)Long.valueOf(value));
                        continue;
                    }
                    if (name.equals("user_id")) {
                        updateQuery.put("userId", (Object)Long.valueOf(value));
                        continue;
                    }
                    if (!name.equals("vote")) continue;
                    Long rate = 0L;
                    rate = Long.valueOf(value).equals(rate) ? null : Long.valueOf(value);
                    updateQuery.put("rate", (Object)rate);
                }
                logger.warn((Object)("Adding document: doc=" + updateQuery));
                coll.remove((DBObject)updateQuery);
            }
        } else {
            logger.error((Object)("Unrecognized action type: " + action));
            return;
        }
    }

    private void changeMyCobjectsAndSelections(RowChangeData.ActionType action, OneRowChange orc) {
        DB db = this.m.getDB("kino-kp");
        if (action.toString().equals("INSERT")) {
            logger.warn((Object)("IN insert-if Processing row update: action=" + action + " schema=kino-kp table=userMustsee"));
            ArrayList colSpecs = orc.getColumnSpec();
            Iterator colValues = orc.getColumnValues().iterator();
            boolean isMyCobject = false;
            Long filmId = 0L;
            Long titleId = 0L;
            Long userId = 0L;
            Long mustSeeId = 0L;
            while (colValues.hasNext()) {
                DBCollection coll;
                BasicDBObject updateQuery = new BasicDBObject();
                BasicDBObject updateSelectionQuery = new BasicDBObject();
                BasicDBObject m = new BasicDBObject();
                ArrayList row = (ArrayList)colValues.next();
                for (int i = 0; i < row.size(); ++i) {
                    if (((OneRowChange.ColumnVal)row.get(i)).getValue() == null) continue;
                    String value = ((OneRowChange.ColumnVal)row.get(i)).getValue().toString();
                    String name = ((OneRowChange.ColumnSpec)colSpecs.get(i)).getName();
                    logger.warn((Object)("IN insert-if Processing column  = " + name + " value =" + value));
                    if (name.equals("mustsee_id")) {
                        updateQuery.put("_id", (Object)Long.valueOf(value));
                        m.put("mustSeeId", (Object)Long.valueOf(value));
                        continue;
                    }
                    if (name.equals("user_id")) {
                        updateQuery.put("userId", (Object)Long.valueOf(value));
                        userId = Long.valueOf(value);
                        continue;
                    }
                    if (name.equals("id_film")) {
                        filmId = Long.valueOf(value);
                        updateQuery.put("filmId", (Object)filmId);
                        m.put("filmId", (Object)filmId);
                        continue;
                    }
                    if (!name.equals("type_id")) continue;
                    if (value.equals("2") || value.equals("3575")) {
                        isMyCobject = true;
                        updateQuery.put("filmType", (Object)"MOVIE");
                        continue;
                    }
                    titleId = Long.valueOf(value);
                }
                if (isMyCobject) {
                    coll = db.getCollection("myCobject");
                    this.ensureIndexes(coll, orc);
                    updateQuery.put("date", (Object)new Date());
                    logger.warn((Object)("Adding myCobject: doc=" + updateQuery));
                    logger.warn((Object)coll.count((DBObject)updateQuery));
                    continue;
                }
                BasicDBObject searchQuery = new BasicDBObject("selection._id", (Object)(userId * 1000000L + titleId));
                coll = db.getCollection("newFilmSelection");
                this.ensureIndexes(coll, orc);
                if (coll.count((DBObject)searchQuery) == 0L) {
                    logger.warn((Object)"inserting new film selection");
                    BasicDBObject insertQuery = new BasicDBObject();
                    insertQuery.put("ownerId", (Object)userId);
                    coll = db.getCollection("filmSelectionTitle");
                    this.ensureIndexes(coll, orc);
                    BasicDBObject selection = new BasicDBObject();
                    String title = coll.findOne((DBObject)new BasicDBObject("_id", (Object)titleId)).get("title").toString();
                    selection.put("title", (Object)title);
                    coll = db.getCollection("newFilmSelection");
                    this.ensureIndexes(coll, orc);
                    selection.put("_id", (Object)(userId * 1000000L + titleId));
                    selection.put("isBadExtSourceUrl", (Object)false);
                    selection.put("isForever", (Object)false);
                    selection.put("isPromo", (Object)false);
                    selection.put("isForbiddenShowingOnMain", (Object)true);
                    selection.put("filmIds", new ArrayList());
                    selection.put("map", new ArrayList());
                    selection.put("creationDate", (Object)new Date());
                    BasicDBObject author = new BasicDBObject("userId", (Object)userId);
                    insertQuery.put("selection", (Object)selection);
                    coll = db.getCollection("userProfile");
                    this.ensureIndexes(coll, orc);
                    DBObject user = coll.findOne((DBObject)new BasicDBObject("userId", (Object)userId), (DBObject)new BasicDBObject("displayName", (Object)1));
                    String login = user.get("displayName").toString();
                    author.put("name", (Object)login);
                    insertQuery.put("author", (Object)author);
                    coll = db.getCollection("newFilmSelection");
                    this.ensureIndexes(coll, orc);
                    logger.warn((Object)insertQuery);
                    logger.warn((Object)coll.insert(new DBObject[]{insertQuery}));
                }
                BasicDBObject uQ = new BasicDBObject("$addToSet", (Object)new BasicDBObject("selection.filmIds", (Object)filmId));
                logger.warn((Object)(uQ + " ----------" + searchQuery));
                logger.warn((Object)coll.updateMulti((DBObject)searchQuery, (DBObject)uQ));
                BasicDBObject uQQ = new BasicDBObject("$addToSet", (Object)new BasicDBObject("selection.map", (Object)m));
                logger.warn((Object)(" uQQ " + uQQ));
                logger.warn((Object)coll.updateMulti((DBObject)searchQuery, (DBObject)uQQ));
                logger.warn((Object)coll.findOne((DBObject)searchQuery).toString());
            }
        } else if (action.toString().equals("UPDATE")) {
            ArrayList keySpecs = orc.getKeySpec();
            ArrayList colSpecs = orc.getColumnSpec();
            ArrayList keyValues = orc.getKeyValues();
            ArrayList columnValues = orc.getColumnValues();
            boolean isMyCobject = false;
            for (int row = 0; row < columnValues.size() || row < keyValues.size(); ++row) {
                Object o;
                int i;
                List keyValuesOfRow = (List)keyValues.get(row);
                List colValuesOfRow = (List)columnValues.get(row);
                BasicDBObject updateQuery = new BasicDBObject();
                BasicDBObject updateCommand = new BasicDBObject();
                for (i = 0; i < keyValuesOfRow.size(); ++i) {
                    o = ((OneRowChange.ColumnVal)keyValuesOfRow.get(i)).getValue();
                    if (o == null) continue;
                    String value = o.toString();
                    String name = ((OneRowChange.ColumnSpec)keySpecs.get(i)).getName();
                    logger.warn((Object)("IN changeMyCobjectsAndSelections Processing column  = " + name + " value =" + value));
                    if (!name.equals("mustsee_id")) continue;
                    updateQuery.put("_id", (Object)Long.valueOf(value));
                    updateCommand.put("_id", (Object)Long.valueOf(value));
                }
                for (i = 0; i < colValuesOfRow.size(); ++i) {
                    o = ((OneRowChange.ColumnVal)colValuesOfRow.get(i)).getValue();
                    if (o == null) continue;
                    String name = ((OneRowChange.ColumnSpec)colSpecs.get(i)).getName();
                    String value = o.toString();
                    logger.warn((Object)("IN insert-if Processing column  = " + name + " value =" + value));
                    if (name.equals("id_film")) {
                        updateCommand.put("filmId", (Object)Long.valueOf(value));
                        continue;
                    }
                    if (name.equals("user_id")) {
                        updateCommand.put("userId", (Object)Long.valueOf(value));
                        continue;
                    }
                    if (!name.equals("type_id") || !value.equals("2") && !value.equals("3575")) continue;
                    logger.warn((Object)("error in vote value : " + value));
                    isMyCobject = true;
                    updateCommand.put("filmType", (Object)"MOVIE");
                }
                if (!isMyCobject) continue;
                DBCollection coll = db.getCollection("myCobject");
                this.ensureIndexes(coll, orc);
                logger.warn((Object)("Adding document: doc=" + updateQuery + " command = " + updateCommand));
                coll.remove((DBObject)updateQuery);
                coll.insert(new DBObject[]{updateCommand});
            }
        } else if (action.toString().equals("DELETE")) {
            BasicDBObject updateQuery = new BasicDBObject();
            BasicDBObject removeFilmFromSelection = new BasicDBObject();
            boolean isMyCobject = false;
            logger.warn((Object)("IN changeMyCobjectsAndSelections : action=" + action + " schema=kino-kp table= selection"));
            Long userId = 0L;
            ArrayList keySpecs = orc.getKeySpec();
            ArrayList keyValues = orc.getKeyValues();
            Long mustSeeId = 0L;
            for (int row = 0; row < keyValues.size(); ++row) {
                List keyValuesOfRow = (List)keyValues.get(row);
                for (int i = 0; i < keyValuesOfRow.size(); ++i) {
                    String value = ((OneRowChange.ColumnVal)keyValuesOfRow.get(i)).getValue().toString();
                    String name = ((OneRowChange.ColumnSpec)keySpecs.get(i)).getName();
                    logger.warn((Object)(" name = " + name + " value  = " + value));
                    if (!name.equals("mustsee_id")) continue;
                    updateQuery.put("_id", (Object)Long.valueOf(value));
                    removeFilmFromSelection.put("selection.map.mustSeeId", (Object)Long.valueOf(value));
                    mustSeeId = Long.valueOf(value);
                }
            }
            DBCollection coll = db.getCollection("newFilmSelection");
            this.ensureIndexes(coll, orc);
            if (coll.count((DBObject)removeFilmFromSelection) > 0L) {
                DBObject sel = coll.findOne((DBObject)removeFilmFromSelection, (DBObject)new BasicDBObject("selection.map.filmId.$", (Object)1));
                logger.warn((Object)sel.toString());
                ArrayList arrayList = (ArrayList)((HashMap)sel.get("selection")).get("map");
                Long filmId = Long.valueOf(((HashMap)arrayList.get(0)).get("filmId").toString());
                logger.warn((Object)("filmId" + filmId));
                BasicDBObject dF = new BasicDBObject("selection.filmIds", (Object)filmId);
                logger.warn((Object)dF);
                logger.warn((Object)("deleting : " + coll.updateMulti((DBObject)removeFilmFromSelection, (DBObject)new BasicDBObject("$pull", (Object)dF))));
                logger.warn((Object)coll.findOne((DBObject)removeFilmFromSelection));
                logger.warn((Object)("deleting : " + coll.updateMulti((DBObject)removeFilmFromSelection, (DBObject)new BasicDBObject("$pull", (Object)new BasicDBObject("selection.map", (Object)new BasicDBObject("mustSeeId", (Object)mustSeeId))))));
            }
            if ((coll = db.getCollection("myCobject")).count((DBObject)updateQuery) > 0L) {
                this.ensureIndexes(coll, orc);
                logger.warn((Object)("removing document: doc=" + updateQuery));
                coll.remove((DBObject)updateQuery);
            }
        } else {
            logger.error((Object)("Unrecognized action type: " + action));
            return;
        }
    }

    private void changeFilmReviewVote(RowChangeData.ActionType action, OneRowChange orc) {
        DB db = this.m.getDB("kino-kp");
        DBCollection coll = db.getCollection("filmReview");
        if (action.toString().equals("INSERT")) {
            logger.warn((Object)("IN changeFilmReviewVote: action=" + action + " schema=kino-kp table= userFriends"));
            ArrayList colSpecs = orc.getColumnSpec();
            Iterator colValues = orc.getColumnValues().iterator();
            while (colValues.hasNext()) {
                BasicDBObject updateQuery = new BasicDBObject();
                BasicDBObject vote = new BasicDBObject();
                Long userId = 0L;
                ArrayList row = (ArrayList)colValues.next();
                for (int i = 0; i < row.size(); ++i) {
                    if (((OneRowChange.ColumnVal)row.get(i)).getValue() == null) continue;
                    String value = ((OneRowChange.ColumnVal)row.get(i)).getValue().toString();
                    String name = ((OneRowChange.ColumnSpec)colSpecs.get(i)).getName();
                    logger.warn((Object)("IN insert-if Processing column  = " + name + " value =" + value));
                    if (name.equals("user_id")) {
                        userId = Long.valueOf(value);
                        vote.put("userId", (Object)Long.valueOf(value));
                    } else if (name.equals("id_mess")) {
                        updateQuery.put("_id", (Object)value);
                    } else if (name.equals("vote")) {
                        if (value == null) {
                            logger.warn((Object)("error in vote value : " + value));
                            return;
                        }
                        if (value.equals("ok")) {
                            value = "POSITIVE";
                        } else if (value.equals("no")) {
                            value = "NEGATIVE";
                        } else {
                            logger.warn((Object)("bad value of vote : " + value));
                            return;
                        }
                        vote.put("type", (Object)value);
                    }
                    vote.put("created", (Object)new Date());
                }
                logger.warn((Object)("Adding document: doc=" + updateQuery));
                logger.warn((Object)("inserted:" + coll.update((DBObject)updateQuery, (DBObject)new BasicDBObject("$pull", (Object)new BasicDBObject("votes", (Object)new BasicDBObject("userId", (Object)userId))))));
                logger.warn((Object)("inserted:" + coll.update((DBObject)updateQuery, (DBObject)new BasicDBObject("$addToSet", (Object)new BasicDBObject("votes", (Object)vote)))));
            }
        } else if (action.toString().equals("UPDATE")) {
            this.ensureIndexes(coll, orc);
            ArrayList keySpecs = orc.getKeySpec();
            ArrayList colSpecs = orc.getColumnSpec();
            ArrayList keyValues = orc.getKeyValues();
            ArrayList columnValues = orc.getColumnValues();
            for (int row = 0; row < columnValues.size() || row < keyValues.size(); ++row) {
                Object o;
                int i;
                List keyValuesOfRow = (List)keyValues.get(row);
                List colValuesOfRow = (List)columnValues.get(row);
                BasicDBObject updateQuery = new BasicDBObject();
                BasicDBObject updateCommand = new BasicDBObject();
                BasicDBObject vote = new BasicDBObject();
                Long userId = 0L;
                for (i = 0; i < keyValuesOfRow.size(); ++i) {
                    o = ((OneRowChange.ColumnVal)keyValuesOfRow.get(i)).getValue();
                    if (o == null) continue;
                    String value = o.toString();
                    String name = ((OneRowChange.ColumnSpec)keySpecs.get(i)).getName();
                    logger.warn((Object)("Processing row update: column  = " + name + "  value = " + value));
                    if (name.equals("user_id")) {
                        userId = Long.valueOf(value);
                        vote.put("userId", (Object)Long.valueOf(value));
                        continue;
                    }
                    if (name.equals("id_mess")) {
                        updateQuery.put("_id", (Object)value);
                        continue;
                    }
                    if (!name.equals("vote")) continue;
                    if (value == null) {
                        logger.warn((Object)("error in vote value : " + value));
                        return;
                    }
                    if (value.equals("ok")) {
                        value = "POSITIVE";
                    } else if (value.equals("no")) {
                        value = "NEGATIVE";
                    } else {
                        logger.warn((Object)("bad value of vote : " + value));
                        return;
                    }
                    vote.put("type", (Object)value);
                }
                for (i = 0; i < colValuesOfRow.size(); ++i) {
                    o = ((OneRowChange.ColumnVal)colValuesOfRow.get(i)).getValue();
                    if (o == null) continue;
                    String name = ((OneRowChange.ColumnSpec)colSpecs.get(i)).getName();
                    String value = o.toString();
                    if (name.equals("user_id")) {
                        userId = Long.valueOf(value);
                        vote.put("userId", (Object)Long.valueOf(value));
                    } else if (name.equals("id_mess")) {
                        updateQuery.put("_id", (Object)value);
                    } else if (name.equals("vote")) {
                        if (value == null) {
                            logger.warn((Object)("error in vote value : " + value));
                            return;
                        }
                        if (value.equals("ok")) {
                            value = "POSITIVE";
                        } else if (value.equals("no")) {
                            value = "NEGATIVE";
                        } else {
                            logger.warn((Object)("bad value of vote : " + value));
                            return;
                        }
                        vote.put("type", (Object)value);
                    }
                    vote.put("created", (Object)new Date());
                }
                logger.warn((Object)("Adding document: doc=" + updateQuery));
                logger.warn((Object)("inserted:" + coll.update((DBObject)updateQuery, (DBObject)new BasicDBObject("$pull", (Object)new BasicDBObject("votes", (Object)new BasicDBObject("userId", (Object)userId))))));
                logger.warn((Object)("inserted:" + coll.update((DBObject)updateQuery, (DBObject)new BasicDBObject("$addToSet", (Object)new BasicDBObject("votes", (Object)vote)))));
            }
        } else if (action.toString().equals("DELETE")) {
            BasicDBObject updateQuery = new BasicDBObject();
            this.ensureIndexes(coll, orc);
            logger.warn((Object)("IN changeFilmReviewVote : action=" + action + " schema=kino-kp table= userFriends"));
            Long userId = 0L;
            ArrayList keySpecs = orc.getKeySpec();
            ArrayList keyValues = orc.getKeyValues();
            for (int row = 0; row < keyValues.size(); ++row) {
                List keyValuesOfRow = (List)keyValues.get(row);
                for (int i = 0; i < keyValuesOfRow.size(); ++i) {
                    String value = ((OneRowChange.ColumnVal)keyValuesOfRow.get(i)).getValue().toString();
                    String name = ((OneRowChange.ColumnSpec)keySpecs.get(i)).getName();
                    logger.warn((Object)(" name = " + name + " value  = " + value));
                    if (name.equals("user_id")) {
                        userId = Long.valueOf(value);
                        continue;
                    }
                    if (!name.equals("id_mess")) continue;
                    updateQuery.put("_id", (Object)value);
                }
            }
            logger.warn((Object)("inserted:" + coll.update((DBObject)updateQuery, (DBObject)new BasicDBObject("$pull", (Object)new BasicDBObject("votes", (Object)new BasicDBObject("userId", (Object)userId))))));
            logger.warn((Object)(" deleted obj with query " + updateQuery));
        } else {
            logger.error((Object)("Unrecognized action type: " + action));
            return;
        }
    }

    private void changeFilmReview(RowChangeData.ActionType action, OneRowChange orc) throws SerialException {
        DB db = this.m.getDB("kino-kp");
        DBCollection coll = db.getCollection("filmReview");
        if (action.toString().equals("INSERT")) {
            logger.warn((Object)("IN changeFilmReview : action=" + action + " schema=kino-kp table= filmReview"));
            ArrayList colSpecs = orc.getColumnSpec();
            Iterator colValues = orc.getColumnValues().iterator();
            while (colValues.hasNext()) {
                BasicDBObject updateQuery = new BasicDBObject();
                ArrayList row = (ArrayList)colValues.next();
                for (int i = 0; i < row.size(); ++i) {
                    if (((OneRowChange.ColumnVal)row.get(i)).getValue() == null) continue;
                    String value = ((OneRowChange.ColumnVal)row.get(i)).getValue().toString();
                    String name = ((OneRowChange.ColumnSpec)colSpecs.get(i)).getName();
                    logger.warn((Object)("IN insert-if Processing column  = " + name + " value =" + value));
                    if (name.equals("id_user")) {
                        updateQuery.put("userId", (Object)Long.valueOf(value));
                    } else if (name.equals("id_mess")) {
                        updateQuery.put("_id", (Object)value);
                    } else if (name.equals("id_rel")) {
                        updateQuery.put("filmId", (Object)Long.valueOf(value));
                    } else if (name.equals("message")) {
                        Scanner s = new Scanner(((SerialBlob)((OneRowChange.ColumnVal)row.get(i)).getValue()).getBinaryStream()).useDelimiter("\\A");
                        value = s.next();
                        logger.error((Object)"text value : ");
                        logger.error((Object)value);
                        updateQuery.put("text", (Object)value);
                    } else if (name.equals("title")) {
                        updateQuery.put("title", (Object)value);
                    } else if (name.equals("type_mess")) {
                        if (!value.equals("forum")) {
                            logger.warn((Object)("type_mess must be forum , but found : " + value));
                            return;
                        }
                    } else if (name.equals("type")) {
                        if (!value.equals("film")) {
                            logger.warn((Object)("type must be film , but found : " + value));
                            return;
                        }
                    } else if (name.equals("review_status")) {
                        if (value != null) {
                            value = value.equals("good") ? "POSITIVE" : (value.equals("bad") ? "NEGATIVE" : "NEUTRAL");
                        }
                        updateQuery.put("type", (Object)value);
                    }
                    updateQuery.put("created", (Object)new Date());
                    updateQuery.put("isApproved", (Object)true);
                    updateQuery.put("isVerified", (Object)true);
                    updateQuery.put("isForced", (Object)false);
                    updateQuery.put("isMain", (Object)false);
                    updateQuery.put("spoilerClaims", new ArrayList());
                    updateQuery.put("votes", new ArrayList());
                }
                logger.warn((Object)("Adding document: doc=" + updateQuery));
                logger.warn((Object)("inserted:" + coll.insert(new DBObject[]{updateQuery})));
            }
        } else if (action.toString().equals("UPDATE")) {
            this.ensureIndexes(coll, orc);
            ArrayList keySpecs = orc.getKeySpec();
            ArrayList colSpecs = orc.getColumnSpec();
            ArrayList keyValues = orc.getKeyValues();
            ArrayList columnValues = orc.getColumnValues();
            for (int row = 0; row < columnValues.size() || row < keyValues.size(); ++row) {
                Object o;
                int i;
                List keyValuesOfRow = (List)keyValues.get(row);
                List colValuesOfRow = (List)columnValues.get(row);
                BasicDBObject updateQuery = new BasicDBObject();
                BasicDBObject updateCommand = new BasicDBObject();
                for (i = 0; i < keyValuesOfRow.size(); ++i) {
                    o = ((OneRowChange.ColumnVal)keyValuesOfRow.get(i)).getValue();
                    if (o == null) continue;
                    String value = o.toString();
                    String name = ((OneRowChange.ColumnSpec)keySpecs.get(i)).getName();
                    logger.error((Object)("Processing row update: column  = " + name + "  value = " + value));
                    if (name.equals("id_mess")) {
                        updateQuery.put("_id", (Object)value);
                        continue;
                    }
                    if (name.equals("type_mess")) {
                        if (value.equals("forum")) continue;
                        logger.warn((Object)("type_mess must be forum , but found : " + value));
                        return;
                    }
                    if (!name.equals("type") || value.equals("film")) continue;
                    logger.warn((Object)("type must be film , but found : " + value));
                    return;
                }
                for (i = 0; i < colValuesOfRow.size(); ++i) {
                    o = ((OneRowChange.ColumnVal)colValuesOfRow.get(i)).getValue();
                    if (o == null) continue;
                    String name = ((OneRowChange.ColumnSpec)colSpecs.get(i)).getName();
                    String value = o.toString();
                    if (name.equals("id_rel")) {
                        updateCommand.put("filmId", (Object)Long.valueOf(value));
                        continue;
                    }
                    if (name.equals("message")) {
                        Scanner s = new Scanner(((SerialBlob)o).getBinaryStream()).useDelimiter("\\A");
                        value = s.next();
                        logger.error((Object)"text value : ");
                        logger.error((Object)value);
                        updateCommand.put("text", (Object)value);
                        continue;
                    }
                    if (name.equals("title")) {
                        updateCommand.put("title", (Object)value);
                        continue;
                    }
                    if (name.equals("review_status")) {
                        if (value != null) {
                            value = value.equals("good") ? "POSITIVE" : (value.equals("bad") ? "NEGATIVE" : "NEUTRAL");
                        }
                        updateCommand.put("type", (Object)value);
                        continue;
                    }
                    if (name.equals("type_mess")) {
                        if (value.equals("forum")) continue;
                        logger.warn((Object)("type_mess must be forum , but found : " + value));
                        return;
                    }
                    if (!name.equals("type") || value.equals("film")) continue;
                    logger.warn((Object)("type must be film , but found : " + value));
                    return;
                }
                logger.warn((Object)("Updating document: query=" + updateQuery + " doc=" + updateCommand));
                logger.warn((Object)("count " + coll.getCount((DBObject)updateQuery)));
                coll.update((DBObject)updateQuery, (DBObject)new BasicDBObject("$set", (Object)updateCommand));
            }
        } else if (action.toString().equals("DELETE")) {
            BasicDBObject updateQuery = new BasicDBObject();
            this.ensureIndexes(coll, orc);
            logger.warn((Object)("IN changeFilmReview: action=" + action + " schema=kino-kp table= filmReview"));
            ArrayList keySpecs = orc.getKeySpec();
            ArrayList keyValues = orc.getKeyValues();
            for (int row = 0; row < keyValues.size(); ++row) {
                List keyValuesOfRow = (List)keyValues.get(row);
                for (int i = 0; i < keyValuesOfRow.size(); ++i) {
                    String value = ((OneRowChange.ColumnVal)keyValuesOfRow.get(i)).getValue().toString();
                    String name = ((OneRowChange.ColumnSpec)keySpecs.get(i)).getName();
                    if (!name.equals("id_mess")) continue;
                    updateQuery.put("_id", (Object)value);
                }
                coll.remove((DBObject)updateQuery);
            }
            logger.warn((Object)(" deleted obj with query " + updateQuery));
        } else {
            logger.error((Object)("Unrecognized action type: " + action));
            return;
        }
    }

    private void changePersonSubscription(RowChangeData.ActionType action, OneRowChange orc) {
        DB db = this.m.getDB("kino-kp");
        DBCollection coll = db.getCollection("personSubscription");
        if (action.toString().equals("INSERT")) {
            logger.warn((Object)("IN changePersonSubscription Processing row update: action=" + action + " schema=kino-kp table= userFriends"));
            ArrayList colSpecs = orc.getColumnSpec();
            Iterator colValues = orc.getColumnValues().iterator();
            while (colValues.hasNext()) {
                BasicDBObject updateQuery = new BasicDBObject();
                ArrayList row = (ArrayList)colValues.next();
                for (int i = 0; i < row.size(); ++i) {
                    if (((OneRowChange.ColumnVal)row.get(i)).getValue() == null) continue;
                    String value = ((OneRowChange.ColumnVal)row.get(i)).getValue().toString();
                    String name = ((OneRowChange.ColumnSpec)colSpecs.get(i)).getName();
                    logger.warn((Object)("IN insert-if Processing column  = " + name + " value =" + value));
                    if (name.equals("user_id")) {
                        updateQuery.put("userId", (Object)Long.valueOf(value));
                        continue;
                    }
                    if (name.equals("obj_type")) {
                        if (value.equals("people")) continue;
                        logger.warn((Object)"subscription is not people");
                        return;
                    }
                    if (name.equals("obj_id")) {
                        updateQuery.put("personId", (Object)Long.valueOf(value));
                        continue;
                    }
                    if (!name.equals("status") || value.isEmpty() || value.equals("sleep")) continue;
                    return;
                }
                updateQuery.put("date", (Object)new Date());
                logger.warn((Object)("Adding document: doc=" + updateQuery));
                coll.insert(new DBObject[]{updateQuery});
            }
        } else if (action.toString().equals("UPDATE")) {
            this.ensureIndexes(coll, orc);
            ArrayList keySpecs = orc.getKeySpec();
            ArrayList colSpecs = orc.getColumnSpec();
            ArrayList keyValues = orc.getKeyValues();
            ArrayList columnValues = orc.getColumnValues();
            for (int row = 0; row < columnValues.size() || row < keyValues.size(); ++row) {
                Object o;
                int i;
                List keyValuesOfRow = (List)keyValues.get(row);
                List colValuesOfRow = (List)columnValues.get(row);
                BasicDBObject updateQuery = new BasicDBObject();
                BasicDBObject updateCommand = new BasicDBObject();
                for (i = 0; i < keyValuesOfRow.size(); ++i) {
                    o = ((OneRowChange.ColumnVal)keyValuesOfRow.get(i)).getValue();
                    if (o == null) continue;
                    String value = o.toString();
                    String name = ((OneRowChange.ColumnSpec)keySpecs.get(i)).getName();
                    logger.error((Object)("Processing row update: column  = " + name + "  value = " + value));
                    if (name.equals("user_id")) {
                        updateQuery.put("userId", (Object)Long.valueOf(o.toString()));
                        updateCommand.put("userId", (Object)Long.valueOf(o.toString()));
                    }
                    if (name.equals("obj_type")) {
                        if (value.equals("people")) continue;
                        logger.warn((Object)"subscription is not on person");
                        return;
                    }
                    if (name.equals("obj_id")) {
                        updateQuery.put("personId", (Object)Long.valueOf(value));
                        continue;
                    }
                    if (!name.equals("status") || value.isEmpty() || value.equals("sleep")) continue;
                    return;
                }
                for (i = 0; i < colValuesOfRow.size(); ++i) {
                    o = ((OneRowChange.ColumnVal)colValuesOfRow.get(i)).getValue();
                    if (o == null) continue;
                    String name = ((OneRowChange.ColumnSpec)colSpecs.get(i)).getName();
                    String value = o.toString();
                    logger.error((Object)("Processing row update: column  = " + name + "  value = " + value));
                    if (!name.equals("obj_id")) continue;
                    updateCommand.put("personId", (Object)Long.valueOf(value));
                }
                updateCommand.put("date", (Object)new Date());
                logger.warn((Object)("Updating document: query=" + updateQuery + " doc=" + updateCommand));
                logger.warn((Object)("count " + coll.getCount((DBObject)updateQuery)));
                coll.remove((DBObject)updateQuery);
                coll.insert(new DBObject[]{updateCommand});
            }
        } else if (action.toString().equals("DELETE")) {
            ArrayList keySpecs = orc.getKeySpec();
            ArrayList colSpecs = orc.getColumnSpec();
            ArrayList keyValues = orc.getKeyValues();
            ArrayList columnValues = orc.getColumnValues();
            BasicDBObject updateQuery = new BasicDBObject();
            for (int row = 0; row < columnValues.size() || row < keyValues.size(); ++row) {
                List keyValuesOfRow = (List)keyValues.get(row);
                for (int i = 0; i < keyValuesOfRow.size(); ++i) {
                    Object o = ((OneRowChange.ColumnVal)keyValuesOfRow.get(i)).getValue();
                    if (o == null) continue;
                    String value = o.toString();
                    String name = ((OneRowChange.ColumnSpec)keySpecs.get(i)).getName();
                    logger.error((Object)("Processing row delete: column  = " + name + "  value = " + value));
                    if (name.equals("user_id")) {
                        updateQuery.put("userId", (Object)Long.valueOf(o.toString()));
                    }
                    if (name.equals("obj_type")) {
                        if (value.equals("people")) continue;
                        logger.warn((Object)"subscription is not on person");
                        return;
                    }
                    if (name.equals("obj_id")) {
                        updateQuery.put("personId", (Object)Long.valueOf(value));
                        continue;
                    }
                    if (!name.equals("status") || value.isEmpty() || value.equals("sleep")) continue;
                    return;
                }
            }
            coll.remove((DBObject)updateQuery);
            logger.warn((Object)("Deleting document: query=" + updateQuery));
        } else {
            logger.error((Object)("Unrecognized action type: " + action));
            return;
        }
    }

    private void changeUserSocial(RowChangeData.ActionType action, OneRowChange orc) throws ReplicatorException {
        DB db = this.m.getDB("kino-kp");
        DBCollection coll = db.getCollection("userProfile");
        if (action.toString().equals("INSERT")) {
            logger.warn((Object)("IN insert-if Processing row update: action=" + action + " schema=kino-kp table= userProfile"));
            ArrayList colSpecs = orc.getColumnSpec();
            Iterator colValues = orc.getColumnValues().iterator();
            while (colValues.hasNext()) {
                BasicDBObject doc = new BasicDBObject();
                BasicDBObject updateQuery = new BasicDBObject();
                BasicDBObject updateCommand = new BasicDBObject();
                ArrayList row = (ArrayList)colValues.next();
                for (int i = 0; i < row.size(); ++i) {
                    Object value = ((OneRowChange.ColumnVal)row.get(i)).getValue();
                    logger.warn((Object)("IN insert-if Processing row update: i=" + i + " column  = " + ((OneRowChange.ColumnSpec)colSpecs.get(i)).toString() + " value =" + value));
                    if (((OneRowChange.ColumnSpec)colSpecs.get(i)).getName().equals("user_id")) {
                        updateQuery.put("userId", (Object)Integer.valueOf(value.toString()));
                        logger.warn((Object)("IN insert-if SET user_id: i=" + i + " column  = " + ((OneRowChange.ColumnSpec)colSpecs.get(i)).toString() + " value =" + value));
                        continue;
                    }
                    if (!((OneRowChange.ColumnSpec)colSpecs.get(i)).getName().equals("social_url")) continue;
                    updateCommand.put("$addToSet", (Object)new BasicDBObject("oldKpUserProfile.userSocial", (Object)value.toString()));
                    logger.warn((Object)("IN insert-if SET friend_id: i=" + i + " column  = " + ((OneRowChange.ColumnSpec)colSpecs.get(i)).toString() + " value =" + value));
                }
                logger.warn((Object)(" count " + coll.count((DBObject)updateQuery)));
                logger.warn((Object)("obj" + coll.find((DBObject)updateQuery)));
                if (logger.isDebugEnabled()) {
                    logger.error((Object)("Adding document: doc=" + doc.toString()));
                }
                logger.warn((Object)("Updating document: query=" + updateQuery + "updCom = " + updateCommand));
                coll.update((DBObject)updateQuery, (DBObject)updateCommand);
            }
        } else if (action.toString().equals("UPDATE")) {
            this.ensureIndexes(coll, orc);
            BasicDBObject updateQuery = new BasicDBObject();
            ArrayList keySpecs = orc.getKeySpec();
            ArrayList colSpecs = orc.getColumnSpec();
            ArrayList keyValues = orc.getKeyValues();
            ArrayList columnValues = orc.getColumnValues();
            BasicDBObject pullObject = new BasicDBObject();
            for (int row = 0; row < columnValues.size() || row < keyValues.size(); ++row) {
                List keyValuesOfRow = (List)keyValues.get(row);
                List colValuesOfRow = (List)columnValues.get(row);
                String socialToInsert = "";
                for (int i = 0; i < keyValuesOfRow.size(); ++i) {
                    String value = ((OneRowChange.ColumnVal)keyValuesOfRow.get(i)).getValue().toString();
                    logger.warn((Object)("IN insert-if SET user_id: i=" + i + " column  = " + ((OneRowChange.ColumnSpec)keySpecs.get(i)).toString() + " value =" + value));
                    if (((OneRowChange.ColumnSpec)keySpecs.get(i)).getName().equals("user_id")) {
                        updateQuery.put("userId", (Object)Long.valueOf(value));
                        logger.warn((Object)("IN RE insert-if SET user_id: i=" + i + " column  = " + ((OneRowChange.ColumnSpec)keySpecs.get(i)).toString() + " value =" + value));
                    } else if (((OneRowChange.ColumnSpec)keySpecs.get(i)).getName().equals("social_type")) {
                        if (value.equals("vkontakte")) {
                            pullObject.put("$regex", (Object)".*vk\\.com.*");
                        } else if (value.equals("facebook")) {
                            pullObject.put("$regex", (Object)".*facebook\\.com.*");
                        } else if (value.equals("twitter")) {
                            pullObject.put("$regex", (Object)".*twitter\\..*");
                        } else {
                            pullObject.put("$regex", (Object)".*livejournal.*");
                        }
                        logger.warn((Object)("IN RE insert-if SET friend_id: i=" + i + " column  = " + ((OneRowChange.ColumnSpec)keySpecs.get(i)).toString() + " value =" + value));
                    } else if (((OneRowChange.ColumnSpec)keySpecs.get(i)).getName().equals("social_url")) {
                        socialToInsert = value;
                        logger.warn((Object)("IN RE insert-if SET friend_id: i=" + i + " column  = " + ((OneRowChange.ColumnSpec)keySpecs.get(i)).toString() + " value =" + value));
                    }
                    for (i = 0; i < colValuesOfRow.size(); ++i) {
                        value = ((OneRowChange.ColumnVal)colValuesOfRow.get(i)).getValue().toString();
                        if (((OneRowChange.ColumnSpec)colSpecs.get(i)).getName().equals("social_url")) {
                            socialToInsert = value;
                            logger.warn((Object)("IN RE insert-if SET friend_id: i=" + i + " column  = " + ((OneRowChange.ColumnSpec)colSpecs.get(i)).toString() + " value =" + value));
                            continue;
                        }
                        if (!((OneRowChange.ColumnSpec)keySpecs.get(i)).getName().equals("social_type")) continue;
                        if (value.equals("vkontakte")) {
                            pullObject.put("$regex", (Object)".*vk\\.com.*");
                        } else if (value.equals("facebook")) {
                            pullObject.put("$regex", (Object)".*facebook\\.com.*");
                        } else if (value.equals("twitter")) {
                            pullObject.put("$regex", (Object)".*twitter\\..*");
                        } else {
                            pullObject.put("$regex", (Object)".*livejournal.*");
                        }
                        logger.warn((Object)("IN RE insert-if SET friend_id: i=" + i + " column  = " + ((OneRowChange.ColumnSpec)keySpecs.get(i)).toString() + " value =" + value));
                    }
                }
                logger.warn((Object)("Updating document: query=" + updateQuery));
                coll.update((DBObject)updateQuery, (DBObject)new BasicDBObject("$pull", (Object)new BasicDBObject("oldKpUserProfile.userSocial", (Object)pullObject)));
                coll.update((DBObject)updateQuery, (DBObject)new BasicDBObject("$addToSet", (Object)new BasicDBObject("oldKpUserProfile.userSocial", (Object)socialToInsert)));
            }
        } else if (action.toString().equals("DELETE")) {
            BasicDBObject updateQuery = new BasicDBObject();
            BasicDBObject updateCommand = new BasicDBObject();
            this.ensureIndexes(coll, orc);
            ArrayList keySpecs = orc.getKeySpec();
            ArrayList colSpecs = orc.getColumnSpec();
            ArrayList keyValues = orc.getKeyValues();
            ArrayList columnValues = orc.getColumnValues();
            for (int row = 0; row < columnValues.size() || row < keyValues.size(); ++row) {
                List keyValuesOfRow = new ArrayList();
                if (row < keyValues.size()) {
                    keyValuesOfRow = (List)keyValues.get(row);
                }
                List colValuesOfRow = new ArrayList();
                if (row < columnValues.size()) {
                    colValuesOfRow = (List)columnValues.get(row);
                }
                BasicDBObject pullObject = new BasicDBObject();
                for (int i = 0; i < keyValuesOfRow.size(); ++i) {
                    String value = ((OneRowChange.ColumnVal)keyValuesOfRow.get(i)).getValue().toString();
                    logger.warn((Object)("IN delete-if  user_id: i=" + i + " column  = " + ((OneRowChange.ColumnSpec)keySpecs.get(i)).getName() + " value =" + value));
                    if (((OneRowChange.ColumnSpec)keySpecs.get(i)).getName().equals("user_id")) {
                        updateQuery.put("userId", (Object)Integer.valueOf(((OneRowChange.ColumnVal)keyValuesOfRow.get(i)).getValue().toString()));
                        logger.warn((Object)("IN real delete-if SET user_id: i=" + i + " column  = " + ((OneRowChange.ColumnSpec)keySpecs.get(i)).getName() + " value =" + ((OneRowChange.ColumnVal)keyValuesOfRow.get(i)).getValue()));
                    } else if (((OneRowChange.ColumnSpec)keySpecs.get(i)).getName().equals("social_type")) {
                        if (value.equals("vkontakte")) {
                            pullObject.put("$regex", (Object)".*vk\\.com.*");
                        } else if (value.equals("facebook")) {
                            pullObject.put("$regex", (Object)".*facebook\\.com.*");
                        } else if (value.equals("twitter")) {
                            pullObject.put("$regex", (Object)".*twitter\\..*");
                        } else {
                            pullObject.put("$regex", (Object)".*livejournal.*");
                        }
                        logger.warn((Object)("IN RE insert-if SET friend_id: i=" + i + " column  = " + ((OneRowChange.ColumnSpec)colSpecs.get(i)).toString() + " value =" + value));
                    }
                    logger.warn((Object)("Deleting document: query=" + updateQuery + " com = " + updateCommand));
                    coll.update((DBObject)updateQuery, (DBObject)new BasicDBObject("$pull", (Object)new BasicDBObject("oldKpUserProfile.userSocial", (Object)pullObject)));
                }
            }
        } else {
            logger.error((Object)("Unrecognized action type: " + action));
            return;
        }
    }

    private void changeExpectation(RowChangeData.ActionType action, OneRowChange orc) throws ReplicatorException {
        DB db = this.m.getDB("kino-kp");
        DBCollection coll = db.getCollection("expectation");
        if (action.toString().equals("INSERT")) {
            logger.warn((Object)("IN insert-if Processing row update: action=" + action + " schema=kino-kp table= userFriends"));
            ArrayList colSpecs = orc.getColumnSpec();
            Iterator colValues = orc.getColumnValues().iterator();
            while (colValues.hasNext()) {
                BasicDBObject doc = new BasicDBObject();
                BasicDBObject updateQuery = new BasicDBObject();
                ArrayList row = (ArrayList)colValues.next();
                for (int i = 0; i < row.size(); ++i) {
                    Object value = ((OneRowChange.ColumnVal)row.get(i)).getValue();
                    logger.warn((Object)("IN insert-if Processing row update: i=" + i + " column  = " + ((OneRowChange.ColumnSpec)colSpecs.get(i)).toString() + " value =" + value));
                    if (((OneRowChange.ColumnSpec)colSpecs.get(i)).getName().equals("user_id")) {
                        updateQuery.put("userId", (Object)Long.valueOf(value.toString()));
                        logger.warn((Object)("IN insert-if SET user_id: i=" + i + " column  = " + ((OneRowChange.ColumnSpec)colSpecs.get(i)).toString() + " value =" + value));
                        continue;
                    }
                    if (((OneRowChange.ColumnSpec)colSpecs.get(i)).getName().equals("id_film")) {
                        updateQuery.put("filmId", (Object)Integer.valueOf(value.toString()));
                        logger.warn((Object)("IN insert-if SET friend_id: i=" + i + " column  = " + ((OneRowChange.ColumnSpec)colSpecs.get(i)).toString() + " value =" + value));
                        continue;
                    }
                    if (((OneRowChange.ColumnSpec)colSpecs.get(i)).getName().equals("await")) {
                        updateQuery.put("type", (Object)(value.toString().equals("yes") ? "POSITIVE" : "NEGATIVE"));
                        logger.warn((Object)("IN insert-if SET friend_id: i=" + i + " column  = " + ((OneRowChange.ColumnSpec)colSpecs.get(i)).toString() + " value =" + value));
                        continue;
                    }
                    if (!((OneRowChange.ColumnSpec)colSpecs.get(i)).getName().equals("make_date")) continue;
                    updateQuery.put("date", (Object)new Date());
                    logger.warn((Object)("IN insert-if SET friend_id: i=" + i + " column  = " + ((OneRowChange.ColumnSpec)colSpecs.get(i)).toString() + " value =" + value));
                }
                if (logger.isDebugEnabled()) {
                    logger.error((Object)("Adding document: doc=" + doc.toString()));
                }
                coll.insert(new DBObject[]{updateQuery});
                logger.warn((Object)("IN insert" + updateQuery.toString()));
            }
        } else if (action.toString().equals("UPDATE")) {
            this.ensureIndexes(coll, orc);
            ArrayList keySpecs = orc.getKeySpec();
            ArrayList colSpecs = orc.getColumnSpec();
            ArrayList keyValues = orc.getKeyValues();
            ArrayList columnValues = orc.getColumnValues();
            for (int row = 0; row < columnValues.size() || row < keyValues.size(); ++row) {
                Object value;
                int i;
                List keyValuesOfRow = (List)keyValues.get(row);
                List colValuesOfRow = (List)columnValues.get(row);
                BasicDBObject updateQuery = new BasicDBObject();
                BasicDBObject updateCommand = new BasicDBObject();
                for (i = 0; i < keyValuesOfRow.size(); ++i) {
                    value = ((OneRowChange.ColumnVal)keyValuesOfRow.get(i)).getValue();
                    if (((OneRowChange.ColumnSpec)keySpecs.get(i)).getName().equals("user_id")) {
                        updateQuery.put("userId", (Object)Long.valueOf(value.toString()));
                        logger.warn((Object)("IN insert-if SET user_id: i=" + i + " column  = " + ((OneRowChange.ColumnSpec)colSpecs.get(i)).toString() + " value =" + value));
                        continue;
                    }
                    if (((OneRowChange.ColumnSpec)keySpecs.get(i)).getName().equals("id_film")) {
                        updateQuery.put("filmId", (Object)Integer.valueOf(value.toString()));
                        logger.warn((Object)("IN insert-if SET friend_id: i=" + i + " column  = " + ((OneRowChange.ColumnSpec)colSpecs.get(i)).toString() + " value =" + value));
                        continue;
                    }
                    if (!((OneRowChange.ColumnSpec)keySpecs.get(i)).getName().equals("await")) continue;
                    updateQuery.put("type", (Object)(value.toString().equals("yes") ? "POSITIVE" : "NEGATIVE"));
                    logger.warn((Object)("IN insert-if SET friend_id: i=" + i + " column  = " + ((OneRowChange.ColumnSpec)colSpecs.get(i)).toString() + " value =" + value));
                }
                for (i = 0; i < colValuesOfRow.size(); ++i) {
                    value = ((OneRowChange.ColumnVal)colValuesOfRow.get(i)).getValue();
                    if (((OneRowChange.ColumnSpec)colSpecs.get(i)).getName().equals("user_id")) {
                        updateCommand.put("userId", (Object)Long.valueOf(value.toString()));
                        continue;
                    }
                    if (((OneRowChange.ColumnSpec)colSpecs.get(i)).getName().equals("id_film")) {
                        updateCommand.put("filmId", (Object)Integer.valueOf(value.toString()));
                        continue;
                    }
                    if (((OneRowChange.ColumnSpec)colSpecs.get(i)).getName().equals("await")) {
                        updateCommand.put("type", (Object)(value.toString().equals("yes") ? "POSITIVE" : "NEGATIVE"));
                        continue;
                    }
                    if (!((OneRowChange.ColumnSpec)colSpecs.get(i)).getName().equals("make_date")) continue;
                    updateCommand.put("date", (Object)new Date());
                }
                logger.warn((Object)("Updating document: query=" + updateQuery + " doc=" + updateCommand));
                logger.warn((Object)("count " + coll.getCount((DBObject)updateQuery)));
                coll.update((DBObject)updateQuery, (DBObject)new BasicDBObject("$set", (Object)updateCommand));
            }
        } else if (action.toString().equals("DELETE")) {
            BasicDBObject updateQuery = new BasicDBObject();
            this.ensureIndexes(coll, orc);
            logger.warn((Object)("IN delete-if Processing row update: action=" + action + " schema=kino-kp table= userFriends"));
            ArrayList keySpecs = orc.getKeySpec();
            ArrayList keyValues = orc.getKeyValues();
            for (int row = 0; row < keyValues.size(); ++row) {
                List keyValuesOfRow = (List)keyValues.get(row);
                for (int i = 0; i < keyValuesOfRow.size(); ++i) {
                    if (((OneRowChange.ColumnSpec)keySpecs.get(i)).getName().equals("user_id")) {
                        updateQuery.put("userId", (Object)Long.valueOf(((OneRowChange.ColumnVal)keyValuesOfRow.get(i)).getValue().toString()));
                        continue;
                    }
                    if (!((OneRowChange.ColumnSpec)keySpecs.get(i)).getName().equals("id_film")) continue;
                    updateQuery.put("filmId", (Object)Integer.valueOf(((OneRowChange.ColumnVal)keyValuesOfRow.get(i)).getValue().toString()));
                }
                coll.remove((DBObject)updateQuery);
            }
            logger.warn((Object)(" deleted obj with query " + updateQuery));
        } else {
            logger.error((Object)("Unrecognized action type: " + action));
        }
    }

    private void changeUserFriends(RowChangeData.ActionType action, OneRowChange orc) throws ReplicatorException {
        if (action.toString().equals("INSERT")) {
            logger.warn((Object)("IN insert-if Processing row update: action=" + action + " schema=kino-kp table= userFriends"));
            ArrayList colSpecs = orc.getColumnSpec();
            Iterator colValues = orc.getColumnValues().iterator();
            while (colValues.hasNext()) {
                BasicDBObject updateQuery = new BasicDBObject();
                BasicDBObject updateCommand = new BasicDBObject();
                BasicDBObject fanQuery = new BasicDBObject();
                BasicDBObject fanCommand = new BasicDBObject();
                ArrayList row = (ArrayList)colValues.next();
                for (int i = 0; i < row.size(); ++i) {
                    Object o = ((OneRowChange.ColumnVal)row.get(i)).getValue();
                    if (o == null) {
                        return;
                    }
                    String value = o.toString();
                    String name = ((OneRowChange.ColumnSpec)colSpecs.get(i)).getName();
                    logger.warn((Object)("update: i=" + i + " column  = " + name + " value =" + value));
                    if (name.equals("user_id")) {
                        OneRowChange.ColumnSpec c = (OneRowChange.ColumnSpec)colSpecs.get(i);
                        c.setName("userId");
                        updateQuery.put("userId", (Object)Integer.valueOf(value));
                        fanCommand.put("$addToSet", (Object)new BasicDBObject("connectedUsersIds", (Object)Integer.valueOf(value)));
                        continue;
                    }
                    if (!name.equals("friend_id")) continue;
                    updateCommand.put("$addToSet", (Object)new BasicDBObject("connectedUsersIds", (Object)Integer.valueOf(value)));
                    fanQuery.put("userId", (Object)Integer.valueOf(value));
                }
                DB db = this.m.getDB("kino-kp");
                DBCollection coll = db.getCollection("userFriends");
                this.ensureIndexes(coll, orc);
                coll.update((DBObject)updateQuery, (DBObject)updateCommand, true, true);
                coll = db.getCollection("userFans");
                this.ensureIndexes(coll, orc);
                logger.warn((Object)(" q = " + fanQuery + " com = " + fanCommand));
                coll.update((DBObject)fanQuery, (DBObject)fanCommand, true, true);
            }
        } else if (!action.toString().equals("UPDATE")) {
            if (action.toString().equals("DELETE")) {
                BasicDBObject updateQuery = new BasicDBObject();
                BasicDBObject updateCommand = new BasicDBObject();
                BasicDBObject fanQuery = new BasicDBObject();
                BasicDBObject fanCommand = new BasicDBObject();
                ArrayList keySpecs = orc.getKeySpec();
                ArrayList keyValues = orc.getKeyValues();
                ArrayList columnValues = orc.getColumnValues();
                for (int row = 0; row < columnValues.size() || row < keyValues.size(); ++row) {
                    List keyValuesOfRow = (List)keyValues.get(row);
                    BasicDBObject query = new BasicDBObject();
                    for (int i = 0; i < keyValuesOfRow.size(); ++i) {
                        OneRowChange.ColumnSpec c;
                        if (((OneRowChange.ColumnSpec)keySpecs.get(i)).getName().equals("user_id")) {
                            c = (OneRowChange.ColumnSpec)keySpecs.get(i);
                            c.setName("userId");
                            updateQuery.put("userId", (Object)Integer.valueOf(((OneRowChange.ColumnVal)keyValuesOfRow.get(i)).getValue().toString()));
                            fanCommand.put("$pull", (Object)new BasicDBObject("connectedUsersIds", (Object)Integer.valueOf(((OneRowChange.ColumnVal)keyValuesOfRow.get(i)).getValue().toString())));
                            continue;
                        }
                        if (!((OneRowChange.ColumnSpec)keySpecs.get(i)).getName().equals("friend_id")) continue;
                        c = (OneRowChange.ColumnSpec)keySpecs.get(i);
                        c.setName("friendId");
                        updateCommand.put("$pull", (Object)new BasicDBObject("connectedUsersIds", (Object)Integer.valueOf(((OneRowChange.ColumnVal)keyValuesOfRow.get(i)).getValue().toString())));
                        fanQuery.put("userId", (Object)Integer.valueOf(((OneRowChange.ColumnVal)keyValuesOfRow.get(i)).getValue().toString()));
                        logger.warn((Object)("IN real delete-if SET user_id: i=" + i + " column  = " + ((OneRowChange.ColumnSpec)keySpecs.get(i)).getName() + " value =" + ((OneRowChange.ColumnVal)keyValuesOfRow.get(i)).getValue()));
                    }
                    DB db = this.m.getDB("kino-kp");
                    DBCollection coll = db.getCollection("userFriends");
                    this.ensureIndexes(coll, orc);
                    logger.warn((Object)coll.update((DBObject)updateQuery, (DBObject)updateCommand, true, true));
                    coll = db.getCollection("userFans");
                    this.ensureIndexes(coll, orc);
                    logger.warn((Object)coll.update((DBObject)fanQuery, (DBObject)fanCommand, true, true));
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Deleting document: query=" + query));
                    }
                    DBObject deletedRow = coll.findAndRemove((DBObject)query);
                    if (!logger.isDebugEnabled()) continue;
                    if (deletedRow == null) {
                        logger.error((Object)"Unable to find document for delete");
                        continue;
                    }
                    logger.error((Object)("Documented deleted: doc=" + deletedRow));
                }
            } else {
                logger.error((Object)("Unrecognized action type: " + action));
                return;
            }
        }
    }

    private void changeUserLastVisit(RowChangeData.ActionType action, OneRowChange orc) throws ReplicatorException {
        DB db = this.m.getDB("kino-kp");
        DBCollection coll = db.getCollection("userProfile");
        if (action.toString().equals("INSERT")) {
            logger.warn((Object)("IN insert-if Processing row update: action=" + action + " schema=kino-kp table= userFriends"));
            ArrayList colSpecs = orc.getColumnSpec();
            Iterator colValues = orc.getColumnValues().iterator();
            while (colValues.hasNext()) {
                BasicDBObject updateQuery = new BasicDBObject();
                BasicDBObject updateCommand = new BasicDBObject();
                ArrayList row = (ArrayList)colValues.next();
                for (int i = 0; i < row.size(); ++i) {
                    Object value = ((OneRowChange.ColumnVal)row.get(i)).getValue();
                    logger.warn((Object)("IN insert-if Processing row update: i=" + i + " column  = " + ((OneRowChange.ColumnSpec)colSpecs.get(i)).toString() + " value =" + value));
                    if (!((OneRowChange.ColumnSpec)colSpecs.get(i)).getName().equals("user_id")) continue;
                    updateQuery.put("userId", (Object)Long.valueOf(value.toString()));
                    updateCommand.put("oldKpUserProfile.lastVisit", (Object)new Date());
                    logger.warn((Object)("IN insert-if SET user_id: i=" + i + " column  = " + ((OneRowChange.ColumnSpec)colSpecs.get(i)).toString() + " value =" + value));
                }
                coll.update((DBObject)updateQuery, (DBObject)new BasicDBObject("$set", (Object)updateCommand));
                logger.warn((Object)("IN insert" + updateQuery.toString()));
            }
        } else if (action.toString().equals("UPDATE")) {
            this.ensureIndexes(coll, orc);
            ArrayList keySpecs = orc.getKeySpec();
            ArrayList colSpecs = orc.getColumnSpec();
            ArrayList keyValues = orc.getKeyValues();
            ArrayList columnValues = orc.getColumnValues();
            for (int row = 0; row < columnValues.size() || row < keyValues.size(); ++row) {
                List keyValuesOfRow = (List)keyValues.get(row);
                List colValuesOfRow = (List)columnValues.get(row);
                BasicDBObject updateQuery = new BasicDBObject();
                BasicDBObject updateCommand = new BasicDBObject();
                for (int i = 0; i < keyValuesOfRow.size(); ++i) {
                    Object value = ((OneRowChange.ColumnVal)keyValuesOfRow.get(i)).getValue();
                    if (!((OneRowChange.ColumnSpec)keySpecs.get(i)).getName().equals("user_id")) continue;
                    updateQuery.put("userId", (Object)Long.valueOf(value.toString()));
                    updateCommand.put("oldKpUserProfile.lastVisit", (Object)new Date());
                    logger.warn((Object)("IN insert-if SET user_id: i=" + i + " column  = " + ((OneRowChange.ColumnSpec)colSpecs.get(i)).toString() + " value =" + value));
                }
                logger.warn((Object)("Updating document: query=" + updateQuery + " doc=" + updateCommand));
                logger.warn((Object)("count " + coll.getCount((DBObject)updateQuery)));
                coll.update((DBObject)updateQuery, (DBObject)new BasicDBObject("$set", (Object)updateCommand));
            }
        } else if (!action.toString().equals("DELETE")) {
            logger.error((Object)("Unrecognized action type: " + action));
            return;
        }
    }

    private void changeUserProfile(RowChangeData.ActionType action, OneRowChange orc) throws ReplicatorException {
        DB db = this.m.getDB("kino-kp");
        DBCollection coll = db.getCollection("userProfile");
        if (action.toString().equals("INSERT")) {
            logger.warn((Object)("IN insert-if Processing row update: action=" + action + " schema=kino-kp table= userFriends"));
            ArrayList colSpecs = orc.getColumnSpec();
            Iterator colValues = orc.getColumnValues().iterator();
            while (colValues.hasNext()) {
                BasicDBObject updateQuery = new BasicDBObject();
                BasicDBObject oldKpUserProfile = new BasicDBObject();
                ArrayList row = (ArrayList)colValues.next();
                for (int i = 0; i < row.size(); ++i) {
                    if (((OneRowChange.ColumnVal)row.get(i)).getValue() == null) continue;
                    String value = ((OneRowChange.ColumnVal)row.get(i)).getValue().toString();
                    String name = ((OneRowChange.ColumnSpec)colSpecs.get(i)).getName();
                    logger.warn((Object)("IN insert-if Processing column  = " + name + " value =" + value));
                    if (name.equals("user_id")) {
                        updateQuery.put("userId", (Object)Long.valueOf(value));
                        continue;
                    }
                    if (name.equals("login")) {
                        updateQuery.put("displayName", (Object)value);
                        continue;
                    }
                    if (name.equals("password")) {
                        oldKpUserProfile.put("password", (Object)value);
                        continue;
                    }
                    if (name.equals("email")) {
                        oldKpUserProfile.put("email", (Object)value);
                        continue;
                    }
                    if (name.equals("new_email")) {
                        oldKpUserProfile.put("newEmail", (Object)value);
                        continue;
                    }
                    if (name.equals("birth_date")) {
                        oldKpUserProfile.put("birth", (Object)new DateTime((Object)String.format("%sT00:00:00Z", value)).toDate());
                        continue;
                    }
                    if (name.equals("reg_key")) {
                        oldKpUserProfile.put("regKey", (Object)value);
                        continue;
                    }
                    if (name.equals("film")) {
                        oldKpUserProfile.put("favoriteFilm", (Object)value);
                        continue;
                    }
                    if (name.equals("image")) {
                        oldKpUserProfile.put("image", (Object)value);
                        continue;
                    }
                    if (name.equals("first_name")) {
                        oldKpUserProfile.put("firstName", (Object)value);
                        continue;
                    }
                    if (!name.equals("last_name")) continue;
                    oldKpUserProfile.put("lastName", (Object)value);
                }
                updateQuery.put("oldKpUserProfile", (Object)oldKpUserProfile);
                logger.warn((Object)("Adding document: doc=" + updateQuery));
                coll.insert(new DBObject[]{updateQuery});
            }
        } else if (action.toString().equals("UPDATE")) {
            this.ensureIndexes(coll, orc);
            ArrayList keySpecs = orc.getKeySpec();
            ArrayList colSpecs = orc.getColumnSpec();
            ArrayList keyValues = orc.getKeyValues();
            ArrayList columnValues = orc.getColumnValues();
            for (int row = 0; row < columnValues.size() || row < keyValues.size(); ++row) {
                Object o;
                int i;
                List keyValuesOfRow = (List)keyValues.get(row);
                List colValuesOfRow = (List)columnValues.get(row);
                BasicDBObject updateQuery = new BasicDBObject();
                BasicDBObject updateCommand = new BasicDBObject();
                for (i = 0; i < keyValuesOfRow.size(); ++i) {
                    o = ((OneRowChange.ColumnVal)keyValuesOfRow.get(i)).getValue();
                    if (o == null) continue;
                    String value = o.toString();
                    String name = ((OneRowChange.ColumnSpec)keySpecs.get(i)).getName();
                    logger.error((Object)("Processing row update: column  = " + name + "  value = " + value));
                    if (name.equals("user_id")) {
                        updateQuery.put("userId", (Object)Long.valueOf(o.toString()));
                        continue;
                    }
                    if (name.equals("login")) {
                        updateQuery.put("displayName", (Object)value);
                        continue;
                    }
                    if (name.equals("password")) {
                        updateQuery.put("oldKpUserProfile.password", (Object)o.toString());
                        continue;
                    }
                    if (name.equals("email")) {
                        updateQuery.put("oldKpUserProfile.email", (Object)o.toString());
                        continue;
                    }
                    if (name.equals("new_email")) {
                        updateQuery.put("oldKpUserProfile.newEmail", (Object)o.toString());
                        continue;
                    }
                    if (name.equals("birth_date")) {
                        updateQuery.put("oldKpUserProfile.birth", (Object)new DateTime((Object)String.format("%sT00:00:00Z", value)).toDate());
                        continue;
                    }
                    if (name.equals("reg_key")) {
                        updateQuery.put("oldKpUserProfile.regKey", (Object)o.toString());
                        continue;
                    }
                    if (name.equals("film")) {
                        updateQuery.put("oldKpUserProfile.favoriteFilm", (Object)value);
                        continue;
                    }
                    if (name.equals("image")) {
                        updateQuery.put("oldKpUserProfile.image", (Object)o.toString());
                        continue;
                    }
                    if (name.equals("first_name")) {
                        updateQuery.put("oldKpUserProfile.firstName", (Object)value);
                        continue;
                    }
                    if (!name.equals("last_name")) continue;
                    updateQuery.put("oldKpUserProfile.lastName", (Object)value);
                }
                for (i = 0; i < colValuesOfRow.size(); ++i) {
                    o = ((OneRowChange.ColumnVal)colValuesOfRow.get(i)).getValue();
                    if (o == null) continue;
                    String name = ((OneRowChange.ColumnSpec)colSpecs.get(i)).getName();
                    String value = o.toString();
                    if (name.equals("login")) {
                        updateCommand.put("displayName", (Object)o.toString());
                        continue;
                    }
                    if (name.equals("password")) {
                        updateCommand.put("oldKpUserProfile.password", (Object)value);
                        continue;
                    }
                    if (name.equals("email")) {
                        updateCommand.put("oldKpUserProfile.email", (Object)value);
                        continue;
                    }
                    if (name.equals("new_email")) {
                        updateCommand.put("oldKpUserProfile.newEmail", (Object)value);
                        continue;
                    }
                    if (name.equals("birth_date")) {
                        updateCommand.put("oldKpUserProfile.birth", (Object)new DateTime((Object)String.format("%sT00:00:00Z", value)).toDate());
                        continue;
                    }
                    if (name.equals("reg_key")) {
                        updateCommand.put("oldKpUserProfile.regKey", (Object)value);
                        continue;
                    }
                    if (name.equals("film")) {
                        updateCommand.put("oldKpUserProfile.favoriteFilm", (Object)value);
                        continue;
                    }
                    if (name.equals("image")) {
                        updateCommand.put("oldKpUserProfile.image", (Object)value);
                        continue;
                    }
                    if (name.equals("first_name")) {
                        updateCommand.put("oldKpUserProfile.firstName", (Object)value);
                        continue;
                    }
                    if (!name.equals("last_name")) continue;
                    updateCommand.put("oldKpUserProfile.lastName", (Object)value);
                }
                logger.error((Object)("Updating document: query=" + updateQuery + " doc=" + updateCommand));
                logger.error((Object)("count " + coll.getCount((DBObject)updateQuery)));
                coll.update((DBObject)updateQuery, (DBObject)new BasicDBObject("$set", (Object)updateCommand));
            }
        } else if (!action.toString().equals("DELETE")) {
            logger.error((Object)("Unrecognized action type: " + action));
            return;
        }
    }

    private void setValue(DBObject doc, OneRowChange.ColumnSpec columnSpec, Object value) throws ReplicatorException {
        String name = columnSpec.getName();
        if (value == null) {
            doc.put(name, value);
        } else if (value instanceof SerialBlob) {
            doc.put(name, (Object)this.deserializeBlob(name, (SerialBlob)value));
        } else if (columnSpec.getType() == 92) {
            if (value instanceof Timestamp) {
                Timestamp timestamp = (Timestamp)value;
                StringBuffer time = new StringBuffer(new Time(timestamp.getTime()).toString());
                if (timestamp.getNanos() > 0) {
                    time.append(".");
                    time.append(String.format("%09d", timestamp.getNanos()));
                }
                doc.put(name, (Object)time.toString());
            } else {
                Time t = (Time)value;
                doc.put(name, (Object)t.toString());
            }
        } else {
            doc.put(name, (Object)value.toString());
        }
    }

    private void ensureIndexes(DBCollection coll, OneRowChange orc) {
        String table;
        String schema;
        Table t;
        if (this.autoIndex && (t = this.tableMetadataCache.retrieve(schema = orc.getSchemaName(), table = orc.getTableName())) == null) {
            ArrayList keySpecs;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Ensuring index exists on collection: db=" + schema + " collection=" + table));
            }
            if ((keySpecs = orc.getKeySpec()).size() > 0) {
                BasicDBObjectBuilder builder = BasicDBObjectBuilder.start();
                for (OneRowChange.ColumnSpec keySpec : keySpecs) {
                    builder.add(keySpec.getName(), (Object)1);
                }
                coll.ensureIndex(builder.get());
            }
            t = new Table(schema, table);
            this.tableMetadataCache.store(t);
        }
    }

    private String deserializeBlob(String name, SerialBlob blob) throws ReplicatorException {
        try {
            long length = blob.length();
            if (length > 0L) {
                byte[] byteArray = blob.getBytes(1L, (int)length);
                String value = new String(byteArray);
                return value;
            }
            return "";
        }
        catch (SerialException e) {
            throw new ReplicatorException("Unable to deserialize blob value: column=" + name, (Throwable)e);
        }
    }

    public void commit() throws ReplicatorException, InterruptedException {
        if (this.latestHeader == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Unable to commit; last header is null");
            }
            return;
        }
        DB db = this.m.getDB(this.serviceSchema);
        DBCollection trepCommitSeqno = db.getCollection("trep_commit_seqno");
        BasicDBObject query = new BasicDBObject();
        query.put("task_id", (Object)this.taskId);
        BasicDBObject doc = new BasicDBObject();
        doc.put("task_id", (Object)this.taskId);
        doc.put("seqno", (Object)this.latestHeader.getSeqno());
        doc.put("fragno", (Object)this.latestHeader.getFragno());
        doc.put("last_frag", (Object)this.latestHeader.getLastFrag());
        doc.put("source_id", (Object)this.latestHeader.getSourceId());
        doc.put("epoch_number", (Object)this.latestHeader.getEpochNumber());
        doc.put("event_id", (Object)this.latestHeader.getEventId());
        doc.put("extract_timestamp", (Object)this.latestHeader.getExtractedTstamp().getTime());
        DBObject updatedDoc = trepCommitSeqno.findAndModify((DBObject)query, null, null, false, (DBObject)doc, true, true);
        if (logger.isDebugEnabled()) {
            if (updatedDoc == null) {
                logger.debug((Object)("Unable to update/insert trep_commit_seqno: query=" + query + " doc=" + doc));
            } else {
                logger.debug((Object)("Trep_commit_seqno updated: updatedDoc=" + updatedDoc));
            }
        }
    }

    public ReplDBMSHeader getLastEvent() throws ReplicatorException, InterruptedException {
        DB db = this.m.getDB(this.serviceSchema);
        DBCollection trepCommitSeqno = db.getCollection("trep_commit_seqno");
        BasicDBObject query = new BasicDBObject();
        query.put("task_id", (Object)this.taskId);
        DBObject doc = trepCommitSeqno.findOne((DBObject)query);
        if (doc == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("trep_commit_seqno is empty: taskId=" + this.taskId));
            }
            return null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("trep_commit_seqno entry found: doc=" + doc));
        }
        long seqno = (Long)doc.get("seqno");
        int fragno = (Integer)doc.get("fragno");
        boolean lastFrag = (Boolean)doc.get("last_frag");
        String sourceId = (String)doc.get("source_id");
        long epochNumber = (Long)doc.get("epoch_number");
        String eventId = (String)doc.get("event_id");
        String shardId = (String)doc.get("shard_id");
        long extractTimestamp = (Long)doc.get("extract_timestamp");
        ReplDBMSHeaderData header = new ReplDBMSHeaderData(seqno, (short)fragno, lastFrag, sourceId, epochNumber, eventId, shardId, new Timestamp(extractTimestamp), 0L);
        return header;
    }

    public void rollback() throws InterruptedException {
    }

    public void setTaskId(int id) {
        this.taskId = id;
    }

    public void configure(PluginContext context) throws ReplicatorException, InterruptedException {
        this.serviceSchema = "tungsten_" + context.getServiceName();
    }

    public void prepare(PluginContext context) throws ReplicatorException, InterruptedException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Connecting to MongoDB: connectString=" + this.connectString));
        }
        this.m = null;
        try {
            this.m = this.connectString == null ? new Mongo() : new Mongo(this.connectString);
        }
        catch (Exception e) {
            throw new ReplicatorException("Unable to connect to MongoDB: connection=" + this.connectString, (Throwable)e);
        }
        this.tableMetadataCache = new TableMetadataCache(5000);
    }

    public void release(PluginContext context) throws ReplicatorException, InterruptedException {
        if (this.m != null) {
            this.m.close();
            this.m = null;
        }
        if (this.tableMetadataCache != null) {
            this.tableMetadataCache.invalidateAll();
            this.tableMetadataCache = null;
        }
    }
}

