/*
 * Decompiled with CFR 0.152.
 */
package com.ganji.tungsten.replicator.applier;

import com.continuent.tungsten.replicator.ReplicatorException;
import com.continuent.tungsten.replicator.applier.ApplierException;
import com.continuent.tungsten.replicator.applier.RawApplier;
import com.continuent.tungsten.replicator.consistency.ConsistencyException;
import com.continuent.tungsten.replicator.dbms.DBMSData;
import com.continuent.tungsten.replicator.dbms.LoadDataFileFragment;
import com.continuent.tungsten.replicator.dbms.OneRowChange;
import com.continuent.tungsten.replicator.dbms.RowChangeData;
import com.continuent.tungsten.replicator.dbms.RowIdData;
import com.continuent.tungsten.replicator.dbms.StatementData;
import com.continuent.tungsten.replicator.event.DBMSEmptyEvent;
import com.continuent.tungsten.replicator.event.DBMSEvent;
import com.continuent.tungsten.replicator.event.ReplDBMSHeader;
import com.continuent.tungsten.replicator.extractor.mysql.SerialBlob;
import com.continuent.tungsten.replicator.plugin.PluginContext;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.sql.rowset.serial.SerialException;
import org.apache.log4j.Logger;
import org.json.simple.JSONObject;

public abstract class RowDataApplier
implements RawApplier {
    private static Logger logger = Logger.getLogger(RowDataApplier.class);
    protected ReplDBMSHeader latestHeader;
    protected static int ACTION_INSERT = 0;
    protected static int ACTION_UPDATE = 1;
    protected static int ACTION_DELETE = 2;

    public void apply(DBMSEvent event, ReplDBMSHeader header, boolean doCommit, boolean doRollback) throws ReplicatorException, ConsistencyException, InterruptedException {
        ArrayList dbmsDataValues = event.getData();
        if (this.latestHeader != null && this.latestHeader.getLastFrag() && this.latestHeader.getSeqno() >= header.getSeqno() && !(event instanceof DBMSEmptyEvent)) {
            logger.info((Object)("Skipping over previously applied event: seqno=" + header.getSeqno() + " fragno=" + header.getFragno()));
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Applying event: seqno=" + header.getSeqno() + " fragno=" + header.getFragno() + " commit=" + doCommit));
        }
        for (DBMSData dbmsData : dbmsDataValues) {
            if (dbmsData instanceof StatementData) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)"Ignoring statement");
                continue;
            }
            if (dbmsData instanceof RowChangeData) {
                RowChangeData rd = (RowChangeData)dbmsData;
                for (OneRowChange orc : rd.getRowChanges()) {
                    String value;
                    String name;
                    int row;
                    ArrayList columnValues;
                    ArrayList keyValues;
                    ArrayList colSpecs;
                    RowChangeData.ActionType action = orc.getAction();
                    String schema = orc.getSchemaName();
                    String table = orc.getTableName();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Processing row update: action=" + action + " schema=" + schema + " table=" + table));
                    }
                    if (action.equals((Object)RowChangeData.ActionType.INSERT)) {
                        colSpecs = orc.getColumnSpec();
                        Iterator colValues = orc.getColumnValues().iterator();
                        while (colValues.hasNext()) {
                            JSONObject doc = new JSONObject();
                            ArrayList row2 = (ArrayList)colValues.next();
                            for (int i = 0; i < row2.size(); ++i) {
                                String name2 = ((OneRowChange.ColumnSpec)colSpecs.get(i)).getName();
                                String value2 = this.ColValue2String((OneRowChange.ColumnSpec)colSpecs.get(i), (OneRowChange.ColumnVal)row2.get(i));
                                doc.put((Object)name2, (Object)value2);
                            }
                            this.onRowData(schema, table, ACTION_INSERT, doc, event.getSourceTstamp());
                        }
                        continue;
                    }
                    if (action.equals((Object)RowChangeData.ActionType.UPDATE)) {
                        colSpecs = orc.getColumnSpec();
                        keyValues = orc.getKeyValues();
                        columnValues = orc.getColumnValues();
                        for (row = 0; row < columnValues.size() || row < keyValues.size(); ++row) {
                            JSONObject doc = new JSONObject();
                            List colValuesOfRow = (List)columnValues.get(row);
                            for (int i = 0; i < colValuesOfRow.size(); ++i) {
                                name = ((OneRowChange.ColumnSpec)colSpecs.get(i)).getName();
                                value = this.ColValue2String((OneRowChange.ColumnSpec)colSpecs.get(i), (OneRowChange.ColumnVal)colValuesOfRow.get(i));
                                doc.put((Object)name, (Object)value);
                            }
                            this.onRowData(schema, table, ACTION_UPDATE, doc, event.getSourceTstamp());
                        }
                        continue;
                    }
                    if (action.equals((Object)RowChangeData.ActionType.DELETE)) {
                        ArrayList keySpecs = orc.getKeySpec();
                        keyValues = orc.getKeyValues();
                        columnValues = orc.getColumnValues();
                        for (row = 0; row < columnValues.size() || row < keyValues.size(); ++row) {
                            List keyValuesOfRow = (List)keyValues.get(row);
                            JSONObject doc = new JSONObject();
                            for (int i = 0; i < keyValuesOfRow.size(); ++i) {
                                name = ((OneRowChange.ColumnSpec)keySpecs.get(i)).getName();
                                value = this.ColValue2String((OneRowChange.ColumnSpec)keySpecs.get(i), (OneRowChange.ColumnVal)keyValuesOfRow.get(i));
                                doc.put((Object)name, (Object)value);
                            }
                            this.onRowData(schema, table, ACTION_DELETE, doc, event.getSourceTstamp());
                        }
                        continue;
                    }
                    logger.warn((Object)("Unrecognized action type: " + action));
                    return;
                }
                continue;
            }
            if (dbmsData instanceof LoadDataFileFragment) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)"Ignoring load data file fragment");
                continue;
            }
            if (dbmsData instanceof RowIdData) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)"Ignoring row ID data");
                continue;
            }
            logger.warn((Object)("Unsupported DbmsData class: " + dbmsData.getClass().getName()));
        }
        this.latestHeader = header;
        if (doCommit) {
            this.commit();
        }
    }

    protected abstract void onRowData(String var1, String var2, int var3, JSONObject var4, Timestamp var5) throws ApplierException;

    public void release(PluginContext arg0) throws ReplicatorException, InterruptedException {
    }

    private String ColValue2String(OneRowChange.ColumnSpec cspec, OneRowChange.ColumnVal cvalue) {
        String value;
        if (cvalue.getValue() == null) {
            return null;
        }
        if (cspec.getType() == 12) {
            value = new String((byte[])cvalue.getValue());
        } else if (cspec.getType() == 2004) {
            SerialBlob blob = (SerialBlob)cvalue.getValue();
            try {
                value = new String(blob.getBytes(1L, (int)blob.length()));
            }
            catch (SerialException e) {
                value = "ERROR";
            }
        } else {
            value = cvalue.getValue() != null ? cvalue.getValue().toString() : null;
        }
        return value;
    }
}

