# coding: utf-8
# vim: sw=4 ts=4 expandtab ai

# Путь к lock файлу
LOCK = '/var/lock/yabs-chkdisk.lock'

# Путь к файлу лога
LOG = '/var/log/yabs-chkdisk.log'

# Уровень лога. NOTSET=0; DEBUG=10; INFO=20; WARNING=30; ERROR=40; CRITICAL=50
LOGLEVEL = 10

# Путь к базе данных
DBPATH = '/var/lib/yabs-chkdisk'

# Если этот файлик будет существовать, то chkdisk не будет запускаться.
# Можно использовать для временного или полного выключения данного сервиса.
NOACTIONFLAG = '/etc/yabs-chkdisk-stop'

# Лимит разницы между объемом старого и нового диска в байтах при котором
# допустимо использование такого диска Естественно объем нового диска должен
# быть больше чем старого. По умолчанию выставляем разницу в 22Гб - это разница
# между SAS дисками производителей в 300*1000^3 байт и 300*1024^3 байт
DISK_CPM_LIMIT = 22122547200

# Параметры для отправки запроса в бот:
# initiator -- автор заявки. Обычно это логин сотрудника, либо общее название
# проекта машинок (к примеру search).
# email = yes -- в этом случае заявка будет продублирована письмом на help@
# comment -- комментарий к заявке. При отправке заявки к концу этого поля будет
# добавлен hostname.
# replyto -- по данному обратному адресу электронной почты будет сообщаться о
# результатах выполнения задачи.
# needcall -- в тикете в OTRS будет поставлена пометка "позвонить ответственному перед выполнением заявки"
BOT_REMOVE_DISK_PARAMS = { 'initiator' : 'kp-admin', 'replyto' : 'kp-admin@yandex-team.ru', 'email' : 'yes', 'comment' : 'Generated by yabs-chkdisk on ', }
# Кол-во попыток отправить в бот запрос на замену диска
BOT_REMOVE_DISK_TRY_COUNT = 30
# Таймаут в секундах, проходящий между попытками отправить запрос на замену диска в бот.
BOT_REMOVE_DISK_TRY_TIMEOUT = 300
# Резервные адреса для отправки запроса на замену почтой - если через бот не получается.
BKP_DST_MAIL = ['helpdc@yandex-team.ru', 'kp-admin@yandex-team.ru']
BKP_SRC_MAIL = 'kp-admin@yandex-team.ru'

# Кол-во одновременно извлекаемых дисков. Во избежании накладок это будет
# только один диск. Работа при большем значении счетчика не тестировалась.
RM_DISK_COUNT = 1

# Временной интервал, в который диски будут добавляться к деградированным рэйдам.
# Выбирается из времени наименьшей загруженности дисков, т к процесс синхронизации весьма тяжел.
RESYNC_TIME = [(0,5),(23,23)]

# Иногда при добавлении нового диска mdadm отдает различные ошибки(тормозит).
# Данный парамерт отвечает за кол-во попыток добавить диск в рэйд. Пауза между попытками одна минута.
ADD_DISK_TRY_COUNT = 3

# При обработке отбасываем флэшки. Отбор проходит по 2-м параметра. Первый это
# шина, на которую подключено устройство(отбрасываем подключенные к usb).
# Второй - размер. Если меньше определенного размера - отбосить. Данный
# параметр как раз определяет этот размер в байтах. Считаем что у нас не бывает
# флэшек больше 3Гб.
FLASHSIZELIM = 3000000000

# Не проверяем те накопители, у которых ID_MODEL в выводе udevadm матчится на данное регулярное выражение
STORAGE_IGNORE_PATTERN = '^.+SSD'

# Временный файл, в который будет сохранятся статус мониторинга
MONFILE = '/tmp/yabs-chkdisk-monitoring'

# Время за которое должны заменить диск(он должен изменить свое состояние на нормальное).
# По умолчанию - двое суток. Иначе зажигаем проверку.
BADRAID_TIMEOUT = 48*3600

# Номера проверяемых битов в exit code для smartctl
# Если хотя бы один из них выставлен в 1, диск будет считаться сбойным
# Какие биты за что отвечают можно посмотреть в man smartctl, "RETURN VALUES"
SMARTCTL_ACTIVE_ERROR_BITS = [ 0, 1, 2, 3 ]

# Эти опции, отвечают за проверку вывода smartctl на наличие uncorrected errors
# для sas или Reallocated_Event_Count для sata. Если значение установлено в 0
# то проверка проводится не будет. Если значение больше нуля, то считается что
# это предел ошибок при достижении которого диск будет заменен. Также диск
# будет считаться сбойным если exit code для smartctl будет отличаться от 0.
SMART_SAS_ERR_LIM = 10
SMART_SATA_ERR_LIM = 5

# Кол-во попыток получить информацию через smartctl. Пауза между попытками - 10 сек.
SMART_TRY_COUNT = 5

# Пути к различным бинарникам
UDEVADM = '/sbin/udevadm'
BLOCKDEV = '/sbin/blockdev'
SG_INQ = '/usr/bin/sg_inq'
HDPARM = '/sbin/hdparm'
SFDISK = '/sbin/sfdisk'
SMARTCTL = '/usr/sbin/smartctl'
SG_SES = '/usr/bin/sg_ses'
MDADM = '/sbin/mdadm'
DD = '/bin/dd'
RM = '/bin/rm'
ECHO = '/bin/echo'
HOSTNAME = '/bin/hostname'
MKDIR = '/bin/mkdir'
SGDISK = '/sbin/sgdisk'

# Путь к папке с плагинами
PLUGINS_PATH = '/etc/yabs-chkdisk/plugins/'

# Настройки для работы с bot.yandex-team.ru:
# 1. URL по которому можно обратится к api бота
BOT_HW_URL = 'http://bot.yandex-team.ru/api/'
# 2. Путь куда сохраняются данные с bot
BOT_DATA_PATH  = '/var/lib/yabs-chkdisk/tmp_data_from_bot'
# 3. Период времени, в секундах, после которого данные из bot будут обновлены. По умолчанию 30 дней.
BOT_REFRESH_INTERVAL = 24*3600*3

