# graphite-to-solomon-sender

Утилита, которая принимает метрики графита и пушит их в соломон. Дополнительно может проксировать метрики графита as is на указанный порт.

# teamcity
https://teamcity.yandex-team.ru/project.html?projectId=MediaAdmins_GraphiteToSolomonSender&tab=projectOverview

# Принцип работы:
Открываем порт и слушаем поток метрик графита.<br />
Складываем приходящие метрики в циклический буфер.<br />
Сендер в графит берет пачку метрик из буфера и пытается записать в графитовый порт.<br />
Сендер соломона берет пачку метрик из буфера и пытается записать в соломон.<br />
Оба сендера запускаются раз в секунду, но если после отправки детектится наличие новых данных то перерыва не будет.<br />
Периодически метрики из памяти сбрасываются на жесткий диск.<br />
Периодически пишется статус в монран формате о состоянии приложения.<br />
Приложенька переживает перезапуск, так как буфер персистится.<br />
Все работает в одном потоке на корутинах (медленная операция бекапа вынесена в отдельный тред).<br />
Метрики в памяти хранятся оптимизированно. В среднем 1 млн метрик занимает 40мб.<br />
Приложение пишет логи и ротейтит лог файлы.<br />

# Описание настроек:

```javascript
{
  "logging": {
    "file": "__solomon_sender.log", - файл для лога 
    "level": "DEBUG", - лог левел, рекоммендуется info
    "file_size_bytes": 30000000, - размер одного файла лога
    "backup_count": 10 - количество бекап лог файлов
  },
  "port": 42000, - порт, с которого слушаем метрики графита
  "backup_settings": {
    "on": true, - включать бекап
    "file": "backup.bin", - файл, куда писать бекап
    "delay_millis":10000 - как часто писать бекап
  },
  "buffer": {
    "length": 3000000, - размер циклического буфера в метриках
    "check_health_delay_millis":1000 - как часто проверятеся отставание
  },
  "solomon_http_sender": {
    "on": true, - включена ли отправка в соломон
    "delay_millis":1000, - как часто проверять, не стоит ли отправить что нить в соломон, если в редыдущий раз отправили все.
    "sender_id": "s1", - айдишник сендера, должен быть уникальным, по нему происходит идентификация сендера как ридера буфера.
    "url": "http://solomon-test.yandex.net/push/json", - куда шлем данные.
    "read_timeout_millis": 1009, рид таймаут до соломона, рекоммендуется поставить секунд 10-15.
    "connect_timeout_millis": 12323, - коннект таймаут до соломона.
    "solomon_serializer": { - настройки для конкретного проекта будут свои, нужно ввести указанные при создании проекта в
      "common_labels": {  соломоне имена проекта, кластера, сервиса.
        "project": "tv-test",
        "cluster": "test",
        "service": "api"
      }
    }
  },
  "graphite_senders": [
    {
     "on": false, - нужно ли слать метрики в графит.
    "delay_millis":1000, - как часто проверять есть ли что-то в буфере для отправки
    "sender_id": "g1", - айдишник сендера, должен быть уникальным, по нему происходит идентификация сендера как ридера буфера.
    "server": "gr.mega-graphite-sas.search.yandex.net", - сервер, куда слать метрики
    "port": 2024 - порт, на который слать метрики.
      "metric_prefix": "tv.api.prod.", - префикс для всех метрик(можно не указывать)
      "max_batch_size": 5000, - размер батча для отсылки
    },
    {
    то же самое, за исключением того, что сервер другой
      "on": true,
      "delay_millis": 1000,
      "metric_prefix": "tv.api.prod.",
      "max_batch_size": 5000,
      "sender_id": "g2",
      "server": "gr.mega-graphite-man.search.yandex.net",
      "port": 2024
    }
    ],
  "health_reporter": {
    "on": true, - репортить ли состояние
    "delay_millis":1000, - как часто
    "file": "healthcheck.txt" - в какой файл (пример записи "0;OK:senders_health_check:No problem.;")
  }
}
```
