{% from slspath + "/map.jinja" import sentinel with context %}
{% if salt['pillar.get']("redis:sentinel:enabled") %}
include:
  - .service
  - .monitoring

sentinel_group:
  group.present:
    - name: {{ sentinel.group }}

sentinel_user:
  user.present:
    - name: {{ sentinel.user }}
    - gid: {{ sentinel.group }}
    - require:
      - group: sentinel_group

/etc/redis/sentinel.conf:
  file.managed:
    - user: {{ sentinel.user }}
    - group: {{ sentinel.group }}
    - mode: 0644
    - makedirs: True
    - dir_mode: 0755

update_redis_sentinel_config:
  file.blockreplace:
    - name: /etc/redis/sentinel.conf
    - source: {{ sentinel.config }}
    - marker_start: "# START salt-managed zone. DO NOT EDIT manually this file"
    - marker_end: "# END salt-managed zone. DO NOT EDIT manually this file"
    - prepend_if_not_found: True
    - show_changes: True
    - template: jinja
    - context:
        params: {{ sentinel.params }}
    - require_in:
      - file: /etc/redis/redis.conf
    - watch_in:
      - service: {{ sentinel.service }}

remove_not_managed_changes_redis_sentinel_start:
  cmd.wait:
    - name: sed -i '/\# START salt-managed zone\. DO NOT EDIT manually this file/,$!d' sentinel.conf
    - cwd: /etc/redis
    - watch:
      - file: update_redis_sentinel_config

remove_not_managed_changes_redis_sentinel_end:
  cmd.wait:
    - name: sed -i -n -e '/\# END salt-managed zone\. DO NOT EDIT manually this file/{' -e 'p' -e ':a' -e 'N' -e '/\# Generated by CONFIG REWRITE/!ba' -e 's/.*\n//' -e '}' -e 'p' sentinel.conf
    - cwd: /etc/redis
    - watch:
      - file: update_redis_sentinel_config
    - watch_in:
      - service: {{ sentinel.service }}
{% else %}
redis_sentinel_not_enabled:
  cmd.run:
      - name: echo "redis:sentinel:enabled set to False, or memory leaks on salt master!";exit 1
{% endif %}
