{% from slspath + "/map.jinja" import server with context %}
{% if salt['pillar.get']("redis:server:enabled") %}
include:
  - .service
  - .monitoring

redis_group:
  group.present:
    - name: {{ server.group }}

redis_user:
  user.present:
    - name: {{ server.user }}
    - gid: {{ server.group }}
    - require:
      - group: redis_group

/etc/redis/redis.conf:
  file.managed:
    - user: {{ server.user }}
    - group: {{ server.group }}
    - mode: 0644
    - makedirs: True
    - dir_mode: 0755

update_redis_server_config:
  file.blockreplace:
    - name: /etc/redis/redis.conf
    - source: {{ server.config }}
    - marker_start: "# START salt-managed zone. DO NOT EDIT manually this file"
    - marker_end: "# END salt-managed zone. DO NOT EDIT manually this file"
    - prepend_if_not_found: True
    - show_changes: True
    - template: jinja
    - context:
        params: {{ server.params }}
    - require_in:
      - file: /etc/redis/redis.conf

remove_not_managed_changes_redis_server_config_start:
  cmd.wait:
    - name: sed '/\# START salt-managed zone\. DO NOT EDIT manually this file/,$!d' redis.conf
    - cwd: /etc/redis
    - watch:
      - file: update_redis_server_config

remove_not_managed_changes_redis_server_config_end:
  cmd.wait:
    - name: sed -i -n -e '/\# END salt-managed zone\. DO NOT EDIT manually this file/{' -e 'p' -e ':a' -e 'N' -e '/\# Generated by CONFIG REWRITE/!ba' -e 's/.*\n//' -e '}' -e 'p' redis.conf
    - cwd: /etc/redis
    - watch:
      - file: update_redis_server_config
    - watch_in:
      - service: {{ server.service }}
{% else %}
redis_server_not_enabled:
  cmd.run:
        - name: echo "redis:server:enabled set to False, or memory leaks on salt master!";exit 1
{% endif %}
