# MANAGED BY SALT
@version: 3.13
@include "scl.conf"
@include "`scl-root`/system/tty10.conf"

# Syslog-ng configuration file, compatible with default Debian syslogd
# installation.

# First, set some global options.
options {
	# enable syslog-ng OSE to run in multithreaded mode and use multiple CPUs
	threaded(yes);

	# the time to wait before a died connection is re-established
	time_reopen(10);

	# the time to wait before an idle destination file is closed
	time_reap(360);

	# the number of lines buffered before written to file
	flush_lines(100);

	# the number of lines fitting in the output queue
	log_fifo_size(131072);

	# default owner, group, and permissions for log files
	owner("root");
	group("adm");
	perm(0640);

	# enable or disable directory creation for destination files
	create_dirs(yes);

	# default owner, group, and permissions for created directories
	dir_owner("root");
	dir_group("adm");
	dir_perm(0755);

	# number of hostnames in the DNS cache
	dns_cache_size(4096);

	# enable or disable DNS usage
	use_dns(yes);

	# add Fully Qualified Domain Name instead of short hostname
	use_fqdn(no);

	# disable the chained hostname format in logs
	chain_hostnames(no);

	# a regexp containing hostnames which should not be handled as hostnames
	bad_hostname("^gconfd$");

	# CADMIN-6873
	stats_freq(0);
	mark_freq(0);
};

########################
# Sources
########################
# This is the default behavior of sysklogd package
# Logs may come from unix stream, but not from another machine.
#
source s_all {
	systemd-journal();
	# message generated by syslog-ng
	internal();
	# standard Linux log source
	unix-dgram("/dev/log");
	# messages from the kernel
#	file("/proc/kmsg" program-override("kernel") flags(kernel)); # BARE_METAL

	tcp(port(514) log_iw_size(102400) max-connections(1024));
	udp(port(514));
};

########################
# Destinations
########################
# First some standard logfile
#
destination d_auth { file("/var/log/auth.log"); udp6("trapdoor.yandex.net" port(514)); };
destination d_cron { file("/var/log/cron.log"); };
destination d_daemon { file("/var/log/daemon.log"); };
destination d_kern { file("/var/log/kern.log"); };
destination d_lpr { file("/var/log/lpr.log"); };
destination d_mail { file("/var/log/mail.log"); };
destination d_syslog { file("/var/log/syslog"); };
destination d_user { file("/var/log/user.log"); };
destination d_uucp { file("/var/log/uucp.log"); };

# This files are the log come from the mail subsystem.
#
destination d_mailinfo { file("/var/log/mail.info"); };
destination d_mailwarn { file("/var/log/mail.warn"); };
destination d_mailerr { file("/var/log/mail.err"); };

# Logging for INN news system
#
#destination d_newscrit { file("/var/log/news/news.crit"); };
#destination d_newserr { file("/var/log/news/news.err"); };
#destination d_newsnotice { file("/var/log/news/news.notice"); };

# Some 'catch-all' logfiles.
#
destination d_debug { file("/var/log/debug"); };
destination d_error { file("/var/log/error"); };
destination d_messages { file("/var/log/messages"); };

# The root's console.
#
destination d_console { usertty("root"); };

# Virtual console.
#
#destination d_console_all { file("/dev/tty10"); };  # BARE_METAL

# The named pipe /dev/xconsole is for the nsole' utility.  To use it,
# you must invoke nsole' with the -file' option:
#
#    $ xconsole -file /dev/xconsole [...]
#
destination d_xconsole { pipe("/dev/xconsole"); };

# Send the messages to an other host
#
#destination d_net { tcp("127.0.0.1" port(1000) log_fifo_size(1000)); };

# Debian only
#destination d_ppp { file("/var/log/ppp.log"); };

########################
# Filters
########################
# Here's come the filter options. With this rules, we can set which
# message go where.

filter f_dbg { level(debug); };
filter f_info { level(info); };
filter f_notice { level(notice); };
filter f_warn { level(warn); };
filter f_err { level(err); };
filter f_crit { level(crit .. emerg); };

filter f_debug { level(debug) and not facility(auth, authpriv, news, mail); };
filter f_error { level(err .. emerg) ; };
filter f_messages { level(info,notice,warn) and
                    not facility(auth,authpriv,cron,daemon,mail,news); };

filter f_auth { facility(auth, authpriv) and not filter(f_debug); };
filter f_cron { facility(cron) and not filter(f_debug); };
filter f_daemon { facility(daemon) and not filter(f_debug); };
filter f_kern { facility(kern) and not filter(f_debug); };
filter f_lpr { facility(lpr) and not filter(f_debug); };
filter f_local { facility(local0, local1, local3, local4, local5,
                        local6, local7) and not filter(f_debug); };
filter f_mail { facility(mail) and not filter(f_debug); };
filter f_news { facility(news) and not filter(f_debug); };
filter f_syslog3 { not facility(auth, authpriv, mail) and not filter(f_debug); };
filter f_user { facility(user) and not filter(f_debug); };
filter f_uucp { facility(uucp) and not filter(f_debug); };

filter f_cnews { level(notice, err, crit) and facility(news); };
filter f_cother { level(debug, info, notice, warn) or facility(daemon, mail); };

filter f_ppp { facility(local2) and not filter(f_debug); };
filter f_console { level(warn .. emerg); };

###
# Include all config files in /etc/syslog-ng/conf.d/
###
@include "/etc/syslog-ng/conf.d/"

########################
# Log paths
########################
log { source(s_all); filter(f_auth); destination(d_auth); };
log { source(s_all); filter(f_cron); destination(d_cron); };
log { source(s_all); filter(f_daemon); destination(d_daemon); };
log { source(s_all); filter(f_kern); destination(d_kern); };
log { source(s_all); filter(f_lpr); destination(d_lpr); };
log { source(s_all); filter(f_syslog3); destination(d_syslog); };
log { source(s_all); filter(f_user); destination(d_user); };

log { source(s_all); filter(f_mail); destination(d_mail); };
log { source(s_all); filter(f_mail); filter(f_info); destination(d_mailinfo); };
log { source(s_all); filter(f_mail); filter(f_warn); destination(d_mailwarn); };
log { source(s_all); filter(f_mail); filter(f_err); destination(d_mailerr); };

log { source(s_all); filter(f_debug); destination(d_debug); };
log { source(s_all); filter(f_messages); destination(d_messages); };
