import socket

AGENT_SLEEP_SECONDS = 15
SERVER_SLEEP_SECONDS = 60

NODE_TIMEOUT = 30

UNICORN_TIMEOUT = 10
UNICORN_TIMEOUT_GETLOCK = 10
UNICORN_HEARTBEAT_SLEEP_DURATION = 30
UNICORN_HEARTBEAT_LOST_THRESHOLD = UNICORN_HEARTBEAT_SLEEP_DURATION * 3

UNICORN_ROOT = "/orchestra"
UNICORN_SUFFIX_LOCK = '.lock'
UNICORN_SUFFIX_STATE = '.json'

UNICORN_PREFIX_AGENT_FROM = '/from'
UNICORN_PREFIX_AGENT_TO = '/to'

UNICORN_AGENTS_TREE = UNICORN_ROOT + '/agents'
UNICORN_AGENT_HOST_FROM_ROOT = UNICORN_AGENTS_TREE + UNICORN_PREFIX_AGENT_FROM
UNICORN_AGENT_HOST_TO_ROOT = UNICORN_AGENTS_TREE + UNICORN_PREFIX_AGENT_TO

UNICORN_AGENT_HOST_PATTERN = '/%s'
UNICORN_AGENT_HOST = '/%s' % socket.getfqdn()

UNICORN_AGENT_HOST_LOCK_FILE = UNICORN_AGENTS_TREE + UNICORN_AGENT_HOST + UNICORN_SUFFIX_LOCK
UNICORN_AGENT_HOST_TO_FILE = UNICORN_AGENT_HOST_TO_ROOT + UNICORN_AGENT_HOST + UNICORN_SUFFIX_STATE
UNICORN_AGENT_HOST_FROM_FILE = UNICORN_AGENT_HOST_FROM_ROOT + UNICORN_AGENT_HOST + UNICORN_SUFFIX_STATE

UNICORN_AGENT_HOST_STATE_JSON_KEY_DC = 'datacenter'
UNICORN_AGENT_HOST_STATE_JSON_KEY_FQDN = 'fqdn'
UNICORN_AGENT_HOST_STATE_JSON_KEY_APPLIEDVERSION = 'last_processed_version'
UNICORN_AGENT_HOST_STATE_JSON_VALUE_COMPOSEDBY = 'agent'

UNICORN_COMMON_HOST_STATE_JSON_KEY_COMPOSEDBY = 'state_composed_by'
UNICORN_COMMON_HOST_STATE_JSON_KEY_COMPOSEDTIMESTAMPUTC = 'generated_at_timestamp_utc'

UNICORN_COMMON_HOST_STATE_JSON_KEY_APP = 'app'
UNICORN_COMMON_HOST_STATE_JSON_KEY_PROFILE_TREE = 'profile'
UNICORN_COMMON_HOST_STATE_JSON_KEY_PROFILE_NAME = 'name'

UNICORN_SERVER_TREE = UNICORN_ROOT + '/server'
UNICORN_SERVER_CONF_LOCK = UNICORN_SERVER_TREE + '/config.lock'
UNICORN_SERVER_CONF_FILE = UNICORN_SERVER_TREE + '/config.json'
UNICORN_SERVER_LOCK = UNICORN_SERVER_TREE + '/lock'
UNICORN_SERVER_HOST_STATE_JSON_VALUE_COMPOSEDBY = 'server'
UNICORN_SERVER_CONF_FILE_KEY_WORKERS = 'workers'

CALC_MIN_BACKENDS_PER_APP = 3

SERVER_JOURNAL_SIZE_TRUNCATE_THRESHOLD = 1000
