package app

// see: https://a.yandex-team.ru/arc/trunk/arcadia/alice/acceptance/modules/request_generator/lib/app_presets.py

var (
	presets = map[string]appPreset{
		"iot_app_prod_ios": {
			AppID:              "com.yandex.iot",
			AppVersion:         "9510",
			OSVersion:          "15.4.1",
			Platform:           "iphone",
			DeviceID:           "feedface-a105-4abb-86f3-5105e892a8b9",
			DeviceModel:        "iPhone",
			DeviceManufacturer: "Apple",
			AuthToken:          "06762f99-b8cf-46d7-8482-6d46638ae755",
			ASRTopic:           "dialog-general",
			UserAgent:          "Mozilla/5.0 (iPhone; CPU iPhone OS 15_4_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Mobile/15E148 YaBrowser/19.5.2.38.10 YaApp_iOS/95.10 Safari/604.1 IOT/1.0",
			Features: []string{
				"iot_ios_device_setup",
			},
		},
		"iot_app_prod_android": {
			AppID:              "com.yandex.iot",
			AppVersion:         "21.112",
			OSVersion:          "11",
			Platform:           "android",
			DeviceID:           "feedface-a712-4abb-86f3-5105e892a8b9",
			DeviceModel:        "M2101K6G",
			DeviceManufacturer: "Redmi",
			AuthToken:          "06762f99-b8cf-46d7-8482-6d46638ae755",
			ASRTopic:           "dialog-general",
			UserAgent:          "Mozilla/5.0 (Linux; arm; Android 11; M2101K6G) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/94.0.4606.85 BroPP/1.0 SA/3 Mobile Safari/537.36 YandexSearch/21.112",
			Features: []string{
				"iot_android_device_setup",
			},
		},
		"search_app_prod": {
			AppID:              "ru.yandex.searchplugin",
			AppVersion:         "21.22",
			OSVersion:          "9",
			Platform:           "android",
			DeviceID:           "feedface-e22e-4abb-86f3-5105e892a8b9",
			DeviceModel:        "SM-G965F",
			DeviceManufacturer: "samsung",
			AuthToken:          "06762f99-b8cf-46d7-8482-6d46638ae755",
			ASRTopic:           "dialog-general",
			UserAgent:          "Mozilla/5.0 (Linux; Android 8.1.0; DUA-L22 Build/HONORDUA-L22; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/76.0.3809.89 Mobile Safari/537.36 YandexSearch/8.80",
			Features: []string{
				"bonus_cards_camera",
				"bonus_cards_list",
				"can_open_videotranslation_onboarding",
				"pedometer",
				"pwd_app_manager",
				"reader_app",
				"whocalls_message_filtering",
				"phone_address_book",
				"open_link_outgoing_device_calls",
				"cloud_ui",
				"cloud_ui_filling",
			},
		},
		"search_app_beta": {
			AppID:              "ru.yandex.searchplugin.beta",
			AppVersion:         "8.70",
			OSVersion:          "8.1.0",
			Platform:           "android",
			DeviceID:           "feedface-2e90-443b-89be-24bcfdfeea93",
			DeviceModel:        "Redmi Note 5",
			DeviceManufacturer: "xiaomi",
			AuthToken:          "06762f99-b8cf-46d7-8482-6d46638ae755",
			ASRTopic:           "dialog-general",
			UserAgent:          "Mozilla/5.0 (Linux; Android 9; JAT-LX1 Build/HONORJAT-LX1; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/75.0.3770.100 Mobile Safari/537.36 YandexSearch/8.90",
			Features: []string{
				"bonus_cards_camera",
				"bonus_cards_list",
				"can_open_videotranslation_onboarding",
				"pedometer",
				"pwd_app_manager",
				"reader_app",
				"whocalls_message_filtering",
				"phone_address_book",
				"open_link_outgoing_device_calls",
				"cloud_ui",
				"cloud_ui_filling",
			},
		},
		"search_app_ipad": {
			AppID:              "ru.yandex.mobile.search.ipad",
			AppVersion:         "1906.1.157",
			OSVersion:          "9.2.1",
			Platform:           "iphone",
			DeviceID:           "feedface-5062-4e72-9696-58382afec807",
			DeviceModel:        "iPad",
			DeviceManufacturer: "Apple",
			AuthToken:          "cc96633d-59d4-4724-94bd-f5db2f02ad13",
			ASRTopic:           "dialog-general",
			UserAgent:          "Mozilla/5.0 (iPad; CPU OS 12_3 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/12.0 YaBrowser/19.7.3.121.11 Mobile/15E148 Safari/605.1",
			Features: []string{
				"bonus_cards_camera",
				"bonus_cards_list",
				"can_open_videotranslation_onboarding",
				"pedometer",
				"pwd_app_manager",
				"reader_app",
				"whocalls_message_filtering",
				"cloud_ui",
				"cloud_ui_filling",
			},
		},
		"search_app_ios": {
			AppID:              "ru.yandex.mobile",
			AppVersion:         "3100",
			OSVersion:          "14.6",
			Platform:           "iphone",
			DeviceID:           "feedface-cdd2-4933-bd61-691bbc1dc56e",
			DeviceModel:        "iPhone",
			DeviceManufacturer: "Apple",
			AuthToken:          "06762f99-b8cf-46d7-8482-6d46638ae755",
			ASRTopic:           "dialog-general",
			UserAgent:          "Mozilla/5.0 (iPhone; CPU iPhone OS 14_6 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Mobile/15E148 YaBrowser/19.5.2.38.10 YaApp_iOS/31.00 Safari/604.1",
			Features: []string{
				"bonus_cards_camera",
				"bonus_cards_list",
				"can_open_videotranslation_onboarding",
				"pedometer",
				"pwd_app_manager",
				"reader_app",
				"whocalls_message_filtering",
				"phone_address_book",
				"open_link_outgoing_device_calls",
				"cloud_ui",
				"cloud_ui_filling",
			},
		},
		"alice_prod": {
			AppID:              "com.yandex.alice",
			AppVersion:         "20.112",
			OSVersion:          "9",
			Platform:           "android",
			DeviceID:           "1c1fc3be-3f18-c630-a732-9832370bb1eb",
			DeviceModel:        "SM-G965F",
			DeviceManufacturer: "samsung",
			AuthToken:          "06762f99-b8cf-46d7-8482-6d46638ae755",
			ASRTopic:           "dialog-general",
			UserAgent:          "Mozilla/5.0 (Linux; Android 8.1.0; DUA-L22 Build/HONORDUA-L22; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/76.0.3809.89 Mobile Safari/537.36 YandexSearch/8.80",
			Features:           []string{},
		},
		"browser_prod": {
			AppID:              "com.yandex.browser",
			AppVersion:         "19.7.1.93",
			OSVersion:          "8.0.0",
			Platform:           "android",
			DeviceID:           "",
			DeviceModel:        "ANE-LX1",
			DeviceManufacturer: "HUAWEI",
			AuthToken:          "1f8abf45-d7a8-4bb6-9b4c-31a2bb9668e0",
			ASRTopic:           "desktop-general",
			UserAgent:          "com.yandex.browser/19.7.1.93",
			Features: []string{
				"pwd_app_manager",
				"phone_address_book",
				"cloud_ui",
				"cloud_ui_filling",
			},
		},
		"browser_prod_ios": {
			AppID:              "ru.yandex.mobile.search",
			AppVersion:         "21.5.1.845",
			OSVersion:          "14.6",
			Platform:           "iphone",
			DeviceID:           "feedface-1641-407d-a590-cc26abb19df1",
			DeviceModel:        "iPhone",
			DeviceManufacturer: "Apple",
			AuthToken:          "1f8abf45-d7a8-4bb6-9b4c-31a2bb9668e0",
			ASRTopic:           "dialog-general",
			UserAgent:          "Mozilla/5.0 (iPhone; CPU iPhone OS 14_6 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Mobile/15E148 YaBrowser/21.5.1.845 YaApp_iOS/31.00 Safari/604.1",
			Features: []string{
				"open_ibro_settings",
				"pwd_app_manager",
				"phone_address_book",
				"cloud_ui",
				"cloud_ui_filling",
			},
		},
		"browser_alpha": {
			AppID:              "com.yandex.browser.alpha",
			AppVersion:         "19.7.3.46",
			OSVersion:          "5.1.1",
			Platform:           "android",
			DeviceID:           "feedface-b0df-4b69-bb96-e9bda4504ee8",
			DeviceModel:        "SM-J120H",
			DeviceManufacturer: "samsung",
			AuthToken:          "1f8abf45-d7a8-4bb6-9b4c-31a2bb9668e0",
			ASRTopic:           "desktop-general",
			UserAgent:          "com.yandex.browser.alpha/19.7.3.46",
			Features: []string{
				"pwd_app_manager",
				"phone_address_book",
				"cloud_ui",
				"cloud_ui_filling",
			},
		},
		"browser_beta": {
			AppID:              "com.yandex.browser.beta",
			AppVersion:         "19.7.2.88",
			OSVersion:          "8.0.0",
			Platform:           "android",
			DeviceID:           "feedface-e2ad-496a-8251-f05bd4ee4d18",
			DeviceModel:        "AUM-L41",
			DeviceManufacturer: "HONOR",
			AuthToken:          "1f8abf45-d7a8-4bb6-9b4c-31a2bb9668e0",
			ASRTopic:           "desktop-general",
			UserAgent:          "com.yandex.browser.beta/19.7.2.88",
			Features: []string{
				"pwd_app_manager",
				"phone_address_book",
				"cloud_ui",
				"cloud_ui_filling",
			},
		},
		"webtouch_prod": {
			AppID:              "ru.yandex.webtouch",
			AppVersion:         "1.0",
			OSVersion:          "8.0.0",
			Platform:           "android",
			DeviceID:           "",
			DeviceModel:        "ANE-LX1",
			DeviceManufacturer: "HUAWEI",
			AuthToken:          "effd5a3f-fd42-4a18-83a1-61766a6d0924",
			ASRTopic:           "desktop-general",
			UserAgent:          "Version/4.0 Chrome/76.0.3809.89 Mobile Safari/537.36 YandexSearch/8.80",
			Features: []string{
				"open_link_intent",
				"open_link",
				"server_action",
				"cloud_ui",
				"show_promo",
			},
		},
		"webtouch_prod_ios": {
			AppID:              "ru.yandex.webtouch",
			AppVersion:         "1.0",
			OSVersion:          "14.6",
			Platform:           "iphone",
			DeviceID:           "feedface-1641-407d-a590-cc26abb19df1",
			DeviceModel:        "iPhone",
			DeviceManufacturer: "Apple",
			AuthToken:          "effd5a3f-fd42-4a18-83a1-61766a6d0924",
			ASRTopic:           "dialog-general",
			UserAgent:          "Mozilla/5.0 (iPhone; CPU iPhone OS 14_6 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) ",
			Features: []string{
				"open_link_intent",
				"open_link",
				"server_action",
				"cloud_ui",
				"show_promo",
			},
		},
		"stroka": {
			AppID:              "winsearchbar",
			AppVersion:         "6.3.0.9600",
			OSVersion:          "6.1.7601",
			Platform:           "Windows",
			DeviceID:           "feedface-c8e2-47f4-be39-96991d4c90a8",
			DeviceModel:        "Unknown",
			DeviceManufacturer: "Unknown",
			AuthToken:          "14e2f152-e03a-439d-9abe-f470c27db24e",
			ASRTopic:           "desktop-general",
			UserAgent:          "winsearchbar/5.5.0.1923 (Unknown Unknown; Windows 6.3.0.9600)",
			Features:           []string{},
		},
		"navigator": {
			AppID:              "ru.yandex.yandexnavi",
			AppVersion:         "3.91",
			OSVersion:          "8.1.0",
			Platform:           "android",
			DeviceID:           "feedface-aa9d-4c8b-89f1-74f9a1739089",
			DeviceModel:        "Redmi Note 5",
			DeviceManufacturer: "xiaomi",
			AuthToken:          "27fbd96d-ec5b-4688-a54d-421d81aa8cd2",
			ASRTopic:           "dialog-maps",
			UserAgent:          "",
			Features:           []string{},
		},
		"launcher": {
			AppID:              "com.yandex.launcher",
			AppVersion:         "2.1.2",
			OSVersion:          "6.0",
			Platform:           "android",
			DeviceID:           "feedface-e7a8-4b9b-a63d-02c469c20516",
			DeviceModel:        "FS507",
			DeviceManufacturer: "Fly",
			AuthToken:          "1f2a4085-473c-4ab7-b010-cb9a3500dd37",
			ASRTopic:           "dialog-general",
			UserAgent:          "Mozilla/5.0 (Linux; Android 8.1.0; YNDX-000SB Build/8710.1.A.0063.20190415; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/70.0.3538.110 Mobile Safari/537.36",
			Features:           []string{},
		},
		"auto": {
			AppID:              "yandex.auto",
			AppVersion:         "1.5.0",
			OSVersion:          "6.0.1",
			Platform:           "android",
			DeviceID:           "feedface-ea21-444a-93b0-1110590b9620",
			DeviceModel:        "t3-polo-yaCS",
			DeviceManufacturer: "Allwinner",
			AuthToken:          "1a198b89-2443-4ac9-85b9-9db178271aec",
			ASRTopic:           "dialog-maps",
			UserAgent:          "",
			Features:           []string{},
		},
		"auto_new": {
			AppID:              "yandex.auto",
			AppVersion:         "1.9.0",
			OSVersion:          "6.0.1",
			Platform:           "android",
			DeviceID:           "feedface-ea21-444a-93b0-1110590b9620",
			DeviceModel:        "t3-polo-yaCS",
			DeviceManufacturer: "Allwinner",
			AuthToken:          "1a198b89-2443-4ac9-85b9-9db178271aec",
			ASRTopic:           "dialog-maps",
			UserAgent:          "",
			Features:           []string{},
		},
		"auto_old": {
			AppID:              "yandex.auto.old",
			AppVersion:         "1.2.0",
			OSVersion:          "6.0.1",
			Platform:           "android",
			DeviceID:           "feedface-ea21-444a-93b0-1110590b9620",
			DeviceModel:        "t3-polo-yaCS",
			DeviceManufacturer: "Allwinner",
			AuthToken:          "1a198b89-2443-4ac9-85b9-9db178271aec",
			ASRTopic:           "dialog-maps",
			UserAgent:          "",
			Features:           []string{},
		},
		"elariwatch": {
			AppID:              "ru.yandex.iosdk.elariwatch",
			AppVersion:         "1.0",
			OSVersion:          "4.4.2",
			Platform:           "android",
			DeviceID:           "feedface-ec60-4d27-884f-163d4c21bdfb",
			DeviceModel:        "KidPhone3G",
			DeviceManufacturer: "KidPhone3G",
			AuthToken:          "9051faff-b426-4251-9343-df10ee4d7a5d",
			ASRTopic:           "dialog-general",
			UserAgent:          "",
			Features:           []string{},
		},
		"small_smart_speakers": {
			AppID:              "aliced",
			AppVersion:         "1.0",
			OSVersion:          "1.0",
			Platform:           "Linux",
			DeviceID:           "feedface-72fe-48e4-a1d5-ea09a546a7e6",
			DeviceModel:        "elari_a98",
			DeviceManufacturer: "Elari",
			AuthToken:          "51ae06cc-5c8f-48dc-93ae-7214517679e6",
			ASRTopic:           "quasar-general",
			UserAgent:          "Mozilla/5.0 (Linux; Android 6.0.1; Station Build/MOB30J; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/61.0.3163.98 Safari/537.36 YandexStation/2.3.0.3.373060213.20190204.develop.ENG (YandexIO)",
			Features: []string{
				"audio_client",
			},
		},
		"yabro_prod": {
			AppID:              "YaBro",
			AppVersion:         "19.6.2.599",
			OSVersion:          "10.0.17134",
			Platform:           "Windows",
			DeviceID:           "feedface-e38e-463d-be15-4fa56996c863",
			DeviceModel:        "Unknown",
			DeviceManufacturer: "Unknown",
			AuthToken:          "14e2f152-e03a-439d-9abe-f470c27db24e",
			ASRTopic:           "desktop-general",
			UserAgent:          "YaBro/19.7.2.470 (Unknown Unknown; Windows 6.3.9600.19401)",
			Features:           []string{},
		},
		"yabro_beta": {
			AppID:              "YaBro.beta",
			AppVersion:         "19.7.0.1374",
			OSVersion:          "10.0.17134",
			Platform:           "Windows",
			DeviceID:           "feedface-8046-4c81-938a-31d766174f51",
			DeviceModel:        "Unknown",
			DeviceManufacturer: "Unknown",
			AuthToken:          "14e2f152-e03a-439d-9abe-f470c27db24e",
			ASRTopic:           "desktop-general",
			UserAgent:          "YaBro.beta/19.9.1.74 (Unknown Unknown; Windows 10.0.17134.885)",
			Features:           []string{},
		},
		"taximeter": {
			AppID:              "ru.yandex.taximeter",
			AppVersion:         "9.30",
			OSVersion:          "10.0",
			Platform:           "android",
			DeviceID:           "feedface-cdd2-4933-bd61-691bbc1dc56e",
			DeviceModel:        "Unknown",
			DeviceManufacturer: "Unknown",
			AuthToken:          "06762f99-b8cf-46d7-8482-6d46638ae755",
			ASRTopic:           "desktop-general",
			UserAgent:          "Taximeter 9.30 (1234)",
			Features:           []string{},
		},
		"tv": {
			AppID:              "com.yandex.tv.alice",
			AppVersion:         "2.1000.1000",
			OSVersion:          "",
			Platform:           "android",
			DeviceID:           "feedface-6219-45e3-a140-41993ef7dad9",
			DeviceModel:        "yandex_tv_mt9632_cv",
			DeviceManufacturer: "YTV",
			AuthToken:          "51ae06cc-5c8f-48dc-93ae-7214517679e6",
			ASRTopic:           "queries",
			UserAgent:          "com.yandex.io.sdk/2.1000.1000.8305 (YTV YU43CV9632; Android 9)",
			Features: []string{
				"vertical_screen_navigation",
				"directive_sequencer",
				"change_alarm_sound_level",
				"music_player_allow_shots",
				"music_recognizer",
				"go_home",
				"publicly_available",
				"change_alarm_sound",
				"tts_play_placeholder",
				"music_quasar_client",
				"tv_open_collection_screen_directive",
				"has_synchronized_push",
				"tv_open_details_screen_directive",
				"tv_open_person_screen_directive",
				"server_action",
				"tandem_setup",
				"tv_open_search_screen_directive",
				"live_tv_scheme",
				"video_protocol",
				"video_play_directive",
				"unauthorized_music_directives",
				"audio_client_hls",
				"cec_available",
				"audio_client",
				"absolute_volume_change",
				"handle_android_app_intent",
				"tv_open_store",
				"!outgoing_phone_calls",
				"!open_link",
				"!set_timer",
				"!set_alarm",
				"!synchronized_push_implementation",
			},
		},
		"module_2": {
			AppID:              "com.yandex.tv.alice",
			AppVersion:         "2.1000.1000",
			OSVersion:          "",
			Platform:           "android",
			DeviceID:           "feedface-6219-45e3-a140-41993ef7dad9",
			DeviceModel:        "yandexmodule_2",
			DeviceManufacturer: "Yandex",
			AuthToken:          "51ae06cc-5c8f-48dc-93ae-7214517679e6",
			ASRTopic:           "queries",
			UserAgent:          "com.yandex.io.sdk/2.1000.1000.8305 (YTV YU43CV9632; Android 9)",
			Features: []string{
				"change_alarm_sound",
				"change_alarm_sound_level",
				"music_player_allow_shots",
				"tts_play_placeholder",
				"publicly_available",
				"directive_sequencer",
				"music_quasar_client",
				"video_protocol",
				"has_synchronized_push",
				"server_action",
				"music_recognizer",
				"live_tv_scheme",
				"video_play_directive",
				"unauthorized_music_directives",
				"tv_open_details_screen_directive",
				"tv_open_search_screen_directive",
				"tv_open_person_screen_directive",
				"tv_open_collection_screen_directive",
				"audio_client",
				"audio_client_hls",
				"vertical_screen_navigation",
				"bluetooth_rcu",
				"cec_available",
				"go_home",
				"relative_volume_change",
				"handle_android_app_intent",
				"tv_open_store",
				"tandem_setup",
				"!outgoing_phone_calls",
				"!open_link",
				"!set_timer",
				"!set_alarm",
				"!synchronized_push_implementation",
				"!absolute_volume_change",
			},
		},
		"smart_display": {
			AppID:              "ru.yandex.centaur",
			AppVersion:         "1.0",
			OSVersion:          "6.0.1",
			Platform:           "android",
			DeviceID:           "feedface-e8a2-4439-b2e7-689d95f277b7",
			DeviceModel:        "Station",
			DeviceManufacturer: "Yandex",
			AuthToken:          "51ae06cc-5c8f-48dc-93ae-7214517679e6",
			ASRTopic:           "quasar-general",
			UserAgent:          "Mozilla/5.0 (Linux; arm_64; Android 6.0.1; Station Build/MOB30J; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/75.0.3770.143 YandexStation/2.3.3.13.510432417.20190918 (YandexIO) Safari/537.36",
			Features: []string{
				"multiroom",
				"change_alarm_sound",
				"change_alarm_sound_level",
				"music_player_allow_shots",
				"audio_client",
				"notifications",
				"tts_play_placeholder",
				"incoming_messenger_calls",
				"outgoing_messenger_calls",
				"publicly_available",
				"video_codec_AVC",
				"audio_codec_AAC",
				"audio_codec_VORBIS",
				"audio_codec_OPUS",
				"directive_sequencer",
				"show_view",
				"div2_cards",
				"show_timer",
				"do_not_disturb",
				"handle_android_app_intent",
			},
		},
		"maps": {
			AppID:              "ru.yandex.yandexmaps",
			AppVersion:         "10.5.4",
			OSVersion:          "11",
			Platform:           "android",
			DeviceID:           "feedface-e11e-a666-31f3-5106e892a9a2",
			DeviceModel:        "SM-G996B",
			DeviceManufacturer: "samsung",
			AuthToken:          "87d9fcbc-602c-43df-becb-772a15340ea2",
			ASRTopic:           "dialog-general",
			UserAgent:          "",
			Features: []string{
				"open_link",
				"navigator",
				"maps_download_offline",
				"phone_address_book",
			},
		},
		"legatus": {
			AppID:              "legatus",
			AppVersion:         "1.0",
			OSVersion:          "7.2.0",
			Platform:           "W22H",
			DeviceID:           "feedface-2fc3-49bf-8c11-c68ad244e4ff",
			DeviceModel:        "WEBOS22",
			DeviceManufacturer: "LG Electronics",
			AuthToken:          "51ae06cc-5c8f-48dc-93ae-7214517679e6",
			ASRTopic:           "quasar-general",
			UserAgent:          "Mozilla/5.0 (Linux; arm_64; Android 6.0.1; Station Build/MOB30J; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/75.0.3770.143 YandexStation/2.3.3.13.510432417.20190918 (YandexIO) Safari/537.36",
			Features: []string{
				"video_protocol",
				"music_sdk_client",
				"!open_link",
				"!set_alarm",
				"!set_timer",
				"!absolute_volume_change",
				"!relative_volume_change",
				"!mute_unmute_volume",
				"!player_continue_directive",
				"!player_pause_directive",
				"!synchronized_push_implementation",
				"!player_rewind_directive",
			},
		},
		"sdc": {
			AppID:              "ru.yandex.sdg.taxi.inhouse",
			AppVersion:         "1.0.16",
			OSVersion:          "15.3.1",
			Platform:           "iphone",
			DeviceID:           "feedface-6219-45e3-a140-41993ef7dac0",
			DeviceModel:        "iPad",
			DeviceManufacturer: "Apple",
			AuthToken:          "06762f99-b8cf-46d7-8482-6d46638ae755",
			ASRTopic:           "dialog-maps",
			UserAgent:          "Mozilla/5.0 (iPhone; CPU iPhone OS 10_3 like Mac OS X) AppleWebKit/603.1.23 (KHTML, like Gecko) Version/10.0 Mobile/14E5239e Safari/602.1",
			Features: []string{
				"navigator",
				"route_manager_start",
				"route_manager_stop",
				"outgoing_operator_calls",
				"!open_link",
			},
		},
		"quasar": {
			AppID:              "ru.yandex.quasar.app",
			AppVersion:         "1.0",
			OSVersion:          "6.0.1",
			Platform:           "android",
			DeviceID:           "feedface-e8a2-4439-b2e7-689d95f277b7",
			DeviceModel:        "Station",
			DeviceManufacturer: "Yandex",
			AuthToken:          "51ae06cc-5c8f-48dc-93ae-7214517679e6",
			ASRTopic:           "quasar-general",
			UserAgent:          "Mozilla/5.0 (Linux; arm_64; Android 6.0.1; Station Build/MOB30J; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/75.0.3770.143 YandexStation/2.3.3.13.510432417.20190918 (YandexIO) Safari/537.36",
			Features: []string{
				"absolute_volume_change",
				"relative_volume_change",
				"mordovia_webview",
				"multiroom",
				"multiroom_cluster",
				"multiroom_audio_client",
				"change_alarm_sound",
				"change_alarm_sound_level",
				"music_player_allow_shots",
				"audio_client",
				"audio_client_hls",
				"notifications",
				"tts_play_placeholder",
				"incoming_messenger_calls",
				"outgoing_messenger_calls",
				"publicly_available",
				"video_codec_AVC",
				"audio_codec_AAC",
				"audio_codec_VORBIS",
				"audio_codec_OPUS",
				"directive_sequencer",
				"set_alarm_semantic_frame_v2",
				"stereo_pair",
				"muzpult",
				"audio_bitrate192",
				"audio_bitrate320",
				"prefetch_invalidation",
				"equalizer",
			},
		},
		"yandexmax": {
			AppID:              "ru.yandex.quasar.app",
			AppVersion:         "1.0",
			OSVersion:          "9",
			Platform:           "android",
			DeviceID:           "280b4000-0112-3300-000f-3834524e5050",
			DeviceModel:        "Station_2",
			DeviceManufacturer: "Yandex",
			AuthToken:          "51ae06cc-5c8f-48dc-93ae-7214517679e6",
			ASRTopic:           "quasar-general",
			UserAgent:          "Mozilla/5.0 (Linux; arm; Android 9; yandexstation_2 Build/PPR1.180610.011; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/81.0.4044.138 YandexStation2/1.10.1.24.808865580.20201030.10 (YandexIO)",
			Features: []string{
				"absolute_volume_change",
				"relative_volume_change",
				"mordovia_webview",
				"multiroom",
				"multiroom_cluster",
				"multiroom_audio_client",
				"change_alarm_sound",
				"change_alarm_sound_level",
				"music_player_allow_shots",
				"led_display",
				"clock_display",
				"audio_client",
				"audio_client_hls",
				"tts_play_placeholder",
				"bluetooth_rcu",
				"incoming_messenger_calls",
				"outgoing_messenger_calls",
				"publicly_available",
				"video_codec_AVC",
				"video_codec_HEVC",
				"video_codec_VP9",
				"audio_codec_AAC",
				"audio_codec_AC3",
				"audio_codec_EAC3",
				"audio_codec_VORBIS",
				"audio_codec_OPUS",
				"notifications",
				"bluetooth_player",
				"cec_available",
				"directive_sequencer",
				"set_alarm_semantic_frame_v2",
				"stereo_pair",
				"muzpult",
				"audio_bitrate192",
				"audio_bitrate320",
				"prefetch_invalidation",
				"equalizer",
			},
		},
		"yandexmini": {
			AppID:              "aliced",
			AppVersion:         "1.0",
			OSVersion:          "1.0",
			Platform:           "Linux",
			DeviceID:           "feedface-4e95-4fc9-ba19-7bf943a7bf55",
			DeviceModel:        "yandexmini",
			DeviceManufacturer: "Yandex",
			AuthToken:          "51ae06cc-5c8f-48dc-93ae-7214517679e6",
			ASRTopic:           "quasar-general",
			UserAgent:          "Mozilla/5.0 (Linux; Android 6.0.1; Station Build/MOB30J; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/61.0.3163.98 Safari/537.36 YandexStation/2.3.0.3.373060213.20190204.develop.ENG (YandexIO)",
			Features: []string{
				"absolute_volume_change",
				"relative_volume_change",
				"multiroom",
				"multiroom_cluster",
				"multiroom_audio_client",
				"change_alarm_sound",
				"change_alarm_sound_level",
				"music_player_allow_shots",
				"bluetooth_player",
				"audio_client",
				"audio_client_hls",
				"notifications",
				"tts_play_placeholder",
				"incoming_messenger_calls",
				"outgoing_messenger_calls",
				"publicly_available",
				"directive_sequencer",
				"set_alarm_semantic_frame_v2",
				"stereo_pair",
				"muzpult",
				"audio_bitrate192",
				"audio_bitrate320",
				"prefetch_invalidation",
			},
		},
		"yandexmidi": {
			AppID:              "aliced",
			AppVersion:         "1.0",
			OSVersion:          "1.0",
			Platform:           "Linux",
			DeviceID:           "feedface-2fcf-49bf-ac11-c68ad244e4ff",
			DeviceModel:        "yandexmidi",
			DeviceManufacturer: "Yandex",
			AuthToken:          "51ae06cc-5c8f-48dc-93ae-7214517679e6",
			ASRTopic:           "quasar-general",
			UserAgent:          "Mozilla/5.0 (Linux; Android 6.0.1; Station Build/MOB30J; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/61.0.3163.98 Safari/537.36 YandexStation/2.3.0.3.373060213.20190204.develop.ENG (YandexIO)",
			Features: []string{
				"absolute_volume_change",
				"relative_volume_change",
				"multiroom",
				"multiroom_cluster",
				"multiroom_audio_client",
				"change_alarm_sound",
				"change_alarm_sound_level",
				"music_player_allow_shots",
				"bluetooth_player",
				"audio_client",
				"audio_client_hls",
				"notifications",
				"tts_play_placeholder",
				"incoming_messenger_calls",
				"outgoing_messenger_calls",
				"publicly_available",
				"directive_sequencer",
				"set_alarm_semantic_frame_v2",
				"stereo_pair",
				"muzpult",
				"audio_bitrate192",
				"audio_bitrate320",
				"prefetch_invalidation",
			},
		},
		"dexp": {
			AppID:              "aliced",
			AppVersion:         "1.0",
			OSVersion:          "1.0",
			Platform:           "Linux",
			DeviceID:           "feedface-0497-42f0-9227-206459a7f439",
			DeviceModel:        "lightcomm",
			DeviceManufacturer: "Dexp",
			AuthToken:          "51ae06cc-5c8f-48dc-93ae-7214517679e6",
			ASRTopic:           "quasar-general",
			UserAgent:          "Mozilla/5.0 (Linux; Android 6.0.1; Station Build/MOB30J; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/61.0.3163.98 Safari/537.36 YandexStation/2.3.0.3.373060213.20190204.develop.ENG (YandexIO)",
			Features: []string{
				"change_alarm_sound",
				"music_player_allow_shots",
			},
		},
		"yandexmicro_beige": {
			AppID:              "aliced",
			AppVersion:         "1.0",
			OSVersion:          "1.0",
			Platform:           "Linux",
			DeviceID:           "fBedface-4e95-4fc9-ba19-7bf943a7bf55",
			DeviceModel:        "yandexmicro",
			DeviceManufacturer: "Yandex",
			AuthToken:          "51ae06cc-5c8f-48dc-93ae-7214517679e6",
			ASRTopic:           "quasar-general",
			UserAgent:          "Mozilla/5.0 (Linux; Android 6.0.1; Station Build/MOB30J; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/61.0.3163.98 Safari/537.36 YandexStation/2.3.0.3.373060213.20190204.develop.ENG (YandexIO)",
			Features: []string{
				"absolute_volume_change",
				"relative_volume_change",
				"multiroom",
				"multiroom_cluster",
				"multiroom_audio_client",
				"change_alarm_sound",
				"change_alarm_sound_level",
				"music_player_allow_shots",
				"bluetooth_player",
				"audio_client",
				"audio_client_hls",
				"notifications",
				"tts_play_placeholder",
				"incoming_messenger_calls",
				"outgoing_messenger_calls",
				"publicly_available",
				"directive_sequencer",
				"set_alarm_semantic_frame_v2",
				"stereo_pair",
				"muzpult",
				"audio_bitrate192",
				"audio_bitrate320",
				"prefetch_invalidation",
			},
		},
		"yandexmicro_red": {
			AppID:              "aliced",
			AppVersion:         "1.0",
			OSVersion:          "1.0",
			Platform:           "Linux",
			DeviceID:           "fRedface-4e95-4fc9-ba19-7bf943a7bf55",
			DeviceModel:        "yandexmicro",
			DeviceManufacturer: "Yandex",
			AuthToken:          "51ae06cc-5c8f-48dc-93ae-7214517679e6",
			ASRTopic:           "quasar-general",
			UserAgent:          "Mozilla/5.0 (Linux; Android 6.0.1; Station Build/MOB30J; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/61.0.3163.98 Safari/537.36 YandexStation/2.3.0.3.373060213.20190204.develop.ENG (YandexIO)",
			Features: []string{
				"absolute_volume_change",
				"relative_volume_change",
				"multiroom",
				"multiroom_cluster",
				"multiroom_audio_client",
				"change_alarm_sound",
				"change_alarm_sound_level",
				"music_player_allow_shots",
				"bluetooth_player",
				"audio_client",
				"audio_client_hls",
				"notifications",
				"tts_play_placeholder",
				"incoming_messenger_calls",
				"outgoing_messenger_calls",
				"publicly_available",
				"directive_sequencer",
				"set_alarm_semantic_frame_v2",
				"stereo_pair",
				"muzpult",
				"audio_bitrate192",
				"audio_bitrate320",
				"prefetch_invalidation",
			},
		},
		"yandexmicro_green": {
			AppID:              "aliced",
			AppVersion:         "1.0",
			OSVersion:          "1.0",
			Platform:           "Linux",
			DeviceID:           "fGedface-4e95-4fc9-ba19-7bf943a7bf55",
			DeviceModel:        "yandexmicro",
			DeviceManufacturer: "Yandex",
			AuthToken:          "51ae06cc-5c8f-48dc-93ae-7214517679e6",
			ASRTopic:           "quasar-general",
			UserAgent:          "Mozilla/5.0 (Linux; Android 6.0.1; Station Build/MOB30J; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/61.0.3163.98 Safari/537.36 YandexStation/2.3.0.3.373060213.20190204.develop.ENG (YandexIO)",
			Features: []string{
				"absolute_volume_change",
				"relative_volume_change",
				"multiroom",
				"multiroom_cluster",
				"multiroom_audio_client",
				"change_alarm_sound",
				"change_alarm_sound_level",
				"music_player_allow_shots",
				"bluetooth_player",
				"audio_client",
				"audio_client_hls",
				"notifications",
				"tts_play_placeholder",
				"incoming_messenger_calls",
				"outgoing_messenger_calls",
				"publicly_available",
				"directive_sequencer",
				"set_alarm_semantic_frame_v2",
				"stereo_pair",
				"muzpult",
				"audio_bitrate192",
				"audio_bitrate320",
				"prefetch_invalidation",
			},
		},
		"yandexmicro_purple": {
			AppID:              "aliced",
			AppVersion:         "1.0",
			OSVersion:          "1.0",
			Platform:           "Linux",
			DeviceID:           "fPedface-4e95-4fc9-ba19-7bf943a7bf55",
			DeviceModel:        "yandexmicro",
			DeviceManufacturer: "Yandex",
			AuthToken:          "51ae06cc-5c8f-48dc-93ae-7214517679e6",
			ASRTopic:           "quasar-general",
			UserAgent:          "Mozilla/5.0 (Linux; Android 6.0.1; Station Build/MOB30J; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/61.0.3163.98 Safari/537.36 YandexStation/2.3.0.3.373060213.20190204.develop.ENG (YandexIO)",
			Features: []string{
				"absolute_volume_change",
				"relative_volume_change",
				"multiroom",
				"multiroom_cluster",
				"multiroom_audio_client",
				"change_alarm_sound",
				"change_alarm_sound_level",
				"music_player_allow_shots",
				"bluetooth_player",
				"audio_client",
				"audio_client_hls",
				"notifications",
				"tts_play_placeholder",
				"incoming_messenger_calls",
				"outgoing_messenger_calls",
				"publicly_available",
				"directive_sequencer",
				"set_alarm_semantic_frame_v2",
				"stereo_pair",
				"muzpult",
				"audio_bitrate192",
				"audio_bitrate320",
				"prefetch_invalidation",
			},
		},
		"yandexmicro_yellow": {
			AppID:              "aliced",
			AppVersion:         "1.0",
			OSVersion:          "1.0",
			Platform:           "Linux",
			DeviceID:           "fYedface-4e95-4fc9-ba19-7bf943a7bf55",
			DeviceModel:        "yandexmicro",
			DeviceManufacturer: "Yandex",
			AuthToken:          "51ae06cc-5c8f-48dc-93ae-7214517679e6",
			ASRTopic:           "quasar-general",
			UserAgent:          "Mozilla/5.0 (Linux; Android 6.0.1; Station Build/MOB30J; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/61.0.3163.98 Safari/537.36 YandexStation/2.3.0.3.373060213.20190204.develop.ENG (YandexIO)",
			Features: []string{
				"absolute_volume_change",
				"relative_volume_change",
				"multiroom",
				"multiroom_cluster",
				"multiroom_audio_client",
				"change_alarm_sound",
				"change_alarm_sound_level",
				"music_player_allow_shots",
				"bluetooth_player",
				"audio_client",
				"audio_client_hls",
				"notifications",
				"tts_play_placeholder",
				"incoming_messenger_calls",
				"outgoing_messenger_calls",
				"publicly_available",
				"directive_sequencer",
				"set_alarm_semantic_frame_v2",
				"stereo_pair",
				"muzpult",
				"audio_bitrate192",
				"audio_bitrate320",
				"prefetch_invalidation",
			},
		},
		"yandexmicro_pink": {
			AppID:              "aliced",
			AppVersion:         "1.0",
			OSVersion:          "1.0",
			Platform:           "Linux",
			DeviceID:           "fNedface-4e95-4fc9-ba19-7bf943a7bf55",
			DeviceModel:        "yandexmicro",
			DeviceManufacturer: "Yandex",
			AuthToken:          "51ae06cc-5c8f-48dc-93ae-7214517679e6",
			ASRTopic:           "quasar-general",
			UserAgent:          "Mozilla/5.0 (Linux; Android 6.0.1; Station Build/MOB30J; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/61.0.3163.98 Safari/537.36 YandexStation/2.3.0.3.373060213.20190204.develop.ENG (YandexIO)",
			Features: []string{
				"absolute_volume_change",
				"relative_volume_change",
				"multiroom",
				"multiroom_cluster",
				"multiroom_audio_client",
				"change_alarm_sound",
				"change_alarm_sound_level",
				"music_player_allow_shots",
				"bluetooth_player",
				"audio_client",
				"audio_client_hls",
				"notifications",
				"tts_play_placeholder",
				"incoming_messenger_calls",
				"outgoing_messenger_calls",
				"publicly_available",
				"directive_sequencer",
				"set_alarm_semantic_frame_v2",
				"stereo_pair",
				"muzpult",
				"audio_bitrate192",
				"audio_bitrate320",
				"prefetch_invalidation",
			},
		},
	}
)
