# Куб активаций Android TV

В кубе лежат данные со всеми активациями Android TV за всю историю. Не учитываются активации на заводах.

Хранится 7 последних версий таблиц. Каждый день данные пересчитываются за всю историю

Исходные данные: `//home/sda/cubes/tv/dayuse/{date}`
Путь до таблиц на YT: `//home/sda/cubes/tv/activations/{date}`

## Описание полей таблицы

+ `↓ device_id` - метричный device_id пользователя (уникальный ключ)
+ `activation_date` - дата активации устройства
+ `app_version` - версия прошивки в формате `{board}@{platform}@{firmware_version}@{build}` для устройств, начиная с версии 1.2.1
+ `firmware_version` - человекочитаемая версия прошивки из поля `app_version`
+ `build_fingerprint` - fingerprint сборки
+ `manufacturer` - производитель телевизора
+ `model` - модель телевизора
+ `diagonal` - диагональ экрана устройства
+ `resolution` - разрешение экрана устройства
+ `crypta_id` - свежий crypta_id пользователя на дату расчёта
+ `clid1` - установочный клид (по первой дате, где поле было не пустым)
+ `build` - сборка из поля `app_version` (по первой дате, где поле было не пустым)
+ `board` - производитель платы из поля `app_version` (по первой дате, где поле было не пустым)
+ `platform` - базовая платформа из поля `app_version` (по первой дате, где поле было не пустым)
+ `geo_id` - регион пользователя (по первой дате, где поле было не пустым)
+ `eth0` - ethernet mac-адрес устройства
