В этой папке скрипты, использовавшиеся для сбора корзин.
В скриптах прописаны папки для insert'ов, не забудьте поправить.

**Сбор данных из логов**

Сейчас мы собираем основную часть данных из вандерлогов. Часть полей, например, input_type, который хитро вычисляется, приджойниваем из prepared. Еще для данных с пустым распознаванием сейчас нужен еще один join с логами asr, чтобы узнать, какие из данных с пустым распознаванием входят в эксперимент с дослушиванием. По вандерлогам мы этого не может понять, потому что для пустого распознавания там часто не доезжают тестиды.
Важный момент - сейчас брать сами вандерлоги в качестве входных данных мы не можем из-за формата device_state в них - он не парсится прокачкой. Поэтому первый шаг сбора - Ранис строит нам таблички на базе вандерлогов, где все поля в нужном формате. В текущий сбор он сложил их по этому адресу: https://yt.yandex-team.ru/hahn/navigation?path=//home/alice/wonder/basket-data.
Даты для сбора основных корзин берем обычно за полгода. В последний сбор я брала даты 2021-02-26 - 2021-08-29.
Скрипты для сбора:
`join_data_from_expboxes_and_wonder_basket_data.yql`
`empty_asr_data_from_expboxes_and_wonder_basket_data.yql`
Запускаются, как есть, нужно заменить только даты сбора ($date_start, $date_end), адрес до табличек Раниса, если он изменился ($wonder_basket_logs), и путь для итоговых таблиц ($output_dir).
ToDo: скрипты можно будет объединить, если сделают тикет: VOICESERV-4051

**Первичное семплирование**
Один скрипт, но с разными action'ами: `make_initial_sampling.yql`

Проверка того, что посемплировалось: https://yql.yandex-team.ru/Operations/Xjp7Np3udlz7oknGh-K8Ii0j31RfXiidR5qYkwKGlD0=
Проверяю пересечения семплов не рекидам и uuid, смотрю представленность дат, uuid'ов и интентов (не должны были насемплировать из одной даты или одного пользователя, и тем более из одного интента), смотрю, что представлены все нужные нам приложения. В блоке queries stats смотрю, что с станционные семплы попали только голосовые типы запросов со ссылком на голос, а в выборку general попали ещё и текстовые запросы, а также смотрю, что туда не просочились запросы из прокачек, блеклиста, который появился в ходе других отсмотров (временный), и что получились правильные доли старых и новых пользователей.

NB! Надо было выкидывать срабатывания внутри external_skill (не вызов навыка, а всё, что внутри навыка или окончание навыка). Это согласовано с командой внешних навыков. Делаем так из-за риска передачи приватных данных

**Разметки**
Тут пропущены шаги с разметками на аннотирование и интенты.
Там довольно мелкие yql (и есть some magic от Эда), есть в пайплайне тут: https://st.yandex-team.ru/VA-1189#5e3c8c23daa6b659b195d6cd

**Семплирование**
1. `basket_sampling_preparation.yql` - объединяют инфу из корзинок, подготовленных на этапе сбора, и разметок (аннотирования, классификации интентов), чтоб потом было удобнее стратифицировать
2. `basket_sampling_for_none_voice.yql` - простое семплирование из запросов, на которых толокеры/асессоры сказали, что голосовая запись пуста
3. `basket_stratification_and_sampling.yql` - стратификация по интентам и хешу от asr текста запроса и проаннотированного запроса. Довольно агрессивно вытягивает хвосты.
   Здесь лежит адаптированная под запуск из Нирваны версия. Пример запуска: https://nirvana.yandex-team.ru/flow/fb3783f7-4b4e-439d-9745-8f0ea4cdd227/ed1e9ac7-d7af-4368-b69c-fbc7ee940d85/graph
   Запрос, которым реально семплировалось, тут: https://yql.yandex-team.ru/Operations/Xnh8RGim9eZONQMD-sg1Ct__HozbYGjfZouQcog0fUQ=

**Глубокий контекст и формирование корзины**
1. `form_deep_context.yql` - приджойнивает из заготовленных полугодовых табличек данные к посемплированной части
2. `prepare_for_context_markup.yql` - готовит входную табличку для графа разметки на глубину контекста
3. Дополнительно доставала этим deep_context, но с другими LAG, контексты для запросов, в которых не надо было ничо отвечать: https://yql.yandex-team.ru/Operations/XpSO3J9LnjuGBCGRlBd55TSbpC0FdxxNbWfC3X27TJo=
3. `form_not_patched_ue2e_basket.yql` - формирует из всех табличек непропатченную корзинку (нет патчинга device_state и правильного force_intent/force_scenario) ue2e
   Вот так проверяла получившееся: https://yql.yandex-team.ru/Operations/Xpnw_p3udh7n5qy1WB-OtHEo1KPAoSneNRMm4eRaiq0=
   Запускала отдельно для accept/kpi.

#ToDo: упростить формирование глубокого контекста и скрипт формирования корзины. Кажется, что много лишних телодвижений получилось.
