## AR ASR AGGREGATOR
`alice/analytics/ww/arabic/asr_annotation/aggregator`

Аггрегация результатов арабского аннотирования (транскрибирования) аудио в текст

Алгоритм для каждого аудио с 5-ю вариантами написания выбирет наиболее часто встречаемый и оценит уверенность ответа

Результат работы лучше всего сразу смотреть [тут](https://a.yandex-team.ru/arcadia/alice/analytics/ww/arabic/asr_annotation/aggregator/tests/canondata/test_aggregation.test_aggregation/test_data.out.json?rev=2196d110287a8397c125ef11710697cb917ae9df#L228-311)

### Описание алгоритма аггрегации:
* для всех текстов применяются нормализации текста на арабском. Подробнее про нормализацию - ниже
* если из всех вариантов написания текста есть 3+ совпадающих по полному тексту — то выбираем его в качестве результата
* если же все 5 вариантов отличаются по тексту, пробуем пословную аггрегацию:
    * считаем число слов в запросе (самое часто встречаемое число слов)
    * в цикле по словам, для каждого индекса слова, независимо выбирается самое частотное слово
    * если для каждого слова есть 2+ совпадающих по тексту — то выбираем его, слово "уверенное"
    * если все слова в результате — уверенные, то всё хорошо, считаем весь результат "уверенным"
* если не удалось получить уверенный результат разными способами, выставляется `is_bad_item: True`

### Описание файлов:
* `main.py` — бинарник, запускающийся на объединённых результатах после Толоки, выполняет аггрегацию текстов
* `lib/aggregate.py` - основной код аггрегации
* `lib/normalize.py` - содержит нормализации текста
* `tests/test_data.in.json` - тесты на сложные случаи. Результаты смотреть сразу в `tests/canondata/test_aggregation.test_aggregation/test_data.out.json`
* Пришлось скопипастить часть кода из https://github.com/linuxscout/tashaphyne — Arabic Light Stemmer (tashaphyne_contrib.py, arabic_const.py)

### Нормализации текста:
* `lower` — всё к нижнему регистру
* `unicodedata` — нормализовать юникодные символы ("разлепить лигатуры")
* `digits` — цифры прописью
* `spn` — пропуски слов (SPN, spoken noise) ؟ -> ?
* `punctuation` — убрать пунктуацию
* `strip_tashkeel` — убрать огласовки
* `strip_tatweel` — убрать татвиль (underscore)
* `hamza` — убрать хамзы над/под Алефом
* `space` — оставить одинарные пробелы

### Формат возвращаемых данных:
* `result_mv` — str, результат аггрегирования, самый часто-встречающийся текст
* `is_bad_item` — bool, если True, то результат получился неуверенный. Такую аннотацию нельзя использовать. Лучше отправить аудио на до- (пере-) разметку в Толоку
* `mv_probability` — double, доля одинаковых текстов-аннотация для каждого аудио. от 0 до 1. При пословной аггрегации — доля одинаковых слов в результате result_mv
* `answers_normalized` — dict, объект, ключами которого являются нормализованные тексты от толокеров, а значениями — количество их
* `stats` — dict, объект с расширенной статистикой
    * `mv_words_votes` — int, число совпадающих слов в результате аггрегирования с исходными текстами
    * `total_words_votes` — int, общее количество слов во всех текстах
    * `words_count` — int, количество слов в результате result_mv
    * `words_details` — list, массив с информацией по каждому слову из result_mv: 
        * `mv` — int количество голосов за каждое слово
        * `second` — int количество голосов за топ-2 слово 
        * `total` — int всего аннотаций этого слова
        * `word` — str слово

### Идеи для улучшения:
* **выравнивание слов**: сейчас мы никак не выравниваем текста друг относительно друга. Просто по-порядку идём. И это уже сейчас [хорошо работает](https://st.yandex-team.ru/ATAN-628#62b5b9a258c2023af37a618d). Иногда толокеры пропускают слова в середине аудио. И из-за этого "съезжают" все остальные слова. Тут можно было бы все слова выровнять друг относительно друга (например минимизировав суммарное расстояние Левенштейна между всеми текстами) и это бы дало больше уверенных слов