#pragma once

#include <util/generic/strbuf.h>

namespace NBASS::NCrmbot {

enum class EOrderStatus {
    UNKNOWN    = -1 /* "UNKNOWN" */,
    PLACING    =  0 /* "PLACING" */,
    RESERVED   =  1 /* "RESERVED" */,
    UNPAID     =  2 /* "UNPAID" */,
    PROCESSING =  3 /* "PROCESSING" */,
    DELIVERY   =  4 /* "DELIVERY" */,
    PICKUP     =  5 /* "PICKUP" */,
    DELIVERED  =  6 /* "DELIVERED" */,
    CANCELLED  =  7 /* "CANCELLED" */,
    PENDING    =  8 /* "PENDING" */
};

enum class EOrderSubstatus {
    RESERVATION_EXPIRED /* "RESERVATION_EXPIRED" */,
    USER_NOT_PAID /* "USER_NOT_PAID" */,
    USER_UNREACHABLE /* "USER_UNREACHABLE" */,
    USER_CHANGED_MIND /* "USER_CHANGED_MIND" */,
    USER_REFUSED_DELIVERY /* "USER_REFUSED_DELIVERY" */,
    USER_REFUSED_PRODUCT /* "USER_REFUSED_PRODUCT" */,
    SHOP_FAILED /* "SHOP_FAILED" */,
    USER_REFUSED_QUALITY /* "USER_REFUSED_QUALITY" */,
    REPLACING_ORDER /* "REPLACING_ORDER" */,
    PROCESSING_EXPIRED /* "PROCESSING_EXPIRED" */,
    PENDING_EXPIRED /* "PENDING_EXPIRED" */,
    SHOP_PENDING_CANCELLED /* "SHOP_PENDING_CANCELLED" */,
    PENDING_CANCELLED /* "PENDING_CANCELLED" */,
    USER_FRAUD /* "USER_FRAUD" */,
    RESERVATION_FAILED /* "RESERVATION_FAILED" */,
    USER_PLACED_OTHER_ORDER /* "USER_PLACED_OTHER_ORDER" */,
    USER_BOUGHT_CHEAPER /* "USER_BOUGHT_CHEAPER" */,
    MISSING_ITEM /* "MISSING_ITEM" */,
    BROKEN_ITEM /* "BROKEN_ITEM" */,
    WRONG_ITEM /* "WRONG_ITEM" */,
    PICKUP_EXPIRED /* "PICKUP_EXPIRED" */,
    DELIVERY_PROBLEMS /* "DELIVERY_PROBLEMS" */,
    LATE_CONTACT /* "LATE_CONTACT" */,
    CUSTOM /* "CUSTOM" */,
    DELIVERY_SERVICE_FAILED /* "DELIVERY_SERVICE_FAILED" */,
    WAREHOUSE_FAILED_TO_SHIP /* "WAREHOUSE_FAILED_TO_SHIP" */,
    DELIVERY_SERIVCE_UNDELIVERED /* "DELIVERY_SERIVCE_UNDELIVERED" */,
    PREORDER /* "PREORDER" */,
    AWAIT_CONFIRMATION /* "AWAIT_CONFIRMATION" */,
    STARTED /* "STARTED" */,
    PACKAGING /* "PACKAGING" */,
    READY_TO_SHIP /* "READY_TO_SHIP" */,
    SHIPPED /* "SHIPPED" */,
    ASYNC_PROCESSING /* "ASYNC_PROCESSING" */,
    USER_REFUSED_TO_PROVIDE_PERSONAL_DATA /* "USER_REFUSED_TO_PROVIDE_PERSONAL_DATA" */,
    WAITING_USER_INPUT /* "WAITING_USER_INPUT" */,
    WAITING_BANK_DECISION /* "WAITING_BANK_DECISION" */,
    BANK_REJECT_CREDIT_OFFER /* "BANK_REJECT_CREDIT_OFFER" */,
    CUSTOMER_REJECT_CREDIT_OFFER /* "CUSTOMER_REJECT_CREDIT_OFFER" */,
    CREDIT_OFFER_FAILED /* "CREDIT_OFFER_FAILED" */,
    AWAIT_DELIVERY_DATES_CONFIRMATION /* "AWAIT_DELIVERY_DATES_CONFIRMATION" */,
    SERVICE_FAULT /* "SERVICE_FAULT" */,
    DELIVERY_SERVICE_RECEIVED /* "DELIVERY_SERVICE_RECEIVED" */,
    USER_RECEIVED /* "USER_RECEIVED" */,
    WAITING_FOR_STOCKS /* "WAITING_FOR_STOCKS" */,
    UNKNOWN /* "UNKNOWN" */
};

enum class EDeliveryType {
    DELIVERY /* "DELIVERY" */,
    PICKUP   /* "PICKUP" */,
    POST     /* "POST" */,
    DIGITAL  /* "DIGITAL" */,
    UNKNOWN  /* "UNKNOWN" */
};

enum class ECheckpointStatus {
    PENDING          /* "PENDING" */,
    INFO_RECEIVED    /* "INFO_RECEIVED" */,
    IN_TRANSIT       /* "IN_TRANSIT" */,
    OUT_FOR_DELIVERY /* "OUT_FOR_DELIVERY" */,
    ATTEMPT_FAIL     /* "ATTEMPT_FAIL" */,
    DELIVERED        /* "DELIVERED" */,
    EXCEPTION        /* "EXCEPTION" */,
    EXPIRED          /* "EXPIRED" */,
    UNKNOWN          /* "UNKNOWN" */
};

enum class EDSCheckpointStatus { // not enum class because they are returned as numbers by checkouter
    SENDER_SENT = 0 /* "SENDER_SENT" */,
    DELIVERY_LOADED = 1 /* "DELIVERY_LOADED" */,
    ERROR = 2 /* "ERROR" */,
    DELIVERY_AT_START = 10 /* "DELIVERY_AT_START" */,
    DELIVERY_AT_START_SORT = 20 /* "DELIVERY_AT_START_SORT" */,
    DELIVERY_TRANSPORTATION = 30 /* "DELIVERY_TRANSPORTATION" */,
    DELIVERY_CUSTOMS_ARRIVED = 38 /* "DELIVERY_CUSTOMS_ARRIVED" */,
    DELIVERY_CUSTOMS_CLEARED = 39 /* "DELIVERY_CUSTOMS_CLEARED" */,
    DELIVERY_ARRIVED = 40 /* "DELIVERY_ARRIVED" */,
    DELIVERY_STORAGE_PERIOD_EXTENDED = 42 /* "DELIVERY_STORAGE_PERIOD_EXTENDED" */,
    DELIVERY_STORAGE_PERIOD_EXPIRED = 43 /* "DELIVERY_STORAGE_PERIOD_EXPIRED" */,
    DELIVERY_UPDATED_BY_SHOP = 44 /* "DELIVERY_UPDATED_BY_SHOP" */,
    DELIVERY_ARRIVED_PICKUP_POINT = 45 /* "DELIVERY_ARRIVED_PICKUP_POINT" */,
    DELIVERY_UPDATED_BY_RECIPIENT = 46 /* "DELIVERY_UPDATED_BY_RECIPIENT" */,
    DELIVERY_UPDATED_BY_DELIVERY = 47 /* "DELIVERY_UPDATED_BY_DELIVERY" */,
    DELIVERY_TRANSPORTATION_RECIPIENT = 48 /* "DELIVERY_TRANSPORTATION_RECIPIENT" */,
    DELIVERY_TRANSMITTED_TO_RECIPIENT = 49 /* "DELIVERY_TRANSMITTED_TO_RECIPIENT" */,
    DELIVERY_DELIVERED = 50 /* "DELIVERY_DELIVERED" */,
    RETURN_PREPARING = 60 /* "RETURN_PREPARING" */,
    RETURN_ARRIVED_DELIVERY = 70 /* "RETURN_ARRIVED_DELIVERY" */,
    RETURN_TRANSMITTED_FULFILMENT = 80 /* "RETURN_TRANSMITTED_FULFILMENT" */,
    DELIVERY_ATTEMPT_FAILED = 90 /* "DELIVERY_ATTEMPT_FAILED" */,
    DELIVERY_CAN_NOT_BE_COMPLETED = 412 /* "DELIVERY_CAN_NOT_BE_COMPLETED" */,
    SORTING_CENTER_CREATED = 100 /* "SORTING_CENTER_CREATED" */,
    SORTING_CENTER_LOADED = 101 /* "SORTING_CENTER_LOADED" */,
    SORTING_CENTER_ERROR = 102 /* "SORTING_CENTER_ERROR" */,
    SORTING_CENTER_CANCELED = 105 /* "SORTING_CENTER_CANCELED" */,
    SORTING_CENTER_AT_START = 110 /* "SORTING_CENTER_AT_START" */,
    SORTING_CENTER_OUT_OF_STOCK = 113 /* "SORTING_CENTER_OUT_OF_STOCK" */,
    SORTING_CENTER_AWAITING_CLARIFICATION = 117 /* "SORTING_CENTER_AWAITING_CLARIFICATION" */,
    SORTING_CENTER_PREPARED = 120 /* "SORTING_CENTER_PREPARED" */,
    SORTING_CENTER_TRANSMITTED = 130 /* "SORTING_CENTER_TRANSMITTED" */,
    SORTING_CENTER_RETURN_PREPARING = 160 /* "SORTING_CENTER_RETURN_PREPARING" */,
    SORTING_CENTER_RETURN_ARRIVED = 170 /* "SORTING_CENTER_RETURN_ARRIVED" */,
    SORTING_CENTER_RETURN_PREPARING_SENDER = 175 /* "SORTING_CENTER_RETURN_PREPARING_SENDER" */,
    SORTING_CENTER_RETURN_TRANSFERRED = 177 /* "SORTING_CENTER_RETURN_TRANSFERRED" */,
    SORTING_CENTER_RETURN_RETURNED = 180 /* "SORTING_CENTER_RETURN_RETURNED" */,
    SORTING_CENTER_RETURN_RFF_PREPARING_FULFILLMENT = 195 /* "SORTING_CENTER_RETURN_RFF_PREPARING_FULFILLMENT" */,
    SORTING_CENTER_RETURN_RFF_TRANSMITTED_FULFILLMENT = 197 /* "SORTING_CENTER_RETURN_RFF_TRANSMITTED_FULFILLMENT" */,
    SORTING_CENTER_RETURN_RFF_ARRIVED_FULFILLMENT = 199 /* "SORTING_CENTER_RETURN_RFF_ARRIVED_FULFILLMENT" */,
    LOST = 403 /* "LOST" */,
    ERROR_NOT_FOUND = 404 /* "ERROR_NOT_FOUND" */,
    CANCELED = 410 /* "CANCELED" */,
    UNKNOWN = -1 /* "UNKNOWN" */
};

enum class EOrderChangeType {
    NEW_ORDER = 0 /* "NEW_ORDER" */,
    ORDER_STATUS_UPDATED = 1 /* "ORDER_STATUS_UPDATED" */,
    ORDER_DELIVERY_UPDATED = 2 /* "ORDER_DELIVERY_UPDATED" */,
    NEW_PAYMENT = 3 /* "NEW_PAYMENT" */,
    REFUND = 4 /* "REFUND" */,
    ORDER_UID_UPDATED = 5 /* "ORDER_UID_UPDATED" */,
    ARCHIVED = 6 /* "ARCHIVED" */,
    NEW_SUBSIDY = 7 /* "NEW_SUBSIDY" */,
    SUBSIDY_REFUND = 8 /* "SUBSIDY_REFUND" */,
    DEARCHIVED = 9 /* "DEARCHIVED" */,
    TRACK_CHECKPOINT_CHANGED = 10 /* "TRACK_CHECKPOINT_CHANGED" */,
    RECEIPT_PRINTED = 11 /* "RECEIPT_PRINTED" */,
    BUYER_BEEN_CALLED = 12 /* "BUYER_BEEN_CALLED" */,
    ITEMS_UPDATED = 13 /* "ITEMS_UPDATED" */,
    NEW_CASH_PAYMENT = 14 /* "NEW_CASH_PAYMENT" */,
    DELIVERY_EXPIRY_STARTED = 15 /* "DELIVERY_EXPIRY_STARTED" */,
    USER_RECEIVED_ORDER = 16 /* "USER_RECEIVED_ORDER" */,
    SHIPMENT_UPDATED = 17 /* "SHIPMENT_UPDATED" */,
    RECEIPT_GENERATED = 18 /* "RECEIPT_GENERATED" */,
    NEW_COMPENSATION = 19 /* "NEW_COMPENSATION" */,
    REBIND_PAYMENT = 20 /* "REBIND_PAYMENT" */,
    ORDER_RETURN_CREATED = 21 /* "ORDER_RETURN_CREATED" */,
    ORDER_RETURN_STATUS_UPDATED = 22 /* "ORDER_RETURN_STATUS_UPDATED" */,
    TRACK_UPDATED = 23 /* "TRACK_UPDATED" */,
    ORDER_CANCELLATION_REQUESTED = 24 /* "ORDER_CANCELLATION_REQUESTED" */,
    ORDER_ITEM_RECEIVED = 25 /* "ORDER_ITEM_RECEIVED" */,
    ORDER_RETURN_TRACK_CHECKPOINT_CHANGED = 26 /* "ORDER_RETURN_TRACK_CHECKPOINT_CHANGED" */,
    ORDER_SUBSTATUS_UPDATED = 27 /* "ORDER_SUBSTATUS_UPDATED" */,
    CASH_REFUND = 28 /* "CASH_REFUND" */,
    CASH_REFUND_RECEIPT_PRINTED = 29 /* "CASH_REFUND_RECEIPT_PRINTED" */,
    PARCEL_BOXES_CHANGED = 30 /* "PARCEL_BOXES_CHANGED" */,
    PARCEL_BOXES_UPDATED = 31 /* "PARCEL_BOXES_UPDATED" */,
    PARCEL_BOX_ITEMS_CHANGED = 32 /* "PARCEL_BOX_ITEMS_CHANGED" */,
    ORDER_BUYER_UPDATED = 33 /* "ORDER_BUYER_UPDATED" */,
    PARCEL_DELIVERED_AT_UPDATED = 34 /* "PARCEL_DELIVERED_AT_UPDATED" */,
    RECEIPT_FAILED = 35 /* "RECEIPT_FAILED" */,
    NEW_SUPPLIER_PAYMENT = 36 /* "NEW_SUPPLIER_PAYMENT" */,
    PARCEL_CANCELLATION_REQUESTED = 37 /* "PARCEL_CANCELLATION_REQUESTED" */,
    PARCEL_CANCELLATION_REQUEST_UPDATED = 38 /* "PARCEL_CANCELLATION_REQUEST_UPDATED" */,
    PARCEL_UPDATED = 39 /* "PARCEL_UPDATED" */,
    ORDER_CHANGE_REQUEST_CREATED = 40 /* "ORDER_CHANGE_REQUEST_CREATED" */,
    ORDER_CHANGE_REQUEST_STATUS_UPDATED = 41 /* "ORDER_CHANGE_REQUEST_STATUS_UPDATED" */,
    PARCEL_SUPPLIER_SHIPMENT_DATE_TIME_UPDATED = 42 /* "PARCEL_SUPPLIER_SHIPMENT_DATE_TIME_UPDATED" */,
    PARCEL_DELIVERY_DEADLINE_STATUS_UPDATED = 43 /* "PARCEL_DELIVERY_DEADLINE_STATUS_UPDATED" */,
    ORDER_PAYMENT_METHOD_UPDATED = 44 /* "ORDER_PAYMENT_METHOD_UPDATED" */,
    UNKNOWN = -1 /* "UNKNOWN" */
};

enum class EDeliveryChangeReason {
    SHIPPING_DELAYED = 0 /* "SHIPPING_DELAYED" */,
    DELIVERY_SERVICE_DELAYED = 1 /* "DELIVERY_SERVICE_DELAYED" */,
    USER_MOVED_DELIVERY_DATES = 2 /* "USER_MOVED_DELIVERY_DATES" */,
    DELAYED_DUE_EXTERNAL_CONDITIONS = 3 /* "DELAYED_DUE_EXTERNAL_CONDITIONS" */,
    DELIVERY_SERVICE_PROBLEM = 4 /* "DELIVERY_SERVICE_PROBLEM" */,
    USER_MOVED_DELIVERY_DATES_BY_DS = 5 /* "USER_MOVED_DELIVERY_DATES_BY_DS" */,
    UNKNOWN = -1 /* "UNKNOWN" */,
};

enum class ESupplierType {
    FIRST_PARTY /* "FIRST_PARTY" */,
    THIRD_PARTY /* "THIRD_PARTY" */,
    UNKNOWN /* "UNKNOWN" */
};

enum class EDeliveryServiceType {
    CARRIER /* "CARRIER" */,
    SORTING_CENTER /* "SORTING_CENTER" */,
    FULFILLMENT /* "FULFILLMENT" */,
    RETURN_DELIVERY /* "RETURN_DELIVERY" */,
    UNKNOWN /* "UNKNOWN" */
};

enum class EOrderCancellationReason {
    USER_CHANGED_MIND,
    USER_BOUGHT_CHEAPER,
    USER_PLACED_OTHER_ORDER,
    USER_REFUSED_DELIVERY,
    CUSTOM
};

enum class EOrderPaymentMethod {
    SHOP_PREPAID,
    BANK_CARD,
    YANDEX_MONEY,
    CASH_ON_DELIVERY,
    CARD_ON_DELIVERY,
    YANDEX,
    APPLE_PAY,
    EXTERNAL_CERTIFICATE,
    CREDIT,
    INSTALLMENT,
    GOOGLE_PAY,
    UNKNOWN
};

enum class EOrderPaymentAgent {
    DEFAULT,
    SBER_SPASIBO,
    UNKNOWN
};

}

