# Фикслист
Направляет запрос в желаемый сценарий. Задать запрос можно тремя способами:
## Виды матчеров:
### Точный текст запроса:
```
Video:
  nlu_exact:
    - включи комедии
```
### Regex запроса:
```
Search:CanOpenLink:
  nlu_regex:
    - брать.*подар[ок]
```
### Грамматика:
Нужно создать форму с грамматикой в alice/nlu/data/(ru|en|...)/granet и добавить её в фикслист. Большая просьба поставить флаг is_internal: true для формы.
```
Search:
  nlu_granet:
    - alice.your_form
```
## Объединение матчеров:
При перечислении шаблона матчера (текст/регекс/имя формы) внутри одного имени матчера (nlu_exact/nlu_regex/nlu_granet) условия объединяются через или:
```
Search:CanOpenLink:
  nlu_regex:
    - брать.*подар[ок]
    - совет.*подар[ок]
    - иде.*подар[ок]
```
При перечислении разных матчеров (могут быть одного типа) объединяются через и:
```
Search:CanOpenLink:
  nlu_regex:
    - брать.*подар[ок]
  nlu_granet:
    - alice.present_advice
  nlu_granet:
    - alice:some_other_form
```
Окончательно фикслист объединяет через или все условия:
```
Video:
  nlu_exact:
    - включи комедии

HollywoodMusic:
  nlu_regex:
    - подкасты? недели

Search:CanOpenLink:
  nlu_regex:
    - брать.*подар[ок]
```

## Ограничение на поверхности:
Через двоеточие после имени сценария можно добавить имя фичи поверхности которую она должна поддерживать:
```
Search:CanOpenLink:
  nlu_regex:
    - брать.*подар[ок]
```