# Manifest
Результатом загрузки явяются таблицы по каждому датасету со следующей схемой:
- text: str, required
- target: int32, required, 0 - negative, 1 - positive
- source: str, optional
# Данные
Для работы в манифесте присуствует раздел `data`.
```yaml
data:
  train:
    sources:
      - type: yt
        table: '//home/alice-dev/alkapov/nirvana/ea2fb37d-dcd5-46d0-bd82-11909074c33e/output1__EesjpR7WTgeDYhaEWoc1Cw'
        parser:
          type: standard_parser
          source: train_yt
        dispatchers:
          - type: entries_limiter
            limit: 20
  accept:
    sources: []
  kpi:
    sources: []
```

## data
В разделе `data` есть следующие датасеты: `train`, `accept`, `kpi`.
Их структура полностью одинакова и задает данные для каждого датасета.

В каждом датасете перечислены источники данных в разделе `sources`.
Порядок источников данных в списке задает приоритет по пересекающимся данным: например, одна и таже фраза была представлена в двух источников, но данные для разметки будут использованы только из первого вхождения.

### Источники данных: `sources`
На данный момент поддержаны следущие типы источников данных:
#### yt
Источник позволяет получить данные с таблицы yt.

Параметры:
- `table: str` - путь до таблицы;
- `proxy: str` - кластер yt (по умолчанию `hahn`);

### Парсер: `parser`
В каждом из парсеров предоставляется `source` - мета атрибут, которые позволит определить источник вхождения строки в финальной таблице.

#### analytics_basket_parser
analytics_basket_parser считывает таблицы, которые содержат колонки `text` и `is_negative_query`. Это ToM корзинки и корзины по логам

Параметры:
- `source: str` - название источника (по умолчанию: `null`);

#### standard_parser
standard_parser считывает данные которые содержат текст и ожидает, что колонка с разметкой содержит 1 для позитивов, 0 для негативов.

Параметры:
- `text_key: str` - название колонки с текстом (по умолчанию: `text`);
- `target_key: str` - название колонки с таргетом (по умолчанию: `target`);
- `source: str` - название источника (по умолчанию: `null`);

#### unmarked_parser
unmarked_parser считывает данные, которые содержат только текст.

Параметры:
- `target: int` - `0` или `1` - значение таргета, который нужно подставить;
- `text_key: str` - название колонки с текстом (по умолчанию: `text`);
- `source: str` - название источника (по умолчанию: `null`);

#### analytics_general_parser
analytics_general_parser считывает данные, которые содержат текст и ожидает, что колонка с разметкой содержит `'Y'` для позитивов, `'N'` для негативов.

Параметры:
- `text_key: str` - название колонки с текстом (по умолчанию: `utterance`);
- `target_key: str` - название колонки с таргетом (по умолчанию: `is_positive`);
- `source: str` - название источника (по умолчанию: `null`);

### Диспатчеры: `dispatchers`
Для того, чтобы модифицировать данные из источника используются диспатчеры, которые задаются в поле `dispatchers`.
Порядок применения диспатчеров определен порядком их вхождениям в списки.

#### entries_limiter
entries_limiter ограничивает количество вхождений.

Параметры:
- `limit: int` - ограничение по количеству вхождение, положительное;

#### random_limiter
random_limiter ограничивает количество вхождений по порогу, производя сравнение результата функции `Random() -> [0, 1)` с порогом.
Если порог меньше полученного значения, то элемент удаляется.

```python
if random() > threshold:
   continue
```

Параметры:
- `threshold: float` - порог фильтрации;

#### positives_filter
positives_filter оставляет только вхождения с target == 1.

#### negatives_filter
negatives_filter оставляет только вхождения с target == 0.

#### invert_modifier
invert_modifier позволяет инвертировать target у вхождений.
