import { Div, FixedSize, ImageBlock } from 'divcard2';
import { getStaticS3Asset } from '../../../helpers/assets';
import { createRequestState } from '../../../../../registries/common';
import { IRequestState } from '../../../../../common/types/common';

export default function MusicPlayingTemplate(): [Div, IRequestState] {
    const requestState = createRequestState();
    return [
        new ImageBlock({
            image_url: getStaticS3Asset('music/playing_in_playlist.png'),
            width: new FixedSize({ value: 50 }),
            height: new FixedSize({ value: 50 }),
        }),
        requestState,
    ];
    // TODO: использовать лотти после 122 релиза
    // return new DivCustomBlock({
    //     custom_type: 'lottie',
    //     width: new FixedSize({ value: 50 }),
    //     height: new FixedSize({ value: 50 }),
    //     custom_props: {
    //         steps: [
    //             {
    //                 source: {
    //                     type: 'json',
    //                     cacheKey: '05898201-7f77-4b01-9f0b-4ec5b7ee0cf2',
    //                     json_string: '{"v":"4.8.0","meta":{"g":"LottieFiles AE 1.0.0","a":"","k":"","d":"","tc":""},"fr":25,"ip":0,"op":25,"w":48,"h":48,"nm":"Comp 1","ddd":0,"assets":[],"layers":[{"ddd":0,"ind":1,"ty":4,"nm":"эквалайзер Outlines","sr":1,"ks":{"o":{"a":0,"k":100,"ix":11},"r":{"a":0,"k":0,"ix":10},"p":{"a":0,"k":[24,24,0],"ix":2},"a":{"a":0,"k":[24,24,0],"ix":1},"s":{"a":0,"k":[100,100,100],"ix":6}},"ao":0,"shapes":[{"ty":"gr","it":[{"ind":0,"ty":"sh","ix":1,"ks":{"a":1,"k":[{"i":{"x":0.833,"y":0.833},"o":{"x":0.167,"y":0.167},"t":0,"s":[{"i":[[0,0],[-1.105,0],[0,1.105],[0,0],[1.105,0],[0,-1.105]],"o":[[0,1.105],[1.105,0],[0,0],[0,-1.105],[-1.105,0],[0,0]],"v":[[-10,10],[-8,12],[-6,10],[-6,-10],[-8,-12],[-10,-10]],"c":true}]},{"i":{"x":0.833,"y":0.833},"o":{"x":0.167,"y":0.167},"t":12,"s":[{"i":[[0,0],[-1.105,0],[0,1.105],[0,0],[1.105,0],[0,-1.105]],"o":[[0,1.105],[1.105,0],[0,0],[0,-1.105],[-1.105,0],[0,0]],"v":[[-10,6.719],[-8,8.719],[-6,6.719],[-6,-4.875],[-8,-6.875],[-10,-4.875]],"c":true}]},{"t":25,"s":[{"i":[[0,0],[-1.105,0],[0,1.105],[0,0],[1.105,0],[0,-1.105]],"o":[[0,1.105],[1.105,0],[0,0],[0,-1.105],[-1.105,0],[0,0]],"v":[[-10,10],[-8,12],[-6,10],[-6,-10],[-8,-12],[-10,-10]],"c":true}]}],"ix":2},"nm":"Path 1","mn":"ADBE Vector Shape - Group","hd":false},{"ind":1,"ty":"sh","ix":2,"ks":{"a":1,"k":[{"i":{"x":0.833,"y":0.833},"o":{"x":0.167,"y":0.167},"t":0,"s":[{"i":[[0,0],[-1.105,0],[0,1.105],[0,0],[1.105,0],[0,-1.105]],"o":[[0,1.105],[1.105,0],[0,0],[0,-1.105],[-1.105,0],[0,0]],"v":[[-2,18],[0,20],[2,18],[2,-18],[0,-20],[-2,-18]],"c":true}]},{"i":{"x":0.833,"y":0.833},"o":{"x":0.167,"y":0.167},"t":12,"s":[{"i":[[0,0],[-1.105,0],[0,1.105],[0,0],[1.105,0],[0,-1.105]],"o":[[0,1.105],[1.105,0],[0,0],[0,-1.105],[-1.105,0],[0,0]],"v":[[-2,8.156],[0,10.156],[2,8.156],[2,-8.375],[0,-10.375],[-2,-8.375]],"c":true}]},{"t":25,"s":[{"i":[[0,0],[-1.105,0],[0,1.105],[0,0],[1.105,0],[0,-1.105]],"o":[[0,1.105],[1.105,0],[0,0],[0,-1.105],[-1.105,0],[0,0]],"v":[[-2,18],[0,20],[2,18],[2,-18],[0,-20],[-2,-18]],"c":true}]}],"ix":2},"nm":"Path 2","mn":"ADBE Vector Shape - Group","hd":false},{"ind":2,"ty":"sh","ix":3,"ks":{"a":1,"k":[{"i":{"x":0.833,"y":0.833},"o":{"x":0.167,"y":0.167},"t":0,"s":[{"i":[[0,0],[-1.105,0],[0,1.105],[0,0],[1.105,0],[0,-1.105]],"o":[[0,1.105],[1.105,0],[0,0],[0,-1.105],[-1.105,0],[0,0]],"v":[[-18,2],[-16,4],[-14,2],[-14,-2],[-16,-4],[-18,-2]],"c":true}]},{"i":{"x":0.833,"y":0.833},"o":{"x":0.167,"y":0.167},"t":12,"s":[{"i":[[0,0],[-1.105,0],[0,1.105],[0,0],[1.105,0],[0,-1.105]],"o":[[0,1.105],[1.105,0],[0,0],[0,-1.105],[-1.105,0],[0,0]],"v":[[-18,11.5],[-16,13.5],[-14,11.5],[-14,-8.75],[-16,-10.75],[-18,-8.75]],"c":true}]},{"t":25,"s":[{"i":[[0,0],[-1.105,0],[0,1.105],[0,0],[1.105,0],[0,-1.105]],"o":[[0,1.105],[1.105,0],[0,0],[0,-1.105],[-1.105,0],[0,0]],"v":[[-18,2],[-16,4],[-14,2],[-14,-2],[-16,-4],[-18,-2]],"c":true}]}],"ix":2},"nm":"Path 3","mn":"ADBE Vector Shape - Group","hd":false},{"ind":3,"ty":"sh","ix":4,"ks":{"a":1,"k":[{"i":{"x":0.833,"y":0.833},"o":{"x":0.167,"y":0.167},"t":0,"s":[{"i":[[0,0],[-1.105,0],[0,1.105],[0,0],[1.105,0],[0,-1.105]],"o":[[0,1.105],[1.105,0],[0,0],[0,-1.105],[-1.105,0],[0,0]],"v":[[6,10],[8,12],[10,10],[10,-10],[8,-12],[6,-10]],"c":true}]},{"i":{"x":0.833,"y":0.833},"o":{"x":0.167,"y":0.167},"t":12,"s":[{"i":[[0,0],[-1.105,0],[0,1.105],[0,0],[1.105,0],[0,-1.105]],"o":[[0,1.105],[1.105,0],[0,0],[0,-1.105],[-1.105,0],[0,0]],"v":[[6,14.625],[8,16.625],[10,14.625],[10,-12.25],[8,-14.25],[6,-12.25]],"c":true}]},{"t":25,"s":[{"i":[[0,0],[-1.105,0],[0,1.105],[0,0],[1.105,0],[0,-1.105]],"o":[[0,1.105],[1.105,0],[0,0],[0,-1.105],[-1.105,0],[0,0]],"v":[[6,10],[8,12],[10,10],[10,-10],[8,-12],[6,-10]],"c":true}]}],"ix":2},"nm":"Path 4","mn":"ADBE Vector Shape - Group","hd":false},{"ind":4,"ty":"sh","ix":5,"ks":{"a":1,"k":[{"i":{"x":0.833,"y":0.833},"o":{"x":0.167,"y":0.167},"t":0,"s":[{"i":[[1.105,0],[0,-1.105],[0,0],[-1.105,0],[0,1.105],[0,0]],"o":[[-1.105,0],[0,0],[0,1.105],[1.105,0],[0,0],[0,-1.105]],"v":[[16,-4],[14,-2],[14,2],[16,4],[18,2],[18,-2]],"c":true}]},{"i":{"x":0.833,"y":0.833},"o":{"x":0.167,"y":0.167},"t":12,"s":[{"i":[[1.105,0],[0,-1.105],[0,0],[-1.105,0],[0,1.105],[0,0]],"o":[[-1.105,0],[0,0],[0,1.105],[1.105,0],[0,0],[0,-1.105]],"v":[[16,-9.25],[14,-7.25],[14,10],[16,12],[18,10],[18,-7.25]],"c":true}]},{"t":25,"s":[{"i":[[1.105,0],[0,-1.105],[0,0],[-1.105,0],[0,1.105],[0,0]],"o":[[-1.105,0],[0,0],[0,1.105],[1.105,0],[0,0],[0,-1.105]],"v":[[16,-4],[14,-2],[14,2],[16,4],[18,2],[18,-2]],"c":true}]}],"ix":2},"nm":"Path 5","mn":"ADBE Vector Shape - Group","hd":false},{"ty":"mm","mm":1,"nm":"Merge Paths 1","mn":"ADBE Vector Filter - Merge","hd":false},{"ty":"fl","c":{"a":0,"k":[1,1,1,1],"ix":4},"o":{"a":0,"k":100,"ix":5},"r":1,"bm":0,"nm":"Fill 1","mn":"ADBE Vector Graphic - Fill","hd":false},{"ty":"tr","p":{"a":0,"k":[24,24],"ix":2},"a":{"a":0,"k":[0,0],"ix":1},"s":{"a":0,"k":[100,100],"ix":3},"r":{"a":0,"k":0,"ix":6},"o":{"a":0,"k":100,"ix":7},"sk":{"a":0,"k":0,"ix":4},"sa":{"a":0,"k":0,"ix":5},"nm":"Transform"}],"nm":"Group 1","np":7,"cix":2,"bm":0,"ix":1,"mn":"ADBE Vector Group","hd":false}],"ip":0,"op":50,"st":0,"bm":0}],"markers":[]}',
    //                 },
    //                 count: {
    //                     type: 'infinity',
    //                 },
    //                 scale: 'center_crop',
    //             },
    //         ],
    //     },
    // });
}
