import * as $protobuf from "protobufjs";
/** Namespace NAlice. */
export namespace NAlice {

    /** Namespace NRenderer. */
    namespace NRenderer {

        /** Properties of a TRenderResponse. */
        interface ITRenderResponse {

            /** TRenderResponse CardId */
            CardId?: (string|null);

            /** TRenderResponse Div2Body */
            Div2Body?: (google.protobuf.IStruct|null);

            /** TRenderResponse StringDiv2Body */
            StringDiv2Body?: (string|null);

            /** TRenderResponse Div2PatchBody */
            Div2PatchBody?: (NAlice.NRenderer.TRenderResponse.IDiv2Patch|null);

            /** TRenderResponse GlobalDiv2Templates */
            GlobalDiv2Templates?: ({ [k: string]: NAlice.NRenderer.TRenderResponse.IDiv2Template }|null);

            /** TRenderResponse CardName */
            CardName?: (string|null);
        }

        /** Represents a TRenderResponse. */
        class TRenderResponse implements ITRenderResponse {

            /**
             * Constructs a new TRenderResponse.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NRenderer.ITRenderResponse);

            /** TRenderResponse CardId. */
            public CardId: string;

            /** TRenderResponse Div2Body. */
            public Div2Body?: (google.protobuf.IStruct|null);

            /** TRenderResponse StringDiv2Body. */
            public StringDiv2Body?: (string|null);

            /** TRenderResponse Div2PatchBody. */
            public Div2PatchBody?: (NAlice.NRenderer.TRenderResponse.IDiv2Patch|null);

            /** TRenderResponse GlobalDiv2Templates. */
            public GlobalDiv2Templates: { [k: string]: NAlice.NRenderer.TRenderResponse.IDiv2Template };

            /** TRenderResponse CardName. */
            public CardName: string;

            /** TRenderResponse Div2. */
            public Div2?: ("Div2Body"|"StringDiv2Body"|"Div2PatchBody");

            /**
             * Creates a new TRenderResponse instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TRenderResponse instance
             */
            public static create(properties?: NAlice.NRenderer.ITRenderResponse): NAlice.NRenderer.TRenderResponse;

            /**
             * Encodes the specified TRenderResponse message. Does not implicitly {@link NAlice.NRenderer.TRenderResponse.verify|verify} messages.
             * @param message TRenderResponse message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NRenderer.ITRenderResponse, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TRenderResponse message, length delimited. Does not implicitly {@link NAlice.NRenderer.TRenderResponse.verify|verify} messages.
             * @param message TRenderResponse message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NRenderer.ITRenderResponse, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TRenderResponse message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TRenderResponse
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NRenderer.TRenderResponse;

            /**
             * Decodes a TRenderResponse message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TRenderResponse
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NRenderer.TRenderResponse;

            /**
             * Verifies a TRenderResponse message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TRenderResponse message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TRenderResponse
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NRenderer.TRenderResponse;

            /**
             * Creates a plain object from a TRenderResponse message. Also converts values to other types if specified.
             * @param message TRenderResponse
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NRenderer.TRenderResponse, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TRenderResponse to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        namespace TRenderResponse {

            /** Properties of a Div2Template. */
            interface IDiv2Template {

                /** Div2Template Body */
                Body?: (google.protobuf.IStruct|null);

                /** Div2Template StringBody */
                StringBody?: (string|null);
            }

            /** Represents a Div2Template. */
            class Div2Template implements IDiv2Template {

                /**
                 * Constructs a new Div2Template.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: NAlice.NRenderer.TRenderResponse.IDiv2Template);

                /** Div2Template Body. */
                public Body?: (google.protobuf.IStruct|null);

                /** Div2Template StringBody. */
                public StringBody?: (string|null);

                /** Div2Template Div2. */
                public Div2?: ("Body"|"StringBody");

                /**
                 * Creates a new Div2Template instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns Div2Template instance
                 */
                public static create(properties?: NAlice.NRenderer.TRenderResponse.IDiv2Template): NAlice.NRenderer.TRenderResponse.Div2Template;

                /**
                 * Encodes the specified Div2Template message. Does not implicitly {@link NAlice.NRenderer.TRenderResponse.Div2Template.verify|verify} messages.
                 * @param message Div2Template message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: NAlice.NRenderer.TRenderResponse.IDiv2Template, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified Div2Template message, length delimited. Does not implicitly {@link NAlice.NRenderer.TRenderResponse.Div2Template.verify|verify} messages.
                 * @param message Div2Template message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: NAlice.NRenderer.TRenderResponse.IDiv2Template, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a Div2Template message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns Div2Template
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NRenderer.TRenderResponse.Div2Template;

                /**
                 * Decodes a Div2Template message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns Div2Template
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NRenderer.TRenderResponse.Div2Template;

                /**
                 * Verifies a Div2Template message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a Div2Template message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns Div2Template
                 */
                public static fromObject(object: { [k: string]: any }): NAlice.NRenderer.TRenderResponse.Div2Template;

                /**
                 * Creates a plain object from a Div2Template message. Also converts values to other types if specified.
                 * @param message Div2Template
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: NAlice.NRenderer.TRenderResponse.Div2Template, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this Div2Template to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }

            /** Properties of a Div2Patch. */
            interface IDiv2Patch {

                /** Div2Patch Div2PatchBody */
                Div2PatchBody?: (google.protobuf.IStruct|null);

                /** Div2Patch StringDiv2PatchBody */
                StringDiv2PatchBody?: (string|null);

                /** Div2Patch Templates */
                Templates?: (string|null);
            }

            /** Represents a Div2Patch. */
            class Div2Patch implements IDiv2Patch {

                /**
                 * Constructs a new Div2Patch.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: NAlice.NRenderer.TRenderResponse.IDiv2Patch);

                /** Div2Patch Div2PatchBody. */
                public Div2PatchBody?: (google.protobuf.IStruct|null);

                /** Div2Patch StringDiv2PatchBody. */
                public StringDiv2PatchBody?: (string|null);

                /** Div2Patch Templates. */
                public Templates: string;

                /** Div2Patch Body. */
                public Body?: ("Div2PatchBody"|"StringDiv2PatchBody");

                /**
                 * Creates a new Div2Patch instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns Div2Patch instance
                 */
                public static create(properties?: NAlice.NRenderer.TRenderResponse.IDiv2Patch): NAlice.NRenderer.TRenderResponse.Div2Patch;

                /**
                 * Encodes the specified Div2Patch message. Does not implicitly {@link NAlice.NRenderer.TRenderResponse.Div2Patch.verify|verify} messages.
                 * @param message Div2Patch message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: NAlice.NRenderer.TRenderResponse.IDiv2Patch, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified Div2Patch message, length delimited. Does not implicitly {@link NAlice.NRenderer.TRenderResponse.Div2Patch.verify|verify} messages.
                 * @param message Div2Patch message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: NAlice.NRenderer.TRenderResponse.IDiv2Patch, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a Div2Patch message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns Div2Patch
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NRenderer.TRenderResponse.Div2Patch;

                /**
                 * Decodes a Div2Patch message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns Div2Patch
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NRenderer.TRenderResponse.Div2Patch;

                /**
                 * Verifies a Div2Patch message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a Div2Patch message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns Div2Patch
                 */
                public static fromObject(object: { [k: string]: any }): NAlice.NRenderer.TRenderResponse.Div2Patch;

                /**
                 * Creates a plain object from a Div2Patch message. Also converts values to other types if specified.
                 * @param message Div2Patch
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: NAlice.NRenderer.TRenderResponse.Div2Patch, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this Div2Patch to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }
        }

        /** Properties of a TDivRenderData. */
        interface ITDivRenderData {

            /** TDivRenderData CardId */
            CardId?: (string|null);

            /** TDivRenderData ScenarioData */
            ScenarioData?: (NAlice.NData.ITScenarioData|null);

            /** TDivRenderData DivPatchData */
            DivPatchData?: (NAlice.NData.ITScenarioData|null);

            /** TDivRenderData CardName */
            CardName?: (string|null);
        }

        /** Represents a TDivRenderData. */
        class TDivRenderData implements ITDivRenderData {

            /**
             * Constructs a new TDivRenderData.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NRenderer.ITDivRenderData);

            /** TDivRenderData CardId. */
            public CardId: string;

            /** TDivRenderData ScenarioData. */
            public ScenarioData?: (NAlice.NData.ITScenarioData|null);

            /** TDivRenderData DivPatchData. */
            public DivPatchData?: (NAlice.NData.ITScenarioData|null);

            /** TDivRenderData CardName. */
            public CardName: string;

            /** TDivRenderData RenderData. */
            public RenderData?: ("ScenarioData"|"DivPatchData");

            /**
             * Creates a new TDivRenderData instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TDivRenderData instance
             */
            public static create(properties?: NAlice.NRenderer.ITDivRenderData): NAlice.NRenderer.TDivRenderData;

            /**
             * Encodes the specified TDivRenderData message. Does not implicitly {@link NAlice.NRenderer.TDivRenderData.verify|verify} messages.
             * @param message TDivRenderData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NRenderer.ITDivRenderData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TDivRenderData message, length delimited. Does not implicitly {@link NAlice.NRenderer.TDivRenderData.verify|verify} messages.
             * @param message TDivRenderData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NRenderer.ITDivRenderData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TDivRenderData message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TDivRenderData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NRenderer.TDivRenderData;

            /**
             * Decodes a TDivRenderData message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TDivRenderData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NRenderer.TDivRenderData;

            /**
             * Verifies a TDivRenderData message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TDivRenderData message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TDivRenderData
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NRenderer.TDivRenderData;

            /**
             * Creates a plain object from a TDivRenderData message. Also converts values to other types if specified.
             * @param message TDivRenderData
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NRenderer.TDivRenderData, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TDivRenderData to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }
    }

    /** Namespace NData. */
    namespace NData {

        /** Properties of a TScenarioData. */
        interface ITScenarioData {

            /** TScenarioData SearchObjectData */
            SearchObjectData?: (NAlice.NData.ITSearchObjectData|null);

            /** TScenarioData SearchFactData */
            SearchFactData?: (NAlice.NData.ITSearchFactData|null);

            /** TScenarioData ExampleScenarioData */
            ExampleScenarioData?: (NAlice.NData.ITExampleScenarioData|null);

            /** TScenarioData NewsGalleryData */
            NewsGalleryData?: (NAlice.NData.ITNewsGalleryData|null);

            /** TScenarioData NewsTeaserData */
            NewsTeaserData?: (NAlice.NData.ITNewsTeaserData|null);

            /** TScenarioData WeatherDayHoursData */
            WeatherDayHoursData?: (NAlice.NData.ITWeatherDayHoursData|null);

            /** TScenarioData WeatherDayPartData */
            WeatherDayPartData?: (NAlice.NData.ITWeatherDayPartData|null);

            /** TScenarioData WeatherDayData */
            WeatherDayData?: (NAlice.NData.ITWeatherDayData|null);

            /** TScenarioData WeatherDaysRangeData */
            WeatherDaysRangeData?: (NAlice.NData.ITWeatherDaysRangeData|null);

            /** TScenarioData CentaurMainScreenGalleryMusicCardData */
            CentaurMainScreenGalleryMusicCardData?: (NAlice.NData.ITCentaurMainScreenGalleryMusicCardData|null);

            /** TScenarioData CentaurMainScreenGalleryVideoCardData */
            CentaurMainScreenGalleryVideoCardData?: (NAlice.NData.ITCentaurMainScreenGalleryVideoCardData|null);

            /** TScenarioData WeatherTeaserData */
            WeatherTeaserData?: (NAlice.NData.ITWeatherTeaserData|null);

            /** TScenarioData MusicPlayerData */
            MusicPlayerData?: (NAlice.NData.ITMusicPlayerData|null);

            /** TScenarioData CentaurMainScreenWebviewCardData */
            CentaurMainScreenWebviewCardData?: (NAlice.NData.ITCentaurMainScreenWebviewCardData|null);

            /** TScenarioData MusicInfiniteFeedData */
            MusicInfiniteFeedData?: (NAlice.NData.NMusic.ITMusicInfiniteFeedData|null);

            /** TScenarioData CentaurMainScreenWebviewTabData */
            CentaurMainScreenWebviewTabData?: (NAlice.NData.ITCentaurMainScreenWebviewTabData|null);

            /** TScenarioData CentaurTeaserChromeDefaultLayerData */
            CentaurTeaserChromeDefaultLayerData?: (NAlice.NData.ITCentaurTeaserChromeDefaultLayerData|null);

            /** TScenarioData CentaurMainScreenDiscoveryTabData */
            CentaurMainScreenDiscoveryTabData?: (NAlice.NData.ITCentaurMainScreenDiscoveryTabData|null);

            /** TScenarioData CentaurMainScreenMusicTabData */
            CentaurMainScreenMusicTabData?: (NAlice.NData.ITCentaurMainScreenMusicTabData|null);

            /** TScenarioData CentaurMainScreenServicesTabData */
            CentaurMainScreenServicesTabData?: (NAlice.NData.ITCentaurMainScreenServicesTabData|null);

            /** TScenarioData IoTUserData */
            IoTUserData?: (NAlice.ITIoTUserInfo|null);

            /** TScenarioData CentaurMainScreenSmartHomeTabData */
            CentaurMainScreenSmartHomeTabData?: (NAlice.NData.ITCentaurMainScreenSmartHomeTabData|null);

            /** TScenarioData CentaurUpperShutterData */
            CentaurUpperShutterData?: (NAlice.NData.ITCentaurUpperShutterData|null);

            /** TScenarioData CentaurWebviewData */
            CentaurWebviewData?: (NAlice.NData.ITCentaurWebviewData|null);

            /** TScenarioData CentaurMainScreenMyScreenData */
            CentaurMainScreenMyScreenData?: (NAlice.NData.ITCentaurMainScreenMyScreenData|null);

            /** TScenarioData NewsMainScreenData */
            NewsMainScreenData?: (NAlice.NData.ITNewsMainScreenData|null);

            /** TScenarioData WeatherMainScreenData */
            WeatherMainScreenData?: (NAlice.NData.ITWeatherMainScreenData|null);

            /** TScenarioData DialogovoSkillCardData */
            DialogovoSkillCardData?: (NAlice.NData.ITDialogovoSkillCardData|null);

            /** TScenarioData CentaurWidgetGalleryData */
            CentaurWidgetGalleryData?: (NAlice.NData.ITCentaurWidgetGalleryData|null);

            /** TScenarioData ScreenSaverData */
            ScreenSaverData?: (NAlice.NData.ITScreenSaverData|null);

            /** TScenarioData TrafficData */
            TrafficData?: (NAlice.NData.ITTrafficWidgetData|null);

            /** TScenarioData GalleryData */
            GalleryData?: (NAlice.NData.ITGalleryData|null);

            /** TScenarioData ConversationData */
            ConversationData?: (NAlice.NData.ITConversationData|null);

            /** TScenarioData VideoCallMainScreenData */
            VideoCallMainScreenData?: (NAlice.NData.ITVideoCallMainScreenData|null);

            /** TScenarioData VideoCallContactChoosingData */
            VideoCallContactChoosingData?: (NAlice.NData.ITVideoCallContactChoosingData|null);

            /** TScenarioData CentaurWidgetCardItemData */
            CentaurWidgetCardItemData?: (NAlice.NData.ITCentaurWidgetCardItemData|null);

            /** TScenarioData CentaurWidgetCardItem */
            CentaurWidgetCardItem?: (NAlice.NData.ITCentaurWidgetCardItem|null);

            /** TScenarioData AfishaTeaserData */
            AfishaTeaserData?: (NAlice.NData.ITAfishaTeaserData|null);

            /** TScenarioData CentaurScenarioWidgetData */
            CentaurScenarioWidgetData?: (NAlice.NData.ITCentaurScenarioWidgetData|null);

            /** TScenarioData IncomingTelegramCallData */
            IncomingTelegramCallData?: (NAlice.NData.ITIncomingTelegramCallData|null);

            /** TScenarioData VideoSearchResultData */
            VideoSearchResultData?: (NAlice.ITTvSearchResultData|null);

            /** TScenarioData SearchRichCardData */
            SearchRichCardData?: (NAlice.NData.ITSearchRichCardData|null);

            /** TScenarioData OutgoingTelegramCallData */
            OutgoingTelegramCallData?: (NAlice.NData.ITOutgoingTelegramCallData|null);

            /** TScenarioData CurrentTelegramCallData */
            CurrentTelegramCallData?: (NAlice.NData.ITCurrentTelegramCallData|null);

            /** TScenarioData GreetingsCardData */
            GreetingsCardData?: (NAlice.NData.ITGreetingsCardData|null);

            /** TScenarioData ShowRouteData */
            ShowRouteData?: (NAlice.NData.ITShowRouteData|null);

            /** TScenarioData DialogovoTeaserCardData */
            DialogovoTeaserCardData?: (NAlice.NData.ITDialogovoSkillTeaserData|null);

            /** TScenarioData TrafficCardData */
            TrafficCardData?: (NAlice.NData.ITTrafficCardData|null);

            /** TScenarioData ProactivityTeaserData */
            ProactivityTeaserData?: (NAlice.NData.ITProactivityTeaserData|null);

            /** TScenarioData GreetingsFooterCardData */
            GreetingsFooterCardData?: (NAlice.NData.ITGreetingsFooterCardData|null);

            /** TScenarioData TeaserSettingsWithContentData */
            TeaserSettingsWithContentData?: (NAlice.NData.ITTeaserSettingsWithContentData|null);

            /** TScenarioData TeasersPreviewData */
            TeasersPreviewData?: (NAlice.NData.ITTeasersPreviewData|null);
        }

        /** Represents a TScenarioData. */
        class TScenarioData implements ITScenarioData {

            /**
             * Constructs a new TScenarioData.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITScenarioData);

            /** TScenarioData SearchObjectData. */
            public SearchObjectData?: (NAlice.NData.ITSearchObjectData|null);

            /** TScenarioData SearchFactData. */
            public SearchFactData?: (NAlice.NData.ITSearchFactData|null);

            /** TScenarioData ExampleScenarioData. */
            public ExampleScenarioData?: (NAlice.NData.ITExampleScenarioData|null);

            /** TScenarioData NewsGalleryData. */
            public NewsGalleryData?: (NAlice.NData.ITNewsGalleryData|null);

            /** TScenarioData NewsTeaserData. */
            public NewsTeaserData?: (NAlice.NData.ITNewsTeaserData|null);

            /** TScenarioData WeatherDayHoursData. */
            public WeatherDayHoursData?: (NAlice.NData.ITWeatherDayHoursData|null);

            /** TScenarioData WeatherDayPartData. */
            public WeatherDayPartData?: (NAlice.NData.ITWeatherDayPartData|null);

            /** TScenarioData WeatherDayData. */
            public WeatherDayData?: (NAlice.NData.ITWeatherDayData|null);

            /** TScenarioData WeatherDaysRangeData. */
            public WeatherDaysRangeData?: (NAlice.NData.ITWeatherDaysRangeData|null);

            /** TScenarioData CentaurMainScreenGalleryMusicCardData. */
            public CentaurMainScreenGalleryMusicCardData?: (NAlice.NData.ITCentaurMainScreenGalleryMusicCardData|null);

            /** TScenarioData CentaurMainScreenGalleryVideoCardData. */
            public CentaurMainScreenGalleryVideoCardData?: (NAlice.NData.ITCentaurMainScreenGalleryVideoCardData|null);

            /** TScenarioData WeatherTeaserData. */
            public WeatherTeaserData?: (NAlice.NData.ITWeatherTeaserData|null);

            /** TScenarioData MusicPlayerData. */
            public MusicPlayerData?: (NAlice.NData.ITMusicPlayerData|null);

            /** TScenarioData CentaurMainScreenWebviewCardData. */
            public CentaurMainScreenWebviewCardData?: (NAlice.NData.ITCentaurMainScreenWebviewCardData|null);

            /** TScenarioData MusicInfiniteFeedData. */
            public MusicInfiniteFeedData?: (NAlice.NData.NMusic.ITMusicInfiniteFeedData|null);

            /** TScenarioData CentaurMainScreenWebviewTabData. */
            public CentaurMainScreenWebviewTabData?: (NAlice.NData.ITCentaurMainScreenWebviewTabData|null);

            /** TScenarioData CentaurTeaserChromeDefaultLayerData. */
            public CentaurTeaserChromeDefaultLayerData?: (NAlice.NData.ITCentaurTeaserChromeDefaultLayerData|null);

            /** TScenarioData CentaurMainScreenDiscoveryTabData. */
            public CentaurMainScreenDiscoveryTabData?: (NAlice.NData.ITCentaurMainScreenDiscoveryTabData|null);

            /** TScenarioData CentaurMainScreenMusicTabData. */
            public CentaurMainScreenMusicTabData?: (NAlice.NData.ITCentaurMainScreenMusicTabData|null);

            /** TScenarioData CentaurMainScreenServicesTabData. */
            public CentaurMainScreenServicesTabData?: (NAlice.NData.ITCentaurMainScreenServicesTabData|null);

            /** TScenarioData IoTUserData. */
            public IoTUserData?: (NAlice.ITIoTUserInfo|null);

            /** TScenarioData CentaurMainScreenSmartHomeTabData. */
            public CentaurMainScreenSmartHomeTabData?: (NAlice.NData.ITCentaurMainScreenSmartHomeTabData|null);

            /** TScenarioData CentaurUpperShutterData. */
            public CentaurUpperShutterData?: (NAlice.NData.ITCentaurUpperShutterData|null);

            /** TScenarioData CentaurWebviewData. */
            public CentaurWebviewData?: (NAlice.NData.ITCentaurWebviewData|null);

            /** TScenarioData CentaurMainScreenMyScreenData. */
            public CentaurMainScreenMyScreenData?: (NAlice.NData.ITCentaurMainScreenMyScreenData|null);

            /** TScenarioData NewsMainScreenData. */
            public NewsMainScreenData?: (NAlice.NData.ITNewsMainScreenData|null);

            /** TScenarioData WeatherMainScreenData. */
            public WeatherMainScreenData?: (NAlice.NData.ITWeatherMainScreenData|null);

            /** TScenarioData DialogovoSkillCardData. */
            public DialogovoSkillCardData?: (NAlice.NData.ITDialogovoSkillCardData|null);

            /** TScenarioData CentaurWidgetGalleryData. */
            public CentaurWidgetGalleryData?: (NAlice.NData.ITCentaurWidgetGalleryData|null);

            /** TScenarioData ScreenSaverData. */
            public ScreenSaverData?: (NAlice.NData.ITScreenSaverData|null);

            /** TScenarioData TrafficData. */
            public TrafficData?: (NAlice.NData.ITTrafficWidgetData|null);

            /** TScenarioData GalleryData. */
            public GalleryData?: (NAlice.NData.ITGalleryData|null);

            /** TScenarioData ConversationData. */
            public ConversationData?: (NAlice.NData.ITConversationData|null);

            /** TScenarioData VideoCallMainScreenData. */
            public VideoCallMainScreenData?: (NAlice.NData.ITVideoCallMainScreenData|null);

            /** TScenarioData VideoCallContactChoosingData. */
            public VideoCallContactChoosingData?: (NAlice.NData.ITVideoCallContactChoosingData|null);

            /** TScenarioData CentaurWidgetCardItemData. */
            public CentaurWidgetCardItemData?: (NAlice.NData.ITCentaurWidgetCardItemData|null);

            /** TScenarioData CentaurWidgetCardItem. */
            public CentaurWidgetCardItem?: (NAlice.NData.ITCentaurWidgetCardItem|null);

            /** TScenarioData AfishaTeaserData. */
            public AfishaTeaserData?: (NAlice.NData.ITAfishaTeaserData|null);

            /** TScenarioData CentaurScenarioWidgetData. */
            public CentaurScenarioWidgetData?: (NAlice.NData.ITCentaurScenarioWidgetData|null);

            /** TScenarioData IncomingTelegramCallData. */
            public IncomingTelegramCallData?: (NAlice.NData.ITIncomingTelegramCallData|null);

            /** TScenarioData VideoSearchResultData. */
            public VideoSearchResultData?: (NAlice.ITTvSearchResultData|null);

            /** TScenarioData SearchRichCardData. */
            public SearchRichCardData?: (NAlice.NData.ITSearchRichCardData|null);

            /** TScenarioData OutgoingTelegramCallData. */
            public OutgoingTelegramCallData?: (NAlice.NData.ITOutgoingTelegramCallData|null);

            /** TScenarioData CurrentTelegramCallData. */
            public CurrentTelegramCallData?: (NAlice.NData.ITCurrentTelegramCallData|null);

            /** TScenarioData GreetingsCardData. */
            public GreetingsCardData?: (NAlice.NData.ITGreetingsCardData|null);

            /** TScenarioData ShowRouteData. */
            public ShowRouteData?: (NAlice.NData.ITShowRouteData|null);

            /** TScenarioData DialogovoTeaserCardData. */
            public DialogovoTeaserCardData?: (NAlice.NData.ITDialogovoSkillTeaserData|null);

            /** TScenarioData TrafficCardData. */
            public TrafficCardData?: (NAlice.NData.ITTrafficCardData|null);

            /** TScenarioData ProactivityTeaserData. */
            public ProactivityTeaserData?: (NAlice.NData.ITProactivityTeaserData|null);

            /** TScenarioData GreetingsFooterCardData. */
            public GreetingsFooterCardData?: (NAlice.NData.ITGreetingsFooterCardData|null);

            /** TScenarioData TeaserSettingsWithContentData. */
            public TeaserSettingsWithContentData?: (NAlice.NData.ITTeaserSettingsWithContentData|null);

            /** TScenarioData TeasersPreviewData. */
            public TeasersPreviewData?: (NAlice.NData.ITTeasersPreviewData|null);

            /** TScenarioData Data. */
            public Data?: ("SearchObjectData"|"SearchFactData"|"ExampleScenarioData"|"NewsGalleryData"|"NewsTeaserData"|"WeatherDayHoursData"|"WeatherDayPartData"|"WeatherDayData"|"WeatherDaysRangeData"|"CentaurMainScreenGalleryMusicCardData"|"CentaurMainScreenGalleryVideoCardData"|"WeatherTeaserData"|"MusicPlayerData"|"CentaurMainScreenWebviewCardData"|"MusicInfiniteFeedData"|"CentaurMainScreenWebviewTabData"|"CentaurTeaserChromeDefaultLayerData"|"CentaurMainScreenDiscoveryTabData"|"CentaurMainScreenMusicTabData"|"CentaurMainScreenServicesTabData"|"IoTUserData"|"CentaurMainScreenSmartHomeTabData"|"CentaurUpperShutterData"|"CentaurWebviewData"|"CentaurMainScreenMyScreenData"|"NewsMainScreenData"|"WeatherMainScreenData"|"DialogovoSkillCardData"|"CentaurWidgetGalleryData"|"ScreenSaverData"|"TrafficData"|"GalleryData"|"ConversationData"|"VideoCallMainScreenData"|"VideoCallContactChoosingData"|"CentaurWidgetCardItemData"|"CentaurWidgetCardItem"|"AfishaTeaserData"|"CentaurScenarioWidgetData"|"IncomingTelegramCallData"|"VideoSearchResultData"|"SearchRichCardData"|"OutgoingTelegramCallData"|"CurrentTelegramCallData"|"GreetingsCardData"|"ShowRouteData"|"DialogovoTeaserCardData"|"TrafficCardData"|"ProactivityTeaserData"|"GreetingsFooterCardData"|"TeaserSettingsWithContentData"|"TeasersPreviewData");

            /**
             * Creates a new TScenarioData instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TScenarioData instance
             */
            public static create(properties?: NAlice.NData.ITScenarioData): NAlice.NData.TScenarioData;

            /**
             * Encodes the specified TScenarioData message. Does not implicitly {@link NAlice.NData.TScenarioData.verify|verify} messages.
             * @param message TScenarioData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITScenarioData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TScenarioData message, length delimited. Does not implicitly {@link NAlice.NData.TScenarioData.verify|verify} messages.
             * @param message TScenarioData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITScenarioData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TScenarioData message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TScenarioData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TScenarioData;

            /**
             * Decodes a TScenarioData message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TScenarioData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TScenarioData;

            /**
             * Verifies a TScenarioData message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TScenarioData message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TScenarioData
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TScenarioData;

            /**
             * Creates a plain object from a TScenarioData message. Also converts values to other types if specified.
             * @param message TScenarioData
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TScenarioData, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TScenarioData to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a TAfishaTeaserData. */
        interface ITAfishaTeaserData {

            /** TAfishaTeaserData Title */
            Title?: (string|null);

            /** TAfishaTeaserData ImageUrl */
            ImageUrl?: (string|null);

            /** TAfishaTeaserData Date */
            Date?: (string|null);

            /** TAfishaTeaserData Place */
            Place?: (string|null);

            /** TAfishaTeaserData ContentRating */
            ContentRating?: (string|null);
        }

        /** Represents a TAfishaTeaserData. */
        class TAfishaTeaserData implements ITAfishaTeaserData {

            /**
             * Constructs a new TAfishaTeaserData.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITAfishaTeaserData);

            /** TAfishaTeaserData Title. */
            public Title: string;

            /** TAfishaTeaserData ImageUrl. */
            public ImageUrl: string;

            /** TAfishaTeaserData Date. */
            public Date: string;

            /** TAfishaTeaserData Place. */
            public Place: string;

            /** TAfishaTeaserData ContentRating. */
            public ContentRating: string;

            /**
             * Creates a new TAfishaTeaserData instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TAfishaTeaserData instance
             */
            public static create(properties?: NAlice.NData.ITAfishaTeaserData): NAlice.NData.TAfishaTeaserData;

            /**
             * Encodes the specified TAfishaTeaserData message. Does not implicitly {@link NAlice.NData.TAfishaTeaserData.verify|verify} messages.
             * @param message TAfishaTeaserData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITAfishaTeaserData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TAfishaTeaserData message, length delimited. Does not implicitly {@link NAlice.NData.TAfishaTeaserData.verify|verify} messages.
             * @param message TAfishaTeaserData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITAfishaTeaserData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TAfishaTeaserData message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TAfishaTeaserData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TAfishaTeaserData;

            /**
             * Decodes a TAfishaTeaserData message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TAfishaTeaserData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TAfishaTeaserData;

            /**
             * Verifies a TAfishaTeaserData message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TAfishaTeaserData message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TAfishaTeaserData
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TAfishaTeaserData;

            /**
             * Creates a plain object from a TAfishaTeaserData message. Also converts values to other types if specified.
             * @param message TAfishaTeaserData
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TAfishaTeaserData, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TAfishaTeaserData to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a TCentaurMainScreenMusicTabData. */
        interface ITCentaurMainScreenMusicTabData {

            /** TCentaurMainScreenMusicTabData Id */
            Id?: (string|null);

            /** TCentaurMainScreenMusicTabData HorizontalMusicBlockData */
            HorizontalMusicBlockData?: (NAlice.NData.ITHorizontalMusicBlockData[]|null);
        }

        /** Represents a TCentaurMainScreenMusicTabData. */
        class TCentaurMainScreenMusicTabData implements ITCentaurMainScreenMusicTabData {

            /**
             * Constructs a new TCentaurMainScreenMusicTabData.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITCentaurMainScreenMusicTabData);

            /** TCentaurMainScreenMusicTabData Id. */
            public Id: string;

            /** TCentaurMainScreenMusicTabData HorizontalMusicBlockData. */
            public HorizontalMusicBlockData: NAlice.NData.ITHorizontalMusicBlockData[];

            /**
             * Creates a new TCentaurMainScreenMusicTabData instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TCentaurMainScreenMusicTabData instance
             */
            public static create(properties?: NAlice.NData.ITCentaurMainScreenMusicTabData): NAlice.NData.TCentaurMainScreenMusicTabData;

            /**
             * Encodes the specified TCentaurMainScreenMusicTabData message. Does not implicitly {@link NAlice.NData.TCentaurMainScreenMusicTabData.verify|verify} messages.
             * @param message TCentaurMainScreenMusicTabData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITCentaurMainScreenMusicTabData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TCentaurMainScreenMusicTabData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurMainScreenMusicTabData.verify|verify} messages.
             * @param message TCentaurMainScreenMusicTabData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITCentaurMainScreenMusicTabData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TCentaurMainScreenMusicTabData message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TCentaurMainScreenMusicTabData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TCentaurMainScreenMusicTabData;

            /**
             * Decodes a TCentaurMainScreenMusicTabData message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TCentaurMainScreenMusicTabData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TCentaurMainScreenMusicTabData;

            /**
             * Verifies a TCentaurMainScreenMusicTabData message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TCentaurMainScreenMusicTabData message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TCentaurMainScreenMusicTabData
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TCentaurMainScreenMusicTabData;

            /**
             * Creates a plain object from a TCentaurMainScreenMusicTabData message. Also converts values to other types if specified.
             * @param message TCentaurMainScreenMusicTabData
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TCentaurMainScreenMusicTabData, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TCentaurMainScreenMusicTabData to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a THorizontalMusicBlockData. */
        interface ITHorizontalMusicBlockData {

            /** THorizontalMusicBlockData Type */
            Type?: (string|null);

            /** THorizontalMusicBlockData Title */
            Title?: (string|null);

            /** THorizontalMusicBlockData CentaurMainScreenGalleryMusicCardData */
            CentaurMainScreenGalleryMusicCardData?: (NAlice.NData.ITCentaurMainScreenGalleryMusicCardData[]|null);
        }

        /** Represents a THorizontalMusicBlockData. */
        class THorizontalMusicBlockData implements ITHorizontalMusicBlockData {

            /**
             * Constructs a new THorizontalMusicBlockData.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITHorizontalMusicBlockData);

            /** THorizontalMusicBlockData Type. */
            public Type: string;

            /** THorizontalMusicBlockData Title. */
            public Title: string;

            /** THorizontalMusicBlockData CentaurMainScreenGalleryMusicCardData. */
            public CentaurMainScreenGalleryMusicCardData: NAlice.NData.ITCentaurMainScreenGalleryMusicCardData[];

            /**
             * Creates a new THorizontalMusicBlockData instance using the specified properties.
             * @param [properties] Properties to set
             * @returns THorizontalMusicBlockData instance
             */
            public static create(properties?: NAlice.NData.ITHorizontalMusicBlockData): NAlice.NData.THorizontalMusicBlockData;

            /**
             * Encodes the specified THorizontalMusicBlockData message. Does not implicitly {@link NAlice.NData.THorizontalMusicBlockData.verify|verify} messages.
             * @param message THorizontalMusicBlockData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITHorizontalMusicBlockData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified THorizontalMusicBlockData message, length delimited. Does not implicitly {@link NAlice.NData.THorizontalMusicBlockData.verify|verify} messages.
             * @param message THorizontalMusicBlockData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITHorizontalMusicBlockData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a THorizontalMusicBlockData message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns THorizontalMusicBlockData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.THorizontalMusicBlockData;

            /**
             * Decodes a THorizontalMusicBlockData message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns THorizontalMusicBlockData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.THorizontalMusicBlockData;

            /**
             * Verifies a THorizontalMusicBlockData message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a THorizontalMusicBlockData message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns THorizontalMusicBlockData
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.THorizontalMusicBlockData;

            /**
             * Creates a plain object from a THorizontalMusicBlockData message. Also converts values to other types if specified.
             * @param message THorizontalMusicBlockData
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.THorizontalMusicBlockData, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this THorizontalMusicBlockData to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a TCentaurMainScreenGalleryMusicCardData. */
        interface ITCentaurMainScreenGalleryMusicCardData {

            /** TCentaurMainScreenGalleryMusicCardData Id */
            Id?: (string|null);

            /** TCentaurMainScreenGalleryMusicCardData ImageUrl */
            ImageUrl?: (string|null);

            /** TCentaurMainScreenGalleryMusicCardData Action */
            Action?: (string|null);

            /** TCentaurMainScreenGalleryMusicCardData Type */
            Type?: (string|null);

            /** TCentaurMainScreenGalleryMusicCardData Title */
            Title?: (string|null);

            /** TCentaurMainScreenGalleryMusicCardData Modified */
            Modified?: (google.protobuf.IStringValue|null);

            /** TCentaurMainScreenGalleryMusicCardData LikesCount */
            LikesCount?: (google.protobuf.IUInt32Value|null);

            /** TCentaurMainScreenGalleryMusicCardData Genres */
            Genres?: (string[]|null);

            /** TCentaurMainScreenGalleryMusicCardData ReleaseDate */
            ReleaseDate?: (google.protobuf.IStringValue|null);

            /** TCentaurMainScreenGalleryMusicCardData Artists */
            Artists?: (NAlice.NData.TCentaurMainScreenGalleryMusicCardData.ITArtistInfo[]|null);

            /** TCentaurMainScreenGalleryMusicCardData BlockType */
            BlockType?: (string|null);

            /** TCentaurMainScreenGalleryMusicCardData TypedAction */
            TypedAction?: (google.protobuf.IAny|null);
        }

        /** Represents a TCentaurMainScreenGalleryMusicCardData. */
        class TCentaurMainScreenGalleryMusicCardData implements ITCentaurMainScreenGalleryMusicCardData {

            /**
             * Constructs a new TCentaurMainScreenGalleryMusicCardData.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITCentaurMainScreenGalleryMusicCardData);

            /** TCentaurMainScreenGalleryMusicCardData Id. */
            public Id: string;

            /** TCentaurMainScreenGalleryMusicCardData ImageUrl. */
            public ImageUrl: string;

            /** TCentaurMainScreenGalleryMusicCardData Action. */
            public Action: string;

            /** TCentaurMainScreenGalleryMusicCardData Type. */
            public Type: string;

            /** TCentaurMainScreenGalleryMusicCardData Title. */
            public Title: string;

            /** TCentaurMainScreenGalleryMusicCardData Modified. */
            public Modified?: (google.protobuf.IStringValue|null);

            /** TCentaurMainScreenGalleryMusicCardData LikesCount. */
            public LikesCount?: (google.protobuf.IUInt32Value|null);

            /** TCentaurMainScreenGalleryMusicCardData Genres. */
            public Genres: string[];

            /** TCentaurMainScreenGalleryMusicCardData ReleaseDate. */
            public ReleaseDate?: (google.protobuf.IStringValue|null);

            /** TCentaurMainScreenGalleryMusicCardData Artists. */
            public Artists: NAlice.NData.TCentaurMainScreenGalleryMusicCardData.ITArtistInfo[];

            /** TCentaurMainScreenGalleryMusicCardData BlockType. */
            public BlockType: string;

            /** TCentaurMainScreenGalleryMusicCardData TypedAction. */
            public TypedAction?: (google.protobuf.IAny|null);

            /**
             * Creates a new TCentaurMainScreenGalleryMusicCardData instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TCentaurMainScreenGalleryMusicCardData instance
             */
            public static create(properties?: NAlice.NData.ITCentaurMainScreenGalleryMusicCardData): NAlice.NData.TCentaurMainScreenGalleryMusicCardData;

            /**
             * Encodes the specified TCentaurMainScreenGalleryMusicCardData message. Does not implicitly {@link NAlice.NData.TCentaurMainScreenGalleryMusicCardData.verify|verify} messages.
             * @param message TCentaurMainScreenGalleryMusicCardData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITCentaurMainScreenGalleryMusicCardData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TCentaurMainScreenGalleryMusicCardData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurMainScreenGalleryMusicCardData.verify|verify} messages.
             * @param message TCentaurMainScreenGalleryMusicCardData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITCentaurMainScreenGalleryMusicCardData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TCentaurMainScreenGalleryMusicCardData message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TCentaurMainScreenGalleryMusicCardData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TCentaurMainScreenGalleryMusicCardData;

            /**
             * Decodes a TCentaurMainScreenGalleryMusicCardData message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TCentaurMainScreenGalleryMusicCardData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TCentaurMainScreenGalleryMusicCardData;

            /**
             * Verifies a TCentaurMainScreenGalleryMusicCardData message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TCentaurMainScreenGalleryMusicCardData message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TCentaurMainScreenGalleryMusicCardData
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TCentaurMainScreenGalleryMusicCardData;

            /**
             * Creates a plain object from a TCentaurMainScreenGalleryMusicCardData message. Also converts values to other types if specified.
             * @param message TCentaurMainScreenGalleryMusicCardData
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TCentaurMainScreenGalleryMusicCardData, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TCentaurMainScreenGalleryMusicCardData to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        namespace TCentaurMainScreenGalleryMusicCardData {

            /** Properties of a TArtistInfo. */
            interface ITArtistInfo {

                /** TArtistInfo Id */
                Id?: (string|null);

                /** TArtistInfo Name */
                Name?: (string|null);
            }

            /** Represents a TArtistInfo. */
            class TArtistInfo implements ITArtistInfo {

                /**
                 * Constructs a new TArtistInfo.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: NAlice.NData.TCentaurMainScreenGalleryMusicCardData.ITArtistInfo);

                /** TArtistInfo Id. */
                public Id: string;

                /** TArtistInfo Name. */
                public Name: string;

                /**
                 * Creates a new TArtistInfo instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns TArtistInfo instance
                 */
                public static create(properties?: NAlice.NData.TCentaurMainScreenGalleryMusicCardData.ITArtistInfo): NAlice.NData.TCentaurMainScreenGalleryMusicCardData.TArtistInfo;

                /**
                 * Encodes the specified TArtistInfo message. Does not implicitly {@link NAlice.NData.TCentaurMainScreenGalleryMusicCardData.TArtistInfo.verify|verify} messages.
                 * @param message TArtistInfo message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: NAlice.NData.TCentaurMainScreenGalleryMusicCardData.ITArtistInfo, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified TArtistInfo message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurMainScreenGalleryMusicCardData.TArtistInfo.verify|verify} messages.
                 * @param message TArtistInfo message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: NAlice.NData.TCentaurMainScreenGalleryMusicCardData.ITArtistInfo, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a TArtistInfo message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns TArtistInfo
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TCentaurMainScreenGalleryMusicCardData.TArtistInfo;

                /**
                 * Decodes a TArtistInfo message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns TArtistInfo
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TCentaurMainScreenGalleryMusicCardData.TArtistInfo;

                /**
                 * Verifies a TArtistInfo message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a TArtistInfo message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns TArtistInfo
                 */
                public static fromObject(object: { [k: string]: any }): NAlice.NData.TCentaurMainScreenGalleryMusicCardData.TArtistInfo;

                /**
                 * Creates a plain object from a TArtistInfo message. Also converts values to other types if specified.
                 * @param message TArtistInfo
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: NAlice.NData.TCentaurMainScreenGalleryMusicCardData.TArtistInfo, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this TArtistInfo to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }
        }

        /** Properties of a TCentaurMainScreenGalleryVideoCardData. */
        interface ITCentaurMainScreenGalleryVideoCardData {

            /** TCentaurMainScreenGalleryVideoCardData Id */
            Id?: (string|null);

            /** TCentaurMainScreenGalleryVideoCardData ImageUrl */
            ImageUrl?: (string|null);

            /** TCentaurMainScreenGalleryVideoCardData Action */
            Action?: (string|null);
        }

        /** Represents a TCentaurMainScreenGalleryVideoCardData. */
        class TCentaurMainScreenGalleryVideoCardData implements ITCentaurMainScreenGalleryVideoCardData {

            /**
             * Constructs a new TCentaurMainScreenGalleryVideoCardData.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITCentaurMainScreenGalleryVideoCardData);

            /** TCentaurMainScreenGalleryVideoCardData Id. */
            public Id: string;

            /** TCentaurMainScreenGalleryVideoCardData ImageUrl. */
            public ImageUrl: string;

            /** TCentaurMainScreenGalleryVideoCardData Action. */
            public Action: string;

            /**
             * Creates a new TCentaurMainScreenGalleryVideoCardData instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TCentaurMainScreenGalleryVideoCardData instance
             */
            public static create(properties?: NAlice.NData.ITCentaurMainScreenGalleryVideoCardData): NAlice.NData.TCentaurMainScreenGalleryVideoCardData;

            /**
             * Encodes the specified TCentaurMainScreenGalleryVideoCardData message. Does not implicitly {@link NAlice.NData.TCentaurMainScreenGalleryVideoCardData.verify|verify} messages.
             * @param message TCentaurMainScreenGalleryVideoCardData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITCentaurMainScreenGalleryVideoCardData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TCentaurMainScreenGalleryVideoCardData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurMainScreenGalleryVideoCardData.verify|verify} messages.
             * @param message TCentaurMainScreenGalleryVideoCardData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITCentaurMainScreenGalleryVideoCardData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TCentaurMainScreenGalleryVideoCardData message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TCentaurMainScreenGalleryVideoCardData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TCentaurMainScreenGalleryVideoCardData;

            /**
             * Decodes a TCentaurMainScreenGalleryVideoCardData message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TCentaurMainScreenGalleryVideoCardData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TCentaurMainScreenGalleryVideoCardData;

            /**
             * Verifies a TCentaurMainScreenGalleryVideoCardData message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TCentaurMainScreenGalleryVideoCardData message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TCentaurMainScreenGalleryVideoCardData
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TCentaurMainScreenGalleryVideoCardData;

            /**
             * Creates a plain object from a TCentaurMainScreenGalleryVideoCardData message. Also converts values to other types if specified.
             * @param message TCentaurMainScreenGalleryVideoCardData
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TCentaurMainScreenGalleryVideoCardData, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TCentaurMainScreenGalleryVideoCardData to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a TCentaurMainScreenWebviewCardData. */
        interface ITCentaurMainScreenWebviewCardData {

            /** TCentaurMainScreenWebviewCardData Id */
            Id?: (string|null);

            /** TCentaurMainScreenWebviewCardData ImageUrl */
            ImageUrl?: (string|null);

            /** TCentaurMainScreenWebviewCardData WebviewUrl */
            WebviewUrl?: (string|null);

            /** TCentaurMainScreenWebviewCardData Title */
            Title?: (string|null);
        }

        /** Represents a TCentaurMainScreenWebviewCardData. */
        class TCentaurMainScreenWebviewCardData implements ITCentaurMainScreenWebviewCardData {

            /**
             * Constructs a new TCentaurMainScreenWebviewCardData.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITCentaurMainScreenWebviewCardData);

            /** TCentaurMainScreenWebviewCardData Id. */
            public Id: string;

            /** TCentaurMainScreenWebviewCardData ImageUrl. */
            public ImageUrl: string;

            /** TCentaurMainScreenWebviewCardData WebviewUrl. */
            public WebviewUrl: string;

            /** TCentaurMainScreenWebviewCardData Title. */
            public Title: string;

            /**
             * Creates a new TCentaurMainScreenWebviewCardData instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TCentaurMainScreenWebviewCardData instance
             */
            public static create(properties?: NAlice.NData.ITCentaurMainScreenWebviewCardData): NAlice.NData.TCentaurMainScreenWebviewCardData;

            /**
             * Encodes the specified TCentaurMainScreenWebviewCardData message. Does not implicitly {@link NAlice.NData.TCentaurMainScreenWebviewCardData.verify|verify} messages.
             * @param message TCentaurMainScreenWebviewCardData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITCentaurMainScreenWebviewCardData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TCentaurMainScreenWebviewCardData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurMainScreenWebviewCardData.verify|verify} messages.
             * @param message TCentaurMainScreenWebviewCardData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITCentaurMainScreenWebviewCardData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TCentaurMainScreenWebviewCardData message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TCentaurMainScreenWebviewCardData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TCentaurMainScreenWebviewCardData;

            /**
             * Decodes a TCentaurMainScreenWebviewCardData message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TCentaurMainScreenWebviewCardData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TCentaurMainScreenWebviewCardData;

            /**
             * Verifies a TCentaurMainScreenWebviewCardData message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TCentaurMainScreenWebviewCardData message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TCentaurMainScreenWebviewCardData
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TCentaurMainScreenWebviewCardData;

            /**
             * Creates a plain object from a TCentaurMainScreenWebviewCardData message. Also converts values to other types if specified.
             * @param message TCentaurMainScreenWebviewCardData
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TCentaurMainScreenWebviewCardData, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TCentaurMainScreenWebviewCardData to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a TCentaurMainScreenWebviewTabData. */
        interface ITCentaurMainScreenWebviewTabData {

            /** TCentaurMainScreenWebviewTabData Id */
            Id?: (string|null);

            /** TCentaurMainScreenWebviewTabData WebviewUrl */
            WebviewUrl?: (string|null);
        }

        /** Represents a TCentaurMainScreenWebviewTabData. */
        class TCentaurMainScreenWebviewTabData implements ITCentaurMainScreenWebviewTabData {

            /**
             * Constructs a new TCentaurMainScreenWebviewTabData.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITCentaurMainScreenWebviewTabData);

            /** TCentaurMainScreenWebviewTabData Id. */
            public Id: string;

            /** TCentaurMainScreenWebviewTabData WebviewUrl. */
            public WebviewUrl: string;

            /**
             * Creates a new TCentaurMainScreenWebviewTabData instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TCentaurMainScreenWebviewTabData instance
             */
            public static create(properties?: NAlice.NData.ITCentaurMainScreenWebviewTabData): NAlice.NData.TCentaurMainScreenWebviewTabData;

            /**
             * Encodes the specified TCentaurMainScreenWebviewTabData message. Does not implicitly {@link NAlice.NData.TCentaurMainScreenWebviewTabData.verify|verify} messages.
             * @param message TCentaurMainScreenWebviewTabData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITCentaurMainScreenWebviewTabData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TCentaurMainScreenWebviewTabData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurMainScreenWebviewTabData.verify|verify} messages.
             * @param message TCentaurMainScreenWebviewTabData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITCentaurMainScreenWebviewTabData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TCentaurMainScreenWebviewTabData message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TCentaurMainScreenWebviewTabData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TCentaurMainScreenWebviewTabData;

            /**
             * Decodes a TCentaurMainScreenWebviewTabData message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TCentaurMainScreenWebviewTabData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TCentaurMainScreenWebviewTabData;

            /**
             * Verifies a TCentaurMainScreenWebviewTabData message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TCentaurMainScreenWebviewTabData message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TCentaurMainScreenWebviewTabData
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TCentaurMainScreenWebviewTabData;

            /**
             * Creates a plain object from a TCentaurMainScreenWebviewTabData message. Also converts values to other types if specified.
             * @param message TCentaurMainScreenWebviewTabData
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TCentaurMainScreenWebviewTabData, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TCentaurMainScreenWebviewTabData to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a TCentaurMainScreenDiscoveryTabData. */
        interface ITCentaurMainScreenDiscoveryTabData {

            /** TCentaurMainScreenDiscoveryTabData Id */
            Id?: (string|null);
        }

        /** Represents a TCentaurMainScreenDiscoveryTabData. */
        class TCentaurMainScreenDiscoveryTabData implements ITCentaurMainScreenDiscoveryTabData {

            /**
             * Constructs a new TCentaurMainScreenDiscoveryTabData.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITCentaurMainScreenDiscoveryTabData);

            /** TCentaurMainScreenDiscoveryTabData Id. */
            public Id: string;

            /**
             * Creates a new TCentaurMainScreenDiscoveryTabData instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TCentaurMainScreenDiscoveryTabData instance
             */
            public static create(properties?: NAlice.NData.ITCentaurMainScreenDiscoveryTabData): NAlice.NData.TCentaurMainScreenDiscoveryTabData;

            /**
             * Encodes the specified TCentaurMainScreenDiscoveryTabData message. Does not implicitly {@link NAlice.NData.TCentaurMainScreenDiscoveryTabData.verify|verify} messages.
             * @param message TCentaurMainScreenDiscoveryTabData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITCentaurMainScreenDiscoveryTabData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TCentaurMainScreenDiscoveryTabData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurMainScreenDiscoveryTabData.verify|verify} messages.
             * @param message TCentaurMainScreenDiscoveryTabData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITCentaurMainScreenDiscoveryTabData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TCentaurMainScreenDiscoveryTabData message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TCentaurMainScreenDiscoveryTabData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TCentaurMainScreenDiscoveryTabData;

            /**
             * Decodes a TCentaurMainScreenDiscoveryTabData message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TCentaurMainScreenDiscoveryTabData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TCentaurMainScreenDiscoveryTabData;

            /**
             * Verifies a TCentaurMainScreenDiscoveryTabData message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TCentaurMainScreenDiscoveryTabData message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TCentaurMainScreenDiscoveryTabData
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TCentaurMainScreenDiscoveryTabData;

            /**
             * Creates a plain object from a TCentaurMainScreenDiscoveryTabData message. Also converts values to other types if specified.
             * @param message TCentaurMainScreenDiscoveryTabData
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TCentaurMainScreenDiscoveryTabData, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TCentaurMainScreenDiscoveryTabData to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a TCentaurMainScreenServicesTabData. */
        interface ITCentaurMainScreenServicesTabData {

            /** TCentaurMainScreenServicesTabData Id */
            Id?: (string|null);

            /** TCentaurMainScreenServicesTabData CentaurMainScreenWebviewCardData */
            CentaurMainScreenWebviewCardData?: (NAlice.NData.ITCentaurMainScreenWebviewCardData[]|null);
        }

        /** Represents a TCentaurMainScreenServicesTabData. */
        class TCentaurMainScreenServicesTabData implements ITCentaurMainScreenServicesTabData {

            /**
             * Constructs a new TCentaurMainScreenServicesTabData.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITCentaurMainScreenServicesTabData);

            /** TCentaurMainScreenServicesTabData Id. */
            public Id: string;

            /** TCentaurMainScreenServicesTabData CentaurMainScreenWebviewCardData. */
            public CentaurMainScreenWebviewCardData: NAlice.NData.ITCentaurMainScreenWebviewCardData[];

            /**
             * Creates a new TCentaurMainScreenServicesTabData instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TCentaurMainScreenServicesTabData instance
             */
            public static create(properties?: NAlice.NData.ITCentaurMainScreenServicesTabData): NAlice.NData.TCentaurMainScreenServicesTabData;

            /**
             * Encodes the specified TCentaurMainScreenServicesTabData message. Does not implicitly {@link NAlice.NData.TCentaurMainScreenServicesTabData.verify|verify} messages.
             * @param message TCentaurMainScreenServicesTabData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITCentaurMainScreenServicesTabData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TCentaurMainScreenServicesTabData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurMainScreenServicesTabData.verify|verify} messages.
             * @param message TCentaurMainScreenServicesTabData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITCentaurMainScreenServicesTabData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TCentaurMainScreenServicesTabData message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TCentaurMainScreenServicesTabData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TCentaurMainScreenServicesTabData;

            /**
             * Decodes a TCentaurMainScreenServicesTabData message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TCentaurMainScreenServicesTabData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TCentaurMainScreenServicesTabData;

            /**
             * Verifies a TCentaurMainScreenServicesTabData message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TCentaurMainScreenServicesTabData message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TCentaurMainScreenServicesTabData
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TCentaurMainScreenServicesTabData;

            /**
             * Creates a plain object from a TCentaurMainScreenServicesTabData message. Also converts values to other types if specified.
             * @param message TCentaurMainScreenServicesTabData
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TCentaurMainScreenServicesTabData, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TCentaurMainScreenServicesTabData to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a TCentaurMainScreenSmartHomeTabData. */
        interface ITCentaurMainScreenSmartHomeTabData {

            /** TCentaurMainScreenSmartHomeTabData Id */
            Id?: (string|null);

            /** TCentaurMainScreenSmartHomeTabData IoTUserData */
            IoTUserData?: (NAlice.ITIoTUserInfo|null);
        }

        /** Represents a TCentaurMainScreenSmartHomeTabData. */
        class TCentaurMainScreenSmartHomeTabData implements ITCentaurMainScreenSmartHomeTabData {

            /**
             * Constructs a new TCentaurMainScreenSmartHomeTabData.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITCentaurMainScreenSmartHomeTabData);

            /** TCentaurMainScreenSmartHomeTabData Id. */
            public Id: string;

            /** TCentaurMainScreenSmartHomeTabData IoTUserData. */
            public IoTUserData?: (NAlice.ITIoTUserInfo|null);

            /**
             * Creates a new TCentaurMainScreenSmartHomeTabData instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TCentaurMainScreenSmartHomeTabData instance
             */
            public static create(properties?: NAlice.NData.ITCentaurMainScreenSmartHomeTabData): NAlice.NData.TCentaurMainScreenSmartHomeTabData;

            /**
             * Encodes the specified TCentaurMainScreenSmartHomeTabData message. Does not implicitly {@link NAlice.NData.TCentaurMainScreenSmartHomeTabData.verify|verify} messages.
             * @param message TCentaurMainScreenSmartHomeTabData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITCentaurMainScreenSmartHomeTabData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TCentaurMainScreenSmartHomeTabData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurMainScreenSmartHomeTabData.verify|verify} messages.
             * @param message TCentaurMainScreenSmartHomeTabData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITCentaurMainScreenSmartHomeTabData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TCentaurMainScreenSmartHomeTabData message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TCentaurMainScreenSmartHomeTabData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TCentaurMainScreenSmartHomeTabData;

            /**
             * Decodes a TCentaurMainScreenSmartHomeTabData message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TCentaurMainScreenSmartHomeTabData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TCentaurMainScreenSmartHomeTabData;

            /**
             * Verifies a TCentaurMainScreenSmartHomeTabData message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TCentaurMainScreenSmartHomeTabData message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TCentaurMainScreenSmartHomeTabData
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TCentaurMainScreenSmartHomeTabData;

            /**
             * Creates a plain object from a TCentaurMainScreenSmartHomeTabData message. Also converts values to other types if specified.
             * @param message TCentaurMainScreenSmartHomeTabData
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TCentaurMainScreenSmartHomeTabData, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TCentaurMainScreenSmartHomeTabData to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a TCentaurWidgetCardData. */
        interface ITCentaurWidgetCardData {

            /** TCentaurWidgetCardData Id */
            Id?: (string|null);

            /** TCentaurWidgetCardData Action */
            Action?: (string|null);

            /** TCentaurWidgetCardData InfoCardData */
            InfoCardData?: (NAlice.NData.TCentaurWidgetCardData.ITInfoCardData|null);

            /** TCentaurWidgetCardData MusicCardData */
            MusicCardData?: (NAlice.NData.TCentaurWidgetCardData.ITMusicCardData|null);

            /** TCentaurWidgetCardData NewsCardData */
            NewsCardData?: (NAlice.NData.TCentaurWidgetCardData.ITNewsCardData|null);

            /** TCentaurWidgetCardData WeatherCardData */
            WeatherCardData?: (NAlice.NData.TCentaurWidgetCardData.ITWeatherCardData|null);

            /** TCentaurWidgetCardData YouTubeCardData */
            YouTubeCardData?: (NAlice.NData.TCentaurWidgetCardData.ITYouTubeCardData|null);

            /** TCentaurWidgetCardData VacantCardData */
            VacantCardData?: (NAlice.NData.TCentaurWidgetCardData.ITVacantCardData|null);

            /** TCentaurWidgetCardData TrafficCardData */
            TrafficCardData?: (NAlice.NData.TCentaurWidgetCardData.ITTrafficCardData|null);

            /** TCentaurWidgetCardData VideoCallCardData */
            VideoCallCardData?: (NAlice.NData.TCentaurWidgetCardData.ITVideoCallCardData|null);

            /** TCentaurWidgetCardData ExternalSkillCardData */
            ExternalSkillCardData?: (NAlice.NData.TCentaurWidgetCardData.ITExternalSkillCardData|null);

            /** TCentaurWidgetCardData LongTapAction */
            LongTapAction?: (string|null);

            /** TCentaurWidgetCardData DeleteWidgetAction */
            DeleteWidgetAction?: (string|null);

            /** TCentaurWidgetCardData MainScreenPosition */
            MainScreenPosition?: (NAlice.NData.ITWidgetPosition|null);

            /** TCentaurWidgetCardData TypedAction */
            TypedAction?: (google.protobuf.IAny|null);

            /** TCentaurWidgetCardData LongTapTypedAction */
            LongTapTypedAction?: (google.protobuf.IAny|null);

            /** TCentaurWidgetCardData DeleteWidgetTypedAction */
            DeleteWidgetTypedAction?: (google.protobuf.IAny|null);
        }

        /** Represents a TCentaurWidgetCardData. */
        class TCentaurWidgetCardData implements ITCentaurWidgetCardData {

            /**
             * Constructs a new TCentaurWidgetCardData.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITCentaurWidgetCardData);

            /** TCentaurWidgetCardData Id. */
            public Id: string;

            /** TCentaurWidgetCardData Action. */
            public Action: string;

            /** TCentaurWidgetCardData InfoCardData. */
            public InfoCardData?: (NAlice.NData.TCentaurWidgetCardData.ITInfoCardData|null);

            /** TCentaurWidgetCardData MusicCardData. */
            public MusicCardData?: (NAlice.NData.TCentaurWidgetCardData.ITMusicCardData|null);

            /** TCentaurWidgetCardData NewsCardData. */
            public NewsCardData?: (NAlice.NData.TCentaurWidgetCardData.ITNewsCardData|null);

            /** TCentaurWidgetCardData WeatherCardData. */
            public WeatherCardData?: (NAlice.NData.TCentaurWidgetCardData.ITWeatherCardData|null);

            /** TCentaurWidgetCardData YouTubeCardData. */
            public YouTubeCardData?: (NAlice.NData.TCentaurWidgetCardData.ITYouTubeCardData|null);

            /** TCentaurWidgetCardData VacantCardData. */
            public VacantCardData?: (NAlice.NData.TCentaurWidgetCardData.ITVacantCardData|null);

            /** TCentaurWidgetCardData TrafficCardData. */
            public TrafficCardData?: (NAlice.NData.TCentaurWidgetCardData.ITTrafficCardData|null);

            /** TCentaurWidgetCardData VideoCallCardData. */
            public VideoCallCardData?: (NAlice.NData.TCentaurWidgetCardData.ITVideoCallCardData|null);

            /** TCentaurWidgetCardData ExternalSkillCardData. */
            public ExternalSkillCardData?: (NAlice.NData.TCentaurWidgetCardData.ITExternalSkillCardData|null);

            /** TCentaurWidgetCardData LongTapAction. */
            public LongTapAction: string;

            /** TCentaurWidgetCardData DeleteWidgetAction. */
            public DeleteWidgetAction: string;

            /** TCentaurWidgetCardData MainScreenPosition. */
            public MainScreenPosition?: (NAlice.NData.ITWidgetPosition|null);

            /** TCentaurWidgetCardData TypedAction. */
            public TypedAction?: (google.protobuf.IAny|null);

            /** TCentaurWidgetCardData LongTapTypedAction. */
            public LongTapTypedAction?: (google.protobuf.IAny|null);

            /** TCentaurWidgetCardData DeleteWidgetTypedAction. */
            public DeleteWidgetTypedAction?: (google.protobuf.IAny|null);

            /** TCentaurWidgetCardData CardData. */
            public CardData?: ("InfoCardData"|"MusicCardData"|"NewsCardData"|"WeatherCardData"|"YouTubeCardData"|"VacantCardData"|"TrafficCardData"|"VideoCallCardData"|"ExternalSkillCardData");

            /**
             * Creates a new TCentaurWidgetCardData instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TCentaurWidgetCardData instance
             */
            public static create(properties?: NAlice.NData.ITCentaurWidgetCardData): NAlice.NData.TCentaurWidgetCardData;

            /**
             * Encodes the specified TCentaurWidgetCardData message. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardData.verify|verify} messages.
             * @param message TCentaurWidgetCardData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITCentaurWidgetCardData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TCentaurWidgetCardData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardData.verify|verify} messages.
             * @param message TCentaurWidgetCardData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITCentaurWidgetCardData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TCentaurWidgetCardData message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TCentaurWidgetCardData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TCentaurWidgetCardData;

            /**
             * Decodes a TCentaurWidgetCardData message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TCentaurWidgetCardData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TCentaurWidgetCardData;

            /**
             * Verifies a TCentaurWidgetCardData message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TCentaurWidgetCardData message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TCentaurWidgetCardData
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TCentaurWidgetCardData;

            /**
             * Creates a plain object from a TCentaurWidgetCardData message. Also converts values to other types if specified.
             * @param message TCentaurWidgetCardData
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TCentaurWidgetCardData, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TCentaurWidgetCardData to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        namespace TCentaurWidgetCardData {

            /** Properties of a TInfoCardData. */
            interface ITInfoCardData {

                /** TInfoCardData Title */
                Title?: (string|null);

                /** TInfoCardData Description */
                Description?: (string|null);

                /** TInfoCardData Color */
                Color?: (string|null);

                /** TInfoCardData ImageBackground */
                ImageBackground?: (string|null);

                /** TInfoCardData Subcomment */
                Subcomment?: (string|null);

                /** TInfoCardData Icon */
                Icon?: (string|null);
            }

            /** Represents a TInfoCardData. */
            class TInfoCardData implements ITInfoCardData {

                /**
                 * Constructs a new TInfoCardData.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: NAlice.NData.TCentaurWidgetCardData.ITInfoCardData);

                /** TInfoCardData Title. */
                public Title: string;

                /** TInfoCardData Description. */
                public Description: string;

                /** TInfoCardData Color. */
                public Color: string;

                /** TInfoCardData ImageBackground. */
                public ImageBackground: string;

                /** TInfoCardData Subcomment. */
                public Subcomment: string;

                /** TInfoCardData Icon. */
                public Icon: string;

                /**
                 * Creates a new TInfoCardData instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns TInfoCardData instance
                 */
                public static create(properties?: NAlice.NData.TCentaurWidgetCardData.ITInfoCardData): NAlice.NData.TCentaurWidgetCardData.TInfoCardData;

                /**
                 * Encodes the specified TInfoCardData message. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardData.TInfoCardData.verify|verify} messages.
                 * @param message TInfoCardData message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: NAlice.NData.TCentaurWidgetCardData.ITInfoCardData, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified TInfoCardData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardData.TInfoCardData.verify|verify} messages.
                 * @param message TInfoCardData message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: NAlice.NData.TCentaurWidgetCardData.ITInfoCardData, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a TInfoCardData message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns TInfoCardData
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TCentaurWidgetCardData.TInfoCardData;

                /**
                 * Decodes a TInfoCardData message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns TInfoCardData
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TCentaurWidgetCardData.TInfoCardData;

                /**
                 * Verifies a TInfoCardData message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a TInfoCardData message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns TInfoCardData
                 */
                public static fromObject(object: { [k: string]: any }): NAlice.NData.TCentaurWidgetCardData.TInfoCardData;

                /**
                 * Creates a plain object from a TInfoCardData message. Also converts values to other types if specified.
                 * @param message TInfoCardData
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: NAlice.NData.TCentaurWidgetCardData.TInfoCardData, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this TInfoCardData to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }

            /** Properties of a TMusicCardData. */
            interface ITMusicCardData {

                /** TMusicCardData Name */
                Name?: (string|null);

                /** TMusicCardData Color */
                Color?: (string|null);

                /** TMusicCardData Cover */
                Cover?: (string|null);

                /** TMusicCardData Modified */
                Modified?: (google.protobuf.IStringValue|null);
            }

            /** Represents a TMusicCardData. */
            class TMusicCardData implements ITMusicCardData {

                /**
                 * Constructs a new TMusicCardData.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: NAlice.NData.TCentaurWidgetCardData.ITMusicCardData);

                /** TMusicCardData Name. */
                public Name: string;

                /** TMusicCardData Color. */
                public Color: string;

                /** TMusicCardData Cover. */
                public Cover: string;

                /** TMusicCardData Modified. */
                public Modified?: (google.protobuf.IStringValue|null);

                /**
                 * Creates a new TMusicCardData instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns TMusicCardData instance
                 */
                public static create(properties?: NAlice.NData.TCentaurWidgetCardData.ITMusicCardData): NAlice.NData.TCentaurWidgetCardData.TMusicCardData;

                /**
                 * Encodes the specified TMusicCardData message. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardData.TMusicCardData.verify|verify} messages.
                 * @param message TMusicCardData message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: NAlice.NData.TCentaurWidgetCardData.ITMusicCardData, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified TMusicCardData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardData.TMusicCardData.verify|verify} messages.
                 * @param message TMusicCardData message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: NAlice.NData.TCentaurWidgetCardData.ITMusicCardData, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a TMusicCardData message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns TMusicCardData
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TCentaurWidgetCardData.TMusicCardData;

                /**
                 * Decodes a TMusicCardData message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns TMusicCardData
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TCentaurWidgetCardData.TMusicCardData;

                /**
                 * Verifies a TMusicCardData message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a TMusicCardData message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns TMusicCardData
                 */
                public static fromObject(object: { [k: string]: any }): NAlice.NData.TCentaurWidgetCardData.TMusicCardData;

                /**
                 * Creates a plain object from a TMusicCardData message. Also converts values to other types if specified.
                 * @param message TMusicCardData
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: NAlice.NData.TCentaurWidgetCardData.TMusicCardData, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this TMusicCardData to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }

            /** Properties of a TNewsCardData. */
            interface ITNewsCardData {

                /** TNewsCardData Title */
                Title?: (string|null);

                /** TNewsCardData Content */
                Content?: (string|null);

                /** TNewsCardData ImageUrl */
                ImageUrl?: (string|null);

                /** TNewsCardData Topic */
                Topic?: (string|null);
            }

            /** Represents a TNewsCardData. */
            class TNewsCardData implements ITNewsCardData {

                /**
                 * Constructs a new TNewsCardData.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: NAlice.NData.TCentaurWidgetCardData.ITNewsCardData);

                /** TNewsCardData Title. */
                public Title: string;

                /** TNewsCardData Content. */
                public Content: string;

                /** TNewsCardData ImageUrl. */
                public ImageUrl: string;

                /** TNewsCardData Topic. */
                public Topic: string;

                /**
                 * Creates a new TNewsCardData instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns TNewsCardData instance
                 */
                public static create(properties?: NAlice.NData.TCentaurWidgetCardData.ITNewsCardData): NAlice.NData.TCentaurWidgetCardData.TNewsCardData;

                /**
                 * Encodes the specified TNewsCardData message. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardData.TNewsCardData.verify|verify} messages.
                 * @param message TNewsCardData message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: NAlice.NData.TCentaurWidgetCardData.ITNewsCardData, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified TNewsCardData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardData.TNewsCardData.verify|verify} messages.
                 * @param message TNewsCardData message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: NAlice.NData.TCentaurWidgetCardData.ITNewsCardData, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a TNewsCardData message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns TNewsCardData
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TCentaurWidgetCardData.TNewsCardData;

                /**
                 * Decodes a TNewsCardData message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns TNewsCardData
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TCentaurWidgetCardData.TNewsCardData;

                /**
                 * Verifies a TNewsCardData message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a TNewsCardData message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns TNewsCardData
                 */
                public static fromObject(object: { [k: string]: any }): NAlice.NData.TCentaurWidgetCardData.TNewsCardData;

                /**
                 * Creates a plain object from a TNewsCardData message. Also converts values to other types if specified.
                 * @param message TNewsCardData
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: NAlice.NData.TCentaurWidgetCardData.TNewsCardData, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this TNewsCardData to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }

            /** Properties of a TWeatherCardData. */
            interface ITWeatherCardData {

                /** TWeatherCardData City */
                City?: (string|null);

                /** TWeatherCardData Temperature */
                Temperature?: (number|null);

                /** TWeatherCardData Image */
                Image?: (string|null);

                /** TWeatherCardData Comment */
                Comment?: (string|null);

                /** TWeatherCardData Sunrise */
                Sunrise?: (string|null);

                /** TWeatherCardData Sunset */
                Sunset?: (string|null);

                /** TWeatherCardData UserTime */
                UserTime?: (string|null);

                /** TWeatherCardData Condition */
                Condition?: (NAlice.NData.ITWeatherCondition|null);
            }

            /** Represents a TWeatherCardData. */
            class TWeatherCardData implements ITWeatherCardData {

                /**
                 * Constructs a new TWeatherCardData.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: NAlice.NData.TCentaurWidgetCardData.ITWeatherCardData);

                /** TWeatherCardData City. */
                public City: string;

                /** TWeatherCardData Temperature. */
                public Temperature: number;

                /** TWeatherCardData Image. */
                public Image: string;

                /** TWeatherCardData Comment. */
                public Comment: string;

                /** TWeatherCardData Sunrise. */
                public Sunrise: string;

                /** TWeatherCardData Sunset. */
                public Sunset: string;

                /** TWeatherCardData UserTime. */
                public UserTime: string;

                /** TWeatherCardData Condition. */
                public Condition?: (NAlice.NData.ITWeatherCondition|null);

                /**
                 * Creates a new TWeatherCardData instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns TWeatherCardData instance
                 */
                public static create(properties?: NAlice.NData.TCentaurWidgetCardData.ITWeatherCardData): NAlice.NData.TCentaurWidgetCardData.TWeatherCardData;

                /**
                 * Encodes the specified TWeatherCardData message. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardData.TWeatherCardData.verify|verify} messages.
                 * @param message TWeatherCardData message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: NAlice.NData.TCentaurWidgetCardData.ITWeatherCardData, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified TWeatherCardData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardData.TWeatherCardData.verify|verify} messages.
                 * @param message TWeatherCardData message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: NAlice.NData.TCentaurWidgetCardData.ITWeatherCardData, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a TWeatherCardData message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns TWeatherCardData
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TCentaurWidgetCardData.TWeatherCardData;

                /**
                 * Decodes a TWeatherCardData message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns TWeatherCardData
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TCentaurWidgetCardData.TWeatherCardData;

                /**
                 * Verifies a TWeatherCardData message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a TWeatherCardData message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns TWeatherCardData
                 */
                public static fromObject(object: { [k: string]: any }): NAlice.NData.TCentaurWidgetCardData.TWeatherCardData;

                /**
                 * Creates a plain object from a TWeatherCardData message. Also converts values to other types if specified.
                 * @param message TWeatherCardData
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: NAlice.NData.TCentaurWidgetCardData.TWeatherCardData, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this TWeatherCardData to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }

            /** Properties of a TYouTubeCardData. */
            interface ITYouTubeCardData {
            }

            /** Represents a TYouTubeCardData. */
            class TYouTubeCardData implements ITYouTubeCardData {

                /**
                 * Constructs a new TYouTubeCardData.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: NAlice.NData.TCentaurWidgetCardData.ITYouTubeCardData);

                /**
                 * Creates a new TYouTubeCardData instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns TYouTubeCardData instance
                 */
                public static create(properties?: NAlice.NData.TCentaurWidgetCardData.ITYouTubeCardData): NAlice.NData.TCentaurWidgetCardData.TYouTubeCardData;

                /**
                 * Encodes the specified TYouTubeCardData message. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardData.TYouTubeCardData.verify|verify} messages.
                 * @param message TYouTubeCardData message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: NAlice.NData.TCentaurWidgetCardData.ITYouTubeCardData, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified TYouTubeCardData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardData.TYouTubeCardData.verify|verify} messages.
                 * @param message TYouTubeCardData message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: NAlice.NData.TCentaurWidgetCardData.ITYouTubeCardData, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a TYouTubeCardData message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns TYouTubeCardData
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TCentaurWidgetCardData.TYouTubeCardData;

                /**
                 * Decodes a TYouTubeCardData message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns TYouTubeCardData
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TCentaurWidgetCardData.TYouTubeCardData;

                /**
                 * Verifies a TYouTubeCardData message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a TYouTubeCardData message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns TYouTubeCardData
                 */
                public static fromObject(object: { [k: string]: any }): NAlice.NData.TCentaurWidgetCardData.TYouTubeCardData;

                /**
                 * Creates a plain object from a TYouTubeCardData message. Also converts values to other types if specified.
                 * @param message TYouTubeCardData
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: NAlice.NData.TCentaurWidgetCardData.TYouTubeCardData, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this TYouTubeCardData to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }

            /** Properties of a TVacantCardData. */
            interface ITVacantCardData {
            }

            /** Represents a TVacantCardData. */
            class TVacantCardData implements ITVacantCardData {

                /**
                 * Constructs a new TVacantCardData.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: NAlice.NData.TCentaurWidgetCardData.ITVacantCardData);

                /**
                 * Creates a new TVacantCardData instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns TVacantCardData instance
                 */
                public static create(properties?: NAlice.NData.TCentaurWidgetCardData.ITVacantCardData): NAlice.NData.TCentaurWidgetCardData.TVacantCardData;

                /**
                 * Encodes the specified TVacantCardData message. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardData.TVacantCardData.verify|verify} messages.
                 * @param message TVacantCardData message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: NAlice.NData.TCentaurWidgetCardData.ITVacantCardData, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified TVacantCardData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardData.TVacantCardData.verify|verify} messages.
                 * @param message TVacantCardData message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: NAlice.NData.TCentaurWidgetCardData.ITVacantCardData, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a TVacantCardData message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns TVacantCardData
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TCentaurWidgetCardData.TVacantCardData;

                /**
                 * Decodes a TVacantCardData message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns TVacantCardData
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TCentaurWidgetCardData.TVacantCardData;

                /**
                 * Verifies a TVacantCardData message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a TVacantCardData message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns TVacantCardData
                 */
                public static fromObject(object: { [k: string]: any }): NAlice.NData.TCentaurWidgetCardData.TVacantCardData;

                /**
                 * Creates a plain object from a TVacantCardData message. Also converts values to other types if specified.
                 * @param message TVacantCardData
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: NAlice.NData.TCentaurWidgetCardData.TVacantCardData, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this TVacantCardData to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }

            /** Properties of a TTrafficCardData. */
            interface ITTrafficCardData {

                /** TTrafficCardData City */
                City?: (string|null);

                /** TTrafficCardData Message */
                Message?: (string|null);

                /** TTrafficCardData MapUrl */
                MapUrl?: (string|null);

                /** TTrafficCardData ImageUrl */
                ImageUrl?: (string|null);

                /** TTrafficCardData Level */
                Level?: (string|null);

                /** TTrafficCardData Score */
                Score?: (number|null);

                /** TTrafficCardData Forecast */
                Forecast?: (NAlice.NData.TCentaurWidgetCardData.TTrafficCardData.ITTrafficForecastData[]|null);
            }

            /** Represents a TTrafficCardData. */
            class TTrafficCardData implements ITTrafficCardData {

                /**
                 * Constructs a new TTrafficCardData.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: NAlice.NData.TCentaurWidgetCardData.ITTrafficCardData);

                /** TTrafficCardData City. */
                public City: string;

                /** TTrafficCardData Message. */
                public Message: string;

                /** TTrafficCardData MapUrl. */
                public MapUrl: string;

                /** TTrafficCardData ImageUrl. */
                public ImageUrl: string;

                /** TTrafficCardData Level. */
                public Level: string;

                /** TTrafficCardData Score. */
                public Score: number;

                /** TTrafficCardData Forecast. */
                public Forecast: NAlice.NData.TCentaurWidgetCardData.TTrafficCardData.ITTrafficForecastData[];

                /**
                 * Creates a new TTrafficCardData instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns TTrafficCardData instance
                 */
                public static create(properties?: NAlice.NData.TCentaurWidgetCardData.ITTrafficCardData): NAlice.NData.TCentaurWidgetCardData.TTrafficCardData;

                /**
                 * Encodes the specified TTrafficCardData message. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardData.TTrafficCardData.verify|verify} messages.
                 * @param message TTrafficCardData message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: NAlice.NData.TCentaurWidgetCardData.ITTrafficCardData, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified TTrafficCardData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardData.TTrafficCardData.verify|verify} messages.
                 * @param message TTrafficCardData message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: NAlice.NData.TCentaurWidgetCardData.ITTrafficCardData, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a TTrafficCardData message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns TTrafficCardData
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TCentaurWidgetCardData.TTrafficCardData;

                /**
                 * Decodes a TTrafficCardData message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns TTrafficCardData
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TCentaurWidgetCardData.TTrafficCardData;

                /**
                 * Verifies a TTrafficCardData message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a TTrafficCardData message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns TTrafficCardData
                 */
                public static fromObject(object: { [k: string]: any }): NAlice.NData.TCentaurWidgetCardData.TTrafficCardData;

                /**
                 * Creates a plain object from a TTrafficCardData message. Also converts values to other types if specified.
                 * @param message TTrafficCardData
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: NAlice.NData.TCentaurWidgetCardData.TTrafficCardData, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this TTrafficCardData to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }

            namespace TTrafficCardData {

                /** Properties of a TTrafficForecastData. */
                interface ITTrafficForecastData {

                    /** TTrafficForecastData Hour */
                    Hour?: (number|null);

                    /** TTrafficForecastData Score */
                    Score?: (number|null);
                }

                /** Represents a TTrafficForecastData. */
                class TTrafficForecastData implements ITTrafficForecastData {

                    /**
                     * Constructs a new TTrafficForecastData.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: NAlice.NData.TCentaurWidgetCardData.TTrafficCardData.ITTrafficForecastData);

                    /** TTrafficForecastData Hour. */
                    public Hour: number;

                    /** TTrafficForecastData Score. */
                    public Score: number;

                    /**
                     * Creates a new TTrafficForecastData instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns TTrafficForecastData instance
                     */
                    public static create(properties?: NAlice.NData.TCentaurWidgetCardData.TTrafficCardData.ITTrafficForecastData): NAlice.NData.TCentaurWidgetCardData.TTrafficCardData.TTrafficForecastData;

                    /**
                     * Encodes the specified TTrafficForecastData message. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardData.TTrafficCardData.TTrafficForecastData.verify|verify} messages.
                     * @param message TTrafficForecastData message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: NAlice.NData.TCentaurWidgetCardData.TTrafficCardData.ITTrafficForecastData, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified TTrafficForecastData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardData.TTrafficCardData.TTrafficForecastData.verify|verify} messages.
                     * @param message TTrafficForecastData message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: NAlice.NData.TCentaurWidgetCardData.TTrafficCardData.ITTrafficForecastData, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a TTrafficForecastData message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns TTrafficForecastData
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TCentaurWidgetCardData.TTrafficCardData.TTrafficForecastData;

                    /**
                     * Decodes a TTrafficForecastData message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns TTrafficForecastData
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TCentaurWidgetCardData.TTrafficCardData.TTrafficForecastData;

                    /**
                     * Verifies a TTrafficForecastData message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a TTrafficForecastData message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns TTrafficForecastData
                     */
                    public static fromObject(object: { [k: string]: any }): NAlice.NData.TCentaurWidgetCardData.TTrafficCardData.TTrafficForecastData;

                    /**
                     * Creates a plain object from a TTrafficForecastData message. Also converts values to other types if specified.
                     * @param message TTrafficForecastData
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: NAlice.NData.TCentaurWidgetCardData.TTrafficCardData.TTrafficForecastData, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this TTrafficForecastData to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }
            }

            /** Properties of a TVideoCallCardData. */
            interface ITVideoCallCardData {

                /** TVideoCallCardData LoggedOutCardData */
                LoggedOutCardData?: (NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.ITLoggedOutCardData|null);

                /** TVideoCallCardData LoggedInCardData */
                LoggedInCardData?: (NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.ITLoggedInCardData|null);
            }

            /** Represents a TVideoCallCardData. */
            class TVideoCallCardData implements ITVideoCallCardData {

                /**
                 * Constructs a new TVideoCallCardData.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: NAlice.NData.TCentaurWidgetCardData.ITVideoCallCardData);

                /** TVideoCallCardData LoggedOutCardData. */
                public LoggedOutCardData?: (NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.ITLoggedOutCardData|null);

                /** TVideoCallCardData LoggedInCardData. */
                public LoggedInCardData?: (NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.ITLoggedInCardData|null);

                /** TVideoCallCardData CardTypeData. */
                public CardTypeData?: ("LoggedOutCardData"|"LoggedInCardData");

                /**
                 * Creates a new TVideoCallCardData instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns TVideoCallCardData instance
                 */
                public static create(properties?: NAlice.NData.TCentaurWidgetCardData.ITVideoCallCardData): NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData;

                /**
                 * Encodes the specified TVideoCallCardData message. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.verify|verify} messages.
                 * @param message TVideoCallCardData message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: NAlice.NData.TCentaurWidgetCardData.ITVideoCallCardData, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified TVideoCallCardData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.verify|verify} messages.
                 * @param message TVideoCallCardData message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: NAlice.NData.TCentaurWidgetCardData.ITVideoCallCardData, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a TVideoCallCardData message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns TVideoCallCardData
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData;

                /**
                 * Decodes a TVideoCallCardData message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns TVideoCallCardData
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData;

                /**
                 * Verifies a TVideoCallCardData message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a TVideoCallCardData message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns TVideoCallCardData
                 */
                public static fromObject(object: { [k: string]: any }): NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData;

                /**
                 * Creates a plain object from a TVideoCallCardData message. Also converts values to other types if specified.
                 * @param message TVideoCallCardData
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this TVideoCallCardData to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }

            namespace TVideoCallCardData {

                /** Properties of a TLoggedOutCardData. */
                interface ITLoggedOutCardData {
                }

                /** Represents a TLoggedOutCardData. */
                class TLoggedOutCardData implements ITLoggedOutCardData {

                    /**
                     * Constructs a new TLoggedOutCardData.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.ITLoggedOutCardData);

                    /**
                     * Creates a new TLoggedOutCardData instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns TLoggedOutCardData instance
                     */
                    public static create(properties?: NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.ITLoggedOutCardData): NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedOutCardData;

                    /**
                     * Encodes the specified TLoggedOutCardData message. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedOutCardData.verify|verify} messages.
                     * @param message TLoggedOutCardData message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.ITLoggedOutCardData, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified TLoggedOutCardData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedOutCardData.verify|verify} messages.
                     * @param message TLoggedOutCardData message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.ITLoggedOutCardData, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a TLoggedOutCardData message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns TLoggedOutCardData
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedOutCardData;

                    /**
                     * Decodes a TLoggedOutCardData message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns TLoggedOutCardData
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedOutCardData;

                    /**
                     * Verifies a TLoggedOutCardData message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a TLoggedOutCardData message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns TLoggedOutCardData
                     */
                    public static fromObject(object: { [k: string]: any }): NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedOutCardData;

                    /**
                     * Creates a plain object from a TLoggedOutCardData message. Also converts values to other types if specified.
                     * @param message TLoggedOutCardData
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedOutCardData, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this TLoggedOutCardData to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a TLoggedInCardData. */
                interface ITLoggedInCardData {

                    /** TLoggedInCardData TelegramCardData */
                    TelegramCardData?: (NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.ITTelegramCardData|null);
                }

                /** Represents a TLoggedInCardData. */
                class TLoggedInCardData implements ITLoggedInCardData {

                    /**
                     * Constructs a new TLoggedInCardData.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.ITLoggedInCardData);

                    /** TLoggedInCardData TelegramCardData. */
                    public TelegramCardData?: (NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.ITTelegramCardData|null);

                    /** TLoggedInCardData ProviderData. */
                    public ProviderData?: "TelegramCardData";

                    /**
                     * Creates a new TLoggedInCardData instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns TLoggedInCardData instance
                     */
                    public static create(properties?: NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.ITLoggedInCardData): NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData;

                    /**
                     * Encodes the specified TLoggedInCardData message. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.verify|verify} messages.
                     * @param message TLoggedInCardData message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.ITLoggedInCardData, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified TLoggedInCardData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.verify|verify} messages.
                     * @param message TLoggedInCardData message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.ITLoggedInCardData, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a TLoggedInCardData message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns TLoggedInCardData
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData;

                    /**
                     * Decodes a TLoggedInCardData message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns TLoggedInCardData
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData;

                    /**
                     * Verifies a TLoggedInCardData message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a TLoggedInCardData message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns TLoggedInCardData
                     */
                    public static fromObject(object: { [k: string]: any }): NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData;

                    /**
                     * Creates a plain object from a TLoggedInCardData message. Also converts values to other types if specified.
                     * @param message TLoggedInCardData
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this TLoggedInCardData to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                namespace TLoggedInCardData {

                    /** Properties of a TTelegramCardData. */
                    interface ITTelegramCardData {

                        /** TTelegramCardData UserId */
                        UserId?: (string|null);

                        /** TTelegramCardData ContactsUploaded */
                        ContactsUploaded?: (boolean|null);

                        /** TTelegramCardData FavoriteContactData */
                        FavoriteContactData?: (NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.ITFavoriteContactData[]|null);
                    }

                    /** Represents a TTelegramCardData. */
                    class TTelegramCardData implements ITTelegramCardData {

                        /**
                         * Constructs a new TTelegramCardData.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.ITTelegramCardData);

                        /** TTelegramCardData UserId. */
                        public UserId: string;

                        /** TTelegramCardData ContactsUploaded. */
                        public ContactsUploaded: boolean;

                        /** TTelegramCardData FavoriteContactData. */
                        public FavoriteContactData: NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.ITFavoriteContactData[];

                        /**
                         * Creates a new TTelegramCardData instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns TTelegramCardData instance
                         */
                        public static create(properties?: NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.ITTelegramCardData): NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.TTelegramCardData;

                        /**
                         * Encodes the specified TTelegramCardData message. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.TTelegramCardData.verify|verify} messages.
                         * @param message TTelegramCardData message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.ITTelegramCardData, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified TTelegramCardData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.TTelegramCardData.verify|verify} messages.
                         * @param message TTelegramCardData message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.ITTelegramCardData, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a TTelegramCardData message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns TTelegramCardData
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.TTelegramCardData;

                        /**
                         * Decodes a TTelegramCardData message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns TTelegramCardData
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.TTelegramCardData;

                        /**
                         * Verifies a TTelegramCardData message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a TTelegramCardData message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns TTelegramCardData
                         */
                        public static fromObject(object: { [k: string]: any }): NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.TTelegramCardData;

                        /**
                         * Creates a plain object from a TTelegramCardData message. Also converts values to other types if specified.
                         * @param message TTelegramCardData
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.TTelegramCardData, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this TTelegramCardData to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of a TFavoriteContactData. */
                    interface ITFavoriteContactData {

                        /** TFavoriteContactData DisplayName */
                        DisplayName?: (string|null);

                        /** TFavoriteContactData UserId */
                        UserId?: (string|null);

                        /** TFavoriteContactData LookupKey */
                        LookupKey?: (string|null);
                    }

                    /** Represents a TFavoriteContactData. */
                    class TFavoriteContactData implements ITFavoriteContactData {

                        /**
                         * Constructs a new TFavoriteContactData.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.ITFavoriteContactData);

                        /** TFavoriteContactData DisplayName. */
                        public DisplayName: string;

                        /** TFavoriteContactData UserId. */
                        public UserId: string;

                        /** TFavoriteContactData LookupKey. */
                        public LookupKey: string;

                        /**
                         * Creates a new TFavoriteContactData instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns TFavoriteContactData instance
                         */
                        public static create(properties?: NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.ITFavoriteContactData): NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.TFavoriteContactData;

                        /**
                         * Encodes the specified TFavoriteContactData message. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.TFavoriteContactData.verify|verify} messages.
                         * @param message TFavoriteContactData message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.ITFavoriteContactData, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified TFavoriteContactData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.TFavoriteContactData.verify|verify} messages.
                         * @param message TFavoriteContactData message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.ITFavoriteContactData, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a TFavoriteContactData message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns TFavoriteContactData
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.TFavoriteContactData;

                        /**
                         * Decodes a TFavoriteContactData message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns TFavoriteContactData
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.TFavoriteContactData;

                        /**
                         * Verifies a TFavoriteContactData message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a TFavoriteContactData message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns TFavoriteContactData
                         */
                        public static fromObject(object: { [k: string]: any }): NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.TFavoriteContactData;

                        /**
                         * Creates a plain object from a TFavoriteContactData message. Also converts values to other types if specified.
                         * @param message TFavoriteContactData
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.TFavoriteContactData, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this TFavoriteContactData to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }
                }
            }

            /** Properties of a TExternalSkillCardData. */
            interface ITExternalSkillCardData {

                /** TExternalSkillCardData widgetGalleryData */
                widgetGalleryData?: (NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.ITWidgetGalleryData|null);

                /** TExternalSkillCardData mainScreenData */
                mainScreenData?: (NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.ITMainScreenData|null);

                /** TExternalSkillCardData skillInfo */
                skillInfo?: (NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.ITSkillInfo|null);
            }

            /** Represents a TExternalSkillCardData. */
            class TExternalSkillCardData implements ITExternalSkillCardData {

                /**
                 * Constructs a new TExternalSkillCardData.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: NAlice.NData.TCentaurWidgetCardData.ITExternalSkillCardData);

                /** TExternalSkillCardData widgetGalleryData. */
                public widgetGalleryData?: (NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.ITWidgetGalleryData|null);

                /** TExternalSkillCardData mainScreenData. */
                public mainScreenData?: (NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.ITMainScreenData|null);

                /** TExternalSkillCardData skillInfo. */
                public skillInfo?: (NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.ITSkillInfo|null);

                /** TExternalSkillCardData SkillCardData. */
                public SkillCardData?: ("widgetGalleryData"|"mainScreenData");

                /**
                 * Creates a new TExternalSkillCardData instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns TExternalSkillCardData instance
                 */
                public static create(properties?: NAlice.NData.TCentaurWidgetCardData.ITExternalSkillCardData): NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData;

                /**
                 * Encodes the specified TExternalSkillCardData message. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.verify|verify} messages.
                 * @param message TExternalSkillCardData message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: NAlice.NData.TCentaurWidgetCardData.ITExternalSkillCardData, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified TExternalSkillCardData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.verify|verify} messages.
                 * @param message TExternalSkillCardData message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: NAlice.NData.TCentaurWidgetCardData.ITExternalSkillCardData, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a TExternalSkillCardData message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns TExternalSkillCardData
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData;

                /**
                 * Decodes a TExternalSkillCardData message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns TExternalSkillCardData
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData;

                /**
                 * Verifies a TExternalSkillCardData message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a TExternalSkillCardData message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns TExternalSkillCardData
                 */
                public static fromObject(object: { [k: string]: any }): NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData;

                /**
                 * Creates a plain object from a TExternalSkillCardData message. Also converts values to other types if specified.
                 * @param message TExternalSkillCardData
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this TExternalSkillCardData to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }

            namespace TExternalSkillCardData {

                /** Properties of a TSkillInfo. */
                interface ITSkillInfo {

                    /** TSkillInfo Name */
                    Name?: (string|null);

                    /** TSkillInfo Logo */
                    Logo?: (string|null);

                    /** TSkillInfo SkillId */
                    SkillId?: (string|null);
                }

                /** Represents a TSkillInfo. */
                class TSkillInfo implements ITSkillInfo {

                    /**
                     * Constructs a new TSkillInfo.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.ITSkillInfo);

                    /** TSkillInfo Name. */
                    public Name: string;

                    /** TSkillInfo Logo. */
                    public Logo: string;

                    /** TSkillInfo SkillId. */
                    public SkillId: string;

                    /**
                     * Creates a new TSkillInfo instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns TSkillInfo instance
                     */
                    public static create(properties?: NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.ITSkillInfo): NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TSkillInfo;

                    /**
                     * Encodes the specified TSkillInfo message. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TSkillInfo.verify|verify} messages.
                     * @param message TSkillInfo message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.ITSkillInfo, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified TSkillInfo message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TSkillInfo.verify|verify} messages.
                     * @param message TSkillInfo message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.ITSkillInfo, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a TSkillInfo message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns TSkillInfo
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TSkillInfo;

                    /**
                     * Decodes a TSkillInfo message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns TSkillInfo
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TSkillInfo;

                    /**
                     * Verifies a TSkillInfo message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a TSkillInfo message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns TSkillInfo
                     */
                    public static fromObject(object: { [k: string]: any }): NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TSkillInfo;

                    /**
                     * Creates a plain object from a TSkillInfo message. Also converts values to other types if specified.
                     * @param message TSkillInfo
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TSkillInfo, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this TSkillInfo to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a TWidgetGalleryData. */
                interface ITWidgetGalleryData {
                }

                /** Represents a TWidgetGalleryData. */
                class TWidgetGalleryData implements ITWidgetGalleryData {

                    /**
                     * Constructs a new TWidgetGalleryData.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.ITWidgetGalleryData);

                    /**
                     * Creates a new TWidgetGalleryData instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns TWidgetGalleryData instance
                     */
                    public static create(properties?: NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.ITWidgetGalleryData): NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TWidgetGalleryData;

                    /**
                     * Encodes the specified TWidgetGalleryData message. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TWidgetGalleryData.verify|verify} messages.
                     * @param message TWidgetGalleryData message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.ITWidgetGalleryData, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified TWidgetGalleryData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TWidgetGalleryData.verify|verify} messages.
                     * @param message TWidgetGalleryData message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.ITWidgetGalleryData, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a TWidgetGalleryData message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns TWidgetGalleryData
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TWidgetGalleryData;

                    /**
                     * Decodes a TWidgetGalleryData message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns TWidgetGalleryData
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TWidgetGalleryData;

                    /**
                     * Verifies a TWidgetGalleryData message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a TWidgetGalleryData message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns TWidgetGalleryData
                     */
                    public static fromObject(object: { [k: string]: any }): NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TWidgetGalleryData;

                    /**
                     * Creates a plain object from a TWidgetGalleryData message. Also converts values to other types if specified.
                     * @param message TWidgetGalleryData
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TWidgetGalleryData, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this TWidgetGalleryData to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a TMainScreenData. */
                interface ITMainScreenData {

                    /** TMainScreenData Title */
                    Title?: (string|null);

                    /** TMainScreenData Text */
                    Text?: (string|null);

                    /** TMainScreenData ImageUrl */
                    ImageUrl?: (string|null);

                    /** TMainScreenData buttons */
                    buttons?: (NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData.ITButton[]|null);
                }

                /** Represents a TMainScreenData. */
                class TMainScreenData implements ITMainScreenData {

                    /**
                     * Constructs a new TMainScreenData.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.ITMainScreenData);

                    /** TMainScreenData Title. */
                    public Title: string;

                    /** TMainScreenData Text. */
                    public Text: string;

                    /** TMainScreenData ImageUrl. */
                    public ImageUrl: string;

                    /** TMainScreenData buttons. */
                    public buttons: NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData.ITButton[];

                    /**
                     * Creates a new TMainScreenData instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns TMainScreenData instance
                     */
                    public static create(properties?: NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.ITMainScreenData): NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData;

                    /**
                     * Encodes the specified TMainScreenData message. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData.verify|verify} messages.
                     * @param message TMainScreenData message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.ITMainScreenData, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified TMainScreenData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData.verify|verify} messages.
                     * @param message TMainScreenData message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.ITMainScreenData, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a TMainScreenData message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns TMainScreenData
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData;

                    /**
                     * Decodes a TMainScreenData message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns TMainScreenData
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData;

                    /**
                     * Verifies a TMainScreenData message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a TMainScreenData message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns TMainScreenData
                     */
                    public static fromObject(object: { [k: string]: any }): NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData;

                    /**
                     * Creates a plain object from a TMainScreenData message. Also converts values to other types if specified.
                     * @param message TMainScreenData
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this TMainScreenData to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                namespace TMainScreenData {

                    /** Properties of a TButton. */
                    interface ITButton {

                        /** TButton Text */
                        Text?: (string|null);

                        /** TButton Url */
                        Url?: (string|null);

                        /** TButton Payload */
                        Payload?: (string|null);
                    }

                    /** Represents a TButton. */
                    class TButton implements ITButton {

                        /**
                         * Constructs a new TButton.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData.ITButton);

                        /** TButton Text. */
                        public Text: string;

                        /** TButton Url. */
                        public Url: string;

                        /** TButton Payload. */
                        public Payload: string;

                        /**
                         * Creates a new TButton instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns TButton instance
                         */
                        public static create(properties?: NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData.ITButton): NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData.TButton;

                        /**
                         * Encodes the specified TButton message. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData.TButton.verify|verify} messages.
                         * @param message TButton message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData.ITButton, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified TButton message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData.TButton.verify|verify} messages.
                         * @param message TButton message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData.ITButton, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a TButton message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns TButton
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData.TButton;

                        /**
                         * Decodes a TButton message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns TButton
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData.TButton;

                        /**
                         * Verifies a TButton message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a TButton message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns TButton
                         */
                        public static fromObject(object: { [k: string]: any }): NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData.TButton;

                        /**
                         * Creates a plain object from a TButton message. Also converts values to other types if specified.
                         * @param message TButton
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData.TButton, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this TButton to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }
                }
            }
        }

        /** Properties of a TCentaurWidgetCardItem. */
        interface ITCentaurWidgetCardItem {

            /** TCentaurWidgetCardItem Id */
            Id?: (string|null);

            /** TCentaurWidgetCardItem CardData */
            CardData?: (NAlice.NData.ITCentaurWidgetCardData|null);

            /** TCentaurWidgetCardItem Div2Card */
            Div2Card?: (NAlice.ITDiv2Card|null);

            /** TCentaurWidgetCardItem Div2CardCompact */
            Div2CardCompact?: (NAlice.ITDiv2Card|null);

            /** TCentaurWidgetCardItem OpenWidgetGalleryAction */
            OpenWidgetGalleryAction?: (string|null);
        }

        /** Represents a TCentaurWidgetCardItem. */
        class TCentaurWidgetCardItem implements ITCentaurWidgetCardItem {

            /**
             * Constructs a new TCentaurWidgetCardItem.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITCentaurWidgetCardItem);

            /** TCentaurWidgetCardItem Id. */
            public Id: string;

            /** TCentaurWidgetCardItem CardData. */
            public CardData?: (NAlice.NData.ITCentaurWidgetCardData|null);

            /** TCentaurWidgetCardItem Div2Card. */
            public Div2Card?: (NAlice.ITDiv2Card|null);

            /** TCentaurWidgetCardItem Div2CardCompact. */
            public Div2CardCompact?: (NAlice.ITDiv2Card|null);

            /** TCentaurWidgetCardItem OpenWidgetGalleryAction. */
            public OpenWidgetGalleryAction: string;

            /**
             * Creates a new TCentaurWidgetCardItem instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TCentaurWidgetCardItem instance
             */
            public static create(properties?: NAlice.NData.ITCentaurWidgetCardItem): NAlice.NData.TCentaurWidgetCardItem;

            /**
             * Encodes the specified TCentaurWidgetCardItem message. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardItem.verify|verify} messages.
             * @param message TCentaurWidgetCardItem message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITCentaurWidgetCardItem, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TCentaurWidgetCardItem message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardItem.verify|verify} messages.
             * @param message TCentaurWidgetCardItem message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITCentaurWidgetCardItem, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TCentaurWidgetCardItem message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TCentaurWidgetCardItem
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TCentaurWidgetCardItem;

            /**
             * Decodes a TCentaurWidgetCardItem message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TCentaurWidgetCardItem
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TCentaurWidgetCardItem;

            /**
             * Verifies a TCentaurWidgetCardItem message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TCentaurWidgetCardItem message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TCentaurWidgetCardItem
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TCentaurWidgetCardItem;

            /**
             * Creates a plain object from a TCentaurWidgetCardItem message. Also converts values to other types if specified.
             * @param message TCentaurWidgetCardItem
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TCentaurWidgetCardItem, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TCentaurWidgetCardItem to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a TCentaurWidgetCardItemData. */
        interface ITCentaurWidgetCardItemData {

            /** TCentaurWidgetCardItemData WidgetType */
            WidgetType?: (string|null);

            /** TCentaurWidgetCardItemData CentaurWidgetCardItems */
            CentaurWidgetCardItems?: (NAlice.NData.ITCentaurWidgetCardItem[]|null);
        }

        /** Represents a TCentaurWidgetCardItemData. */
        class TCentaurWidgetCardItemData implements ITCentaurWidgetCardItemData {

            /**
             * Constructs a new TCentaurWidgetCardItemData.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITCentaurWidgetCardItemData);

            /** TCentaurWidgetCardItemData WidgetType. */
            public WidgetType: string;

            /** TCentaurWidgetCardItemData CentaurWidgetCardItems. */
            public CentaurWidgetCardItems: NAlice.NData.ITCentaurWidgetCardItem[];

            /**
             * Creates a new TCentaurWidgetCardItemData instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TCentaurWidgetCardItemData instance
             */
            public static create(properties?: NAlice.NData.ITCentaurWidgetCardItemData): NAlice.NData.TCentaurWidgetCardItemData;

            /**
             * Encodes the specified TCentaurWidgetCardItemData message. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardItemData.verify|verify} messages.
             * @param message TCentaurWidgetCardItemData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITCentaurWidgetCardItemData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TCentaurWidgetCardItemData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardItemData.verify|verify} messages.
             * @param message TCentaurWidgetCardItemData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITCentaurWidgetCardItemData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TCentaurWidgetCardItemData message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TCentaurWidgetCardItemData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TCentaurWidgetCardItemData;

            /**
             * Decodes a TCentaurWidgetCardItemData message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TCentaurWidgetCardItemData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TCentaurWidgetCardItemData;

            /**
             * Verifies a TCentaurWidgetCardItemData message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TCentaurWidgetCardItemData message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TCentaurWidgetCardItemData
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TCentaurWidgetCardItemData;

            /**
             * Creates a plain object from a TCentaurWidgetCardItemData message. Also converts values to other types if specified.
             * @param message TCentaurWidgetCardItemData
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TCentaurWidgetCardItemData, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TCentaurWidgetCardItemData to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a TCentaurScenarioWidgetData. */
        interface ITCentaurScenarioWidgetData {

            /** TCentaurScenarioWidgetData WidgetType */
            WidgetType?: (string|null);

            /** TCentaurScenarioWidgetData WidgetCards */
            WidgetCards?: (NAlice.NData.ITCentaurWidgetCardData[]|null);
        }

        /** Represents a TCentaurScenarioWidgetData. */
        class TCentaurScenarioWidgetData implements ITCentaurScenarioWidgetData {

            /**
             * Constructs a new TCentaurScenarioWidgetData.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITCentaurScenarioWidgetData);

            /** TCentaurScenarioWidgetData WidgetType. */
            public WidgetType: string;

            /** TCentaurScenarioWidgetData WidgetCards. */
            public WidgetCards: NAlice.NData.ITCentaurWidgetCardData[];

            /**
             * Creates a new TCentaurScenarioWidgetData instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TCentaurScenarioWidgetData instance
             */
            public static create(properties?: NAlice.NData.ITCentaurScenarioWidgetData): NAlice.NData.TCentaurScenarioWidgetData;

            /**
             * Encodes the specified TCentaurScenarioWidgetData message. Does not implicitly {@link NAlice.NData.TCentaurScenarioWidgetData.verify|verify} messages.
             * @param message TCentaurScenarioWidgetData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITCentaurScenarioWidgetData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TCentaurScenarioWidgetData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurScenarioWidgetData.verify|verify} messages.
             * @param message TCentaurScenarioWidgetData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITCentaurScenarioWidgetData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TCentaurScenarioWidgetData message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TCentaurScenarioWidgetData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TCentaurScenarioWidgetData;

            /**
             * Decodes a TCentaurScenarioWidgetData message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TCentaurScenarioWidgetData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TCentaurScenarioWidgetData;

            /**
             * Verifies a TCentaurScenarioWidgetData message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TCentaurScenarioWidgetData message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TCentaurScenarioWidgetData
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TCentaurScenarioWidgetData;

            /**
             * Creates a plain object from a TCentaurScenarioWidgetData message. Also converts values to other types if specified.
             * @param message TCentaurScenarioWidgetData
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TCentaurScenarioWidgetData, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TCentaurScenarioWidgetData to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a TCentaurMainScreenMyScreenData. */
        interface ITCentaurMainScreenMyScreenData {

            /** TCentaurMainScreenMyScreenData Id */
            Id?: (string|null);

            /** TCentaurMainScreenMyScreenData Columns */
            Columns?: (NAlice.NData.TCentaurMainScreenMyScreenData.ITColumn[]|null);
        }

        /** Represents a TCentaurMainScreenMyScreenData. */
        class TCentaurMainScreenMyScreenData implements ITCentaurMainScreenMyScreenData {

            /**
             * Constructs a new TCentaurMainScreenMyScreenData.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITCentaurMainScreenMyScreenData);

            /** TCentaurMainScreenMyScreenData Id. */
            public Id: string;

            /** TCentaurMainScreenMyScreenData Columns. */
            public Columns: NAlice.NData.TCentaurMainScreenMyScreenData.ITColumn[];

            /**
             * Creates a new TCentaurMainScreenMyScreenData instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TCentaurMainScreenMyScreenData instance
             */
            public static create(properties?: NAlice.NData.ITCentaurMainScreenMyScreenData): NAlice.NData.TCentaurMainScreenMyScreenData;

            /**
             * Encodes the specified TCentaurMainScreenMyScreenData message. Does not implicitly {@link NAlice.NData.TCentaurMainScreenMyScreenData.verify|verify} messages.
             * @param message TCentaurMainScreenMyScreenData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITCentaurMainScreenMyScreenData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TCentaurMainScreenMyScreenData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurMainScreenMyScreenData.verify|verify} messages.
             * @param message TCentaurMainScreenMyScreenData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITCentaurMainScreenMyScreenData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TCentaurMainScreenMyScreenData message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TCentaurMainScreenMyScreenData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TCentaurMainScreenMyScreenData;

            /**
             * Decodes a TCentaurMainScreenMyScreenData message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TCentaurMainScreenMyScreenData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TCentaurMainScreenMyScreenData;

            /**
             * Verifies a TCentaurMainScreenMyScreenData message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TCentaurMainScreenMyScreenData message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TCentaurMainScreenMyScreenData
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TCentaurMainScreenMyScreenData;

            /**
             * Creates a plain object from a TCentaurMainScreenMyScreenData message. Also converts values to other types if specified.
             * @param message TCentaurMainScreenMyScreenData
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TCentaurMainScreenMyScreenData, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TCentaurMainScreenMyScreenData to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        namespace TCentaurMainScreenMyScreenData {

            /** Properties of a TColumn. */
            interface ITColumn {

                /** TColumn Cards */
                Cards?: (NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.ITCardData[]|null);

                /** TColumn WidgetCards */
                WidgetCards?: (NAlice.NData.ITCentaurWidgetCardData[]|null);

                /** TColumn WidgetCardItems */
                WidgetCardItems?: (NAlice.NData.ITCentaurWidgetCardItem[]|null);
            }

            /** Represents a TColumn. */
            class TColumn implements ITColumn {

                /**
                 * Constructs a new TColumn.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: NAlice.NData.TCentaurMainScreenMyScreenData.ITColumn);

                /** TColumn Cards. */
                public Cards: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.ITCardData[];

                /** TColumn WidgetCards. */
                public WidgetCards: NAlice.NData.ITCentaurWidgetCardData[];

                /** TColumn WidgetCardItems. */
                public WidgetCardItems: NAlice.NData.ITCentaurWidgetCardItem[];

                /**
                 * Creates a new TColumn instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns TColumn instance
                 */
                public static create(properties?: NAlice.NData.TCentaurMainScreenMyScreenData.ITColumn): NAlice.NData.TCentaurMainScreenMyScreenData.TColumn;

                /**
                 * Encodes the specified TColumn message. Does not implicitly {@link NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.verify|verify} messages.
                 * @param message TColumn message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: NAlice.NData.TCentaurMainScreenMyScreenData.ITColumn, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified TColumn message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.verify|verify} messages.
                 * @param message TColumn message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: NAlice.NData.TCentaurMainScreenMyScreenData.ITColumn, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a TColumn message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns TColumn
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TCentaurMainScreenMyScreenData.TColumn;

                /**
                 * Decodes a TColumn message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns TColumn
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TCentaurMainScreenMyScreenData.TColumn;

                /**
                 * Verifies a TColumn message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a TColumn message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns TColumn
                 */
                public static fromObject(object: { [k: string]: any }): NAlice.NData.TCentaurMainScreenMyScreenData.TColumn;

                /**
                 * Creates a plain object from a TColumn message. Also converts values to other types if specified.
                 * @param message TColumn
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this TColumn to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }

            namespace TColumn {

                /** Properties of a TCardData. */
                interface ITCardData {

                    /** TCardData Id */
                    Id?: (string|null);

                    /** TCardData Action */
                    Action?: (string|null);

                    /** TCardData InfoCardData */
                    InfoCardData?: (NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITInfoCardData|null);

                    /** TCardData MusicCardData */
                    MusicCardData?: (NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITMusicCardData|null);

                    /** TCardData NewsCardData */
                    NewsCardData?: (NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITNewsCardData|null);

                    /** TCardData WeatherCardData */
                    WeatherCardData?: (NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITWeatherCardData|null);

                    /** TCardData YouTubeCardData */
                    YouTubeCardData?: (NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITYouTubeCardData|null);

                    /** TCardData VacantCardData */
                    VacantCardData?: (NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITVacantCardData|null);

                    /** TCardData TrafficCardData */
                    TrafficCardData?: (NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITTrafficCardData|null);

                    /** TCardData VideoCallCardData */
                    VideoCallCardData?: (NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITVideoCallCardData|null);

                    /** TCardData ExternalSkillCardData */
                    ExternalSkillCardData?: (NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITExternalSkillCardData|null);

                    /** TCardData LongTapAction */
                    LongTapAction?: (string|null);

                    /** TCardData DeleteWidgetAction */
                    DeleteWidgetAction?: (string|null);

                    /** TCardData TypedAction */
                    TypedAction?: (google.protobuf.IAny|null);

                    /** TCardData LongTapTypedAction */
                    LongTapTypedAction?: (google.protobuf.IAny|null);

                    /** TCardData DeleteWidgetTypedAction */
                    DeleteWidgetTypedAction?: (google.protobuf.IAny|null);
                }

                /** Represents a TCardData. */
                class TCardData implements ITCardData {

                    /**
                     * Constructs a new TCardData.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.ITCardData);

                    /** TCardData Id. */
                    public Id: string;

                    /** TCardData Action. */
                    public Action: string;

                    /** TCardData InfoCardData. */
                    public InfoCardData?: (NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITInfoCardData|null);

                    /** TCardData MusicCardData. */
                    public MusicCardData?: (NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITMusicCardData|null);

                    /** TCardData NewsCardData. */
                    public NewsCardData?: (NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITNewsCardData|null);

                    /** TCardData WeatherCardData. */
                    public WeatherCardData?: (NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITWeatherCardData|null);

                    /** TCardData YouTubeCardData. */
                    public YouTubeCardData?: (NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITYouTubeCardData|null);

                    /** TCardData VacantCardData. */
                    public VacantCardData?: (NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITVacantCardData|null);

                    /** TCardData TrafficCardData. */
                    public TrafficCardData?: (NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITTrafficCardData|null);

                    /** TCardData VideoCallCardData. */
                    public VideoCallCardData?: (NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITVideoCallCardData|null);

                    /** TCardData ExternalSkillCardData. */
                    public ExternalSkillCardData?: (NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITExternalSkillCardData|null);

                    /** TCardData LongTapAction. */
                    public LongTapAction: string;

                    /** TCardData DeleteWidgetAction. */
                    public DeleteWidgetAction: string;

                    /** TCardData TypedAction. */
                    public TypedAction?: (google.protobuf.IAny|null);

                    /** TCardData LongTapTypedAction. */
                    public LongTapTypedAction?: (google.protobuf.IAny|null);

                    /** TCardData DeleteWidgetTypedAction. */
                    public DeleteWidgetTypedAction?: (google.protobuf.IAny|null);

                    /** TCardData CardData. */
                    public CardData?: ("InfoCardData"|"MusicCardData"|"NewsCardData"|"WeatherCardData"|"YouTubeCardData"|"VacantCardData"|"TrafficCardData"|"VideoCallCardData"|"ExternalSkillCardData");

                    /**
                     * Creates a new TCardData instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns TCardData instance
                     */
                    public static create(properties?: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.ITCardData): NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData;

                    /**
                     * Encodes the specified TCardData message. Does not implicitly {@link NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.verify|verify} messages.
                     * @param message TCardData message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.ITCardData, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified TCardData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.verify|verify} messages.
                     * @param message TCardData message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.ITCardData, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a TCardData message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns TCardData
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData;

                    /**
                     * Decodes a TCardData message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns TCardData
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData;

                    /**
                     * Verifies a TCardData message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a TCardData message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns TCardData
                     */
                    public static fromObject(object: { [k: string]: any }): NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData;

                    /**
                     * Creates a plain object from a TCardData message. Also converts values to other types if specified.
                     * @param message TCardData
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this TCardData to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                namespace TCardData {

                    /** Properties of a TInfoCardData. */
                    interface ITInfoCardData {

                        /** TInfoCardData Title */
                        Title?: (string|null);

                        /** TInfoCardData Description */
                        Description?: (string|null);

                        /** TInfoCardData Color */
                        Color?: (string|null);

                        /** TInfoCardData ImageBackground */
                        ImageBackground?: (string|null);

                        /** TInfoCardData Subcomment */
                        Subcomment?: (string|null);

                        /** TInfoCardData Icon */
                        Icon?: (string|null);
                    }

                    /** Represents a TInfoCardData. */
                    class TInfoCardData implements ITInfoCardData {

                        /**
                         * Constructs a new TInfoCardData.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITInfoCardData);

                        /** TInfoCardData Title. */
                        public Title: string;

                        /** TInfoCardData Description. */
                        public Description: string;

                        /** TInfoCardData Color. */
                        public Color: string;

                        /** TInfoCardData ImageBackground. */
                        public ImageBackground: string;

                        /** TInfoCardData Subcomment. */
                        public Subcomment: string;

                        /** TInfoCardData Icon. */
                        public Icon: string;

                        /**
                         * Creates a new TInfoCardData instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns TInfoCardData instance
                         */
                        public static create(properties?: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITInfoCardData): NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TInfoCardData;

                        /**
                         * Encodes the specified TInfoCardData message. Does not implicitly {@link NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TInfoCardData.verify|verify} messages.
                         * @param message TInfoCardData message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITInfoCardData, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified TInfoCardData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TInfoCardData.verify|verify} messages.
                         * @param message TInfoCardData message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITInfoCardData, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a TInfoCardData message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns TInfoCardData
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TInfoCardData;

                        /**
                         * Decodes a TInfoCardData message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns TInfoCardData
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TInfoCardData;

                        /**
                         * Verifies a TInfoCardData message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a TInfoCardData message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns TInfoCardData
                         */
                        public static fromObject(object: { [k: string]: any }): NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TInfoCardData;

                        /**
                         * Creates a plain object from a TInfoCardData message. Also converts values to other types if specified.
                         * @param message TInfoCardData
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TInfoCardData, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this TInfoCardData to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of a TMusicCardData. */
                    interface ITMusicCardData {

                        /** TMusicCardData Name */
                        Name?: (string|null);

                        /** TMusicCardData Color */
                        Color?: (string|null);

                        /** TMusicCardData Cover */
                        Cover?: (string|null);

                        /** TMusicCardData Modified */
                        Modified?: (google.protobuf.IStringValue|null);
                    }

                    /** Represents a TMusicCardData. */
                    class TMusicCardData implements ITMusicCardData {

                        /**
                         * Constructs a new TMusicCardData.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITMusicCardData);

                        /** TMusicCardData Name. */
                        public Name: string;

                        /** TMusicCardData Color. */
                        public Color: string;

                        /** TMusicCardData Cover. */
                        public Cover: string;

                        /** TMusicCardData Modified. */
                        public Modified?: (google.protobuf.IStringValue|null);

                        /**
                         * Creates a new TMusicCardData instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns TMusicCardData instance
                         */
                        public static create(properties?: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITMusicCardData): NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TMusicCardData;

                        /**
                         * Encodes the specified TMusicCardData message. Does not implicitly {@link NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TMusicCardData.verify|verify} messages.
                         * @param message TMusicCardData message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITMusicCardData, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified TMusicCardData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TMusicCardData.verify|verify} messages.
                         * @param message TMusicCardData message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITMusicCardData, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a TMusicCardData message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns TMusicCardData
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TMusicCardData;

                        /**
                         * Decodes a TMusicCardData message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns TMusicCardData
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TMusicCardData;

                        /**
                         * Verifies a TMusicCardData message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a TMusicCardData message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns TMusicCardData
                         */
                        public static fromObject(object: { [k: string]: any }): NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TMusicCardData;

                        /**
                         * Creates a plain object from a TMusicCardData message. Also converts values to other types if specified.
                         * @param message TMusicCardData
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TMusicCardData, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this TMusicCardData to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of a TNewsCardData. */
                    interface ITNewsCardData {

                        /** TNewsCardData Title */
                        Title?: (string|null);

                        /** TNewsCardData Content */
                        Content?: (string|null);

                        /** TNewsCardData ImageUrl */
                        ImageUrl?: (string|null);

                        /** TNewsCardData Topic */
                        Topic?: (string|null);
                    }

                    /** Represents a TNewsCardData. */
                    class TNewsCardData implements ITNewsCardData {

                        /**
                         * Constructs a new TNewsCardData.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITNewsCardData);

                        /** TNewsCardData Title. */
                        public Title: string;

                        /** TNewsCardData Content. */
                        public Content: string;

                        /** TNewsCardData ImageUrl. */
                        public ImageUrl: string;

                        /** TNewsCardData Topic. */
                        public Topic: string;

                        /**
                         * Creates a new TNewsCardData instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns TNewsCardData instance
                         */
                        public static create(properties?: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITNewsCardData): NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TNewsCardData;

                        /**
                         * Encodes the specified TNewsCardData message. Does not implicitly {@link NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TNewsCardData.verify|verify} messages.
                         * @param message TNewsCardData message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITNewsCardData, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified TNewsCardData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TNewsCardData.verify|verify} messages.
                         * @param message TNewsCardData message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITNewsCardData, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a TNewsCardData message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns TNewsCardData
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TNewsCardData;

                        /**
                         * Decodes a TNewsCardData message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns TNewsCardData
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TNewsCardData;

                        /**
                         * Verifies a TNewsCardData message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a TNewsCardData message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns TNewsCardData
                         */
                        public static fromObject(object: { [k: string]: any }): NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TNewsCardData;

                        /**
                         * Creates a plain object from a TNewsCardData message. Also converts values to other types if specified.
                         * @param message TNewsCardData
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TNewsCardData, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this TNewsCardData to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of a TWeatherCardData. */
                    interface ITWeatherCardData {

                        /** TWeatherCardData City */
                        City?: (string|null);

                        /** TWeatherCardData Temperature */
                        Temperature?: (number|null);

                        /** TWeatherCardData Image */
                        Image?: (string|null);

                        /** TWeatherCardData Comment */
                        Comment?: (string|null);

                        /** TWeatherCardData Sunrise */
                        Sunrise?: (string|null);

                        /** TWeatherCardData Sunset */
                        Sunset?: (string|null);

                        /** TWeatherCardData UserTime */
                        UserTime?: (string|null);

                        /** TWeatherCardData Condition */
                        Condition?: (NAlice.NData.ITWeatherCondition|null);
                    }

                    /** Represents a TWeatherCardData. */
                    class TWeatherCardData implements ITWeatherCardData {

                        /**
                         * Constructs a new TWeatherCardData.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITWeatherCardData);

                        /** TWeatherCardData City. */
                        public City: string;

                        /** TWeatherCardData Temperature. */
                        public Temperature: number;

                        /** TWeatherCardData Image. */
                        public Image: string;

                        /** TWeatherCardData Comment. */
                        public Comment: string;

                        /** TWeatherCardData Sunrise. */
                        public Sunrise: string;

                        /** TWeatherCardData Sunset. */
                        public Sunset: string;

                        /** TWeatherCardData UserTime. */
                        public UserTime: string;

                        /** TWeatherCardData Condition. */
                        public Condition?: (NAlice.NData.ITWeatherCondition|null);

                        /**
                         * Creates a new TWeatherCardData instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns TWeatherCardData instance
                         */
                        public static create(properties?: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITWeatherCardData): NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TWeatherCardData;

                        /**
                         * Encodes the specified TWeatherCardData message. Does not implicitly {@link NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TWeatherCardData.verify|verify} messages.
                         * @param message TWeatherCardData message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITWeatherCardData, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified TWeatherCardData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TWeatherCardData.verify|verify} messages.
                         * @param message TWeatherCardData message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITWeatherCardData, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a TWeatherCardData message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns TWeatherCardData
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TWeatherCardData;

                        /**
                         * Decodes a TWeatherCardData message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns TWeatherCardData
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TWeatherCardData;

                        /**
                         * Verifies a TWeatherCardData message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a TWeatherCardData message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns TWeatherCardData
                         */
                        public static fromObject(object: { [k: string]: any }): NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TWeatherCardData;

                        /**
                         * Creates a plain object from a TWeatherCardData message. Also converts values to other types if specified.
                         * @param message TWeatherCardData
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TWeatherCardData, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this TWeatherCardData to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of a TYouTubeCardData. */
                    interface ITYouTubeCardData {
                    }

                    /** Represents a TYouTubeCardData. */
                    class TYouTubeCardData implements ITYouTubeCardData {

                        /**
                         * Constructs a new TYouTubeCardData.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITYouTubeCardData);

                        /**
                         * Creates a new TYouTubeCardData instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns TYouTubeCardData instance
                         */
                        public static create(properties?: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITYouTubeCardData): NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TYouTubeCardData;

                        /**
                         * Encodes the specified TYouTubeCardData message. Does not implicitly {@link NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TYouTubeCardData.verify|verify} messages.
                         * @param message TYouTubeCardData message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITYouTubeCardData, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified TYouTubeCardData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TYouTubeCardData.verify|verify} messages.
                         * @param message TYouTubeCardData message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITYouTubeCardData, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a TYouTubeCardData message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns TYouTubeCardData
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TYouTubeCardData;

                        /**
                         * Decodes a TYouTubeCardData message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns TYouTubeCardData
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TYouTubeCardData;

                        /**
                         * Verifies a TYouTubeCardData message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a TYouTubeCardData message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns TYouTubeCardData
                         */
                        public static fromObject(object: { [k: string]: any }): NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TYouTubeCardData;

                        /**
                         * Creates a plain object from a TYouTubeCardData message. Also converts values to other types if specified.
                         * @param message TYouTubeCardData
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TYouTubeCardData, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this TYouTubeCardData to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of a TVacantCardData. */
                    interface ITVacantCardData {
                    }

                    /** Represents a TVacantCardData. */
                    class TVacantCardData implements ITVacantCardData {

                        /**
                         * Constructs a new TVacantCardData.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITVacantCardData);

                        /**
                         * Creates a new TVacantCardData instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns TVacantCardData instance
                         */
                        public static create(properties?: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITVacantCardData): NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVacantCardData;

                        /**
                         * Encodes the specified TVacantCardData message. Does not implicitly {@link NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVacantCardData.verify|verify} messages.
                         * @param message TVacantCardData message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITVacantCardData, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified TVacantCardData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVacantCardData.verify|verify} messages.
                         * @param message TVacantCardData message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITVacantCardData, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a TVacantCardData message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns TVacantCardData
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVacantCardData;

                        /**
                         * Decodes a TVacantCardData message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns TVacantCardData
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVacantCardData;

                        /**
                         * Verifies a TVacantCardData message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a TVacantCardData message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns TVacantCardData
                         */
                        public static fromObject(object: { [k: string]: any }): NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVacantCardData;

                        /**
                         * Creates a plain object from a TVacantCardData message. Also converts values to other types if specified.
                         * @param message TVacantCardData
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVacantCardData, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this TVacantCardData to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of a TTrafficCardData. */
                    interface ITTrafficCardData {

                        /** TTrafficCardData City */
                        City?: (string|null);

                        /** TTrafficCardData Message */
                        Message?: (string|null);

                        /** TTrafficCardData MapUrl */
                        MapUrl?: (string|null);

                        /** TTrafficCardData ImageUrl */
                        ImageUrl?: (string|null);

                        /** TTrafficCardData Level */
                        Level?: (string|null);

                        /** TTrafficCardData Score */
                        Score?: (number|null);

                        /** TTrafficCardData Forecast */
                        Forecast?: (NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData.ITTrafficForecastData[]|null);
                    }

                    /** Represents a TTrafficCardData. */
                    class TTrafficCardData implements ITTrafficCardData {

                        /**
                         * Constructs a new TTrafficCardData.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITTrafficCardData);

                        /** TTrafficCardData City. */
                        public City: string;

                        /** TTrafficCardData Message. */
                        public Message: string;

                        /** TTrafficCardData MapUrl. */
                        public MapUrl: string;

                        /** TTrafficCardData ImageUrl. */
                        public ImageUrl: string;

                        /** TTrafficCardData Level. */
                        public Level: string;

                        /** TTrafficCardData Score. */
                        public Score: number;

                        /** TTrafficCardData Forecast. */
                        public Forecast: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData.ITTrafficForecastData[];

                        /**
                         * Creates a new TTrafficCardData instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns TTrafficCardData instance
                         */
                        public static create(properties?: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITTrafficCardData): NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData;

                        /**
                         * Encodes the specified TTrafficCardData message. Does not implicitly {@link NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData.verify|verify} messages.
                         * @param message TTrafficCardData message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITTrafficCardData, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified TTrafficCardData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData.verify|verify} messages.
                         * @param message TTrafficCardData message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITTrafficCardData, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a TTrafficCardData message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns TTrafficCardData
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData;

                        /**
                         * Decodes a TTrafficCardData message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns TTrafficCardData
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData;

                        /**
                         * Verifies a TTrafficCardData message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a TTrafficCardData message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns TTrafficCardData
                         */
                        public static fromObject(object: { [k: string]: any }): NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData;

                        /**
                         * Creates a plain object from a TTrafficCardData message. Also converts values to other types if specified.
                         * @param message TTrafficCardData
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this TTrafficCardData to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    namespace TTrafficCardData {

                        /** Properties of a TTrafficForecastData. */
                        interface ITTrafficForecastData {

                            /** TTrafficForecastData Hour */
                            Hour?: (number|null);

                            /** TTrafficForecastData Score */
                            Score?: (number|null);
                        }

                        /** Represents a TTrafficForecastData. */
                        class TTrafficForecastData implements ITTrafficForecastData {

                            /**
                             * Constructs a new TTrafficForecastData.
                             * @param [properties] Properties to set
                             */
                            constructor(properties?: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData.ITTrafficForecastData);

                            /** TTrafficForecastData Hour. */
                            public Hour: number;

                            /** TTrafficForecastData Score. */
                            public Score: number;

                            /**
                             * Creates a new TTrafficForecastData instance using the specified properties.
                             * @param [properties] Properties to set
                             * @returns TTrafficForecastData instance
                             */
                            public static create(properties?: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData.ITTrafficForecastData): NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData.TTrafficForecastData;

                            /**
                             * Encodes the specified TTrafficForecastData message. Does not implicitly {@link NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData.TTrafficForecastData.verify|verify} messages.
                             * @param message TTrafficForecastData message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encode(message: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData.ITTrafficForecastData, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Encodes the specified TTrafficForecastData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData.TTrafficForecastData.verify|verify} messages.
                             * @param message TTrafficForecastData message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encodeDelimited(message: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData.ITTrafficForecastData, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Decodes a TTrafficForecastData message from the specified reader or buffer.
                             * @param reader Reader or buffer to decode from
                             * @param [length] Message length if known beforehand
                             * @returns TTrafficForecastData
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData.TTrafficForecastData;

                            /**
                             * Decodes a TTrafficForecastData message from the specified reader or buffer, length delimited.
                             * @param reader Reader or buffer to decode from
                             * @returns TTrafficForecastData
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData.TTrafficForecastData;

                            /**
                             * Verifies a TTrafficForecastData message.
                             * @param message Plain object to verify
                             * @returns `null` if valid, otherwise the reason why it is not
                             */
                            public static verify(message: { [k: string]: any }): (string|null);

                            /**
                             * Creates a TTrafficForecastData message from a plain object. Also converts values to their respective internal types.
                             * @param object Plain object
                             * @returns TTrafficForecastData
                             */
                            public static fromObject(object: { [k: string]: any }): NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData.TTrafficForecastData;

                            /**
                             * Creates a plain object from a TTrafficForecastData message. Also converts values to other types if specified.
                             * @param message TTrafficForecastData
                             * @param [options] Conversion options
                             * @returns Plain object
                             */
                            public static toObject(message: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData.TTrafficForecastData, options?: $protobuf.IConversionOptions): { [k: string]: any };

                            /**
                             * Converts this TTrafficForecastData to JSON.
                             * @returns JSON object
                             */
                            public toJSON(): { [k: string]: any };
                        }
                    }

                    /** Properties of a TVideoCallCardData. */
                    interface ITVideoCallCardData {

                        /** TVideoCallCardData LoggedOutCardData */
                        LoggedOutCardData?: (NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.ITLoggedOutCardData|null);

                        /** TVideoCallCardData LoggedInCardData */
                        LoggedInCardData?: (NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.ITLoggedInCardData|null);
                    }

                    /** Represents a TVideoCallCardData. */
                    class TVideoCallCardData implements ITVideoCallCardData {

                        /**
                         * Constructs a new TVideoCallCardData.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITVideoCallCardData);

                        /** TVideoCallCardData LoggedOutCardData. */
                        public LoggedOutCardData?: (NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.ITLoggedOutCardData|null);

                        /** TVideoCallCardData LoggedInCardData. */
                        public LoggedInCardData?: (NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.ITLoggedInCardData|null);

                        /** TVideoCallCardData CardTypeData. */
                        public CardTypeData?: ("LoggedOutCardData"|"LoggedInCardData");

                        /**
                         * Creates a new TVideoCallCardData instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns TVideoCallCardData instance
                         */
                        public static create(properties?: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITVideoCallCardData): NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData;

                        /**
                         * Encodes the specified TVideoCallCardData message. Does not implicitly {@link NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.verify|verify} messages.
                         * @param message TVideoCallCardData message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITVideoCallCardData, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified TVideoCallCardData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.verify|verify} messages.
                         * @param message TVideoCallCardData message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITVideoCallCardData, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a TVideoCallCardData message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns TVideoCallCardData
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData;

                        /**
                         * Decodes a TVideoCallCardData message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns TVideoCallCardData
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData;

                        /**
                         * Verifies a TVideoCallCardData message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a TVideoCallCardData message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns TVideoCallCardData
                         */
                        public static fromObject(object: { [k: string]: any }): NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData;

                        /**
                         * Creates a plain object from a TVideoCallCardData message. Also converts values to other types if specified.
                         * @param message TVideoCallCardData
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this TVideoCallCardData to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    namespace TVideoCallCardData {

                        /** Properties of a TLoggedOutCardData. */
                        interface ITLoggedOutCardData {
                        }

                        /** Represents a TLoggedOutCardData. */
                        class TLoggedOutCardData implements ITLoggedOutCardData {

                            /**
                             * Constructs a new TLoggedOutCardData.
                             * @param [properties] Properties to set
                             */
                            constructor(properties?: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.ITLoggedOutCardData);

                            /**
                             * Creates a new TLoggedOutCardData instance using the specified properties.
                             * @param [properties] Properties to set
                             * @returns TLoggedOutCardData instance
                             */
                            public static create(properties?: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.ITLoggedOutCardData): NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedOutCardData;

                            /**
                             * Encodes the specified TLoggedOutCardData message. Does not implicitly {@link NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedOutCardData.verify|verify} messages.
                             * @param message TLoggedOutCardData message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encode(message: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.ITLoggedOutCardData, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Encodes the specified TLoggedOutCardData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedOutCardData.verify|verify} messages.
                             * @param message TLoggedOutCardData message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encodeDelimited(message: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.ITLoggedOutCardData, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Decodes a TLoggedOutCardData message from the specified reader or buffer.
                             * @param reader Reader or buffer to decode from
                             * @param [length] Message length if known beforehand
                             * @returns TLoggedOutCardData
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedOutCardData;

                            /**
                             * Decodes a TLoggedOutCardData message from the specified reader or buffer, length delimited.
                             * @param reader Reader or buffer to decode from
                             * @returns TLoggedOutCardData
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedOutCardData;

                            /**
                             * Verifies a TLoggedOutCardData message.
                             * @param message Plain object to verify
                             * @returns `null` if valid, otherwise the reason why it is not
                             */
                            public static verify(message: { [k: string]: any }): (string|null);

                            /**
                             * Creates a TLoggedOutCardData message from a plain object. Also converts values to their respective internal types.
                             * @param object Plain object
                             * @returns TLoggedOutCardData
                             */
                            public static fromObject(object: { [k: string]: any }): NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedOutCardData;

                            /**
                             * Creates a plain object from a TLoggedOutCardData message. Also converts values to other types if specified.
                             * @param message TLoggedOutCardData
                             * @param [options] Conversion options
                             * @returns Plain object
                             */
                            public static toObject(message: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedOutCardData, options?: $protobuf.IConversionOptions): { [k: string]: any };

                            /**
                             * Converts this TLoggedOutCardData to JSON.
                             * @returns JSON object
                             */
                            public toJSON(): { [k: string]: any };
                        }

                        /** Properties of a TLoggedInCardData. */
                        interface ITLoggedInCardData {

                            /** TLoggedInCardData TelegramCardData */
                            TelegramCardData?: (NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.ITTelegramCardData|null);
                        }

                        /** Represents a TLoggedInCardData. */
                        class TLoggedInCardData implements ITLoggedInCardData {

                            /**
                             * Constructs a new TLoggedInCardData.
                             * @param [properties] Properties to set
                             */
                            constructor(properties?: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.ITLoggedInCardData);

                            /** TLoggedInCardData TelegramCardData. */
                            public TelegramCardData?: (NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.ITTelegramCardData|null);

                            /** TLoggedInCardData ProviderData. */
                            public ProviderData?: "TelegramCardData";

                            /**
                             * Creates a new TLoggedInCardData instance using the specified properties.
                             * @param [properties] Properties to set
                             * @returns TLoggedInCardData instance
                             */
                            public static create(properties?: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.ITLoggedInCardData): NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData;

                            /**
                             * Encodes the specified TLoggedInCardData message. Does not implicitly {@link NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.verify|verify} messages.
                             * @param message TLoggedInCardData message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encode(message: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.ITLoggedInCardData, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Encodes the specified TLoggedInCardData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.verify|verify} messages.
                             * @param message TLoggedInCardData message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encodeDelimited(message: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.ITLoggedInCardData, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Decodes a TLoggedInCardData message from the specified reader or buffer.
                             * @param reader Reader or buffer to decode from
                             * @param [length] Message length if known beforehand
                             * @returns TLoggedInCardData
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData;

                            /**
                             * Decodes a TLoggedInCardData message from the specified reader or buffer, length delimited.
                             * @param reader Reader or buffer to decode from
                             * @returns TLoggedInCardData
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData;

                            /**
                             * Verifies a TLoggedInCardData message.
                             * @param message Plain object to verify
                             * @returns `null` if valid, otherwise the reason why it is not
                             */
                            public static verify(message: { [k: string]: any }): (string|null);

                            /**
                             * Creates a TLoggedInCardData message from a plain object. Also converts values to their respective internal types.
                             * @param object Plain object
                             * @returns TLoggedInCardData
                             */
                            public static fromObject(object: { [k: string]: any }): NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData;

                            /**
                             * Creates a plain object from a TLoggedInCardData message. Also converts values to other types if specified.
                             * @param message TLoggedInCardData
                             * @param [options] Conversion options
                             * @returns Plain object
                             */
                            public static toObject(message: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData, options?: $protobuf.IConversionOptions): { [k: string]: any };

                            /**
                             * Converts this TLoggedInCardData to JSON.
                             * @returns JSON object
                             */
                            public toJSON(): { [k: string]: any };
                        }

                        namespace TLoggedInCardData {

                            /** Properties of a TTelegramCardData. */
                            interface ITTelegramCardData {

                                /** TTelegramCardData UserId */
                                UserId?: (string|null);

                                /** TTelegramCardData ContactsUploaded */
                                ContactsUploaded?: (boolean|null);

                                /** TTelegramCardData FavoriteContactData */
                                FavoriteContactData?: (NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.ITFavoriteContactData[]|null);
                            }

                            /** Represents a TTelegramCardData. */
                            class TTelegramCardData implements ITTelegramCardData {

                                /**
                                 * Constructs a new TTelegramCardData.
                                 * @param [properties] Properties to set
                                 */
                                constructor(properties?: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.ITTelegramCardData);

                                /** TTelegramCardData UserId. */
                                public UserId: string;

                                /** TTelegramCardData ContactsUploaded. */
                                public ContactsUploaded: boolean;

                                /** TTelegramCardData FavoriteContactData. */
                                public FavoriteContactData: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.ITFavoriteContactData[];

                                /**
                                 * Creates a new TTelegramCardData instance using the specified properties.
                                 * @param [properties] Properties to set
                                 * @returns TTelegramCardData instance
                                 */
                                public static create(properties?: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.ITTelegramCardData): NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.TTelegramCardData;

                                /**
                                 * Encodes the specified TTelegramCardData message. Does not implicitly {@link NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.TTelegramCardData.verify|verify} messages.
                                 * @param message TTelegramCardData message or plain object to encode
                                 * @param [writer] Writer to encode to
                                 * @returns Writer
                                 */
                                public static encode(message: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.ITTelegramCardData, writer?: $protobuf.Writer): $protobuf.Writer;

                                /**
                                 * Encodes the specified TTelegramCardData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.TTelegramCardData.verify|verify} messages.
                                 * @param message TTelegramCardData message or plain object to encode
                                 * @param [writer] Writer to encode to
                                 * @returns Writer
                                 */
                                public static encodeDelimited(message: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.ITTelegramCardData, writer?: $protobuf.Writer): $protobuf.Writer;

                                /**
                                 * Decodes a TTelegramCardData message from the specified reader or buffer.
                                 * @param reader Reader or buffer to decode from
                                 * @param [length] Message length if known beforehand
                                 * @returns TTelegramCardData
                                 * @throws {Error} If the payload is not a reader or valid buffer
                                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                                 */
                                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.TTelegramCardData;

                                /**
                                 * Decodes a TTelegramCardData message from the specified reader or buffer, length delimited.
                                 * @param reader Reader or buffer to decode from
                                 * @returns TTelegramCardData
                                 * @throws {Error} If the payload is not a reader or valid buffer
                                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                                 */
                                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.TTelegramCardData;

                                /**
                                 * Verifies a TTelegramCardData message.
                                 * @param message Plain object to verify
                                 * @returns `null` if valid, otherwise the reason why it is not
                                 */
                                public static verify(message: { [k: string]: any }): (string|null);

                                /**
                                 * Creates a TTelegramCardData message from a plain object. Also converts values to their respective internal types.
                                 * @param object Plain object
                                 * @returns TTelegramCardData
                                 */
                                public static fromObject(object: { [k: string]: any }): NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.TTelegramCardData;

                                /**
                                 * Creates a plain object from a TTelegramCardData message. Also converts values to other types if specified.
                                 * @param message TTelegramCardData
                                 * @param [options] Conversion options
                                 * @returns Plain object
                                 */
                                public static toObject(message: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.TTelegramCardData, options?: $protobuf.IConversionOptions): { [k: string]: any };

                                /**
                                 * Converts this TTelegramCardData to JSON.
                                 * @returns JSON object
                                 */
                                public toJSON(): { [k: string]: any };
                            }

                            /** Properties of a TFavoriteContactData. */
                            interface ITFavoriteContactData {

                                /** TFavoriteContactData DisplayName */
                                DisplayName?: (string|null);

                                /** TFavoriteContactData UserId */
                                UserId?: (string|null);

                                /** TFavoriteContactData LookupKey */
                                LookupKey?: (string|null);
                            }

                            /** Represents a TFavoriteContactData. */
                            class TFavoriteContactData implements ITFavoriteContactData {

                                /**
                                 * Constructs a new TFavoriteContactData.
                                 * @param [properties] Properties to set
                                 */
                                constructor(properties?: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.ITFavoriteContactData);

                                /** TFavoriteContactData DisplayName. */
                                public DisplayName: string;

                                /** TFavoriteContactData UserId. */
                                public UserId: string;

                                /** TFavoriteContactData LookupKey. */
                                public LookupKey: string;

                                /**
                                 * Creates a new TFavoriteContactData instance using the specified properties.
                                 * @param [properties] Properties to set
                                 * @returns TFavoriteContactData instance
                                 */
                                public static create(properties?: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.ITFavoriteContactData): NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.TFavoriteContactData;

                                /**
                                 * Encodes the specified TFavoriteContactData message. Does not implicitly {@link NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.TFavoriteContactData.verify|verify} messages.
                                 * @param message TFavoriteContactData message or plain object to encode
                                 * @param [writer] Writer to encode to
                                 * @returns Writer
                                 */
                                public static encode(message: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.ITFavoriteContactData, writer?: $protobuf.Writer): $protobuf.Writer;

                                /**
                                 * Encodes the specified TFavoriteContactData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.TFavoriteContactData.verify|verify} messages.
                                 * @param message TFavoriteContactData message or plain object to encode
                                 * @param [writer] Writer to encode to
                                 * @returns Writer
                                 */
                                public static encodeDelimited(message: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.ITFavoriteContactData, writer?: $protobuf.Writer): $protobuf.Writer;

                                /**
                                 * Decodes a TFavoriteContactData message from the specified reader or buffer.
                                 * @param reader Reader or buffer to decode from
                                 * @param [length] Message length if known beforehand
                                 * @returns TFavoriteContactData
                                 * @throws {Error} If the payload is not a reader or valid buffer
                                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                                 */
                                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.TFavoriteContactData;

                                /**
                                 * Decodes a TFavoriteContactData message from the specified reader or buffer, length delimited.
                                 * @param reader Reader or buffer to decode from
                                 * @returns TFavoriteContactData
                                 * @throws {Error} If the payload is not a reader or valid buffer
                                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                                 */
                                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.TFavoriteContactData;

                                /**
                                 * Verifies a TFavoriteContactData message.
                                 * @param message Plain object to verify
                                 * @returns `null` if valid, otherwise the reason why it is not
                                 */
                                public static verify(message: { [k: string]: any }): (string|null);

                                /**
                                 * Creates a TFavoriteContactData message from a plain object. Also converts values to their respective internal types.
                                 * @param object Plain object
                                 * @returns TFavoriteContactData
                                 */
                                public static fromObject(object: { [k: string]: any }): NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.TFavoriteContactData;

                                /**
                                 * Creates a plain object from a TFavoriteContactData message. Also converts values to other types if specified.
                                 * @param message TFavoriteContactData
                                 * @param [options] Conversion options
                                 * @returns Plain object
                                 */
                                public static toObject(message: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.TFavoriteContactData, options?: $protobuf.IConversionOptions): { [k: string]: any };

                                /**
                                 * Converts this TFavoriteContactData to JSON.
                                 * @returns JSON object
                                 */
                                public toJSON(): { [k: string]: any };
                            }
                        }
                    }

                    /** Properties of a TExternalSkillCardData. */
                    interface ITExternalSkillCardData {

                        /** TExternalSkillCardData widgetGalleryData */
                        widgetGalleryData?: (NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.ITWidgetGalleryData|null);

                        /** TExternalSkillCardData mainScreenData */
                        mainScreenData?: (NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.ITMainScreenData|null);

                        /** TExternalSkillCardData skillInfo */
                        skillInfo?: (NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.ITSkillInfo|null);
                    }

                    /** Represents a TExternalSkillCardData. */
                    class TExternalSkillCardData implements ITExternalSkillCardData {

                        /**
                         * Constructs a new TExternalSkillCardData.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITExternalSkillCardData);

                        /** TExternalSkillCardData widgetGalleryData. */
                        public widgetGalleryData?: (NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.ITWidgetGalleryData|null);

                        /** TExternalSkillCardData mainScreenData. */
                        public mainScreenData?: (NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.ITMainScreenData|null);

                        /** TExternalSkillCardData skillInfo. */
                        public skillInfo?: (NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.ITSkillInfo|null);

                        /** TExternalSkillCardData SkillCardData. */
                        public SkillCardData?: ("widgetGalleryData"|"mainScreenData");

                        /**
                         * Creates a new TExternalSkillCardData instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns TExternalSkillCardData instance
                         */
                        public static create(properties?: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITExternalSkillCardData): NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData;

                        /**
                         * Encodes the specified TExternalSkillCardData message. Does not implicitly {@link NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.verify|verify} messages.
                         * @param message TExternalSkillCardData message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITExternalSkillCardData, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified TExternalSkillCardData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.verify|verify} messages.
                         * @param message TExternalSkillCardData message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITExternalSkillCardData, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a TExternalSkillCardData message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns TExternalSkillCardData
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData;

                        /**
                         * Decodes a TExternalSkillCardData message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns TExternalSkillCardData
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData;

                        /**
                         * Verifies a TExternalSkillCardData message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a TExternalSkillCardData message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns TExternalSkillCardData
                         */
                        public static fromObject(object: { [k: string]: any }): NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData;

                        /**
                         * Creates a plain object from a TExternalSkillCardData message. Also converts values to other types if specified.
                         * @param message TExternalSkillCardData
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this TExternalSkillCardData to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    namespace TExternalSkillCardData {

                        /** Properties of a TSkillInfo. */
                        interface ITSkillInfo {

                            /** TSkillInfo Name */
                            Name?: (string|null);

                            /** TSkillInfo Logo */
                            Logo?: (string|null);

                            /** TSkillInfo SkillId */
                            SkillId?: (string|null);
                        }

                        /** Represents a TSkillInfo. */
                        class TSkillInfo implements ITSkillInfo {

                            /**
                             * Constructs a new TSkillInfo.
                             * @param [properties] Properties to set
                             */
                            constructor(properties?: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.ITSkillInfo);

                            /** TSkillInfo Name. */
                            public Name: string;

                            /** TSkillInfo Logo. */
                            public Logo: string;

                            /** TSkillInfo SkillId. */
                            public SkillId: string;

                            /**
                             * Creates a new TSkillInfo instance using the specified properties.
                             * @param [properties] Properties to set
                             * @returns TSkillInfo instance
                             */
                            public static create(properties?: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.ITSkillInfo): NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.TSkillInfo;

                            /**
                             * Encodes the specified TSkillInfo message. Does not implicitly {@link NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.TSkillInfo.verify|verify} messages.
                             * @param message TSkillInfo message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encode(message: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.ITSkillInfo, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Encodes the specified TSkillInfo message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.TSkillInfo.verify|verify} messages.
                             * @param message TSkillInfo message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encodeDelimited(message: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.ITSkillInfo, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Decodes a TSkillInfo message from the specified reader or buffer.
                             * @param reader Reader or buffer to decode from
                             * @param [length] Message length if known beforehand
                             * @returns TSkillInfo
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.TSkillInfo;

                            /**
                             * Decodes a TSkillInfo message from the specified reader or buffer, length delimited.
                             * @param reader Reader or buffer to decode from
                             * @returns TSkillInfo
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.TSkillInfo;

                            /**
                             * Verifies a TSkillInfo message.
                             * @param message Plain object to verify
                             * @returns `null` if valid, otherwise the reason why it is not
                             */
                            public static verify(message: { [k: string]: any }): (string|null);

                            /**
                             * Creates a TSkillInfo message from a plain object. Also converts values to their respective internal types.
                             * @param object Plain object
                             * @returns TSkillInfo
                             */
                            public static fromObject(object: { [k: string]: any }): NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.TSkillInfo;

                            /**
                             * Creates a plain object from a TSkillInfo message. Also converts values to other types if specified.
                             * @param message TSkillInfo
                             * @param [options] Conversion options
                             * @returns Plain object
                             */
                            public static toObject(message: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.TSkillInfo, options?: $protobuf.IConversionOptions): { [k: string]: any };

                            /**
                             * Converts this TSkillInfo to JSON.
                             * @returns JSON object
                             */
                            public toJSON(): { [k: string]: any };
                        }

                        /** Properties of a TWidgetGalleryData. */
                        interface ITWidgetGalleryData {
                        }

                        /** Represents a TWidgetGalleryData. */
                        class TWidgetGalleryData implements ITWidgetGalleryData {

                            /**
                             * Constructs a new TWidgetGalleryData.
                             * @param [properties] Properties to set
                             */
                            constructor(properties?: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.ITWidgetGalleryData);

                            /**
                             * Creates a new TWidgetGalleryData instance using the specified properties.
                             * @param [properties] Properties to set
                             * @returns TWidgetGalleryData instance
                             */
                            public static create(properties?: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.ITWidgetGalleryData): NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.TWidgetGalleryData;

                            /**
                             * Encodes the specified TWidgetGalleryData message. Does not implicitly {@link NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.TWidgetGalleryData.verify|verify} messages.
                             * @param message TWidgetGalleryData message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encode(message: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.ITWidgetGalleryData, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Encodes the specified TWidgetGalleryData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.TWidgetGalleryData.verify|verify} messages.
                             * @param message TWidgetGalleryData message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encodeDelimited(message: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.ITWidgetGalleryData, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Decodes a TWidgetGalleryData message from the specified reader or buffer.
                             * @param reader Reader or buffer to decode from
                             * @param [length] Message length if known beforehand
                             * @returns TWidgetGalleryData
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.TWidgetGalleryData;

                            /**
                             * Decodes a TWidgetGalleryData message from the specified reader or buffer, length delimited.
                             * @param reader Reader or buffer to decode from
                             * @returns TWidgetGalleryData
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.TWidgetGalleryData;

                            /**
                             * Verifies a TWidgetGalleryData message.
                             * @param message Plain object to verify
                             * @returns `null` if valid, otherwise the reason why it is not
                             */
                            public static verify(message: { [k: string]: any }): (string|null);

                            /**
                             * Creates a TWidgetGalleryData message from a plain object. Also converts values to their respective internal types.
                             * @param object Plain object
                             * @returns TWidgetGalleryData
                             */
                            public static fromObject(object: { [k: string]: any }): NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.TWidgetGalleryData;

                            /**
                             * Creates a plain object from a TWidgetGalleryData message. Also converts values to other types if specified.
                             * @param message TWidgetGalleryData
                             * @param [options] Conversion options
                             * @returns Plain object
                             */
                            public static toObject(message: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.TWidgetGalleryData, options?: $protobuf.IConversionOptions): { [k: string]: any };

                            /**
                             * Converts this TWidgetGalleryData to JSON.
                             * @returns JSON object
                             */
                            public toJSON(): { [k: string]: any };
                        }

                        /** Properties of a TMainScreenData. */
                        interface ITMainScreenData {

                            /** TMainScreenData Title */
                            Title?: (string|null);

                            /** TMainScreenData Text */
                            Text?: (string|null);

                            /** TMainScreenData ImageUrl */
                            ImageUrl?: (string|null);

                            /** TMainScreenData buttons */
                            buttons?: (NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.TMainScreenData.ITButton[]|null);
                        }

                        /** Represents a TMainScreenData. */
                        class TMainScreenData implements ITMainScreenData {

                            /**
                             * Constructs a new TMainScreenData.
                             * @param [properties] Properties to set
                             */
                            constructor(properties?: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.ITMainScreenData);

                            /** TMainScreenData Title. */
                            public Title: string;

                            /** TMainScreenData Text. */
                            public Text: string;

                            /** TMainScreenData ImageUrl. */
                            public ImageUrl: string;

                            /** TMainScreenData buttons. */
                            public buttons: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.TMainScreenData.ITButton[];

                            /**
                             * Creates a new TMainScreenData instance using the specified properties.
                             * @param [properties] Properties to set
                             * @returns TMainScreenData instance
                             */
                            public static create(properties?: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.ITMainScreenData): NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.TMainScreenData;

                            /**
                             * Encodes the specified TMainScreenData message. Does not implicitly {@link NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.TMainScreenData.verify|verify} messages.
                             * @param message TMainScreenData message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encode(message: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.ITMainScreenData, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Encodes the specified TMainScreenData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.TMainScreenData.verify|verify} messages.
                             * @param message TMainScreenData message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encodeDelimited(message: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.ITMainScreenData, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Decodes a TMainScreenData message from the specified reader or buffer.
                             * @param reader Reader or buffer to decode from
                             * @param [length] Message length if known beforehand
                             * @returns TMainScreenData
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.TMainScreenData;

                            /**
                             * Decodes a TMainScreenData message from the specified reader or buffer, length delimited.
                             * @param reader Reader or buffer to decode from
                             * @returns TMainScreenData
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.TMainScreenData;

                            /**
                             * Verifies a TMainScreenData message.
                             * @param message Plain object to verify
                             * @returns `null` if valid, otherwise the reason why it is not
                             */
                            public static verify(message: { [k: string]: any }): (string|null);

                            /**
                             * Creates a TMainScreenData message from a plain object. Also converts values to their respective internal types.
                             * @param object Plain object
                             * @returns TMainScreenData
                             */
                            public static fromObject(object: { [k: string]: any }): NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.TMainScreenData;

                            /**
                             * Creates a plain object from a TMainScreenData message. Also converts values to other types if specified.
                             * @param message TMainScreenData
                             * @param [options] Conversion options
                             * @returns Plain object
                             */
                            public static toObject(message: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.TMainScreenData, options?: $protobuf.IConversionOptions): { [k: string]: any };

                            /**
                             * Converts this TMainScreenData to JSON.
                             * @returns JSON object
                             */
                            public toJSON(): { [k: string]: any };
                        }

                        namespace TMainScreenData {

                            /** Properties of a TButton. */
                            interface ITButton {

                                /** TButton Text */
                                Text?: (string|null);

                                /** TButton Url */
                                Url?: (string|null);

                                /** TButton Payload */
                                Payload?: (string|null);
                            }

                            /** Represents a TButton. */
                            class TButton implements ITButton {

                                /**
                                 * Constructs a new TButton.
                                 * @param [properties] Properties to set
                                 */
                                constructor(properties?: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.TMainScreenData.ITButton);

                                /** TButton Text. */
                                public Text: string;

                                /** TButton Url. */
                                public Url: string;

                                /** TButton Payload. */
                                public Payload: string;

                                /**
                                 * Creates a new TButton instance using the specified properties.
                                 * @param [properties] Properties to set
                                 * @returns TButton instance
                                 */
                                public static create(properties?: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.TMainScreenData.ITButton): NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.TMainScreenData.TButton;

                                /**
                                 * Encodes the specified TButton message. Does not implicitly {@link NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.TMainScreenData.TButton.verify|verify} messages.
                                 * @param message TButton message or plain object to encode
                                 * @param [writer] Writer to encode to
                                 * @returns Writer
                                 */
                                public static encode(message: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.TMainScreenData.ITButton, writer?: $protobuf.Writer): $protobuf.Writer;

                                /**
                                 * Encodes the specified TButton message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.TMainScreenData.TButton.verify|verify} messages.
                                 * @param message TButton message or plain object to encode
                                 * @param [writer] Writer to encode to
                                 * @returns Writer
                                 */
                                public static encodeDelimited(message: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.TMainScreenData.ITButton, writer?: $protobuf.Writer): $protobuf.Writer;

                                /**
                                 * Decodes a TButton message from the specified reader or buffer.
                                 * @param reader Reader or buffer to decode from
                                 * @param [length] Message length if known beforehand
                                 * @returns TButton
                                 * @throws {Error} If the payload is not a reader or valid buffer
                                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                                 */
                                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.TMainScreenData.TButton;

                                /**
                                 * Decodes a TButton message from the specified reader or buffer, length delimited.
                                 * @param reader Reader or buffer to decode from
                                 * @returns TButton
                                 * @throws {Error} If the payload is not a reader or valid buffer
                                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                                 */
                                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.TMainScreenData.TButton;

                                /**
                                 * Verifies a TButton message.
                                 * @param message Plain object to verify
                                 * @returns `null` if valid, otherwise the reason why it is not
                                 */
                                public static verify(message: { [k: string]: any }): (string|null);

                                /**
                                 * Creates a TButton message from a plain object. Also converts values to their respective internal types.
                                 * @param object Plain object
                                 * @returns TButton
                                 */
                                public static fromObject(object: { [k: string]: any }): NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.TMainScreenData.TButton;

                                /**
                                 * Creates a plain object from a TButton message. Also converts values to other types if specified.
                                 * @param message TButton
                                 * @param [options] Conversion options
                                 * @returns Plain object
                                 */
                                public static toObject(message: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.TMainScreenData.TButton, options?: $protobuf.IConversionOptions): { [k: string]: any };

                                /**
                                 * Converts this TButton to JSON.
                                 * @returns JSON object
                                 */
                                public toJSON(): { [k: string]: any };
                            }
                        }
                    }
                }
            }
        }

        /** Properties of a TCentaurWidgetGalleryData. */
        interface ITCentaurWidgetGalleryData {

            /** TCentaurWidgetGalleryData Id */
            Id?: (string|null);

            /** TCentaurWidgetGalleryData Widgets */
            Widgets?: (NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.ITCardData[]|null);

            /** TCentaurWidgetGalleryData WidgetCards */
            WidgetCards?: (NAlice.NData.ITCentaurWidgetCardData[]|null);

            /** TCentaurWidgetGalleryData WidgetCardItems */
            WidgetCardItems?: (NAlice.NData.ITCentaurWidgetCardItem[]|null);
        }

        /** Represents a TCentaurWidgetGalleryData. */
        class TCentaurWidgetGalleryData implements ITCentaurWidgetGalleryData {

            /**
             * Constructs a new TCentaurWidgetGalleryData.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITCentaurWidgetGalleryData);

            /** TCentaurWidgetGalleryData Id. */
            public Id: string;

            /** TCentaurWidgetGalleryData Widgets. */
            public Widgets: NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.ITCardData[];

            /** TCentaurWidgetGalleryData WidgetCards. */
            public WidgetCards: NAlice.NData.ITCentaurWidgetCardData[];

            /** TCentaurWidgetGalleryData WidgetCardItems. */
            public WidgetCardItems: NAlice.NData.ITCentaurWidgetCardItem[];

            /**
             * Creates a new TCentaurWidgetGalleryData instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TCentaurWidgetGalleryData instance
             */
            public static create(properties?: NAlice.NData.ITCentaurWidgetGalleryData): NAlice.NData.TCentaurWidgetGalleryData;

            /**
             * Encodes the specified TCentaurWidgetGalleryData message. Does not implicitly {@link NAlice.NData.TCentaurWidgetGalleryData.verify|verify} messages.
             * @param message TCentaurWidgetGalleryData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITCentaurWidgetGalleryData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TCentaurWidgetGalleryData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurWidgetGalleryData.verify|verify} messages.
             * @param message TCentaurWidgetGalleryData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITCentaurWidgetGalleryData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TCentaurWidgetGalleryData message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TCentaurWidgetGalleryData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TCentaurWidgetGalleryData;

            /**
             * Decodes a TCentaurWidgetGalleryData message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TCentaurWidgetGalleryData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TCentaurWidgetGalleryData;

            /**
             * Verifies a TCentaurWidgetGalleryData message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TCentaurWidgetGalleryData message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TCentaurWidgetGalleryData
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TCentaurWidgetGalleryData;

            /**
             * Creates a plain object from a TCentaurWidgetGalleryData message. Also converts values to other types if specified.
             * @param message TCentaurWidgetGalleryData
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TCentaurWidgetGalleryData, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TCentaurWidgetGalleryData to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a TWeatherCondition. */
        interface ITWeatherCondition {

            /** TWeatherCondition Title */
            Title?: (string|null);

            /** TWeatherCondition FeelsLike */
            FeelsLike?: (number|null);

            /** TWeatherCondition Cloudness */
            Cloudness?: (number|null);

            /** TWeatherCondition PrecStrength */
            PrecStrength?: (number|null);

            /** TWeatherCondition PrecType */
            PrecType?: (number|null);
        }

        /** Represents a TWeatherCondition. */
        class TWeatherCondition implements ITWeatherCondition {

            /**
             * Constructs a new TWeatherCondition.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITWeatherCondition);

            /** TWeatherCondition Title. */
            public Title: string;

            /** TWeatherCondition FeelsLike. */
            public FeelsLike: number;

            /** TWeatherCondition Cloudness. */
            public Cloudness: number;

            /** TWeatherCondition PrecStrength. */
            public PrecStrength: number;

            /** TWeatherCondition PrecType. */
            public PrecType: number;

            /**
             * Creates a new TWeatherCondition instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TWeatherCondition instance
             */
            public static create(properties?: NAlice.NData.ITWeatherCondition): NAlice.NData.TWeatherCondition;

            /**
             * Encodes the specified TWeatherCondition message. Does not implicitly {@link NAlice.NData.TWeatherCondition.verify|verify} messages.
             * @param message TWeatherCondition message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITWeatherCondition, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TWeatherCondition message, length delimited. Does not implicitly {@link NAlice.NData.TWeatherCondition.verify|verify} messages.
             * @param message TWeatherCondition message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITWeatherCondition, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TWeatherCondition message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TWeatherCondition
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TWeatherCondition;

            /**
             * Decodes a TWeatherCondition message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TWeatherCondition
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TWeatherCondition;

            /**
             * Verifies a TWeatherCondition message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TWeatherCondition message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TWeatherCondition
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TWeatherCondition;

            /**
             * Creates a plain object from a TWeatherCondition message. Also converts values to other types if specified.
             * @param message TWeatherCondition
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TWeatherCondition, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TWeatherCondition to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a TWeatherLocation. */
        interface ITWeatherLocation {

            /** TWeatherLocation City */
            City?: (string|null);

            /** TWeatherLocation CityPrepcase */
            CityPrepcase?: (string|null);
        }

        /** Represents a TWeatherLocation. */
        class TWeatherLocation implements ITWeatherLocation {

            /**
             * Constructs a new TWeatherLocation.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITWeatherLocation);

            /** TWeatherLocation City. */
            public City: string;

            /** TWeatherLocation CityPrepcase. */
            public CityPrepcase: string;

            /**
             * Creates a new TWeatherLocation instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TWeatherLocation instance
             */
            public static create(properties?: NAlice.NData.ITWeatherLocation): NAlice.NData.TWeatherLocation;

            /**
             * Encodes the specified TWeatherLocation message. Does not implicitly {@link NAlice.NData.TWeatherLocation.verify|verify} messages.
             * @param message TWeatherLocation message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITWeatherLocation, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TWeatherLocation message, length delimited. Does not implicitly {@link NAlice.NData.TWeatherLocation.verify|verify} messages.
             * @param message TWeatherLocation message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITWeatherLocation, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TWeatherLocation message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TWeatherLocation
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TWeatherLocation;

            /**
             * Decodes a TWeatherLocation message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TWeatherLocation
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TWeatherLocation;

            /**
             * Verifies a TWeatherLocation message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TWeatherLocation message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TWeatherLocation
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TWeatherLocation;

            /**
             * Creates a plain object from a TWeatherLocation message. Also converts values to other types if specified.
             * @param message TWeatherLocation
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TWeatherLocation, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TWeatherLocation to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a TDaylightHours. */
        interface ITDaylightHours {

            /** TDaylightHours Sunrise */
            Sunrise?: (string|null);

            /** TDaylightHours Sunset */
            Sunset?: (string|null);
        }

        /** Represents a TDaylightHours. */
        class TDaylightHours implements ITDaylightHours {

            /**
             * Constructs a new TDaylightHours.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITDaylightHours);

            /** TDaylightHours Sunrise. */
            public Sunrise: string;

            /** TDaylightHours Sunset. */
            public Sunset: string;

            /**
             * Creates a new TDaylightHours instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TDaylightHours instance
             */
            public static create(properties?: NAlice.NData.ITDaylightHours): NAlice.NData.TDaylightHours;

            /**
             * Encodes the specified TDaylightHours message. Does not implicitly {@link NAlice.NData.TDaylightHours.verify|verify} messages.
             * @param message TDaylightHours message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITDaylightHours, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TDaylightHours message, length delimited. Does not implicitly {@link NAlice.NData.TDaylightHours.verify|verify} messages.
             * @param message TDaylightHours message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITDaylightHours, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TDaylightHours message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TDaylightHours
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TDaylightHours;

            /**
             * Decodes a TDaylightHours message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TDaylightHours
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TDaylightHours;

            /**
             * Verifies a TDaylightHours message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TDaylightHours message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TDaylightHours
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TDaylightHours;

            /**
             * Creates a plain object from a TDaylightHours message. Also converts values to other types if specified.
             * @param message TDaylightHours
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TDaylightHours, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TDaylightHours to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a TWeatherTeaserData. */
        interface ITWeatherTeaserData {

            /** TWeatherTeaserData HourItems */
            HourItems?: (NAlice.NData.ITWeatherHourItem[]|null);

            /** TWeatherTeaserData Date */
            Date?: (string|null);

            /** TWeatherTeaserData GeoLocation */
            GeoLocation?: (NAlice.NData.ITWeatherLocation|null);

            /** TWeatherTeaserData Tz */
            Tz?: (string|null);

            /** TWeatherTeaserData UserTime */
            UserTime?: (string|null);

            /** TWeatherTeaserData Sunrise */
            Sunrise?: (string|null);

            /** TWeatherTeaserData Sunset */
            Sunset?: (string|null);

            /** TWeatherTeaserData Temperature */
            Temperature?: (number|null);

            /** TWeatherTeaserData Icon */
            Icon?: (string|null);

            /** TWeatherTeaserData Condition */
            Condition?: (NAlice.NData.ITWeatherCondition|null);

            /** TWeatherTeaserData IconType */
            IconType?: (string|null);

            /** TWeatherTeaserData UserDate */
            UserDate?: (string|null);
        }

        /** Represents a TWeatherTeaserData. */
        class TWeatherTeaserData implements ITWeatherTeaserData {

            /**
             * Constructs a new TWeatherTeaserData.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITWeatherTeaserData);

            /** TWeatherTeaserData HourItems. */
            public HourItems: NAlice.NData.ITWeatherHourItem[];

            /** TWeatherTeaserData Date. */
            public Date: string;

            /** TWeatherTeaserData GeoLocation. */
            public GeoLocation?: (NAlice.NData.ITWeatherLocation|null);

            /** TWeatherTeaserData Tz. */
            public Tz: string;

            /** TWeatherTeaserData UserTime. */
            public UserTime: string;

            /** TWeatherTeaserData Sunrise. */
            public Sunrise: string;

            /** TWeatherTeaserData Sunset. */
            public Sunset: string;

            /** TWeatherTeaserData Temperature. */
            public Temperature: number;

            /** TWeatherTeaserData Icon. */
            public Icon: string;

            /** TWeatherTeaserData Condition. */
            public Condition?: (NAlice.NData.ITWeatherCondition|null);

            /** TWeatherTeaserData IconType. */
            public IconType: string;

            /** TWeatherTeaserData UserDate. */
            public UserDate: string;

            /**
             * Creates a new TWeatherTeaserData instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TWeatherTeaserData instance
             */
            public static create(properties?: NAlice.NData.ITWeatherTeaserData): NAlice.NData.TWeatherTeaserData;

            /**
             * Encodes the specified TWeatherTeaserData message. Does not implicitly {@link NAlice.NData.TWeatherTeaserData.verify|verify} messages.
             * @param message TWeatherTeaserData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITWeatherTeaserData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TWeatherTeaserData message, length delimited. Does not implicitly {@link NAlice.NData.TWeatherTeaserData.verify|verify} messages.
             * @param message TWeatherTeaserData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITWeatherTeaserData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TWeatherTeaserData message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TWeatherTeaserData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TWeatherTeaserData;

            /**
             * Decodes a TWeatherTeaserData message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TWeatherTeaserData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TWeatherTeaserData;

            /**
             * Verifies a TWeatherTeaserData message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TWeatherTeaserData message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TWeatherTeaserData
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TWeatherTeaserData;

            /**
             * Creates a plain object from a TWeatherTeaserData message. Also converts values to other types if specified.
             * @param message TWeatherTeaserData
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TWeatherTeaserData, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TWeatherTeaserData to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a TWeatherMainScreenData. */
        interface ITWeatherMainScreenData {

            /** TWeatherMainScreenData Date */
            Date?: (string|null);

            /** TWeatherMainScreenData GeoLocation */
            GeoLocation?: (NAlice.NData.ITWeatherLocation|null);

            /** TWeatherMainScreenData Tz */
            Tz?: (string|null);

            /** TWeatherMainScreenData UserTime */
            UserTime?: (string|null);

            /** TWeatherMainScreenData Sunrise */
            Sunrise?: (string|null);

            /** TWeatherMainScreenData Sunset */
            Sunset?: (string|null);

            /** TWeatherMainScreenData Temperature */
            Temperature?: (number|null);

            /** TWeatherMainScreenData Icon */
            Icon?: (string|null);

            /** TWeatherMainScreenData Condition */
            Condition?: (NAlice.NData.ITWeatherCondition|null);

            /** TWeatherMainScreenData IconType */
            IconType?: (string|null);

            /** TWeatherMainScreenData UserDate */
            UserDate?: (string|null);
        }

        /** Represents a TWeatherMainScreenData. */
        class TWeatherMainScreenData implements ITWeatherMainScreenData {

            /**
             * Constructs a new TWeatherMainScreenData.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITWeatherMainScreenData);

            /** TWeatherMainScreenData Date. */
            public Date: string;

            /** TWeatherMainScreenData GeoLocation. */
            public GeoLocation?: (NAlice.NData.ITWeatherLocation|null);

            /** TWeatherMainScreenData Tz. */
            public Tz: string;

            /** TWeatherMainScreenData UserTime. */
            public UserTime: string;

            /** TWeatherMainScreenData Sunrise. */
            public Sunrise: string;

            /** TWeatherMainScreenData Sunset. */
            public Sunset: string;

            /** TWeatherMainScreenData Temperature. */
            public Temperature: number;

            /** TWeatherMainScreenData Icon. */
            public Icon: string;

            /** TWeatherMainScreenData Condition. */
            public Condition?: (NAlice.NData.ITWeatherCondition|null);

            /** TWeatherMainScreenData IconType. */
            public IconType: string;

            /** TWeatherMainScreenData UserDate. */
            public UserDate: string;

            /**
             * Creates a new TWeatherMainScreenData instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TWeatherMainScreenData instance
             */
            public static create(properties?: NAlice.NData.ITWeatherMainScreenData): NAlice.NData.TWeatherMainScreenData;

            /**
             * Encodes the specified TWeatherMainScreenData message. Does not implicitly {@link NAlice.NData.TWeatherMainScreenData.verify|verify} messages.
             * @param message TWeatherMainScreenData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITWeatherMainScreenData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TWeatherMainScreenData message, length delimited. Does not implicitly {@link NAlice.NData.TWeatherMainScreenData.verify|verify} messages.
             * @param message TWeatherMainScreenData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITWeatherMainScreenData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TWeatherMainScreenData message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TWeatherMainScreenData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TWeatherMainScreenData;

            /**
             * Decodes a TWeatherMainScreenData message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TWeatherMainScreenData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TWeatherMainScreenData;

            /**
             * Verifies a TWeatherMainScreenData message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TWeatherMainScreenData message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TWeatherMainScreenData
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TWeatherMainScreenData;

            /**
             * Creates a plain object from a TWeatherMainScreenData message. Also converts values to other types if specified.
             * @param message TWeatherMainScreenData
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TWeatherMainScreenData, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TWeatherMainScreenData to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a TWeatherHourItem. */
        interface ITWeatherHourItem {

            /** TWeatherHourItem Hour */
            Hour?: (number|null);

            /** TWeatherHourItem Timestamp */
            Timestamp?: (number|Long|null);

            /** TWeatherHourItem Temperature */
            Temperature?: (number|null);

            /** TWeatherHourItem Icon */
            Icon?: (string|null);

            /** TWeatherHourItem IconType */
            IconType?: (string|null);

            /** TWeatherHourItem PrecStrength */
            PrecStrength?: (number|null);

            /** TWeatherHourItem PrecType */
            PrecType?: (number|null);
        }

        /** Represents a TWeatherHourItem. */
        class TWeatherHourItem implements ITWeatherHourItem {

            /**
             * Constructs a new TWeatherHourItem.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITWeatherHourItem);

            /** TWeatherHourItem Hour. */
            public Hour: number;

            /** TWeatherHourItem Timestamp. */
            public Timestamp: (number|Long);

            /** TWeatherHourItem Temperature. */
            public Temperature: number;

            /** TWeatherHourItem Icon. */
            public Icon: string;

            /** TWeatherHourItem IconType. */
            public IconType: string;

            /** TWeatherHourItem PrecStrength. */
            public PrecStrength: number;

            /** TWeatherHourItem PrecType. */
            public PrecType: number;

            /**
             * Creates a new TWeatherHourItem instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TWeatherHourItem instance
             */
            public static create(properties?: NAlice.NData.ITWeatherHourItem): NAlice.NData.TWeatherHourItem;

            /**
             * Encodes the specified TWeatherHourItem message. Does not implicitly {@link NAlice.NData.TWeatherHourItem.verify|verify} messages.
             * @param message TWeatherHourItem message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITWeatherHourItem, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TWeatherHourItem message, length delimited. Does not implicitly {@link NAlice.NData.TWeatherHourItem.verify|verify} messages.
             * @param message TWeatherHourItem message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITWeatherHourItem, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TWeatherHourItem message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TWeatherHourItem
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TWeatherHourItem;

            /**
             * Decodes a TWeatherHourItem message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TWeatherHourItem
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TWeatherHourItem;

            /**
             * Verifies a TWeatherHourItem message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TWeatherHourItem message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TWeatherHourItem
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TWeatherHourItem;

            /**
             * Creates a plain object from a TWeatherHourItem message. Also converts values to other types if specified.
             * @param message TWeatherHourItem
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TWeatherHourItem, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TWeatherHourItem to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a TWeatherDayHoursData. */
        interface ITWeatherDayHoursData {

            /** TWeatherDayHoursData HourItems */
            HourItems?: (NAlice.NData.ITWeatherHourItem[]|null);

            /** TWeatherDayHoursData Date */
            Date?: (string|null);

            /** TWeatherDayHoursData GeoLocation */
            GeoLocation?: (NAlice.NData.ITWeatherLocation|null);

            /** TWeatherDayHoursData DayPartType */
            DayPartType?: (string|null);

            /** TWeatherDayHoursData Tz */
            Tz?: (string|null);

            /** TWeatherDayHoursData UserTime */
            UserTime?: (string|null);

            /** TWeatherDayHoursData Sunrise */
            Sunrise?: (string|null);

            /** TWeatherDayHoursData Sunset */
            Sunset?: (string|null);

            /** TWeatherDayHoursData Temperature */
            Temperature?: (number|null);

            /** TWeatherDayHoursData Icon */
            Icon?: (string|null);

            /** TWeatherDayHoursData Condition */
            Condition?: (NAlice.NData.ITWeatherCondition|null);

            /** TWeatherDayHoursData TodayDaylight */
            TodayDaylight?: (NAlice.NData.ITDaylightHours|null);

            /** TWeatherDayHoursData IconType */
            IconType?: (string|null);

            /** TWeatherDayHoursData UserDate */
            UserDate?: (string|null);
        }

        /** Represents a TWeatherDayHoursData. */
        class TWeatherDayHoursData implements ITWeatherDayHoursData {

            /**
             * Constructs a new TWeatherDayHoursData.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITWeatherDayHoursData);

            /** TWeatherDayHoursData HourItems. */
            public HourItems: NAlice.NData.ITWeatherHourItem[];

            /** TWeatherDayHoursData Date. */
            public Date: string;

            /** TWeatherDayHoursData GeoLocation. */
            public GeoLocation?: (NAlice.NData.ITWeatherLocation|null);

            /** TWeatherDayHoursData DayPartType. */
            public DayPartType: string;

            /** TWeatherDayHoursData Tz. */
            public Tz: string;

            /** TWeatherDayHoursData UserTime. */
            public UserTime: string;

            /** TWeatherDayHoursData Sunrise. */
            public Sunrise: string;

            /** TWeatherDayHoursData Sunset. */
            public Sunset: string;

            /** TWeatherDayHoursData Temperature. */
            public Temperature: number;

            /** TWeatherDayHoursData Icon. */
            public Icon: string;

            /** TWeatherDayHoursData Condition. */
            public Condition?: (NAlice.NData.ITWeatherCondition|null);

            /** TWeatherDayHoursData TodayDaylight. */
            public TodayDaylight?: (NAlice.NData.ITDaylightHours|null);

            /** TWeatherDayHoursData IconType. */
            public IconType: string;

            /** TWeatherDayHoursData UserDate. */
            public UserDate: string;

            /**
             * Creates a new TWeatherDayHoursData instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TWeatherDayHoursData instance
             */
            public static create(properties?: NAlice.NData.ITWeatherDayHoursData): NAlice.NData.TWeatherDayHoursData;

            /**
             * Encodes the specified TWeatherDayHoursData message. Does not implicitly {@link NAlice.NData.TWeatherDayHoursData.verify|verify} messages.
             * @param message TWeatherDayHoursData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITWeatherDayHoursData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TWeatherDayHoursData message, length delimited. Does not implicitly {@link NAlice.NData.TWeatherDayHoursData.verify|verify} messages.
             * @param message TWeatherDayHoursData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITWeatherDayHoursData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TWeatherDayHoursData message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TWeatherDayHoursData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TWeatherDayHoursData;

            /**
             * Decodes a TWeatherDayHoursData message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TWeatherDayHoursData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TWeatherDayHoursData;

            /**
             * Verifies a TWeatherDayHoursData message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TWeatherDayHoursData message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TWeatherDayHoursData
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TWeatherDayHoursData;

            /**
             * Creates a plain object from a TWeatherDayHoursData message. Also converts values to other types if specified.
             * @param message TWeatherDayHoursData
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TWeatherDayHoursData, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TWeatherDayHoursData to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a TWeatherDayPartData. */
        interface ITWeatherDayPartData {

            /** TWeatherDayPartData Date */
            Date?: (string|null);

            /** TWeatherDayPartData GeoLocation */
            GeoLocation?: (NAlice.NData.ITWeatherLocation|null);

            /** TWeatherDayPartData DayPartType */
            DayPartType?: (string|null);

            /** TWeatherDayPartData Tz */
            Tz?: (string|null);

            /** TWeatherDayPartData UserTime */
            UserTime?: (string|null);

            /** TWeatherDayPartData Sunrise */
            Sunrise?: (string|null);

            /** TWeatherDayPartData Sunset */
            Sunset?: (string|null);

            /** TWeatherDayPartData Temperature */
            Temperature?: (number|null);

            /** TWeatherDayPartData Icon */
            Icon?: (string|null);

            /** TWeatherDayPartData Condition */
            Condition?: (NAlice.NData.ITWeatherCondition|null);

            /** TWeatherDayPartData TodayDaylight */
            TodayDaylight?: (NAlice.NData.ITDaylightHours|null);

            /** TWeatherDayPartData IconType */
            IconType?: (string|null);

            /** TWeatherDayPartData UserDate */
            UserDate?: (string|null);
        }

        /** Represents a TWeatherDayPartData. */
        class TWeatherDayPartData implements ITWeatherDayPartData {

            /**
             * Constructs a new TWeatherDayPartData.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITWeatherDayPartData);

            /** TWeatherDayPartData Date. */
            public Date: string;

            /** TWeatherDayPartData GeoLocation. */
            public GeoLocation?: (NAlice.NData.ITWeatherLocation|null);

            /** TWeatherDayPartData DayPartType. */
            public DayPartType: string;

            /** TWeatherDayPartData Tz. */
            public Tz: string;

            /** TWeatherDayPartData UserTime. */
            public UserTime: string;

            /** TWeatherDayPartData Sunrise. */
            public Sunrise: string;

            /** TWeatherDayPartData Sunset. */
            public Sunset: string;

            /** TWeatherDayPartData Temperature. */
            public Temperature: number;

            /** TWeatherDayPartData Icon. */
            public Icon: string;

            /** TWeatherDayPartData Condition. */
            public Condition?: (NAlice.NData.ITWeatherCondition|null);

            /** TWeatherDayPartData TodayDaylight. */
            public TodayDaylight?: (NAlice.NData.ITDaylightHours|null);

            /** TWeatherDayPartData IconType. */
            public IconType: string;

            /** TWeatherDayPartData UserDate. */
            public UserDate: string;

            /**
             * Creates a new TWeatherDayPartData instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TWeatherDayPartData instance
             */
            public static create(properties?: NAlice.NData.ITWeatherDayPartData): NAlice.NData.TWeatherDayPartData;

            /**
             * Encodes the specified TWeatherDayPartData message. Does not implicitly {@link NAlice.NData.TWeatherDayPartData.verify|verify} messages.
             * @param message TWeatherDayPartData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITWeatherDayPartData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TWeatherDayPartData message, length delimited. Does not implicitly {@link NAlice.NData.TWeatherDayPartData.verify|verify} messages.
             * @param message TWeatherDayPartData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITWeatherDayPartData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TWeatherDayPartData message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TWeatherDayPartData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TWeatherDayPartData;

            /**
             * Decodes a TWeatherDayPartData message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TWeatherDayPartData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TWeatherDayPartData;

            /**
             * Verifies a TWeatherDayPartData message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TWeatherDayPartData message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TWeatherDayPartData
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TWeatherDayPartData;

            /**
             * Creates a plain object from a TWeatherDayPartData message. Also converts values to other types if specified.
             * @param message TWeatherDayPartData
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TWeatherDayPartData, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TWeatherDayPartData to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a TWeatherDayPartItem. */
        interface ITWeatherDayPartItem {

            /** TWeatherDayPartItem DayPartType */
            DayPartType?: (string|null);

            /** TWeatherDayPartItem Temperature */
            Temperature?: (number|null);

            /** TWeatherDayPartItem Icon */
            Icon?: (string|null);

            /** TWeatherDayPartItem Condition */
            Condition?: (NAlice.NData.ITWeatherCondition|null);

            /** TWeatherDayPartItem IconType */
            IconType?: (string|null);
        }

        /** Represents a TWeatherDayPartItem. */
        class TWeatherDayPartItem implements ITWeatherDayPartItem {

            /**
             * Constructs a new TWeatherDayPartItem.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITWeatherDayPartItem);

            /** TWeatherDayPartItem DayPartType. */
            public DayPartType: string;

            /** TWeatherDayPartItem Temperature. */
            public Temperature: number;

            /** TWeatherDayPartItem Icon. */
            public Icon: string;

            /** TWeatherDayPartItem Condition. */
            public Condition?: (NAlice.NData.ITWeatherCondition|null);

            /** TWeatherDayPartItem IconType. */
            public IconType: string;

            /**
             * Creates a new TWeatherDayPartItem instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TWeatherDayPartItem instance
             */
            public static create(properties?: NAlice.NData.ITWeatherDayPartItem): NAlice.NData.TWeatherDayPartItem;

            /**
             * Encodes the specified TWeatherDayPartItem message. Does not implicitly {@link NAlice.NData.TWeatherDayPartItem.verify|verify} messages.
             * @param message TWeatherDayPartItem message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITWeatherDayPartItem, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TWeatherDayPartItem message, length delimited. Does not implicitly {@link NAlice.NData.TWeatherDayPartItem.verify|verify} messages.
             * @param message TWeatherDayPartItem message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITWeatherDayPartItem, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TWeatherDayPartItem message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TWeatherDayPartItem
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TWeatherDayPartItem;

            /**
             * Decodes a TWeatherDayPartItem message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TWeatherDayPartItem
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TWeatherDayPartItem;

            /**
             * Verifies a TWeatherDayPartItem message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TWeatherDayPartItem message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TWeatherDayPartItem
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TWeatherDayPartItem;

            /**
             * Creates a plain object from a TWeatherDayPartItem message. Also converts values to other types if specified.
             * @param message TWeatherDayPartItem
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TWeatherDayPartItem, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TWeatherDayPartItem to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a TWeatherDayData. */
        interface ITWeatherDayData {

            /** TWeatherDayData DayPartItems */
            DayPartItems?: (NAlice.NData.ITWeatherDayPartItem[]|null);

            /** TWeatherDayData Date */
            Date?: (string|null);

            /** TWeatherDayData GeoLocation */
            GeoLocation?: (NAlice.NData.ITWeatherLocation|null);

            /** TWeatherDayData Tz */
            Tz?: (string|null);

            /** TWeatherDayData UserTime */
            UserTime?: (string|null);

            /** TWeatherDayData Sunrise */
            Sunrise?: (string|null);

            /** TWeatherDayData Sunset */
            Sunset?: (string|null);

            /** TWeatherDayData Temperature */
            Temperature?: (number|null);

            /** TWeatherDayData Icon */
            Icon?: (string|null);

            /** TWeatherDayData Condition */
            Condition?: (NAlice.NData.ITWeatherCondition|null);

            /** TWeatherDayData TodayDaylight */
            TodayDaylight?: (NAlice.NData.ITDaylightHours|null);

            /** TWeatherDayData IconType */
            IconType?: (string|null);

            /** TWeatherDayData UserDate */
            UserDate?: (string|null);
        }

        /** Represents a TWeatherDayData. */
        class TWeatherDayData implements ITWeatherDayData {

            /**
             * Constructs a new TWeatherDayData.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITWeatherDayData);

            /** TWeatherDayData DayPartItems. */
            public DayPartItems: NAlice.NData.ITWeatherDayPartItem[];

            /** TWeatherDayData Date. */
            public Date: string;

            /** TWeatherDayData GeoLocation. */
            public GeoLocation?: (NAlice.NData.ITWeatherLocation|null);

            /** TWeatherDayData Tz. */
            public Tz: string;

            /** TWeatherDayData UserTime. */
            public UserTime: string;

            /** TWeatherDayData Sunrise. */
            public Sunrise: string;

            /** TWeatherDayData Sunset. */
            public Sunset: string;

            /** TWeatherDayData Temperature. */
            public Temperature: number;

            /** TWeatherDayData Icon. */
            public Icon: string;

            /** TWeatherDayData Condition. */
            public Condition?: (NAlice.NData.ITWeatherCondition|null);

            /** TWeatherDayData TodayDaylight. */
            public TodayDaylight?: (NAlice.NData.ITDaylightHours|null);

            /** TWeatherDayData IconType. */
            public IconType: string;

            /** TWeatherDayData UserDate. */
            public UserDate: string;

            /**
             * Creates a new TWeatherDayData instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TWeatherDayData instance
             */
            public static create(properties?: NAlice.NData.ITWeatherDayData): NAlice.NData.TWeatherDayData;

            /**
             * Encodes the specified TWeatherDayData message. Does not implicitly {@link NAlice.NData.TWeatherDayData.verify|verify} messages.
             * @param message TWeatherDayData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITWeatherDayData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TWeatherDayData message, length delimited. Does not implicitly {@link NAlice.NData.TWeatherDayData.verify|verify} messages.
             * @param message TWeatherDayData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITWeatherDayData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TWeatherDayData message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TWeatherDayData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TWeatherDayData;

            /**
             * Decodes a TWeatherDayData message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TWeatherDayData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TWeatherDayData;

            /**
             * Verifies a TWeatherDayData message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TWeatherDayData message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TWeatherDayData
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TWeatherDayData;

            /**
             * Creates a plain object from a TWeatherDayData message. Also converts values to other types if specified.
             * @param message TWeatherDayData
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TWeatherDayData, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TWeatherDayData to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a TWeatherDayItem. */
        interface ITWeatherDayItem {

            /** TWeatherDayItem Date */
            Date?: (string|null);

            /** TWeatherDayItem Tz */
            Tz?: (string|null);

            /** TWeatherDayItem WeekDay */
            WeekDay?: (number|null);

            /** TWeatherDayItem DayTemp */
            DayTemp?: (number|null);

            /** TWeatherDayItem NightTemp */
            NightTemp?: (number|null);

            /** TWeatherDayItem Icon */
            Icon?: (string|null);

            /** TWeatherDayItem Condition */
            Condition?: (NAlice.NData.ITWeatherCondition|null);

            /** TWeatherDayItem Url */
            Url?: (string|null);

            /** TWeatherDayItem IconType */
            IconType?: (string|null);
        }

        /** Represents a TWeatherDayItem. */
        class TWeatherDayItem implements ITWeatherDayItem {

            /**
             * Constructs a new TWeatherDayItem.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITWeatherDayItem);

            /** TWeatherDayItem Date. */
            public Date: string;

            /** TWeatherDayItem Tz. */
            public Tz: string;

            /** TWeatherDayItem WeekDay. */
            public WeekDay: number;

            /** TWeatherDayItem DayTemp. */
            public DayTemp: number;

            /** TWeatherDayItem NightTemp. */
            public NightTemp: number;

            /** TWeatherDayItem Icon. */
            public Icon: string;

            /** TWeatherDayItem Condition. */
            public Condition?: (NAlice.NData.ITWeatherCondition|null);

            /** TWeatherDayItem Url. */
            public Url: string;

            /** TWeatherDayItem IconType. */
            public IconType: string;

            /**
             * Creates a new TWeatherDayItem instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TWeatherDayItem instance
             */
            public static create(properties?: NAlice.NData.ITWeatherDayItem): NAlice.NData.TWeatherDayItem;

            /**
             * Encodes the specified TWeatherDayItem message. Does not implicitly {@link NAlice.NData.TWeatherDayItem.verify|verify} messages.
             * @param message TWeatherDayItem message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITWeatherDayItem, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TWeatherDayItem message, length delimited. Does not implicitly {@link NAlice.NData.TWeatherDayItem.verify|verify} messages.
             * @param message TWeatherDayItem message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITWeatherDayItem, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TWeatherDayItem message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TWeatherDayItem
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TWeatherDayItem;

            /**
             * Decodes a TWeatherDayItem message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TWeatherDayItem
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TWeatherDayItem;

            /**
             * Verifies a TWeatherDayItem message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TWeatherDayItem message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TWeatherDayItem
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TWeatherDayItem;

            /**
             * Creates a plain object from a TWeatherDayItem message. Also converts values to other types if specified.
             * @param message TWeatherDayItem
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TWeatherDayItem, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TWeatherDayItem to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a TWeatherDaysRangeData. */
        interface ITWeatherDaysRangeData {

            /** TWeatherDaysRangeData DayItems */
            DayItems?: (NAlice.NData.ITWeatherDayItem[]|null);

            /** TWeatherDaysRangeData GeoLocation */
            GeoLocation?: (NAlice.NData.ITWeatherLocation|null);

            /** TWeatherDaysRangeData Tz */
            Tz?: (string|null);

            /** TWeatherDaysRangeData UserTime */
            UserTime?: (string|null);

            /** TWeatherDaysRangeData TodayDaylight */
            TodayDaylight?: (NAlice.NData.ITDaylightHours|null);

            /** TWeatherDaysRangeData UserDate */
            UserDate?: (string|null);
        }

        /** Represents a TWeatherDaysRangeData. */
        class TWeatherDaysRangeData implements ITWeatherDaysRangeData {

            /**
             * Constructs a new TWeatherDaysRangeData.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITWeatherDaysRangeData);

            /** TWeatherDaysRangeData DayItems. */
            public DayItems: NAlice.NData.ITWeatherDayItem[];

            /** TWeatherDaysRangeData GeoLocation. */
            public GeoLocation?: (NAlice.NData.ITWeatherLocation|null);

            /** TWeatherDaysRangeData Tz. */
            public Tz: string;

            /** TWeatherDaysRangeData UserTime. */
            public UserTime: string;

            /** TWeatherDaysRangeData TodayDaylight. */
            public TodayDaylight?: (NAlice.NData.ITDaylightHours|null);

            /** TWeatherDaysRangeData UserDate. */
            public UserDate: string;

            /**
             * Creates a new TWeatherDaysRangeData instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TWeatherDaysRangeData instance
             */
            public static create(properties?: NAlice.NData.ITWeatherDaysRangeData): NAlice.NData.TWeatherDaysRangeData;

            /**
             * Encodes the specified TWeatherDaysRangeData message. Does not implicitly {@link NAlice.NData.TWeatherDaysRangeData.verify|verify} messages.
             * @param message TWeatherDaysRangeData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITWeatherDaysRangeData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TWeatherDaysRangeData message, length delimited. Does not implicitly {@link NAlice.NData.TWeatherDaysRangeData.verify|verify} messages.
             * @param message TWeatherDaysRangeData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITWeatherDaysRangeData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TWeatherDaysRangeData message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TWeatherDaysRangeData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TWeatherDaysRangeData;

            /**
             * Decodes a TWeatherDaysRangeData message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TWeatherDaysRangeData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TWeatherDaysRangeData;

            /**
             * Verifies a TWeatherDaysRangeData message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TWeatherDaysRangeData message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TWeatherDaysRangeData
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TWeatherDaysRangeData;

            /**
             * Creates a plain object from a TWeatherDaysRangeData message. Also converts values to other types if specified.
             * @param message TWeatherDaysRangeData
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TWeatherDaysRangeData, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TWeatherDaysRangeData to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a TCentaurWidgetData. */
        interface ITCentaurWidgetData {

            /** TCentaurWidgetData Fixed */
            Fixed?: (boolean|null);

            /** TCentaurWidgetData VacantWidgetData */
            VacantWidgetData?: (NAlice.NData.TCentaurWidgetData.ITVacantWidgetData|null);

            /** TCentaurWidgetData MusicWidgetData */
            MusicWidgetData?: (NAlice.NData.TCentaurWidgetData.ITMusicWidgetData|null);

            /** TCentaurWidgetData NotificationWidgetData */
            NotificationWidgetData?: (NAlice.NData.TCentaurWidgetData.ITNotificationWidgetData|null);

            /** TCentaurWidgetData WeatherWidgetData */
            WeatherWidgetData?: (NAlice.NData.TCentaurWidgetData.ITWeatherWidgetData|null);

            /** TCentaurWidgetData NewsWidgetData */
            NewsWidgetData?: (NAlice.NData.TCentaurWidgetData.ITNewsWidgetData|null);

            /** TCentaurWidgetData OpenWebviewWidgetData */
            OpenWebviewWidgetData?: (NAlice.NData.TCentaurWidgetData.ITOpenWebviewWidgetData|null);

            /** TCentaurWidgetData TrafficWidgetData */
            TrafficWidgetData?: (NAlice.NData.TCentaurWidgetData.ITTrafficWidgetData|null);

            /** TCentaurWidgetData VideoCallWidgetData */
            VideoCallWidgetData?: (NAlice.NData.TCentaurWidgetData.ITVideoCallWidgetData|null);
        }

        /** Represents a TCentaurWidgetData. */
        class TCentaurWidgetData implements ITCentaurWidgetData {

            /**
             * Constructs a new TCentaurWidgetData.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITCentaurWidgetData);

            /** TCentaurWidgetData Fixed. */
            public Fixed: boolean;

            /** TCentaurWidgetData VacantWidgetData. */
            public VacantWidgetData?: (NAlice.NData.TCentaurWidgetData.ITVacantWidgetData|null);

            /** TCentaurWidgetData MusicWidgetData. */
            public MusicWidgetData?: (NAlice.NData.TCentaurWidgetData.ITMusicWidgetData|null);

            /** TCentaurWidgetData NotificationWidgetData. */
            public NotificationWidgetData?: (NAlice.NData.TCentaurWidgetData.ITNotificationWidgetData|null);

            /** TCentaurWidgetData WeatherWidgetData. */
            public WeatherWidgetData?: (NAlice.NData.TCentaurWidgetData.ITWeatherWidgetData|null);

            /** TCentaurWidgetData NewsWidgetData. */
            public NewsWidgetData?: (NAlice.NData.TCentaurWidgetData.ITNewsWidgetData|null);

            /** TCentaurWidgetData OpenWebviewWidgetData. */
            public OpenWebviewWidgetData?: (NAlice.NData.TCentaurWidgetData.ITOpenWebviewWidgetData|null);

            /** TCentaurWidgetData TrafficWidgetData. */
            public TrafficWidgetData?: (NAlice.NData.TCentaurWidgetData.ITTrafficWidgetData|null);

            /** TCentaurWidgetData VideoCallWidgetData. */
            public VideoCallWidgetData?: (NAlice.NData.TCentaurWidgetData.ITVideoCallWidgetData|null);

            /** TCentaurWidgetData WidgetTypeData. */
            public WidgetTypeData?: ("VacantWidgetData"|"MusicWidgetData"|"NotificationWidgetData"|"WeatherWidgetData"|"NewsWidgetData"|"OpenWebviewWidgetData"|"TrafficWidgetData"|"VideoCallWidgetData");

            /**
             * Creates a new TCentaurWidgetData instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TCentaurWidgetData instance
             */
            public static create(properties?: NAlice.NData.ITCentaurWidgetData): NAlice.NData.TCentaurWidgetData;

            /**
             * Encodes the specified TCentaurWidgetData message. Does not implicitly {@link NAlice.NData.TCentaurWidgetData.verify|verify} messages.
             * @param message TCentaurWidgetData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITCentaurWidgetData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TCentaurWidgetData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurWidgetData.verify|verify} messages.
             * @param message TCentaurWidgetData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITCentaurWidgetData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TCentaurWidgetData message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TCentaurWidgetData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TCentaurWidgetData;

            /**
             * Decodes a TCentaurWidgetData message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TCentaurWidgetData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TCentaurWidgetData;

            /**
             * Verifies a TCentaurWidgetData message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TCentaurWidgetData message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TCentaurWidgetData
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TCentaurWidgetData;

            /**
             * Creates a plain object from a TCentaurWidgetData message. Also converts values to other types if specified.
             * @param message TCentaurWidgetData
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TCentaurWidgetData, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TCentaurWidgetData to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        namespace TCentaurWidgetData {

            /** Properties of a TVacantWidgetData. */
            interface ITVacantWidgetData {
            }

            /** Represents a TVacantWidgetData. */
            class TVacantWidgetData implements ITVacantWidgetData {

                /**
                 * Constructs a new TVacantWidgetData.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: NAlice.NData.TCentaurWidgetData.ITVacantWidgetData);

                /**
                 * Creates a new TVacantWidgetData instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns TVacantWidgetData instance
                 */
                public static create(properties?: NAlice.NData.TCentaurWidgetData.ITVacantWidgetData): NAlice.NData.TCentaurWidgetData.TVacantWidgetData;

                /**
                 * Encodes the specified TVacantWidgetData message. Does not implicitly {@link NAlice.NData.TCentaurWidgetData.TVacantWidgetData.verify|verify} messages.
                 * @param message TVacantWidgetData message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: NAlice.NData.TCentaurWidgetData.ITVacantWidgetData, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified TVacantWidgetData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurWidgetData.TVacantWidgetData.verify|verify} messages.
                 * @param message TVacantWidgetData message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: NAlice.NData.TCentaurWidgetData.ITVacantWidgetData, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a TVacantWidgetData message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns TVacantWidgetData
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TCentaurWidgetData.TVacantWidgetData;

                /**
                 * Decodes a TVacantWidgetData message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns TVacantWidgetData
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TCentaurWidgetData.TVacantWidgetData;

                /**
                 * Verifies a TVacantWidgetData message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a TVacantWidgetData message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns TVacantWidgetData
                 */
                public static fromObject(object: { [k: string]: any }): NAlice.NData.TCentaurWidgetData.TVacantWidgetData;

                /**
                 * Creates a plain object from a TVacantWidgetData message. Also converts values to other types if specified.
                 * @param message TVacantWidgetData
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: NAlice.NData.TCentaurWidgetData.TVacantWidgetData, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this TVacantWidgetData to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }

            /** Properties of a TMusicWidgetData. */
            interface ITMusicWidgetData {
            }

            /** Represents a TMusicWidgetData. */
            class TMusicWidgetData implements ITMusicWidgetData {

                /**
                 * Constructs a new TMusicWidgetData.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: NAlice.NData.TCentaurWidgetData.ITMusicWidgetData);

                /**
                 * Creates a new TMusicWidgetData instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns TMusicWidgetData instance
                 */
                public static create(properties?: NAlice.NData.TCentaurWidgetData.ITMusicWidgetData): NAlice.NData.TCentaurWidgetData.TMusicWidgetData;

                /**
                 * Encodes the specified TMusicWidgetData message. Does not implicitly {@link NAlice.NData.TCentaurWidgetData.TMusicWidgetData.verify|verify} messages.
                 * @param message TMusicWidgetData message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: NAlice.NData.TCentaurWidgetData.ITMusicWidgetData, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified TMusicWidgetData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurWidgetData.TMusicWidgetData.verify|verify} messages.
                 * @param message TMusicWidgetData message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: NAlice.NData.TCentaurWidgetData.ITMusicWidgetData, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a TMusicWidgetData message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns TMusicWidgetData
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TCentaurWidgetData.TMusicWidgetData;

                /**
                 * Decodes a TMusicWidgetData message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns TMusicWidgetData
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TCentaurWidgetData.TMusicWidgetData;

                /**
                 * Verifies a TMusicWidgetData message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a TMusicWidgetData message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns TMusicWidgetData
                 */
                public static fromObject(object: { [k: string]: any }): NAlice.NData.TCentaurWidgetData.TMusicWidgetData;

                /**
                 * Creates a plain object from a TMusicWidgetData message. Also converts values to other types if specified.
                 * @param message TMusicWidgetData
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: NAlice.NData.TCentaurWidgetData.TMusicWidgetData, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this TMusicWidgetData to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }

            /** Properties of a TNotificationWidgetData. */
            interface ITNotificationWidgetData {
            }

            /** Represents a TNotificationWidgetData. */
            class TNotificationWidgetData implements ITNotificationWidgetData {

                /**
                 * Constructs a new TNotificationWidgetData.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: NAlice.NData.TCentaurWidgetData.ITNotificationWidgetData);

                /**
                 * Creates a new TNotificationWidgetData instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns TNotificationWidgetData instance
                 */
                public static create(properties?: NAlice.NData.TCentaurWidgetData.ITNotificationWidgetData): NAlice.NData.TCentaurWidgetData.TNotificationWidgetData;

                /**
                 * Encodes the specified TNotificationWidgetData message. Does not implicitly {@link NAlice.NData.TCentaurWidgetData.TNotificationWidgetData.verify|verify} messages.
                 * @param message TNotificationWidgetData message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: NAlice.NData.TCentaurWidgetData.ITNotificationWidgetData, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified TNotificationWidgetData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurWidgetData.TNotificationWidgetData.verify|verify} messages.
                 * @param message TNotificationWidgetData message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: NAlice.NData.TCentaurWidgetData.ITNotificationWidgetData, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a TNotificationWidgetData message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns TNotificationWidgetData
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TCentaurWidgetData.TNotificationWidgetData;

                /**
                 * Decodes a TNotificationWidgetData message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns TNotificationWidgetData
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TCentaurWidgetData.TNotificationWidgetData;

                /**
                 * Verifies a TNotificationWidgetData message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a TNotificationWidgetData message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns TNotificationWidgetData
                 */
                public static fromObject(object: { [k: string]: any }): NAlice.NData.TCentaurWidgetData.TNotificationWidgetData;

                /**
                 * Creates a plain object from a TNotificationWidgetData message. Also converts values to other types if specified.
                 * @param message TNotificationWidgetData
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: NAlice.NData.TCentaurWidgetData.TNotificationWidgetData, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this TNotificationWidgetData to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }

            /** Properties of a TWeatherWidgetData. */
            interface ITWeatherWidgetData {
            }

            /** Represents a TWeatherWidgetData. */
            class TWeatherWidgetData implements ITWeatherWidgetData {

                /**
                 * Constructs a new TWeatherWidgetData.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: NAlice.NData.TCentaurWidgetData.ITWeatherWidgetData);

                /**
                 * Creates a new TWeatherWidgetData instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns TWeatherWidgetData instance
                 */
                public static create(properties?: NAlice.NData.TCentaurWidgetData.ITWeatherWidgetData): NAlice.NData.TCentaurWidgetData.TWeatherWidgetData;

                /**
                 * Encodes the specified TWeatherWidgetData message. Does not implicitly {@link NAlice.NData.TCentaurWidgetData.TWeatherWidgetData.verify|verify} messages.
                 * @param message TWeatherWidgetData message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: NAlice.NData.TCentaurWidgetData.ITWeatherWidgetData, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified TWeatherWidgetData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurWidgetData.TWeatherWidgetData.verify|verify} messages.
                 * @param message TWeatherWidgetData message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: NAlice.NData.TCentaurWidgetData.ITWeatherWidgetData, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a TWeatherWidgetData message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns TWeatherWidgetData
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TCentaurWidgetData.TWeatherWidgetData;

                /**
                 * Decodes a TWeatherWidgetData message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns TWeatherWidgetData
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TCentaurWidgetData.TWeatherWidgetData;

                /**
                 * Verifies a TWeatherWidgetData message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a TWeatherWidgetData message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns TWeatherWidgetData
                 */
                public static fromObject(object: { [k: string]: any }): NAlice.NData.TCentaurWidgetData.TWeatherWidgetData;

                /**
                 * Creates a plain object from a TWeatherWidgetData message. Also converts values to other types if specified.
                 * @param message TWeatherWidgetData
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: NAlice.NData.TCentaurWidgetData.TWeatherWidgetData, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this TWeatherWidgetData to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }

            /** Properties of a TNewsWidgetData. */
            interface ITNewsWidgetData {
            }

            /** Represents a TNewsWidgetData. */
            class TNewsWidgetData implements ITNewsWidgetData {

                /**
                 * Constructs a new TNewsWidgetData.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: NAlice.NData.TCentaurWidgetData.ITNewsWidgetData);

                /**
                 * Creates a new TNewsWidgetData instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns TNewsWidgetData instance
                 */
                public static create(properties?: NAlice.NData.TCentaurWidgetData.ITNewsWidgetData): NAlice.NData.TCentaurWidgetData.TNewsWidgetData;

                /**
                 * Encodes the specified TNewsWidgetData message. Does not implicitly {@link NAlice.NData.TCentaurWidgetData.TNewsWidgetData.verify|verify} messages.
                 * @param message TNewsWidgetData message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: NAlice.NData.TCentaurWidgetData.ITNewsWidgetData, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified TNewsWidgetData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurWidgetData.TNewsWidgetData.verify|verify} messages.
                 * @param message TNewsWidgetData message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: NAlice.NData.TCentaurWidgetData.ITNewsWidgetData, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a TNewsWidgetData message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns TNewsWidgetData
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TCentaurWidgetData.TNewsWidgetData;

                /**
                 * Decodes a TNewsWidgetData message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns TNewsWidgetData
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TCentaurWidgetData.TNewsWidgetData;

                /**
                 * Verifies a TNewsWidgetData message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a TNewsWidgetData message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns TNewsWidgetData
                 */
                public static fromObject(object: { [k: string]: any }): NAlice.NData.TCentaurWidgetData.TNewsWidgetData;

                /**
                 * Creates a plain object from a TNewsWidgetData message. Also converts values to other types if specified.
                 * @param message TNewsWidgetData
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: NAlice.NData.TCentaurWidgetData.TNewsWidgetData, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this TNewsWidgetData to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }

            /** Properties of a TTrafficWidgetData. */
            interface ITTrafficWidgetData {
            }

            /** Represents a TTrafficWidgetData. */
            class TTrafficWidgetData implements ITTrafficWidgetData {

                /**
                 * Constructs a new TTrafficWidgetData.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: NAlice.NData.TCentaurWidgetData.ITTrafficWidgetData);

                /**
                 * Creates a new TTrafficWidgetData instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns TTrafficWidgetData instance
                 */
                public static create(properties?: NAlice.NData.TCentaurWidgetData.ITTrafficWidgetData): NAlice.NData.TCentaurWidgetData.TTrafficWidgetData;

                /**
                 * Encodes the specified TTrafficWidgetData message. Does not implicitly {@link NAlice.NData.TCentaurWidgetData.TTrafficWidgetData.verify|verify} messages.
                 * @param message TTrafficWidgetData message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: NAlice.NData.TCentaurWidgetData.ITTrafficWidgetData, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified TTrafficWidgetData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurWidgetData.TTrafficWidgetData.verify|verify} messages.
                 * @param message TTrafficWidgetData message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: NAlice.NData.TCentaurWidgetData.ITTrafficWidgetData, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a TTrafficWidgetData message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns TTrafficWidgetData
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TCentaurWidgetData.TTrafficWidgetData;

                /**
                 * Decodes a TTrafficWidgetData message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns TTrafficWidgetData
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TCentaurWidgetData.TTrafficWidgetData;

                /**
                 * Verifies a TTrafficWidgetData message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a TTrafficWidgetData message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns TTrafficWidgetData
                 */
                public static fromObject(object: { [k: string]: any }): NAlice.NData.TCentaurWidgetData.TTrafficWidgetData;

                /**
                 * Creates a plain object from a TTrafficWidgetData message. Also converts values to other types if specified.
                 * @param message TTrafficWidgetData
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: NAlice.NData.TCentaurWidgetData.TTrafficWidgetData, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this TTrafficWidgetData to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }

            /** Properties of a TVideoCallWidgetData. */
            interface ITVideoCallWidgetData {
            }

            /** Represents a TVideoCallWidgetData. */
            class TVideoCallWidgetData implements ITVideoCallWidgetData {

                /**
                 * Constructs a new TVideoCallWidgetData.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: NAlice.NData.TCentaurWidgetData.ITVideoCallWidgetData);

                /**
                 * Creates a new TVideoCallWidgetData instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns TVideoCallWidgetData instance
                 */
                public static create(properties?: NAlice.NData.TCentaurWidgetData.ITVideoCallWidgetData): NAlice.NData.TCentaurWidgetData.TVideoCallWidgetData;

                /**
                 * Encodes the specified TVideoCallWidgetData message. Does not implicitly {@link NAlice.NData.TCentaurWidgetData.TVideoCallWidgetData.verify|verify} messages.
                 * @param message TVideoCallWidgetData message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: NAlice.NData.TCentaurWidgetData.ITVideoCallWidgetData, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified TVideoCallWidgetData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurWidgetData.TVideoCallWidgetData.verify|verify} messages.
                 * @param message TVideoCallWidgetData message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: NAlice.NData.TCentaurWidgetData.ITVideoCallWidgetData, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a TVideoCallWidgetData message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns TVideoCallWidgetData
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TCentaurWidgetData.TVideoCallWidgetData;

                /**
                 * Decodes a TVideoCallWidgetData message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns TVideoCallWidgetData
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TCentaurWidgetData.TVideoCallWidgetData;

                /**
                 * Verifies a TVideoCallWidgetData message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a TVideoCallWidgetData message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns TVideoCallWidgetData
                 */
                public static fromObject(object: { [k: string]: any }): NAlice.NData.TCentaurWidgetData.TVideoCallWidgetData;

                /**
                 * Creates a plain object from a TVideoCallWidgetData message. Also converts values to other types if specified.
                 * @param message TVideoCallWidgetData
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: NAlice.NData.TCentaurWidgetData.TVideoCallWidgetData, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this TVideoCallWidgetData to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }

            /** Properties of a TOpenWebviewWidgetData. */
            interface ITOpenWebviewWidgetData {

                /** TOpenWebviewWidgetData Application */
                Application?: (string|null);

                /** TOpenWebviewWidgetData Url */
                Url?: (string|null);
            }

            /** Represents a TOpenWebviewWidgetData. */
            class TOpenWebviewWidgetData implements ITOpenWebviewWidgetData {

                /**
                 * Constructs a new TOpenWebviewWidgetData.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: NAlice.NData.TCentaurWidgetData.ITOpenWebviewWidgetData);

                /** TOpenWebviewWidgetData Application. */
                public Application?: (string|null);

                /** TOpenWebviewWidgetData Url. */
                public Url?: (string|null);

                /** TOpenWebviewWidgetData Source. */
                public Source?: ("Application"|"Url");

                /**
                 * Creates a new TOpenWebviewWidgetData instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns TOpenWebviewWidgetData instance
                 */
                public static create(properties?: NAlice.NData.TCentaurWidgetData.ITOpenWebviewWidgetData): NAlice.NData.TCentaurWidgetData.TOpenWebviewWidgetData;

                /**
                 * Encodes the specified TOpenWebviewWidgetData message. Does not implicitly {@link NAlice.NData.TCentaurWidgetData.TOpenWebviewWidgetData.verify|verify} messages.
                 * @param message TOpenWebviewWidgetData message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: NAlice.NData.TCentaurWidgetData.ITOpenWebviewWidgetData, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified TOpenWebviewWidgetData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurWidgetData.TOpenWebviewWidgetData.verify|verify} messages.
                 * @param message TOpenWebviewWidgetData message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: NAlice.NData.TCentaurWidgetData.ITOpenWebviewWidgetData, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a TOpenWebviewWidgetData message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns TOpenWebviewWidgetData
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TCentaurWidgetData.TOpenWebviewWidgetData;

                /**
                 * Decodes a TOpenWebviewWidgetData message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns TOpenWebviewWidgetData
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TCentaurWidgetData.TOpenWebviewWidgetData;

                /**
                 * Verifies a TOpenWebviewWidgetData message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a TOpenWebviewWidgetData message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns TOpenWebviewWidgetData
                 */
                public static fromObject(object: { [k: string]: any }): NAlice.NData.TCentaurWidgetData.TOpenWebviewWidgetData;

                /**
                 * Creates a plain object from a TOpenWebviewWidgetData message. Also converts values to other types if specified.
                 * @param message TOpenWebviewWidgetData
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: NAlice.NData.TCentaurWidgetData.TOpenWebviewWidgetData, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this TOpenWebviewWidgetData to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }
        }

        /** Properties of a TCentaurWidgetConfigData. */
        interface ITCentaurWidgetConfigData {

            /** TCentaurWidgetConfigData Id */
            Id?: (string|null);

            /** TCentaurWidgetConfigData WidgetType */
            WidgetType?: (string|null);

            /** TCentaurWidgetConfigData CustomWidgetTypeData */
            CustomWidgetTypeData?: (NAlice.NData.TCentaurWidgetConfigData.ITCustomWidgetTypeData|null);

            /** TCentaurWidgetConfigData Fixed */
            Fixed?: (boolean|null);
        }

        /** Represents a TCentaurWidgetConfigData. */
        class TCentaurWidgetConfigData implements ITCentaurWidgetConfigData {

            /**
             * Constructs a new TCentaurWidgetConfigData.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITCentaurWidgetConfigData);

            /** TCentaurWidgetConfigData Id. */
            public Id: string;

            /** TCentaurWidgetConfigData WidgetType. */
            public WidgetType: string;

            /** TCentaurWidgetConfigData CustomWidgetTypeData. */
            public CustomWidgetTypeData?: (NAlice.NData.TCentaurWidgetConfigData.ITCustomWidgetTypeData|null);

            /** TCentaurWidgetConfigData Fixed. */
            public Fixed: boolean;

            /**
             * Creates a new TCentaurWidgetConfigData instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TCentaurWidgetConfigData instance
             */
            public static create(properties?: NAlice.NData.ITCentaurWidgetConfigData): NAlice.NData.TCentaurWidgetConfigData;

            /**
             * Encodes the specified TCentaurWidgetConfigData message. Does not implicitly {@link NAlice.NData.TCentaurWidgetConfigData.verify|verify} messages.
             * @param message TCentaurWidgetConfigData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITCentaurWidgetConfigData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TCentaurWidgetConfigData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurWidgetConfigData.verify|verify} messages.
             * @param message TCentaurWidgetConfigData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITCentaurWidgetConfigData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TCentaurWidgetConfigData message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TCentaurWidgetConfigData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TCentaurWidgetConfigData;

            /**
             * Decodes a TCentaurWidgetConfigData message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TCentaurWidgetConfigData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TCentaurWidgetConfigData;

            /**
             * Verifies a TCentaurWidgetConfigData message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TCentaurWidgetConfigData message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TCentaurWidgetConfigData
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TCentaurWidgetConfigData;

            /**
             * Creates a plain object from a TCentaurWidgetConfigData message. Also converts values to other types if specified.
             * @param message TCentaurWidgetConfigData
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TCentaurWidgetConfigData, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TCentaurWidgetConfigData to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        namespace TCentaurWidgetConfigData {

            /** Properties of a TCustomWidgetTypeData. */
            interface ITCustomWidgetTypeData {
            }

            /** Represents a TCustomWidgetTypeData. */
            class TCustomWidgetTypeData implements ITCustomWidgetTypeData {

                /**
                 * Constructs a new TCustomWidgetTypeData.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: NAlice.NData.TCentaurWidgetConfigData.ITCustomWidgetTypeData);

                /**
                 * Creates a new TCustomWidgetTypeData instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns TCustomWidgetTypeData instance
                 */
                public static create(properties?: NAlice.NData.TCentaurWidgetConfigData.ITCustomWidgetTypeData): NAlice.NData.TCentaurWidgetConfigData.TCustomWidgetTypeData;

                /**
                 * Encodes the specified TCustomWidgetTypeData message. Does not implicitly {@link NAlice.NData.TCentaurWidgetConfigData.TCustomWidgetTypeData.verify|verify} messages.
                 * @param message TCustomWidgetTypeData message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: NAlice.NData.TCentaurWidgetConfigData.ITCustomWidgetTypeData, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified TCustomWidgetTypeData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurWidgetConfigData.TCustomWidgetTypeData.verify|verify} messages.
                 * @param message TCustomWidgetTypeData message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: NAlice.NData.TCentaurWidgetConfigData.ITCustomWidgetTypeData, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a TCustomWidgetTypeData message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns TCustomWidgetTypeData
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TCentaurWidgetConfigData.TCustomWidgetTypeData;

                /**
                 * Decodes a TCustomWidgetTypeData message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns TCustomWidgetTypeData
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TCentaurWidgetConfigData.TCustomWidgetTypeData;

                /**
                 * Verifies a TCustomWidgetTypeData message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a TCustomWidgetTypeData message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns TCustomWidgetTypeData
                 */
                public static fromObject(object: { [k: string]: any }): NAlice.NData.TCentaurWidgetConfigData.TCustomWidgetTypeData;

                /**
                 * Creates a plain object from a TCustomWidgetTypeData message. Also converts values to other types if specified.
                 * @param message TCustomWidgetTypeData
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: NAlice.NData.TCentaurWidgetConfigData.TCustomWidgetTypeData, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this TCustomWidgetTypeData to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }
        }

        /** Properties of a TWidgetPosition. */
        interface ITWidgetPosition {

            /** TWidgetPosition Column */
            Column?: (number|null);

            /** TWidgetPosition Row */
            Row?: (number|null);
        }

        /** Represents a TWidgetPosition. */
        class TWidgetPosition implements ITWidgetPosition {

            /**
             * Constructs a new TWidgetPosition.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITWidgetPosition);

            /** TWidgetPosition Column. */
            public Column: number;

            /** TWidgetPosition Row. */
            public Row: number;

            /**
             * Creates a new TWidgetPosition instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TWidgetPosition instance
             */
            public static create(properties?: NAlice.NData.ITWidgetPosition): NAlice.NData.TWidgetPosition;

            /**
             * Encodes the specified TWidgetPosition message. Does not implicitly {@link NAlice.NData.TWidgetPosition.verify|verify} messages.
             * @param message TWidgetPosition message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITWidgetPosition, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TWidgetPosition message, length delimited. Does not implicitly {@link NAlice.NData.TWidgetPosition.verify|verify} messages.
             * @param message TWidgetPosition message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITWidgetPosition, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TWidgetPosition message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TWidgetPosition
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TWidgetPosition;

            /**
             * Decodes a TWidgetPosition message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TWidgetPosition
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TWidgetPosition;

            /**
             * Verifies a TWidgetPosition message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TWidgetPosition message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TWidgetPosition
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TWidgetPosition;

            /**
             * Creates a plain object from a TWidgetPosition message. Also converts values to other types if specified.
             * @param message TWidgetPosition
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TWidgetPosition, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TWidgetPosition to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a TCentaurTeaserChromeDefaultLayerData. */
        interface ITCentaurTeaserChromeDefaultLayerData {

            /** TCentaurTeaserChromeDefaultLayerData WeatherTeaserData */
            WeatherTeaserData?: (NAlice.NData.ITWeatherTeaserData|null);
        }

        /** Represents a TCentaurTeaserChromeDefaultLayerData. */
        class TCentaurTeaserChromeDefaultLayerData implements ITCentaurTeaserChromeDefaultLayerData {

            /**
             * Constructs a new TCentaurTeaserChromeDefaultLayerData.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITCentaurTeaserChromeDefaultLayerData);

            /** TCentaurTeaserChromeDefaultLayerData WeatherTeaserData. */
            public WeatherTeaserData?: (NAlice.NData.ITWeatherTeaserData|null);

            /**
             * Creates a new TCentaurTeaserChromeDefaultLayerData instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TCentaurTeaserChromeDefaultLayerData instance
             */
            public static create(properties?: NAlice.NData.ITCentaurTeaserChromeDefaultLayerData): NAlice.NData.TCentaurTeaserChromeDefaultLayerData;

            /**
             * Encodes the specified TCentaurTeaserChromeDefaultLayerData message. Does not implicitly {@link NAlice.NData.TCentaurTeaserChromeDefaultLayerData.verify|verify} messages.
             * @param message TCentaurTeaserChromeDefaultLayerData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITCentaurTeaserChromeDefaultLayerData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TCentaurTeaserChromeDefaultLayerData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurTeaserChromeDefaultLayerData.verify|verify} messages.
             * @param message TCentaurTeaserChromeDefaultLayerData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITCentaurTeaserChromeDefaultLayerData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TCentaurTeaserChromeDefaultLayerData message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TCentaurTeaserChromeDefaultLayerData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TCentaurTeaserChromeDefaultLayerData;

            /**
             * Decodes a TCentaurTeaserChromeDefaultLayerData message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TCentaurTeaserChromeDefaultLayerData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TCentaurTeaserChromeDefaultLayerData;

            /**
             * Verifies a TCentaurTeaserChromeDefaultLayerData message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TCentaurTeaserChromeDefaultLayerData message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TCentaurTeaserChromeDefaultLayerData
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TCentaurTeaserChromeDefaultLayerData;

            /**
             * Creates a plain object from a TCentaurTeaserChromeDefaultLayerData message. Also converts values to other types if specified.
             * @param message TCentaurTeaserChromeDefaultLayerData
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TCentaurTeaserChromeDefaultLayerData, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TCentaurTeaserChromeDefaultLayerData to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a TCentaurTeaserConfigData. */
        interface ITCentaurTeaserConfigData {

            /** TCentaurTeaserConfigData TeaserType */
            TeaserType?: (string|null);

            /** TCentaurTeaserConfigData TeaserId */
            TeaserId?: (string|null);
        }

        /** Represents a TCentaurTeaserConfigData. */
        class TCentaurTeaserConfigData implements ITCentaurTeaserConfigData {

            /**
             * Constructs a new TCentaurTeaserConfigData.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITCentaurTeaserConfigData);

            /** TCentaurTeaserConfigData TeaserType. */
            public TeaserType: string;

            /** TCentaurTeaserConfigData TeaserId. */
            public TeaserId: string;

            /**
             * Creates a new TCentaurTeaserConfigData instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TCentaurTeaserConfigData instance
             */
            public static create(properties?: NAlice.NData.ITCentaurTeaserConfigData): NAlice.NData.TCentaurTeaserConfigData;

            /**
             * Encodes the specified TCentaurTeaserConfigData message. Does not implicitly {@link NAlice.NData.TCentaurTeaserConfigData.verify|verify} messages.
             * @param message TCentaurTeaserConfigData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITCentaurTeaserConfigData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TCentaurTeaserConfigData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurTeaserConfigData.verify|verify} messages.
             * @param message TCentaurTeaserConfigData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITCentaurTeaserConfigData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TCentaurTeaserConfigData message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TCentaurTeaserConfigData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TCentaurTeaserConfigData;

            /**
             * Decodes a TCentaurTeaserConfigData message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TCentaurTeaserConfigData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TCentaurTeaserConfigData;

            /**
             * Verifies a TCentaurTeaserConfigData message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TCentaurTeaserConfigData message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TCentaurTeaserConfigData
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TCentaurTeaserConfigData;

            /**
             * Creates a plain object from a TCentaurTeaserConfigData message. Also converts values to other types if specified.
             * @param message TCentaurTeaserConfigData
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TCentaurTeaserConfigData, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TCentaurTeaserConfigData to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a TTeaserSettingsData. */
        interface ITTeaserSettingsData {

            /** TTeaserSettingsData TeaserSettings */
            TeaserSettings?: (NAlice.NData.TTeaserSettingsData.ITeaserSetting[]|null);
        }

        /** Represents a TTeaserSettingsData. */
        class TTeaserSettingsData implements ITTeaserSettingsData {

            /**
             * Constructs a new TTeaserSettingsData.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITTeaserSettingsData);

            /** TTeaserSettingsData TeaserSettings. */
            public TeaserSettings: NAlice.NData.TTeaserSettingsData.ITeaserSetting[];

            /**
             * Creates a new TTeaserSettingsData instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TTeaserSettingsData instance
             */
            public static create(properties?: NAlice.NData.ITTeaserSettingsData): NAlice.NData.TTeaserSettingsData;

            /**
             * Encodes the specified TTeaserSettingsData message. Does not implicitly {@link NAlice.NData.TTeaserSettingsData.verify|verify} messages.
             * @param message TTeaserSettingsData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITTeaserSettingsData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TTeaserSettingsData message, length delimited. Does not implicitly {@link NAlice.NData.TTeaserSettingsData.verify|verify} messages.
             * @param message TTeaserSettingsData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITTeaserSettingsData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TTeaserSettingsData message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TTeaserSettingsData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TTeaserSettingsData;

            /**
             * Decodes a TTeaserSettingsData message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TTeaserSettingsData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TTeaserSettingsData;

            /**
             * Verifies a TTeaserSettingsData message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TTeaserSettingsData message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TTeaserSettingsData
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TTeaserSettingsData;

            /**
             * Creates a plain object from a TTeaserSettingsData message. Also converts values to other types if specified.
             * @param message TTeaserSettingsData
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TTeaserSettingsData, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TTeaserSettingsData to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        namespace TTeaserSettingsData {

            /** Properties of a TeaserSetting. */
            interface ITeaserSetting {

                /** TeaserSetting TeaserConfigData */
                TeaserConfigData?: (NAlice.NData.ITCentaurTeaserConfigData|null);

                /** TeaserSetting IsChosen */
                IsChosen?: (boolean|null);
            }

            /** Represents a TeaserSetting. */
            class TeaserSetting implements ITeaserSetting {

                /**
                 * Constructs a new TeaserSetting.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: NAlice.NData.TTeaserSettingsData.ITeaserSetting);

                /** TeaserSetting TeaserConfigData. */
                public TeaserConfigData?: (NAlice.NData.ITCentaurTeaserConfigData|null);

                /** TeaserSetting IsChosen. */
                public IsChosen: boolean;

                /**
                 * Creates a new TeaserSetting instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns TeaserSetting instance
                 */
                public static create(properties?: NAlice.NData.TTeaserSettingsData.ITeaserSetting): NAlice.NData.TTeaserSettingsData.TeaserSetting;

                /**
                 * Encodes the specified TeaserSetting message. Does not implicitly {@link NAlice.NData.TTeaserSettingsData.TeaserSetting.verify|verify} messages.
                 * @param message TeaserSetting message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: NAlice.NData.TTeaserSettingsData.ITeaserSetting, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified TeaserSetting message, length delimited. Does not implicitly {@link NAlice.NData.TTeaserSettingsData.TeaserSetting.verify|verify} messages.
                 * @param message TeaserSetting message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: NAlice.NData.TTeaserSettingsData.ITeaserSetting, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a TeaserSetting message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns TeaserSetting
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TTeaserSettingsData.TeaserSetting;

                /**
                 * Decodes a TeaserSetting message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns TeaserSetting
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TTeaserSettingsData.TeaserSetting;

                /**
                 * Verifies a TeaserSetting message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a TeaserSetting message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns TeaserSetting
                 */
                public static fromObject(object: { [k: string]: any }): NAlice.NData.TTeaserSettingsData.TeaserSetting;

                /**
                 * Creates a plain object from a TeaserSetting message. Also converts values to other types if specified.
                 * @param message TeaserSetting
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: NAlice.NData.TTeaserSettingsData.TeaserSetting, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this TeaserSetting to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }
        }

        /** Properties of a TTeaserPreviewScenarioData. */
        interface ITTeaserPreviewScenarioData {

            /** TTeaserPreviewScenarioData NewsTeaserData */
            NewsTeaserData?: (NAlice.NData.ITNewsTeaserData|null);

            /** TTeaserPreviewScenarioData ScreenSaverData */
            ScreenSaverData?: (NAlice.NData.ITScreenSaverData|null);

            /** TTeaserPreviewScenarioData AfishaTeaserData */
            AfishaTeaserData?: (NAlice.NData.ITAfishaTeaserData|null);

            /** TTeaserPreviewScenarioData WeatherTeaserData */
            WeatherTeaserData?: (NAlice.NData.ITWeatherTeaserData|null);

            /** TTeaserPreviewScenarioData DialogovoTeaserCardData */
            DialogovoTeaserCardData?: (NAlice.NData.ITDialogovoSkillTeaserData|null);
        }

        /** Represents a TTeaserPreviewScenarioData. */
        class TTeaserPreviewScenarioData implements ITTeaserPreviewScenarioData {

            /**
             * Constructs a new TTeaserPreviewScenarioData.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITTeaserPreviewScenarioData);

            /** TTeaserPreviewScenarioData NewsTeaserData. */
            public NewsTeaserData?: (NAlice.NData.ITNewsTeaserData|null);

            /** TTeaserPreviewScenarioData ScreenSaverData. */
            public ScreenSaverData?: (NAlice.NData.ITScreenSaverData|null);

            /** TTeaserPreviewScenarioData AfishaTeaserData. */
            public AfishaTeaserData?: (NAlice.NData.ITAfishaTeaserData|null);

            /** TTeaserPreviewScenarioData WeatherTeaserData. */
            public WeatherTeaserData?: (NAlice.NData.ITWeatherTeaserData|null);

            /** TTeaserPreviewScenarioData DialogovoTeaserCardData. */
            public DialogovoTeaserCardData?: (NAlice.NData.ITDialogovoSkillTeaserData|null);

            /** TTeaserPreviewScenarioData PreviewScenarioData. */
            public PreviewScenarioData?: ("NewsTeaserData"|"ScreenSaverData"|"AfishaTeaserData"|"WeatherTeaserData"|"DialogovoTeaserCardData");

            /**
             * Creates a new TTeaserPreviewScenarioData instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TTeaserPreviewScenarioData instance
             */
            public static create(properties?: NAlice.NData.ITTeaserPreviewScenarioData): NAlice.NData.TTeaserPreviewScenarioData;

            /**
             * Encodes the specified TTeaserPreviewScenarioData message. Does not implicitly {@link NAlice.NData.TTeaserPreviewScenarioData.verify|verify} messages.
             * @param message TTeaserPreviewScenarioData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITTeaserPreviewScenarioData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TTeaserPreviewScenarioData message, length delimited. Does not implicitly {@link NAlice.NData.TTeaserPreviewScenarioData.verify|verify} messages.
             * @param message TTeaserPreviewScenarioData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITTeaserPreviewScenarioData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TTeaserPreviewScenarioData message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TTeaserPreviewScenarioData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TTeaserPreviewScenarioData;

            /**
             * Decodes a TTeaserPreviewScenarioData message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TTeaserPreviewScenarioData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TTeaserPreviewScenarioData;

            /**
             * Verifies a TTeaserPreviewScenarioData message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TTeaserPreviewScenarioData message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TTeaserPreviewScenarioData
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TTeaserPreviewScenarioData;

            /**
             * Creates a plain object from a TTeaserPreviewScenarioData message. Also converts values to other types if specified.
             * @param message TTeaserPreviewScenarioData
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TTeaserPreviewScenarioData, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TTeaserPreviewScenarioData to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a TTeaserSettingsWithContentData. */
        interface ITTeaserSettingsWithContentData {

            /** TTeaserSettingsWithContentData TeaserSettingsWithPreview */
            TeaserSettingsWithPreview?: (NAlice.NData.TTeaserSettingsWithContentData.ITeaserSettingWithPreview[]|null);
        }

        /** Represents a TTeaserSettingsWithContentData. */
        class TTeaserSettingsWithContentData implements ITTeaserSettingsWithContentData {

            /**
             * Constructs a new TTeaserSettingsWithContentData.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITTeaserSettingsWithContentData);

            /** TTeaserSettingsWithContentData TeaserSettingsWithPreview. */
            public TeaserSettingsWithPreview: NAlice.NData.TTeaserSettingsWithContentData.ITeaserSettingWithPreview[];

            /**
             * Creates a new TTeaserSettingsWithContentData instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TTeaserSettingsWithContentData instance
             */
            public static create(properties?: NAlice.NData.ITTeaserSettingsWithContentData): NAlice.NData.TTeaserSettingsWithContentData;

            /**
             * Encodes the specified TTeaserSettingsWithContentData message. Does not implicitly {@link NAlice.NData.TTeaserSettingsWithContentData.verify|verify} messages.
             * @param message TTeaserSettingsWithContentData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITTeaserSettingsWithContentData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TTeaserSettingsWithContentData message, length delimited. Does not implicitly {@link NAlice.NData.TTeaserSettingsWithContentData.verify|verify} messages.
             * @param message TTeaserSettingsWithContentData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITTeaserSettingsWithContentData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TTeaserSettingsWithContentData message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TTeaserSettingsWithContentData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TTeaserSettingsWithContentData;

            /**
             * Decodes a TTeaserSettingsWithContentData message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TTeaserSettingsWithContentData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TTeaserSettingsWithContentData;

            /**
             * Verifies a TTeaserSettingsWithContentData message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TTeaserSettingsWithContentData message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TTeaserSettingsWithContentData
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TTeaserSettingsWithContentData;

            /**
             * Creates a plain object from a TTeaserSettingsWithContentData message. Also converts values to other types if specified.
             * @param message TTeaserSettingsWithContentData
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TTeaserSettingsWithContentData, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TTeaserSettingsWithContentData to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        namespace TTeaserSettingsWithContentData {

            /** Properties of a TeaserSettingWithPreview. */
            interface ITeaserSettingWithPreview {

                /** TeaserSettingWithPreview TeaserConfigData */
                TeaserConfigData?: (NAlice.NData.ITCentaurTeaserConfigData|null);

                /** TeaserSettingWithPreview IsChosen */
                IsChosen?: (boolean|null);

                /** TeaserSettingWithPreview TeaserName */
                TeaserName?: (string|null);

                /** TeaserSettingWithPreview TeaserPreviewScenarioData */
                TeaserPreviewScenarioData?: (NAlice.NData.ITTeaserPreviewScenarioData|null);
            }

            /** Represents a TeaserSettingWithPreview. */
            class TeaserSettingWithPreview implements ITeaserSettingWithPreview {

                /**
                 * Constructs a new TeaserSettingWithPreview.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: NAlice.NData.TTeaserSettingsWithContentData.ITeaserSettingWithPreview);

                /** TeaserSettingWithPreview TeaserConfigData. */
                public TeaserConfigData?: (NAlice.NData.ITCentaurTeaserConfigData|null);

                /** TeaserSettingWithPreview IsChosen. */
                public IsChosen: boolean;

                /** TeaserSettingWithPreview TeaserName. */
                public TeaserName: string;

                /** TeaserSettingWithPreview TeaserPreviewScenarioData. */
                public TeaserPreviewScenarioData?: (NAlice.NData.ITTeaserPreviewScenarioData|null);

                /**
                 * Creates a new TeaserSettingWithPreview instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns TeaserSettingWithPreview instance
                 */
                public static create(properties?: NAlice.NData.TTeaserSettingsWithContentData.ITeaserSettingWithPreview): NAlice.NData.TTeaserSettingsWithContentData.TeaserSettingWithPreview;

                /**
                 * Encodes the specified TeaserSettingWithPreview message. Does not implicitly {@link NAlice.NData.TTeaserSettingsWithContentData.TeaserSettingWithPreview.verify|verify} messages.
                 * @param message TeaserSettingWithPreview message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: NAlice.NData.TTeaserSettingsWithContentData.ITeaserSettingWithPreview, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified TeaserSettingWithPreview message, length delimited. Does not implicitly {@link NAlice.NData.TTeaserSettingsWithContentData.TeaserSettingWithPreview.verify|verify} messages.
                 * @param message TeaserSettingWithPreview message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: NAlice.NData.TTeaserSettingsWithContentData.ITeaserSettingWithPreview, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a TeaserSettingWithPreview message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns TeaserSettingWithPreview
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TTeaserSettingsWithContentData.TeaserSettingWithPreview;

                /**
                 * Decodes a TeaserSettingWithPreview message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns TeaserSettingWithPreview
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TTeaserSettingsWithContentData.TeaserSettingWithPreview;

                /**
                 * Verifies a TeaserSettingWithPreview message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a TeaserSettingWithPreview message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns TeaserSettingWithPreview
                 */
                public static fromObject(object: { [k: string]: any }): NAlice.NData.TTeaserSettingsWithContentData.TeaserSettingWithPreview;

                /**
                 * Creates a plain object from a TeaserSettingWithPreview message. Also converts values to other types if specified.
                 * @param message TeaserSettingWithPreview
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: NAlice.NData.TTeaserSettingsWithContentData.TeaserSettingWithPreview, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this TeaserSettingWithPreview to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }
        }

        /** Properties of a TTeasersPreviewData. */
        interface ITTeasersPreviewData {

            /** TTeasersPreviewData TeaserPreviews */
            TeaserPreviews?: (NAlice.NData.TTeasersPreviewData.ITTeaserPreview[]|null);
        }

        /** Represents a TTeasersPreviewData. */
        class TTeasersPreviewData implements ITTeasersPreviewData {

            /**
             * Constructs a new TTeasersPreviewData.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITTeasersPreviewData);

            /** TTeasersPreviewData TeaserPreviews. */
            public TeaserPreviews: NAlice.NData.TTeasersPreviewData.ITTeaserPreview[];

            /**
             * Creates a new TTeasersPreviewData instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TTeasersPreviewData instance
             */
            public static create(properties?: NAlice.NData.ITTeasersPreviewData): NAlice.NData.TTeasersPreviewData;

            /**
             * Encodes the specified TTeasersPreviewData message. Does not implicitly {@link NAlice.NData.TTeasersPreviewData.verify|verify} messages.
             * @param message TTeasersPreviewData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITTeasersPreviewData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TTeasersPreviewData message, length delimited. Does not implicitly {@link NAlice.NData.TTeasersPreviewData.verify|verify} messages.
             * @param message TTeasersPreviewData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITTeasersPreviewData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TTeasersPreviewData message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TTeasersPreviewData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TTeasersPreviewData;

            /**
             * Decodes a TTeasersPreviewData message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TTeasersPreviewData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TTeasersPreviewData;

            /**
             * Verifies a TTeasersPreviewData message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TTeasersPreviewData message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TTeasersPreviewData
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TTeasersPreviewData;

            /**
             * Creates a plain object from a TTeasersPreviewData message. Also converts values to other types if specified.
             * @param message TTeasersPreviewData
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TTeasersPreviewData, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TTeasersPreviewData to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        namespace TTeasersPreviewData {

            /** Properties of a TTeaserPreview. */
            interface ITTeaserPreview {

                /** TTeaserPreview TeaserConfigData */
                TeaserConfigData?: (NAlice.NData.ITCentaurTeaserConfigData|null);

                /** TTeaserPreview TeaserName */
                TeaserName?: (string|null);

                /** TTeaserPreview TeaserPreviewScenarioData */
                TeaserPreviewScenarioData?: (NAlice.NData.ITTeaserPreviewScenarioData|null);
            }

            /** Represents a TTeaserPreview. */
            class TTeaserPreview implements ITTeaserPreview {

                /**
                 * Constructs a new TTeaserPreview.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: NAlice.NData.TTeasersPreviewData.ITTeaserPreview);

                /** TTeaserPreview TeaserConfigData. */
                public TeaserConfigData?: (NAlice.NData.ITCentaurTeaserConfigData|null);

                /** TTeaserPreview TeaserName. */
                public TeaserName: string;

                /** TTeaserPreview TeaserPreviewScenarioData. */
                public TeaserPreviewScenarioData?: (NAlice.NData.ITTeaserPreviewScenarioData|null);

                /**
                 * Creates a new TTeaserPreview instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns TTeaserPreview instance
                 */
                public static create(properties?: NAlice.NData.TTeasersPreviewData.ITTeaserPreview): NAlice.NData.TTeasersPreviewData.TTeaserPreview;

                /**
                 * Encodes the specified TTeaserPreview message. Does not implicitly {@link NAlice.NData.TTeasersPreviewData.TTeaserPreview.verify|verify} messages.
                 * @param message TTeaserPreview message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: NAlice.NData.TTeasersPreviewData.ITTeaserPreview, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified TTeaserPreview message, length delimited. Does not implicitly {@link NAlice.NData.TTeasersPreviewData.TTeaserPreview.verify|verify} messages.
                 * @param message TTeaserPreview message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: NAlice.NData.TTeasersPreviewData.ITTeaserPreview, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a TTeaserPreview message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns TTeaserPreview
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TTeasersPreviewData.TTeaserPreview;

                /**
                 * Decodes a TTeaserPreview message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns TTeaserPreview
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TTeasersPreviewData.TTeaserPreview;

                /**
                 * Verifies a TTeaserPreview message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a TTeaserPreview message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns TTeaserPreview
                 */
                public static fromObject(object: { [k: string]: any }): NAlice.NData.TTeasersPreviewData.TTeaserPreview;

                /**
                 * Creates a plain object from a TTeaserPreview message. Also converts values to other types if specified.
                 * @param message TTeaserPreview
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: NAlice.NData.TTeasersPreviewData.TTeaserPreview, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this TTeaserPreview to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }
        }

        /** Properties of a TNewsItem. */
        interface ITNewsItem {

            /** TNewsItem Text */
            Text?: (string|null);

            /** TNewsItem Url */
            Url?: (string|null);

            /** TNewsItem Image */
            Image?: (NAlice.NData.TNewsItem.ITImage|null);

            /** TNewsItem Messages */
            Messages?: (string|null);

            /** TNewsItem TurboIconUrl */
            TurboIconUrl?: (string|null);

            /** TNewsItem Agency */
            Agency?: (string|null);

            /** TNewsItem Logo */
            Logo?: (string|null);

            /** TNewsItem PubDate */
            PubDate?: (number|Long|null);

            /** TNewsItem ExtendedNews */
            ExtendedNews?: (NAlice.NData.ITNewsItem[]|null);
        }

        /** Represents a TNewsItem. */
        class TNewsItem implements ITNewsItem {

            /**
             * Constructs a new TNewsItem.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITNewsItem);

            /** TNewsItem Text. */
            public Text: string;

            /** TNewsItem Url. */
            public Url: string;

            /** TNewsItem Image. */
            public Image?: (NAlice.NData.TNewsItem.ITImage|null);

            /** TNewsItem Messages. */
            public Messages: string;

            /** TNewsItem TurboIconUrl. */
            public TurboIconUrl: string;

            /** TNewsItem Agency. */
            public Agency: string;

            /** TNewsItem Logo. */
            public Logo: string;

            /** TNewsItem PubDate. */
            public PubDate: (number|Long);

            /** TNewsItem ExtendedNews. */
            public ExtendedNews: NAlice.NData.ITNewsItem[];

            /**
             * Creates a new TNewsItem instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TNewsItem instance
             */
            public static create(properties?: NAlice.NData.ITNewsItem): NAlice.NData.TNewsItem;

            /**
             * Encodes the specified TNewsItem message. Does not implicitly {@link NAlice.NData.TNewsItem.verify|verify} messages.
             * @param message TNewsItem message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITNewsItem, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TNewsItem message, length delimited. Does not implicitly {@link NAlice.NData.TNewsItem.verify|verify} messages.
             * @param message TNewsItem message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITNewsItem, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TNewsItem message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TNewsItem
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TNewsItem;

            /**
             * Decodes a TNewsItem message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TNewsItem
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TNewsItem;

            /**
             * Verifies a TNewsItem message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TNewsItem message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TNewsItem
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TNewsItem;

            /**
             * Creates a plain object from a TNewsItem message. Also converts values to other types if specified.
             * @param message TNewsItem
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TNewsItem, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TNewsItem to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        namespace TNewsItem {

            /** Properties of a TImage. */
            interface ITImage {

                /** TImage Src */
                Src?: (string|null);

                /** TImage Width */
                Width?: (number|null);

                /** TImage Height */
                Height?: (number|null);
            }

            /** Represents a TImage. */
            class TImage implements ITImage {

                /**
                 * Constructs a new TImage.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: NAlice.NData.TNewsItem.ITImage);

                /** TImage Src. */
                public Src: string;

                /** TImage Width. */
                public Width: number;

                /** TImage Height. */
                public Height: number;

                /**
                 * Creates a new TImage instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns TImage instance
                 */
                public static create(properties?: NAlice.NData.TNewsItem.ITImage): NAlice.NData.TNewsItem.TImage;

                /**
                 * Encodes the specified TImage message. Does not implicitly {@link NAlice.NData.TNewsItem.TImage.verify|verify} messages.
                 * @param message TImage message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: NAlice.NData.TNewsItem.ITImage, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified TImage message, length delimited. Does not implicitly {@link NAlice.NData.TNewsItem.TImage.verify|verify} messages.
                 * @param message TImage message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: NAlice.NData.TNewsItem.ITImage, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a TImage message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns TImage
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TNewsItem.TImage;

                /**
                 * Decodes a TImage message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns TImage
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TNewsItem.TImage;

                /**
                 * Verifies a TImage message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a TImage message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns TImage
                 */
                public static fromObject(object: { [k: string]: any }): NAlice.NData.TNewsItem.TImage;

                /**
                 * Creates a plain object from a TImage message. Also converts values to other types if specified.
                 * @param message TImage
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: NAlice.NData.TNewsItem.TImage, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this TImage to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }
        }

        /** Properties of a TNewsGalleryData. */
        interface ITNewsGalleryData {

            /** TNewsGalleryData NewsItems */
            NewsItems?: (NAlice.NData.ITNewsItem[]|null);

            /** TNewsGalleryData CurrentNewsItem */
            CurrentNewsItem?: (number|null);

            /** TNewsGalleryData Topic */
            Topic?: (string|null);

            /** TNewsGalleryData Tz */
            Tz?: (string|null);
        }

        /** Represents a TNewsGalleryData. */
        class TNewsGalleryData implements ITNewsGalleryData {

            /**
             * Constructs a new TNewsGalleryData.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITNewsGalleryData);

            /** TNewsGalleryData NewsItems. */
            public NewsItems: NAlice.NData.ITNewsItem[];

            /** TNewsGalleryData CurrentNewsItem. */
            public CurrentNewsItem: number;

            /** TNewsGalleryData Topic. */
            public Topic: string;

            /** TNewsGalleryData Tz. */
            public Tz: string;

            /**
             * Creates a new TNewsGalleryData instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TNewsGalleryData instance
             */
            public static create(properties?: NAlice.NData.ITNewsGalleryData): NAlice.NData.TNewsGalleryData;

            /**
             * Encodes the specified TNewsGalleryData message. Does not implicitly {@link NAlice.NData.TNewsGalleryData.verify|verify} messages.
             * @param message TNewsGalleryData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITNewsGalleryData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TNewsGalleryData message, length delimited. Does not implicitly {@link NAlice.NData.TNewsGalleryData.verify|verify} messages.
             * @param message TNewsGalleryData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITNewsGalleryData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TNewsGalleryData message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TNewsGalleryData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TNewsGalleryData;

            /**
             * Decodes a TNewsGalleryData message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TNewsGalleryData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TNewsGalleryData;

            /**
             * Verifies a TNewsGalleryData message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TNewsGalleryData message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TNewsGalleryData
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TNewsGalleryData;

            /**
             * Creates a plain object from a TNewsGalleryData message. Also converts values to other types if specified.
             * @param message TNewsGalleryData
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TNewsGalleryData, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TNewsGalleryData to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a TNewsTeaserData. */
        interface ITNewsTeaserData {

            /** TNewsTeaserData NewsItem */
            NewsItem?: (NAlice.NData.ITNewsItem|null);

            /** TNewsTeaserData Topic */
            Topic?: (string|null);

            /** TNewsTeaserData Tz */
            Tz?: (string|null);
        }

        /** Represents a TNewsTeaserData. */
        class TNewsTeaserData implements ITNewsTeaserData {

            /**
             * Constructs a new TNewsTeaserData.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITNewsTeaserData);

            /** TNewsTeaserData NewsItem. */
            public NewsItem?: (NAlice.NData.ITNewsItem|null);

            /** TNewsTeaserData Topic. */
            public Topic: string;

            /** TNewsTeaserData Tz. */
            public Tz: string;

            /**
             * Creates a new TNewsTeaserData instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TNewsTeaserData instance
             */
            public static create(properties?: NAlice.NData.ITNewsTeaserData): NAlice.NData.TNewsTeaserData;

            /**
             * Encodes the specified TNewsTeaserData message. Does not implicitly {@link NAlice.NData.TNewsTeaserData.verify|verify} messages.
             * @param message TNewsTeaserData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITNewsTeaserData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TNewsTeaserData message, length delimited. Does not implicitly {@link NAlice.NData.TNewsTeaserData.verify|verify} messages.
             * @param message TNewsTeaserData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITNewsTeaserData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TNewsTeaserData message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TNewsTeaserData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TNewsTeaserData;

            /**
             * Decodes a TNewsTeaserData message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TNewsTeaserData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TNewsTeaserData;

            /**
             * Verifies a TNewsTeaserData message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TNewsTeaserData message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TNewsTeaserData
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TNewsTeaserData;

            /**
             * Creates a plain object from a TNewsTeaserData message. Also converts values to other types if specified.
             * @param message TNewsTeaserData
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TNewsTeaserData, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TNewsTeaserData to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a TNewsMainScreenData. */
        interface ITNewsMainScreenData {

            /** TNewsMainScreenData NewsItems */
            NewsItems?: (NAlice.NData.ITNewsItem[]|null);

            /** TNewsMainScreenData Topic */
            Topic?: (string|null);

            /** TNewsMainScreenData Tz */
            Tz?: (string|null);
        }

        /** Represents a TNewsMainScreenData. */
        class TNewsMainScreenData implements ITNewsMainScreenData {

            /**
             * Constructs a new TNewsMainScreenData.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITNewsMainScreenData);

            /** TNewsMainScreenData NewsItems. */
            public NewsItems: NAlice.NData.ITNewsItem[];

            /** TNewsMainScreenData Topic. */
            public Topic: string;

            /** TNewsMainScreenData Tz. */
            public Tz: string;

            /**
             * Creates a new TNewsMainScreenData instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TNewsMainScreenData instance
             */
            public static create(properties?: NAlice.NData.ITNewsMainScreenData): NAlice.NData.TNewsMainScreenData;

            /**
             * Encodes the specified TNewsMainScreenData message. Does not implicitly {@link NAlice.NData.TNewsMainScreenData.verify|verify} messages.
             * @param message TNewsMainScreenData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITNewsMainScreenData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TNewsMainScreenData message, length delimited. Does not implicitly {@link NAlice.NData.TNewsMainScreenData.verify|verify} messages.
             * @param message TNewsMainScreenData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITNewsMainScreenData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TNewsMainScreenData message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TNewsMainScreenData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TNewsMainScreenData;

            /**
             * Decodes a TNewsMainScreenData message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TNewsMainScreenData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TNewsMainScreenData;

            /**
             * Verifies a TNewsMainScreenData message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TNewsMainScreenData message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TNewsMainScreenData
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TNewsMainScreenData;

            /**
             * Creates a plain object from a TNewsMainScreenData message. Also converts values to other types if specified.
             * @param message TNewsMainScreenData
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TNewsMainScreenData, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TNewsMainScreenData to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a TScreenSaverData. */
        interface ITScreenSaverData {

            /** TScreenSaverData ImageUrl */
            ImageUrl?: (string|null);
        }

        /** Represents a TScreenSaverData. */
        class TScreenSaverData implements ITScreenSaverData {

            /**
             * Constructs a new TScreenSaverData.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITScreenSaverData);

            /** TScreenSaverData ImageUrl. */
            public ImageUrl: string;

            /**
             * Creates a new TScreenSaverData instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TScreenSaverData instance
             */
            public static create(properties?: NAlice.NData.ITScreenSaverData): NAlice.NData.TScreenSaverData;

            /**
             * Encodes the specified TScreenSaverData message. Does not implicitly {@link NAlice.NData.TScreenSaverData.verify|verify} messages.
             * @param message TScreenSaverData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITScreenSaverData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TScreenSaverData message, length delimited. Does not implicitly {@link NAlice.NData.TScreenSaverData.verify|verify} messages.
             * @param message TScreenSaverData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITScreenSaverData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TScreenSaverData message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TScreenSaverData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TScreenSaverData;

            /**
             * Decodes a TScreenSaverData message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TScreenSaverData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TScreenSaverData;

            /**
             * Verifies a TScreenSaverData message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TScreenSaverData message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TScreenSaverData
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TScreenSaverData;

            /**
             * Creates a plain object from a TScreenSaverData message. Also converts values to other types if specified.
             * @param message TScreenSaverData
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TScreenSaverData, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TScreenSaverData to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a TDialogovoSkillCardData. */
        interface ITDialogovoSkillCardData {

            /** TDialogovoSkillCardData SkillInfo */
            SkillInfo?: (NAlice.NData.TDialogovoSkillCardData.ITSkillInfo|null);

            /** TDialogovoSkillCardData SkillRequest */
            SkillRequest?: (NAlice.NData.TDialogovoSkillCardData.ITSkillRequest|null);

            /** TDialogovoSkillCardData SkillResponse */
            SkillResponse?: (NAlice.NData.TDialogovoSkillCardData.ITSkillResponse|null);
        }

        /** Represents a TDialogovoSkillCardData. */
        class TDialogovoSkillCardData implements ITDialogovoSkillCardData {

            /**
             * Constructs a new TDialogovoSkillCardData.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITDialogovoSkillCardData);

            /** TDialogovoSkillCardData SkillInfo. */
            public SkillInfo?: (NAlice.NData.TDialogovoSkillCardData.ITSkillInfo|null);

            /** TDialogovoSkillCardData SkillRequest. */
            public SkillRequest?: (NAlice.NData.TDialogovoSkillCardData.ITSkillRequest|null);

            /** TDialogovoSkillCardData SkillResponse. */
            public SkillResponse?: (NAlice.NData.TDialogovoSkillCardData.ITSkillResponse|null);

            /**
             * Creates a new TDialogovoSkillCardData instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TDialogovoSkillCardData instance
             */
            public static create(properties?: NAlice.NData.ITDialogovoSkillCardData): NAlice.NData.TDialogovoSkillCardData;

            /**
             * Encodes the specified TDialogovoSkillCardData message. Does not implicitly {@link NAlice.NData.TDialogovoSkillCardData.verify|verify} messages.
             * @param message TDialogovoSkillCardData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITDialogovoSkillCardData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TDialogovoSkillCardData message, length delimited. Does not implicitly {@link NAlice.NData.TDialogovoSkillCardData.verify|verify} messages.
             * @param message TDialogovoSkillCardData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITDialogovoSkillCardData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TDialogovoSkillCardData message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TDialogovoSkillCardData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TDialogovoSkillCardData;

            /**
             * Decodes a TDialogovoSkillCardData message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TDialogovoSkillCardData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TDialogovoSkillCardData;

            /**
             * Verifies a TDialogovoSkillCardData message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TDialogovoSkillCardData message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TDialogovoSkillCardData
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TDialogovoSkillCardData;

            /**
             * Creates a plain object from a TDialogovoSkillCardData message. Also converts values to other types if specified.
             * @param message TDialogovoSkillCardData
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TDialogovoSkillCardData, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TDialogovoSkillCardData to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        namespace TDialogovoSkillCardData {

            /** Properties of a TSkillInfo. */
            interface ITSkillInfo {

                /** TSkillInfo Name */
                Name?: (string|null);

                /** TSkillInfo Logo */
                Logo?: (string|null);

                /** TSkillInfo SkillId */
                SkillId?: (string|null);
            }

            /** Represents a TSkillInfo. */
            class TSkillInfo implements ITSkillInfo {

                /**
                 * Constructs a new TSkillInfo.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: NAlice.NData.TDialogovoSkillCardData.ITSkillInfo);

                /** TSkillInfo Name. */
                public Name: string;

                /** TSkillInfo Logo. */
                public Logo: string;

                /** TSkillInfo SkillId. */
                public SkillId: string;

                /**
                 * Creates a new TSkillInfo instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns TSkillInfo instance
                 */
                public static create(properties?: NAlice.NData.TDialogovoSkillCardData.ITSkillInfo): NAlice.NData.TDialogovoSkillCardData.TSkillInfo;

                /**
                 * Encodes the specified TSkillInfo message. Does not implicitly {@link NAlice.NData.TDialogovoSkillCardData.TSkillInfo.verify|verify} messages.
                 * @param message TSkillInfo message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: NAlice.NData.TDialogovoSkillCardData.ITSkillInfo, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified TSkillInfo message, length delimited. Does not implicitly {@link NAlice.NData.TDialogovoSkillCardData.TSkillInfo.verify|verify} messages.
                 * @param message TSkillInfo message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: NAlice.NData.TDialogovoSkillCardData.ITSkillInfo, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a TSkillInfo message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns TSkillInfo
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TDialogovoSkillCardData.TSkillInfo;

                /**
                 * Decodes a TSkillInfo message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns TSkillInfo
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TDialogovoSkillCardData.TSkillInfo;

                /**
                 * Verifies a TSkillInfo message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a TSkillInfo message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns TSkillInfo
                 */
                public static fromObject(object: { [k: string]: any }): NAlice.NData.TDialogovoSkillCardData.TSkillInfo;

                /**
                 * Creates a plain object from a TSkillInfo message. Also converts values to other types if specified.
                 * @param message TSkillInfo
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: NAlice.NData.TDialogovoSkillCardData.TSkillInfo, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this TSkillInfo to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }

            /** Properties of a TSkillRequest. */
            interface ITSkillRequest {

                /** TSkillRequest Text */
                Text?: (string|null);
            }

            /** Represents a TSkillRequest. */
            class TSkillRequest implements ITSkillRequest {

                /**
                 * Constructs a new TSkillRequest.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: NAlice.NData.TDialogovoSkillCardData.ITSkillRequest);

                /** TSkillRequest Text. */
                public Text: string;

                /**
                 * Creates a new TSkillRequest instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns TSkillRequest instance
                 */
                public static create(properties?: NAlice.NData.TDialogovoSkillCardData.ITSkillRequest): NAlice.NData.TDialogovoSkillCardData.TSkillRequest;

                /**
                 * Encodes the specified TSkillRequest message. Does not implicitly {@link NAlice.NData.TDialogovoSkillCardData.TSkillRequest.verify|verify} messages.
                 * @param message TSkillRequest message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: NAlice.NData.TDialogovoSkillCardData.ITSkillRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified TSkillRequest message, length delimited. Does not implicitly {@link NAlice.NData.TDialogovoSkillCardData.TSkillRequest.verify|verify} messages.
                 * @param message TSkillRequest message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: NAlice.NData.TDialogovoSkillCardData.ITSkillRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a TSkillRequest message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns TSkillRequest
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TDialogovoSkillCardData.TSkillRequest;

                /**
                 * Decodes a TSkillRequest message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns TSkillRequest
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TDialogovoSkillCardData.TSkillRequest;

                /**
                 * Verifies a TSkillRequest message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a TSkillRequest message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns TSkillRequest
                 */
                public static fromObject(object: { [k: string]: any }): NAlice.NData.TDialogovoSkillCardData.TSkillRequest;

                /**
                 * Creates a plain object from a TSkillRequest message. Also converts values to other types if specified.
                 * @param message TSkillRequest
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: NAlice.NData.TDialogovoSkillCardData.TSkillRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this TSkillRequest to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }

            /** Properties of a TSkillResponse. */
            interface ITSkillResponse {

                /** TSkillResponse TextResponse */
                TextResponse?: (NAlice.NData.TDialogovoSkillCardData.TSkillResponse.ITTextResponse|null);

                /** TSkillResponse BigImageResponse */
                BigImageResponse?: (NAlice.NData.TDialogovoSkillCardData.TSkillResponse.ITBigImageResponse|null);

                /** TSkillResponse ImageGalleryResponse */
                ImageGalleryResponse?: (NAlice.NData.TDialogovoSkillCardData.TSkillResponse.ITImageGalleryResponse|null);

                /** TSkillResponse ItemsListResponse */
                ItemsListResponse?: (NAlice.NData.TDialogovoSkillCardData.TSkillResponse.ITItemsListResponse|null);

                /** TSkillResponse buttons */
                buttons?: (NAlice.NData.TDialogovoSkillCardData.TSkillResponse.ITButton[]|null);

                /** TSkillResponse suggests */
                suggests?: (NAlice.NData.TDialogovoSkillCardData.TSkillResponse.ITSuggest[]|null);
            }

            /** Represents a TSkillResponse. */
            class TSkillResponse implements ITSkillResponse {

                /**
                 * Constructs a new TSkillResponse.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: NAlice.NData.TDialogovoSkillCardData.ITSkillResponse);

                /** TSkillResponse TextResponse. */
                public TextResponse?: (NAlice.NData.TDialogovoSkillCardData.TSkillResponse.ITTextResponse|null);

                /** TSkillResponse BigImageResponse. */
                public BigImageResponse?: (NAlice.NData.TDialogovoSkillCardData.TSkillResponse.ITBigImageResponse|null);

                /** TSkillResponse ImageGalleryResponse. */
                public ImageGalleryResponse?: (NAlice.NData.TDialogovoSkillCardData.TSkillResponse.ITImageGalleryResponse|null);

                /** TSkillResponse ItemsListResponse. */
                public ItemsListResponse?: (NAlice.NData.TDialogovoSkillCardData.TSkillResponse.ITItemsListResponse|null);

                /** TSkillResponse buttons. */
                public buttons: NAlice.NData.TDialogovoSkillCardData.TSkillResponse.ITButton[];

                /** TSkillResponse suggests. */
                public suggests: NAlice.NData.TDialogovoSkillCardData.TSkillResponse.ITSuggest[];

                /** TSkillResponse ResponseCard. */
                public ResponseCard?: ("TextResponse"|"BigImageResponse"|"ImageGalleryResponse"|"ItemsListResponse");

                /**
                 * Creates a new TSkillResponse instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns TSkillResponse instance
                 */
                public static create(properties?: NAlice.NData.TDialogovoSkillCardData.ITSkillResponse): NAlice.NData.TDialogovoSkillCardData.TSkillResponse;

                /**
                 * Encodes the specified TSkillResponse message. Does not implicitly {@link NAlice.NData.TDialogovoSkillCardData.TSkillResponse.verify|verify} messages.
                 * @param message TSkillResponse message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: NAlice.NData.TDialogovoSkillCardData.ITSkillResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified TSkillResponse message, length delimited. Does not implicitly {@link NAlice.NData.TDialogovoSkillCardData.TSkillResponse.verify|verify} messages.
                 * @param message TSkillResponse message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: NAlice.NData.TDialogovoSkillCardData.ITSkillResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a TSkillResponse message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns TSkillResponse
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TDialogovoSkillCardData.TSkillResponse;

                /**
                 * Decodes a TSkillResponse message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns TSkillResponse
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TDialogovoSkillCardData.TSkillResponse;

                /**
                 * Verifies a TSkillResponse message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a TSkillResponse message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns TSkillResponse
                 */
                public static fromObject(object: { [k: string]: any }): NAlice.NData.TDialogovoSkillCardData.TSkillResponse;

                /**
                 * Creates a plain object from a TSkillResponse message. Also converts values to other types if specified.
                 * @param message TSkillResponse
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: NAlice.NData.TDialogovoSkillCardData.TSkillResponse, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this TSkillResponse to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }

            namespace TSkillResponse {

                /** Properties of a TButton. */
                interface ITButton {

                    /** TButton Text */
                    Text?: (string|null);

                    /** TButton Url */
                    Url?: (string|null);

                    /** TButton Payload */
                    Payload?: (string|null);
                }

                /** Represents a TButton. */
                class TButton implements ITButton {

                    /**
                     * Constructs a new TButton.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: NAlice.NData.TDialogovoSkillCardData.TSkillResponse.ITButton);

                    /** TButton Text. */
                    public Text: string;

                    /** TButton Url. */
                    public Url: string;

                    /** TButton Payload. */
                    public Payload: string;

                    /**
                     * Creates a new TButton instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns TButton instance
                     */
                    public static create(properties?: NAlice.NData.TDialogovoSkillCardData.TSkillResponse.ITButton): NAlice.NData.TDialogovoSkillCardData.TSkillResponse.TButton;

                    /**
                     * Encodes the specified TButton message. Does not implicitly {@link NAlice.NData.TDialogovoSkillCardData.TSkillResponse.TButton.verify|verify} messages.
                     * @param message TButton message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: NAlice.NData.TDialogovoSkillCardData.TSkillResponse.ITButton, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified TButton message, length delimited. Does not implicitly {@link NAlice.NData.TDialogovoSkillCardData.TSkillResponse.TButton.verify|verify} messages.
                     * @param message TButton message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: NAlice.NData.TDialogovoSkillCardData.TSkillResponse.ITButton, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a TButton message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns TButton
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TDialogovoSkillCardData.TSkillResponse.TButton;

                    /**
                     * Decodes a TButton message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns TButton
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TDialogovoSkillCardData.TSkillResponse.TButton;

                    /**
                     * Verifies a TButton message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a TButton message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns TButton
                     */
                    public static fromObject(object: { [k: string]: any }): NAlice.NData.TDialogovoSkillCardData.TSkillResponse.TButton;

                    /**
                     * Creates a plain object from a TButton message. Also converts values to other types if specified.
                     * @param message TButton
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: NAlice.NData.TDialogovoSkillCardData.TSkillResponse.TButton, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this TButton to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a TSuggest. */
                interface ITSuggest {

                    /** TSuggest Text */
                    Text?: (string|null);

                    /** TSuggest Url */
                    Url?: (string|null);

                    /** TSuggest Payload */
                    Payload?: (string|null);
                }

                /** Represents a TSuggest. */
                class TSuggest implements ITSuggest {

                    /**
                     * Constructs a new TSuggest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: NAlice.NData.TDialogovoSkillCardData.TSkillResponse.ITSuggest);

                    /** TSuggest Text. */
                    public Text: string;

                    /** TSuggest Url. */
                    public Url: string;

                    /** TSuggest Payload. */
                    public Payload: string;

                    /**
                     * Creates a new TSuggest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns TSuggest instance
                     */
                    public static create(properties?: NAlice.NData.TDialogovoSkillCardData.TSkillResponse.ITSuggest): NAlice.NData.TDialogovoSkillCardData.TSkillResponse.TSuggest;

                    /**
                     * Encodes the specified TSuggest message. Does not implicitly {@link NAlice.NData.TDialogovoSkillCardData.TSkillResponse.TSuggest.verify|verify} messages.
                     * @param message TSuggest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: NAlice.NData.TDialogovoSkillCardData.TSkillResponse.ITSuggest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified TSuggest message, length delimited. Does not implicitly {@link NAlice.NData.TDialogovoSkillCardData.TSkillResponse.TSuggest.verify|verify} messages.
                     * @param message TSuggest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: NAlice.NData.TDialogovoSkillCardData.TSkillResponse.ITSuggest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a TSuggest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns TSuggest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TDialogovoSkillCardData.TSkillResponse.TSuggest;

                    /**
                     * Decodes a TSuggest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns TSuggest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TDialogovoSkillCardData.TSkillResponse.TSuggest;

                    /**
                     * Verifies a TSuggest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a TSuggest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns TSuggest
                     */
                    public static fromObject(object: { [k: string]: any }): NAlice.NData.TDialogovoSkillCardData.TSkillResponse.TSuggest;

                    /**
                     * Creates a plain object from a TSuggest message. Also converts values to other types if specified.
                     * @param message TSuggest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: NAlice.NData.TDialogovoSkillCardData.TSkillResponse.TSuggest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this TSuggest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a TTextResponse. */
                interface ITTextResponse {

                    /** TTextResponse Text */
                    Text?: (string|null);
                }

                /** Represents a TTextResponse. */
                class TTextResponse implements ITTextResponse {

                    /**
                     * Constructs a new TTextResponse.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: NAlice.NData.TDialogovoSkillCardData.TSkillResponse.ITTextResponse);

                    /** TTextResponse Text. */
                    public Text: string;

                    /**
                     * Creates a new TTextResponse instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns TTextResponse instance
                     */
                    public static create(properties?: NAlice.NData.TDialogovoSkillCardData.TSkillResponse.ITTextResponse): NAlice.NData.TDialogovoSkillCardData.TSkillResponse.TTextResponse;

                    /**
                     * Encodes the specified TTextResponse message. Does not implicitly {@link NAlice.NData.TDialogovoSkillCardData.TSkillResponse.TTextResponse.verify|verify} messages.
                     * @param message TTextResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: NAlice.NData.TDialogovoSkillCardData.TSkillResponse.ITTextResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified TTextResponse message, length delimited. Does not implicitly {@link NAlice.NData.TDialogovoSkillCardData.TSkillResponse.TTextResponse.verify|verify} messages.
                     * @param message TTextResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: NAlice.NData.TDialogovoSkillCardData.TSkillResponse.ITTextResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a TTextResponse message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns TTextResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TDialogovoSkillCardData.TSkillResponse.TTextResponse;

                    /**
                     * Decodes a TTextResponse message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns TTextResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TDialogovoSkillCardData.TSkillResponse.TTextResponse;

                    /**
                     * Verifies a TTextResponse message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a TTextResponse message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns TTextResponse
                     */
                    public static fromObject(object: { [k: string]: any }): NAlice.NData.TDialogovoSkillCardData.TSkillResponse.TTextResponse;

                    /**
                     * Creates a plain object from a TTextResponse message. Also converts values to other types if specified.
                     * @param message TTextResponse
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: NAlice.NData.TDialogovoSkillCardData.TSkillResponse.TTextResponse, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this TTextResponse to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a TImageItem. */
                interface ITImageItem {

                    /** TImageItem ImageUrl */
                    ImageUrl?: (string|null);

                    /** TImageItem Title */
                    Title?: (string|null);

                    /** TImageItem Description */
                    Description?: (string|null);

                    /** TImageItem Button */
                    Button?: (NAlice.NData.TDialogovoSkillCardData.TSkillResponse.ITButton|null);
                }

                /** Represents a TImageItem. */
                class TImageItem implements ITImageItem {

                    /**
                     * Constructs a new TImageItem.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: NAlice.NData.TDialogovoSkillCardData.TSkillResponse.ITImageItem);

                    /** TImageItem ImageUrl. */
                    public ImageUrl: string;

                    /** TImageItem Title. */
                    public Title: string;

                    /** TImageItem Description. */
                    public Description: string;

                    /** TImageItem Button. */
                    public Button?: (NAlice.NData.TDialogovoSkillCardData.TSkillResponse.ITButton|null);

                    /**
                     * Creates a new TImageItem instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns TImageItem instance
                     */
                    public static create(properties?: NAlice.NData.TDialogovoSkillCardData.TSkillResponse.ITImageItem): NAlice.NData.TDialogovoSkillCardData.TSkillResponse.TImageItem;

                    /**
                     * Encodes the specified TImageItem message. Does not implicitly {@link NAlice.NData.TDialogovoSkillCardData.TSkillResponse.TImageItem.verify|verify} messages.
                     * @param message TImageItem message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: NAlice.NData.TDialogovoSkillCardData.TSkillResponse.ITImageItem, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified TImageItem message, length delimited. Does not implicitly {@link NAlice.NData.TDialogovoSkillCardData.TSkillResponse.TImageItem.verify|verify} messages.
                     * @param message TImageItem message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: NAlice.NData.TDialogovoSkillCardData.TSkillResponse.ITImageItem, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a TImageItem message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns TImageItem
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TDialogovoSkillCardData.TSkillResponse.TImageItem;

                    /**
                     * Decodes a TImageItem message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns TImageItem
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TDialogovoSkillCardData.TSkillResponse.TImageItem;

                    /**
                     * Verifies a TImageItem message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a TImageItem message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns TImageItem
                     */
                    public static fromObject(object: { [k: string]: any }): NAlice.NData.TDialogovoSkillCardData.TSkillResponse.TImageItem;

                    /**
                     * Creates a plain object from a TImageItem message. Also converts values to other types if specified.
                     * @param message TImageItem
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: NAlice.NData.TDialogovoSkillCardData.TSkillResponse.TImageItem, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this TImageItem to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a TBigImageResponse. */
                interface ITBigImageResponse {

                    /** TBigImageResponse ImageItem */
                    ImageItem?: (NAlice.NData.TDialogovoSkillCardData.TSkillResponse.ITImageItem|null);
                }

                /** Represents a TBigImageResponse. */
                class TBigImageResponse implements ITBigImageResponse {

                    /**
                     * Constructs a new TBigImageResponse.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: NAlice.NData.TDialogovoSkillCardData.TSkillResponse.ITBigImageResponse);

                    /** TBigImageResponse ImageItem. */
                    public ImageItem?: (NAlice.NData.TDialogovoSkillCardData.TSkillResponse.ITImageItem|null);

                    /**
                     * Creates a new TBigImageResponse instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns TBigImageResponse instance
                     */
                    public static create(properties?: NAlice.NData.TDialogovoSkillCardData.TSkillResponse.ITBigImageResponse): NAlice.NData.TDialogovoSkillCardData.TSkillResponse.TBigImageResponse;

                    /**
                     * Encodes the specified TBigImageResponse message. Does not implicitly {@link NAlice.NData.TDialogovoSkillCardData.TSkillResponse.TBigImageResponse.verify|verify} messages.
                     * @param message TBigImageResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: NAlice.NData.TDialogovoSkillCardData.TSkillResponse.ITBigImageResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified TBigImageResponse message, length delimited. Does not implicitly {@link NAlice.NData.TDialogovoSkillCardData.TSkillResponse.TBigImageResponse.verify|verify} messages.
                     * @param message TBigImageResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: NAlice.NData.TDialogovoSkillCardData.TSkillResponse.ITBigImageResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a TBigImageResponse message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns TBigImageResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TDialogovoSkillCardData.TSkillResponse.TBigImageResponse;

                    /**
                     * Decodes a TBigImageResponse message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns TBigImageResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TDialogovoSkillCardData.TSkillResponse.TBigImageResponse;

                    /**
                     * Verifies a TBigImageResponse message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a TBigImageResponse message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns TBigImageResponse
                     */
                    public static fromObject(object: { [k: string]: any }): NAlice.NData.TDialogovoSkillCardData.TSkillResponse.TBigImageResponse;

                    /**
                     * Creates a plain object from a TBigImageResponse message. Also converts values to other types if specified.
                     * @param message TBigImageResponse
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: NAlice.NData.TDialogovoSkillCardData.TSkillResponse.TBigImageResponse, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this TBigImageResponse to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a TImageGalleryResponse. */
                interface ITImageGalleryResponse {

                    /** TImageGalleryResponse ImageItems */
                    ImageItems?: (NAlice.NData.TDialogovoSkillCardData.TSkillResponse.ITImageItem[]|null);
                }

                /** Represents a TImageGalleryResponse. */
                class TImageGalleryResponse implements ITImageGalleryResponse {

                    /**
                     * Constructs a new TImageGalleryResponse.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: NAlice.NData.TDialogovoSkillCardData.TSkillResponse.ITImageGalleryResponse);

                    /** TImageGalleryResponse ImageItems. */
                    public ImageItems: NAlice.NData.TDialogovoSkillCardData.TSkillResponse.ITImageItem[];

                    /**
                     * Creates a new TImageGalleryResponse instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns TImageGalleryResponse instance
                     */
                    public static create(properties?: NAlice.NData.TDialogovoSkillCardData.TSkillResponse.ITImageGalleryResponse): NAlice.NData.TDialogovoSkillCardData.TSkillResponse.TImageGalleryResponse;

                    /**
                     * Encodes the specified TImageGalleryResponse message. Does not implicitly {@link NAlice.NData.TDialogovoSkillCardData.TSkillResponse.TImageGalleryResponse.verify|verify} messages.
                     * @param message TImageGalleryResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: NAlice.NData.TDialogovoSkillCardData.TSkillResponse.ITImageGalleryResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified TImageGalleryResponse message, length delimited. Does not implicitly {@link NAlice.NData.TDialogovoSkillCardData.TSkillResponse.TImageGalleryResponse.verify|verify} messages.
                     * @param message TImageGalleryResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: NAlice.NData.TDialogovoSkillCardData.TSkillResponse.ITImageGalleryResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a TImageGalleryResponse message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns TImageGalleryResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TDialogovoSkillCardData.TSkillResponse.TImageGalleryResponse;

                    /**
                     * Decodes a TImageGalleryResponse message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns TImageGalleryResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TDialogovoSkillCardData.TSkillResponse.TImageGalleryResponse;

                    /**
                     * Verifies a TImageGalleryResponse message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a TImageGalleryResponse message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns TImageGalleryResponse
                     */
                    public static fromObject(object: { [k: string]: any }): NAlice.NData.TDialogovoSkillCardData.TSkillResponse.TImageGalleryResponse;

                    /**
                     * Creates a plain object from a TImageGalleryResponse message. Also converts values to other types if specified.
                     * @param message TImageGalleryResponse
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: NAlice.NData.TDialogovoSkillCardData.TSkillResponse.TImageGalleryResponse, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this TImageGalleryResponse to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a TItemsListHeader. */
                interface ITItemsListHeader {

                    /** TItemsListHeader Text */
                    Text?: (string|null);
                }

                /** Represents a TItemsListHeader. */
                class TItemsListHeader implements ITItemsListHeader {

                    /**
                     * Constructs a new TItemsListHeader.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: NAlice.NData.TDialogovoSkillCardData.TSkillResponse.ITItemsListHeader);

                    /** TItemsListHeader Text. */
                    public Text: string;

                    /**
                     * Creates a new TItemsListHeader instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns TItemsListHeader instance
                     */
                    public static create(properties?: NAlice.NData.TDialogovoSkillCardData.TSkillResponse.ITItemsListHeader): NAlice.NData.TDialogovoSkillCardData.TSkillResponse.TItemsListHeader;

                    /**
                     * Encodes the specified TItemsListHeader message. Does not implicitly {@link NAlice.NData.TDialogovoSkillCardData.TSkillResponse.TItemsListHeader.verify|verify} messages.
                     * @param message TItemsListHeader message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: NAlice.NData.TDialogovoSkillCardData.TSkillResponse.ITItemsListHeader, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified TItemsListHeader message, length delimited. Does not implicitly {@link NAlice.NData.TDialogovoSkillCardData.TSkillResponse.TItemsListHeader.verify|verify} messages.
                     * @param message TItemsListHeader message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: NAlice.NData.TDialogovoSkillCardData.TSkillResponse.ITItemsListHeader, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a TItemsListHeader message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns TItemsListHeader
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TDialogovoSkillCardData.TSkillResponse.TItemsListHeader;

                    /**
                     * Decodes a TItemsListHeader message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns TItemsListHeader
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TDialogovoSkillCardData.TSkillResponse.TItemsListHeader;

                    /**
                     * Verifies a TItemsListHeader message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a TItemsListHeader message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns TItemsListHeader
                     */
                    public static fromObject(object: { [k: string]: any }): NAlice.NData.TDialogovoSkillCardData.TSkillResponse.TItemsListHeader;

                    /**
                     * Creates a plain object from a TItemsListHeader message. Also converts values to other types if specified.
                     * @param message TItemsListHeader
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: NAlice.NData.TDialogovoSkillCardData.TSkillResponse.TItemsListHeader, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this TItemsListHeader to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a TItemsListFooter. */
                interface ITItemsListFooter {

                    /** TItemsListFooter Text */
                    Text?: (string|null);

                    /** TItemsListFooter Button */
                    Button?: (NAlice.NData.TDialogovoSkillCardData.TSkillResponse.ITButton|null);
                }

                /** Represents a TItemsListFooter. */
                class TItemsListFooter implements ITItemsListFooter {

                    /**
                     * Constructs a new TItemsListFooter.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: NAlice.NData.TDialogovoSkillCardData.TSkillResponse.ITItemsListFooter);

                    /** TItemsListFooter Text. */
                    public Text: string;

                    /** TItemsListFooter Button. */
                    public Button?: (NAlice.NData.TDialogovoSkillCardData.TSkillResponse.ITButton|null);

                    /**
                     * Creates a new TItemsListFooter instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns TItemsListFooter instance
                     */
                    public static create(properties?: NAlice.NData.TDialogovoSkillCardData.TSkillResponse.ITItemsListFooter): NAlice.NData.TDialogovoSkillCardData.TSkillResponse.TItemsListFooter;

                    /**
                     * Encodes the specified TItemsListFooter message. Does not implicitly {@link NAlice.NData.TDialogovoSkillCardData.TSkillResponse.TItemsListFooter.verify|verify} messages.
                     * @param message TItemsListFooter message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: NAlice.NData.TDialogovoSkillCardData.TSkillResponse.ITItemsListFooter, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified TItemsListFooter message, length delimited. Does not implicitly {@link NAlice.NData.TDialogovoSkillCardData.TSkillResponse.TItemsListFooter.verify|verify} messages.
                     * @param message TItemsListFooter message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: NAlice.NData.TDialogovoSkillCardData.TSkillResponse.ITItemsListFooter, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a TItemsListFooter message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns TItemsListFooter
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TDialogovoSkillCardData.TSkillResponse.TItemsListFooter;

                    /**
                     * Decodes a TItemsListFooter message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns TItemsListFooter
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TDialogovoSkillCardData.TSkillResponse.TItemsListFooter;

                    /**
                     * Verifies a TItemsListFooter message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a TItemsListFooter message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns TItemsListFooter
                     */
                    public static fromObject(object: { [k: string]: any }): NAlice.NData.TDialogovoSkillCardData.TSkillResponse.TItemsListFooter;

                    /**
                     * Creates a plain object from a TItemsListFooter message. Also converts values to other types if specified.
                     * @param message TItemsListFooter
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: NAlice.NData.TDialogovoSkillCardData.TSkillResponse.TItemsListFooter, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this TItemsListFooter to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a TItemsListResponse. */
                interface ITItemsListResponse {

                    /** TItemsListResponse ItemsLisetHeader */
                    ItemsLisetHeader?: (NAlice.NData.TDialogovoSkillCardData.TSkillResponse.ITItemsListHeader|null);

                    /** TItemsListResponse ImageItems */
                    ImageItems?: (NAlice.NData.TDialogovoSkillCardData.TSkillResponse.ITImageItem[]|null);

                    /** TItemsListResponse ItemsLisetFooter */
                    ItemsLisetFooter?: (NAlice.NData.TDialogovoSkillCardData.TSkillResponse.ITItemsListFooter|null);
                }

                /** Represents a TItemsListResponse. */
                class TItemsListResponse implements ITItemsListResponse {

                    /**
                     * Constructs a new TItemsListResponse.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: NAlice.NData.TDialogovoSkillCardData.TSkillResponse.ITItemsListResponse);

                    /** TItemsListResponse ItemsLisetHeader. */
                    public ItemsLisetHeader?: (NAlice.NData.TDialogovoSkillCardData.TSkillResponse.ITItemsListHeader|null);

                    /** TItemsListResponse ImageItems. */
                    public ImageItems: NAlice.NData.TDialogovoSkillCardData.TSkillResponse.ITImageItem[];

                    /** TItemsListResponse ItemsLisetFooter. */
                    public ItemsLisetFooter?: (NAlice.NData.TDialogovoSkillCardData.TSkillResponse.ITItemsListFooter|null);

                    /**
                     * Creates a new TItemsListResponse instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns TItemsListResponse instance
                     */
                    public static create(properties?: NAlice.NData.TDialogovoSkillCardData.TSkillResponse.ITItemsListResponse): NAlice.NData.TDialogovoSkillCardData.TSkillResponse.TItemsListResponse;

                    /**
                     * Encodes the specified TItemsListResponse message. Does not implicitly {@link NAlice.NData.TDialogovoSkillCardData.TSkillResponse.TItemsListResponse.verify|verify} messages.
                     * @param message TItemsListResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: NAlice.NData.TDialogovoSkillCardData.TSkillResponse.ITItemsListResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified TItemsListResponse message, length delimited. Does not implicitly {@link NAlice.NData.TDialogovoSkillCardData.TSkillResponse.TItemsListResponse.verify|verify} messages.
                     * @param message TItemsListResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: NAlice.NData.TDialogovoSkillCardData.TSkillResponse.ITItemsListResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a TItemsListResponse message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns TItemsListResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TDialogovoSkillCardData.TSkillResponse.TItemsListResponse;

                    /**
                     * Decodes a TItemsListResponse message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns TItemsListResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TDialogovoSkillCardData.TSkillResponse.TItemsListResponse;

                    /**
                     * Verifies a TItemsListResponse message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a TItemsListResponse message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns TItemsListResponse
                     */
                    public static fromObject(object: { [k: string]: any }): NAlice.NData.TDialogovoSkillCardData.TSkillResponse.TItemsListResponse;

                    /**
                     * Creates a plain object from a TItemsListResponse message. Also converts values to other types if specified.
                     * @param message TItemsListResponse
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: NAlice.NData.TDialogovoSkillCardData.TSkillResponse.TItemsListResponse, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this TItemsListResponse to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }
            }
        }

        /** Properties of a TDialogovoSkillTeaserData. */
        interface ITDialogovoSkillTeaserData {

            /** TDialogovoSkillTeaserData SkillInfo */
            SkillInfo?: (NAlice.NData.TDialogovoSkillTeaserData.ITSkillInfo|null);

            /** TDialogovoSkillTeaserData ImageUrl */
            ImageUrl?: (string|null);

            /** TDialogovoSkillTeaserData Text */
            Text?: (string|null);

            /** TDialogovoSkillTeaserData Title */
            Title?: (string|null);

            /** TDialogovoSkillTeaserData Action */
            Action?: (string|null);
        }

        /** Represents a TDialogovoSkillTeaserData. */
        class TDialogovoSkillTeaserData implements ITDialogovoSkillTeaserData {

            /**
             * Constructs a new TDialogovoSkillTeaserData.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITDialogovoSkillTeaserData);

            /** TDialogovoSkillTeaserData SkillInfo. */
            public SkillInfo?: (NAlice.NData.TDialogovoSkillTeaserData.ITSkillInfo|null);

            /** TDialogovoSkillTeaserData ImageUrl. */
            public ImageUrl: string;

            /** TDialogovoSkillTeaserData Text. */
            public Text: string;

            /** TDialogovoSkillTeaserData Title. */
            public Title: string;

            /** TDialogovoSkillTeaserData Action. */
            public Action: string;

            /**
             * Creates a new TDialogovoSkillTeaserData instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TDialogovoSkillTeaserData instance
             */
            public static create(properties?: NAlice.NData.ITDialogovoSkillTeaserData): NAlice.NData.TDialogovoSkillTeaserData;

            /**
             * Encodes the specified TDialogovoSkillTeaserData message. Does not implicitly {@link NAlice.NData.TDialogovoSkillTeaserData.verify|verify} messages.
             * @param message TDialogovoSkillTeaserData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITDialogovoSkillTeaserData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TDialogovoSkillTeaserData message, length delimited. Does not implicitly {@link NAlice.NData.TDialogovoSkillTeaserData.verify|verify} messages.
             * @param message TDialogovoSkillTeaserData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITDialogovoSkillTeaserData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TDialogovoSkillTeaserData message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TDialogovoSkillTeaserData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TDialogovoSkillTeaserData;

            /**
             * Decodes a TDialogovoSkillTeaserData message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TDialogovoSkillTeaserData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TDialogovoSkillTeaserData;

            /**
             * Verifies a TDialogovoSkillTeaserData message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TDialogovoSkillTeaserData message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TDialogovoSkillTeaserData
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TDialogovoSkillTeaserData;

            /**
             * Creates a plain object from a TDialogovoSkillTeaserData message. Also converts values to other types if specified.
             * @param message TDialogovoSkillTeaserData
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TDialogovoSkillTeaserData, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TDialogovoSkillTeaserData to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        namespace TDialogovoSkillTeaserData {

            /** Properties of a TSkillInfo. */
            interface ITSkillInfo {

                /** TSkillInfo Name */
                Name?: (string|null);

                /** TSkillInfo Logo */
                Logo?: (string|null);

                /** TSkillInfo SkillId */
                SkillId?: (string|null);
            }

            /** Represents a TSkillInfo. */
            class TSkillInfo implements ITSkillInfo {

                /**
                 * Constructs a new TSkillInfo.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: NAlice.NData.TDialogovoSkillTeaserData.ITSkillInfo);

                /** TSkillInfo Name. */
                public Name: string;

                /** TSkillInfo Logo. */
                public Logo: string;

                /** TSkillInfo SkillId. */
                public SkillId: string;

                /**
                 * Creates a new TSkillInfo instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns TSkillInfo instance
                 */
                public static create(properties?: NAlice.NData.TDialogovoSkillTeaserData.ITSkillInfo): NAlice.NData.TDialogovoSkillTeaserData.TSkillInfo;

                /**
                 * Encodes the specified TSkillInfo message. Does not implicitly {@link NAlice.NData.TDialogovoSkillTeaserData.TSkillInfo.verify|verify} messages.
                 * @param message TSkillInfo message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: NAlice.NData.TDialogovoSkillTeaserData.ITSkillInfo, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified TSkillInfo message, length delimited. Does not implicitly {@link NAlice.NData.TDialogovoSkillTeaserData.TSkillInfo.verify|verify} messages.
                 * @param message TSkillInfo message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: NAlice.NData.TDialogovoSkillTeaserData.ITSkillInfo, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a TSkillInfo message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns TSkillInfo
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TDialogovoSkillTeaserData.TSkillInfo;

                /**
                 * Decodes a TSkillInfo message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns TSkillInfo
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TDialogovoSkillTeaserData.TSkillInfo;

                /**
                 * Verifies a TSkillInfo message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a TSkillInfo message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns TSkillInfo
                 */
                public static fromObject(object: { [k: string]: any }): NAlice.NData.TDialogovoSkillTeaserData.TSkillInfo;

                /**
                 * Creates a plain object from a TSkillInfo message. Also converts values to other types if specified.
                 * @param message TSkillInfo
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: NAlice.NData.TDialogovoSkillTeaserData.TSkillInfo, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this TSkillInfo to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }
        }

        /** Properties of a TCentaurUpperShutterData. */
        interface ITCentaurUpperShutterData {

            /** TCentaurUpperShutterData Id */
            Id?: (string|null);

            /** TCentaurUpperShutterData SmartHomeData */
            SmartHomeData?: (NAlice.NData.TCentaurUpperShutterData.ITSmartHomeData|null);
        }

        /** Represents a TCentaurUpperShutterData. */
        class TCentaurUpperShutterData implements ITCentaurUpperShutterData {

            /**
             * Constructs a new TCentaurUpperShutterData.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITCentaurUpperShutterData);

            /** TCentaurUpperShutterData Id. */
            public Id: string;

            /** TCentaurUpperShutterData SmartHomeData. */
            public SmartHomeData?: (NAlice.NData.TCentaurUpperShutterData.ITSmartHomeData|null);

            /**
             * Creates a new TCentaurUpperShutterData instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TCentaurUpperShutterData instance
             */
            public static create(properties?: NAlice.NData.ITCentaurUpperShutterData): NAlice.NData.TCentaurUpperShutterData;

            /**
             * Encodes the specified TCentaurUpperShutterData message. Does not implicitly {@link NAlice.NData.TCentaurUpperShutterData.verify|verify} messages.
             * @param message TCentaurUpperShutterData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITCentaurUpperShutterData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TCentaurUpperShutterData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurUpperShutterData.verify|verify} messages.
             * @param message TCentaurUpperShutterData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITCentaurUpperShutterData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TCentaurUpperShutterData message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TCentaurUpperShutterData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TCentaurUpperShutterData;

            /**
             * Decodes a TCentaurUpperShutterData message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TCentaurUpperShutterData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TCentaurUpperShutterData;

            /**
             * Verifies a TCentaurUpperShutterData message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TCentaurUpperShutterData message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TCentaurUpperShutterData
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TCentaurUpperShutterData;

            /**
             * Creates a plain object from a TCentaurUpperShutterData message. Also converts values to other types if specified.
             * @param message TCentaurUpperShutterData
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TCentaurUpperShutterData, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TCentaurUpperShutterData to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        namespace TCentaurUpperShutterData {

            /** Properties of a TSmartHomeData. */
            interface ITSmartHomeData {

                /** TSmartHomeData Id */
                Id?: (string|null);

                /** TSmartHomeData IoTUserData */
                IoTUserData?: (NAlice.ITIoTUserInfo|null);
            }

            /** Represents a TSmartHomeData. */
            class TSmartHomeData implements ITSmartHomeData {

                /**
                 * Constructs a new TSmartHomeData.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: NAlice.NData.TCentaurUpperShutterData.ITSmartHomeData);

                /** TSmartHomeData Id. */
                public Id: string;

                /** TSmartHomeData IoTUserData. */
                public IoTUserData?: (NAlice.ITIoTUserInfo|null);

                /**
                 * Creates a new TSmartHomeData instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns TSmartHomeData instance
                 */
                public static create(properties?: NAlice.NData.TCentaurUpperShutterData.ITSmartHomeData): NAlice.NData.TCentaurUpperShutterData.TSmartHomeData;

                /**
                 * Encodes the specified TSmartHomeData message. Does not implicitly {@link NAlice.NData.TCentaurUpperShutterData.TSmartHomeData.verify|verify} messages.
                 * @param message TSmartHomeData message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: NAlice.NData.TCentaurUpperShutterData.ITSmartHomeData, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified TSmartHomeData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurUpperShutterData.TSmartHomeData.verify|verify} messages.
                 * @param message TSmartHomeData message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: NAlice.NData.TCentaurUpperShutterData.ITSmartHomeData, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a TSmartHomeData message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns TSmartHomeData
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TCentaurUpperShutterData.TSmartHomeData;

                /**
                 * Decodes a TSmartHomeData message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns TSmartHomeData
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TCentaurUpperShutterData.TSmartHomeData;

                /**
                 * Verifies a TSmartHomeData message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a TSmartHomeData message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns TSmartHomeData
                 */
                public static fromObject(object: { [k: string]: any }): NAlice.NData.TCentaurUpperShutterData.TSmartHomeData;

                /**
                 * Creates a plain object from a TSmartHomeData message. Also converts values to other types if specified.
                 * @param message TSmartHomeData
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: NAlice.NData.TCentaurUpperShutterData.TSmartHomeData, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this TSmartHomeData to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }
        }

        /** Properties of a TCentaurWebviewData. */
        interface ITCentaurWebviewData {

            /** TCentaurWebviewData Id */
            Id?: (string|null);

            /** TCentaurWebviewData WebviewUrl */
            WebviewUrl?: (string|null);

            /** TCentaurWebviewData ShowNavigationBar */
            ShowNavigationBar?: (boolean|null);

            /** TCentaurWebviewData MediaSessionId */
            MediaSessionId?: (string|null);
        }

        /** Represents a TCentaurWebviewData. */
        class TCentaurWebviewData implements ITCentaurWebviewData {

            /**
             * Constructs a new TCentaurWebviewData.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITCentaurWebviewData);

            /** TCentaurWebviewData Id. */
            public Id: string;

            /** TCentaurWebviewData WebviewUrl. */
            public WebviewUrl: string;

            /** TCentaurWebviewData ShowNavigationBar. */
            public ShowNavigationBar: boolean;

            /** TCentaurWebviewData MediaSessionId. */
            public MediaSessionId: string;

            /**
             * Creates a new TCentaurWebviewData instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TCentaurWebviewData instance
             */
            public static create(properties?: NAlice.NData.ITCentaurWebviewData): NAlice.NData.TCentaurWebviewData;

            /**
             * Encodes the specified TCentaurWebviewData message. Does not implicitly {@link NAlice.NData.TCentaurWebviewData.verify|verify} messages.
             * @param message TCentaurWebviewData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITCentaurWebviewData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TCentaurWebviewData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurWebviewData.verify|verify} messages.
             * @param message TCentaurWebviewData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITCentaurWebviewData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TCentaurWebviewData message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TCentaurWebviewData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TCentaurWebviewData;

            /**
             * Decodes a TCentaurWebviewData message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TCentaurWebviewData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TCentaurWebviewData;

            /**
             * Verifies a TCentaurWebviewData message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TCentaurWebviewData message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TCentaurWebviewData
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TCentaurWebviewData;

            /**
             * Creates a plain object from a TCentaurWebviewData message. Also converts values to other types if specified.
             * @param message TCentaurWebviewData
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TCentaurWebviewData, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TCentaurWebviewData to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a TExampleScenarioData. */
        interface ITExampleScenarioData {

            /** TExampleScenarioData hello */
            hello?: (string|null);
        }

        /** Represents a TExampleScenarioData. */
        class TExampleScenarioData implements ITExampleScenarioData {

            /**
             * Constructs a new TExampleScenarioData.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITExampleScenarioData);

            /** TExampleScenarioData hello. */
            public hello: string;

            /**
             * Creates a new TExampleScenarioData instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TExampleScenarioData instance
             */
            public static create(properties?: NAlice.NData.ITExampleScenarioData): NAlice.NData.TExampleScenarioData;

            /**
             * Encodes the specified TExampleScenarioData message. Does not implicitly {@link NAlice.NData.TExampleScenarioData.verify|verify} messages.
             * @param message TExampleScenarioData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITExampleScenarioData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TExampleScenarioData message, length delimited. Does not implicitly {@link NAlice.NData.TExampleScenarioData.verify|verify} messages.
             * @param message TExampleScenarioData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITExampleScenarioData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TExampleScenarioData message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TExampleScenarioData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TExampleScenarioData;

            /**
             * Decodes a TExampleScenarioData message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TExampleScenarioData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TExampleScenarioData;

            /**
             * Verifies a TExampleScenarioData message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TExampleScenarioData message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TExampleScenarioData
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TExampleScenarioData;

            /**
             * Creates a plain object from a TExampleScenarioData message. Also converts values to other types if specified.
             * @param message TExampleScenarioData
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TExampleScenarioData, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TExampleScenarioData to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a TConversationData. */
        interface ITConversationData {
        }

        /** Represents a TConversationData. */
        class TConversationData implements ITConversationData {

            /**
             * Constructs a new TConversationData.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITConversationData);

            /**
             * Creates a new TConversationData instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TConversationData instance
             */
            public static create(properties?: NAlice.NData.ITConversationData): NAlice.NData.TConversationData;

            /**
             * Encodes the specified TConversationData message. Does not implicitly {@link NAlice.NData.TConversationData.verify|verify} messages.
             * @param message TConversationData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITConversationData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TConversationData message, length delimited. Does not implicitly {@link NAlice.NData.TConversationData.verify|verify} messages.
             * @param message TConversationData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITConversationData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TConversationData message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TConversationData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TConversationData;

            /**
             * Decodes a TConversationData message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TConversationData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TConversationData;

            /**
             * Verifies a TConversationData message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TConversationData message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TConversationData
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TConversationData;

            /**
             * Creates a plain object from a TConversationData message. Also converts values to other types if specified.
             * @param message TConversationData
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TConversationData, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TConversationData to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Namespace NMusic. */
        namespace NMusic {

            /** Properties of a TMusicInfiniteFeedData. */
            interface ITMusicInfiniteFeedData {

                /** TMusicInfiniteFeedData MusicObjectsBlocks */
                MusicObjectsBlocks?: (NAlice.NData.NMusic.TMusicInfiniteFeedData.ITMusicObjectsBlock[]|null);
            }

            /** Represents a TMusicInfiniteFeedData. */
            class TMusicInfiniteFeedData implements ITMusicInfiniteFeedData {

                /**
                 * Constructs a new TMusicInfiniteFeedData.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: NAlice.NData.NMusic.ITMusicInfiniteFeedData);

                /** TMusicInfiniteFeedData MusicObjectsBlocks. */
                public MusicObjectsBlocks: NAlice.NData.NMusic.TMusicInfiniteFeedData.ITMusicObjectsBlock[];

                /**
                 * Creates a new TMusicInfiniteFeedData instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns TMusicInfiniteFeedData instance
                 */
                public static create(properties?: NAlice.NData.NMusic.ITMusicInfiniteFeedData): NAlice.NData.NMusic.TMusicInfiniteFeedData;

                /**
                 * Encodes the specified TMusicInfiniteFeedData message. Does not implicitly {@link NAlice.NData.NMusic.TMusicInfiniteFeedData.verify|verify} messages.
                 * @param message TMusicInfiniteFeedData message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: NAlice.NData.NMusic.ITMusicInfiniteFeedData, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified TMusicInfiniteFeedData message, length delimited. Does not implicitly {@link NAlice.NData.NMusic.TMusicInfiniteFeedData.verify|verify} messages.
                 * @param message TMusicInfiniteFeedData message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: NAlice.NData.NMusic.ITMusicInfiniteFeedData, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a TMusicInfiniteFeedData message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns TMusicInfiniteFeedData
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.NMusic.TMusicInfiniteFeedData;

                /**
                 * Decodes a TMusicInfiniteFeedData message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns TMusicInfiniteFeedData
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.NMusic.TMusicInfiniteFeedData;

                /**
                 * Verifies a TMusicInfiniteFeedData message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a TMusicInfiniteFeedData message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns TMusicInfiniteFeedData
                 */
                public static fromObject(object: { [k: string]: any }): NAlice.NData.NMusic.TMusicInfiniteFeedData;

                /**
                 * Creates a plain object from a TMusicInfiniteFeedData message. Also converts values to other types if specified.
                 * @param message TMusicInfiniteFeedData
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: NAlice.NData.NMusic.TMusicInfiniteFeedData, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this TMusicInfiniteFeedData to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }

            namespace TMusicInfiniteFeedData {

                /** Properties of a TAutoPlaylist. */
                interface ITAutoPlaylist {

                    /** TAutoPlaylist Uid */
                    Uid?: (string|null);

                    /** TAutoPlaylist ImageUrl */
                    ImageUrl?: (string|null);

                    /** TAutoPlaylist Title */
                    Title?: (string|null);

                    /** TAutoPlaylist Kind */
                    Kind?: (string|null);

                    /** TAutoPlaylist Modified */
                    Modified?: (string|null);
                }

                /** Represents a TAutoPlaylist. */
                class TAutoPlaylist implements ITAutoPlaylist {

                    /**
                     * Constructs a new TAutoPlaylist.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: NAlice.NData.NMusic.TMusicInfiniteFeedData.ITAutoPlaylist);

                    /** TAutoPlaylist Uid. */
                    public Uid: string;

                    /** TAutoPlaylist ImageUrl. */
                    public ImageUrl: string;

                    /** TAutoPlaylist Title. */
                    public Title: string;

                    /** TAutoPlaylist Kind. */
                    public Kind: string;

                    /** TAutoPlaylist Modified. */
                    public Modified: string;

                    /**
                     * Creates a new TAutoPlaylist instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns TAutoPlaylist instance
                     */
                    public static create(properties?: NAlice.NData.NMusic.TMusicInfiniteFeedData.ITAutoPlaylist): NAlice.NData.NMusic.TMusicInfiniteFeedData.TAutoPlaylist;

                    /**
                     * Encodes the specified TAutoPlaylist message. Does not implicitly {@link NAlice.NData.NMusic.TMusicInfiniteFeedData.TAutoPlaylist.verify|verify} messages.
                     * @param message TAutoPlaylist message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: NAlice.NData.NMusic.TMusicInfiniteFeedData.ITAutoPlaylist, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified TAutoPlaylist message, length delimited. Does not implicitly {@link NAlice.NData.NMusic.TMusicInfiniteFeedData.TAutoPlaylist.verify|verify} messages.
                     * @param message TAutoPlaylist message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: NAlice.NData.NMusic.TMusicInfiniteFeedData.ITAutoPlaylist, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a TAutoPlaylist message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns TAutoPlaylist
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.NMusic.TMusicInfiniteFeedData.TAutoPlaylist;

                    /**
                     * Decodes a TAutoPlaylist message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns TAutoPlaylist
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.NMusic.TMusicInfiniteFeedData.TAutoPlaylist;

                    /**
                     * Verifies a TAutoPlaylist message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a TAutoPlaylist message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns TAutoPlaylist
                     */
                    public static fromObject(object: { [k: string]: any }): NAlice.NData.NMusic.TMusicInfiniteFeedData.TAutoPlaylist;

                    /**
                     * Creates a plain object from a TAutoPlaylist message. Also converts values to other types if specified.
                     * @param message TAutoPlaylist
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: NAlice.NData.NMusic.TMusicInfiniteFeedData.TAutoPlaylist, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this TAutoPlaylist to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a TPlaylist. */
                interface ITPlaylist {

                    /** TPlaylist Uid */
                    Uid?: (string|null);

                    /** TPlaylist ImageUrl */
                    ImageUrl?: (string|null);

                    /** TPlaylist Title */
                    Title?: (string|null);

                    /** TPlaylist Kind */
                    Kind?: (string|null);

                    /** TPlaylist Modified */
                    Modified?: (string|null);

                    /** TPlaylist LikesCount */
                    LikesCount?: (number|null);
                }

                /** Represents a TPlaylist. */
                class TPlaylist implements ITPlaylist {

                    /**
                     * Constructs a new TPlaylist.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: NAlice.NData.NMusic.TMusicInfiniteFeedData.ITPlaylist);

                    /** TPlaylist Uid. */
                    public Uid: string;

                    /** TPlaylist ImageUrl. */
                    public ImageUrl: string;

                    /** TPlaylist Title. */
                    public Title: string;

                    /** TPlaylist Kind. */
                    public Kind: string;

                    /** TPlaylist Modified. */
                    public Modified: string;

                    /** TPlaylist LikesCount. */
                    public LikesCount: number;

                    /**
                     * Creates a new TPlaylist instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns TPlaylist instance
                     */
                    public static create(properties?: NAlice.NData.NMusic.TMusicInfiniteFeedData.ITPlaylist): NAlice.NData.NMusic.TMusicInfiniteFeedData.TPlaylist;

                    /**
                     * Encodes the specified TPlaylist message. Does not implicitly {@link NAlice.NData.NMusic.TMusicInfiniteFeedData.TPlaylist.verify|verify} messages.
                     * @param message TPlaylist message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: NAlice.NData.NMusic.TMusicInfiniteFeedData.ITPlaylist, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified TPlaylist message, length delimited. Does not implicitly {@link NAlice.NData.NMusic.TMusicInfiniteFeedData.TPlaylist.verify|verify} messages.
                     * @param message TPlaylist message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: NAlice.NData.NMusic.TMusicInfiniteFeedData.ITPlaylist, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a TPlaylist message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns TPlaylist
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.NMusic.TMusicInfiniteFeedData.TPlaylist;

                    /**
                     * Decodes a TPlaylist message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns TPlaylist
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.NMusic.TMusicInfiniteFeedData.TPlaylist;

                    /**
                     * Verifies a TPlaylist message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a TPlaylist message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns TPlaylist
                     */
                    public static fromObject(object: { [k: string]: any }): NAlice.NData.NMusic.TMusicInfiniteFeedData.TPlaylist;

                    /**
                     * Creates a plain object from a TPlaylist message. Also converts values to other types if specified.
                     * @param message TPlaylist
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: NAlice.NData.NMusic.TMusicInfiniteFeedData.TPlaylist, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this TPlaylist to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a TArtist. */
                interface ITArtist {

                    /** TArtist Id */
                    Id?: (string|null);

                    /** TArtist Name */
                    Name?: (string|null);

                    /** TArtist ImageUrl */
                    ImageUrl?: (string|null);

                    /** TArtist Genres */
                    Genres?: (string[]|null);
                }

                /** Represents a TArtist. */
                class TArtist implements ITArtist {

                    /**
                     * Constructs a new TArtist.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: NAlice.NData.NMusic.TMusicInfiniteFeedData.ITArtist);

                    /** TArtist Id. */
                    public Id: string;

                    /** TArtist Name. */
                    public Name: string;

                    /** TArtist ImageUrl. */
                    public ImageUrl: string;

                    /** TArtist Genres. */
                    public Genres: string[];

                    /**
                     * Creates a new TArtist instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns TArtist instance
                     */
                    public static create(properties?: NAlice.NData.NMusic.TMusicInfiniteFeedData.ITArtist): NAlice.NData.NMusic.TMusicInfiniteFeedData.TArtist;

                    /**
                     * Encodes the specified TArtist message. Does not implicitly {@link NAlice.NData.NMusic.TMusicInfiniteFeedData.TArtist.verify|verify} messages.
                     * @param message TArtist message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: NAlice.NData.NMusic.TMusicInfiniteFeedData.ITArtist, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified TArtist message, length delimited. Does not implicitly {@link NAlice.NData.NMusic.TMusicInfiniteFeedData.TArtist.verify|verify} messages.
                     * @param message TArtist message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: NAlice.NData.NMusic.TMusicInfiniteFeedData.ITArtist, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a TArtist message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns TArtist
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.NMusic.TMusicInfiniteFeedData.TArtist;

                    /**
                     * Decodes a TArtist message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns TArtist
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.NMusic.TMusicInfiniteFeedData.TArtist;

                    /**
                     * Verifies a TArtist message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a TArtist message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns TArtist
                     */
                    public static fromObject(object: { [k: string]: any }): NAlice.NData.NMusic.TMusicInfiniteFeedData.TArtist;

                    /**
                     * Creates a plain object from a TArtist message. Also converts values to other types if specified.
                     * @param message TArtist
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: NAlice.NData.NMusic.TMusicInfiniteFeedData.TArtist, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this TArtist to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a TAlbum. */
                interface ITAlbum {

                    /** TAlbum Id */
                    Id?: (string|null);

                    /** TAlbum ImageUrl */
                    ImageUrl?: (string|null);

                    /** TAlbum Title */
                    Title?: (string|null);

                    /** TAlbum ReleaseDate */
                    ReleaseDate?: (string|null);

                    /** TAlbum LikesCount */
                    LikesCount?: (number|null);

                    /** TAlbum Artists */
                    Artists?: (NAlice.NData.NMusic.TMusicInfiniteFeedData.ITArtist[]|null);
                }

                /** Represents a TAlbum. */
                class TAlbum implements ITAlbum {

                    /**
                     * Constructs a new TAlbum.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: NAlice.NData.NMusic.TMusicInfiniteFeedData.ITAlbum);

                    /** TAlbum Id. */
                    public Id: string;

                    /** TAlbum ImageUrl. */
                    public ImageUrl: string;

                    /** TAlbum Title. */
                    public Title: string;

                    /** TAlbum ReleaseDate. */
                    public ReleaseDate: string;

                    /** TAlbum LikesCount. */
                    public LikesCount: number;

                    /** TAlbum Artists. */
                    public Artists: NAlice.NData.NMusic.TMusicInfiniteFeedData.ITArtist[];

                    /**
                     * Creates a new TAlbum instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns TAlbum instance
                     */
                    public static create(properties?: NAlice.NData.NMusic.TMusicInfiniteFeedData.ITAlbum): NAlice.NData.NMusic.TMusicInfiniteFeedData.TAlbum;

                    /**
                     * Encodes the specified TAlbum message. Does not implicitly {@link NAlice.NData.NMusic.TMusicInfiniteFeedData.TAlbum.verify|verify} messages.
                     * @param message TAlbum message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: NAlice.NData.NMusic.TMusicInfiniteFeedData.ITAlbum, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified TAlbum message, length delimited. Does not implicitly {@link NAlice.NData.NMusic.TMusicInfiniteFeedData.TAlbum.verify|verify} messages.
                     * @param message TAlbum message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: NAlice.NData.NMusic.TMusicInfiniteFeedData.ITAlbum, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a TAlbum message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns TAlbum
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.NMusic.TMusicInfiniteFeedData.TAlbum;

                    /**
                     * Decodes a TAlbum message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns TAlbum
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.NMusic.TMusicInfiniteFeedData.TAlbum;

                    /**
                     * Verifies a TAlbum message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a TAlbum message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns TAlbum
                     */
                    public static fromObject(object: { [k: string]: any }): NAlice.NData.NMusic.TMusicInfiniteFeedData.TAlbum;

                    /**
                     * Creates a plain object from a TAlbum message. Also converts values to other types if specified.
                     * @param message TAlbum
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: NAlice.NData.NMusic.TMusicInfiniteFeedData.TAlbum, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this TAlbum to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a TMusicObject. */
                interface ITMusicObject {

                    /** TMusicObject AutoPlaylist */
                    AutoPlaylist?: (NAlice.NData.NMusic.TMusicInfiniteFeedData.ITAutoPlaylist|null);

                    /** TMusicObject Playlist */
                    Playlist?: (NAlice.NData.NMusic.TMusicInfiniteFeedData.ITPlaylist|null);

                    /** TMusicObject Artist */
                    Artist?: (NAlice.NData.NMusic.TMusicInfiniteFeedData.ITArtist|null);

                    /** TMusicObject Album */
                    Album?: (NAlice.NData.NMusic.TMusicInfiniteFeedData.ITAlbum|null);
                }

                /** Represents a TMusicObject. */
                class TMusicObject implements ITMusicObject {

                    /**
                     * Constructs a new TMusicObject.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: NAlice.NData.NMusic.TMusicInfiniteFeedData.ITMusicObject);

                    /** TMusicObject AutoPlaylist. */
                    public AutoPlaylist?: (NAlice.NData.NMusic.TMusicInfiniteFeedData.ITAutoPlaylist|null);

                    /** TMusicObject Playlist. */
                    public Playlist?: (NAlice.NData.NMusic.TMusicInfiniteFeedData.ITPlaylist|null);

                    /** TMusicObject Artist. */
                    public Artist?: (NAlice.NData.NMusic.TMusicInfiniteFeedData.ITArtist|null);

                    /** TMusicObject Album. */
                    public Album?: (NAlice.NData.NMusic.TMusicInfiniteFeedData.ITAlbum|null);

                    /** TMusicObject Object. */
                    public Object?: ("AutoPlaylist"|"Playlist"|"Artist"|"Album");

                    /**
                     * Creates a new TMusicObject instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns TMusicObject instance
                     */
                    public static create(properties?: NAlice.NData.NMusic.TMusicInfiniteFeedData.ITMusicObject): NAlice.NData.NMusic.TMusicInfiniteFeedData.TMusicObject;

                    /**
                     * Encodes the specified TMusicObject message. Does not implicitly {@link NAlice.NData.NMusic.TMusicInfiniteFeedData.TMusicObject.verify|verify} messages.
                     * @param message TMusicObject message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: NAlice.NData.NMusic.TMusicInfiniteFeedData.ITMusicObject, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified TMusicObject message, length delimited. Does not implicitly {@link NAlice.NData.NMusic.TMusicInfiniteFeedData.TMusicObject.verify|verify} messages.
                     * @param message TMusicObject message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: NAlice.NData.NMusic.TMusicInfiniteFeedData.ITMusicObject, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a TMusicObject message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns TMusicObject
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.NMusic.TMusicInfiniteFeedData.TMusicObject;

                    /**
                     * Decodes a TMusicObject message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns TMusicObject
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.NMusic.TMusicInfiniteFeedData.TMusicObject;

                    /**
                     * Verifies a TMusicObject message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a TMusicObject message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns TMusicObject
                     */
                    public static fromObject(object: { [k: string]: any }): NAlice.NData.NMusic.TMusicInfiniteFeedData.TMusicObject;

                    /**
                     * Creates a plain object from a TMusicObject message. Also converts values to other types if specified.
                     * @param message TMusicObject
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: NAlice.NData.NMusic.TMusicInfiniteFeedData.TMusicObject, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this TMusicObject to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a TMusicObjectsBlock. */
                interface ITMusicObjectsBlock {

                    /** TMusicObjectsBlock Title */
                    Title?: (string|null);

                    /** TMusicObjectsBlock Type */
                    Type?: (string|null);

                    /** TMusicObjectsBlock MusicObjects */
                    MusicObjects?: (NAlice.NData.NMusic.TMusicInfiniteFeedData.ITMusicObject[]|null);
                }

                /** Represents a TMusicObjectsBlock. */
                class TMusicObjectsBlock implements ITMusicObjectsBlock {

                    /**
                     * Constructs a new TMusicObjectsBlock.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: NAlice.NData.NMusic.TMusicInfiniteFeedData.ITMusicObjectsBlock);

                    /** TMusicObjectsBlock Title. */
                    public Title: string;

                    /** TMusicObjectsBlock Type. */
                    public Type: string;

                    /** TMusicObjectsBlock MusicObjects. */
                    public MusicObjects: NAlice.NData.NMusic.TMusicInfiniteFeedData.ITMusicObject[];

                    /**
                     * Creates a new TMusicObjectsBlock instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns TMusicObjectsBlock instance
                     */
                    public static create(properties?: NAlice.NData.NMusic.TMusicInfiniteFeedData.ITMusicObjectsBlock): NAlice.NData.NMusic.TMusicInfiniteFeedData.TMusicObjectsBlock;

                    /**
                     * Encodes the specified TMusicObjectsBlock message. Does not implicitly {@link NAlice.NData.NMusic.TMusicInfiniteFeedData.TMusicObjectsBlock.verify|verify} messages.
                     * @param message TMusicObjectsBlock message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: NAlice.NData.NMusic.TMusicInfiniteFeedData.ITMusicObjectsBlock, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified TMusicObjectsBlock message, length delimited. Does not implicitly {@link NAlice.NData.NMusic.TMusicInfiniteFeedData.TMusicObjectsBlock.verify|verify} messages.
                     * @param message TMusicObjectsBlock message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: NAlice.NData.NMusic.TMusicInfiniteFeedData.ITMusicObjectsBlock, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a TMusicObjectsBlock message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns TMusicObjectsBlock
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.NMusic.TMusicInfiniteFeedData.TMusicObjectsBlock;

                    /**
                     * Decodes a TMusicObjectsBlock message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns TMusicObjectsBlock
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.NMusic.TMusicInfiniteFeedData.TMusicObjectsBlock;

                    /**
                     * Verifies a TMusicObjectsBlock message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a TMusicObjectsBlock message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns TMusicObjectsBlock
                     */
                    public static fromObject(object: { [k: string]: any }): NAlice.NData.NMusic.TMusicInfiniteFeedData.TMusicObjectsBlock;

                    /**
                     * Creates a plain object from a TMusicObjectsBlock message. Also converts values to other types if specified.
                     * @param message TMusicObjectsBlock
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: NAlice.NData.NMusic.TMusicInfiniteFeedData.TMusicObjectsBlock, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this TMusicObjectsBlock to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }
            }

            /** Properties of a TContentId. */
            interface ITContentId {

                /** TContentId Type */
                Type?: (NAlice.NData.NMusic.TContentId.EContentType|null);

                /** TContentId Id */
                Id?: (string|null);

                /** TContentId Ids */
                Ids?: (string[]|null);
            }

            /** Represents a TContentId. */
            class TContentId implements ITContentId {

                /**
                 * Constructs a new TContentId.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: NAlice.NData.NMusic.ITContentId);

                /** TContentId Type. */
                public Type: NAlice.NData.NMusic.TContentId.EContentType;

                /** TContentId Id. */
                public Id: string;

                /** TContentId Ids. */
                public Ids: string[];

                /**
                 * Creates a new TContentId instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns TContentId instance
                 */
                public static create(properties?: NAlice.NData.NMusic.ITContentId): NAlice.NData.NMusic.TContentId;

                /**
                 * Encodes the specified TContentId message. Does not implicitly {@link NAlice.NData.NMusic.TContentId.verify|verify} messages.
                 * @param message TContentId message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: NAlice.NData.NMusic.ITContentId, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified TContentId message, length delimited. Does not implicitly {@link NAlice.NData.NMusic.TContentId.verify|verify} messages.
                 * @param message TContentId message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: NAlice.NData.NMusic.ITContentId, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a TContentId message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns TContentId
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.NMusic.TContentId;

                /**
                 * Decodes a TContentId message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns TContentId
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.NMusic.TContentId;

                /**
                 * Verifies a TContentId message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a TContentId message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns TContentId
                 */
                public static fromObject(object: { [k: string]: any }): NAlice.NData.NMusic.TContentId;

                /**
                 * Creates a plain object from a TContentId message. Also converts values to other types if specified.
                 * @param message TContentId
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: NAlice.NData.NMusic.TContentId, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this TContentId to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }

            namespace TContentId {

                /** EContentType enum. */
                enum EContentType {
                    Track = 0,
                    Album = 1,
                    Artist = 2,
                    Playlist = 3,
                    Radio = 4,
                    Generative = 5,
                    FmRadio = 6
                }
            }

            /** Properties of a TContentInfo. */
            interface ITContentInfo {

                /** TContentInfo Name */
                Name?: (string|null);

                /** TContentInfo Title */
                Title?: (string|null);
            }

            /** Represents a TContentInfo. */
            class TContentInfo implements ITContentInfo {

                /**
                 * Constructs a new TContentInfo.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: NAlice.NData.NMusic.ITContentInfo);

                /** TContentInfo Name. */
                public Name?: (string|null);

                /** TContentInfo Title. */
                public Title?: (string|null);

                /** TContentInfo EntityName. */
                public EntityName?: ("Name"|"Title");

                /**
                 * Creates a new TContentInfo instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns TContentInfo instance
                 */
                public static create(properties?: NAlice.NData.NMusic.ITContentInfo): NAlice.NData.NMusic.TContentInfo;

                /**
                 * Encodes the specified TContentInfo message. Does not implicitly {@link NAlice.NData.NMusic.TContentInfo.verify|verify} messages.
                 * @param message TContentInfo message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: NAlice.NData.NMusic.ITContentInfo, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified TContentInfo message, length delimited. Does not implicitly {@link NAlice.NData.NMusic.TContentInfo.verify|verify} messages.
                 * @param message TContentInfo message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: NAlice.NData.NMusic.ITContentInfo, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a TContentInfo message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns TContentInfo
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.NMusic.TContentInfo;

                /**
                 * Decodes a TContentInfo message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns TContentInfo
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.NMusic.TContentInfo;

                /**
                 * Verifies a TContentInfo message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a TContentInfo message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns TContentInfo
                 */
                public static fromObject(object: { [k: string]: any }): NAlice.NData.NMusic.TContentInfo;

                /**
                 * Creates a plain object from a TContentInfo message. Also converts values to other types if specified.
                 * @param message TContentInfo
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: NAlice.NData.NMusic.TContentInfo, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this TContentInfo to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }

            /** Properties of a TTopic. */
            interface ITTopic {

                /** TTopic Podcast */
                Podcast?: (string|null);
            }

            /** Represents a TTopic. */
            class TTopic implements ITTopic {

                /**
                 * Constructs a new TTopic.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: NAlice.NData.NMusic.ITTopic);

                /** TTopic Podcast. */
                public Podcast: string;

                /**
                 * Creates a new TTopic instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns TTopic instance
                 */
                public static create(properties?: NAlice.NData.NMusic.ITTopic): NAlice.NData.NMusic.TTopic;

                /**
                 * Encodes the specified TTopic message. Does not implicitly {@link NAlice.NData.NMusic.TTopic.verify|verify} messages.
                 * @param message TTopic message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: NAlice.NData.NMusic.ITTopic, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified TTopic message, length delimited. Does not implicitly {@link NAlice.NData.NMusic.TTopic.verify|verify} messages.
                 * @param message TTopic message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: NAlice.NData.NMusic.ITTopic, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a TTopic message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns TTopic
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.NMusic.TTopic;

                /**
                 * Decodes a TTopic message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns TTopic
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.NMusic.TTopic;

                /**
                 * Verifies a TTopic message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a TTopic message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns TTopic
                 */
                public static fromObject(object: { [k: string]: any }): NAlice.NData.NMusic.TTopic;

                /**
                 * Creates a plain object from a TTopic message. Also converts values to other types if specified.
                 * @param message TTopic
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: NAlice.NData.NMusic.TTopic, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this TTopic to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }

            /** Properties of a TUserConfig. */
            interface ITUserConfig {

                /** TUserConfig AnnounceTracks */
                AnnounceTracks?: (boolean|null);
            }

            /** Represents a TUserConfig. */
            class TUserConfig implements ITUserConfig {

                /**
                 * Constructs a new TUserConfig.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: NAlice.NData.NMusic.ITUserConfig);

                /** TUserConfig AnnounceTracks. */
                public AnnounceTracks: boolean;

                /**
                 * Creates a new TUserConfig instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns TUserConfig instance
                 */
                public static create(properties?: NAlice.NData.NMusic.ITUserConfig): NAlice.NData.NMusic.TUserConfig;

                /**
                 * Encodes the specified TUserConfig message. Does not implicitly {@link NAlice.NData.NMusic.TUserConfig.verify|verify} messages.
                 * @param message TUserConfig message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: NAlice.NData.NMusic.ITUserConfig, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified TUserConfig message, length delimited. Does not implicitly {@link NAlice.NData.NMusic.TUserConfig.verify|verify} messages.
                 * @param message TUserConfig message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: NAlice.NData.NMusic.ITUserConfig, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a TUserConfig message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns TUserConfig
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.NMusic.TUserConfig;

                /**
                 * Decodes a TUserConfig message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns TUserConfig
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.NMusic.TUserConfig;

                /**
                 * Verifies a TUserConfig message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a TUserConfig message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns TUserConfig
                 */
                public static fromObject(object: { [k: string]: any }): NAlice.NData.NMusic.TUserConfig;

                /**
                 * Creates a plain object from a TUserConfig message. Also converts values to other types if specified.
                 * @param message TUserConfig
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: NAlice.NData.NMusic.TUserConfig, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this TUserConfig to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }
        }

        /** Properties of a TQueueItem. */
        interface ITQueueItem {

            /** TQueueItem Id */
            Id?: (string|null);

            /** TQueueItem Title */
            Title?: (string|null);

            /** TQueueItem Subtype */
            Subtype?: (string|null);

            /** TQueueItem ArtImageUrl */
            ArtImageUrl?: (string|null);

            /** TQueueItem Artists */
            Artists?: (NAlice.NData.ITArtist[]|null);

            /** TQueueItem DurationMs */
            DurationMs?: (number|null);

            /** TQueueItem TrackInfo */
            TrackInfo?: (NAlice.NData.TQueueItem.ITTrackInfo|null);

            /** TQueueItem FmRadioInfo */
            FmRadioInfo?: (NAlice.NData.TQueueItem.ITFmRadioInfo|null);
        }

        /** Represents a TQueueItem. */
        class TQueueItem implements ITQueueItem {

            /**
             * Constructs a new TQueueItem.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITQueueItem);

            /** TQueueItem Id. */
            public Id: string;

            /** TQueueItem Title. */
            public Title: string;

            /** TQueueItem Subtype. */
            public Subtype: string;

            /** TQueueItem ArtImageUrl. */
            public ArtImageUrl: string;

            /** TQueueItem Artists. */
            public Artists: NAlice.NData.ITArtist[];

            /** TQueueItem DurationMs. */
            public DurationMs: number;

            /** TQueueItem TrackInfo. */
            public TrackInfo?: (NAlice.NData.TQueueItem.ITTrackInfo|null);

            /** TQueueItem FmRadioInfo. */
            public FmRadioInfo?: (NAlice.NData.TQueueItem.ITFmRadioInfo|null);

            /** TQueueItem ItemInformation. */
            public ItemInformation?: ("TrackInfo"|"FmRadioInfo");

            /**
             * Creates a new TQueueItem instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TQueueItem instance
             */
            public static create(properties?: NAlice.NData.ITQueueItem): NAlice.NData.TQueueItem;

            /**
             * Encodes the specified TQueueItem message. Does not implicitly {@link NAlice.NData.TQueueItem.verify|verify} messages.
             * @param message TQueueItem message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITQueueItem, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TQueueItem message, length delimited. Does not implicitly {@link NAlice.NData.TQueueItem.verify|verify} messages.
             * @param message TQueueItem message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITQueueItem, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TQueueItem message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TQueueItem
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TQueueItem;

            /**
             * Decodes a TQueueItem message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TQueueItem
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TQueueItem;

            /**
             * Verifies a TQueueItem message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TQueueItem message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TQueueItem
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TQueueItem;

            /**
             * Creates a plain object from a TQueueItem message. Also converts values to other types if specified.
             * @param message TQueueItem
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TQueueItem, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TQueueItem to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        namespace TQueueItem {

            /** Properties of a TTrackInfo. */
            interface ITTrackInfo {

                /** TTrackInfo LikeStatus */
                LikeStatus?: (NAlice.NData.TQueueItem.TTrackInfo.ELikeStatus|null);

                /** TTrackInfo AlbumId */
                AlbumId?: (string|null);
            }

            /** Represents a TTrackInfo. */
            class TTrackInfo implements ITTrackInfo {

                /**
                 * Constructs a new TTrackInfo.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: NAlice.NData.TQueueItem.ITTrackInfo);

                /** TTrackInfo LikeStatus. */
                public LikeStatus: NAlice.NData.TQueueItem.TTrackInfo.ELikeStatus;

                /** TTrackInfo AlbumId. */
                public AlbumId: string;

                /**
                 * Creates a new TTrackInfo instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns TTrackInfo instance
                 */
                public static create(properties?: NAlice.NData.TQueueItem.ITTrackInfo): NAlice.NData.TQueueItem.TTrackInfo;

                /**
                 * Encodes the specified TTrackInfo message. Does not implicitly {@link NAlice.NData.TQueueItem.TTrackInfo.verify|verify} messages.
                 * @param message TTrackInfo message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: NAlice.NData.TQueueItem.ITTrackInfo, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified TTrackInfo message, length delimited. Does not implicitly {@link NAlice.NData.TQueueItem.TTrackInfo.verify|verify} messages.
                 * @param message TTrackInfo message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: NAlice.NData.TQueueItem.ITTrackInfo, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a TTrackInfo message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns TTrackInfo
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TQueueItem.TTrackInfo;

                /**
                 * Decodes a TTrackInfo message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns TTrackInfo
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TQueueItem.TTrackInfo;

                /**
                 * Verifies a TTrackInfo message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a TTrackInfo message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns TTrackInfo
                 */
                public static fromObject(object: { [k: string]: any }): NAlice.NData.TQueueItem.TTrackInfo;

                /**
                 * Creates a plain object from a TTrackInfo message. Also converts values to other types if specified.
                 * @param message TTrackInfo
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: NAlice.NData.TQueueItem.TTrackInfo, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this TTrackInfo to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }

            namespace TTrackInfo {

                /** ELikeStatus enum. */
                enum ELikeStatus {
                    Undefined = 0,
                    None = 1,
                    Liked = 2,
                    Disliked = 3
                }
            }

            /** Properties of a TFmRadioInfo. */
            interface ITFmRadioInfo {

                /** TFmRadioInfo Frequency */
                Frequency?: (string|null);

                /** TFmRadioInfo Color */
                Color?: (string|null);
            }

            /** Represents a TFmRadioInfo. */
            class TFmRadioInfo implements ITFmRadioInfo {

                /**
                 * Constructs a new TFmRadioInfo.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: NAlice.NData.TQueueItem.ITFmRadioInfo);

                /** TFmRadioInfo Frequency. */
                public Frequency: string;

                /** TFmRadioInfo Color. */
                public Color: string;

                /**
                 * Creates a new TFmRadioInfo instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns TFmRadioInfo instance
                 */
                public static create(properties?: NAlice.NData.TQueueItem.ITFmRadioInfo): NAlice.NData.TQueueItem.TFmRadioInfo;

                /**
                 * Encodes the specified TFmRadioInfo message. Does not implicitly {@link NAlice.NData.TQueueItem.TFmRadioInfo.verify|verify} messages.
                 * @param message TFmRadioInfo message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: NAlice.NData.TQueueItem.ITFmRadioInfo, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified TFmRadioInfo message, length delimited. Does not implicitly {@link NAlice.NData.TQueueItem.TFmRadioInfo.verify|verify} messages.
                 * @param message TFmRadioInfo message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: NAlice.NData.TQueueItem.ITFmRadioInfo, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a TFmRadioInfo message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns TFmRadioInfo
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TQueueItem.TFmRadioInfo;

                /**
                 * Decodes a TFmRadioInfo message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns TFmRadioInfo
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TQueueItem.TFmRadioInfo;

                /**
                 * Verifies a TFmRadioInfo message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a TFmRadioInfo message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns TFmRadioInfo
                 */
                public static fromObject(object: { [k: string]: any }): NAlice.NData.TQueueItem.TFmRadioInfo;

                /**
                 * Creates a plain object from a TFmRadioInfo message. Also converts values to other types if specified.
                 * @param message TFmRadioInfo
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: NAlice.NData.TQueueItem.TFmRadioInfo, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this TFmRadioInfo to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }
        }

        /** Properties of a TColors. */
        interface ITColors {

            /** TColors MainColor */
            MainColor?: (string|null);

            /** TColors SecondColor */
            SecondColor?: (string|null);
        }

        /** Represents a TColors. */
        class TColors implements ITColors {

            /**
             * Constructs a new TColors.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITColors);

            /** TColors MainColor. */
            public MainColor: string;

            /** TColors SecondColor. */
            public SecondColor: string;

            /**
             * Creates a new TColors instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TColors instance
             */
            public static create(properties?: NAlice.NData.ITColors): NAlice.NData.TColors;

            /**
             * Encodes the specified TColors message. Does not implicitly {@link NAlice.NData.TColors.verify|verify} messages.
             * @param message TColors message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITColors, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TColors message, length delimited. Does not implicitly {@link NAlice.NData.TColors.verify|verify} messages.
             * @param message TColors message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITColors, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TColors message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TColors
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TColors;

            /**
             * Decodes a TColors message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TColors
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TColors;

            /**
             * Verifies a TColors message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TColors message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TColors
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TColors;

            /**
             * Creates a plain object from a TColors message. Also converts values to other types if specified.
             * @param message TColors
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TColors, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TColors to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** ERepeatMode enum. */
        enum ERepeatMode {
            NONE = 0,
            TRACK = 1,
            ALL = 2
        }

        /** Properties of a TMusicPlayerData. */
        interface ITMusicPlayerData {

            /** TMusicPlayerData Track */
            Track?: (NAlice.NData.ITTrack|null);

            /** TMusicPlayerData ShuffleModeOn */
            ShuffleModeOn?: (boolean|null);

            /** TMusicPlayerData RepeatMode */
            RepeatMode?: (NAlice.NData.ERepeatMode|null);

            /** TMusicPlayerData ContentId */
            ContentId?: (NAlice.NData.NMusic.ITContentId|null);

            /** TMusicPlayerData ContentInfo */
            ContentInfo?: (NAlice.NData.NMusic.ITContentInfo|null);

            /** TMusicPlayerData QueueItems */
            QueueItems?: (NAlice.NData.ITQueueItem[]|null);

            /** TMusicPlayerData Colors */
            Colors?: (NAlice.NData.ITColors|null);
        }

        /** Represents a TMusicPlayerData. */
        class TMusicPlayerData implements ITMusicPlayerData {

            /**
             * Constructs a new TMusicPlayerData.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITMusicPlayerData);

            /** TMusicPlayerData Track. */
            public Track?: (NAlice.NData.ITTrack|null);

            /** TMusicPlayerData ShuffleModeOn. */
            public ShuffleModeOn: boolean;

            /** TMusicPlayerData RepeatMode. */
            public RepeatMode: NAlice.NData.ERepeatMode;

            /** TMusicPlayerData ContentId. */
            public ContentId?: (NAlice.NData.NMusic.ITContentId|null);

            /** TMusicPlayerData ContentInfo. */
            public ContentInfo?: (NAlice.NData.NMusic.ITContentInfo|null);

            /** TMusicPlayerData QueueItems. */
            public QueueItems: NAlice.NData.ITQueueItem[];

            /** TMusicPlayerData Colors. */
            public Colors?: (NAlice.NData.ITColors|null);

            /**
             * Creates a new TMusicPlayerData instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TMusicPlayerData instance
             */
            public static create(properties?: NAlice.NData.ITMusicPlayerData): NAlice.NData.TMusicPlayerData;

            /**
             * Encodes the specified TMusicPlayerData message. Does not implicitly {@link NAlice.NData.TMusicPlayerData.verify|verify} messages.
             * @param message TMusicPlayerData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITMusicPlayerData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TMusicPlayerData message, length delimited. Does not implicitly {@link NAlice.NData.TMusicPlayerData.verify|verify} messages.
             * @param message TMusicPlayerData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITMusicPlayerData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TMusicPlayerData message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TMusicPlayerData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TMusicPlayerData;

            /**
             * Decodes a TMusicPlayerData message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TMusicPlayerData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TMusicPlayerData;

            /**
             * Verifies a TMusicPlayerData message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TMusicPlayerData message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TMusicPlayerData
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TMusicPlayerData;

            /**
             * Creates a plain object from a TMusicPlayerData message. Also converts values to other types if specified.
             * @param message TMusicPlayerData
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TMusicPlayerData, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TMusicPlayerData to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a TAlbum. */
        interface ITAlbum {

            /** TAlbum Id */
            Id?: (string|null);

            /** TAlbum Title */
            Title?: (string|null);

            /** TAlbum Genre */
            Genre?: (string|null);

            /** TAlbum CoverUri */
            CoverUri?: (string|null);

            /** TAlbum Artists */
            Artists?: (NAlice.NData.ITArtist[]|null);

            /** TAlbum ReleaseYear */
            ReleaseYear?: (number|null);
        }

        /** Represents a TAlbum. */
        class TAlbum implements ITAlbum {

            /**
             * Constructs a new TAlbum.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITAlbum);

            /** TAlbum Id. */
            public Id: string;

            /** TAlbum Title. */
            public Title: string;

            /** TAlbum Genre. */
            public Genre: string;

            /** TAlbum CoverUri. */
            public CoverUri: string;

            /** TAlbum Artists. */
            public Artists: NAlice.NData.ITArtist[];

            /** TAlbum ReleaseYear. */
            public ReleaseYear: number;

            /**
             * Creates a new TAlbum instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TAlbum instance
             */
            public static create(properties?: NAlice.NData.ITAlbum): NAlice.NData.TAlbum;

            /**
             * Encodes the specified TAlbum message. Does not implicitly {@link NAlice.NData.TAlbum.verify|verify} messages.
             * @param message TAlbum message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITAlbum, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TAlbum message, length delimited. Does not implicitly {@link NAlice.NData.TAlbum.verify|verify} messages.
             * @param message TAlbum message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITAlbum, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TAlbum message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TAlbum
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TAlbum;

            /**
             * Decodes a TAlbum message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TAlbum
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TAlbum;

            /**
             * Verifies a TAlbum message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TAlbum message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TAlbum
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TAlbum;

            /**
             * Creates a plain object from a TAlbum message. Also converts values to other types if specified.
             * @param message TAlbum
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TAlbum, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TAlbum to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a TArtist. */
        interface ITArtist {

            /** TArtist Id */
            Id?: (string|null);

            /** TArtist Name */
            Name?: (string|null);

            /** TArtist Composer */
            Composer?: (boolean|null);

            /** TArtist IsVarious */
            IsVarious?: (boolean|null);
        }

        /** Represents a TArtist. */
        class TArtist implements ITArtist {

            /**
             * Constructs a new TArtist.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITArtist);

            /** TArtist Id. */
            public Id: string;

            /** TArtist Name. */
            public Name: string;

            /** TArtist Composer. */
            public Composer: boolean;

            /** TArtist IsVarious. */
            public IsVarious: boolean;

            /**
             * Creates a new TArtist instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TArtist instance
             */
            public static create(properties?: NAlice.NData.ITArtist): NAlice.NData.TArtist;

            /**
             * Encodes the specified TArtist message. Does not implicitly {@link NAlice.NData.TArtist.verify|verify} messages.
             * @param message TArtist message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITArtist, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TArtist message, length delimited. Does not implicitly {@link NAlice.NData.TArtist.verify|verify} messages.
             * @param message TArtist message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITArtist, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TArtist message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TArtist
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TArtist;

            /**
             * Decodes a TArtist message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TArtist
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TArtist;

            /**
             * Verifies a TArtist message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TArtist message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TArtist
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TArtist;

            /**
             * Creates a plain object from a TArtist message. Also converts values to other types if specified.
             * @param message TArtist
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TArtist, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TArtist to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a TTrack. */
        interface ITTrack {

            /** TTrack Id */
            Id?: (string|null);

            /** TTrack Title */
            Title?: (string|null);

            /** TTrack Subtype */
            Subtype?: (string|null);

            /** TTrack ArtImageUrl */
            ArtImageUrl?: (string|null);

            /** TTrack Album */
            Album?: (NAlice.NData.ITAlbum|null);

            /** TTrack Artists */
            Artists?: (NAlice.NData.ITArtist[]|null);

            /** TTrack IsLiked */
            IsLiked?: (boolean|null);

            /** TTrack IsDisliked */
            IsDisliked?: (boolean|null);

            /** TTrack DurationMs */
            DurationMs?: (number|null);
        }

        /** Represents a TTrack. */
        class TTrack implements ITTrack {

            /**
             * Constructs a new TTrack.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITTrack);

            /** TTrack Id. */
            public Id: string;

            /** TTrack Title. */
            public Title: string;

            /** TTrack Subtype. */
            public Subtype: string;

            /** TTrack ArtImageUrl. */
            public ArtImageUrl: string;

            /** TTrack Album. */
            public Album?: (NAlice.NData.ITAlbum|null);

            /** TTrack Artists. */
            public Artists: NAlice.NData.ITArtist[];

            /** TTrack IsLiked. */
            public IsLiked: boolean;

            /** TTrack IsDisliked. */
            public IsDisliked: boolean;

            /** TTrack DurationMs. */
            public DurationMs: number;

            /**
             * Creates a new TTrack instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TTrack instance
             */
            public static create(properties?: NAlice.NData.ITTrack): NAlice.NData.TTrack;

            /**
             * Encodes the specified TTrack message. Does not implicitly {@link NAlice.NData.TTrack.verify|verify} messages.
             * @param message TTrack message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITTrack, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TTrack message, length delimited. Does not implicitly {@link NAlice.NData.TTrack.verify|verify} messages.
             * @param message TTrack message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITTrack, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TTrack message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TTrack
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TTrack;

            /**
             * Decodes a TTrack message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TTrack
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TTrack;

            /**
             * Verifies a TTrack message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TTrack message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TTrack
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TTrack;

            /**
             * Creates a plain object from a TTrack message. Also converts values to other types if specified.
             * @param message TTrack
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TTrack, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TTrack to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a TMusicBand. */
        interface ITMusicBand {

            /** TMusicBand Id */
            Id?: (string|null);

            /** TMusicBand Title */
            Title?: (string|null);

            /** TMusicBand Subtitle */
            Subtitle?: (string|null);

            /** TMusicBand GroupDescription */
            GroupDescription?: (string|null);

            /** TMusicBand Logo */
            Logo?: (NAlice.NData.TSingleImage.ITImageRef|null);

            /** TMusicBand Year */
            Year?: (number|null);

            /** TMusicBand SearchUrl */
            SearchUrl?: (string|null);
        }

        /** Represents a TMusicBand. */
        class TMusicBand implements ITMusicBand {

            /**
             * Constructs a new TMusicBand.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITMusicBand);

            /** TMusicBand Id. */
            public Id: string;

            /** TMusicBand Title. */
            public Title: string;

            /** TMusicBand Subtitle. */
            public Subtitle: string;

            /** TMusicBand GroupDescription. */
            public GroupDescription: string;

            /** TMusicBand Logo. */
            public Logo?: (NAlice.NData.TSingleImage.ITImageRef|null);

            /** TMusicBand Year. */
            public Year: number;

            /** TMusicBand SearchUrl. */
            public SearchUrl: string;

            /**
             * Creates a new TMusicBand instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TMusicBand instance
             */
            public static create(properties?: NAlice.NData.ITMusicBand): NAlice.NData.TMusicBand;

            /**
             * Encodes the specified TMusicBand message. Does not implicitly {@link NAlice.NData.TMusicBand.verify|verify} messages.
             * @param message TMusicBand message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITMusicBand, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TMusicBand message, length delimited. Does not implicitly {@link NAlice.NData.TMusicBand.verify|verify} messages.
             * @param message TMusicBand message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITMusicBand, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TMusicBand message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TMusicBand
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TMusicBand;

            /**
             * Decodes a TMusicBand message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TMusicBand
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TMusicBand;

            /**
             * Verifies a TMusicBand message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TMusicBand message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TMusicBand
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TMusicBand;

            /**
             * Creates a plain object from a TMusicBand message. Also converts values to other types if specified.
             * @param message TMusicBand
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TMusicBand, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TMusicBand to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a TMusicBands. */
        interface ITMusicBands {

            /** TMusicBands Bands */
            Bands?: (NAlice.NData.ITMusicBand[]|null);
        }

        /** Represents a TMusicBands. */
        class TMusicBands implements ITMusicBands {

            /**
             * Constructs a new TMusicBands.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITMusicBands);

            /** TMusicBands Bands. */
            public Bands: NAlice.NData.ITMusicBand[];

            /**
             * Creates a new TMusicBands instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TMusicBands instance
             */
            public static create(properties?: NAlice.NData.ITMusicBands): NAlice.NData.TMusicBands;

            /**
             * Encodes the specified TMusicBands message. Does not implicitly {@link NAlice.NData.TMusicBands.verify|verify} messages.
             * @param message TMusicBands message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITMusicBands, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TMusicBands message, length delimited. Does not implicitly {@link NAlice.NData.TMusicBands.verify|verify} messages.
             * @param message TMusicBands message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITMusicBands, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TMusicBands message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TMusicBands
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TMusicBands;

            /**
             * Decodes a TMusicBands message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TMusicBands
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TMusicBands;

            /**
             * Verifies a TMusicBands message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TMusicBands message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TMusicBands
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TMusicBands;

            /**
             * Creates a plain object from a TMusicBands message. Also converts values to other types if specified.
             * @param message TMusicBands
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TMusicBands, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TMusicBands to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a TMusicAlbums. */
        interface ITMusicAlbums {

            /** TMusicAlbums Albums */
            Albums?: (NAlice.NData.ITAlbum[]|null);
        }

        /** Represents a TMusicAlbums. */
        class TMusicAlbums implements ITMusicAlbums {

            /**
             * Constructs a new TMusicAlbums.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITMusicAlbums);

            /** TMusicAlbums Albums. */
            public Albums: NAlice.NData.ITAlbum[];

            /**
             * Creates a new TMusicAlbums instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TMusicAlbums instance
             */
            public static create(properties?: NAlice.NData.ITMusicAlbums): NAlice.NData.TMusicAlbums;

            /**
             * Encodes the specified TMusicAlbums message. Does not implicitly {@link NAlice.NData.TMusicAlbums.verify|verify} messages.
             * @param message TMusicAlbums message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITMusicAlbums, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TMusicAlbums message, length delimited. Does not implicitly {@link NAlice.NData.TMusicAlbums.verify|verify} messages.
             * @param message TMusicAlbums message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITMusicAlbums, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TMusicAlbums message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TMusicAlbums
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TMusicAlbums;

            /**
             * Decodes a TMusicAlbums message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TMusicAlbums
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TMusicAlbums;

            /**
             * Verifies a TMusicAlbums message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TMusicAlbums message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TMusicAlbums
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TMusicAlbums;

            /**
             * Creates a plain object from a TMusicAlbums message. Also converts values to other types if specified.
             * @param message TMusicAlbums
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TMusicAlbums, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TMusicAlbums to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a TMusicTracks. */
        interface ITMusicTracks {

            /** TMusicTracks Tracks */
            Tracks?: (NAlice.NData.ITTrack[]|null);
        }

        /** Represents a TMusicTracks. */
        class TMusicTracks implements ITMusicTracks {

            /**
             * Constructs a new TMusicTracks.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITMusicTracks);

            /** TMusicTracks Tracks. */
            public Tracks: NAlice.NData.ITTrack[];

            /**
             * Creates a new TMusicTracks instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TMusicTracks instance
             */
            public static create(properties?: NAlice.NData.ITMusicTracks): NAlice.NData.TMusicTracks;

            /**
             * Encodes the specified TMusicTracks message. Does not implicitly {@link NAlice.NData.TMusicTracks.verify|verify} messages.
             * @param message TMusicTracks message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITMusicTracks, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TMusicTracks message, length delimited. Does not implicitly {@link NAlice.NData.TMusicTracks.verify|verify} messages.
             * @param message TMusicTracks message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITMusicTracks, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TMusicTracks message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TMusicTracks
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TMusicTracks;

            /**
             * Decodes a TMusicTracks message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TMusicTracks
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TMusicTracks;

            /**
             * Verifies a TMusicTracks message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TMusicTracks message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TMusicTracks
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TMusicTracks;

            /**
             * Creates a plain object from a TMusicTracks message. Also converts values to other types if specified.
             * @param message TMusicTracks
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TMusicTracks, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TMusicTracks to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a TSingleImage. */
        interface ITSingleImage {

            /** TSingleImage UrlAvatar */
            UrlAvatar?: (NAlice.NData.TSingleImage.ITImageRef|null);

            /** TSingleImage UrlSource */
            UrlSource?: (NAlice.NData.TSingleImage.ITImageRef|null);

            /** TSingleImage Text */
            Text?: (string|null);

            /** TSingleImage HttpSource */
            HttpSource?: (string|null);
        }

        /** Represents a TSingleImage. */
        class TSingleImage implements ITSingleImage {

            /**
             * Constructs a new TSingleImage.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITSingleImage);

            /** TSingleImage UrlAvatar. */
            public UrlAvatar?: (NAlice.NData.TSingleImage.ITImageRef|null);

            /** TSingleImage UrlSource. */
            public UrlSource?: (NAlice.NData.TSingleImage.ITImageRef|null);

            /** TSingleImage Text. */
            public Text: string;

            /** TSingleImage HttpSource. */
            public HttpSource: string;

            /**
             * Creates a new TSingleImage instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TSingleImage instance
             */
            public static create(properties?: NAlice.NData.ITSingleImage): NAlice.NData.TSingleImage;

            /**
             * Encodes the specified TSingleImage message. Does not implicitly {@link NAlice.NData.TSingleImage.verify|verify} messages.
             * @param message TSingleImage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITSingleImage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TSingleImage message, length delimited. Does not implicitly {@link NAlice.NData.TSingleImage.verify|verify} messages.
             * @param message TSingleImage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITSingleImage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TSingleImage message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TSingleImage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TSingleImage;

            /**
             * Decodes a TSingleImage message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TSingleImage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TSingleImage;

            /**
             * Verifies a TSingleImage message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TSingleImage message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TSingleImage
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TSingleImage;

            /**
             * Creates a plain object from a TSingleImage message. Also converts values to other types if specified.
             * @param message TSingleImage
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TSingleImage, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TSingleImage to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        namespace TSingleImage {

            /** Properties of a TImageRef. */
            interface ITImageRef {

                /** TImageRef Url */
                Url?: (string|null);

                /** TImageRef Width */
                Width?: (number|null);

                /** TImageRef Height */
                Height?: (number|null);
            }

            /** Represents a TImageRef. */
            class TImageRef implements ITImageRef {

                /**
                 * Constructs a new TImageRef.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: NAlice.NData.TSingleImage.ITImageRef);

                /** TImageRef Url. */
                public Url: string;

                /** TImageRef Width. */
                public Width: number;

                /** TImageRef Height. */
                public Height: number;

                /**
                 * Creates a new TImageRef instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns TImageRef instance
                 */
                public static create(properties?: NAlice.NData.TSingleImage.ITImageRef): NAlice.NData.TSingleImage.TImageRef;

                /**
                 * Encodes the specified TImageRef message. Does not implicitly {@link NAlice.NData.TSingleImage.TImageRef.verify|verify} messages.
                 * @param message TImageRef message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: NAlice.NData.TSingleImage.ITImageRef, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified TImageRef message, length delimited. Does not implicitly {@link NAlice.NData.TSingleImage.TImageRef.verify|verify} messages.
                 * @param message TImageRef message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: NAlice.NData.TSingleImage.ITImageRef, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a TImageRef message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns TImageRef
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TSingleImage.TImageRef;

                /**
                 * Decodes a TImageRef message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns TImageRef
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TSingleImage.TImageRef;

                /**
                 * Verifies a TImageRef message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a TImageRef message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns TImageRef
                 */
                public static fromObject(object: { [k: string]: any }): NAlice.NData.TSingleImage.TImageRef;

                /**
                 * Creates a plain object from a TImageRef message. Also converts values to other types if specified.
                 * @param message TImageRef
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: NAlice.NData.TSingleImage.TImageRef, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this TImageRef to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }
        }

        /** Properties of a TImageGallery. */
        interface ITImageGallery {

            /** TImageGallery Images */
            Images?: (NAlice.NData.ITSingleImage[]|null);
        }

        /** Represents a TImageGallery. */
        class TImageGallery implements ITImageGallery {

            /**
             * Constructs a new TImageGallery.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITImageGallery);

            /** TImageGallery Images. */
            public Images: NAlice.NData.ITSingleImage[];

            /**
             * Creates a new TImageGallery instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TImageGallery instance
             */
            public static create(properties?: NAlice.NData.ITImageGallery): NAlice.NData.TImageGallery;

            /**
             * Encodes the specified TImageGallery message. Does not implicitly {@link NAlice.NData.TImageGallery.verify|verify} messages.
             * @param message TImageGallery message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITImageGallery, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TImageGallery message, length delimited. Does not implicitly {@link NAlice.NData.TImageGallery.verify|verify} messages.
             * @param message TImageGallery message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITImageGallery, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TImageGallery message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TImageGallery
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TImageGallery;

            /**
             * Decodes a TImageGallery message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TImageGallery
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TImageGallery;

            /**
             * Verifies a TImageGallery message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TImageGallery message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TImageGallery
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TImageGallery;

            /**
             * Creates a plain object from a TImageGallery message. Also converts values to other types if specified.
             * @param message TImageGallery
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TImageGallery, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TImageGallery to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a TButton. */
        interface ITButton {

            /** TButton Title */
            Title?: (string|null);

            /** TButton ActionId */
            ActionId?: (string|null);
        }

        /** Represents a TButton. */
        class TButton implements ITButton {

            /**
             * Constructs a new TButton.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITButton);

            /** TButton Title. */
            public Title: string;

            /** TButton ActionId. */
            public ActionId: string;

            /**
             * Creates a new TButton instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TButton instance
             */
            public static create(properties?: NAlice.NData.ITButton): NAlice.NData.TButton;

            /**
             * Encodes the specified TButton message. Does not implicitly {@link NAlice.NData.TButton.verify|verify} messages.
             * @param message TButton message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITButton, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TButton message, length delimited. Does not implicitly {@link NAlice.NData.TButton.verify|verify} messages.
             * @param message TButton message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITButton, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TButton message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TButton
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TButton;

            /**
             * Decodes a TButton message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TButton
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TButton;

            /**
             * Verifies a TButton message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TButton message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TButton
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TButton;

            /**
             * Creates a plain object from a TButton message. Also converts values to other types if specified.
             * @param message TButton
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TButton, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TButton to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a TTile. */
        interface ITTile {

            /** TTile Title */
            Title?: (string|null);

            /** TTile ActionId */
            ActionId?: (string|null);

            /** TTile ImageUrl */
            ImageUrl?: (string|null);
        }

        /** Represents a TTile. */
        class TTile implements ITTile {

            /**
             * Constructs a new TTile.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITTile);

            /** TTile Title. */
            public Title: string;

            /** TTile ActionId. */
            public ActionId: string;

            /** TTile ImageUrl. */
            public ImageUrl: string;

            /**
             * Creates a new TTile instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TTile instance
             */
            public static create(properties?: NAlice.NData.ITTile): NAlice.NData.TTile;

            /**
             * Encodes the specified TTile message. Does not implicitly {@link NAlice.NData.TTile.verify|verify} messages.
             * @param message TTile message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITTile, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TTile message, length delimited. Does not implicitly {@link NAlice.NData.TTile.verify|verify} messages.
             * @param message TTile message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITTile, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TTile message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TTile
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TTile;

            /**
             * Decodes a TTile message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TTile
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TTile;

            /**
             * Verifies a TTile message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TTile message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TTile
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TTile;

            /**
             * Creates a plain object from a TTile message. Also converts values to other types if specified.
             * @param message TTile
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TTile, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TTile to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a TGreetingsCardData. */
        interface ITGreetingsCardData {

            /** TGreetingsCardData Buttons */
            Buttons?: (NAlice.NData.ITButton[]|null);
        }

        /** Represents a TGreetingsCardData. */
        class TGreetingsCardData implements ITGreetingsCardData {

            /**
             * Constructs a new TGreetingsCardData.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITGreetingsCardData);

            /** TGreetingsCardData Buttons. */
            public Buttons: NAlice.NData.ITButton[];

            /**
             * Creates a new TGreetingsCardData instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TGreetingsCardData instance
             */
            public static create(properties?: NAlice.NData.ITGreetingsCardData): NAlice.NData.TGreetingsCardData;

            /**
             * Encodes the specified TGreetingsCardData message. Does not implicitly {@link NAlice.NData.TGreetingsCardData.verify|verify} messages.
             * @param message TGreetingsCardData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITGreetingsCardData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TGreetingsCardData message, length delimited. Does not implicitly {@link NAlice.NData.TGreetingsCardData.verify|verify} messages.
             * @param message TGreetingsCardData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITGreetingsCardData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TGreetingsCardData message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TGreetingsCardData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TGreetingsCardData;

            /**
             * Decodes a TGreetingsCardData message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TGreetingsCardData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TGreetingsCardData;

            /**
             * Verifies a TGreetingsCardData message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TGreetingsCardData message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TGreetingsCardData
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TGreetingsCardData;

            /**
             * Creates a plain object from a TGreetingsCardData message. Also converts values to other types if specified.
             * @param message TGreetingsCardData
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TGreetingsCardData, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TGreetingsCardData to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a TGreetingsFooterCardData. */
        interface ITGreetingsFooterCardData {

            /** TGreetingsFooterCardData Tiles */
            Tiles?: (NAlice.NData.ITTile[]|null);
        }

        /** Represents a TGreetingsFooterCardData. */
        class TGreetingsFooterCardData implements ITGreetingsFooterCardData {

            /**
             * Constructs a new TGreetingsFooterCardData.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITGreetingsFooterCardData);

            /** TGreetingsFooterCardData Tiles. */
            public Tiles: NAlice.NData.ITTile[];

            /**
             * Creates a new TGreetingsFooterCardData instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TGreetingsFooterCardData instance
             */
            public static create(properties?: NAlice.NData.ITGreetingsFooterCardData): NAlice.NData.TGreetingsFooterCardData;

            /**
             * Encodes the specified TGreetingsFooterCardData message. Does not implicitly {@link NAlice.NData.TGreetingsFooterCardData.verify|verify} messages.
             * @param message TGreetingsFooterCardData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITGreetingsFooterCardData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TGreetingsFooterCardData message, length delimited. Does not implicitly {@link NAlice.NData.TGreetingsFooterCardData.verify|verify} messages.
             * @param message TGreetingsFooterCardData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITGreetingsFooterCardData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TGreetingsFooterCardData message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TGreetingsFooterCardData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TGreetingsFooterCardData;

            /**
             * Decodes a TGreetingsFooterCardData message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TGreetingsFooterCardData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TGreetingsFooterCardData;

            /**
             * Verifies a TGreetingsFooterCardData message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TGreetingsFooterCardData message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TGreetingsFooterCardData
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TGreetingsFooterCardData;

            /**
             * Creates a plain object from a TGreetingsFooterCardData message. Also converts values to other types if specified.
             * @param message TGreetingsFooterCardData
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TGreetingsFooterCardData, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TGreetingsFooterCardData to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a TProactivityTeaserData. */
        interface ITProactivityTeaserData {

            /** TProactivityTeaserData Title */
            Title?: (string|null);

            /** TProactivityTeaserData Description */
            Description?: (string|null);

            /** TProactivityTeaserData BackgroundImageUrl */
            BackgroundImageUrl?: (string|null);

            /** TProactivityTeaserData TypedAction */
            TypedAction?: (google.protobuf.IAny|null);
        }

        /** Represents a TProactivityTeaserData. */
        class TProactivityTeaserData implements ITProactivityTeaserData {

            /**
             * Constructs a new TProactivityTeaserData.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITProactivityTeaserData);

            /** TProactivityTeaserData Title. */
            public Title: string;

            /** TProactivityTeaserData Description. */
            public Description: string;

            /** TProactivityTeaserData BackgroundImageUrl. */
            public BackgroundImageUrl: string;

            /** TProactivityTeaserData TypedAction. */
            public TypedAction?: (google.protobuf.IAny|null);

            /**
             * Creates a new TProactivityTeaserData instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TProactivityTeaserData instance
             */
            public static create(properties?: NAlice.NData.ITProactivityTeaserData): NAlice.NData.TProactivityTeaserData;

            /**
             * Encodes the specified TProactivityTeaserData message. Does not implicitly {@link NAlice.NData.TProactivityTeaserData.verify|verify} messages.
             * @param message TProactivityTeaserData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITProactivityTeaserData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TProactivityTeaserData message, length delimited. Does not implicitly {@link NAlice.NData.TProactivityTeaserData.verify|verify} messages.
             * @param message TProactivityTeaserData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITProactivityTeaserData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TProactivityTeaserData message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TProactivityTeaserData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TProactivityTeaserData;

            /**
             * Decodes a TProactivityTeaserData message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TProactivityTeaserData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TProactivityTeaserData;

            /**
             * Verifies a TProactivityTeaserData message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TProactivityTeaserData message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TProactivityTeaserData
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TProactivityTeaserData;

            /**
             * Creates a plain object from a TProactivityTeaserData message. Also converts values to other types if specified.
             * @param message TProactivityTeaserData
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TProactivityTeaserData, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TProactivityTeaserData to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a TSearchFactData. */
        interface ITSearchFactData {

            /** TSearchFactData SnippetType */
            SnippetType?: (string|null);

            /** TSearchFactData Text */
            Text?: (string|null);

            /** TSearchFactData Question */
            Question?: (string|null);

            /** TSearchFactData Image */
            Image?: (string|null);

            /** TSearchFactData SearchUrl */
            SearchUrl?: (string|null);

            /** TSearchFactData Url */
            Url?: (string|null);

            /** TSearchFactData Hostname */
            Hostname?: (string|null);

            /** TSearchFactData Title */
            Title?: (string|null);

            /** TSearchFactData SerpData */
            SerpData?: (NAlice.NData.TSearchFactData.ITSerpData|null);
        }

        /** Represents a TSearchFactData. */
        class TSearchFactData implements ITSearchFactData {

            /**
             * Constructs a new TSearchFactData.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITSearchFactData);

            /** TSearchFactData SnippetType. */
            public SnippetType: string;

            /** TSearchFactData Text. */
            public Text: string;

            /** TSearchFactData Question. */
            public Question: string;

            /** TSearchFactData Image. */
            public Image: string;

            /** TSearchFactData SearchUrl. */
            public SearchUrl: string;

            /** TSearchFactData Url. */
            public Url: string;

            /** TSearchFactData Hostname. */
            public Hostname: string;

            /** TSearchFactData Title. */
            public Title: string;

            /** TSearchFactData SerpData. */
            public SerpData?: (NAlice.NData.TSearchFactData.ITSerpData|null);

            /**
             * Creates a new TSearchFactData instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TSearchFactData instance
             */
            public static create(properties?: NAlice.NData.ITSearchFactData): NAlice.NData.TSearchFactData;

            /**
             * Encodes the specified TSearchFactData message. Does not implicitly {@link NAlice.NData.TSearchFactData.verify|verify} messages.
             * @param message TSearchFactData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITSearchFactData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TSearchFactData message, length delimited. Does not implicitly {@link NAlice.NData.TSearchFactData.verify|verify} messages.
             * @param message TSearchFactData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITSearchFactData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TSearchFactData message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TSearchFactData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TSearchFactData;

            /**
             * Decodes a TSearchFactData message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TSearchFactData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TSearchFactData;

            /**
             * Verifies a TSearchFactData message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TSearchFactData message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TSearchFactData
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TSearchFactData;

            /**
             * Creates a plain object from a TSearchFactData message. Also converts values to other types if specified.
             * @param message TSearchFactData
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TSearchFactData, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TSearchFactData to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        namespace TSearchFactData {

            /** Properties of a TSerpData. */
            interface ITSerpData {

                /** TSerpData Question */
                Question?: (string|null);

                /** TSerpData Title */
                Title?: (string|null);

                /** TSerpData RequestedFact */
                RequestedFact?: (string|null);
            }

            /** Represents a TSerpData. */
            class TSerpData implements ITSerpData {

                /**
                 * Constructs a new TSerpData.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: NAlice.NData.TSearchFactData.ITSerpData);

                /** TSerpData Question. */
                public Question: string;

                /** TSerpData Title. */
                public Title: string;

                /** TSerpData RequestedFact. */
                public RequestedFact: string;

                /**
                 * Creates a new TSerpData instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns TSerpData instance
                 */
                public static create(properties?: NAlice.NData.TSearchFactData.ITSerpData): NAlice.NData.TSearchFactData.TSerpData;

                /**
                 * Encodes the specified TSerpData message. Does not implicitly {@link NAlice.NData.TSearchFactData.TSerpData.verify|verify} messages.
                 * @param message TSerpData message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: NAlice.NData.TSearchFactData.ITSerpData, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified TSerpData message, length delimited. Does not implicitly {@link NAlice.NData.TSearchFactData.TSerpData.verify|verify} messages.
                 * @param message TSerpData message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: NAlice.NData.TSearchFactData.ITSerpData, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a TSerpData message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns TSerpData
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TSearchFactData.TSerpData;

                /**
                 * Decodes a TSerpData message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns TSerpData
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TSearchFactData.TSerpData;

                /**
                 * Verifies a TSerpData message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a TSerpData message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns TSerpData
                 */
                public static fromObject(object: { [k: string]: any }): NAlice.NData.TSearchFactData.TSerpData;

                /**
                 * Creates a plain object from a TSerpData message. Also converts values to other types if specified.
                 * @param message TSerpData
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: NAlice.NData.TSearchFactData.TSerpData, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this TSerpData to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }
        }

        /** Properties of a TSearchRichCardData. */
        interface ITSearchRichCardData {

            /** TSearchRichCardData CardType */
            CardType?: (string|null);

            /** TSearchRichCardData Header */
            Header?: (NAlice.NData.TSearchRichCardData.ITHeader|null);

            /** TSearchRichCardData Blocks */
            Blocks?: (NAlice.NData.TSearchRichCardData.ITBlock[]|null);

            /** TSearchRichCardData Question */
            Question?: (string|null);
        }

        /** Represents a TSearchRichCardData. */
        class TSearchRichCardData implements ITSearchRichCardData {

            /**
             * Constructs a new TSearchRichCardData.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITSearchRichCardData);

            /** TSearchRichCardData CardType. */
            public CardType: string;

            /** TSearchRichCardData Header. */
            public Header?: (NAlice.NData.TSearchRichCardData.ITHeader|null);

            /** TSearchRichCardData Blocks. */
            public Blocks: NAlice.NData.TSearchRichCardData.ITBlock[];

            /** TSearchRichCardData Question. */
            public Question: string;

            /**
             * Creates a new TSearchRichCardData instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TSearchRichCardData instance
             */
            public static create(properties?: NAlice.NData.ITSearchRichCardData): NAlice.NData.TSearchRichCardData;

            /**
             * Encodes the specified TSearchRichCardData message. Does not implicitly {@link NAlice.NData.TSearchRichCardData.verify|verify} messages.
             * @param message TSearchRichCardData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITSearchRichCardData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TSearchRichCardData message, length delimited. Does not implicitly {@link NAlice.NData.TSearchRichCardData.verify|verify} messages.
             * @param message TSearchRichCardData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITSearchRichCardData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TSearchRichCardData message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TSearchRichCardData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TSearchRichCardData;

            /**
             * Decodes a TSearchRichCardData message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TSearchRichCardData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TSearchRichCardData;

            /**
             * Verifies a TSearchRichCardData message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TSearchRichCardData message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TSearchRichCardData
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TSearchRichCardData;

            /**
             * Creates a plain object from a TSearchRichCardData message. Also converts values to other types if specified.
             * @param message TSearchRichCardData
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TSearchRichCardData, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TSearchRichCardData to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        namespace TSearchRichCardData {

            /** Properties of a THeader. */
            interface ITHeader {

                /** THeader Text */
                Text?: (string|null);

                /** THeader ExtraText */
                ExtraText?: (string|null);

                /** THeader SearchUrl */
                SearchUrl?: (string|null);

                /** THeader Url */
                Url?: (string|null);

                /** THeader Hostname */
                Hostname?: (string|null);

                /** THeader Title */
                Title?: (string|null);

                /** THeader Image */
                Image?: (NAlice.NData.TSingleImage.ITImageRef|null);

                /** THeader Rating */
                Rating?: (string|null);

                /** THeader ExtraText2 */
                ExtraText2?: (string|null);
            }

            /** Represents a THeader. */
            class THeader implements ITHeader {

                /**
                 * Constructs a new THeader.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: NAlice.NData.TSearchRichCardData.ITHeader);

                /** THeader Text. */
                public Text: string;

                /** THeader ExtraText. */
                public ExtraText: string;

                /** THeader SearchUrl. */
                public SearchUrl: string;

                /** THeader Url. */
                public Url: string;

                /** THeader Hostname. */
                public Hostname: string;

                /** THeader Title. */
                public Title: string;

                /** THeader Image. */
                public Image?: (NAlice.NData.TSingleImage.ITImageRef|null);

                /** THeader Rating. */
                public Rating: string;

                /** THeader ExtraText2. */
                public ExtraText2: string;

                /**
                 * Creates a new THeader instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns THeader instance
                 */
                public static create(properties?: NAlice.NData.TSearchRichCardData.ITHeader): NAlice.NData.TSearchRichCardData.THeader;

                /**
                 * Encodes the specified THeader message. Does not implicitly {@link NAlice.NData.TSearchRichCardData.THeader.verify|verify} messages.
                 * @param message THeader message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: NAlice.NData.TSearchRichCardData.ITHeader, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified THeader message, length delimited. Does not implicitly {@link NAlice.NData.TSearchRichCardData.THeader.verify|verify} messages.
                 * @param message THeader message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: NAlice.NData.TSearchRichCardData.ITHeader, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a THeader message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns THeader
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TSearchRichCardData.THeader;

                /**
                 * Decodes a THeader message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns THeader
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TSearchRichCardData.THeader;

                /**
                 * Verifies a THeader message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a THeader message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns THeader
                 */
                public static fromObject(object: { [k: string]: any }): NAlice.NData.TSearchRichCardData.THeader;

                /**
                 * Creates a plain object from a THeader message. Also converts values to other types if specified.
                 * @param message THeader
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: NAlice.NData.TSearchRichCardData.THeader, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this THeader to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }

            /** Properties of a TBlock. */
            interface ITBlock {

                /** TBlock Title */
                Title?: (string|null);

                /** TBlock TitleNavigation */
                TitleNavigation?: (string|null);

                /** TBlock Order */
                Order?: (number|null);

                /** TBlock BlockType */
                BlockType?: (NAlice.NData.TSearchRichCardData.TBlock.EBlockType|null);

                /** TBlock Hidden */
                Hidden?: (boolean|null);

                /** TBlock Sections */
                Sections?: (NAlice.NData.TSearchRichCardData.TBlock.ITSection[]|null);
            }

            /** Represents a TBlock. */
            class TBlock implements ITBlock {

                /**
                 * Constructs a new TBlock.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: NAlice.NData.TSearchRichCardData.ITBlock);

                /** TBlock Title. */
                public Title: string;

                /** TBlock TitleNavigation. */
                public TitleNavigation: string;

                /** TBlock Order. */
                public Order: number;

                /** TBlock BlockType. */
                public BlockType: NAlice.NData.TSearchRichCardData.TBlock.EBlockType;

                /** TBlock Hidden. */
                public Hidden: boolean;

                /** TBlock Sections. */
                public Sections: NAlice.NData.TSearchRichCardData.TBlock.ITSection[];

                /**
                 * Creates a new TBlock instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns TBlock instance
                 */
                public static create(properties?: NAlice.NData.TSearchRichCardData.ITBlock): NAlice.NData.TSearchRichCardData.TBlock;

                /**
                 * Encodes the specified TBlock message. Does not implicitly {@link NAlice.NData.TSearchRichCardData.TBlock.verify|verify} messages.
                 * @param message TBlock message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: NAlice.NData.TSearchRichCardData.ITBlock, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified TBlock message, length delimited. Does not implicitly {@link NAlice.NData.TSearchRichCardData.TBlock.verify|verify} messages.
                 * @param message TBlock message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: NAlice.NData.TSearchRichCardData.ITBlock, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a TBlock message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns TBlock
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TSearchRichCardData.TBlock;

                /**
                 * Decodes a TBlock message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns TBlock
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TSearchRichCardData.TBlock;

                /**
                 * Verifies a TBlock message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a TBlock message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns TBlock
                 */
                public static fromObject(object: { [k: string]: any }): NAlice.NData.TSearchRichCardData.TBlock;

                /**
                 * Creates a plain object from a TBlock message. Also converts values to other types if specified.
                 * @param message TBlock
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: NAlice.NData.TSearchRichCardData.TBlock, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this TBlock to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }

            namespace TBlock {

                /** Properties of a TSection. */
                interface ITSection {

                    /** TSection Order */
                    Order?: (number|null);

                    /** TSection Hidden */
                    Hidden?: (boolean|null);

                    /** TSection Text */
                    Text?: (NAlice.NData.ITSimpleText|null);

                    /** TSection FactList */
                    FactList?: (NAlice.NData.ITFactList|null);

                    /** TSection Gallery */
                    Gallery?: (NAlice.NData.ITImageGallery|null);

                    /** TSection Persons */
                    Persons?: (NAlice.NData.ITPersons|null);

                    /** TSection GeoPlaces */
                    GeoPlaces?: (NAlice.NData.ITGeoPlaces|null);

                    /** TSection Books */
                    Books?: (NAlice.NData.ITBooks|null);

                    /** TSection VideoClips */
                    VideoClips?: (NAlice.NData.ITVideoGallery|null);

                    /** TSection VideoMovies */
                    VideoMovies?: (NAlice.NData.ITVideoGallery|null);

                    /** TSection MusicBands */
                    MusicBands?: (NAlice.NData.ITMusicBands|null);

                    /** TSection MusicAlbums */
                    MusicAlbums?: (NAlice.NData.ITMusicAlbums|null);

                    /** TSection MusicTracks */
                    MusicTracks?: (NAlice.NData.ITMusicTracks|null);

                    /** TSection Companies */
                    Companies?: (NAlice.NData.ITCompanies|null);
                }

                /** Represents a TSection. */
                class TSection implements ITSection {

                    /**
                     * Constructs a new TSection.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: NAlice.NData.TSearchRichCardData.TBlock.ITSection);

                    /** TSection Order. */
                    public Order: number;

                    /** TSection Hidden. */
                    public Hidden: boolean;

                    /** TSection Text. */
                    public Text?: (NAlice.NData.ITSimpleText|null);

                    /** TSection FactList. */
                    public FactList?: (NAlice.NData.ITFactList|null);

                    /** TSection Gallery. */
                    public Gallery?: (NAlice.NData.ITImageGallery|null);

                    /** TSection Persons. */
                    public Persons?: (NAlice.NData.ITPersons|null);

                    /** TSection GeoPlaces. */
                    public GeoPlaces?: (NAlice.NData.ITGeoPlaces|null);

                    /** TSection Books. */
                    public Books?: (NAlice.NData.ITBooks|null);

                    /** TSection VideoClips. */
                    public VideoClips?: (NAlice.NData.ITVideoGallery|null);

                    /** TSection VideoMovies. */
                    public VideoMovies?: (NAlice.NData.ITVideoGallery|null);

                    /** TSection MusicBands. */
                    public MusicBands?: (NAlice.NData.ITMusicBands|null);

                    /** TSection MusicAlbums. */
                    public MusicAlbums?: (NAlice.NData.ITMusicAlbums|null);

                    /** TSection MusicTracks. */
                    public MusicTracks?: (NAlice.NData.ITMusicTracks|null);

                    /** TSection Companies. */
                    public Companies?: (NAlice.NData.ITCompanies|null);

                    /** TSection Section. */
                    public Section?: ("Text"|"FactList"|"Gallery"|"Persons"|"GeoPlaces"|"Books"|"VideoClips"|"VideoMovies"|"MusicBands"|"MusicAlbums"|"MusicTracks"|"Companies");

                    /**
                     * Creates a new TSection instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns TSection instance
                     */
                    public static create(properties?: NAlice.NData.TSearchRichCardData.TBlock.ITSection): NAlice.NData.TSearchRichCardData.TBlock.TSection;

                    /**
                     * Encodes the specified TSection message. Does not implicitly {@link NAlice.NData.TSearchRichCardData.TBlock.TSection.verify|verify} messages.
                     * @param message TSection message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: NAlice.NData.TSearchRichCardData.TBlock.ITSection, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified TSection message, length delimited. Does not implicitly {@link NAlice.NData.TSearchRichCardData.TBlock.TSection.verify|verify} messages.
                     * @param message TSection message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: NAlice.NData.TSearchRichCardData.TBlock.ITSection, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a TSection message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns TSection
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TSearchRichCardData.TBlock.TSection;

                    /**
                     * Decodes a TSection message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns TSection
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TSearchRichCardData.TBlock.TSection;

                    /**
                     * Verifies a TSection message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a TSection message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns TSection
                     */
                    public static fromObject(object: { [k: string]: any }): NAlice.NData.TSearchRichCardData.TBlock.TSection;

                    /**
                     * Creates a plain object from a TSection message. Also converts values to other types if specified.
                     * @param message TSection
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: NAlice.NData.TSearchRichCardData.TBlock.TSection, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this TSection to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** EBlockType enum. */
                enum EBlockType {
                    Custom = 0,
                    Main = 1,
                    Gallery = 2,
                    Tracks = 3,
                    Movie = 4,
                    Albums = 5,
                    Info = 6,
                    Suggest = 7,
                    SeeAlso = 8,
                    Persons = 9,
                    Places = 10,
                    Books = 11,
                    Clips = 12,
                    Band = 13,
                    Companies = 14,
                    Software = 15
                }
            }
        }

        /** Properties of a TBook. */
        interface ITBook {

            /** TBook Id */
            Id?: (string|null);

            /** TBook Name */
            Name?: (string|null);

            /** TBook NameOrig */
            NameOrig?: (string|null);

            /** TBook Image */
            Image?: (NAlice.NData.TSingleImage.ITImageRef|null);

            /** TBook Url */
            Url?: (string|null);

            /** TBook Description */
            Description?: (string|null);

            /** TBook Authors */
            Authors?: (NAlice.NData.ITPerson[]|null);

            /** TBook Rating */
            Rating?: (string|null);

            /** TBook ReleaseYear */
            ReleaseYear?: (number|null);

            /** TBook SearchUrl */
            SearchUrl?: (string|null);
        }

        /** Represents a TBook. */
        class TBook implements ITBook {

            /**
             * Constructs a new TBook.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITBook);

            /** TBook Id. */
            public Id: string;

            /** TBook Name. */
            public Name: string;

            /** TBook NameOrig. */
            public NameOrig: string;

            /** TBook Image. */
            public Image?: (NAlice.NData.TSingleImage.ITImageRef|null);

            /** TBook Url. */
            public Url: string;

            /** TBook Description. */
            public Description: string;

            /** TBook Authors. */
            public Authors: NAlice.NData.ITPerson[];

            /** TBook Rating. */
            public Rating: string;

            /** TBook ReleaseYear. */
            public ReleaseYear: number;

            /** TBook SearchUrl. */
            public SearchUrl: string;

            /**
             * Creates a new TBook instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TBook instance
             */
            public static create(properties?: NAlice.NData.ITBook): NAlice.NData.TBook;

            /**
             * Encodes the specified TBook message. Does not implicitly {@link NAlice.NData.TBook.verify|verify} messages.
             * @param message TBook message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITBook, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TBook message, length delimited. Does not implicitly {@link NAlice.NData.TBook.verify|verify} messages.
             * @param message TBook message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITBook, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TBook message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TBook
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TBook;

            /**
             * Decodes a TBook message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TBook
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TBook;

            /**
             * Verifies a TBook message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TBook message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TBook
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TBook;

            /**
             * Creates a plain object from a TBook message. Also converts values to other types if specified.
             * @param message TBook
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TBook, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TBook to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a TBooks. */
        interface ITBooks {

            /** TBooks Books */
            Books?: (NAlice.NData.ITBook[]|null);
        }

        /** Represents a TBooks. */
        class TBooks implements ITBooks {

            /**
             * Constructs a new TBooks.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITBooks);

            /** TBooks Books. */
            public Books: NAlice.NData.ITBook[];

            /**
             * Creates a new TBooks instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TBooks instance
             */
            public static create(properties?: NAlice.NData.ITBooks): NAlice.NData.TBooks;

            /**
             * Encodes the specified TBooks message. Does not implicitly {@link NAlice.NData.TBooks.verify|verify} messages.
             * @param message TBooks message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITBooks, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TBooks message, length delimited. Does not implicitly {@link NAlice.NData.TBooks.verify|verify} messages.
             * @param message TBooks message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITBooks, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TBooks message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TBooks
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TBooks;

            /**
             * Decodes a TBooks message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TBooks
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TBooks;

            /**
             * Verifies a TBooks message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TBooks message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TBooks
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TBooks;

            /**
             * Creates a plain object from a TBooks message. Also converts values to other types if specified.
             * @param message TBooks
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TBooks, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TBooks to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a TPerson. */
        interface ITPerson {

            /** TPerson Id */
            Id?: (string|null);

            /** TPerson Name */
            Name?: (string|null);

            /** TPerson Image */
            Image?: (NAlice.NData.TSingleImage.ITImageRef|null);

            /** TPerson Url */
            Url?: (string|null);

            /** TPerson Description */
            Description?: (string|null);

            /** TPerson TypedAction */
            TypedAction?: (google.protobuf.IAny|null);
        }

        /** Represents a TPerson. */
        class TPerson implements ITPerson {

            /**
             * Constructs a new TPerson.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITPerson);

            /** TPerson Id. */
            public Id: string;

            /** TPerson Name. */
            public Name: string;

            /** TPerson Image. */
            public Image?: (NAlice.NData.TSingleImage.ITImageRef|null);

            /** TPerson Url. */
            public Url: string;

            /** TPerson Description. */
            public Description: string;

            /** TPerson TypedAction. */
            public TypedAction?: (google.protobuf.IAny|null);

            /**
             * Creates a new TPerson instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TPerson instance
             */
            public static create(properties?: NAlice.NData.ITPerson): NAlice.NData.TPerson;

            /**
             * Encodes the specified TPerson message. Does not implicitly {@link NAlice.NData.TPerson.verify|verify} messages.
             * @param message TPerson message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITPerson, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TPerson message, length delimited. Does not implicitly {@link NAlice.NData.TPerson.verify|verify} messages.
             * @param message TPerson message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITPerson, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TPerson message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TPerson
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TPerson;

            /**
             * Decodes a TPerson message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TPerson
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TPerson;

            /**
             * Verifies a TPerson message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TPerson message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TPerson
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TPerson;

            /**
             * Creates a plain object from a TPerson message. Also converts values to other types if specified.
             * @param message TPerson
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TPerson, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TPerson to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a TPersons. */
        interface ITPersons {

            /** TPersons Persones */
            Persones?: (NAlice.NData.ITPerson[]|null);
        }

        /** Represents a TPersons. */
        class TPersons implements ITPersons {

            /**
             * Constructs a new TPersons.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITPersons);

            /** TPersons Persones. */
            public Persones: NAlice.NData.ITPerson[];

            /**
             * Creates a new TPersons instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TPersons instance
             */
            public static create(properties?: NAlice.NData.ITPersons): NAlice.NData.TPersons;

            /**
             * Encodes the specified TPersons message. Does not implicitly {@link NAlice.NData.TPersons.verify|verify} messages.
             * @param message TPersons message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITPersons, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TPersons message, length delimited. Does not implicitly {@link NAlice.NData.TPersons.verify|verify} messages.
             * @param message TPersons message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITPersons, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TPersons message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TPersons
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TPersons;

            /**
             * Decodes a TPersons message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TPersons
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TPersons;

            /**
             * Verifies a TPersons message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TPersons message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TPersons
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TPersons;

            /**
             * Creates a plain object from a TPersons message. Also converts values to other types if specified.
             * @param message TPersons
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TPersons, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TPersons to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a TCompany. */
        interface ITCompany {

            /** TCompany Id */
            Id?: (string|null);

            /** TCompany Name */
            Name?: (string|null);

            /** TCompany Image */
            Image?: (NAlice.NData.TSingleImage.ITImageRef|null);

            /** TCompany Url */
            Url?: (string|null);

            /** TCompany Description */
            Description?: (string|null);

            /** TCompany Rating */
            Rating?: (string|null);

            /** TCompany Address */
            Address?: (string|null);

            /** TCompany WorkingHours */
            WorkingHours?: (string|null);

            /** TCompany SearchUrl */
            SearchUrl?: (string|null);
        }

        /** Represents a TCompany. */
        class TCompany implements ITCompany {

            /**
             * Constructs a new TCompany.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITCompany);

            /** TCompany Id. */
            public Id: string;

            /** TCompany Name. */
            public Name: string;

            /** TCompany Image. */
            public Image?: (NAlice.NData.TSingleImage.ITImageRef|null);

            /** TCompany Url. */
            public Url: string;

            /** TCompany Description. */
            public Description: string;

            /** TCompany Rating. */
            public Rating: string;

            /** TCompany Address. */
            public Address: string;

            /** TCompany WorkingHours. */
            public WorkingHours: string;

            /** TCompany SearchUrl. */
            public SearchUrl: string;

            /**
             * Creates a new TCompany instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TCompany instance
             */
            public static create(properties?: NAlice.NData.ITCompany): NAlice.NData.TCompany;

            /**
             * Encodes the specified TCompany message. Does not implicitly {@link NAlice.NData.TCompany.verify|verify} messages.
             * @param message TCompany message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITCompany, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TCompany message, length delimited. Does not implicitly {@link NAlice.NData.TCompany.verify|verify} messages.
             * @param message TCompany message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITCompany, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TCompany message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TCompany
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TCompany;

            /**
             * Decodes a TCompany message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TCompany
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TCompany;

            /**
             * Verifies a TCompany message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TCompany message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TCompany
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TCompany;

            /**
             * Creates a plain object from a TCompany message. Also converts values to other types if specified.
             * @param message TCompany
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TCompany, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TCompany to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a TCompanies. */
        interface ITCompanies {

            /** TCompanies Companies */
            Companies?: (NAlice.NData.ITCompany[]|null);
        }

        /** Represents a TCompanies. */
        class TCompanies implements ITCompanies {

            /**
             * Constructs a new TCompanies.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITCompanies);

            /** TCompanies Companies. */
            public Companies: NAlice.NData.ITCompany[];

            /**
             * Creates a new TCompanies instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TCompanies instance
             */
            public static create(properties?: NAlice.NData.ITCompanies): NAlice.NData.TCompanies;

            /**
             * Encodes the specified TCompanies message. Does not implicitly {@link NAlice.NData.TCompanies.verify|verify} messages.
             * @param message TCompanies message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITCompanies, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TCompanies message, length delimited. Does not implicitly {@link NAlice.NData.TCompanies.verify|verify} messages.
             * @param message TCompanies message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITCompanies, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TCompanies message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TCompanies
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TCompanies;

            /**
             * Decodes a TCompanies message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TCompanies
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TCompanies;

            /**
             * Verifies a TCompanies message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TCompanies message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TCompanies
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TCompanies;

            /**
             * Creates a plain object from a TCompanies message. Also converts values to other types if specified.
             * @param message TCompanies
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TCompanies, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TCompanies to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a TGeoPlace. */
        interface ITGeoPlace {

            /** TGeoPlace Id */
            Id?: (string|null);

            /** TGeoPlace Name */
            Name?: (string|null);

            /** TGeoPlace Image */
            Image?: (NAlice.NData.TSingleImage.ITImageRef|null);

            /** TGeoPlace Url */
            Url?: (string|null);

            /** TGeoPlace Description */
            Description?: (string|null);

            /** TGeoPlace Rating */
            Rating?: (string|null);

            /** TGeoPlace SearchUrl */
            SearchUrl?: (string|null);
        }

        /** Represents a TGeoPlace. */
        class TGeoPlace implements ITGeoPlace {

            /**
             * Constructs a new TGeoPlace.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITGeoPlace);

            /** TGeoPlace Id. */
            public Id: string;

            /** TGeoPlace Name. */
            public Name: string;

            /** TGeoPlace Image. */
            public Image?: (NAlice.NData.TSingleImage.ITImageRef|null);

            /** TGeoPlace Url. */
            public Url: string;

            /** TGeoPlace Description. */
            public Description: string;

            /** TGeoPlace Rating. */
            public Rating: string;

            /** TGeoPlace SearchUrl. */
            public SearchUrl: string;

            /**
             * Creates a new TGeoPlace instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TGeoPlace instance
             */
            public static create(properties?: NAlice.NData.ITGeoPlace): NAlice.NData.TGeoPlace;

            /**
             * Encodes the specified TGeoPlace message. Does not implicitly {@link NAlice.NData.TGeoPlace.verify|verify} messages.
             * @param message TGeoPlace message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITGeoPlace, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TGeoPlace message, length delimited. Does not implicitly {@link NAlice.NData.TGeoPlace.verify|verify} messages.
             * @param message TGeoPlace message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITGeoPlace, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TGeoPlace message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TGeoPlace
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TGeoPlace;

            /**
             * Decodes a TGeoPlace message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TGeoPlace
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TGeoPlace;

            /**
             * Verifies a TGeoPlace message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TGeoPlace message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TGeoPlace
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TGeoPlace;

            /**
             * Creates a plain object from a TGeoPlace message. Also converts values to other types if specified.
             * @param message TGeoPlace
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TGeoPlace, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TGeoPlace to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a TGeoPlaces. */
        interface ITGeoPlaces {

            /** TGeoPlaces Places */
            Places?: (NAlice.NData.ITGeoPlace[]|null);
        }

        /** Represents a TGeoPlaces. */
        class TGeoPlaces implements ITGeoPlaces {

            /**
             * Constructs a new TGeoPlaces.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITGeoPlaces);

            /** TGeoPlaces Places. */
            public Places: NAlice.NData.ITGeoPlace[];

            /**
             * Creates a new TGeoPlaces instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TGeoPlaces instance
             */
            public static create(properties?: NAlice.NData.ITGeoPlaces): NAlice.NData.TGeoPlaces;

            /**
             * Encodes the specified TGeoPlaces message. Does not implicitly {@link NAlice.NData.TGeoPlaces.verify|verify} messages.
             * @param message TGeoPlaces message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITGeoPlaces, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TGeoPlaces message, length delimited. Does not implicitly {@link NAlice.NData.TGeoPlaces.verify|verify} messages.
             * @param message TGeoPlaces message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITGeoPlaces, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TGeoPlaces message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TGeoPlaces
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TGeoPlaces;

            /**
             * Decodes a TGeoPlaces message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TGeoPlaces
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TGeoPlaces;

            /**
             * Verifies a TGeoPlaces message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TGeoPlaces message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TGeoPlaces
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TGeoPlaces;

            /**
             * Creates a plain object from a TGeoPlaces message. Also converts values to other types if specified.
             * @param message TGeoPlaces
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TGeoPlaces, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TGeoPlaces to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a TSimpleText. */
        interface ITSimpleText {

            /** TSimpleText SnippetType */
            SnippetType?: (string|null);

            /** TSimpleText Text */
            Text?: (string|null);

            /** TSimpleText Image */
            Image?: (NAlice.NData.TSingleImage.ITImageRef|null);

            /** TSimpleText SearchUrl */
            SearchUrl?: (string|null);

            /** TSimpleText Url */
            Url?: (string|null);

            /** TSimpleText Hostname */
            Hostname?: (string|null);

            /** TSimpleText Title */
            Title?: (string|null);

            /** TSimpleText Symbol */
            Symbol?: (NAlice.NData.TSimpleText.ITTextSymbol|null);

            /** TSimpleText OriginalLanguage */
            OriginalLanguage?: (string|null);
        }

        /** Represents a TSimpleText. */
        class TSimpleText implements ITSimpleText {

            /**
             * Constructs a new TSimpleText.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITSimpleText);

            /** TSimpleText SnippetType. */
            public SnippetType: string;

            /** TSimpleText Text. */
            public Text: string;

            /** TSimpleText Image. */
            public Image?: (NAlice.NData.TSingleImage.ITImageRef|null);

            /** TSimpleText SearchUrl. */
            public SearchUrl: string;

            /** TSimpleText Url. */
            public Url: string;

            /** TSimpleText Hostname. */
            public Hostname: string;

            /** TSimpleText Title. */
            public Title: string;

            /** TSimpleText Symbol. */
            public Symbol?: (NAlice.NData.TSimpleText.ITTextSymbol|null);

            /** TSimpleText OriginalLanguage. */
            public OriginalLanguage: string;

            /**
             * Creates a new TSimpleText instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TSimpleText instance
             */
            public static create(properties?: NAlice.NData.ITSimpleText): NAlice.NData.TSimpleText;

            /**
             * Encodes the specified TSimpleText message. Does not implicitly {@link NAlice.NData.TSimpleText.verify|verify} messages.
             * @param message TSimpleText message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITSimpleText, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TSimpleText message, length delimited. Does not implicitly {@link NAlice.NData.TSimpleText.verify|verify} messages.
             * @param message TSimpleText message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITSimpleText, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TSimpleText message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TSimpleText
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TSimpleText;

            /**
             * Decodes a TSimpleText message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TSimpleText
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TSimpleText;

            /**
             * Verifies a TSimpleText message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TSimpleText message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TSimpleText
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TSimpleText;

            /**
             * Creates a plain object from a TSimpleText message. Also converts values to other types if specified.
             * @param message TSimpleText
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TSimpleText, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TSimpleText to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        namespace TSimpleText {

            /** Properties of a TTextSymbol. */
            interface ITTextSymbol {

                /** TTextSymbol Type */
                Type?: (NAlice.NData.TSimpleText.TTextSymbol.ESymbolType|null);

                /** TTextSymbol Color */
                Color?: (string|null);

                /** TTextSymbol Text */
                Text?: (string|null);
            }

            /** Represents a TTextSymbol. */
            class TTextSymbol implements ITTextSymbol {

                /**
                 * Constructs a new TTextSymbol.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: NAlice.NData.TSimpleText.ITTextSymbol);

                /** TTextSymbol Type. */
                public Type: NAlice.NData.TSimpleText.TTextSymbol.ESymbolType;

                /** TTextSymbol Color. */
                public Color: string;

                /** TTextSymbol Text. */
                public Text: string;

                /**
                 * Creates a new TTextSymbol instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns TTextSymbol instance
                 */
                public static create(properties?: NAlice.NData.TSimpleText.ITTextSymbol): NAlice.NData.TSimpleText.TTextSymbol;

                /**
                 * Encodes the specified TTextSymbol message. Does not implicitly {@link NAlice.NData.TSimpleText.TTextSymbol.verify|verify} messages.
                 * @param message TTextSymbol message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: NAlice.NData.TSimpleText.ITTextSymbol, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified TTextSymbol message, length delimited. Does not implicitly {@link NAlice.NData.TSimpleText.TTextSymbol.verify|verify} messages.
                 * @param message TTextSymbol message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: NAlice.NData.TSimpleText.ITTextSymbol, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a TTextSymbol message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns TTextSymbol
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TSimpleText.TTextSymbol;

                /**
                 * Decodes a TTextSymbol message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns TTextSymbol
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TSimpleText.TTextSymbol;

                /**
                 * Verifies a TTextSymbol message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a TTextSymbol message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns TTextSymbol
                 */
                public static fromObject(object: { [k: string]: any }): NAlice.NData.TSimpleText.TTextSymbol;

                /**
                 * Creates a plain object from a TTextSymbol message. Also converts values to other types if specified.
                 * @param message TTextSymbol
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: NAlice.NData.TSimpleText.TTextSymbol, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this TTextSymbol to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }

            namespace TTextSymbol {

                /** ESymbolType enum. */
                enum ESymbolType {
                    Undefined = 0,
                    Subway = 1
                }
            }
        }

        /** Properties of a TFactList. */
        interface ITFactList {

            /** TFactList Facts */
            Facts?: (NAlice.NData.TFactList.ITFact[]|null);
        }

        /** Represents a TFactList. */
        class TFactList implements ITFactList {

            /**
             * Constructs a new TFactList.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITFactList);

            /** TFactList Facts. */
            public Facts: NAlice.NData.TFactList.ITFact[];

            /**
             * Creates a new TFactList instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TFactList instance
             */
            public static create(properties?: NAlice.NData.ITFactList): NAlice.NData.TFactList;

            /**
             * Encodes the specified TFactList message. Does not implicitly {@link NAlice.NData.TFactList.verify|verify} messages.
             * @param message TFactList message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITFactList, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TFactList message, length delimited. Does not implicitly {@link NAlice.NData.TFactList.verify|verify} messages.
             * @param message TFactList message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITFactList, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TFactList message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TFactList
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TFactList;

            /**
             * Decodes a TFactList message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TFactList
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TFactList;

            /**
             * Verifies a TFactList message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TFactList message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TFactList
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TFactList;

            /**
             * Creates a plain object from a TFactList message. Also converts values to other types if specified.
             * @param message TFactList
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TFactList, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TFactList to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        namespace TFactList {

            /** Properties of a TMultiText. */
            interface ITMultiText {

                /** TMultiText TextAnswer */
                TextAnswer?: (NAlice.NData.ITSimpleText[]|null);
            }

            /** Represents a TMultiText. */
            class TMultiText implements ITMultiText {

                /**
                 * Constructs a new TMultiText.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: NAlice.NData.TFactList.ITMultiText);

                /** TMultiText TextAnswer. */
                public TextAnswer: NAlice.NData.ITSimpleText[];

                /**
                 * Creates a new TMultiText instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns TMultiText instance
                 */
                public static create(properties?: NAlice.NData.TFactList.ITMultiText): NAlice.NData.TFactList.TMultiText;

                /**
                 * Encodes the specified TMultiText message. Does not implicitly {@link NAlice.NData.TFactList.TMultiText.verify|verify} messages.
                 * @param message TMultiText message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: NAlice.NData.TFactList.ITMultiText, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified TMultiText message, length delimited. Does not implicitly {@link NAlice.NData.TFactList.TMultiText.verify|verify} messages.
                 * @param message TMultiText message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: NAlice.NData.TFactList.ITMultiText, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a TMultiText message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns TMultiText
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TFactList.TMultiText;

                /**
                 * Decodes a TMultiText message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns TMultiText
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TFactList.TMultiText;

                /**
                 * Verifies a TMultiText message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a TMultiText message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns TMultiText
                 */
                public static fromObject(object: { [k: string]: any }): NAlice.NData.TFactList.TMultiText;

                /**
                 * Creates a plain object from a TMultiText message. Also converts values to other types if specified.
                 * @param message TMultiText
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: NAlice.NData.TFactList.TMultiText, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this TMultiText to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }

            /** Properties of a TFact. */
            interface ITFact {

                /** TFact FactText */
                FactText?: (string|null);

                /** TFact TextAnswer */
                TextAnswer?: (string|null);

                /** TFact MultiTextAnswer */
                MultiTextAnswer?: (NAlice.NData.TFactList.ITMultiText|null);
            }

            /** Represents a TFact. */
            class TFact implements ITFact {

                /**
                 * Constructs a new TFact.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: NAlice.NData.TFactList.ITFact);

                /** TFact FactText. */
                public FactText: string;

                /** TFact TextAnswer. */
                public TextAnswer?: (string|null);

                /** TFact MultiTextAnswer. */
                public MultiTextAnswer?: (NAlice.NData.TFactList.ITMultiText|null);

                /** TFact FactAnswer. */
                public FactAnswer?: ("TextAnswer"|"MultiTextAnswer");

                /**
                 * Creates a new TFact instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns TFact instance
                 */
                public static create(properties?: NAlice.NData.TFactList.ITFact): NAlice.NData.TFactList.TFact;

                /**
                 * Encodes the specified TFact message. Does not implicitly {@link NAlice.NData.TFactList.TFact.verify|verify} messages.
                 * @param message TFact message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: NAlice.NData.TFactList.ITFact, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified TFact message, length delimited. Does not implicitly {@link NAlice.NData.TFactList.TFact.verify|verify} messages.
                 * @param message TFact message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: NAlice.NData.TFactList.ITFact, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a TFact message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns TFact
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TFactList.TFact;

                /**
                 * Decodes a TFact message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns TFact
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TFactList.TFact;

                /**
                 * Verifies a TFact message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a TFact message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns TFact
                 */
                public static fromObject(object: { [k: string]: any }): NAlice.NData.TFactList.TFact;

                /**
                 * Creates a plain object from a TFact message. Also converts values to other types if specified.
                 * @param message TFact
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: NAlice.NData.TFactList.TFact, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this TFact to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }
        }

        /** Properties of a TVideoObject. */
        interface ITVideoObject {

            /** TVideoObject Id */
            Id?: (string|null);

            /** TVideoObject VideoType */
            VideoType?: (NAlice.NData.TVideoObject.EVideoType|null);

            /** TVideoObject Title */
            Title?: (string|null);

            /** TVideoObject Subtitle */
            Subtitle?: (string|null);

            /** TVideoObject Logo */
            Logo?: (NAlice.NData.TSingleImage.ITImageRef|null);

            /** TVideoObject ReleaseYear */
            ReleaseYear?: (number|null);

            /** TVideoObject Description */
            Description?: (string|null);

            /** TVideoObject Rating */
            Rating?: (string|null);

            /** TVideoObject Duration */
            Duration?: (number|null);

            /** TVideoObject AgeLimit */
            AgeLimit?: (number|null);

            /** TVideoObject HintInfo */
            HintInfo?: (string|null);
        }

        /** Represents a TVideoObject. */
        class TVideoObject implements ITVideoObject {

            /**
             * Constructs a new TVideoObject.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITVideoObject);

            /** TVideoObject Id. */
            public Id: string;

            /** TVideoObject VideoType. */
            public VideoType: NAlice.NData.TVideoObject.EVideoType;

            /** TVideoObject Title. */
            public Title: string;

            /** TVideoObject Subtitle. */
            public Subtitle: string;

            /** TVideoObject Logo. */
            public Logo?: (NAlice.NData.TSingleImage.ITImageRef|null);

            /** TVideoObject ReleaseYear. */
            public ReleaseYear: number;

            /** TVideoObject Description. */
            public Description: string;

            /** TVideoObject Rating. */
            public Rating: string;

            /** TVideoObject Duration. */
            public Duration: number;

            /** TVideoObject AgeLimit. */
            public AgeLimit: number;

            /** TVideoObject HintInfo. */
            public HintInfo: string;

            /**
             * Creates a new TVideoObject instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TVideoObject instance
             */
            public static create(properties?: NAlice.NData.ITVideoObject): NAlice.NData.TVideoObject;

            /**
             * Encodes the specified TVideoObject message. Does not implicitly {@link NAlice.NData.TVideoObject.verify|verify} messages.
             * @param message TVideoObject message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITVideoObject, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TVideoObject message, length delimited. Does not implicitly {@link NAlice.NData.TVideoObject.verify|verify} messages.
             * @param message TVideoObject message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITVideoObject, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TVideoObject message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TVideoObject
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TVideoObject;

            /**
             * Decodes a TVideoObject message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TVideoObject
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TVideoObject;

            /**
             * Verifies a TVideoObject message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TVideoObject message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TVideoObject
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TVideoObject;

            /**
             * Creates a plain object from a TVideoObject message. Also converts values to other types if specified.
             * @param message TVideoObject
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TVideoObject, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TVideoObject to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        namespace TVideoObject {

            /** EVideoType enum. */
            enum EVideoType {
                Unknown = 0,
                Clip = 1,
                Movie = 2
            }
        }

        /** Properties of a TVideoGallery. */
        interface ITVideoGallery {

            /** TVideoGallery Videos */
            Videos?: (NAlice.NData.ITVideoObject[]|null);
        }

        /** Represents a TVideoGallery. */
        class TVideoGallery implements ITVideoGallery {

            /**
             * Constructs a new TVideoGallery.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITVideoGallery);

            /** TVideoGallery Videos. */
            public Videos: NAlice.NData.ITVideoObject[];

            /**
             * Creates a new TVideoGallery instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TVideoGallery instance
             */
            public static create(properties?: NAlice.NData.ITVideoGallery): NAlice.NData.TVideoGallery;

            /**
             * Encodes the specified TVideoGallery message. Does not implicitly {@link NAlice.NData.TVideoGallery.verify|verify} messages.
             * @param message TVideoGallery message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITVideoGallery, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TVideoGallery message, length delimited. Does not implicitly {@link NAlice.NData.TVideoGallery.verify|verify} messages.
             * @param message TVideoGallery message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITVideoGallery, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TVideoGallery message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TVideoGallery
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TVideoGallery;

            /**
             * Decodes a TVideoGallery message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TVideoGallery
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TVideoGallery;

            /**
             * Verifies a TVideoGallery message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TVideoGallery message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TVideoGallery
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TVideoGallery;

            /**
             * Creates a plain object from a TVideoGallery message. Also converts values to other types if specified.
             * @param message TVideoGallery
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TVideoGallery, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TVideoGallery to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a TGeo. */
        interface ITGeo {

            /** TGeo AddressLine */
            AddressLine?: (string|null);

            /** TGeo City */
            City?: (string|null);

            /** TGeo CityCases */
            CityCases?: (NAlice.NData.TGeo.ITCases|null);

            /** TGeo CityPrepcase */
            CityPrepcase?: (string|null);

            /** TGeo Country */
            Country?: (string|null);

            /** TGeo GeoId */
            GeoId?: (number|Long|null);

            /** TGeo House */
            House?: (string|null);

            /** TGeo InUserCity */
            InUserCity?: (boolean|null);

            /** TGeo Level */
            Level?: (string|null);

            /** TGeo Street */
            Street?: (string|null);
        }

        /** Represents a TGeo. */
        class TGeo implements ITGeo {

            /**
             * Constructs a new TGeo.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITGeo);

            /** TGeo AddressLine. */
            public AddressLine: string;

            /** TGeo City. */
            public City: string;

            /** TGeo CityCases. */
            public CityCases?: (NAlice.NData.TGeo.ITCases|null);

            /** TGeo CityPrepcase. */
            public CityPrepcase: string;

            /** TGeo Country. */
            public Country: string;

            /** TGeo GeoId. */
            public GeoId: (number|Long);

            /** TGeo House. */
            public House: string;

            /** TGeo InUserCity. */
            public InUserCity: boolean;

            /** TGeo Level. */
            public Level: string;

            /** TGeo Street. */
            public Street: string;

            /**
             * Creates a new TGeo instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TGeo instance
             */
            public static create(properties?: NAlice.NData.ITGeo): NAlice.NData.TGeo;

            /**
             * Encodes the specified TGeo message. Does not implicitly {@link NAlice.NData.TGeo.verify|verify} messages.
             * @param message TGeo message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITGeo, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TGeo message, length delimited. Does not implicitly {@link NAlice.NData.TGeo.verify|verify} messages.
             * @param message TGeo message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITGeo, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TGeo message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TGeo
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TGeo;

            /**
             * Decodes a TGeo message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TGeo
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TGeo;

            /**
             * Verifies a TGeo message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TGeo message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TGeo
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TGeo;

            /**
             * Creates a plain object from a TGeo message. Also converts values to other types if specified.
             * @param message TGeo
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TGeo, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TGeo to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        namespace TGeo {

            /** Properties of a TCases. */
            interface ITCases {

                /** TCases Dative */
                Dative?: (string|null);

                /** TCases Genitive */
                Genitive?: (string|null);

                /** TCases Nominative */
                Nominative?: (string|null);

                /** TCases Preposition */
                Preposition?: (string|null);

                /** TCases Prepositional */
                Prepositional?: (string|null);
            }

            /** Represents a TCases. */
            class TCases implements ITCases {

                /**
                 * Constructs a new TCases.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: NAlice.NData.TGeo.ITCases);

                /** TCases Dative. */
                public Dative: string;

                /** TCases Genitive. */
                public Genitive: string;

                /** TCases Nominative. */
                public Nominative: string;

                /** TCases Preposition. */
                public Preposition: string;

                /** TCases Prepositional. */
                public Prepositional: string;

                /**
                 * Creates a new TCases instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns TCases instance
                 */
                public static create(properties?: NAlice.NData.TGeo.ITCases): NAlice.NData.TGeo.TCases;

                /**
                 * Encodes the specified TCases message. Does not implicitly {@link NAlice.NData.TGeo.TCases.verify|verify} messages.
                 * @param message TCases message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: NAlice.NData.TGeo.ITCases, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified TCases message, length delimited. Does not implicitly {@link NAlice.NData.TGeo.TCases.verify|verify} messages.
                 * @param message TCases message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: NAlice.NData.TGeo.ITCases, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a TCases message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns TCases
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TGeo.TCases;

                /**
                 * Decodes a TCases message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns TCases
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TGeo.TCases;

                /**
                 * Verifies a TCases message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a TCases message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns TCases
                 */
                public static fromObject(object: { [k: string]: any }): NAlice.NData.TGeo.TCases;

                /**
                 * Creates a plain object from a TCases message. Also converts values to other types if specified.
                 * @param message TCases
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: NAlice.NData.TGeo.TCases, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this TCases to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }
        }

        /** Properties of a TResolvedLocation. */
        interface ITResolvedLocation {

            /** TResolvedLocation CompanyName */
            CompanyName?: (string|null);

            /** TResolvedLocation Geo */
            Geo?: (NAlice.NData.ITGeo|null);

            /** TResolvedLocation GeoUri */
            GeoUri?: (string|null);

            /** TResolvedLocation Hours */
            Hours?: (NAlice.NData.TResolvedLocation.ITHours|null);

            /** TResolvedLocation Location */
            Location?: (NAlice.NData.TResolvedLocation.ITLocation|null);

            /** TResolvedLocation Name */
            Name?: (string|null);

            /** TResolvedLocation ObjectCatalogPhotosUri */
            ObjectCatalogPhotosUri?: (string|null);

            /** TResolvedLocation ObjectCatalogReviewsUri */
            ObjectCatalogReviewsUri?: (string|null);

            /** TResolvedLocation ObjectCatalogUri */
            ObjectCatalogUri?: (string|null);

            /** TResolvedLocation ObjectId */
            ObjectId?: (string|null);

            /** TResolvedLocation ObjectUri */
            ObjectUri?: (string|null);

            /** TResolvedLocation Phone */
            Phone?: (string|null);

            /** TResolvedLocation PhoneUri */
            PhoneUri?: (string|null);

            /** TResolvedLocation Url */
            Url?: (string|null);
        }

        /** Represents a TResolvedLocation. */
        class TResolvedLocation implements ITResolvedLocation {

            /**
             * Constructs a new TResolvedLocation.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITResolvedLocation);

            /** TResolvedLocation CompanyName. */
            public CompanyName: string;

            /** TResolvedLocation Geo. */
            public Geo?: (NAlice.NData.ITGeo|null);

            /** TResolvedLocation GeoUri. */
            public GeoUri: string;

            /** TResolvedLocation Hours. */
            public Hours?: (NAlice.NData.TResolvedLocation.ITHours|null);

            /** TResolvedLocation Location. */
            public Location?: (NAlice.NData.TResolvedLocation.ITLocation|null);

            /** TResolvedLocation Name. */
            public Name: string;

            /** TResolvedLocation ObjectCatalogPhotosUri. */
            public ObjectCatalogPhotosUri: string;

            /** TResolvedLocation ObjectCatalogReviewsUri. */
            public ObjectCatalogReviewsUri: string;

            /** TResolvedLocation ObjectCatalogUri. */
            public ObjectCatalogUri: string;

            /** TResolvedLocation ObjectId. */
            public ObjectId: string;

            /** TResolvedLocation ObjectUri. */
            public ObjectUri: string;

            /** TResolvedLocation Phone. */
            public Phone: string;

            /** TResolvedLocation PhoneUri. */
            public PhoneUri: string;

            /** TResolvedLocation Url. */
            public Url: string;

            /**
             * Creates a new TResolvedLocation instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TResolvedLocation instance
             */
            public static create(properties?: NAlice.NData.ITResolvedLocation): NAlice.NData.TResolvedLocation;

            /**
             * Encodes the specified TResolvedLocation message. Does not implicitly {@link NAlice.NData.TResolvedLocation.verify|verify} messages.
             * @param message TResolvedLocation message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITResolvedLocation, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TResolvedLocation message, length delimited. Does not implicitly {@link NAlice.NData.TResolvedLocation.verify|verify} messages.
             * @param message TResolvedLocation message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITResolvedLocation, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TResolvedLocation message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TResolvedLocation
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TResolvedLocation;

            /**
             * Decodes a TResolvedLocation message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TResolvedLocation
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TResolvedLocation;

            /**
             * Verifies a TResolvedLocation message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TResolvedLocation message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TResolvedLocation
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TResolvedLocation;

            /**
             * Creates a plain object from a TResolvedLocation message. Also converts values to other types if specified.
             * @param message TResolvedLocation
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TResolvedLocation, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TResolvedLocation to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        namespace TResolvedLocation {

            /** Properties of a TLocation. */
            interface ITLocation {

                /** TLocation Lat */
                Lat?: (number|null);

                /** TLocation Lon */
                Lon?: (number|null);
            }

            /** Represents a TLocation. */
            class TLocation implements ITLocation {

                /**
                 * Constructs a new TLocation.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: NAlice.NData.TResolvedLocation.ITLocation);

                /** TLocation Lat. */
                public Lat: number;

                /** TLocation Lon. */
                public Lon: number;

                /**
                 * Creates a new TLocation instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns TLocation instance
                 */
                public static create(properties?: NAlice.NData.TResolvedLocation.ITLocation): NAlice.NData.TResolvedLocation.TLocation;

                /**
                 * Encodes the specified TLocation message. Does not implicitly {@link NAlice.NData.TResolvedLocation.TLocation.verify|verify} messages.
                 * @param message TLocation message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: NAlice.NData.TResolvedLocation.ITLocation, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified TLocation message, length delimited. Does not implicitly {@link NAlice.NData.TResolvedLocation.TLocation.verify|verify} messages.
                 * @param message TLocation message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: NAlice.NData.TResolvedLocation.ITLocation, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a TLocation message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns TLocation
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TResolvedLocation.TLocation;

                /**
                 * Decodes a TLocation message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns TLocation
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TResolvedLocation.TLocation;

                /**
                 * Verifies a TLocation message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a TLocation message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns TLocation
                 */
                public static fromObject(object: { [k: string]: any }): NAlice.NData.TResolvedLocation.TLocation;

                /**
                 * Creates a plain object from a TLocation message. Also converts values to other types if specified.
                 * @param message TLocation
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: NAlice.NData.TResolvedLocation.TLocation, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this TLocation to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }

            /** Properties of a THours. */
            interface ITHours {

                /** THours CurrentStatus */
                CurrentStatus?: (string|null);

                /** THours Timezone */
                Timezone?: (string|null);

                /** THours Working */
                Working?: (NAlice.NData.TResolvedLocation.THours.ITWorking[]|null);
            }

            /** Represents a THours. */
            class THours implements ITHours {

                /**
                 * Constructs a new THours.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: NAlice.NData.TResolvedLocation.ITHours);

                /** THours CurrentStatus. */
                public CurrentStatus: string;

                /** THours Timezone. */
                public Timezone: string;

                /** THours Working. */
                public Working: NAlice.NData.TResolvedLocation.THours.ITWorking[];

                /**
                 * Creates a new THours instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns THours instance
                 */
                public static create(properties?: NAlice.NData.TResolvedLocation.ITHours): NAlice.NData.TResolvedLocation.THours;

                /**
                 * Encodes the specified THours message. Does not implicitly {@link NAlice.NData.TResolvedLocation.THours.verify|verify} messages.
                 * @param message THours message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: NAlice.NData.TResolvedLocation.ITHours, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified THours message, length delimited. Does not implicitly {@link NAlice.NData.TResolvedLocation.THours.verify|verify} messages.
                 * @param message THours message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: NAlice.NData.TResolvedLocation.ITHours, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a THours message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns THours
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TResolvedLocation.THours;

                /**
                 * Decodes a THours message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns THours
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TResolvedLocation.THours;

                /**
                 * Verifies a THours message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a THours message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns THours
                 */
                public static fromObject(object: { [k: string]: any }): NAlice.NData.TResolvedLocation.THours;

                /**
                 * Creates a plain object from a THours message. Also converts values to other types if specified.
                 * @param message THours
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: NAlice.NData.TResolvedLocation.THours, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this THours to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }

            namespace THours {

                /** Properties of a TWorking. */
                interface ITWorking {

                    /** TWorking From */
                    From?: (string|null);

                    /** TWorking To */
                    To?: (string|null);
                }

                /** Represents a TWorking. */
                class TWorking implements ITWorking {

                    /**
                     * Constructs a new TWorking.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: NAlice.NData.TResolvedLocation.THours.ITWorking);

                    /** TWorking From. */
                    public From: string;

                    /** TWorking To. */
                    public To: string;

                    /**
                     * Creates a new TWorking instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns TWorking instance
                     */
                    public static create(properties?: NAlice.NData.TResolvedLocation.THours.ITWorking): NAlice.NData.TResolvedLocation.THours.TWorking;

                    /**
                     * Encodes the specified TWorking message. Does not implicitly {@link NAlice.NData.TResolvedLocation.THours.TWorking.verify|verify} messages.
                     * @param message TWorking message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: NAlice.NData.TResolvedLocation.THours.ITWorking, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified TWorking message, length delimited. Does not implicitly {@link NAlice.NData.TResolvedLocation.THours.TWorking.verify|verify} messages.
                     * @param message TWorking message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: NAlice.NData.TResolvedLocation.THours.ITWorking, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a TWorking message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns TWorking
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TResolvedLocation.THours.TWorking;

                    /**
                     * Decodes a TWorking message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns TWorking
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TResolvedLocation.THours.TWorking;

                    /**
                     * Verifies a TWorking message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a TWorking message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns TWorking
                     */
                    public static fromObject(object: { [k: string]: any }): NAlice.NData.TResolvedLocation.THours.TWorking;

                    /**
                     * Creates a plain object from a TWorking message. Also converts values to other types if specified.
                     * @param message TWorking
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: NAlice.NData.TResolvedLocation.THours.TWorking, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this TWorking to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }
            }
        }

        /** Properties of a TRouteLocation. */
        interface ITRouteLocation {

            /** TRouteLocation ResolvedLocation */
            ResolvedLocation?: (NAlice.NData.ITResolvedLocation|null);

            /** TRouteLocation NamedLocation */
            NamedLocation?: (string|null);
        }

        /** Represents a TRouteLocation. */
        class TRouteLocation implements ITRouteLocation {

            /**
             * Constructs a new TRouteLocation.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITRouteLocation);

            /** TRouteLocation ResolvedLocation. */
            public ResolvedLocation?: (NAlice.NData.ITResolvedLocation|null);

            /** TRouteLocation NamedLocation. */
            public NamedLocation: string;

            /**
             * Creates a new TRouteLocation instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TRouteLocation instance
             */
            public static create(properties?: NAlice.NData.ITRouteLocation): NAlice.NData.TRouteLocation;

            /**
             * Encodes the specified TRouteLocation message. Does not implicitly {@link NAlice.NData.TRouteLocation.verify|verify} messages.
             * @param message TRouteLocation message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITRouteLocation, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TRouteLocation message, length delimited. Does not implicitly {@link NAlice.NData.TRouteLocation.verify|verify} messages.
             * @param message TRouteLocation message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITRouteLocation, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TRouteLocation message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TRouteLocation
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TRouteLocation;

            /**
             * Decodes a TRouteLocation message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TRouteLocation
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TRouteLocation;

            /**
             * Verifies a TRouteLocation message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TRouteLocation message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TRouteLocation
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TRouteLocation;

            /**
             * Creates a plain object from a TRouteLocation message. Also converts values to other types if specified.
             * @param message TRouteLocation
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TRouteLocation, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TRouteLocation to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a TRoute. */
        interface ITRoute {

            /** TRoute Type */
            Type?: (NAlice.NData.TRoute.EType|null);

            /** TRoute JamsTime */
            JamsTime?: (NAlice.NData.TRoute.ITSlot|null);

            /** TRoute Length */
            Length?: (NAlice.NData.TRoute.ITSlot|null);

            /** TRoute Time */
            Time?: (NAlice.NData.TRoute.ITSlot|null);

            /** TRoute MapsUri */
            MapsUri?: (string|null);

            /** TRoute Transfers */
            Transfers?: (number|Long|null);

            /** TRoute ImageUri */
            ImageUri?: (string|null);
        }

        /** Represents a TRoute. */
        class TRoute implements ITRoute {

            /**
             * Constructs a new TRoute.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITRoute);

            /** TRoute Type. */
            public Type: NAlice.NData.TRoute.EType;

            /** TRoute JamsTime. */
            public JamsTime?: (NAlice.NData.TRoute.ITSlot|null);

            /** TRoute Length. */
            public Length?: (NAlice.NData.TRoute.ITSlot|null);

            /** TRoute Time. */
            public Time?: (NAlice.NData.TRoute.ITSlot|null);

            /** TRoute MapsUri. */
            public MapsUri: string;

            /** TRoute Transfers. */
            public Transfers: (number|Long);

            /** TRoute ImageUri. */
            public ImageUri: string;

            /**
             * Creates a new TRoute instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TRoute instance
             */
            public static create(properties?: NAlice.NData.ITRoute): NAlice.NData.TRoute;

            /**
             * Encodes the specified TRoute message. Does not implicitly {@link NAlice.NData.TRoute.verify|verify} messages.
             * @param message TRoute message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITRoute, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TRoute message, length delimited. Does not implicitly {@link NAlice.NData.TRoute.verify|verify} messages.
             * @param message TRoute message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITRoute, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TRoute message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TRoute
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TRoute;

            /**
             * Decodes a TRoute message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TRoute
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TRoute;

            /**
             * Verifies a TRoute message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TRoute message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TRoute
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TRoute;

            /**
             * Creates a plain object from a TRoute message. Also converts values to other types if specified.
             * @param message TRoute
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TRoute, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TRoute to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        namespace TRoute {

            /** Properties of a TSlot. */
            interface ITSlot {

                /** TSlot Text */
                Text?: (string|null);

                /** TSlot Value */
                Value?: (number|null);
            }

            /** Represents a TSlot. */
            class TSlot implements ITSlot {

                /**
                 * Constructs a new TSlot.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: NAlice.NData.TRoute.ITSlot);

                /** TSlot Text. */
                public Text: string;

                /** TSlot Value. */
                public Value: number;

                /**
                 * Creates a new TSlot instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns TSlot instance
                 */
                public static create(properties?: NAlice.NData.TRoute.ITSlot): NAlice.NData.TRoute.TSlot;

                /**
                 * Encodes the specified TSlot message. Does not implicitly {@link NAlice.NData.TRoute.TSlot.verify|verify} messages.
                 * @param message TSlot message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: NAlice.NData.TRoute.ITSlot, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified TSlot message, length delimited. Does not implicitly {@link NAlice.NData.TRoute.TSlot.verify|verify} messages.
                 * @param message TSlot message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: NAlice.NData.TRoute.ITSlot, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a TSlot message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns TSlot
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TRoute.TSlot;

                /**
                 * Decodes a TSlot message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns TSlot
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TRoute.TSlot;

                /**
                 * Verifies a TSlot message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a TSlot message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns TSlot
                 */
                public static fromObject(object: { [k: string]: any }): NAlice.NData.TRoute.TSlot;

                /**
                 * Creates a plain object from a TSlot message. Also converts values to other types if specified.
                 * @param message TSlot
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: NAlice.NData.TRoute.TSlot, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this TSlot to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }

            /** EType enum. */
            enum EType {
                UNDEFINED = 0,
                CAR = 1,
                PEDESTRIAN = 2,
                PUBLIC_TRANSPORT = 3
            }
        }

        /** Properties of a TShowRouteData. */
        interface ITShowRouteData {

            /** TShowRouteData From */
            From?: (NAlice.NData.ITRouteLocation|null);

            /** TShowRouteData Via */
            Via?: (NAlice.NData.ITRouteLocation|null);

            /** TShowRouteData To */
            To?: (NAlice.NData.ITRouteLocation|null);

            /** TShowRouteData Routes */
            Routes?: (NAlice.NData.ITRoute[]|null);
        }

        /** Represents a TShowRouteData. */
        class TShowRouteData implements ITShowRouteData {

            /**
             * Constructs a new TShowRouteData.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITShowRouteData);

            /** TShowRouteData From. */
            public From?: (NAlice.NData.ITRouteLocation|null);

            /** TShowRouteData Via. */
            public Via?: (NAlice.NData.ITRouteLocation|null);

            /** TShowRouteData To. */
            public To?: (NAlice.NData.ITRouteLocation|null);

            /** TShowRouteData Routes. */
            public Routes: NAlice.NData.ITRoute[];

            /**
             * Creates a new TShowRouteData instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TShowRouteData instance
             */
            public static create(properties?: NAlice.NData.ITShowRouteData): NAlice.NData.TShowRouteData;

            /**
             * Encodes the specified TShowRouteData message. Does not implicitly {@link NAlice.NData.TShowRouteData.verify|verify} messages.
             * @param message TShowRouteData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITShowRouteData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TShowRouteData message, length delimited. Does not implicitly {@link NAlice.NData.TShowRouteData.verify|verify} messages.
             * @param message TShowRouteData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITShowRouteData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TShowRouteData message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TShowRouteData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TShowRouteData;

            /**
             * Decodes a TShowRouteData message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TShowRouteData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TShowRouteData;

            /**
             * Verifies a TShowRouteData message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TShowRouteData message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TShowRouteData
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TShowRouteData;

            /**
             * Creates a plain object from a TShowRouteData message. Also converts values to other types if specified.
             * @param message TShowRouteData
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TShowRouteData, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TShowRouteData to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a TSearchObjectData. */
        interface ITSearchObjectData {

            /** TSearchObjectData SnippetType */
            SnippetType?: (string|null);

            /** TSearchObjectData Text */
            Text?: (string|null);

            /** TSearchObjectData Question */
            Question?: (string|null);

            /** TSearchObjectData Image */
            Image?: (string|null);

            /** TSearchObjectData SearchUrl */
            SearchUrl?: (string|null);

            /** TSearchObjectData Url */
            Url?: (string|null);

            /** TSearchObjectData Hostname */
            Hostname?: (string|null);

            /** TSearchObjectData Title */
            Title?: (string|null);

            /** TSearchObjectData GalleryImages */
            GalleryImages?: (NAlice.NData.TSearchObjectData.ITGalleryImage[]|null);
        }

        /** Represents a TSearchObjectData. */
        class TSearchObjectData implements ITSearchObjectData {

            /**
             * Constructs a new TSearchObjectData.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITSearchObjectData);

            /** TSearchObjectData SnippetType. */
            public SnippetType: string;

            /** TSearchObjectData Text. */
            public Text: string;

            /** TSearchObjectData Question. */
            public Question: string;

            /** TSearchObjectData Image. */
            public Image: string;

            /** TSearchObjectData SearchUrl. */
            public SearchUrl: string;

            /** TSearchObjectData Url. */
            public Url: string;

            /** TSearchObjectData Hostname. */
            public Hostname: string;

            /** TSearchObjectData Title. */
            public Title: string;

            /** TSearchObjectData GalleryImages. */
            public GalleryImages: NAlice.NData.TSearchObjectData.ITGalleryImage[];

            /**
             * Creates a new TSearchObjectData instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TSearchObjectData instance
             */
            public static create(properties?: NAlice.NData.ITSearchObjectData): NAlice.NData.TSearchObjectData;

            /**
             * Encodes the specified TSearchObjectData message. Does not implicitly {@link NAlice.NData.TSearchObjectData.verify|verify} messages.
             * @param message TSearchObjectData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITSearchObjectData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TSearchObjectData message, length delimited. Does not implicitly {@link NAlice.NData.TSearchObjectData.verify|verify} messages.
             * @param message TSearchObjectData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITSearchObjectData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TSearchObjectData message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TSearchObjectData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TSearchObjectData;

            /**
             * Decodes a TSearchObjectData message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TSearchObjectData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TSearchObjectData;

            /**
             * Verifies a TSearchObjectData message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TSearchObjectData message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TSearchObjectData
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TSearchObjectData;

            /**
             * Creates a plain object from a TSearchObjectData message. Also converts values to other types if specified.
             * @param message TSearchObjectData
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TSearchObjectData, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TSearchObjectData to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        namespace TSearchObjectData {

            /** Properties of a TGalleryImage. */
            interface ITGalleryImage {

                /** TGalleryImage ThmbHref */
                ThmbHref?: (string|null);

                /** TGalleryImage ThmbHOrig */
                ThmbHOrig?: (number|null);

                /** TGalleryImage ThmbWOrig */
                ThmbWOrig?: (number|null);
            }

            /** Represents a TGalleryImage. */
            class TGalleryImage implements ITGalleryImage {

                /**
                 * Constructs a new TGalleryImage.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: NAlice.NData.TSearchObjectData.ITGalleryImage);

                /** TGalleryImage ThmbHref. */
                public ThmbHref: string;

                /** TGalleryImage ThmbHOrig. */
                public ThmbHOrig: number;

                /** TGalleryImage ThmbWOrig. */
                public ThmbWOrig: number;

                /**
                 * Creates a new TGalleryImage instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns TGalleryImage instance
                 */
                public static create(properties?: NAlice.NData.TSearchObjectData.ITGalleryImage): NAlice.NData.TSearchObjectData.TGalleryImage;

                /**
                 * Encodes the specified TGalleryImage message. Does not implicitly {@link NAlice.NData.TSearchObjectData.TGalleryImage.verify|verify} messages.
                 * @param message TGalleryImage message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: NAlice.NData.TSearchObjectData.ITGalleryImage, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified TGalleryImage message, length delimited. Does not implicitly {@link NAlice.NData.TSearchObjectData.TGalleryImage.verify|verify} messages.
                 * @param message TGalleryImage message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: NAlice.NData.TSearchObjectData.ITGalleryImage, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a TGalleryImage message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns TGalleryImage
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TSearchObjectData.TGalleryImage;

                /**
                 * Decodes a TGalleryImage message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns TGalleryImage
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TSearchObjectData.TGalleryImage;

                /**
                 * Verifies a TGalleryImage message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a TGalleryImage message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns TGalleryImage
                 */
                public static fromObject(object: { [k: string]: any }): NAlice.NData.TSearchObjectData.TGalleryImage;

                /**
                 * Creates a plain object from a TGalleryImage message. Also converts values to other types if specified.
                 * @param message TGalleryImage
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: NAlice.NData.TSearchObjectData.TGalleryImage, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this TGalleryImage to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }
        }

        /** Properties of a TTrafficForecastData. */
        interface ITTrafficForecastData {

            /** TTrafficForecastData Hour */
            Hour?: (number|null);

            /** TTrafficForecastData Score */
            Score?: (number|null);
        }

        /** Represents a TTrafficForecastData. */
        class TTrafficForecastData implements ITTrafficForecastData {

            /**
             * Constructs a new TTrafficForecastData.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITTrafficForecastData);

            /** TTrafficForecastData Hour. */
            public Hour: number;

            /** TTrafficForecastData Score. */
            public Score: number;

            /**
             * Creates a new TTrafficForecastData instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TTrafficForecastData instance
             */
            public static create(properties?: NAlice.NData.ITTrafficForecastData): NAlice.NData.TTrafficForecastData;

            /**
             * Encodes the specified TTrafficForecastData message. Does not implicitly {@link NAlice.NData.TTrafficForecastData.verify|verify} messages.
             * @param message TTrafficForecastData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITTrafficForecastData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TTrafficForecastData message, length delimited. Does not implicitly {@link NAlice.NData.TTrafficForecastData.verify|verify} messages.
             * @param message TTrafficForecastData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITTrafficForecastData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TTrafficForecastData message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TTrafficForecastData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TTrafficForecastData;

            /**
             * Decodes a TTrafficForecastData message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TTrafficForecastData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TTrafficForecastData;

            /**
             * Verifies a TTrafficForecastData message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TTrafficForecastData message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TTrafficForecastData
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TTrafficForecastData;

            /**
             * Creates a plain object from a TTrafficForecastData message. Also converts values to other types if specified.
             * @param message TTrafficForecastData
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TTrafficForecastData, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TTrafficForecastData to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a TTrafficWidgetData. */
        interface ITTrafficWidgetData {

            /** TTrafficWidgetData City */
            City?: (string|null);

            /** TTrafficWidgetData Message */
            Message?: (string|null);

            /** TTrafficWidgetData MapUrl */
            MapUrl?: (string|null);

            /** TTrafficWidgetData ImageUrl */
            ImageUrl?: (string|null);

            /** TTrafficWidgetData Level */
            Level?: (string|null);

            /** TTrafficWidgetData Score */
            Score?: (number|null);

            /** TTrafficWidgetData Forecast */
            Forecast?: (NAlice.NData.ITTrafficForecastData[]|null);
        }

        /** Represents a TTrafficWidgetData. */
        class TTrafficWidgetData implements ITTrafficWidgetData {

            /**
             * Constructs a new TTrafficWidgetData.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITTrafficWidgetData);

            /** TTrafficWidgetData City. */
            public City: string;

            /** TTrafficWidgetData Message. */
            public Message: string;

            /** TTrafficWidgetData MapUrl. */
            public MapUrl: string;

            /** TTrafficWidgetData ImageUrl. */
            public ImageUrl: string;

            /** TTrafficWidgetData Level. */
            public Level: string;

            /** TTrafficWidgetData Score. */
            public Score: number;

            /** TTrafficWidgetData Forecast. */
            public Forecast: NAlice.NData.ITTrafficForecastData[];

            /**
             * Creates a new TTrafficWidgetData instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TTrafficWidgetData instance
             */
            public static create(properties?: NAlice.NData.ITTrafficWidgetData): NAlice.NData.TTrafficWidgetData;

            /**
             * Encodes the specified TTrafficWidgetData message. Does not implicitly {@link NAlice.NData.TTrafficWidgetData.verify|verify} messages.
             * @param message TTrafficWidgetData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITTrafficWidgetData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TTrafficWidgetData message, length delimited. Does not implicitly {@link NAlice.NData.TTrafficWidgetData.verify|verify} messages.
             * @param message TTrafficWidgetData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITTrafficWidgetData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TTrafficWidgetData message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TTrafficWidgetData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TTrafficWidgetData;

            /**
             * Decodes a TTrafficWidgetData message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TTrafficWidgetData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TTrafficWidgetData;

            /**
             * Verifies a TTrafficWidgetData message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a TTrafficWidgetData message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns TTrafficWidgetData
             */
            public static fromObject(object: { [k: string]: any }): NAlice.NData.TTrafficWidgetData;

            /**
             * Creates a plain object from a TTrafficWidgetData message. Also converts values to other types if specified.
             * @param message TTrafficWidgetData
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: NAlice.NData.TTrafficWidgetData, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this TTrafficWidgetData to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a TTrafficCardData. */
        interface ITTrafficCardData {

            /** TTrafficCardData City */
            City?: (string|null);

            /** TTrafficCardData CityPrepcase */
            CityPrepcase?: (string|null);

            /** TTrafficCardData InUserCity */
            InUserCity?: (boolean|null);

            /** TTrafficCardData ImageUrl */
            ImageUrl?: (string|null);

            /** TTrafficCardData MapUrl */
            MapUrl?: (string|null);

            /** TTrafficCardData Message */
            Message?: (string|null);

            /** TTrafficCardData Level */
            Level?: (string|null);

            /** TTrafficCardData Icon */
            Icon?: (string|null);

            /** TTrafficCardData TrafficLightsImageUrl */
            TrafficLightsImageUrl?: (string|null);

            /** TTrafficCardData Forecast */
            Forecast?: (NAlice.NData.ITTrafficForecastData[]|null);
        }

        /** Represents a TTrafficCardData. */
        class TTrafficCardData implements ITTrafficCardData {

            /**
             * Constructs a new TTrafficCardData.
             * @param [properties] Properties to set
             */
            constructor(properties?: NAlice.NData.ITTrafficCardData);

            /** TTrafficCardData City. */
            public City: string;

            /** TTrafficCardData CityPrepcase. */
            public CityPrepcase: string;

            /** TTrafficCardData InUserCity. */
            public InUserCity: boolean;

            /** TTrafficCardData ImageUrl. */
            public ImageUrl: string;

            /** TTrafficCardData MapUrl. */
            public MapUrl: string;

            /** TTrafficCardData Message. */
            public Message: string;

            /** TTrafficCardData Level. */
            public Level: string;

            /** TTrafficCardData Icon. */
            public Icon: string;

            /** TTrafficCardData TrafficLightsImageUrl. */
            public TrafficLightsImageUrl: string;

            /** TTrafficCardData Forecast. */
            public Forecast: NAlice.NData.ITTrafficForecastData[];

            /**
             * Creates a new TTrafficCardData instance using the specified properties.
             * @param [properties] Properties to set
             * @returns TTrafficCardData instance
             */
            public static create(properties?: NAlice.NData.ITTrafficCardData): NAlice.NData.TTrafficCardData;

            /**
             * Encodes the specified TTrafficCardData message. Does not implicitly {@link NAlice.NData.TTrafficCardData.verify|verify} messages.
             * @param message TTrafficCardData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: NAlice.NData.ITTrafficCardData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified TTrafficCardData message, length delimited. Does not implicitly {@link NAlice.NData.TTrafficCardData.verify|verify} messages.
             * @param message TTrafficCardData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: NAlice.NData.ITTrafficCardData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a TTrafficCardData message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns TTrafficCardData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAlice.NData.TTrafficCardData;

            /**
             * Decodes a TTrafficCardData message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns TTrafficCardData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAlice.NData.TTrafficCardData;

            /**
             * Verifies a TTrafficCardData message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             