/*eslint-disable block-scoped-var, id-length, no-control-regex, no-magic-numbers, no-prototype-builtins, no-redeclare, no-shadow, no-var, sort-vars*/
"use strict";

var $protobuf = require("protobufjs/minimal");

// Common aliases
var $Reader = $protobuf.Reader, $Writer = $protobuf.Writer, $util = $protobuf.util;

// Exported root namespace
var $root = $protobuf.roots["default"] || ($protobuf.roots["default"] = {});

$root.NAlice = (function() {

    /**
     * Namespace NAlice.
     * @exports NAlice
     * @namespace
     */
    var NAlice = {};

    NAlice.NRenderer = (function() {

        /**
         * Namespace NRenderer.
         * @memberof NAlice
         * @namespace
         */
        var NRenderer = {};

        NRenderer.TRenderResponse = (function() {

            /**
             * Properties of a TRenderResponse.
             * @memberof NAlice.NRenderer
             * @interface ITRenderResponse
             * @property {string|null} [CardId] TRenderResponse CardId
             * @property {google.protobuf.IStruct|null} [Div2Body] TRenderResponse Div2Body
             * @property {string|null} [StringDiv2Body] TRenderResponse StringDiv2Body
             * @property {NAlice.NRenderer.TRenderResponse.IDiv2Patch|null} [Div2PatchBody] TRenderResponse Div2PatchBody
             * @property {Object.<string,NAlice.NRenderer.TRenderResponse.IDiv2Template>|null} [GlobalDiv2Templates] TRenderResponse GlobalDiv2Templates
             * @property {string|null} [CardName] TRenderResponse CardName
             */

            /**
             * Constructs a new TRenderResponse.
             * @memberof NAlice.NRenderer
             * @classdesc Represents a TRenderResponse.
             * @implements ITRenderResponse
             * @constructor
             * @param {NAlice.NRenderer.ITRenderResponse=} [properties] Properties to set
             */
            function TRenderResponse(properties) {
                this.GlobalDiv2Templates = {};
                if (properties)
                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                        if (properties[keys[i]] != null)
                            this[keys[i]] = properties[keys[i]];
            }

            /**
             * TRenderResponse CardId.
             * @member {string} CardId
             * @memberof NAlice.NRenderer.TRenderResponse
             * @instance
             */
            TRenderResponse.prototype.CardId = "";

            /**
             * TRenderResponse Div2Body.
             * @member {google.protobuf.IStruct|null|undefined} Div2Body
             * @memberof NAlice.NRenderer.TRenderResponse
             * @instance
             */
            TRenderResponse.prototype.Div2Body = null;

            /**
             * TRenderResponse StringDiv2Body.
             * @member {string|null|undefined} StringDiv2Body
             * @memberof NAlice.NRenderer.TRenderResponse
             * @instance
             */
            TRenderResponse.prototype.StringDiv2Body = null;

            /**
             * TRenderResponse Div2PatchBody.
             * @member {NAlice.NRenderer.TRenderResponse.IDiv2Patch|null|undefined} Div2PatchBody
             * @memberof NAlice.NRenderer.TRenderResponse
             * @instance
             */
            TRenderResponse.prototype.Div2PatchBody = null;

            /**
             * TRenderResponse GlobalDiv2Templates.
             * @member {Object.<string,NAlice.NRenderer.TRenderResponse.IDiv2Template>} GlobalDiv2Templates
             * @memberof NAlice.NRenderer.TRenderResponse
             * @instance
             */
            TRenderResponse.prototype.GlobalDiv2Templates = $util.emptyObject;

            /**
             * TRenderResponse CardName.
             * @member {string} CardName
             * @memberof NAlice.NRenderer.TRenderResponse
             * @instance
             */
            TRenderResponse.prototype.CardName = "";

            // OneOf field names bound to virtual getters and setters
            var $oneOfFields;

            /**
             * TRenderResponse Div2.
             * @member {"Div2Body"|"StringDiv2Body"|"Div2PatchBody"|undefined} Div2
             * @memberof NAlice.NRenderer.TRenderResponse
             * @instance
             */
            Object.defineProperty(TRenderResponse.prototype, "Div2", {
                get: $util.oneOfGetter($oneOfFields = ["Div2Body", "StringDiv2Body", "Div2PatchBody"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            /**
             * Creates a new TRenderResponse instance using the specified properties.
             * @function create
             * @memberof NAlice.NRenderer.TRenderResponse
             * @static
             * @param {NAlice.NRenderer.ITRenderResponse=} [properties] Properties to set
             * @returns {NAlice.NRenderer.TRenderResponse} TRenderResponse instance
             */
            TRenderResponse.create = function create(properties) {
                return new TRenderResponse(properties);
            };

            /**
             * Encodes the specified TRenderResponse message. Does not implicitly {@link NAlice.NRenderer.TRenderResponse.verify|verify} messages.
             * @function encode
             * @memberof NAlice.NRenderer.TRenderResponse
             * @static
             * @param {NAlice.NRenderer.ITRenderResponse} message TRenderResponse message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            TRenderResponse.encode = function encode(message, writer) {
                if (!writer)
                    writer = $Writer.create();
                if (message.CardId != null && Object.hasOwnProperty.call(message, "CardId"))
                    writer.uint32(/* id 1, wireType 2 =*/10).string(message.CardId);
                if (message.Div2Body != null && Object.hasOwnProperty.call(message, "Div2Body"))
                    $root.google.protobuf.Struct.encode(message.Div2Body, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                if (message.GlobalDiv2Templates != null && Object.hasOwnProperty.call(message, "GlobalDiv2Templates"))
                    for (var keys = Object.keys(message.GlobalDiv2Templates), i = 0; i < keys.length; ++i) {
                        writer.uint32(/* id 3, wireType 2 =*/26).fork().uint32(/* id 1, wireType 2 =*/10).string(keys[i]);
                        $root.NAlice.NRenderer.TRenderResponse.Div2Template.encode(message.GlobalDiv2Templates[keys[i]], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim().ldelim();
                    }
                if (message.CardName != null && Object.hasOwnProperty.call(message, "CardName"))
                    writer.uint32(/* id 4, wireType 2 =*/34).string(message.CardName);
                if (message.StringDiv2Body != null && Object.hasOwnProperty.call(message, "StringDiv2Body"))
                    writer.uint32(/* id 5, wireType 2 =*/42).string(message.StringDiv2Body);
                if (message.Div2PatchBody != null && Object.hasOwnProperty.call(message, "Div2PatchBody"))
                    $root.NAlice.NRenderer.TRenderResponse.Div2Patch.encode(message.Div2PatchBody, writer.uint32(/* id 7, wireType 2 =*/58).fork()).ldelim();
                return writer;
            };

            /**
             * Encodes the specified TRenderResponse message, length delimited. Does not implicitly {@link NAlice.NRenderer.TRenderResponse.verify|verify} messages.
             * @function encodeDelimited
             * @memberof NAlice.NRenderer.TRenderResponse
             * @static
             * @param {NAlice.NRenderer.ITRenderResponse} message TRenderResponse message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            TRenderResponse.encodeDelimited = function encodeDelimited(message, writer) {
                return this.encode(message, writer).ldelim();
            };

            /**
             * Decodes a TRenderResponse message from the specified reader or buffer.
             * @function decode
             * @memberof NAlice.NRenderer.TRenderResponse
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @param {number} [length] Message length if known beforehand
             * @returns {NAlice.NRenderer.TRenderResponse} TRenderResponse
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            TRenderResponse.decode = function decode(reader, length) {
                if (!(reader instanceof $Reader))
                    reader = $Reader.create(reader);
                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.NAlice.NRenderer.TRenderResponse(), key, value;
                while (reader.pos < end) {
                    var tag = reader.uint32();
                    switch (tag >>> 3) {
                    case 1:
                        message.CardId = reader.string();
                        break;
                    case 2:
                        message.Div2Body = $root.google.protobuf.Struct.decode(reader, reader.uint32());
                        break;
                    case 5:
                        message.StringDiv2Body = reader.string();
                        break;
                    case 7:
                        message.Div2PatchBody = $root.NAlice.NRenderer.TRenderResponse.Div2Patch.decode(reader, reader.uint32());
                        break;
                    case 3:
                        if (message.GlobalDiv2Templates === $util.emptyObject)
                            message.GlobalDiv2Templates = {};
                        var end2 = reader.uint32() + reader.pos;
                        key = "";
                        value = null;
                        while (reader.pos < end2) {
                            var tag2 = reader.uint32();
                            switch (tag2 >>> 3) {
                            case 1:
                                key = reader.string();
                                break;
                            case 2:
                                value = $root.NAlice.NRenderer.TRenderResponse.Div2Template.decode(reader, reader.uint32());
                                break;
                            default:
                                reader.skipType(tag2 & 7);
                                break;
                            }
                        }
                        message.GlobalDiv2Templates[key] = value;
                        break;
                    case 4:
                        message.CardName = reader.string();
                        break;
                    default:
                        reader.skipType(tag & 7);
                        break;
                    }
                }
                return message;
            };

            /**
             * Decodes a TRenderResponse message from the specified reader or buffer, length delimited.
             * @function decodeDelimited
             * @memberof NAlice.NRenderer.TRenderResponse
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @returns {NAlice.NRenderer.TRenderResponse} TRenderResponse
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            TRenderResponse.decodeDelimited = function decodeDelimited(reader) {
                if (!(reader instanceof $Reader))
                    reader = new $Reader(reader);
                return this.decode(reader, reader.uint32());
            };

            /**
             * Verifies a TRenderResponse message.
             * @function verify
             * @memberof NAlice.NRenderer.TRenderResponse
             * @static
             * @param {Object.<string,*>} message Plain object to verify
             * @returns {string|null} `null` if valid, otherwise the reason why it is not
             */
            TRenderResponse.verify = function verify(message) {
                if (typeof message !== "object" || message === null)
                    return "object expected";
                var properties = {};
                if (message.CardId != null && message.hasOwnProperty("CardId"))
                    if (!$util.isString(message.CardId))
                        return "CardId: string expected";
                if (message.Div2Body != null && message.hasOwnProperty("Div2Body")) {
                    properties.Div2 = 1;
                    {
                        var error = $root.google.protobuf.Struct.verify(message.Div2Body);
                        if (error)
                            return "Div2Body." + error;
                    }
                }
                if (message.StringDiv2Body != null && message.hasOwnProperty("StringDiv2Body")) {
                    if (properties.Div2 === 1)
                        return "Div2: multiple values";
                    properties.Div2 = 1;
                    if (!$util.isString(message.StringDiv2Body))
                        return "StringDiv2Body: string expected";
                }
                if (message.Div2PatchBody != null && message.hasOwnProperty("Div2PatchBody")) {
                    if (properties.Div2 === 1)
                        return "Div2: multiple values";
                    properties.Div2 = 1;
                    {
                        var error = $root.NAlice.NRenderer.TRenderResponse.Div2Patch.verify(message.Div2PatchBody);
                        if (error)
                            return "Div2PatchBody." + error;
                    }
                }
                if (message.GlobalDiv2Templates != null && message.hasOwnProperty("GlobalDiv2Templates")) {
                    if (!$util.isObject(message.GlobalDiv2Templates))
                        return "GlobalDiv2Templates: object expected";
                    var key = Object.keys(message.GlobalDiv2Templates);
                    for (var i = 0; i < key.length; ++i) {
                        var error = $root.NAlice.NRenderer.TRenderResponse.Div2Template.verify(message.GlobalDiv2Templates[key[i]]);
                        if (error)
                            return "GlobalDiv2Templates." + error;
                    }
                }
                if (message.CardName != null && message.hasOwnProperty("CardName"))
                    if (!$util.isString(message.CardName))
                        return "CardName: string expected";
                return null;
            };

            /**
             * Creates a TRenderResponse message from a plain object. Also converts values to their respective internal types.
             * @function fromObject
             * @memberof NAlice.NRenderer.TRenderResponse
             * @static
             * @param {Object.<string,*>} object Plain object
             * @returns {NAlice.NRenderer.TRenderResponse} TRenderResponse
             */
            TRenderResponse.fromObject = function fromObject(object) {
                if (object instanceof $root.NAlice.NRenderer.TRenderResponse)
                    return object;
                var message = new $root.NAlice.NRenderer.TRenderResponse();
                if (object.CardId != null)
                    message.CardId = String(object.CardId);
                if (object.Div2Body != null) {
                    if (typeof object.Div2Body !== "object")
                        throw TypeError(".NAlice.NRenderer.TRenderResponse.Div2Body: object expected");
                    message.Div2Body = $root.google.protobuf.Struct.fromObject(object.Div2Body);
                }
                if (object.StringDiv2Body != null)
                    message.StringDiv2Body = String(object.StringDiv2Body);
                if (object.Div2PatchBody != null) {
                    if (typeof object.Div2PatchBody !== "object")
                        throw TypeError(".NAlice.NRenderer.TRenderResponse.Div2PatchBody: object expected");
                    message.Div2PatchBody = $root.NAlice.NRenderer.TRenderResponse.Div2Patch.fromObject(object.Div2PatchBody);
                }
                if (object.GlobalDiv2Templates) {
                    if (typeof object.GlobalDiv2Templates !== "object")
                        throw TypeError(".NAlice.NRenderer.TRenderResponse.GlobalDiv2Templates: object expected");
                    message.GlobalDiv2Templates = {};
                    for (var keys = Object.keys(object.GlobalDiv2Templates), i = 0; i < keys.length; ++i) {
                        if (typeof object.GlobalDiv2Templates[keys[i]] !== "object")
                            throw TypeError(".NAlice.NRenderer.TRenderResponse.GlobalDiv2Templates: object expected");
                        message.GlobalDiv2Templates[keys[i]] = $root.NAlice.NRenderer.TRenderResponse.Div2Template.fromObject(object.GlobalDiv2Templates[keys[i]]);
                    }
                }
                if (object.CardName != null)
                    message.CardName = String(object.CardName);
                return message;
            };

            /**
             * Creates a plain object from a TRenderResponse message. Also converts values to other types if specified.
             * @function toObject
             * @memberof NAlice.NRenderer.TRenderResponse
             * @static
             * @param {NAlice.NRenderer.TRenderResponse} message TRenderResponse
             * @param {$protobuf.IConversionOptions} [options] Conversion options
             * @returns {Object.<string,*>} Plain object
             */
            TRenderResponse.toObject = function toObject(message, options) {
                if (!options)
                    options = {};
                var object = {};
                if (options.objects || options.defaults)
                    object.GlobalDiv2Templates = {};
                if (options.defaults) {
                    object.CardId = "";
                    object.CardName = "";
                }
                if (message.CardId != null && message.hasOwnProperty("CardId"))
                    object.CardId = message.CardId;
                if (message.Div2Body != null && message.hasOwnProperty("Div2Body")) {
                    object.Div2Body = $root.google.protobuf.Struct.toObject(message.Div2Body, options);
                    if (options.oneofs)
                        object.Div2 = "Div2Body";
                }
                var keys2;
                if (message.GlobalDiv2Templates && (keys2 = Object.keys(message.GlobalDiv2Templates)).length) {
                    object.GlobalDiv2Templates = {};
                    for (var j = 0; j < keys2.length; ++j)
                        object.GlobalDiv2Templates[keys2[j]] = $root.NAlice.NRenderer.TRenderResponse.Div2Template.toObject(message.GlobalDiv2Templates[keys2[j]], options);
                }
                if (message.CardName != null && message.hasOwnProperty("CardName"))
                    object.CardName = message.CardName;
                if (message.StringDiv2Body != null && message.hasOwnProperty("StringDiv2Body")) {
                    object.StringDiv2Body = message.StringDiv2Body;
                    if (options.oneofs)
                        object.Div2 = "StringDiv2Body";
                }
                if (message.Div2PatchBody != null && message.hasOwnProperty("Div2PatchBody")) {
                    object.Div2PatchBody = $root.NAlice.NRenderer.TRenderResponse.Div2Patch.toObject(message.Div2PatchBody, options);
                    if (options.oneofs)
                        object.Div2 = "Div2PatchBody";
                }
                return object;
            };

            /**
             * Converts this TRenderResponse to JSON.
             * @function toJSON
             * @memberof NAlice.NRenderer.TRenderResponse
             * @instance
             * @returns {Object.<string,*>} JSON object
             */
            TRenderResponse.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            TRenderResponse.Div2Template = (function() {

                /**
                 * Properties of a Div2Template.
                 * @memberof NAlice.NRenderer.TRenderResponse
                 * @interface IDiv2Template
                 * @property {google.protobuf.IStruct|null} [Body] Div2Template Body
                 * @property {string|null} [StringBody] Div2Template StringBody
                 */

                /**
                 * Constructs a new Div2Template.
                 * @memberof NAlice.NRenderer.TRenderResponse
                 * @classdesc Represents a Div2Template.
                 * @implements IDiv2Template
                 * @constructor
                 * @param {NAlice.NRenderer.TRenderResponse.IDiv2Template=} [properties] Properties to set
                 */
                function Div2Template(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }

                /**
                 * Div2Template Body.
                 * @member {google.protobuf.IStruct|null|undefined} Body
                 * @memberof NAlice.NRenderer.TRenderResponse.Div2Template
                 * @instance
                 */
                Div2Template.prototype.Body = null;

                /**
                 * Div2Template StringBody.
                 * @member {string|null|undefined} StringBody
                 * @memberof NAlice.NRenderer.TRenderResponse.Div2Template
                 * @instance
                 */
                Div2Template.prototype.StringBody = null;

                // OneOf field names bound to virtual getters and setters
                var $oneOfFields;

                /**
                 * Div2Template Div2.
                 * @member {"Body"|"StringBody"|undefined} Div2
                 * @memberof NAlice.NRenderer.TRenderResponse.Div2Template
                 * @instance
                 */
                Object.defineProperty(Div2Template.prototype, "Div2", {
                    get: $util.oneOfGetter($oneOfFields = ["Body", "StringBody"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                /**
                 * Creates a new Div2Template instance using the specified properties.
                 * @function create
                 * @memberof NAlice.NRenderer.TRenderResponse.Div2Template
                 * @static
                 * @param {NAlice.NRenderer.TRenderResponse.IDiv2Template=} [properties] Properties to set
                 * @returns {NAlice.NRenderer.TRenderResponse.Div2Template} Div2Template instance
                 */
                Div2Template.create = function create(properties) {
                    return new Div2Template(properties);
                };

                /**
                 * Encodes the specified Div2Template message. Does not implicitly {@link NAlice.NRenderer.TRenderResponse.Div2Template.verify|verify} messages.
                 * @function encode
                 * @memberof NAlice.NRenderer.TRenderResponse.Div2Template
                 * @static
                 * @param {NAlice.NRenderer.TRenderResponse.IDiv2Template} message Div2Template message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                Div2Template.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.Body != null && Object.hasOwnProperty.call(message, "Body"))
                        $root.google.protobuf.Struct.encode(message.Body, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                    if (message.StringBody != null && Object.hasOwnProperty.call(message, "StringBody"))
                        writer.uint32(/* id 6, wireType 2 =*/50).string(message.StringBody);
                    return writer;
                };

                /**
                 * Encodes the specified Div2Template message, length delimited. Does not implicitly {@link NAlice.NRenderer.TRenderResponse.Div2Template.verify|verify} messages.
                 * @function encodeDelimited
                 * @memberof NAlice.NRenderer.TRenderResponse.Div2Template
                 * @static
                 * @param {NAlice.NRenderer.TRenderResponse.IDiv2Template} message Div2Template message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                Div2Template.encodeDelimited = function encodeDelimited(message, writer) {
                    return this.encode(message, writer).ldelim();
                };

                /**
                 * Decodes a Div2Template message from the specified reader or buffer.
                 * @function decode
                 * @memberof NAlice.NRenderer.TRenderResponse.Div2Template
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {NAlice.NRenderer.TRenderResponse.Div2Template} Div2Template
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                Div2Template.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.NAlice.NRenderer.TRenderResponse.Div2Template();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.Body = $root.google.protobuf.Struct.decode(reader, reader.uint32());
                            break;
                        case 6:
                            message.StringBody = reader.string();
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };

                /**
                 * Decodes a Div2Template message from the specified reader or buffer, length delimited.
                 * @function decodeDelimited
                 * @memberof NAlice.NRenderer.TRenderResponse.Div2Template
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @returns {NAlice.NRenderer.TRenderResponse.Div2Template} Div2Template
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                Div2Template.decodeDelimited = function decodeDelimited(reader) {
                    if (!(reader instanceof $Reader))
                        reader = new $Reader(reader);
                    return this.decode(reader, reader.uint32());
                };

                /**
                 * Verifies a Div2Template message.
                 * @function verify
                 * @memberof NAlice.NRenderer.TRenderResponse.Div2Template
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                Div2Template.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    var properties = {};
                    if (message.Body != null && message.hasOwnProperty("Body")) {
                        properties.Div2 = 1;
                        {
                            var error = $root.google.protobuf.Struct.verify(message.Body);
                            if (error)
                                return "Body." + error;
                        }
                    }
                    if (message.StringBody != null && message.hasOwnProperty("StringBody")) {
                        if (properties.Div2 === 1)
                            return "Div2: multiple values";
                        properties.Div2 = 1;
                        if (!$util.isString(message.StringBody))
                            return "StringBody: string expected";
                    }
                    return null;
                };

                /**
                 * Creates a Div2Template message from a plain object. Also converts values to their respective internal types.
                 * @function fromObject
                 * @memberof NAlice.NRenderer.TRenderResponse.Div2Template
                 * @static
                 * @param {Object.<string,*>} object Plain object
                 * @returns {NAlice.NRenderer.TRenderResponse.Div2Template} Div2Template
                 */
                Div2Template.fromObject = function fromObject(object) {
                    if (object instanceof $root.NAlice.NRenderer.TRenderResponse.Div2Template)
                        return object;
                    var message = new $root.NAlice.NRenderer.TRenderResponse.Div2Template();
                    if (object.Body != null) {
                        if (typeof object.Body !== "object")
                            throw TypeError(".NAlice.NRenderer.TRenderResponse.Div2Template.Body: object expected");
                        message.Body = $root.google.protobuf.Struct.fromObject(object.Body);
                    }
                    if (object.StringBody != null)
                        message.StringBody = String(object.StringBody);
                    return message;
                };

                /**
                 * Creates a plain object from a Div2Template message. Also converts values to other types if specified.
                 * @function toObject
                 * @memberof NAlice.NRenderer.TRenderResponse.Div2Template
                 * @static
                 * @param {NAlice.NRenderer.TRenderResponse.Div2Template} message Div2Template
                 * @param {$protobuf.IConversionOptions} [options] Conversion options
                 * @returns {Object.<string,*>} Plain object
                 */
                Div2Template.toObject = function toObject(message, options) {
                    if (!options)
                        options = {};
                    var object = {};
                    if (message.Body != null && message.hasOwnProperty("Body")) {
                        object.Body = $root.google.protobuf.Struct.toObject(message.Body, options);
                        if (options.oneofs)
                            object.Div2 = "Body";
                    }
                    if (message.StringBody != null && message.hasOwnProperty("StringBody")) {
                        object.StringBody = message.StringBody;
                        if (options.oneofs)
                            object.Div2 = "StringBody";
                    }
                    return object;
                };

                /**
                 * Converts this Div2Template to JSON.
                 * @function toJSON
                 * @memberof NAlice.NRenderer.TRenderResponse.Div2Template
                 * @instance
                 * @returns {Object.<string,*>} JSON object
                 */
                Div2Template.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };

                return Div2Template;
            })();

            TRenderResponse.Div2Patch = (function() {

                /**
                 * Properties of a Div2Patch.
                 * @memberof NAlice.NRenderer.TRenderResponse
                 * @interface IDiv2Patch
                 * @property {google.protobuf.IStruct|null} [Div2PatchBody] Div2Patch Div2PatchBody
                 * @property {string|null} [StringDiv2PatchBody] Div2Patch StringDiv2PatchBody
                 * @property {string|null} [Templates] Div2Patch Templates
                 */

                /**
                 * Constructs a new Div2Patch.
                 * @memberof NAlice.NRenderer.TRenderResponse
                 * @classdesc Represents a Div2Patch.
                 * @implements IDiv2Patch
                 * @constructor
                 * @param {NAlice.NRenderer.TRenderResponse.IDiv2Patch=} [properties] Properties to set
                 */
                function Div2Patch(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }

                /**
                 * Div2Patch Div2PatchBody.
                 * @member {google.protobuf.IStruct|null|undefined} Div2PatchBody
                 * @memberof NAlice.NRenderer.TRenderResponse.Div2Patch
                 * @instance
                 */
                Div2Patch.prototype.Div2PatchBody = null;

                /**
                 * Div2Patch StringDiv2PatchBody.
                 * @member {string|null|undefined} StringDiv2PatchBody
                 * @memberof NAlice.NRenderer.TRenderResponse.Div2Patch
                 * @instance
                 */
                Div2Patch.prototype.StringDiv2PatchBody = null;

                /**
                 * Div2Patch Templates.
                 * @member {string} Templates
                 * @memberof NAlice.NRenderer.TRenderResponse.Div2Patch
                 * @instance
                 */
                Div2Patch.prototype.Templates = "";

                // OneOf field names bound to virtual getters and setters
                var $oneOfFields;

                /**
                 * Div2Patch Body.
                 * @member {"Div2PatchBody"|"StringDiv2PatchBody"|undefined} Body
                 * @memberof NAlice.NRenderer.TRenderResponse.Div2Patch
                 * @instance
                 */
                Object.defineProperty(Div2Patch.prototype, "Body", {
                    get: $util.oneOfGetter($oneOfFields = ["Div2PatchBody", "StringDiv2PatchBody"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                /**
                 * Creates a new Div2Patch instance using the specified properties.
                 * @function create
                 * @memberof NAlice.NRenderer.TRenderResponse.Div2Patch
                 * @static
                 * @param {NAlice.NRenderer.TRenderResponse.IDiv2Patch=} [properties] Properties to set
                 * @returns {NAlice.NRenderer.TRenderResponse.Div2Patch} Div2Patch instance
                 */
                Div2Patch.create = function create(properties) {
                    return new Div2Patch(properties);
                };

                /**
                 * Encodes the specified Div2Patch message. Does not implicitly {@link NAlice.NRenderer.TRenderResponse.Div2Patch.verify|verify} messages.
                 * @function encode
                 * @memberof NAlice.NRenderer.TRenderResponse.Div2Patch
                 * @static
                 * @param {NAlice.NRenderer.TRenderResponse.IDiv2Patch} message Div2Patch message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                Div2Patch.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.Div2PatchBody != null && Object.hasOwnProperty.call(message, "Div2PatchBody"))
                        $root.google.protobuf.Struct.encode(message.Div2PatchBody, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                    if (message.StringDiv2PatchBody != null && Object.hasOwnProperty.call(message, "StringDiv2PatchBody"))
                        writer.uint32(/* id 2, wireType 2 =*/18).string(message.StringDiv2PatchBody);
                    if (message.Templates != null && Object.hasOwnProperty.call(message, "Templates"))
                        writer.uint32(/* id 3, wireType 2 =*/26).string(message.Templates);
                    return writer;
                };

                /**
                 * Encodes the specified Div2Patch message, length delimited. Does not implicitly {@link NAlice.NRenderer.TRenderResponse.Div2Patch.verify|verify} messages.
                 * @function encodeDelimited
                 * @memberof NAlice.NRenderer.TRenderResponse.Div2Patch
                 * @static
                 * @param {NAlice.NRenderer.TRenderResponse.IDiv2Patch} message Div2Patch message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                Div2Patch.encodeDelimited = function encodeDelimited(message, writer) {
                    return this.encode(message, writer).ldelim();
                };

                /**
                 * Decodes a Div2Patch message from the specified reader or buffer.
                 * @function decode
                 * @memberof NAlice.NRenderer.TRenderResponse.Div2Patch
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {NAlice.NRenderer.TRenderResponse.Div2Patch} Div2Patch
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                Div2Patch.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.NAlice.NRenderer.TRenderResponse.Div2Patch();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.Div2PatchBody = $root.google.protobuf.Struct.decode(reader, reader.uint32());
                            break;
                        case 2:
                            message.StringDiv2PatchBody = reader.string();
                            break;
                        case 3:
                            message.Templates = reader.string();
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };

                /**
                 * Decodes a Div2Patch message from the specified reader or buffer, length delimited.
                 * @function decodeDelimited
                 * @memberof NAlice.NRenderer.TRenderResponse.Div2Patch
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @returns {NAlice.NRenderer.TRenderResponse.Div2Patch} Div2Patch
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                Div2Patch.decodeDelimited = function decodeDelimited(reader) {
                    if (!(reader instanceof $Reader))
                        reader = new $Reader(reader);
                    return this.decode(reader, reader.uint32());
                };

                /**
                 * Verifies a Div2Patch message.
                 * @function verify
                 * @memberof NAlice.NRenderer.TRenderResponse.Div2Patch
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                Div2Patch.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    var properties = {};
                    if (message.Div2PatchBody != null && message.hasOwnProperty("Div2PatchBody")) {
                        properties.Body = 1;
                        {
                            var error = $root.google.protobuf.Struct.verify(message.Div2PatchBody);
                            if (error)
                                return "Div2PatchBody." + error;
                        }
                    }
                    if (message.StringDiv2PatchBody != null && message.hasOwnProperty("StringDiv2PatchBody")) {
                        if (properties.Body === 1)
                            return "Body: multiple values";
                        properties.Body = 1;
                        if (!$util.isString(message.StringDiv2PatchBody))
                            return "StringDiv2PatchBody: string expected";
                    }
                    if (message.Templates != null && message.hasOwnProperty("Templates"))
                        if (!$util.isString(message.Templates))
                            return "Templates: string expected";
                    return null;
                };

                /**
                 * Creates a Div2Patch message from a plain object. Also converts values to their respective internal types.
                 * @function fromObject
                 * @memberof NAlice.NRenderer.TRenderResponse.Div2Patch
                 * @static
                 * @param {Object.<string,*>} object Plain object
                 * @returns {NAlice.NRenderer.TRenderResponse.Div2Patch} Div2Patch
                 */
                Div2Patch.fromObject = function fromObject(object) {
                    if (object instanceof $root.NAlice.NRenderer.TRenderResponse.Div2Patch)
                        return object;
                    var message = new $root.NAlice.NRenderer.TRenderResponse.Div2Patch();
                    if (object.Div2PatchBody != null) {
                        if (typeof object.Div2PatchBody !== "object")
                            throw TypeError(".NAlice.NRenderer.TRenderResponse.Div2Patch.Div2PatchBody: object expected");
                        message.Div2PatchBody = $root.google.protobuf.Struct.fromObject(object.Div2PatchBody);
                    }
                    if (object.StringDiv2PatchBody != null)
                        message.StringDiv2PatchBody = String(object.StringDiv2PatchBody);
                    if (object.Templates != null)
                        message.Templates = String(object.Templates);
                    return message;
                };

                /**
                 * Creates a plain object from a Div2Patch message. Also converts values to other types if specified.
                 * @function toObject
                 * @memberof NAlice.NRenderer.TRenderResponse.Div2Patch
                 * @static
                 * @param {NAlice.NRenderer.TRenderResponse.Div2Patch} message Div2Patch
                 * @param {$protobuf.IConversionOptions} [options] Conversion options
                 * @returns {Object.<string,*>} Plain object
                 */
                Div2Patch.toObject = function toObject(message, options) {
                    if (!options)
                        options = {};
                    var object = {};
                    if (options.defaults)
                        object.Templates = "";
                    if (message.Div2PatchBody != null && message.hasOwnProperty("Div2PatchBody")) {
                        object.Div2PatchBody = $root.google.protobuf.Struct.toObject(message.Div2PatchBody, options);
                        if (options.oneofs)
                            object.Body = "Div2PatchBody";
                    }
                    if (message.StringDiv2PatchBody != null && message.hasOwnProperty("StringDiv2PatchBody")) {
                        object.StringDiv2PatchBody = message.StringDiv2PatchBody;
                        if (options.oneofs)
                            object.Body = "StringDiv2PatchBody";
                    }
                    if (message.Templates != null && message.hasOwnProperty("Templates"))
                        object.Templates = message.Templates;
                    return object;
                };

                /**
                 * Converts this Div2Patch to JSON.
                 * @function toJSON
                 * @memberof NAlice.NRenderer.TRenderResponse.Div2Patch
                 * @instance
                 * @returns {Object.<string,*>} JSON object
                 */
                Div2Patch.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };

                return Div2Patch;
            })();

            return TRenderResponse;
        })();

        NRenderer.TDivRenderData = (function() {

            /**
             * Properties of a TDivRenderData.
             * @memberof NAlice.NRenderer
             * @interface ITDivRenderData
             * @property {string|null} [CardId] TDivRenderData CardId
             * @property {NAlice.NData.ITScenarioData|null} [ScenarioData] TDivRenderData ScenarioData
             * @property {NAlice.NData.ITScenarioData|null} [DivPatchData] TDivRenderData DivPatchData
             * @property {string|null} [CardName] TDivRenderData CardName
             */

            /**
             * Constructs a new TDivRenderData.
             * @memberof NAlice.NRenderer
             * @classdesc Represents a TDivRenderData.
             * @implements ITDivRenderData
             * @constructor
             * @param {NAlice.NRenderer.ITDivRenderData=} [properties] Properties to set
             */
            function TDivRenderData(properties) {
                if (properties)
                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                        if (properties[keys[i]] != null)
                            this[keys[i]] = properties[keys[i]];
            }

            /**
             * TDivRenderData CardId.
             * @member {string} CardId
             * @memberof NAlice.NRenderer.TDivRenderData
             * @instance
             */
            TDivRenderData.prototype.CardId = "";

            /**
             * TDivRenderData ScenarioData.
             * @member {NAlice.NData.ITScenarioData|null|undefined} ScenarioData
             * @memberof NAlice.NRenderer.TDivRenderData
             * @instance
             */
            TDivRenderData.prototype.ScenarioData = null;

            /**
             * TDivRenderData DivPatchData.
             * @member {NAlice.NData.ITScenarioData|null|undefined} DivPatchData
             * @memberof NAlice.NRenderer.TDivRenderData
             * @instance
             */
            TDivRenderData.prototype.DivPatchData = null;

            /**
             * TDivRenderData CardName.
             * @member {string} CardName
             * @memberof NAlice.NRenderer.TDivRenderData
             * @instance
             */
            TDivRenderData.prototype.CardName = "";

            // OneOf field names bound to virtual getters and setters
            var $oneOfFields;

            /**
             * TDivRenderData RenderData.
             * @member {"ScenarioData"|"DivPatchData"|undefined} RenderData
             * @memberof NAlice.NRenderer.TDivRenderData
             * @instance
             */
            Object.defineProperty(TDivRenderData.prototype, "RenderData", {
                get: $util.oneOfGetter($oneOfFields = ["ScenarioData", "DivPatchData"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            /**
             * Creates a new TDivRenderData instance using the specified properties.
             * @function create
             * @memberof NAlice.NRenderer.TDivRenderData
             * @static
             * @param {NAlice.NRenderer.ITDivRenderData=} [properties] Properties to set
             * @returns {NAlice.NRenderer.TDivRenderData} TDivRenderData instance
             */
            TDivRenderData.create = function create(properties) {
                return new TDivRenderData(properties);
            };

            /**
             * Encodes the specified TDivRenderData message. Does not implicitly {@link NAlice.NRenderer.TDivRenderData.verify|verify} messages.
             * @function encode
             * @memberof NAlice.NRenderer.TDivRenderData
             * @static
             * @param {NAlice.NRenderer.ITDivRenderData} message TDivRenderData message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            TDivRenderData.encode = function encode(message, writer) {
                if (!writer)
                    writer = $Writer.create();
                if (message.CardId != null && Object.hasOwnProperty.call(message, "CardId"))
                    writer.uint32(/* id 1, wireType 2 =*/10).string(message.CardId);
                if (message.ScenarioData != null && Object.hasOwnProperty.call(message, "ScenarioData"))
                    $root.NAlice.NData.TScenarioData.encode(message.ScenarioData, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                if (message.DivPatchData != null && Object.hasOwnProperty.call(message, "DivPatchData"))
                    $root.NAlice.NData.TScenarioData.encode(message.DivPatchData, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                if (message.CardName != null && Object.hasOwnProperty.call(message, "CardName"))
                    writer.uint32(/* id 4, wireType 2 =*/34).string(message.CardName);
                return writer;
            };

            /**
             * Encodes the specified TDivRenderData message, length delimited. Does not implicitly {@link NAlice.NRenderer.TDivRenderData.verify|verify} messages.
             * @function encodeDelimited
             * @memberof NAlice.NRenderer.TDivRenderData
             * @static
             * @param {NAlice.NRenderer.ITDivRenderData} message TDivRenderData message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            TDivRenderData.encodeDelimited = function encodeDelimited(message, writer) {
                return this.encode(message, writer).ldelim();
            };

            /**
             * Decodes a TDivRenderData message from the specified reader or buffer.
             * @function decode
             * @memberof NAlice.NRenderer.TDivRenderData
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @param {number} [length] Message length if known beforehand
             * @returns {NAlice.NRenderer.TDivRenderData} TDivRenderData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            TDivRenderData.decode = function decode(reader, length) {
                if (!(reader instanceof $Reader))
                    reader = $Reader.create(reader);
                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.NAlice.NRenderer.TDivRenderData();
                while (reader.pos < end) {
                    var tag = reader.uint32();
                    switch (tag >>> 3) {
                    case 1:
                        message.CardId = reader.string();
                        break;
                    case 2:
                        message.ScenarioData = $root.NAlice.NData.TScenarioData.decode(reader, reader.uint32());
                        break;
                    case 3:
                        message.DivPatchData = $root.NAlice.NData.TScenarioData.decode(reader, reader.uint32());
                        break;
                    case 4:
                        message.CardName = reader.string();
                        break;
                    default:
                        reader.skipType(tag & 7);
                        break;
                    }
                }
                return message;
            };

            /**
             * Decodes a TDivRenderData message from the specified reader or buffer, length delimited.
             * @function decodeDelimited
             * @memberof NAlice.NRenderer.TDivRenderData
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @returns {NAlice.NRenderer.TDivRenderData} TDivRenderData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            TDivRenderData.decodeDelimited = function decodeDelimited(reader) {
                if (!(reader instanceof $Reader))
                    reader = new $Reader(reader);
                return this.decode(reader, reader.uint32());
            };

            /**
             * Verifies a TDivRenderData message.
             * @function verify
             * @memberof NAlice.NRenderer.TDivRenderData
             * @static
             * @param {Object.<string,*>} message Plain object to verify
             * @returns {string|null} `null` if valid, otherwise the reason why it is not
             */
            TDivRenderData.verify = function verify(message) {
                if (typeof message !== "object" || message === null)
                    return "object expected";
                var properties = {};
                if (message.CardId != null && message.hasOwnProperty("CardId"))
                    if (!$util.isString(message.CardId))
                        return "CardId: string expected";
                if (message.ScenarioData != null && message.hasOwnProperty("ScenarioData")) {
                    properties.RenderData = 1;
                    {
                        var error = $root.NAlice.NData.TScenarioData.verify(message.ScenarioData);
                        if (error)
                            return "ScenarioData." + error;
                    }
                }
                if (message.DivPatchData != null && message.hasOwnProperty("DivPatchData")) {
                    if (properties.RenderData === 1)
                        return "RenderData: multiple values";
                    properties.RenderData = 1;
                    {
                        var error = $root.NAlice.NData.TScenarioData.verify(message.DivPatchData);
                        if (error)
                            return "DivPatchData." + error;
                    }
                }
                if (message.CardName != null && message.hasOwnProperty("CardName"))
                    if (!$util.isString(message.CardName))
                        return "CardName: string expected";
                return null;
            };

            /**
             * Creates a TDivRenderData message from a plain object. Also converts values to their respective internal types.
             * @function fromObject
             * @memberof NAlice.NRenderer.TDivRenderData
             * @static
             * @param {Object.<string,*>} object Plain object
             * @returns {NAlice.NRenderer.TDivRenderData} TDivRenderData
             */
            TDivRenderData.fromObject = function fromObject(object) {
                if (object instanceof $root.NAlice.NRenderer.TDivRenderData)
                    return object;
                var message = new $root.NAlice.NRenderer.TDivRenderData();
                if (object.CardId != null)
                    message.CardId = String(object.CardId);
                if (object.ScenarioData != null) {
                    if (typeof object.ScenarioData !== "object")
                        throw TypeError(".NAlice.NRenderer.TDivRenderData.ScenarioData: object expected");
                    message.ScenarioData = $root.NAlice.NData.TScenarioData.fromObject(object.ScenarioData);
                }
                if (object.DivPatchData != null) {
                    if (typeof object.DivPatchData !== "object")
                        throw TypeError(".NAlice.NRenderer.TDivRenderData.DivPatchData: object expected");
                    message.DivPatchData = $root.NAlice.NData.TScenarioData.fromObject(object.DivPatchData);
                }
                if (object.CardName != null)
                    message.CardName = String(object.CardName);
                return message;
            };

            /**
             * Creates a plain object from a TDivRenderData message. Also converts values to other types if specified.
             * @function toObject
             * @memberof NAlice.NRenderer.TDivRenderData
             * @static
             * @param {NAlice.NRenderer.TDivRenderData} message TDivRenderData
             * @param {$protobuf.IConversionOptions} [options] Conversion options
             * @returns {Object.<string,*>} Plain object
             */
            TDivRenderData.toObject = function toObject(message, options) {
                if (!options)
                    options = {};
                var object = {};
                if (options.defaults) {
                    object.CardId = "";
                    object.CardName = "";
                }
                if (message.CardId != null && message.hasOwnProperty("CardId"))
                    object.CardId = message.CardId;
                if (message.ScenarioData != null && message.hasOwnProperty("ScenarioData")) {
                    object.ScenarioData = $root.NAlice.NData.TScenarioData.toObject(message.ScenarioData, options);
                    if (options.oneofs)
                        object.RenderData = "ScenarioData";
                }
                if (message.DivPatchData != null && message.hasOwnProperty("DivPatchData")) {
                    object.DivPatchData = $root.NAlice.NData.TScenarioData.toObject(message.DivPatchData, options);
                    if (options.oneofs)
                        object.RenderData = "DivPatchData";
                }
                if (message.CardName != null && message.hasOwnProperty("CardName"))
                    object.CardName = message.CardName;
                return object;
            };

            /**
             * Converts this TDivRenderData to JSON.
             * @function toJSON
             * @memberof NAlice.NRenderer.TDivRenderData
             * @instance
             * @returns {Object.<string,*>} JSON object
             */
            TDivRenderData.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            return TDivRenderData;
        })();

        return NRenderer;
    })();

    NAlice.NData = (function() {

        /**
         * Namespace NData.
         * @memberof NAlice
         * @namespace
         */
        var NData = {};

        NData.TScenarioData = (function() {

            /**
             * Properties of a TScenarioData.
             * @memberof NAlice.NData
             * @interface ITScenarioData
             * @property {NAlice.NData.ITSearchObjectData|null} [SearchObjectData] TScenarioData SearchObjectData
             * @property {NAlice.NData.ITSearchFactData|null} [SearchFactData] TScenarioData SearchFactData
             * @property {NAlice.NData.ITExampleScenarioData|null} [ExampleScenarioData] TScenarioData ExampleScenarioData
             * @property {NAlice.NData.ITNewsGalleryData|null} [NewsGalleryData] TScenarioData NewsGalleryData
             * @property {NAlice.NData.ITNewsTeaserData|null} [NewsTeaserData] TScenarioData NewsTeaserData
             * @property {NAlice.NData.ITWeatherDayHoursData|null} [WeatherDayHoursData] TScenarioData WeatherDayHoursData
             * @property {NAlice.NData.ITWeatherDayPartData|null} [WeatherDayPartData] TScenarioData WeatherDayPartData
             * @property {NAlice.NData.ITWeatherDayData|null} [WeatherDayData] TScenarioData WeatherDayData
             * @property {NAlice.NData.ITWeatherDaysRangeData|null} [WeatherDaysRangeData] TScenarioData WeatherDaysRangeData
             * @property {NAlice.NData.ITCentaurMainScreenGalleryMusicCardData|null} [CentaurMainScreenGalleryMusicCardData] TScenarioData CentaurMainScreenGalleryMusicCardData
             * @property {NAlice.NData.ITCentaurMainScreenGalleryVideoCardData|null} [CentaurMainScreenGalleryVideoCardData] TScenarioData CentaurMainScreenGalleryVideoCardData
             * @property {NAlice.NData.ITWeatherTeaserData|null} [WeatherTeaserData] TScenarioData WeatherTeaserData
             * @property {NAlice.NData.ITMusicPlayerData|null} [MusicPlayerData] TScenarioData MusicPlayerData
             * @property {NAlice.NData.ITCentaurMainScreenWebviewCardData|null} [CentaurMainScreenWebviewCardData] TScenarioData CentaurMainScreenWebviewCardData
             * @property {NAlice.NData.NMusic.ITMusicInfiniteFeedData|null} [MusicInfiniteFeedData] TScenarioData MusicInfiniteFeedData
             * @property {NAlice.NData.ITCentaurMainScreenWebviewTabData|null} [CentaurMainScreenWebviewTabData] TScenarioData CentaurMainScreenWebviewTabData
             * @property {NAlice.NData.ITCentaurTeaserChromeDefaultLayerData|null} [CentaurTeaserChromeDefaultLayerData] TScenarioData CentaurTeaserChromeDefaultLayerData
             * @property {NAlice.NData.ITCentaurMainScreenDiscoveryTabData|null} [CentaurMainScreenDiscoveryTabData] TScenarioData CentaurMainScreenDiscoveryTabData
             * @property {NAlice.NData.ITCentaurMainScreenMusicTabData|null} [CentaurMainScreenMusicTabData] TScenarioData CentaurMainScreenMusicTabData
             * @property {NAlice.NData.ITCentaurMainScreenServicesTabData|null} [CentaurMainScreenServicesTabData] TScenarioData CentaurMainScreenServicesTabData
             * @property {NAlice.ITIoTUserInfo|null} [IoTUserData] TScenarioData IoTUserData
             * @property {NAlice.NData.ITCentaurMainScreenSmartHomeTabData|null} [CentaurMainScreenSmartHomeTabData] TScenarioData CentaurMainScreenSmartHomeTabData
             * @property {NAlice.NData.ITCentaurUpperShutterData|null} [CentaurUpperShutterData] TScenarioData CentaurUpperShutterData
             * @property {NAlice.NData.ITCentaurWebviewData|null} [CentaurWebviewData] TScenarioData CentaurWebviewData
             * @property {NAlice.NData.ITCentaurMainScreenMyScreenData|null} [CentaurMainScreenMyScreenData] TScenarioData CentaurMainScreenMyScreenData
             * @property {NAlice.NData.ITNewsMainScreenData|null} [NewsMainScreenData] TScenarioData NewsMainScreenData
             * @property {NAlice.NData.ITWeatherMainScreenData|null} [WeatherMainScreenData] TScenarioData WeatherMainScreenData
             * @property {NAlice.NData.ITDialogovoSkillCardData|null} [DialogovoSkillCardData] TScenarioData DialogovoSkillCardData
             * @property {NAlice.NData.ITCentaurWidgetGalleryData|null} [CentaurWidgetGalleryData] TScenarioData CentaurWidgetGalleryData
             * @property {NAlice.NData.ITScreenSaverData|null} [ScreenSaverData] TScenarioData ScreenSaverData
             * @property {NAlice.NData.ITTrafficWidgetData|null} [TrafficData] TScenarioData TrafficData
             * @property {NAlice.NData.ITGalleryData|null} [GalleryData] TScenarioData GalleryData
             * @property {NAlice.NData.ITConversationData|null} [ConversationData] TScenarioData ConversationData
             * @property {NAlice.NData.ITVideoCallMainScreenData|null} [VideoCallMainScreenData] TScenarioData VideoCallMainScreenData
             * @property {NAlice.NData.ITVideoCallContactChoosingData|null} [VideoCallContactChoosingData] TScenarioData VideoCallContactChoosingData
             * @property {NAlice.NData.ITCentaurWidgetCardItemData|null} [CentaurWidgetCardItemData] TScenarioData CentaurWidgetCardItemData
             * @property {NAlice.NData.ITCentaurWidgetCardItem|null} [CentaurWidgetCardItem] TScenarioData CentaurWidgetCardItem
             * @property {NAlice.NData.ITAfishaTeaserData|null} [AfishaTeaserData] TScenarioData AfishaTeaserData
             * @property {NAlice.NData.ITCentaurScenarioWidgetData|null} [CentaurScenarioWidgetData] TScenarioData CentaurScenarioWidgetData
             * @property {NAlice.NData.ITIncomingTelegramCallData|null} [IncomingTelegramCallData] TScenarioData IncomingTelegramCallData
             * @property {NAlice.ITTvSearchResultData|null} [VideoSearchResultData] TScenarioData VideoSearchResultData
             * @property {NAlice.NData.ITSearchRichCardData|null} [SearchRichCardData] TScenarioData SearchRichCardData
             * @property {NAlice.NData.ITOutgoingTelegramCallData|null} [OutgoingTelegramCallData] TScenarioData OutgoingTelegramCallData
             * @property {NAlice.NData.ITCurrentTelegramCallData|null} [CurrentTelegramCallData] TScenarioData CurrentTelegramCallData
             * @property {NAlice.NData.ITGreetingsCardData|null} [GreetingsCardData] TScenarioData GreetingsCardData
             * @property {NAlice.NData.ITShowRouteData|null} [ShowRouteData] TScenarioData ShowRouteData
             * @property {NAlice.NData.ITDialogovoSkillTeaserData|null} [DialogovoTeaserCardData] TScenarioData DialogovoTeaserCardData
             * @property {NAlice.NData.ITTrafficCardData|null} [TrafficCardData] TScenarioData TrafficCardData
             * @property {NAlice.NData.ITProactivityTeaserData|null} [ProactivityTeaserData] TScenarioData ProactivityTeaserData
             * @property {NAlice.NData.ITGreetingsFooterCardData|null} [GreetingsFooterCardData] TScenarioData GreetingsFooterCardData
             * @property {NAlice.NData.ITTeaserSettingsWithContentData|null} [TeaserSettingsWithContentData] TScenarioData TeaserSettingsWithContentData
             * @property {NAlice.NData.ITTeasersPreviewData|null} [TeasersPreviewData] TScenarioData TeasersPreviewData
             */

            /**
             * Constructs a new TScenarioData.
             * @memberof NAlice.NData
             * @classdesc Represents a TScenarioData.
             * @implements ITScenarioData
             * @constructor
             * @param {NAlice.NData.ITScenarioData=} [properties] Properties to set
             */
            function TScenarioData(properties) {
                if (properties)
                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                        if (properties[keys[i]] != null)
                            this[keys[i]] = properties[keys[i]];
            }

            /**
             * TScenarioData SearchObjectData.
             * @member {NAlice.NData.ITSearchObjectData|null|undefined} SearchObjectData
             * @memberof NAlice.NData.TScenarioData
             * @instance
             */
            TScenarioData.prototype.SearchObjectData = null;

            /**
             * TScenarioData SearchFactData.
             * @member {NAlice.NData.ITSearchFactData|null|undefined} SearchFactData
             * @memberof NAlice.NData.TScenarioData
             * @instance
             */
            TScenarioData.prototype.SearchFactData = null;

            /**
             * TScenarioData ExampleScenarioData.
             * @member {NAlice.NData.ITExampleScenarioData|null|undefined} ExampleScenarioData
             * @memberof NAlice.NData.TScenarioData
             * @instance
             */
            TScenarioData.prototype.ExampleScenarioData = null;

            /**
             * TScenarioData NewsGalleryData.
             * @member {NAlice.NData.ITNewsGalleryData|null|undefined} NewsGalleryData
             * @memberof NAlice.NData.TScenarioData
             * @instance
             */
            TScenarioData.prototype.NewsGalleryData = null;

            /**
             * TScenarioData NewsTeaserData.
             * @member {NAlice.NData.ITNewsTeaserData|null|undefined} NewsTeaserData
             * @memberof NAlice.NData.TScenarioData
             * @instance
             */
            TScenarioData.prototype.NewsTeaserData = null;

            /**
             * TScenarioData WeatherDayHoursData.
             * @member {NAlice.NData.ITWeatherDayHoursData|null|undefined} WeatherDayHoursData
             * @memberof NAlice.NData.TScenarioData
             * @instance
             */
            TScenarioData.prototype.WeatherDayHoursData = null;

            /**
             * TScenarioData WeatherDayPartData.
             * @member {NAlice.NData.ITWeatherDayPartData|null|undefined} WeatherDayPartData
             * @memberof NAlice.NData.TScenarioData
             * @instance
             */
            TScenarioData.prototype.WeatherDayPartData = null;

            /**
             * TScenarioData WeatherDayData.
             * @member {NAlice.NData.ITWeatherDayData|null|undefined} WeatherDayData
             * @memberof NAlice.NData.TScenarioData
             * @instance
             */
            TScenarioData.prototype.WeatherDayData = null;

            /**
             * TScenarioData WeatherDaysRangeData.
             * @member {NAlice.NData.ITWeatherDaysRangeData|null|undefined} WeatherDaysRangeData
             * @memberof NAlice.NData.TScenarioData
             * @instance
             */
            TScenarioData.prototype.WeatherDaysRangeData = null;

            /**
             * TScenarioData CentaurMainScreenGalleryMusicCardData.
             * @member {NAlice.NData.ITCentaurMainScreenGalleryMusicCardData|null|undefined} CentaurMainScreenGalleryMusicCardData
             * @memberof NAlice.NData.TScenarioData
             * @instance
             */
            TScenarioData.prototype.CentaurMainScreenGalleryMusicCardData = null;

            /**
             * TScenarioData CentaurMainScreenGalleryVideoCardData.
             * @member {NAlice.NData.ITCentaurMainScreenGalleryVideoCardData|null|undefined} CentaurMainScreenGalleryVideoCardData
             * @memberof NAlice.NData.TScenarioData
             * @instance
             */
            TScenarioData.prototype.CentaurMainScreenGalleryVideoCardData = null;

            /**
             * TScenarioData WeatherTeaserData.
             * @member {NAlice.NData.ITWeatherTeaserData|null|undefined} WeatherTeaserData
             * @memberof NAlice.NData.TScenarioData
             * @instance
             */
            TScenarioData.prototype.WeatherTeaserData = null;

            /**
             * TScenarioData MusicPlayerData.
             * @member {NAlice.NData.ITMusicPlayerData|null|undefined} MusicPlayerData
             * @memberof NAlice.NData.TScenarioData
             * @instance
             */
            TScenarioData.prototype.MusicPlayerData = null;

            /**
             * TScenarioData CentaurMainScreenWebviewCardData.
             * @member {NAlice.NData.ITCentaurMainScreenWebviewCardData|null|undefined} CentaurMainScreenWebviewCardData
             * @memberof NAlice.NData.TScenarioData
             * @instance
             */
            TScenarioData.prototype.CentaurMainScreenWebviewCardData = null;

            /**
             * TScenarioData MusicInfiniteFeedData.
             * @member {NAlice.NData.NMusic.ITMusicInfiniteFeedData|null|undefined} MusicInfiniteFeedData
             * @memberof NAlice.NData.TScenarioData
             * @instance
             */
            TScenarioData.prototype.MusicInfiniteFeedData = null;

            /**
             * TScenarioData CentaurMainScreenWebviewTabData.
             * @member {NAlice.NData.ITCentaurMainScreenWebviewTabData|null|undefined} CentaurMainScreenWebviewTabData
             * @memberof NAlice.NData.TScenarioData
             * @instance
             */
            TScenarioData.prototype.CentaurMainScreenWebviewTabData = null;

            /**
             * TScenarioData CentaurTeaserChromeDefaultLayerData.
             * @member {NAlice.NData.ITCentaurTeaserChromeDefaultLayerData|null|undefined} CentaurTeaserChromeDefaultLayerData
             * @memberof NAlice.NData.TScenarioData
             * @instance
             */
            TScenarioData.prototype.CentaurTeaserChromeDefaultLayerData = null;

            /**
             * TScenarioData CentaurMainScreenDiscoveryTabData.
             * @member {NAlice.NData.ITCentaurMainScreenDiscoveryTabData|null|undefined} CentaurMainScreenDiscoveryTabData
             * @memberof NAlice.NData.TScenarioData
             * @instance
             */
            TScenarioData.prototype.CentaurMainScreenDiscoveryTabData = null;

            /**
             * TScenarioData CentaurMainScreenMusicTabData.
             * @member {NAlice.NData.ITCentaurMainScreenMusicTabData|null|undefined} CentaurMainScreenMusicTabData
             * @memberof NAlice.NData.TScenarioData
             * @instance
             */
            TScenarioData.prototype.CentaurMainScreenMusicTabData = null;

            /**
             * TScenarioData CentaurMainScreenServicesTabData.
             * @member {NAlice.NData.ITCentaurMainScreenServicesTabData|null|undefined} CentaurMainScreenServicesTabData
             * @memberof NAlice.NData.TScenarioData
             * @instance
             */
            TScenarioData.prototype.CentaurMainScreenServicesTabData = null;

            /**
             * TScenarioData IoTUserData.
             * @member {NAlice.ITIoTUserInfo|null|undefined} IoTUserData
             * @memberof NAlice.NData.TScenarioData
             * @instance
             */
            TScenarioData.prototype.IoTUserData = null;

            /**
             * TScenarioData CentaurMainScreenSmartHomeTabData.
             * @member {NAlice.NData.ITCentaurMainScreenSmartHomeTabData|null|undefined} CentaurMainScreenSmartHomeTabData
             * @memberof NAlice.NData.TScenarioData
             * @instance
             */
            TScenarioData.prototype.CentaurMainScreenSmartHomeTabData = null;

            /**
             * TScenarioData CentaurUpperShutterData.
             * @member {NAlice.NData.ITCentaurUpperShutterData|null|undefined} CentaurUpperShutterData
             * @memberof NAlice.NData.TScenarioData
             * @instance
             */
            TScenarioData.prototype.CentaurUpperShutterData = null;

            /**
             * TScenarioData CentaurWebviewData.
             * @member {NAlice.NData.ITCentaurWebviewData|null|undefined} CentaurWebviewData
             * @memberof NAlice.NData.TScenarioData
             * @instance
             */
            TScenarioData.prototype.CentaurWebviewData = null;

            /**
             * TScenarioData CentaurMainScreenMyScreenData.
             * @member {NAlice.NData.ITCentaurMainScreenMyScreenData|null|undefined} CentaurMainScreenMyScreenData
             * @memberof NAlice.NData.TScenarioData
             * @instance
             */
            TScenarioData.prototype.CentaurMainScreenMyScreenData = null;

            /**
             * TScenarioData NewsMainScreenData.
             * @member {NAlice.NData.ITNewsMainScreenData|null|undefined} NewsMainScreenData
             * @memberof NAlice.NData.TScenarioData
             * @instance
             */
            TScenarioData.prototype.NewsMainScreenData = null;

            /**
             * TScenarioData WeatherMainScreenData.
             * @member {NAlice.NData.ITWeatherMainScreenData|null|undefined} WeatherMainScreenData
             * @memberof NAlice.NData.TScenarioData
             * @instance
             */
            TScenarioData.prototype.WeatherMainScreenData = null;

            /**
             * TScenarioData DialogovoSkillCardData.
             * @member {NAlice.NData.ITDialogovoSkillCardData|null|undefined} DialogovoSkillCardData
             * @memberof NAlice.NData.TScenarioData
             * @instance
             */
            TScenarioData.prototype.DialogovoSkillCardData = null;

            /**
             * TScenarioData CentaurWidgetGalleryData.
             * @member {NAlice.NData.ITCentaurWidgetGalleryData|null|undefined} CentaurWidgetGalleryData
             * @memberof NAlice.NData.TScenarioData
             * @instance
             */
            TScenarioData.prototype.CentaurWidgetGalleryData = null;

            /**
             * TScenarioData ScreenSaverData.
             * @member {NAlice.NData.ITScreenSaverData|null|undefined} ScreenSaverData
             * @memberof NAlice.NData.TScenarioData
             * @instance
             */
            TScenarioData.prototype.ScreenSaverData = null;

            /**
             * TScenarioData TrafficData.
             * @member {NAlice.NData.ITTrafficWidgetData|null|undefined} TrafficData
             * @memberof NAlice.NData.TScenarioData
             * @instance
             */
            TScenarioData.prototype.TrafficData = null;

            /**
             * TScenarioData GalleryData.
             * @member {NAlice.NData.ITGalleryData|null|undefined} GalleryData
             * @memberof NAlice.NData.TScenarioData
             * @instance
             */
            TScenarioData.prototype.GalleryData = null;

            /**
             * TScenarioData ConversationData.
             * @member {NAlice.NData.ITConversationData|null|undefined} ConversationData
             * @memberof NAlice.NData.TScenarioData
             * @instance
             */
            TScenarioData.prototype.ConversationData = null;

            /**
             * TScenarioData VideoCallMainScreenData.
             * @member {NAlice.NData.ITVideoCallMainScreenData|null|undefined} VideoCallMainScreenData
             * @memberof NAlice.NData.TScenarioData
             * @instance
             */
            TScenarioData.prototype.VideoCallMainScreenData = null;

            /**
             * TScenarioData VideoCallContactChoosingData.
             * @member {NAlice.NData.ITVideoCallContactChoosingData|null|undefined} VideoCallContactChoosingData
             * @memberof NAlice.NData.TScenarioData
             * @instance
             */
            TScenarioData.prototype.VideoCallContactChoosingData = null;

            /**
             * TScenarioData CentaurWidgetCardItemData.
             * @member {NAlice.NData.ITCentaurWidgetCardItemData|null|undefined} CentaurWidgetCardItemData
             * @memberof NAlice.NData.TScenarioData
             * @instance
             */
            TScenarioData.prototype.CentaurWidgetCardItemData = null;

            /**
             * TScenarioData CentaurWidgetCardItem.
             * @member {NAlice.NData.ITCentaurWidgetCardItem|null|undefined} CentaurWidgetCardItem
             * @memberof NAlice.NData.TScenarioData
             * @instance
             */
            TScenarioData.prototype.CentaurWidgetCardItem = null;

            /**
             * TScenarioData AfishaTeaserData.
             * @member {NAlice.NData.ITAfishaTeaserData|null|undefined} AfishaTeaserData
             * @memberof NAlice.NData.TScenarioData
             * @instance
             */
            TScenarioData.prototype.AfishaTeaserData = null;

            /**
             * TScenarioData CentaurScenarioWidgetData.
             * @member {NAlice.NData.ITCentaurScenarioWidgetData|null|undefined} CentaurScenarioWidgetData
             * @memberof NAlice.NData.TScenarioData
             * @instance
             */
            TScenarioData.prototype.CentaurScenarioWidgetData = null;

            /**
             * TScenarioData IncomingTelegramCallData.
             * @member {NAlice.NData.ITIncomingTelegramCallData|null|undefined} IncomingTelegramCallData
             * @memberof NAlice.NData.TScenarioData
             * @instance
             */
            TScenarioData.prototype.IncomingTelegramCallData = null;

            /**
             * TScenarioData VideoSearchResultData.
             * @member {NAlice.ITTvSearchResultData|null|undefined} VideoSearchResultData
             * @memberof NAlice.NData.TScenarioData
             * @instance
             */
            TScenarioData.prototype.VideoSearchResultData = null;

            /**
             * TScenarioData SearchRichCardData.
             * @member {NAlice.NData.ITSearchRichCardData|null|undefined} SearchRichCardData
             * @memberof NAlice.NData.TScenarioData
             * @instance
             */
            TScenarioData.prototype.SearchRichCardData = null;

            /**
             * TScenarioData OutgoingTelegramCallData.
             * @member {NAlice.NData.ITOutgoingTelegramCallData|null|undefined} OutgoingTelegramCallData
             * @memberof NAlice.NData.TScenarioData
             * @instance
             */
            TScenarioData.prototype.OutgoingTelegramCallData = null;

            /**
             * TScenarioData CurrentTelegramCallData.
             * @member {NAlice.NData.ITCurrentTelegramCallData|null|undefined} CurrentTelegramCallData
             * @memberof NAlice.NData.TScenarioData
             * @instance
             */
            TScenarioData.prototype.CurrentTelegramCallData = null;

            /**
             * TScenarioData GreetingsCardData.
             * @member {NAlice.NData.ITGreetingsCardData|null|undefined} GreetingsCardData
             * @memberof NAlice.NData.TScenarioData
             * @instance
             */
            TScenarioData.prototype.GreetingsCardData = null;

            /**
             * TScenarioData ShowRouteData.
             * @member {NAlice.NData.ITShowRouteData|null|undefined} ShowRouteData
             * @memberof NAlice.NData.TScenarioData
             * @instance
             */
            TScenarioData.prototype.ShowRouteData = null;

            /**
             * TScenarioData DialogovoTeaserCardData.
             * @member {NAlice.NData.ITDialogovoSkillTeaserData|null|undefined} DialogovoTeaserCardData
             * @memberof NAlice.NData.TScenarioData
             * @instance
             */
            TScenarioData.prototype.DialogovoTeaserCardData = null;

            /**
             * TScenarioData TrafficCardData.
             * @member {NAlice.NData.ITTrafficCardData|null|undefined} TrafficCardData
             * @memberof NAlice.NData.TScenarioData
             * @instance
             */
            TScenarioData.prototype.TrafficCardData = null;

            /**
             * TScenarioData ProactivityTeaserData.
             * @member {NAlice.NData.ITProactivityTeaserData|null|undefined} ProactivityTeaserData
             * @memberof NAlice.NData.TScenarioData
             * @instance
             */
            TScenarioData.prototype.ProactivityTeaserData = null;

            /**
             * TScenarioData GreetingsFooterCardData.
             * @member {NAlice.NData.ITGreetingsFooterCardData|null|undefined} GreetingsFooterCardData
             * @memberof NAlice.NData.TScenarioData
             * @instance
             */
            TScenarioData.prototype.GreetingsFooterCardData = null;

            /**
             * TScenarioData TeaserSettingsWithContentData.
             * @member {NAlice.NData.ITTeaserSettingsWithContentData|null|undefined} TeaserSettingsWithContentData
             * @memberof NAlice.NData.TScenarioData
             * @instance
             */
            TScenarioData.prototype.TeaserSettingsWithContentData = null;

            /**
             * TScenarioData TeasersPreviewData.
             * @member {NAlice.NData.ITTeasersPreviewData|null|undefined} TeasersPreviewData
             * @memberof NAlice.NData.TScenarioData
             * @instance
             */
            TScenarioData.prototype.TeasersPreviewData = null;

            // OneOf field names bound to virtual getters and setters
            var $oneOfFields;

            /**
             * TScenarioData Data.
             * @member {"SearchObjectData"|"SearchFactData"|"ExampleScenarioData"|"NewsGalleryData"|"NewsTeaserData"|"WeatherDayHoursData"|"WeatherDayPartData"|"WeatherDayData"|"WeatherDaysRangeData"|"CentaurMainScreenGalleryMusicCardData"|"CentaurMainScreenGalleryVideoCardData"|"WeatherTeaserData"|"MusicPlayerData"|"CentaurMainScreenWebviewCardData"|"MusicInfiniteFeedData"|"CentaurMainScreenWebviewTabData"|"CentaurTeaserChromeDefaultLayerData"|"CentaurMainScreenDiscoveryTabData"|"CentaurMainScreenMusicTabData"|"CentaurMainScreenServicesTabData"|"IoTUserData"|"CentaurMainScreenSmartHomeTabData"|"CentaurUpperShutterData"|"CentaurWebviewData"|"CentaurMainScreenMyScreenData"|"NewsMainScreenData"|"WeatherMainScreenData"|"DialogovoSkillCardData"|"CentaurWidgetGalleryData"|"ScreenSaverData"|"TrafficData"|"GalleryData"|"ConversationData"|"VideoCallMainScreenData"|"VideoCallContactChoosingData"|"CentaurWidgetCardItemData"|"CentaurWidgetCardItem"|"AfishaTeaserData"|"CentaurScenarioWidgetData"|"IncomingTelegramCallData"|"VideoSearchResultData"|"SearchRichCardData"|"OutgoingTelegramCallData"|"CurrentTelegramCallData"|"GreetingsCardData"|"ShowRouteData"|"DialogovoTeaserCardData"|"TrafficCardData"|"ProactivityTeaserData"|"GreetingsFooterCardData"|"TeaserSettingsWithContentData"|"TeasersPreviewData"|undefined} Data
             * @memberof NAlice.NData.TScenarioData
             * @instance
             */
            Object.defineProperty(TScenarioData.prototype, "Data", {
                get: $util.oneOfGetter($oneOfFields = ["SearchObjectData", "SearchFactData", "ExampleScenarioData", "NewsGalleryData", "NewsTeaserData", "WeatherDayHoursData", "WeatherDayPartData", "WeatherDayData", "WeatherDaysRangeData", "CentaurMainScreenGalleryMusicCardData", "CentaurMainScreenGalleryVideoCardData", "WeatherTeaserData", "MusicPlayerData", "CentaurMainScreenWebviewCardData", "MusicInfiniteFeedData", "CentaurMainScreenWebviewTabData", "CentaurTeaserChromeDefaultLayerData", "CentaurMainScreenDiscoveryTabData", "CentaurMainScreenMusicTabData", "CentaurMainScreenServicesTabData", "IoTUserData", "CentaurMainScreenSmartHomeTabData", "CentaurUpperShutterData", "CentaurWebviewData", "CentaurMainScreenMyScreenData", "NewsMainScreenData", "WeatherMainScreenData", "DialogovoSkillCardData", "CentaurWidgetGalleryData", "ScreenSaverData", "TrafficData", "GalleryData", "ConversationData", "VideoCallMainScreenData", "VideoCallContactChoosingData", "CentaurWidgetCardItemData", "CentaurWidgetCardItem", "AfishaTeaserData", "CentaurScenarioWidgetData", "IncomingTelegramCallData", "VideoSearchResultData", "SearchRichCardData", "OutgoingTelegramCallData", "CurrentTelegramCallData", "GreetingsCardData", "ShowRouteData", "DialogovoTeaserCardData", "TrafficCardData", "ProactivityTeaserData", "GreetingsFooterCardData", "TeaserSettingsWithContentData", "TeasersPreviewData"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            /**
             * Creates a new TScenarioData instance using the specified properties.
             * @function create
             * @memberof NAlice.NData.TScenarioData
             * @static
             * @param {NAlice.NData.ITScenarioData=} [properties] Properties to set
             * @returns {NAlice.NData.TScenarioData} TScenarioData instance
             */
            TScenarioData.create = function create(properties) {
                return new TScenarioData(properties);
            };

            /**
             * Encodes the specified TScenarioData message. Does not implicitly {@link NAlice.NData.TScenarioData.verify|verify} messages.
             * @function encode
             * @memberof NAlice.NData.TScenarioData
             * @static
             * @param {NAlice.NData.ITScenarioData} message TScenarioData message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            TScenarioData.encode = function encode(message, writer) {
                if (!writer)
                    writer = $Writer.create();
                if (message.SearchObjectData != null && Object.hasOwnProperty.call(message, "SearchObjectData"))
                    $root.NAlice.NData.TSearchObjectData.encode(message.SearchObjectData, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                if (message.SearchFactData != null && Object.hasOwnProperty.call(message, "SearchFactData"))
                    $root.NAlice.NData.TSearchFactData.encode(message.SearchFactData, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                if (message.ExampleScenarioData != null && Object.hasOwnProperty.call(message, "ExampleScenarioData"))
                    $root.NAlice.NData.TExampleScenarioData.encode(message.ExampleScenarioData, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                if (message.NewsGalleryData != null && Object.hasOwnProperty.call(message, "NewsGalleryData"))
                    $root.NAlice.NData.TNewsGalleryData.encode(message.NewsGalleryData, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
                if (message.NewsTeaserData != null && Object.hasOwnProperty.call(message, "NewsTeaserData"))
                    $root.NAlice.NData.TNewsTeaserData.encode(message.NewsTeaserData, writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
                if (message.WeatherDayHoursData != null && Object.hasOwnProperty.call(message, "WeatherDayHoursData"))
                    $root.NAlice.NData.TWeatherDayHoursData.encode(message.WeatherDayHoursData, writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
                if (message.WeatherDayPartData != null && Object.hasOwnProperty.call(message, "WeatherDayPartData"))
                    $root.NAlice.NData.TWeatherDayPartData.encode(message.WeatherDayPartData, writer.uint32(/* id 7, wireType 2 =*/58).fork()).ldelim();
                if (message.WeatherDayData != null && Object.hasOwnProperty.call(message, "WeatherDayData"))
                    $root.NAlice.NData.TWeatherDayData.encode(message.WeatherDayData, writer.uint32(/* id 8, wireType 2 =*/66).fork()).ldelim();
                if (message.WeatherDaysRangeData != null && Object.hasOwnProperty.call(message, "WeatherDaysRangeData"))
                    $root.NAlice.NData.TWeatherDaysRangeData.encode(message.WeatherDaysRangeData, writer.uint32(/* id 9, wireType 2 =*/74).fork()).ldelim();
                if (message.CentaurMainScreenGalleryMusicCardData != null && Object.hasOwnProperty.call(message, "CentaurMainScreenGalleryMusicCardData"))
                    $root.NAlice.NData.TCentaurMainScreenGalleryMusicCardData.encode(message.CentaurMainScreenGalleryMusicCardData, writer.uint32(/* id 10, wireType 2 =*/82).fork()).ldelim();
                if (message.CentaurMainScreenGalleryVideoCardData != null && Object.hasOwnProperty.call(message, "CentaurMainScreenGalleryVideoCardData"))
                    $root.NAlice.NData.TCentaurMainScreenGalleryVideoCardData.encode(message.CentaurMainScreenGalleryVideoCardData, writer.uint32(/* id 11, wireType 2 =*/90).fork()).ldelim();
                if (message.WeatherTeaserData != null && Object.hasOwnProperty.call(message, "WeatherTeaserData"))
                    $root.NAlice.NData.TWeatherTeaserData.encode(message.WeatherTeaserData, writer.uint32(/* id 12, wireType 2 =*/98).fork()).ldelim();
                if (message.MusicPlayerData != null && Object.hasOwnProperty.call(message, "MusicPlayerData"))
                    $root.NAlice.NData.TMusicPlayerData.encode(message.MusicPlayerData, writer.uint32(/* id 13, wireType 2 =*/106).fork()).ldelim();
                if (message.CentaurMainScreenWebviewCardData != null && Object.hasOwnProperty.call(message, "CentaurMainScreenWebviewCardData"))
                    $root.NAlice.NData.TCentaurMainScreenWebviewCardData.encode(message.CentaurMainScreenWebviewCardData, writer.uint32(/* id 14, wireType 2 =*/114).fork()).ldelim();
                if (message.MusicInfiniteFeedData != null && Object.hasOwnProperty.call(message, "MusicInfiniteFeedData"))
                    $root.NAlice.NData.NMusic.TMusicInfiniteFeedData.encode(message.MusicInfiniteFeedData, writer.uint32(/* id 15, wireType 2 =*/122).fork()).ldelim();
                if (message.CentaurMainScreenWebviewTabData != null && Object.hasOwnProperty.call(message, "CentaurMainScreenWebviewTabData"))
                    $root.NAlice.NData.TCentaurMainScreenWebviewTabData.encode(message.CentaurMainScreenWebviewTabData, writer.uint32(/* id 16, wireType 2 =*/130).fork()).ldelim();
                if (message.CentaurTeaserChromeDefaultLayerData != null && Object.hasOwnProperty.call(message, "CentaurTeaserChromeDefaultLayerData"))
                    $root.NAlice.NData.TCentaurTeaserChromeDefaultLayerData.encode(message.CentaurTeaserChromeDefaultLayerData, writer.uint32(/* id 17, wireType 2 =*/138).fork()).ldelim();
                if (message.CentaurMainScreenDiscoveryTabData != null && Object.hasOwnProperty.call(message, "CentaurMainScreenDiscoveryTabData"))
                    $root.NAlice.NData.TCentaurMainScreenDiscoveryTabData.encode(message.CentaurMainScreenDiscoveryTabData, writer.uint32(/* id 18, wireType 2 =*/146).fork()).ldelim();
                if (message.CentaurMainScreenMusicTabData != null && Object.hasOwnProperty.call(message, "CentaurMainScreenMusicTabData"))
                    $root.NAlice.NData.TCentaurMainScreenMusicTabData.encode(message.CentaurMainScreenMusicTabData, writer.uint32(/* id 19, wireType 2 =*/154).fork()).ldelim();
                if (message.CentaurMainScreenServicesTabData != null && Object.hasOwnProperty.call(message, "CentaurMainScreenServicesTabData"))
                    $root.NAlice.NData.TCentaurMainScreenServicesTabData.encode(message.CentaurMainScreenServicesTabData, writer.uint32(/* id 20, wireType 2 =*/162).fork()).ldelim();
                if (message.IoTUserData != null && Object.hasOwnProperty.call(message, "IoTUserData"))
                    $root.NAlice.TIoTUserInfo.encode(message.IoTUserData, writer.uint32(/* id 21, wireType 2 =*/170).fork()).ldelim();
                if (message.CentaurMainScreenSmartHomeTabData != null && Object.hasOwnProperty.call(message, "CentaurMainScreenSmartHomeTabData"))
                    $root.NAlice.NData.TCentaurMainScreenSmartHomeTabData.encode(message.CentaurMainScreenSmartHomeTabData, writer.uint32(/* id 22, wireType 2 =*/178).fork()).ldelim();
                if (message.CentaurUpperShutterData != null && Object.hasOwnProperty.call(message, "CentaurUpperShutterData"))
                    $root.NAlice.NData.TCentaurUpperShutterData.encode(message.CentaurUpperShutterData, writer.uint32(/* id 23, wireType 2 =*/186).fork()).ldelim();
                if (message.CentaurWebviewData != null && Object.hasOwnProperty.call(message, "CentaurWebviewData"))
                    $root.NAlice.NData.TCentaurWebviewData.encode(message.CentaurWebviewData, writer.uint32(/* id 24, wireType 2 =*/194).fork()).ldelim();
                if (message.CentaurMainScreenMyScreenData != null && Object.hasOwnProperty.call(message, "CentaurMainScreenMyScreenData"))
                    $root.NAlice.NData.TCentaurMainScreenMyScreenData.encode(message.CentaurMainScreenMyScreenData, writer.uint32(/* id 25, wireType 2 =*/202).fork()).ldelim();
                if (message.NewsMainScreenData != null && Object.hasOwnProperty.call(message, "NewsMainScreenData"))
                    $root.NAlice.NData.TNewsMainScreenData.encode(message.NewsMainScreenData, writer.uint32(/* id 26, wireType 2 =*/210).fork()).ldelim();
                if (message.WeatherMainScreenData != null && Object.hasOwnProperty.call(message, "WeatherMainScreenData"))
                    $root.NAlice.NData.TWeatherMainScreenData.encode(message.WeatherMainScreenData, writer.uint32(/* id 27, wireType 2 =*/218).fork()).ldelim();
                if (message.DialogovoSkillCardData != null && Object.hasOwnProperty.call(message, "DialogovoSkillCardData"))
                    $root.NAlice.NData.TDialogovoSkillCardData.encode(message.DialogovoSkillCardData, writer.uint32(/* id 28, wireType 2 =*/226).fork()).ldelim();
                if (message.CentaurWidgetGalleryData != null && Object.hasOwnProperty.call(message, "CentaurWidgetGalleryData"))
                    $root.NAlice.NData.TCentaurWidgetGalleryData.encode(message.CentaurWidgetGalleryData, writer.uint32(/* id 29, wireType 2 =*/234).fork()).ldelim();
                if (message.ScreenSaverData != null && Object.hasOwnProperty.call(message, "ScreenSaverData"))
                    $root.NAlice.NData.TScreenSaverData.encode(message.ScreenSaverData, writer.uint32(/* id 30, wireType 2 =*/242).fork()).ldelim();
                if (message.TrafficData != null && Object.hasOwnProperty.call(message, "TrafficData"))
                    $root.NAlice.NData.TTrafficWidgetData.encode(message.TrafficData, writer.uint32(/* id 31, wireType 2 =*/250).fork()).ldelim();
                if (message.GalleryData != null && Object.hasOwnProperty.call(message, "GalleryData"))
                    $root.NAlice.NData.TGalleryData.encode(message.GalleryData, writer.uint32(/* id 32, wireType 2 =*/258).fork()).ldelim();
                if (message.ConversationData != null && Object.hasOwnProperty.call(message, "ConversationData"))
                    $root.NAlice.NData.TConversationData.encode(message.ConversationData, writer.uint32(/* id 33, wireType 2 =*/266).fork()).ldelim();
                if (message.VideoCallMainScreenData != null && Object.hasOwnProperty.call(message, "VideoCallMainScreenData"))
                    $root.NAlice.NData.TVideoCallMainScreenData.encode(message.VideoCallMainScreenData, writer.uint32(/* id 34, wireType 2 =*/274).fork()).ldelim();
                if (message.VideoCallContactChoosingData != null && Object.hasOwnProperty.call(message, "VideoCallContactChoosingData"))
                    $root.NAlice.NData.TVideoCallContactChoosingData.encode(message.VideoCallContactChoosingData, writer.uint32(/* id 35, wireType 2 =*/282).fork()).ldelim();
                if (message.CentaurWidgetCardItemData != null && Object.hasOwnProperty.call(message, "CentaurWidgetCardItemData"))
                    $root.NAlice.NData.TCentaurWidgetCardItemData.encode(message.CentaurWidgetCardItemData, writer.uint32(/* id 36, wireType 2 =*/290).fork()).ldelim();
                if (message.CentaurWidgetCardItem != null && Object.hasOwnProperty.call(message, "CentaurWidgetCardItem"))
                    $root.NAlice.NData.TCentaurWidgetCardItem.encode(message.CentaurWidgetCardItem, writer.uint32(/* id 37, wireType 2 =*/298).fork()).ldelim();
                if (message.AfishaTeaserData != null && Object.hasOwnProperty.call(message, "AfishaTeaserData"))
                    $root.NAlice.NData.TAfishaTeaserData.encode(message.AfishaTeaserData, writer.uint32(/* id 38, wireType 2 =*/306).fork()).ldelim();
                if (message.CentaurScenarioWidgetData != null && Object.hasOwnProperty.call(message, "CentaurScenarioWidgetData"))
                    $root.NAlice.NData.TCentaurScenarioWidgetData.encode(message.CentaurScenarioWidgetData, writer.uint32(/* id 39, wireType 2 =*/314).fork()).ldelim();
                if (message.IncomingTelegramCallData != null && Object.hasOwnProperty.call(message, "IncomingTelegramCallData"))
                    $root.NAlice.NData.TIncomingTelegramCallData.encode(message.IncomingTelegramCallData, writer.uint32(/* id 40, wireType 2 =*/322).fork()).ldelim();
                if (message.VideoSearchResultData != null && Object.hasOwnProperty.call(message, "VideoSearchResultData"))
                    $root.NAlice.TTvSearchResultData.encode(message.VideoSearchResultData, writer.uint32(/* id 41, wireType 2 =*/330).fork()).ldelim();
                if (message.SearchRichCardData != null && Object.hasOwnProperty.call(message, "SearchRichCardData"))
                    $root.NAlice.NData.TSearchRichCardData.encode(message.SearchRichCardData, writer.uint32(/* id 42, wireType 2 =*/338).fork()).ldelim();
                if (message.OutgoingTelegramCallData != null && Object.hasOwnProperty.call(message, "OutgoingTelegramCallData"))
                    $root.NAlice.NData.TOutgoingTelegramCallData.encode(message.OutgoingTelegramCallData, writer.uint32(/* id 43, wireType 2 =*/346).fork()).ldelim();
                if (message.CurrentTelegramCallData != null && Object.hasOwnProperty.call(message, "CurrentTelegramCallData"))
                    $root.NAlice.NData.TCurrentTelegramCallData.encode(message.CurrentTelegramCallData, writer.uint32(/* id 44, wireType 2 =*/354).fork()).ldelim();
                if (message.GreetingsCardData != null && Object.hasOwnProperty.call(message, "GreetingsCardData"))
                    $root.NAlice.NData.TGreetingsCardData.encode(message.GreetingsCardData, writer.uint32(/* id 45, wireType 2 =*/362).fork()).ldelim();
                if (message.ShowRouteData != null && Object.hasOwnProperty.call(message, "ShowRouteData"))
                    $root.NAlice.NData.TShowRouteData.encode(message.ShowRouteData, writer.uint32(/* id 46, wireType 2 =*/370).fork()).ldelim();
                if (message.DialogovoTeaserCardData != null && Object.hasOwnProperty.call(message, "DialogovoTeaserCardData"))
                    $root.NAlice.NData.TDialogovoSkillTeaserData.encode(message.DialogovoTeaserCardData, writer.uint32(/* id 47, wireType 2 =*/378).fork()).ldelim();
                if (message.TrafficCardData != null && Object.hasOwnProperty.call(message, "TrafficCardData"))
                    $root.NAlice.NData.TTrafficCardData.encode(message.TrafficCardData, writer.uint32(/* id 48, wireType 2 =*/386).fork()).ldelim();
                if (message.ProactivityTeaserData != null && Object.hasOwnProperty.call(message, "ProactivityTeaserData"))
                    $root.NAlice.NData.TProactivityTeaserData.encode(message.ProactivityTeaserData, writer.uint32(/* id 49, wireType 2 =*/394).fork()).ldelim();
                if (message.GreetingsFooterCardData != null && Object.hasOwnProperty.call(message, "GreetingsFooterCardData"))
                    $root.NAlice.NData.TGreetingsFooterCardData.encode(message.GreetingsFooterCardData, writer.uint32(/* id 50, wireType 2 =*/402).fork()).ldelim();
                if (message.TeaserSettingsWithContentData != null && Object.hasOwnProperty.call(message, "TeaserSettingsWithContentData"))
                    $root.NAlice.NData.TTeaserSettingsWithContentData.encode(message.TeaserSettingsWithContentData, writer.uint32(/* id 51, wireType 2 =*/410).fork()).ldelim();
                if (message.TeasersPreviewData != null && Object.hasOwnProperty.call(message, "TeasersPreviewData"))
                    $root.NAlice.NData.TTeasersPreviewData.encode(message.TeasersPreviewData, writer.uint32(/* id 52, wireType 2 =*/418).fork()).ldelim();
                return writer;
            };

            /**
             * Encodes the specified TScenarioData message, length delimited. Does not implicitly {@link NAlice.NData.TScenarioData.verify|verify} messages.
             * @function encodeDelimited
             * @memberof NAlice.NData.TScenarioData
             * @static
             * @param {NAlice.NData.ITScenarioData} message TScenarioData message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            TScenarioData.encodeDelimited = function encodeDelimited(message, writer) {
                return this.encode(message, writer).ldelim();
            };

            /**
             * Decodes a TScenarioData message from the specified reader or buffer.
             * @function decode
             * @memberof NAlice.NData.TScenarioData
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @param {number} [length] Message length if known beforehand
             * @returns {NAlice.NData.TScenarioData} TScenarioData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            TScenarioData.decode = function decode(reader, length) {
                if (!(reader instanceof $Reader))
                    reader = $Reader.create(reader);
                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.NAlice.NData.TScenarioData();
                while (reader.pos < end) {
                    var tag = reader.uint32();
                    switch (tag >>> 3) {
                    case 1:
                        message.SearchObjectData = $root.NAlice.NData.TSearchObjectData.decode(reader, reader.uint32());
                        break;
                    case 2:
                        message.SearchFactData = $root.NAlice.NData.TSearchFactData.decode(reader, reader.uint32());
                        break;
                    case 3:
                        message.ExampleScenarioData = $root.NAlice.NData.TExampleScenarioData.decode(reader, reader.uint32());
                        break;
                    case 4:
                        message.NewsGalleryData = $root.NAlice.NData.TNewsGalleryData.decode(reader, reader.uint32());
                        break;
                    case 5:
                        message.NewsTeaserData = $root.NAlice.NData.TNewsTeaserData.decode(reader, reader.uint32());
                        break;
                    case 6:
                        message.WeatherDayHoursData = $root.NAlice.NData.TWeatherDayHoursData.decode(reader, reader.uint32());
                        break;
                    case 7:
                        message.WeatherDayPartData = $root.NAlice.NData.TWeatherDayPartData.decode(reader, reader.uint32());
                        break;
                    case 8:
                        message.WeatherDayData = $root.NAlice.NData.TWeatherDayData.decode(reader, reader.uint32());
                        break;
                    case 9:
                        message.WeatherDaysRangeData = $root.NAlice.NData.TWeatherDaysRangeData.decode(reader, reader.uint32());
                        break;
                    case 10:
                        message.CentaurMainScreenGalleryMusicCardData = $root.NAlice.NData.TCentaurMainScreenGalleryMusicCardData.decode(reader, reader.uint32());
                        break;
                    case 11:
                        message.CentaurMainScreenGalleryVideoCardData = $root.NAlice.NData.TCentaurMainScreenGalleryVideoCardData.decode(reader, reader.uint32());
                        break;
                    case 12:
                        message.WeatherTeaserData = $root.NAlice.NData.TWeatherTeaserData.decode(reader, reader.uint32());
                        break;
                    case 13:
                        message.MusicPlayerData = $root.NAlice.NData.TMusicPlayerData.decode(reader, reader.uint32());
                        break;
                    case 14:
                        message.CentaurMainScreenWebviewCardData = $root.NAlice.NData.TCentaurMainScreenWebviewCardData.decode(reader, reader.uint32());
                        break;
                    case 15:
                        message.MusicInfiniteFeedData = $root.NAlice.NData.NMusic.TMusicInfiniteFeedData.decode(reader, reader.uint32());
                        break;
                    case 16:
                        message.CentaurMainScreenWebviewTabData = $root.NAlice.NData.TCentaurMainScreenWebviewTabData.decode(reader, reader.uint32());
                        break;
                    case 17:
                        message.CentaurTeaserChromeDefaultLayerData = $root.NAlice.NData.TCentaurTeaserChromeDefaultLayerData.decode(reader, reader.uint32());
                        break;
                    case 18:
                        message.CentaurMainScreenDiscoveryTabData = $root.NAlice.NData.TCentaurMainScreenDiscoveryTabData.decode(reader, reader.uint32());
                        break;
                    case 19:
                        message.CentaurMainScreenMusicTabData = $root.NAlice.NData.TCentaurMainScreenMusicTabData.decode(reader, reader.uint32());
                        break;
                    case 20:
                        message.CentaurMainScreenServicesTabData = $root.NAlice.NData.TCentaurMainScreenServicesTabData.decode(reader, reader.uint32());
                        break;
                    case 21:
                        message.IoTUserData = $root.NAlice.TIoTUserInfo.decode(reader, reader.uint32());
                        break;
                    case 22:
                        message.CentaurMainScreenSmartHomeTabData = $root.NAlice.NData.TCentaurMainScreenSmartHomeTabData.decode(reader, reader.uint32());
                        break;
                    case 23:
                        message.CentaurUpperShutterData = $root.NAlice.NData.TCentaurUpperShutterData.decode(reader, reader.uint32());
                        break;
                    case 24:
                        message.CentaurWebviewData = $root.NAlice.NData.TCentaurWebviewData.decode(reader, reader.uint32());
                        break;
                    case 25:
                        message.CentaurMainScreenMyScreenData = $root.NAlice.NData.TCentaurMainScreenMyScreenData.decode(reader, reader.uint32());
                        break;
                    case 26:
                        message.NewsMainScreenData = $root.NAlice.NData.TNewsMainScreenData.decode(reader, reader.uint32());
                        break;
                    case 27:
                        message.WeatherMainScreenData = $root.NAlice.NData.TWeatherMainScreenData.decode(reader, reader.uint32());
                        break;
                    case 28:
                        message.DialogovoSkillCardData = $root.NAlice.NData.TDialogovoSkillCardData.decode(reader, reader.uint32());
                        break;
                    case 29:
                        message.CentaurWidgetGalleryData = $root.NAlice.NData.TCentaurWidgetGalleryData.decode(reader, reader.uint32());
                        break;
                    case 30:
                        message.ScreenSaverData = $root.NAlice.NData.TScreenSaverData.decode(reader, reader.uint32());
                        break;
                    case 31:
                        message.TrafficData = $root.NAlice.NData.TTrafficWidgetData.decode(reader, reader.uint32());
                        break;
                    case 32:
                        message.GalleryData = $root.NAlice.NData.TGalleryData.decode(reader, reader.uint32());
                        break;
                    case 33:
                        message.ConversationData = $root.NAlice.NData.TConversationData.decode(reader, reader.uint32());
                        break;
                    case 34:
                        message.VideoCallMainScreenData = $root.NAlice.NData.TVideoCallMainScreenData.decode(reader, reader.uint32());
                        break;
                    case 35:
                        message.VideoCallContactChoosingData = $root.NAlice.NData.TVideoCallContactChoosingData.decode(reader, reader.uint32());
                        break;
                    case 36:
                        message.CentaurWidgetCardItemData = $root.NAlice.NData.TCentaurWidgetCardItemData.decode(reader, reader.uint32());
                        break;
                    case 37:
                        message.CentaurWidgetCardItem = $root.NAlice.NData.TCentaurWidgetCardItem.decode(reader, reader.uint32());
                        break;
                    case 38:
                        message.AfishaTeaserData = $root.NAlice.NData.TAfishaTeaserData.decode(reader, reader.uint32());
                        break;
                    case 39:
                        message.CentaurScenarioWidgetData = $root.NAlice.NData.TCentaurScenarioWidgetData.decode(reader, reader.uint32());
                        break;
                    case 40:
                        message.IncomingTelegramCallData = $root.NAlice.NData.TIncomingTelegramCallData.decode(reader, reader.uint32());
                        break;
                    case 41:
                        message.VideoSearchResultData = $root.NAlice.TTvSearchResultData.decode(reader, reader.uint32());
                        break;
                    case 42:
                        message.SearchRichCardData = $root.NAlice.NData.TSearchRichCardData.decode(reader, reader.uint32());
                        break;
                    case 43:
                        message.OutgoingTelegramCallData = $root.NAlice.NData.TOutgoingTelegramCallData.decode(reader, reader.uint32());
                        break;
                    case 44:
                        message.CurrentTelegramCallData = $root.NAlice.NData.TCurrentTelegramCallData.decode(reader, reader.uint32());
                        break;
                    case 45:
                        message.GreetingsCardData = $root.NAlice.NData.TGreetingsCardData.decode(reader, reader.uint32());
                        break;
                    case 46:
                        message.ShowRouteData = $root.NAlice.NData.TShowRouteData.decode(reader, reader.uint32());
                        break;
                    case 47:
                        message.DialogovoTeaserCardData = $root.NAlice.NData.TDialogovoSkillTeaserData.decode(reader, reader.uint32());
                        break;
                    case 48:
                        message.TrafficCardData = $root.NAlice.NData.TTrafficCardData.decode(reader, reader.uint32());
                        break;
                    case 49:
                        message.ProactivityTeaserData = $root.NAlice.NData.TProactivityTeaserData.decode(reader, reader.uint32());
                        break;
                    case 50:
                        message.GreetingsFooterCardData = $root.NAlice.NData.TGreetingsFooterCardData.decode(reader, reader.uint32());
                        break;
                    case 51:
                        message.TeaserSettingsWithContentData = $root.NAlice.NData.TTeaserSettingsWithContentData.decode(reader, reader.uint32());
                        break;
                    case 52:
                        message.TeasersPreviewData = $root.NAlice.NData.TTeasersPreviewData.decode(reader, reader.uint32());
                        break;
                    default:
                        reader.skipType(tag & 7);
                        break;
                    }
                }
                return message;
            };

            /**
             * Decodes a TScenarioData message from the specified reader or buffer, length delimited.
             * @function decodeDelimited
             * @memberof NAlice.NData.TScenarioData
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @returns {NAlice.NData.TScenarioData} TScenarioData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            TScenarioData.decodeDelimited = function decodeDelimited(reader) {
                if (!(reader instanceof $Reader))
                    reader = new $Reader(reader);
                return this.decode(reader, reader.uint32());
            };

            /**
             * Verifies a TScenarioData message.
             * @function verify
             * @memberof NAlice.NData.TScenarioData
             * @static
             * @param {Object.<string,*>} message Plain object to verify
             * @returns {string|null} `null` if valid, otherwise the reason why it is not
             */
            TScenarioData.verify = function verify(message) {
                if (typeof message !== "object" || message === null)
                    return "object expected";
                var properties = {};
                if (message.SearchObjectData != null && message.hasOwnProperty("SearchObjectData")) {
                    properties.Data = 1;
                    {
                        var error = $root.NAlice.NData.TSearchObjectData.verify(message.SearchObjectData);
                        if (error)
                            return "SearchObjectData." + error;
                    }
                }
                if (message.SearchFactData != null && message.hasOwnProperty("SearchFactData")) {
                    if (properties.Data === 1)
                        return "Data: multiple values";
                    properties.Data = 1;
                    {
                        var error = $root.NAlice.NData.TSearchFactData.verify(message.SearchFactData);
                        if (error)
                            return "SearchFactData." + error;
                    }
                }
                if (message.ExampleScenarioData != null && message.hasOwnProperty("ExampleScenarioData")) {
                    if (properties.Data === 1)
                        return "Data: multiple values";
                    properties.Data = 1;
                    {
                        var error = $root.NAlice.NData.TExampleScenarioData.verify(message.ExampleScenarioData);
                        if (error)
                            return "ExampleScenarioData." + error;
                    }
                }
                if (message.NewsGalleryData != null && message.hasOwnProperty("NewsGalleryData")) {
                    if (properties.Data === 1)
                        return "Data: multiple values";
                    properties.Data = 1;
                    {
                        var error = $root.NAlice.NData.TNewsGalleryData.verify(message.NewsGalleryData);
                        if (error)
                            return "NewsGalleryData." + error;
                    }
                }
                if (message.NewsTeaserData != null && message.hasOwnProperty("NewsTeaserData")) {
                    if (properties.Data === 1)
                        return "Data: multiple values";
                    properties.Data = 1;
                    {
                        var error = $root.NAlice.NData.TNewsTeaserData.verify(message.NewsTeaserData);
                        if (error)
                            return "NewsTeaserData." + error;
                    }
                }
                if (message.WeatherDayHoursData != null && message.hasOwnProperty("WeatherDayHoursData")) {
                    if (properties.Data === 1)
                        return "Data: multiple values";
                    properties.Data = 1;
                    {
                        var error = $root.NAlice.NData.TWeatherDayHoursData.verify(message.WeatherDayHoursData);
                        if (error)
                            return "WeatherDayHoursData." + error;
                    }
                }
                if (message.WeatherDayPartData != null && message.hasOwnProperty("WeatherDayPartData")) {
                    if (properties.Data === 1)
                        return "Data: multiple values";
                    properties.Data = 1;
                    {
                        var error = $root.NAlice.NData.TWeatherDayPartData.verify(message.WeatherDayPartData);
                        if (error)
                            return "WeatherDayPartData." + error;
                    }
                }
                if (message.WeatherDayData != null && message.hasOwnProperty("WeatherDayData")) {
                    if (properties.Data === 1)
                        return "Data: multiple values";
                    properties.Data = 1;
                    {
                        var error = $root.NAlice.NData.TWeatherDayData.verify(message.WeatherDayData);
                        if (error)
                            return "WeatherDayData." + error;
                    }
                }
                if (message.WeatherDaysRangeData != null && message.hasOwnProperty("WeatherDaysRangeData")) {
                    if (properties.Data === 1)
                        return "Data: multiple values";
                    properties.Data = 1;
                    {
                        var error = $root.NAlice.NData.TWeatherDaysRangeData.verify(message.WeatherDaysRangeData);
                        if (error)
                            return "WeatherDaysRangeData." + error;
                    }
                }
                if (message.CentaurMainScreenGalleryMusicCardData != null && message.hasOwnProperty("CentaurMainScreenGalleryMusicCardData")) {
                    if (properties.Data === 1)
                        return "Data: multiple values";
                    properties.Data = 1;
                    {
                        var error = $root.NAlice.NData.TCentaurMainScreenGalleryMusicCardData.verify(message.CentaurMainScreenGalleryMusicCardData);
                        if (error)
                            return "CentaurMainScreenGalleryMusicCardData." + error;
                    }
                }
                if (message.CentaurMainScreenGalleryVideoCardData != null && message.hasOwnProperty("CentaurMainScreenGalleryVideoCardData")) {
                    if (properties.Data === 1)
                        return "Data: multiple values";
                    properties.Data = 1;
                    {
                        var error = $root.NAlice.NData.TCentaurMainScreenGalleryVideoCardData.verify(message.CentaurMainScreenGalleryVideoCardData);
                        if (error)
                            return "CentaurMainScreenGalleryVideoCardData." + error;
                    }
                }
                if (message.WeatherTeaserData != null && message.hasOwnProperty("WeatherTeaserData")) {
                    if (properties.Data === 1)
                        return "Data: multiple values";
                    properties.Data = 1;
                    {
                        var error = $root.NAlice.NData.TWeatherTeaserData.verify(message.WeatherTeaserData);
                        if (error)
                            return "WeatherTeaserData." + error;
                    }
                }
                if (message.MusicPlayerData != null && message.hasOwnProperty("MusicPlayerData")) {
                    if (properties.Data === 1)
                        return "Data: multiple values";
                    properties.Data = 1;
                    {
                        var error = $root.NAlice.NData.TMusicPlayerData.verify(message.MusicPlayerData);
                        if (error)
                            return "MusicPlayerData." + error;
                    }
                }
                if (message.CentaurMainScreenWebviewCardData != null && message.hasOwnProperty("CentaurMainScreenWebviewCardData")) {
                    if (properties.Data === 1)
                        return "Data: multiple values";
                    properties.Data = 1;
                    {
                        var error = $root.NAlice.NData.TCentaurMainScreenWebviewCardData.verify(message.CentaurMainScreenWebviewCardData);
                        if (error)
                            return "CentaurMainScreenWebviewCardData." + error;
                    }
                }
                if (message.MusicInfiniteFeedData != null && message.hasOwnProperty("MusicInfiniteFeedData")) {
                    if (properties.Data === 1)
                        return "Data: multiple values";
                    properties.Data = 1;
                    {
                        var error = $root.NAlice.NData.NMusic.TMusicInfiniteFeedData.verify(message.MusicInfiniteFeedData);
                        if (error)
                            return "MusicInfiniteFeedData." + error;
                    }
                }
                if (message.CentaurMainScreenWebviewTabData != null && message.hasOwnProperty("CentaurMainScreenWebviewTabData")) {
                    if (properties.Data === 1)
                        return "Data: multiple values";
                    properties.Data = 1;
                    {
                        var error = $root.NAlice.NData.TCentaurMainScreenWebviewTabData.verify(message.CentaurMainScreenWebviewTabData);
                        if (error)
                            return "CentaurMainScreenWebviewTabData." + error;
                    }
                }
                if (message.CentaurTeaserChromeDefaultLayerData != null && message.hasOwnProperty("CentaurTeaserChromeDefaultLayerData")) {
                    if (properties.Data === 1)
                        return "Data: multiple values";
                    properties.Data = 1;
                    {
                        var error = $root.NAlice.NData.TCentaurTeaserChromeDefaultLayerData.verify(message.CentaurTeaserChromeDefaultLayerData);
                        if (error)
                            return "CentaurTeaserChromeDefaultLayerData." + error;
                    }
                }
                if (message.CentaurMainScreenDiscoveryTabData != null && message.hasOwnProperty("CentaurMainScreenDiscoveryTabData")) {
                    if (properties.Data === 1)
                        return "Data: multiple values";
                    properties.Data = 1;
                    {
                        var error = $root.NAlice.NData.TCentaurMainScreenDiscoveryTabData.verify(message.CentaurMainScreenDiscoveryTabData);
                        if (error)
                            return "CentaurMainScreenDiscoveryTabData." + error;
                    }
                }
                if (message.CentaurMainScreenMusicTabData != null && message.hasOwnProperty("CentaurMainScreenMusicTabData")) {
                    if (properties.Data === 1)
                        return "Data: multiple values";
                    properties.Data = 1;
                    {
                        var error = $root.NAlice.NData.TCentaurMainScreenMusicTabData.verify(message.CentaurMainScreenMusicTabData);
                        if (error)
                            return "CentaurMainScreenMusicTabData." + error;
                    }
                }
                if (message.CentaurMainScreenServicesTabData != null && message.hasOwnProperty("CentaurMainScreenServicesTabData")) {
                    if (properties.Data === 1)
                        return "Data: multiple values";
                    properties.Data = 1;
                    {
                        var error = $root.NAlice.NData.TCentaurMainScreenServicesTabData.verify(message.CentaurMainScreenServicesTabData);
                        if (error)
                            return "CentaurMainScreenServicesTabData." + error;
                    }
                }
                if (message.IoTUserData != null && message.hasOwnProperty("IoTUserData")) {
                    if (properties.Data === 1)
                        return "Data: multiple values";
                    properties.Data = 1;
                    {
                        var error = $root.NAlice.TIoTUserInfo.verify(message.IoTUserData);
                        if (error)
                            return "IoTUserData." + error;
                    }
                }
                if (message.CentaurMainScreenSmartHomeTabData != null && message.hasOwnProperty("CentaurMainScreenSmartHomeTabData")) {
                    if (properties.Data === 1)
                        return "Data: multiple values";
                    properties.Data = 1;
                    {
                        var error = $root.NAlice.NData.TCentaurMainScreenSmartHomeTabData.verify(message.CentaurMainScreenSmartHomeTabData);
                        if (error)
                            return "CentaurMainScreenSmartHomeTabData." + error;
                    }
                }
                if (message.CentaurUpperShutterData != null && message.hasOwnProperty("CentaurUpperShutterData")) {
                    if (properties.Data === 1)
                        return "Data: multiple values";
                    properties.Data = 1;
                    {
                        var error = $root.NAlice.NData.TCentaurUpperShutterData.verify(message.CentaurUpperShutterData);
                        if (error)
                            return "CentaurUpperShutterData." + error;
                    }
                }
                if (message.CentaurWebviewData != null && message.hasOwnProperty("CentaurWebviewData")) {
                    if (properties.Data === 1)
                        return "Data: multiple values";
                    properties.Data = 1;
                    {
                        var error = $root.NAlice.NData.TCentaurWebviewData.verify(message.CentaurWebviewData);
                        if (error)
                            return "CentaurWebviewData." + error;
                    }
                }
                if (message.CentaurMainScreenMyScreenData != null && message.hasOwnProperty("CentaurMainScreenMyScreenData")) {
                    if (properties.Data === 1)
                        return "Data: multiple values";
                    properties.Data = 1;
                    {
                        var error = $root.NAlice.NData.TCentaurMainScreenMyScreenData.verify(message.CentaurMainScreenMyScreenData);
                        if (error)
                            return "CentaurMainScreenMyScreenData." + error;
                    }
                }
                if (message.NewsMainScreenData != null && message.hasOwnProperty("NewsMainScreenData")) {
                    if (properties.Data === 1)
                        return "Data: multiple values";
                    properties.Data = 1;
                    {
                        var error = $root.NAlice.NData.TNewsMainScreenData.verify(message.NewsMainScreenData);
                        if (error)
                            return "NewsMainScreenData." + error;
                    }
                }
                if (message.WeatherMainScreenData != null && message.hasOwnProperty("WeatherMainScreenData")) {
                    if (properties.Data === 1)
                        return "Data: multiple values";
                    properties.Data = 1;
                    {
                        var error = $root.NAlice.NData.TWeatherMainScreenData.verify(message.WeatherMainScreenData);
                        if (error)
                            return "WeatherMainScreenData." + error;
                    }
                }
                if (message.DialogovoSkillCardData != null && message.hasOwnProperty("DialogovoSkillCardData")) {
                    if (properties.Data === 1)
                        return "Data: multiple values";
                    properties.Data = 1;
                    {
                        var error = $root.NAlice.NData.TDialogovoSkillCardData.verify(message.DialogovoSkillCardData);
                        if (error)
                            return "DialogovoSkillCardData." + error;
                    }
                }
                if (message.CentaurWidgetGalleryData != null && message.hasOwnProperty("CentaurWidgetGalleryData")) {
                    if (properties.Data === 1)
                        return "Data: multiple values";
                    properties.Data = 1;
                    {
                        var error = $root.NAlice.NData.TCentaurWidgetGalleryData.verify(message.CentaurWidgetGalleryData);
                        if (error)
                            return "CentaurWidgetGalleryData." + error;
                    }
                }
                if (message.ScreenSaverData != null && message.hasOwnProperty("ScreenSaverData")) {
                    if (properties.Data === 1)
                        return "Data: multiple values";
                    properties.Data = 1;
                    {
                        var error = $root.NAlice.NData.TScreenSaverData.verify(message.ScreenSaverData);
                        if (error)
                            return "ScreenSaverData." + error;
                    }
                }
                if (message.TrafficData != null && message.hasOwnProperty("TrafficData")) {
                    if (properties.Data === 1)
                        return "Data: multiple values";
                    properties.Data = 1;
                    {
                        var error = $root.NAlice.NData.TTrafficWidgetData.verify(message.TrafficData);
                        if (error)
                            return "TrafficData." + error;
                    }
                }
                if (message.GalleryData != null && message.hasOwnProperty("GalleryData")) {
                    if (properties.Data === 1)
                        return "Data: multiple values";
                    properties.Data = 1;
                    {
                        var error = $root.NAlice.NData.TGalleryData.verify(message.GalleryData);
                        if (error)
                            return "GalleryData." + error;
                    }
                }
                if (message.ConversationData != null && message.hasOwnProperty("ConversationData")) {
                    if (properties.Data === 1)
                        return "Data: multiple values";
                    properties.Data = 1;
                    {
                        var error = $root.NAlice.NData.TConversationData.verify(message.ConversationData);
                        if (error)
                            return "ConversationData." + error;
                    }
                }
                if (message.VideoCallMainScreenData != null && message.hasOwnProperty("VideoCallMainScreenData")) {
                    if (properties.Data === 1)
                        return "Data: multiple values";
                    properties.Data = 1;
                    {
                        var error = $root.NAlice.NData.TVideoCallMainScreenData.verify(message.VideoCallMainScreenData);
                        if (error)
                            return "VideoCallMainScreenData." + error;
                    }
                }
                if (message.VideoCallContactChoosingData != null && message.hasOwnProperty("VideoCallContactChoosingData")) {
                    if (properties.Data === 1)
                        return "Data: multiple values";
                    properties.Data = 1;
                    {
                        var error = $root.NAlice.NData.TVideoCallContactChoosingData.verify(message.VideoCallContactChoosingData);
                        if (error)
                            return "VideoCallContactChoosingData." + error;
                    }
                }
                if (message.CentaurWidgetCardItemData != null && message.hasOwnProperty("CentaurWidgetCardItemData")) {
                    if (properties.Data === 1)
                        return "Data: multiple values";
                    properties.Data = 1;
                    {
                        var error = $root.NAlice.NData.TCentaurWidgetCardItemData.verify(message.CentaurWidgetCardItemData);
                        if (error)
                            return "CentaurWidgetCardItemData." + error;
                    }
                }
                if (message.CentaurWidgetCardItem != null && message.hasOwnProperty("CentaurWidgetCardItem")) {
                    if (properties.Data === 1)
                        return "Data: multiple values";
                    properties.Data = 1;
                    {
                        var error = $root.NAlice.NData.TCentaurWidgetCardItem.verify(message.CentaurWidgetCardItem);
                        if (error)
                            return "CentaurWidgetCardItem." + error;
                    }
                }
                if (message.AfishaTeaserData != null && message.hasOwnProperty("AfishaTeaserData")) {
                    if (properties.Data === 1)
                        return "Data: multiple values";
                    properties.Data = 1;
                    {
                        var error = $root.NAlice.NData.TAfishaTeaserData.verify(message.AfishaTeaserData);
                        if (error)
                            return "AfishaTeaserData." + error;
                    }
                }
                if (message.CentaurScenarioWidgetData != null && message.hasOwnProperty("CentaurScenarioWidgetData")) {
                    if (properties.Data === 1)
                        return "Data: multiple values";
                    properties.Data = 1;
                    {
                        var error = $root.NAlice.NData.TCentaurScenarioWidgetData.verify(message.CentaurScenarioWidgetData);
                        if (error)
                            return "CentaurScenarioWidgetData." + error;
                    }
                }
                if (message.IncomingTelegramCallData != null && message.hasOwnProperty("IncomingTelegramCallData")) {
                    if (properties.Data === 1)
                        return "Data: multiple values";
                    properties.Data = 1;
                    {
                        var error = $root.NAlice.NData.TIncomingTelegramCallData.verify(message.IncomingTelegramCallData);
                        if (error)
                            return "IncomingTelegramCallData." + error;
                    }
                }
                if (message.VideoSearchResultData != null && message.hasOwnProperty("VideoSearchResultData")) {
                    if (properties.Data === 1)
                        return "Data: multiple values";
                    properties.Data = 1;
                    {
                        var error = $root.NAlice.TTvSearchResultData.verify(message.VideoSearchResultData);
                        if (error)
                            return "VideoSearchResultData." + error;
                    }
                }
                if (message.SearchRichCardData != null && message.hasOwnProperty("SearchRichCardData")) {
                    if (properties.Data === 1)
                        return "Data: multiple values";
                    properties.Data = 1;
                    {
                        var error = $root.NAlice.NData.TSearchRichCardData.verify(message.SearchRichCardData);
                        if (error)
                            return "SearchRichCardData." + error;
                    }
                }
                if (message.OutgoingTelegramCallData != null && message.hasOwnProperty("OutgoingTelegramCallData")) {
                    if (properties.Data === 1)
                        return "Data: multiple values";
                    properties.Data = 1;
                    {
                        var error = $root.NAlice.NData.TOutgoingTelegramCallData.verify(message.OutgoingTelegramCallData);
                        if (error)
                            return "OutgoingTelegramCallData." + error;
                    }
                }
                if (message.CurrentTelegramCallData != null && message.hasOwnProperty("CurrentTelegramCallData")) {
                    if (properties.Data === 1)
                        return "Data: multiple values";
                    properties.Data = 1;
                    {
                        var error = $root.NAlice.NData.TCurrentTelegramCallData.verify(message.CurrentTelegramCallData);
                        if (error)
                            return "CurrentTelegramCallData." + error;
                    }
                }
                if (message.GreetingsCardData != null && message.hasOwnProperty("GreetingsCardData")) {
                    if (properties.Data === 1)
                        return "Data: multiple values";
                    properties.Data = 1;
                    {
                        var error = $root.NAlice.NData.TGreetingsCardData.verify(message.GreetingsCardData);
                        if (error)
                            return "GreetingsCardData." + error;
                    }
                }
                if (message.ShowRouteData != null && message.hasOwnProperty("ShowRouteData")) {
                    if (properties.Data === 1)
                        return "Data: multiple values";
                    properties.Data = 1;
                    {
                        var error = $root.NAlice.NData.TShowRouteData.verify(message.ShowRouteData);
                        if (error)
                            return "ShowRouteData." + error;
                    }
                }
                if (message.DialogovoTeaserCardData != null && message.hasOwnProperty("DialogovoTeaserCardData")) {
                    if (properties.Data === 1)
                        return "Data: multiple values";
                    properties.Data = 1;
                    {
                        var error = $root.NAlice.NData.TDialogovoSkillTeaserData.verify(message.DialogovoTeaserCardData);
                        if (error)
                            return "DialogovoTeaserCardData." + error;
                    }
                }
                if (message.TrafficCardData != null && message.hasOwnProperty("TrafficCardData")) {
                    if (properties.Data === 1)
                        return "Data: multiple values";
                    properties.Data = 1;
                    {
                        var error = $root.NAlice.NData.TTrafficCardData.verify(message.TrafficCardData);
                        if (error)
                            return "TrafficCardData." + error;
                    }
                }
                if (message.ProactivityTeaserData != null && message.hasOwnProperty("ProactivityTeaserData")) {
                    if (properties.Data === 1)
                        return "Data: multiple values";
                    properties.Data = 1;
                    {
                        var error = $root.NAlice.NData.TProactivityTeaserData.verify(message.ProactivityTeaserData);
                        if (error)
                            return "ProactivityTeaserData." + error;
                    }
                }
                if (message.GreetingsFooterCardData != null && message.hasOwnProperty("GreetingsFooterCardData")) {
                    if (properties.Data === 1)
                        return "Data: multiple values";
                    properties.Data = 1;
                    {
                        var error = $root.NAlice.NData.TGreetingsFooterCardData.verify(message.GreetingsFooterCardData);
                        if (error)
                            return "GreetingsFooterCardData." + error;
                    }
                }
                if (message.TeaserSettingsWithContentData != null && message.hasOwnProperty("TeaserSettingsWithContentData")) {
                    if (properties.Data === 1)
                        return "Data: multiple values";
                    properties.Data = 1;
                    {
                        var error = $root.NAlice.NData.TTeaserSettingsWithContentData.verify(message.TeaserSettingsWithContentData);
                        if (error)
                            return "TeaserSettingsWithContentData." + error;
                    }
                }
                if (message.TeasersPreviewData != null && message.hasOwnProperty("TeasersPreviewData")) {
                    if (properties.Data === 1)
                        return "Data: multiple values";
                    properties.Data = 1;
                    {
                        var error = $root.NAlice.NData.TTeasersPreviewData.verify(message.TeasersPreviewData);
                        if (error)
                            return "TeasersPreviewData." + error;
                    }
                }
                return null;
            };

            /**
             * Creates a TScenarioData message from a plain object. Also converts values to their respective internal types.
             * @function fromObject
             * @memberof NAlice.NData.TScenarioData
             * @static
             * @param {Object.<string,*>} object Plain object
             * @returns {NAlice.NData.TScenarioData} TScenarioData
             */
            TScenarioData.fromObject = function fromObject(object) {
                if (object instanceof $root.NAlice.NData.TScenarioData)
                    return object;
                var message = new $root.NAlice.NData.TScenarioData();
                if (object.SearchObjectData != null) {
                    if (typeof object.SearchObjectData !== "object")
                        throw TypeError(".NAlice.NData.TScenarioData.SearchObjectData: object expected");
                    message.SearchObjectData = $root.NAlice.NData.TSearchObjectData.fromObject(object.SearchObjectData);
                }
                if (object.SearchFactData != null) {
                    if (typeof object.SearchFactData !== "object")
                        throw TypeError(".NAlice.NData.TScenarioData.SearchFactData: object expected");
                    message.SearchFactData = $root.NAlice.NData.TSearchFactData.fromObject(object.SearchFactData);
                }
                if (object.ExampleScenarioData != null) {
                    if (typeof object.ExampleScenarioData !== "object")
                        throw TypeError(".NAlice.NData.TScenarioData.ExampleScenarioData: object expected");
                    message.ExampleScenarioData = $root.NAlice.NData.TExampleScenarioData.fromObject(object.ExampleScenarioData);
                }
                if (object.NewsGalleryData != null) {
                    if (typeof object.NewsGalleryData !== "object")
                        throw TypeError(".NAlice.NData.TScenarioData.NewsGalleryData: object expected");
                    message.NewsGalleryData = $root.NAlice.NData.TNewsGalleryData.fromObject(object.NewsGalleryData);
                }
                if (object.NewsTeaserData != null) {
                    if (typeof object.NewsTeaserData !== "object")
                        throw TypeError(".NAlice.NData.TScenarioData.NewsTeaserData: object expected");
                    message.NewsTeaserData = $root.NAlice.NData.TNewsTeaserData.fromObject(object.NewsTeaserData);
                }
                if (object.WeatherDayHoursData != null) {
                    if (typeof object.WeatherDayHoursData !== "object")
                        throw TypeError(".NAlice.NData.TScenarioData.WeatherDayHoursData: object expected");
                    message.WeatherDayHoursData = $root.NAlice.NData.TWeatherDayHoursData.fromObject(object.WeatherDayHoursData);
                }
                if (object.WeatherDayPartData != null) {
                    if (typeof object.WeatherDayPartData !== "object")
                        throw TypeError(".NAlice.NData.TScenarioData.WeatherDayPartData: object expected");
                    message.WeatherDayPartData = $root.NAlice.NData.TWeatherDayPartData.fromObject(object.WeatherDayPartData);
                }
                if (object.WeatherDayData != null) {
                    if (typeof object.WeatherDayData !== "object")
                        throw TypeError(".NAlice.NData.TScenarioData.WeatherDayData: object expected");
                    message.WeatherDayData = $root.NAlice.NData.TWeatherDayData.fromObject(object.WeatherDayData);
                }
                if (object.WeatherDaysRangeData != null) {
                    if (typeof object.WeatherDaysRangeData !== "object")
                        throw TypeError(".NAlice.NData.TScenarioData.WeatherDaysRangeData: object expected");
                    message.WeatherDaysRangeData = $root.NAlice.NData.TWeatherDaysRangeData.fromObject(object.WeatherDaysRangeData);
                }
                if (object.CentaurMainScreenGalleryMusicCardData != null) {
                    if (typeof object.CentaurMainScreenGalleryMusicCardData !== "object")
                        throw TypeError(".NAlice.NData.TScenarioData.CentaurMainScreenGalleryMusicCardData: object expected");
                    message.CentaurMainScreenGalleryMusicCardData = $root.NAlice.NData.TCentaurMainScreenGalleryMusicCardData.fromObject(object.CentaurMainScreenGalleryMusicCardData);
                }
                if (object.CentaurMainScreenGalleryVideoCardData != null) {
                    if (typeof object.CentaurMainScreenGalleryVideoCardData !== "object")
                        throw TypeError(".NAlice.NData.TScenarioData.CentaurMainScreenGalleryVideoCardData: object expected");
                    message.CentaurMainScreenGalleryVideoCardData = $root.NAlice.NData.TCentaurMainScreenGalleryVideoCardData.fromObject(object.CentaurMainScreenGalleryVideoCardData);
                }
                if (object.WeatherTeaserData != null) {
                    if (typeof object.WeatherTeaserData !== "object")
                        throw TypeError(".NAlice.NData.TScenarioData.WeatherTeaserData: object expected");
                    message.WeatherTeaserData = $root.NAlice.NData.TWeatherTeaserData.fromObject(object.WeatherTeaserData);
                }
                if (object.MusicPlayerData != null) {
                    if (typeof object.MusicPlayerData !== "object")
                        throw TypeError(".NAlice.NData.TScenarioData.MusicPlayerData: object expected");
                    message.MusicPlayerData = $root.NAlice.NData.TMusicPlayerData.fromObject(object.MusicPlayerData);
                }
                if (object.CentaurMainScreenWebviewCardData != null) {
                    if (typeof object.CentaurMainScreenWebviewCardData !== "object")
                        throw TypeError(".NAlice.NData.TScenarioData.CentaurMainScreenWebviewCardData: object expected");
                    message.CentaurMainScreenWebviewCardData = $root.NAlice.NData.TCentaurMainScreenWebviewCardData.fromObject(object.CentaurMainScreenWebviewCardData);
                }
                if (object.MusicInfiniteFeedData != null) {
                    if (typeof object.MusicInfiniteFeedData !== "object")
                        throw TypeError(".NAlice.NData.TScenarioData.MusicInfiniteFeedData: object expected");
                    message.MusicInfiniteFeedData = $root.NAlice.NData.NMusic.TMusicInfiniteFeedData.fromObject(object.MusicInfiniteFeedData);
                }
                if (object.CentaurMainScreenWebviewTabData != null) {
                    if (typeof object.CentaurMainScreenWebviewTabData !== "object")
                        throw TypeError(".NAlice.NData.TScenarioData.CentaurMainScreenWebviewTabData: object expected");
                    message.CentaurMainScreenWebviewTabData = $root.NAlice.NData.TCentaurMainScreenWebviewTabData.fromObject(object.CentaurMainScreenWebviewTabData);
                }
                if (object.CentaurTeaserChromeDefaultLayerData != null) {
                    if (typeof object.CentaurTeaserChromeDefaultLayerData !== "object")
                        throw TypeError(".NAlice.NData.TScenarioData.CentaurTeaserChromeDefaultLayerData: object expected");
                    message.CentaurTeaserChromeDefaultLayerData = $root.NAlice.NData.TCentaurTeaserChromeDefaultLayerData.fromObject(object.CentaurTeaserChromeDefaultLayerData);
                }
                if (object.CentaurMainScreenDiscoveryTabData != null) {
                    if (typeof object.CentaurMainScreenDiscoveryTabData !== "object")
                        throw TypeError(".NAlice.NData.TScenarioData.CentaurMainScreenDiscoveryTabData: object expected");
                    message.CentaurMainScreenDiscoveryTabData = $root.NAlice.NData.TCentaurMainScreenDiscoveryTabData.fromObject(object.CentaurMainScreenDiscoveryTabData);
                }
                if (object.CentaurMainScreenMusicTabData != null) {
                    if (typeof object.CentaurMainScreenMusicTabData !== "object")
                        throw TypeError(".NAlice.NData.TScenarioData.CentaurMainScreenMusicTabData: object expected");
                    message.CentaurMainScreenMusicTabData = $root.NAlice.NData.TCentaurMainScreenMusicTabData.fromObject(object.CentaurMainScreenMusicTabData);
                }
                if (object.CentaurMainScreenServicesTabData != null) {
                    if (typeof object.CentaurMainScreenServicesTabData !== "object")
                        throw TypeError(".NAlice.NData.TScenarioData.CentaurMainScreenServicesTabData: object expected");
                    message.CentaurMainScreenServicesTabData = $root.NAlice.NData.TCentaurMainScreenServicesTabData.fromObject(object.CentaurMainScreenServicesTabData);
                }
                if (object.IoTUserData != null) {
                    if (typeof object.IoTUserData !== "object")
                        throw TypeError(".NAlice.NData.TScenarioData.IoTUserData: object expected");
                    message.IoTUserData = $root.NAlice.TIoTUserInfo.fromObject(object.IoTUserData);
                }
                if (object.CentaurMainScreenSmartHomeTabData != null) {
                    if (typeof object.CentaurMainScreenSmartHomeTabData !== "object")
                        throw TypeError(".NAlice.NData.TScenarioData.CentaurMainScreenSmartHomeTabData: object expected");
                    message.CentaurMainScreenSmartHomeTabData = $root.NAlice.NData.TCentaurMainScreenSmartHomeTabData.fromObject(object.CentaurMainScreenSmartHomeTabData);
                }
                if (object.CentaurUpperShutterData != null) {
                    if (typeof object.CentaurUpperShutterData !== "object")
                        throw TypeError(".NAlice.NData.TScenarioData.CentaurUpperShutterData: object expected");
                    message.CentaurUpperShutterData = $root.NAlice.NData.TCentaurUpperShutterData.fromObject(object.CentaurUpperShutterData);
                }
                if (object.CentaurWebviewData != null) {
                    if (typeof object.CentaurWebviewData !== "object")
                        throw TypeError(".NAlice.NData.TScenarioData.CentaurWebviewData: object expected");
                    message.CentaurWebviewData = $root.NAlice.NData.TCentaurWebviewData.fromObject(object.CentaurWebviewData);
                }
                if (object.CentaurMainScreenMyScreenData != null) {
                    if (typeof object.CentaurMainScreenMyScreenData !== "object")
                        throw TypeError(".NAlice.NData.TScenarioData.CentaurMainScreenMyScreenData: object expected");
                    message.CentaurMainScreenMyScreenData = $root.NAlice.NData.TCentaurMainScreenMyScreenData.fromObject(object.CentaurMainScreenMyScreenData);
                }
                if (object.NewsMainScreenData != null) {
                    if (typeof object.NewsMainScreenData !== "object")
                        throw TypeError(".NAlice.NData.TScenarioData.NewsMainScreenData: object expected");
                    message.NewsMainScreenData = $root.NAlice.NData.TNewsMainScreenData.fromObject(object.NewsMainScreenData);
                }
                if (object.WeatherMainScreenData != null) {
                    if (typeof object.WeatherMainScreenData !== "object")
                        throw TypeError(".NAlice.NData.TScenarioData.WeatherMainScreenData: object expected");
                    message.WeatherMainScreenData = $root.NAlice.NData.TWeatherMainScreenData.fromObject(object.WeatherMainScreenData);
                }
                if (object.DialogovoSkillCardData != null) {
                    if (typeof object.DialogovoSkillCardData !== "object")
                        throw TypeError(".NAlice.NData.TScenarioData.DialogovoSkillCardData: object expected");
                    message.DialogovoSkillCardData = $root.NAlice.NData.TDialogovoSkillCardData.fromObject(object.DialogovoSkillCardData);
                }
                if (object.CentaurWidgetGalleryData != null) {
                    if (typeof object.CentaurWidgetGalleryData !== "object")
                        throw TypeError(".NAlice.NData.TScenarioData.CentaurWidgetGalleryData: object expected");
                    message.CentaurWidgetGalleryData = $root.NAlice.NData.TCentaurWidgetGalleryData.fromObject(object.CentaurWidgetGalleryData);
                }
                if (object.ScreenSaverData != null) {
                    if (typeof object.ScreenSaverData !== "object")
                        throw TypeError(".NAlice.NData.TScenarioData.ScreenSaverData: object expected");
                    message.ScreenSaverData = $root.NAlice.NData.TScreenSaverData.fromObject(object.ScreenSaverData);
                }
                if (object.TrafficData != null) {
                    if (typeof object.TrafficData !== "object")
                        throw TypeError(".NAlice.NData.TScenarioData.TrafficData: object expected");
                    message.TrafficData = $root.NAlice.NData.TTrafficWidgetData.fromObject(object.TrafficData);
                }
                if (object.GalleryData != null) {
                    if (typeof object.GalleryData !== "object")
                        throw TypeError(".NAlice.NData.TScenarioData.GalleryData: object expected");
                    message.GalleryData = $root.NAlice.NData.TGalleryData.fromObject(object.GalleryData);
                }
                if (object.ConversationData != null) {
                    if (typeof object.ConversationData !== "object")
                        throw TypeError(".NAlice.NData.TScenarioData.ConversationData: object expected");
                    message.ConversationData = $root.NAlice.NData.TConversationData.fromObject(object.ConversationData);
                }
                if (object.VideoCallMainScreenData != null) {
                    if (typeof object.VideoCallMainScreenData !== "object")
                        throw TypeError(".NAlice.NData.TScenarioData.VideoCallMainScreenData: object expected");
                    message.VideoCallMainScreenData = $root.NAlice.NData.TVideoCallMainScreenData.fromObject(object.VideoCallMainScreenData);
                }
                if (object.VideoCallContactChoosingData != null) {
                    if (typeof object.VideoCallContactChoosingData !== "object")
                        throw TypeError(".NAlice.NData.TScenarioData.VideoCallContactChoosingData: object expected");
                    message.VideoCallContactChoosingData = $root.NAlice.NData.TVideoCallContactChoosingData.fromObject(object.VideoCallContactChoosingData);
                }
                if (object.CentaurWidgetCardItemData != null) {
                    if (typeof object.CentaurWidgetCardItemData !== "object")
                        throw TypeError(".NAlice.NData.TScenarioData.CentaurWidgetCardItemData: object expected");
                    message.CentaurWidgetCardItemData = $root.NAlice.NData.TCentaurWidgetCardItemData.fromObject(object.CentaurWidgetCardItemData);
                }
                if (object.CentaurWidgetCardItem != null) {
                    if (typeof object.CentaurWidgetCardItem !== "object")
                        throw TypeError(".NAlice.NData.TScenarioData.CentaurWidgetCardItem: object expected");
                    message.CentaurWidgetCardItem = $root.NAlice.NData.TCentaurWidgetCardItem.fromObject(object.CentaurWidgetCardItem);
                }
                if (object.AfishaTeaserData != null) {
                    if (typeof object.AfishaTeaserData !== "object")
                        throw TypeError(".NAlice.NData.TScenarioData.AfishaTeaserData: object expected");
                    message.AfishaTeaserData = $root.NAlice.NData.TAfishaTeaserData.fromObject(object.AfishaTeaserData);
                }
                if (object.CentaurScenarioWidgetData != null) {
                    if (typeof object.CentaurScenarioWidgetData !== "object")
                        throw TypeError(".NAlice.NData.TScenarioData.CentaurScenarioWidgetData: object expected");
                    message.CentaurScenarioWidgetData = $root.NAlice.NData.TCentaurScenarioWidgetData.fromObject(object.CentaurScenarioWidgetData);
                }
                if (object.IncomingTelegramCallData != null) {
                    if (typeof object.IncomingTelegramCallData !== "object")
                        throw TypeError(".NAlice.NData.TScenarioData.IncomingTelegramCallData: object expected");
                    message.IncomingTelegramCallData = $root.NAlice.NData.TIncomingTelegramCallData.fromObject(object.IncomingTelegramCallData);
                }
                if (object.VideoSearchResultData != null) {
                    if (typeof object.VideoSearchResultData !== "object")
                        throw TypeError(".NAlice.NData.TScenarioData.VideoSearchResultData: object expected");
                    message.VideoSearchResultData = $root.NAlice.TTvSearchResultData.fromObject(object.VideoSearchResultData);
                }
                if (object.SearchRichCardData != null) {
                    if (typeof object.SearchRichCardData !== "object")
                        throw TypeError(".NAlice.NData.TScenarioData.SearchRichCardData: object expected");
                    message.SearchRichCardData = $root.NAlice.NData.TSearchRichCardData.fromObject(object.SearchRichCardData);
                }
                if (object.OutgoingTelegramCallData != null) {
                    if (typeof object.OutgoingTelegramCallData !== "object")
                        throw TypeError(".NAlice.NData.TScenarioData.OutgoingTelegramCallData: object expected");
                    message.OutgoingTelegramCallData = $root.NAlice.NData.TOutgoingTelegramCallData.fromObject(object.OutgoingTelegramCallData);
                }
                if (object.CurrentTelegramCallData != null) {
                    if (typeof object.CurrentTelegramCallData !== "object")
                        throw TypeError(".NAlice.NData.TScenarioData.CurrentTelegramCallData: object expected");
                    message.CurrentTelegramCallData = $root.NAlice.NData.TCurrentTelegramCallData.fromObject(object.CurrentTelegramCallData);
                }
                if (object.GreetingsCardData != null) {
                    if (typeof object.GreetingsCardData !== "object")
                        throw TypeError(".NAlice.NData.TScenarioData.GreetingsCardData: object expected");
                    message.GreetingsCardData = $root.NAlice.NData.TGreetingsCardData.fromObject(object.GreetingsCardData);
                }
                if (object.ShowRouteData != null) {
                    if (typeof object.ShowRouteData !== "object")
                        throw TypeError(".NAlice.NData.TScenarioData.ShowRouteData: object expected");
                    message.ShowRouteData = $root.NAlice.NData.TShowRouteData.fromObject(object.ShowRouteData);
                }
                if (object.DialogovoTeaserCardData != null) {
                    if (typeof object.DialogovoTeaserCardData !== "object")
                        throw TypeError(".NAlice.NData.TScenarioData.DialogovoTeaserCardData: object expected");
                    message.DialogovoTeaserCardData = $root.NAlice.NData.TDialogovoSkillTeaserData.fromObject(object.DialogovoTeaserCardData);
                }
                if (object.TrafficCardData != null) {
                    if (typeof object.TrafficCardData !== "object")
                        throw TypeError(".NAlice.NData.TScenarioData.TrafficCardData: object expected");
                    message.TrafficCardData = $root.NAlice.NData.TTrafficCardData.fromObject(object.TrafficCardData);
                }
                if (object.ProactivityTeaserData != null) {
                    if (typeof object.ProactivityTeaserData !== "object")
                        throw TypeError(".NAlice.NData.TScenarioData.ProactivityTeaserData: object expected");
                    message.ProactivityTeaserData = $root.NAlice.NData.TProactivityTeaserData.fromObject(object.ProactivityTeaserData);
                }
                if (object.GreetingsFooterCardData != null) {
                    if (typeof object.GreetingsFooterCardData !== "object")
                        throw TypeError(".NAlice.NData.TScenarioData.GreetingsFooterCardData: object expected");
                    message.GreetingsFooterCardData = $root.NAlice.NData.TGreetingsFooterCardData.fromObject(object.GreetingsFooterCardData);
                }
                if (object.TeaserSettingsWithContentData != null) {
                    if (typeof object.TeaserSettingsWithContentData !== "object")
                        throw TypeError(".NAlice.NData.TScenarioData.TeaserSettingsWithContentData: object expected");
                    message.TeaserSettingsWithContentData = $root.NAlice.NData.TTeaserSettingsWithContentData.fromObject(object.TeaserSettingsWithContentData);
                }
                if (object.TeasersPreviewData != null) {
                    if (typeof object.TeasersPreviewData !== "object")
                        throw TypeError(".NAlice.NData.TScenarioData.TeasersPreviewData: object expected");
                    message.TeasersPreviewData = $root.NAlice.NData.TTeasersPreviewData.fromObject(object.TeasersPreviewData);
                }
                return message;
            };

            /**
             * Creates a plain object from a TScenarioData message. Also converts values to other types if specified.
             * @function toObject
             * @memberof NAlice.NData.TScenarioData
             * @static
             * @param {NAlice.NData.TScenarioData} message TScenarioData
             * @param {$protobuf.IConversionOptions} [options] Conversion options
             * @returns {Object.<string,*>} Plain object
             */
            TScenarioData.toObject = function toObject(message, options) {
                if (!options)
                    options = {};
                var object = {};
                if (message.SearchObjectData != null && message.hasOwnProperty("SearchObjectData")) {
                    object.SearchObjectData = $root.NAlice.NData.TSearchObjectData.toObject(message.SearchObjectData, options);
                    if (options.oneofs)
                        object.Data = "SearchObjectData";
                }
                if (message.SearchFactData != null && message.hasOwnProperty("SearchFactData")) {
                    object.SearchFactData = $root.NAlice.NData.TSearchFactData.toObject(message.SearchFactData, options);
                    if (options.oneofs)
                        object.Data = "SearchFactData";
                }
                if (message.ExampleScenarioData != null && message.hasOwnProperty("ExampleScenarioData")) {
                    object.ExampleScenarioData = $root.NAlice.NData.TExampleScenarioData.toObject(message.ExampleScenarioData, options);
                    if (options.oneofs)
                        object.Data = "ExampleScenarioData";
                }
                if (message.NewsGalleryData != null && message.hasOwnProperty("NewsGalleryData")) {
                    object.NewsGalleryData = $root.NAlice.NData.TNewsGalleryData.toObject(message.NewsGalleryData, options);
                    if (options.oneofs)
                        object.Data = "NewsGalleryData";
                }
                if (message.NewsTeaserData != null && message.hasOwnProperty("NewsTeaserData")) {
                    object.NewsTeaserData = $root.NAlice.NData.TNewsTeaserData.toObject(message.NewsTeaserData, options);
                    if (options.oneofs)
                        object.Data = "NewsTeaserData";
                }
                if (message.WeatherDayHoursData != null && message.hasOwnProperty("WeatherDayHoursData")) {
                    object.WeatherDayHoursData = $root.NAlice.NData.TWeatherDayHoursData.toObject(message.WeatherDayHoursData, options);
                    if (options.oneofs)
                        object.Data = "WeatherDayHoursData";
                }
                if (message.WeatherDayPartData != null && message.hasOwnProperty("WeatherDayPartData")) {
                    object.WeatherDayPartData = $root.NAlice.NData.TWeatherDayPartData.toObject(message.WeatherDayPartData, options);
                    if (options.oneofs)
                        object.Data = "WeatherDayPartData";
                }
                if (message.WeatherDayData != null && message.hasOwnProperty("WeatherDayData")) {
                    object.WeatherDayData = $root.NAlice.NData.TWeatherDayData.toObject(message.WeatherDayData, options);
                    if (options.oneofs)
                        object.Data = "WeatherDayData";
                }
                if (message.WeatherDaysRangeData != null && message.hasOwnProperty("WeatherDaysRangeData")) {
                    object.WeatherDaysRangeData = $root.NAlice.NData.TWeatherDaysRangeData.toObject(message.WeatherDaysRangeData, options);
                    if (options.oneofs)
                        object.Data = "WeatherDaysRangeData";
                }
                if (message.CentaurMainScreenGalleryMusicCardData != null && message.hasOwnProperty("CentaurMainScreenGalleryMusicCardData")) {
                    object.CentaurMainScreenGalleryMusicCardData = $root.NAlice.NData.TCentaurMainScreenGalleryMusicCardData.toObject(message.CentaurMainScreenGalleryMusicCardData, options);
                    if (options.oneofs)
                        object.Data = "CentaurMainScreenGalleryMusicCardData";
                }
                if (message.CentaurMainScreenGalleryVideoCardData != null && message.hasOwnProperty("CentaurMainScreenGalleryVideoCardData")) {
                    object.CentaurMainScreenGalleryVideoCardData = $root.NAlice.NData.TCentaurMainScreenGalleryVideoCardData.toObject(message.CentaurMainScreenGalleryVideoCardData, options);
                    if (options.oneofs)
                        object.Data = "CentaurMainScreenGalleryVideoCardData";
                }
                if (message.WeatherTeaserData != null && message.hasOwnProperty("WeatherTeaserData")) {
                    object.WeatherTeaserData = $root.NAlice.NData.TWeatherTeaserData.toObject(message.WeatherTeaserData, options);
                    if (options.oneofs)
                        object.Data = "WeatherTeaserData";
                }
                if (message.MusicPlayerData != null && message.hasOwnProperty("MusicPlayerData")) {
                    object.MusicPlayerData = $root.NAlice.NData.TMusicPlayerData.toObject(message.MusicPlayerData, options);
                    if (options.oneofs)
                        object.Data = "MusicPlayerData";
                }
                if (message.CentaurMainScreenWebviewCardData != null && message.hasOwnProperty("CentaurMainScreenWebviewCardData")) {
                    object.CentaurMainScreenWebviewCardData = $root.NAlice.NData.TCentaurMainScreenWebviewCardData.toObject(message.CentaurMainScreenWebviewCardData, options);
                    if (options.oneofs)
                        object.Data = "CentaurMainScreenWebviewCardData";
                }
                if (message.MusicInfiniteFeedData != null && message.hasOwnProperty("MusicInfiniteFeedData")) {
                    object.MusicInfiniteFeedData = $root.NAlice.NData.NMusic.TMusicInfiniteFeedData.toObject(message.MusicInfiniteFeedData, options);
                    if (options.oneofs)
                        object.Data = "MusicInfiniteFeedData";
                }
                if (message.CentaurMainScreenWebviewTabData != null && message.hasOwnProperty("CentaurMainScreenWebviewTabData")) {
                    object.CentaurMainScreenWebviewTabData = $root.NAlice.NData.TCentaurMainScreenWebviewTabData.toObject(message.CentaurMainScreenWebviewTabData, options);
                    if (options.oneofs)
                        object.Data = "CentaurMainScreenWebviewTabData";
                }
                if (message.CentaurTeaserChromeDefaultLayerData != null && message.hasOwnProperty("CentaurTeaserChromeDefaultLayerData")) {
                    object.CentaurTeaserChromeDefaultLayerData = $root.NAlice.NData.TCentaurTeaserChromeDefaultLayerData.toObject(message.CentaurTeaserChromeDefaultLayerData, options);
                    if (options.oneofs)
                        object.Data = "CentaurTeaserChromeDefaultLayerData";
                }
                if (message.CentaurMainScreenDiscoveryTabData != null && message.hasOwnProperty("CentaurMainScreenDiscoveryTabData")) {
                    object.CentaurMainScreenDiscoveryTabData = $root.NAlice.NData.TCentaurMainScreenDiscoveryTabData.toObject(message.CentaurMainScreenDiscoveryTabData, options);
                    if (options.oneofs)
                        object.Data = "CentaurMainScreenDiscoveryTabData";
                }
                if (message.CentaurMainScreenMusicTabData != null && message.hasOwnProperty("CentaurMainScreenMusicTabData")) {
                    object.CentaurMainScreenMusicTabData = $root.NAlice.NData.TCentaurMainScreenMusicTabData.toObject(message.CentaurMainScreenMusicTabData, options);
                    if (options.oneofs)
                        object.Data = "CentaurMainScreenMusicTabData";
                }
                if (message.CentaurMainScreenServicesTabData != null && message.hasOwnProperty("CentaurMainScreenServicesTabData")) {
                    object.CentaurMainScreenServicesTabData = $root.NAlice.NData.TCentaurMainScreenServicesTabData.toObject(message.CentaurMainScreenServicesTabData, options);
                    if (options.oneofs)
                        object.Data = "CentaurMainScreenServicesTabData";
                }
                if (message.IoTUserData != null && message.hasOwnProperty("IoTUserData")) {
                    object.IoTUserData = $root.NAlice.TIoTUserInfo.toObject(message.IoTUserData, options);
                    if (options.oneofs)
                        object.Data = "IoTUserData";
                }
                if (message.CentaurMainScreenSmartHomeTabData != null && message.hasOwnProperty("CentaurMainScreenSmartHomeTabData")) {
                    object.CentaurMainScreenSmartHomeTabData = $root.NAlice.NData.TCentaurMainScreenSmartHomeTabData.toObject(message.CentaurMainScreenSmartHomeTabData, options);
                    if (options.oneofs)
                        object.Data = "CentaurMainScreenSmartHomeTabData";
                }
                if (message.CentaurUpperShutterData != null && message.hasOwnProperty("CentaurUpperShutterData")) {
                    object.CentaurUpperShutterData = $root.NAlice.NData.TCentaurUpperShutterData.toObject(message.CentaurUpperShutterData, options);
                    if (options.oneofs)
                        object.Data = "CentaurUpperShutterData";
                }
                if (message.CentaurWebviewData != null && message.hasOwnProperty("CentaurWebviewData")) {
                    object.CentaurWebviewData = $root.NAlice.NData.TCentaurWebviewData.toObject(message.CentaurWebviewData, options);
                    if (options.oneofs)
                        object.Data = "CentaurWebviewData";
                }
                if (message.CentaurMainScreenMyScreenData != null && message.hasOwnProperty("CentaurMainScreenMyScreenData")) {
                    object.CentaurMainScreenMyScreenData = $root.NAlice.NData.TCentaurMainScreenMyScreenData.toObject(message.CentaurMainScreenMyScreenData, options);
                    if (options.oneofs)
                        object.Data = "CentaurMainScreenMyScreenData";
                }
                if (message.NewsMainScreenData != null && message.hasOwnProperty("NewsMainScreenData")) {
                    object.NewsMainScreenData = $root.NAlice.NData.TNewsMainScreenData.toObject(message.NewsMainScreenData, options);
                    if (options.oneofs)
                        object.Data = "NewsMainScreenData";
                }
                if (message.WeatherMainScreenData != null && message.hasOwnProperty("WeatherMainScreenData")) {
                    object.WeatherMainScreenData = $root.NAlice.NData.TWeatherMainScreenData.toObject(message.WeatherMainScreenData, options);
                    if (options.oneofs)
                        object.Data = "WeatherMainScreenData";
                }
                if (message.DialogovoSkillCardData != null && message.hasOwnProperty("DialogovoSkillCardData")) {
                    object.DialogovoSkillCardData = $root.NAlice.NData.TDialogovoSkillCardData.toObject(message.DialogovoSkillCardData, options);
                    if (options.oneofs)
                        object.Data = "DialogovoSkillCardData";
                }
                if (message.CentaurWidgetGalleryData != null && message.hasOwnProperty("CentaurWidgetGalleryData")) {
                    object.CentaurWidgetGalleryData = $root.NAlice.NData.TCentaurWidgetGalleryData.toObject(message.CentaurWidgetGalleryData, options);
                    if (options.oneofs)
                        object.Data = "CentaurWidgetGalleryData";
                }
                if (message.ScreenSaverData != null && message.hasOwnProperty("ScreenSaverData")) {
                    object.ScreenSaverData = $root.NAlice.NData.TScreenSaverData.toObject(message.ScreenSaverData, options);
                    if (options.oneofs)
                        object.Data = "ScreenSaverData";
                }
                if (message.TrafficData != null && message.hasOwnProperty("TrafficData")) {
                    object.TrafficData = $root.NAlice.NData.TTrafficWidgetData.toObject(message.TrafficData, options);
                    if (options.oneofs)
                        object.Data = "TrafficData";
                }
                if (message.GalleryData != null && message.hasOwnProperty("GalleryData")) {
                    object.GalleryData = $root.NAlice.NData.TGalleryData.toObject(message.GalleryData, options);
                    if (options.oneofs)
                        object.Data = "GalleryData";
                }
                if (message.ConversationData != null && message.hasOwnProperty("ConversationData")) {
                    object.ConversationData = $root.NAlice.NData.TConversationData.toObject(message.ConversationData, options);
                    if (options.oneofs)
                        object.Data = "ConversationData";
                }
                if (message.VideoCallMainScreenData != null && message.hasOwnProperty("VideoCallMainScreenData")) {
                    object.VideoCallMainScreenData = $root.NAlice.NData.TVideoCallMainScreenData.toObject(message.VideoCallMainScreenData, options);
                    if (options.oneofs)
                        object.Data = "VideoCallMainScreenData";
                }
                if (message.VideoCallContactChoosingData != null && message.hasOwnProperty("VideoCallContactChoosingData")) {
                    object.VideoCallContactChoosingData = $root.NAlice.NData.TVideoCallContactChoosingData.toObject(message.VideoCallContactChoosingData, options);
                    if (options.oneofs)
                        object.Data = "VideoCallContactChoosingData";
                }
                if (message.CentaurWidgetCardItemData != null && message.hasOwnProperty("CentaurWidgetCardItemData")) {
                    object.CentaurWidgetCardItemData = $root.NAlice.NData.TCentaurWidgetCardItemData.toObject(message.CentaurWidgetCardItemData, options);
                    if (options.oneofs)
                        object.Data = "CentaurWidgetCardItemData";
                }
                if (message.CentaurWidgetCardItem != null && message.hasOwnProperty("CentaurWidgetCardItem")) {
                    object.CentaurWidgetCardItem = $root.NAlice.NData.TCentaurWidgetCardItem.toObject(message.CentaurWidgetCardItem, options);
                    if (options.oneofs)
                        object.Data = "CentaurWidgetCardItem";
                }
                if (message.AfishaTeaserData != null && message.hasOwnProperty("AfishaTeaserData")) {
                    object.AfishaTeaserData = $root.NAlice.NData.TAfishaTeaserData.toObject(message.AfishaTeaserData, options);
                    if (options.oneofs)
                        object.Data = "AfishaTeaserData";
                }
                if (message.CentaurScenarioWidgetData != null && message.hasOwnProperty("CentaurScenarioWidgetData")) {
                    object.CentaurScenarioWidgetData = $root.NAlice.NData.TCentaurScenarioWidgetData.toObject(message.CentaurScenarioWidgetData, options);
                    if (options.oneofs)
                        object.Data = "CentaurScenarioWidgetData";
                }
                if (message.IncomingTelegramCallData != null && message.hasOwnProperty("IncomingTelegramCallData")) {
                    object.IncomingTelegramCallData = $root.NAlice.NData.TIncomingTelegramCallData.toObject(message.IncomingTelegramCallData, options);
                    if (options.oneofs)
                        object.Data = "IncomingTelegramCallData";
                }
                if (message.VideoSearchResultData != null && message.hasOwnProperty("VideoSearchResultData")) {
                    object.VideoSearchResultData = $root.NAlice.TTvSearchResultData.toObject(message.VideoSearchResultData, options);
                    if (options.oneofs)
                        object.Data = "VideoSearchResultData";
                }
                if (message.SearchRichCardData != null && message.hasOwnProperty("SearchRichCardData")) {
                    object.SearchRichCardData = $root.NAlice.NData.TSearchRichCardData.toObject(message.SearchRichCardData, options);
                    if (options.oneofs)
                        object.Data = "SearchRichCardData";
                }
                if (message.OutgoingTelegramCallData != null && message.hasOwnProperty("OutgoingTelegramCallData")) {
                    object.OutgoingTelegramCallData = $root.NAlice.NData.TOutgoingTelegramCallData.toObject(message.OutgoingTelegramCallData, options);
                    if (options.oneofs)
                        object.Data = "OutgoingTelegramCallData";
                }
                if (message.CurrentTelegramCallData != null && message.hasOwnProperty("CurrentTelegramCallData")) {
                    object.CurrentTelegramCallData = $root.NAlice.NData.TCurrentTelegramCallData.toObject(message.CurrentTelegramCallData, options);
                    if (options.oneofs)
                        object.Data = "CurrentTelegramCallData";
                }
                if (message.GreetingsCardData != null && message.hasOwnProperty("GreetingsCardData")) {
                    object.GreetingsCardData = $root.NAlice.NData.TGreetingsCardData.toObject(message.GreetingsCardData, options);
                    if (options.oneofs)
                        object.Data = "GreetingsCardData";
                }
                if (message.ShowRouteData != null && message.hasOwnProperty("ShowRouteData")) {
                    object.ShowRouteData = $root.NAlice.NData.TShowRouteData.toObject(message.ShowRouteData, options);
                    if (options.oneofs)
                        object.Data = "ShowRouteData";
                }
                if (message.DialogovoTeaserCardData != null && message.hasOwnProperty("DialogovoTeaserCardData")) {
                    object.DialogovoTeaserCardData = $root.NAlice.NData.TDialogovoSkillTeaserData.toObject(message.DialogovoTeaserCardData, options);
                    if (options.oneofs)
                        object.Data = "DialogovoTeaserCardData";
                }
                if (message.TrafficCardData != null && message.hasOwnProperty("TrafficCardData")) {
                    object.TrafficCardData = $root.NAlice.NData.TTrafficCardData.toObject(message.TrafficCardData, options);
                    if (options.oneofs)
                        object.Data = "TrafficCardData";
                }
                if (message.ProactivityTeaserData != null && message.hasOwnProperty("ProactivityTeaserData")) {
                    object.ProactivityTeaserData = $root.NAlice.NData.TProactivityTeaserData.toObject(message.ProactivityTeaserData, options);
                    if (options.oneofs)
                        object.Data = "ProactivityTeaserData";
                }
                if (message.GreetingsFooterCardData != null && message.hasOwnProperty("GreetingsFooterCardData")) {
                    object.GreetingsFooterCardData = $root.NAlice.NData.TGreetingsFooterCardData.toObject(message.GreetingsFooterCardData, options);
                    if (options.oneofs)
                        object.Data = "GreetingsFooterCardData";
                }
                if (message.TeaserSettingsWithContentData != null && message.hasOwnProperty("TeaserSettingsWithContentData")) {
                    object.TeaserSettingsWithContentData = $root.NAlice.NData.TTeaserSettingsWithContentData.toObject(message.TeaserSettingsWithContentData, options);
                    if (options.oneofs)
                        object.Data = "TeaserSettingsWithContentData";
                }
                if (message.TeasersPreviewData != null && message.hasOwnProperty("TeasersPreviewData")) {
                    object.TeasersPreviewData = $root.NAlice.NData.TTeasersPreviewData.toObject(message.TeasersPreviewData, options);
                    if (options.oneofs)
                        object.Data = "TeasersPreviewData";
                }
                return object;
            };

            /**
             * Converts this TScenarioData to JSON.
             * @function toJSON
             * @memberof NAlice.NData.TScenarioData
             * @instance
             * @returns {Object.<string,*>} JSON object
             */
            TScenarioData.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            return TScenarioData;
        })();

        NData.TAfishaTeaserData = (function() {

            /**
             * Properties of a TAfishaTeaserData.
             * @memberof NAlice.NData
             * @interface ITAfishaTeaserData
             * @property {string|null} [Title] TAfishaTeaserData Title
             * @property {string|null} [ImageUrl] TAfishaTeaserData ImageUrl
             * @property {string|null} [Date] TAfishaTeaserData Date
             * @property {string|null} [Place] TAfishaTeaserData Place
             * @property {string|null} [ContentRating] TAfishaTeaserData ContentRating
             */

            /**
             * Constructs a new TAfishaTeaserData.
             * @memberof NAlice.NData
             * @classdesc Represents a TAfishaTeaserData.
             * @implements ITAfishaTeaserData
             * @constructor
             * @param {NAlice.NData.ITAfishaTeaserData=} [properties] Properties to set
             */
            function TAfishaTeaserData(properties) {
                if (properties)
                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                        if (properties[keys[i]] != null)
                            this[keys[i]] = properties[keys[i]];
            }

            /**
             * TAfishaTeaserData Title.
             * @member {string} Title
             * @memberof NAlice.NData.TAfishaTeaserData
             * @instance
             */
            TAfishaTeaserData.prototype.Title = "";

            /**
             * TAfishaTeaserData ImageUrl.
             * @member {string} ImageUrl
             * @memberof NAlice.NData.TAfishaTeaserData
             * @instance
             */
            TAfishaTeaserData.prototype.ImageUrl = "";

            /**
             * TAfishaTeaserData Date.
             * @member {string} Date
             * @memberof NAlice.NData.TAfishaTeaserData
             * @instance
             */
            TAfishaTeaserData.prototype.Date = "";

            /**
             * TAfishaTeaserData Place.
             * @member {string} Place
             * @memberof NAlice.NData.TAfishaTeaserData
             * @instance
             */
            TAfishaTeaserData.prototype.Place = "";

            /**
             * TAfishaTeaserData ContentRating.
             * @member {string} ContentRating
             * @memberof NAlice.NData.TAfishaTeaserData
             * @instance
             */
            TAfishaTeaserData.prototype.ContentRating = "";

            /**
             * Creates a new TAfishaTeaserData instance using the specified properties.
             * @function create
             * @memberof NAlice.NData.TAfishaTeaserData
             * @static
             * @param {NAlice.NData.ITAfishaTeaserData=} [properties] Properties to set
             * @returns {NAlice.NData.TAfishaTeaserData} TAfishaTeaserData instance
             */
            TAfishaTeaserData.create = function create(properties) {
                return new TAfishaTeaserData(properties);
            };

            /**
             * Encodes the specified TAfishaTeaserData message. Does not implicitly {@link NAlice.NData.TAfishaTeaserData.verify|verify} messages.
             * @function encode
             * @memberof NAlice.NData.TAfishaTeaserData
             * @static
             * @param {NAlice.NData.ITAfishaTeaserData} message TAfishaTeaserData message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            TAfishaTeaserData.encode = function encode(message, writer) {
                if (!writer)
                    writer = $Writer.create();
                if (message.Title != null && Object.hasOwnProperty.call(message, "Title"))
                    writer.uint32(/* id 1, wireType 2 =*/10).string(message.Title);
                if (message.ImageUrl != null && Object.hasOwnProperty.call(message, "ImageUrl"))
                    writer.uint32(/* id 2, wireType 2 =*/18).string(message.ImageUrl);
                if (message.Date != null && Object.hasOwnProperty.call(message, "Date"))
                    writer.uint32(/* id 3, wireType 2 =*/26).string(message.Date);
                if (message.Place != null && Object.hasOwnProperty.call(message, "Place"))
                    writer.uint32(/* id 4, wireType 2 =*/34).string(message.Place);
                if (message.ContentRating != null && Object.hasOwnProperty.call(message, "ContentRating"))
                    writer.uint32(/* id 5, wireType 2 =*/42).string(message.ContentRating);
                return writer;
            };

            /**
             * Encodes the specified TAfishaTeaserData message, length delimited. Does not implicitly {@link NAlice.NData.TAfishaTeaserData.verify|verify} messages.
             * @function encodeDelimited
             * @memberof NAlice.NData.TAfishaTeaserData
             * @static
             * @param {NAlice.NData.ITAfishaTeaserData} message TAfishaTeaserData message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            TAfishaTeaserData.encodeDelimited = function encodeDelimited(message, writer) {
                return this.encode(message, writer).ldelim();
            };

            /**
             * Decodes a TAfishaTeaserData message from the specified reader or buffer.
             * @function decode
             * @memberof NAlice.NData.TAfishaTeaserData
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @param {number} [length] Message length if known beforehand
             * @returns {NAlice.NData.TAfishaTeaserData} TAfishaTeaserData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            TAfishaTeaserData.decode = function decode(reader, length) {
                if (!(reader instanceof $Reader))
                    reader = $Reader.create(reader);
                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.NAlice.NData.TAfishaTeaserData();
                while (reader.pos < end) {
                    var tag = reader.uint32();
                    switch (tag >>> 3) {
                    case 1:
                        message.Title = reader.string();
                        break;
                    case 2:
                        message.ImageUrl = reader.string();
                        break;
                    case 3:
                        message.Date = reader.string();
                        break;
                    case 4:
                        message.Place = reader.string();
                        break;
                    case 5:
                        message.ContentRating = reader.string();
                        break;
                    default:
                        reader.skipType(tag & 7);
                        break;
                    }
                }
                return message;
            };

            /**
             * Decodes a TAfishaTeaserData message from the specified reader or buffer, length delimited.
             * @function decodeDelimited
             * @memberof NAlice.NData.TAfishaTeaserData
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @returns {NAlice.NData.TAfishaTeaserData} TAfishaTeaserData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            TAfishaTeaserData.decodeDelimited = function decodeDelimited(reader) {
                if (!(reader instanceof $Reader))
                    reader = new $Reader(reader);
                return this.decode(reader, reader.uint32());
            };

            /**
             * Verifies a TAfishaTeaserData message.
             * @function verify
             * @memberof NAlice.NData.TAfishaTeaserData
             * @static
             * @param {Object.<string,*>} message Plain object to verify
             * @returns {string|null} `null` if valid, otherwise the reason why it is not
             */
            TAfishaTeaserData.verify = function verify(message) {
                if (typeof message !== "object" || message === null)
                    return "object expected";
                if (message.Title != null && message.hasOwnProperty("Title"))
                    if (!$util.isString(message.Title))
                        return "Title: string expected";
                if (message.ImageUrl != null && message.hasOwnProperty("ImageUrl"))
                    if (!$util.isString(message.ImageUrl))
                        return "ImageUrl: string expected";
                if (message.Date != null && message.hasOwnProperty("Date"))
                    if (!$util.isString(message.Date))
                        return "Date: string expected";
                if (message.Place != null && message.hasOwnProperty("Place"))
                    if (!$util.isString(message.Place))
                        return "Place: string expected";
                if (message.ContentRating != null && message.hasOwnProperty("ContentRating"))
                    if (!$util.isString(message.ContentRating))
                        return "ContentRating: string expected";
                return null;
            };

            /**
             * Creates a TAfishaTeaserData message from a plain object. Also converts values to their respective internal types.
             * @function fromObject
             * @memberof NAlice.NData.TAfishaTeaserData
             * @static
             * @param {Object.<string,*>} object Plain object
             * @returns {NAlice.NData.TAfishaTeaserData} TAfishaTeaserData
             */
            TAfishaTeaserData.fromObject = function fromObject(object) {
                if (object instanceof $root.NAlice.NData.TAfishaTeaserData)
                    return object;
                var message = new $root.NAlice.NData.TAfishaTeaserData();
                if (object.Title != null)
                    message.Title = String(object.Title);
                if (object.ImageUrl != null)
                    message.ImageUrl = String(object.ImageUrl);
                if (object.Date != null)
                    message.Date = String(object.Date);
                if (object.Place != null)
                    message.Place = String(object.Place);
                if (object.ContentRating != null)
                    message.ContentRating = String(object.ContentRating);
                return message;
            };

            /**
             * Creates a plain object from a TAfishaTeaserData message. Also converts values to other types if specified.
             * @function toObject
             * @memberof NAlice.NData.TAfishaTeaserData
             * @static
             * @param {NAlice.NData.TAfishaTeaserData} message TAfishaTeaserData
             * @param {$protobuf.IConversionOptions} [options] Conversion options
             * @returns {Object.<string,*>} Plain object
             */
            TAfishaTeaserData.toObject = function toObject(message, options) {
                if (!options)
                    options = {};
                var object = {};
                if (options.defaults) {
                    object.Title = "";
                    object.ImageUrl = "";
                    object.Date = "";
                    object.Place = "";
                    object.ContentRating = "";
                }
                if (message.Title != null && message.hasOwnProperty("Title"))
                    object.Title = message.Title;
                if (message.ImageUrl != null && message.hasOwnProperty("ImageUrl"))
                    object.ImageUrl = message.ImageUrl;
                if (message.Date != null && message.hasOwnProperty("Date"))
                    object.Date = message.Date;
                if (message.Place != null && message.hasOwnProperty("Place"))
                    object.Place = message.Place;
                if (message.ContentRating != null && message.hasOwnProperty("ContentRating"))
                    object.ContentRating = message.ContentRating;
                return object;
            };

            /**
             * Converts this TAfishaTeaserData to JSON.
             * @function toJSON
             * @memberof NAlice.NData.TAfishaTeaserData
             * @instance
             * @returns {Object.<string,*>} JSON object
             */
            TAfishaTeaserData.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            return TAfishaTeaserData;
        })();

        NData.TCentaurMainScreenMusicTabData = (function() {

            /**
             * Properties of a TCentaurMainScreenMusicTabData.
             * @memberof NAlice.NData
             * @interface ITCentaurMainScreenMusicTabData
             * @property {string|null} [Id] TCentaurMainScreenMusicTabData Id
             * @property {Array.<NAlice.NData.ITHorizontalMusicBlockData>|null} [HorizontalMusicBlockData] TCentaurMainScreenMusicTabData HorizontalMusicBlockData
             */

            /**
             * Constructs a new TCentaurMainScreenMusicTabData.
             * @memberof NAlice.NData
             * @classdesc Represents a TCentaurMainScreenMusicTabData.
             * @implements ITCentaurMainScreenMusicTabData
             * @constructor
             * @param {NAlice.NData.ITCentaurMainScreenMusicTabData=} [properties] Properties to set
             */
            function TCentaurMainScreenMusicTabData(properties) {
                this.HorizontalMusicBlockData = [];
                if (properties)
                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                        if (properties[keys[i]] != null)
                            this[keys[i]] = properties[keys[i]];
            }

            /**
             * TCentaurMainScreenMusicTabData Id.
             * @member {string} Id
             * @memberof NAlice.NData.TCentaurMainScreenMusicTabData
             * @instance
             */
            TCentaurMainScreenMusicTabData.prototype.Id = "";

            /**
             * TCentaurMainScreenMusicTabData HorizontalMusicBlockData.
             * @member {Array.<NAlice.NData.ITHorizontalMusicBlockData>} HorizontalMusicBlockData
             * @memberof NAlice.NData.TCentaurMainScreenMusicTabData
             * @instance
             */
            TCentaurMainScreenMusicTabData.prototype.HorizontalMusicBlockData = $util.emptyArray;

            /**
             * Creates a new TCentaurMainScreenMusicTabData instance using the specified properties.
             * @function create
             * @memberof NAlice.NData.TCentaurMainScreenMusicTabData
             * @static
             * @param {NAlice.NData.ITCentaurMainScreenMusicTabData=} [properties] Properties to set
             * @returns {NAlice.NData.TCentaurMainScreenMusicTabData} TCentaurMainScreenMusicTabData instance
             */
            TCentaurMainScreenMusicTabData.create = function create(properties) {
                return new TCentaurMainScreenMusicTabData(properties);
            };

            /**
             * Encodes the specified TCentaurMainScreenMusicTabData message. Does not implicitly {@link NAlice.NData.TCentaurMainScreenMusicTabData.verify|verify} messages.
             * @function encode
             * @memberof NAlice.NData.TCentaurMainScreenMusicTabData
             * @static
             * @param {NAlice.NData.ITCentaurMainScreenMusicTabData} message TCentaurMainScreenMusicTabData message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            TCentaurMainScreenMusicTabData.encode = function encode(message, writer) {
                if (!writer)
                    writer = $Writer.create();
                if (message.Id != null && Object.hasOwnProperty.call(message, "Id"))
                    writer.uint32(/* id 1, wireType 2 =*/10).string(message.Id);
                if (message.HorizontalMusicBlockData != null && message.HorizontalMusicBlockData.length)
                    for (var i = 0; i < message.HorizontalMusicBlockData.length; ++i)
                        $root.NAlice.NData.THorizontalMusicBlockData.encode(message.HorizontalMusicBlockData[i], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                return writer;
            };

            /**
             * Encodes the specified TCentaurMainScreenMusicTabData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurMainScreenMusicTabData.verify|verify} messages.
             * @function encodeDelimited
             * @memberof NAlice.NData.TCentaurMainScreenMusicTabData
             * @static
             * @param {NAlice.NData.ITCentaurMainScreenMusicTabData} message TCentaurMainScreenMusicTabData message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            TCentaurMainScreenMusicTabData.encodeDelimited = function encodeDelimited(message, writer) {
                return this.encode(message, writer).ldelim();
            };

            /**
             * Decodes a TCentaurMainScreenMusicTabData message from the specified reader or buffer.
             * @function decode
             * @memberof NAlice.NData.TCentaurMainScreenMusicTabData
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @param {number} [length] Message length if known beforehand
             * @returns {NAlice.NData.TCentaurMainScreenMusicTabData} TCentaurMainScreenMusicTabData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            TCentaurMainScreenMusicTabData.decode = function decode(reader, length) {
                if (!(reader instanceof $Reader))
                    reader = $Reader.create(reader);
                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.NAlice.NData.TCentaurMainScreenMusicTabData();
                while (reader.pos < end) {
                    var tag = reader.uint32();
                    switch (tag >>> 3) {
                    case 1:
                        message.Id = reader.string();
                        break;
                    case 2:
                        if (!(message.HorizontalMusicBlockData && message.HorizontalMusicBlockData.length))
                            message.HorizontalMusicBlockData = [];
                        message.HorizontalMusicBlockData.push($root.NAlice.NData.THorizontalMusicBlockData.decode(reader, reader.uint32()));
                        break;
                    default:
                        reader.skipType(tag & 7);
                        break;
                    }
                }
                return message;
            };

            /**
             * Decodes a TCentaurMainScreenMusicTabData message from the specified reader or buffer, length delimited.
             * @function decodeDelimited
             * @memberof NAlice.NData.TCentaurMainScreenMusicTabData
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @returns {NAlice.NData.TCentaurMainScreenMusicTabData} TCentaurMainScreenMusicTabData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            TCentaurMainScreenMusicTabData.decodeDelimited = function decodeDelimited(reader) {
                if (!(reader instanceof $Reader))
                    reader = new $Reader(reader);
                return this.decode(reader, reader.uint32());
            };

            /**
             * Verifies a TCentaurMainScreenMusicTabData message.
             * @function verify
             * @memberof NAlice.NData.TCentaurMainScreenMusicTabData
             * @static
             * @param {Object.<string,*>} message Plain object to verify
             * @returns {string|null} `null` if valid, otherwise the reason why it is not
             */
            TCentaurMainScreenMusicTabData.verify = function verify(message) {
                if (typeof message !== "object" || message === null)
                    return "object expected";
                if (message.Id != null && message.hasOwnProperty("Id"))
                    if (!$util.isString(message.Id))
                        return "Id: string expected";
                if (message.HorizontalMusicBlockData != null && message.hasOwnProperty("HorizontalMusicBlockData")) {
                    if (!Array.isArray(message.HorizontalMusicBlockData))
                        return "HorizontalMusicBlockData: array expected";
                    for (var i = 0; i < message.HorizontalMusicBlockData.length; ++i) {
                        var error = $root.NAlice.NData.THorizontalMusicBlockData.verify(message.HorizontalMusicBlockData[i]);
                        if (error)
                            return "HorizontalMusicBlockData." + error;
                    }
                }
                return null;
            };

            /**
             * Creates a TCentaurMainScreenMusicTabData message from a plain object. Also converts values to their respective internal types.
             * @function fromObject
             * @memberof NAlice.NData.TCentaurMainScreenMusicTabData
             * @static
             * @param {Object.<string,*>} object Plain object
             * @returns {NAlice.NData.TCentaurMainScreenMusicTabData} TCentaurMainScreenMusicTabData
             */
            TCentaurMainScreenMusicTabData.fromObject = function fromObject(object) {
                if (object instanceof $root.NAlice.NData.TCentaurMainScreenMusicTabData)
                    return object;
                var message = new $root.NAlice.NData.TCentaurMainScreenMusicTabData();
                if (object.Id != null)
                    message.Id = String(object.Id);
                if (object.HorizontalMusicBlockData) {
                    if (!Array.isArray(object.HorizontalMusicBlockData))
                        throw TypeError(".NAlice.NData.TCentaurMainScreenMusicTabData.HorizontalMusicBlockData: array expected");
                    message.HorizontalMusicBlockData = [];
                    for (var i = 0; i < object.HorizontalMusicBlockData.length; ++i) {
                        if (typeof object.HorizontalMusicBlockData[i] !== "object")
                            throw TypeError(".NAlice.NData.TCentaurMainScreenMusicTabData.HorizontalMusicBlockData: object expected");
                        message.HorizontalMusicBlockData[i] = $root.NAlice.NData.THorizontalMusicBlockData.fromObject(object.HorizontalMusicBlockData[i]);
                    }
                }
                return message;
            };

            /**
             * Creates a plain object from a TCentaurMainScreenMusicTabData message. Also converts values to other types if specified.
             * @function toObject
             * @memberof NAlice.NData.TCentaurMainScreenMusicTabData
             * @static
             * @param {NAlice.NData.TCentaurMainScreenMusicTabData} message TCentaurMainScreenMusicTabData
             * @param {$protobuf.IConversionOptions} [options] Conversion options
             * @returns {Object.<string,*>} Plain object
             */
            TCentaurMainScreenMusicTabData.toObject = function toObject(message, options) {
                if (!options)
                    options = {};
                var object = {};
                if (options.arrays || options.defaults)
                    object.HorizontalMusicBlockData = [];
                if (options.defaults)
                    object.Id = "";
                if (message.Id != null && message.hasOwnProperty("Id"))
                    object.Id = message.Id;
                if (message.HorizontalMusicBlockData && message.HorizontalMusicBlockData.length) {
                    object.HorizontalMusicBlockData = [];
                    for (var j = 0; j < message.HorizontalMusicBlockData.length; ++j)
                        object.HorizontalMusicBlockData[j] = $root.NAlice.NData.THorizontalMusicBlockData.toObject(message.HorizontalMusicBlockData[j], options);
                }
                return object;
            };

            /**
             * Converts this TCentaurMainScreenMusicTabData to JSON.
             * @function toJSON
             * @memberof NAlice.NData.TCentaurMainScreenMusicTabData
             * @instance
             * @returns {Object.<string,*>} JSON object
             */
            TCentaurMainScreenMusicTabData.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            return TCentaurMainScreenMusicTabData;
        })();

        NData.THorizontalMusicBlockData = (function() {

            /**
             * Properties of a THorizontalMusicBlockData.
             * @memberof NAlice.NData
             * @interface ITHorizontalMusicBlockData
             * @property {string|null} [Type] THorizontalMusicBlockData Type
             * @property {string|null} [Title] THorizontalMusicBlockData Title
             * @property {Array.<NAlice.NData.ITCentaurMainScreenGalleryMusicCardData>|null} [CentaurMainScreenGalleryMusicCardData] THorizontalMusicBlockData CentaurMainScreenGalleryMusicCardData
             */

            /**
             * Constructs a new THorizontalMusicBlockData.
             * @memberof NAlice.NData
             * @classdesc Represents a THorizontalMusicBlockData.
             * @implements ITHorizontalMusicBlockData
             * @constructor
             * @param {NAlice.NData.ITHorizontalMusicBlockData=} [properties] Properties to set
             */
            function THorizontalMusicBlockData(properties) {
                this.CentaurMainScreenGalleryMusicCardData = [];
                if (properties)
                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                        if (properties[keys[i]] != null)
                            this[keys[i]] = properties[keys[i]];
            }

            /**
             * THorizontalMusicBlockData Type.
             * @member {string} Type
             * @memberof NAlice.NData.THorizontalMusicBlockData
             * @instance
             */
            THorizontalMusicBlockData.prototype.Type = "";

            /**
             * THorizontalMusicBlockData Title.
             * @member {string} Title
             * @memberof NAlice.NData.THorizontalMusicBlockData
             * @instance
             */
            THorizontalMusicBlockData.prototype.Title = "";

            /**
             * THorizontalMusicBlockData CentaurMainScreenGalleryMusicCardData.
             * @member {Array.<NAlice.NData.ITCentaurMainScreenGalleryMusicCardData>} CentaurMainScreenGalleryMusicCardData
             * @memberof NAlice.NData.THorizontalMusicBlockData
             * @instance
             */
            THorizontalMusicBlockData.prototype.CentaurMainScreenGalleryMusicCardData = $util.emptyArray;

            /**
             * Creates a new THorizontalMusicBlockData instance using the specified properties.
             * @function create
             * @memberof NAlice.NData.THorizontalMusicBlockData
             * @static
             * @param {NAlice.NData.ITHorizontalMusicBlockData=} [properties] Properties to set
             * @returns {NAlice.NData.THorizontalMusicBlockData} THorizontalMusicBlockData instance
             */
            THorizontalMusicBlockData.create = function create(properties) {
                return new THorizontalMusicBlockData(properties);
            };

            /**
             * Encodes the specified THorizontalMusicBlockData message. Does not implicitly {@link NAlice.NData.THorizontalMusicBlockData.verify|verify} messages.
             * @function encode
             * @memberof NAlice.NData.THorizontalMusicBlockData
             * @static
             * @param {NAlice.NData.ITHorizontalMusicBlockData} message THorizontalMusicBlockData message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            THorizontalMusicBlockData.encode = function encode(message, writer) {
                if (!writer)
                    writer = $Writer.create();
                if (message.Type != null && Object.hasOwnProperty.call(message, "Type"))
                    writer.uint32(/* id 1, wireType 2 =*/10).string(message.Type);
                if (message.Title != null && Object.hasOwnProperty.call(message, "Title"))
                    writer.uint32(/* id 2, wireType 2 =*/18).string(message.Title);
                if (message.CentaurMainScreenGalleryMusicCardData != null && message.CentaurMainScreenGalleryMusicCardData.length)
                    for (var i = 0; i < message.CentaurMainScreenGalleryMusicCardData.length; ++i)
                        $root.NAlice.NData.TCentaurMainScreenGalleryMusicCardData.encode(message.CentaurMainScreenGalleryMusicCardData[i], writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                return writer;
            };

            /**
             * Encodes the specified THorizontalMusicBlockData message, length delimited. Does not implicitly {@link NAlice.NData.THorizontalMusicBlockData.verify|verify} messages.
             * @function encodeDelimited
             * @memberof NAlice.NData.THorizontalMusicBlockData
             * @static
             * @param {NAlice.NData.ITHorizontalMusicBlockData} message THorizontalMusicBlockData message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            THorizontalMusicBlockData.encodeDelimited = function encodeDelimited(message, writer) {
                return this.encode(message, writer).ldelim();
            };

            /**
             * Decodes a THorizontalMusicBlockData message from the specified reader or buffer.
             * @function decode
             * @memberof NAlice.NData.THorizontalMusicBlockData
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @param {number} [length] Message length if known beforehand
             * @returns {NAlice.NData.THorizontalMusicBlockData} THorizontalMusicBlockData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            THorizontalMusicBlockData.decode = function decode(reader, length) {
                if (!(reader instanceof $Reader))
                    reader = $Reader.create(reader);
                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.NAlice.NData.THorizontalMusicBlockData();
                while (reader.pos < end) {
                    var tag = reader.uint32();
                    switch (tag >>> 3) {
                    case 1:
                        message.Type = reader.string();
                        break;
                    case 2:
                        message.Title = reader.string();
                        break;
                    case 3:
                        if (!(message.CentaurMainScreenGalleryMusicCardData && message.CentaurMainScreenGalleryMusicCardData.length))
                            message.CentaurMainScreenGalleryMusicCardData = [];
                        message.CentaurMainScreenGalleryMusicCardData.push($root.NAlice.NData.TCentaurMainScreenGalleryMusicCardData.decode(reader, reader.uint32()));
                        break;
                    default:
                        reader.skipType(tag & 7);
                        break;
                    }
                }
                return message;
            };

            /**
             * Decodes a THorizontalMusicBlockData message from the specified reader or buffer, length delimited.
             * @function decodeDelimited
             * @memberof NAlice.NData.THorizontalMusicBlockData
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @returns {NAlice.NData.THorizontalMusicBlockData} THorizontalMusicBlockData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            THorizontalMusicBlockData.decodeDelimited = function decodeDelimited(reader) {
                if (!(reader instanceof $Reader))
                    reader = new $Reader(reader);
                return this.decode(reader, reader.uint32());
            };

            /**
             * Verifies a THorizontalMusicBlockData message.
             * @function verify
             * @memberof NAlice.NData.THorizontalMusicBlockData
             * @static
             * @param {Object.<string,*>} message Plain object to verify
             * @returns {string|null} `null` if valid, otherwise the reason why it is not
             */
            THorizontalMusicBlockData.verify = function verify(message) {
                if (typeof message !== "object" || message === null)
                    return "object expected";
                if (message.Type != null && message.hasOwnProperty("Type"))
                    if (!$util.isString(message.Type))
                        return "Type: string expected";
                if (message.Title != null && message.hasOwnProperty("Title"))
                    if (!$util.isString(message.Title))
                        return "Title: string expected";
                if (message.CentaurMainScreenGalleryMusicCardData != null && message.hasOwnProperty("CentaurMainScreenGalleryMusicCardData")) {
                    if (!Array.isArray(message.CentaurMainScreenGalleryMusicCardData))
                        return "CentaurMainScreenGalleryMusicCardData: array expected";
                    for (var i = 0; i < message.CentaurMainScreenGalleryMusicCardData.length; ++i) {
                        var error = $root.NAlice.NData.TCentaurMainScreenGalleryMusicCardData.verify(message.CentaurMainScreenGalleryMusicCardData[i]);
                        if (error)
                            return "CentaurMainScreenGalleryMusicCardData." + error;
                    }
                }
                return null;
            };

            /**
             * Creates a THorizontalMusicBlockData message from a plain object. Also converts values to their respective internal types.
             * @function fromObject
             * @memberof NAlice.NData.THorizontalMusicBlockData
             * @static
             * @param {Object.<string,*>} object Plain object
             * @returns {NAlice.NData.THorizontalMusicBlockData} THorizontalMusicBlockData
             */
            THorizontalMusicBlockData.fromObject = function fromObject(object) {
                if (object instanceof $root.NAlice.NData.THorizontalMusicBlockData)
                    return object;
                var message = new $root.NAlice.NData.THorizontalMusicBlockData();
                if (object.Type != null)
                    message.Type = String(object.Type);
                if (object.Title != null)
                    message.Title = String(object.Title);
                if (object.CentaurMainScreenGalleryMusicCardData) {
                    if (!Array.isArray(object.CentaurMainScreenGalleryMusicCardData))
                        throw TypeError(".NAlice.NData.THorizontalMusicBlockData.CentaurMainScreenGalleryMusicCardData: array expected");
                    message.CentaurMainScreenGalleryMusicCardData = [];
                    for (var i = 0; i < object.CentaurMainScreenGalleryMusicCardData.length; ++i) {
                        if (typeof object.CentaurMainScreenGalleryMusicCardData[i] !== "object")
                            throw TypeError(".NAlice.NData.THorizontalMusicBlockData.CentaurMainScreenGalleryMusicCardData: object expected");
                        message.CentaurMainScreenGalleryMusicCardData[i] = $root.NAlice.NData.TCentaurMainScreenGalleryMusicCardData.fromObject(object.CentaurMainScreenGalleryMusicCardData[i]);
                    }
                }
                return message;
            };

            /**
             * Creates a plain object from a THorizontalMusicBlockData message. Also converts values to other types if specified.
             * @function toObject
             * @memberof NAlice.NData.THorizontalMusicBlockData
             * @static
             * @param {NAlice.NData.THorizontalMusicBlockData} message THorizontalMusicBlockData
             * @param {$protobuf.IConversionOptions} [options] Conversion options
             * @returns {Object.<string,*>} Plain object
             */
            THorizontalMusicBlockData.toObject = function toObject(message, options) {
                if (!options)
                    options = {};
                var object = {};
                if (options.arrays || options.defaults)
                    object.CentaurMainScreenGalleryMusicCardData = [];
                if (options.defaults) {
                    object.Type = "";
                    object.Title = "";
                }
                if (message.Type != null && message.hasOwnProperty("Type"))
                    object.Type = message.Type;
                if (message.Title != null && message.hasOwnProperty("Title"))
                    object.Title = message.Title;
                if (message.CentaurMainScreenGalleryMusicCardData && message.CentaurMainScreenGalleryMusicCardData.length) {
                    object.CentaurMainScreenGalleryMusicCardData = [];
                    for (var j = 0; j < message.CentaurMainScreenGalleryMusicCardData.length; ++j)
                        object.CentaurMainScreenGalleryMusicCardData[j] = $root.NAlice.NData.TCentaurMainScreenGalleryMusicCardData.toObject(message.CentaurMainScreenGalleryMusicCardData[j], options);
                }
                return object;
            };

            /**
             * Converts this THorizontalMusicBlockData to JSON.
             * @function toJSON
             * @memberof NAlice.NData.THorizontalMusicBlockData
             * @instance
             * @returns {Object.<string,*>} JSON object
             */
            THorizontalMusicBlockData.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            return THorizontalMusicBlockData;
        })();

        NData.TCentaurMainScreenGalleryMusicCardData = (function() {

            /**
             * Properties of a TCentaurMainScreenGalleryMusicCardData.
             * @memberof NAlice.NData
             * @interface ITCentaurMainScreenGalleryMusicCardData
             * @property {string|null} [Id] TCentaurMainScreenGalleryMusicCardData Id
             * @property {string|null} [ImageUrl] TCentaurMainScreenGalleryMusicCardData ImageUrl
             * @property {string|null} [Action] TCentaurMainScreenGalleryMusicCardData Action
             * @property {string|null} [Type] TCentaurMainScreenGalleryMusicCardData Type
             * @property {string|null} [Title] TCentaurMainScreenGalleryMusicCardData Title
             * @property {google.protobuf.IStringValue|null} [Modified] TCentaurMainScreenGalleryMusicCardData Modified
             * @property {google.protobuf.IUInt32Value|null} [LikesCount] TCentaurMainScreenGalleryMusicCardData LikesCount
             * @property {Array.<string>|null} [Genres] TCentaurMainScreenGalleryMusicCardData Genres
             * @property {google.protobuf.IStringValue|null} [ReleaseDate] TCentaurMainScreenGalleryMusicCardData ReleaseDate
             * @property {Array.<NAlice.NData.TCentaurMainScreenGalleryMusicCardData.ITArtistInfo>|null} [Artists] TCentaurMainScreenGalleryMusicCardData Artists
             * @property {string|null} [BlockType] TCentaurMainScreenGalleryMusicCardData BlockType
             * @property {google.protobuf.IAny|null} [TypedAction] TCentaurMainScreenGalleryMusicCardData TypedAction
             */

            /**
             * Constructs a new TCentaurMainScreenGalleryMusicCardData.
             * @memberof NAlice.NData
             * @classdesc Represents a TCentaurMainScreenGalleryMusicCardData.
             * @implements ITCentaurMainScreenGalleryMusicCardData
             * @constructor
             * @param {NAlice.NData.ITCentaurMainScreenGalleryMusicCardData=} [properties] Properties to set
             */
            function TCentaurMainScreenGalleryMusicCardData(properties) {
                this.Genres = [];
                this.Artists = [];
                if (properties)
                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                        if (properties[keys[i]] != null)
                            this[keys[i]] = properties[keys[i]];
            }

            /**
             * TCentaurMainScreenGalleryMusicCardData Id.
             * @member {string} Id
             * @memberof NAlice.NData.TCentaurMainScreenGalleryMusicCardData
             * @instance
             */
            TCentaurMainScreenGalleryMusicCardData.prototype.Id = "";

            /**
             * TCentaurMainScreenGalleryMusicCardData ImageUrl.
             * @member {string} ImageUrl
             * @memberof NAlice.NData.TCentaurMainScreenGalleryMusicCardData
             * @instance
             */
            TCentaurMainScreenGalleryMusicCardData.prototype.ImageUrl = "";

            /**
             * TCentaurMainScreenGalleryMusicCardData Action.
             * @member {string} Action
             * @memberof NAlice.NData.TCentaurMainScreenGalleryMusicCardData
             * @instance
             */
            TCentaurMainScreenGalleryMusicCardData.prototype.Action = "";

            /**
             * TCentaurMainScreenGalleryMusicCardData Type.
             * @member {string} Type
             * @memberof NAlice.NData.TCentaurMainScreenGalleryMusicCardData
             * @instance
             */
            TCentaurMainScreenGalleryMusicCardData.prototype.Type = "";

            /**
             * TCentaurMainScreenGalleryMusicCardData Title.
             * @member {string} Title
             * @memberof NAlice.NData.TCentaurMainScreenGalleryMusicCardData
             * @instance
             */
            TCentaurMainScreenGalleryMusicCardData.prototype.Title = "";

            /**
             * TCentaurMainScreenGalleryMusicCardData Modified.
             * @member {google.protobuf.IStringValue|null|undefined} Modified
             * @memberof NAlice.NData.TCentaurMainScreenGalleryMusicCardData
             * @instance
             */
            TCentaurMainScreenGalleryMusicCardData.prototype.Modified = null;

            /**
             * TCentaurMainScreenGalleryMusicCardData LikesCount.
             * @member {google.protobuf.IUInt32Value|null|undefined} LikesCount
             * @memberof NAlice.NData.TCentaurMainScreenGalleryMusicCardData
             * @instance
             */
            TCentaurMainScreenGalleryMusicCardData.prototype.LikesCount = null;

            /**
             * TCentaurMainScreenGalleryMusicCardData Genres.
             * @member {Array.<string>} Genres
             * @memberof NAlice.NData.TCentaurMainScreenGalleryMusicCardData
             * @instance
             */
            TCentaurMainScreenGalleryMusicCardData.prototype.Genres = $util.emptyArray;

            /**
             * TCentaurMainScreenGalleryMusicCardData ReleaseDate.
             * @member {google.protobuf.IStringValue|null|undefined} ReleaseDate
             * @memberof NAlice.NData.TCentaurMainScreenGalleryMusicCardData
             * @instance
             */
            TCentaurMainScreenGalleryMusicCardData.prototype.ReleaseDate = null;

            /**
             * TCentaurMainScreenGalleryMusicCardData Artists.
             * @member {Array.<NAlice.NData.TCentaurMainScreenGalleryMusicCardData.ITArtistInfo>} Artists
             * @memberof NAlice.NData.TCentaurMainScreenGalleryMusicCardData
             * @instance
             */
            TCentaurMainScreenGalleryMusicCardData.prototype.Artists = $util.emptyArray;

            /**
             * TCentaurMainScreenGalleryMusicCardData BlockType.
             * @member {string} BlockType
             * @memberof NAlice.NData.TCentaurMainScreenGalleryMusicCardData
             * @instance
             */
            TCentaurMainScreenGalleryMusicCardData.prototype.BlockType = "";

            /**
             * TCentaurMainScreenGalleryMusicCardData TypedAction.
             * @member {google.protobuf.IAny|null|undefined} TypedAction
             * @memberof NAlice.NData.TCentaurMainScreenGalleryMusicCardData
             * @instance
             */
            TCentaurMainScreenGalleryMusicCardData.prototype.TypedAction = null;

            /**
             * Creates a new TCentaurMainScreenGalleryMusicCardData instance using the specified properties.
             * @function create
             * @memberof NAlice.NData.TCentaurMainScreenGalleryMusicCardData
             * @static
             * @param {NAlice.NData.ITCentaurMainScreenGalleryMusicCardData=} [properties] Properties to set
             * @returns {NAlice.NData.TCentaurMainScreenGalleryMusicCardData} TCentaurMainScreenGalleryMusicCardData instance
             */
            TCentaurMainScreenGalleryMusicCardData.create = function create(properties) {
                return new TCentaurMainScreenGalleryMusicCardData(properties);
            };

            /**
             * Encodes the specified TCentaurMainScreenGalleryMusicCardData message. Does not implicitly {@link NAlice.NData.TCentaurMainScreenGalleryMusicCardData.verify|verify} messages.
             * @function encode
             * @memberof NAlice.NData.TCentaurMainScreenGalleryMusicCardData
             * @static
             * @param {NAlice.NData.ITCentaurMainScreenGalleryMusicCardData} message TCentaurMainScreenGalleryMusicCardData message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            TCentaurMainScreenGalleryMusicCardData.encode = function encode(message, writer) {
                if (!writer)
                    writer = $Writer.create();
                if (message.Id != null && Object.hasOwnProperty.call(message, "Id"))
                    writer.uint32(/* id 1, wireType 2 =*/10).string(message.Id);
                if (message.ImageUrl != null && Object.hasOwnProperty.call(message, "ImageUrl"))
                    writer.uint32(/* id 2, wireType 2 =*/18).string(message.ImageUrl);
                if (message.Action != null && Object.hasOwnProperty.call(message, "Action"))
                    writer.uint32(/* id 3, wireType 2 =*/26).string(message.Action);
                if (message.Type != null && Object.hasOwnProperty.call(message, "Type"))
                    writer.uint32(/* id 4, wireType 2 =*/34).string(message.Type);
                if (message.Title != null && Object.hasOwnProperty.call(message, "Title"))
                    writer.uint32(/* id 5, wireType 2 =*/42).string(message.Title);
                if (message.Modified != null && Object.hasOwnProperty.call(message, "Modified"))
                    $root.google.protobuf.StringValue.encode(message.Modified, writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
                if (message.LikesCount != null && Object.hasOwnProperty.call(message, "LikesCount"))
                    $root.google.protobuf.UInt32Value.encode(message.LikesCount, writer.uint32(/* id 7, wireType 2 =*/58).fork()).ldelim();
                if (message.Genres != null && message.Genres.length)
                    for (var i = 0; i < message.Genres.length; ++i)
                        writer.uint32(/* id 8, wireType 2 =*/66).string(message.Genres[i]);
                if (message.ReleaseDate != null && Object.hasOwnProperty.call(message, "ReleaseDate"))
                    $root.google.protobuf.StringValue.encode(message.ReleaseDate, writer.uint32(/* id 9, wireType 2 =*/74).fork()).ldelim();
                if (message.Artists != null && message.Artists.length)
                    for (var i = 0; i < message.Artists.length; ++i)
                        $root.NAlice.NData.TCentaurMainScreenGalleryMusicCardData.TArtistInfo.encode(message.Artists[i], writer.uint32(/* id 10, wireType 2 =*/82).fork()).ldelim();
                if (message.BlockType != null && Object.hasOwnProperty.call(message, "BlockType"))
                    writer.uint32(/* id 11, wireType 2 =*/90).string(message.BlockType);
                if (message.TypedAction != null && Object.hasOwnProperty.call(message, "TypedAction"))
                    $root.google.protobuf.Any.encode(message.TypedAction, writer.uint32(/* id 12, wireType 2 =*/98).fork()).ldelim();
                return writer;
            };

            /**
             * Encodes the specified TCentaurMainScreenGalleryMusicCardData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurMainScreenGalleryMusicCardData.verify|verify} messages.
             * @function encodeDelimited
             * @memberof NAlice.NData.TCentaurMainScreenGalleryMusicCardData
             * @static
             * @param {NAlice.NData.ITCentaurMainScreenGalleryMusicCardData} message TCentaurMainScreenGalleryMusicCardData message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            TCentaurMainScreenGalleryMusicCardData.encodeDelimited = function encodeDelimited(message, writer) {
                return this.encode(message, writer).ldelim();
            };

            /**
             * Decodes a TCentaurMainScreenGalleryMusicCardData message from the specified reader or buffer.
             * @function decode
             * @memberof NAlice.NData.TCentaurMainScreenGalleryMusicCardData
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @param {number} [length] Message length if known beforehand
             * @returns {NAlice.NData.TCentaurMainScreenGalleryMusicCardData} TCentaurMainScreenGalleryMusicCardData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            TCentaurMainScreenGalleryMusicCardData.decode = function decode(reader, length) {
                if (!(reader instanceof $Reader))
                    reader = $Reader.create(reader);
                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.NAlice.NData.TCentaurMainScreenGalleryMusicCardData();
                while (reader.pos < end) {
                    var tag = reader.uint32();
                    switch (tag >>> 3) {
                    case 1:
                        message.Id = reader.string();
                        break;
                    case 2:
                        message.ImageUrl = reader.string();
                        break;
                    case 3:
                        message.Action = reader.string();
                        break;
                    case 4:
                        message.Type = reader.string();
                        break;
                    case 5:
                        message.Title = reader.string();
                        break;
                    case 6:
                        message.Modified = $root.google.protobuf.StringValue.decode(reader, reader.uint32());
                        break;
                    case 7:
                        message.LikesCount = $root.google.protobuf.UInt32Value.decode(reader, reader.uint32());
                        break;
                    case 8:
                        if (!(message.Genres && message.Genres.length))
                            message.Genres = [];
                        message.Genres.push(reader.string());
                        break;
                    case 9:
                        message.ReleaseDate = $root.google.protobuf.StringValue.decode(reader, reader.uint32());
                        break;
                    case 10:
                        if (!(message.Artists && message.Artists.length))
                            message.Artists = [];
                        message.Artists.push($root.NAlice.NData.TCentaurMainScreenGalleryMusicCardData.TArtistInfo.decode(reader, reader.uint32()));
                        break;
                    case 11:
                        message.BlockType = reader.string();
                        break;
                    case 12:
                        message.TypedAction = $root.google.protobuf.Any.decode(reader, reader.uint32());
                        break;
                    default:
                        reader.skipType(tag & 7);
                        break;
                    }
                }
                return message;
            };

            /**
             * Decodes a TCentaurMainScreenGalleryMusicCardData message from the specified reader or buffer, length delimited.
             * @function decodeDelimited
             * @memberof NAlice.NData.TCentaurMainScreenGalleryMusicCardData
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @returns {NAlice.NData.TCentaurMainScreenGalleryMusicCardData} TCentaurMainScreenGalleryMusicCardData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            TCentaurMainScreenGalleryMusicCardData.decodeDelimited = function decodeDelimited(reader) {
                if (!(reader instanceof $Reader))
                    reader = new $Reader(reader);
                return this.decode(reader, reader.uint32());
            };

            /**
             * Verifies a TCentaurMainScreenGalleryMusicCardData message.
             * @function verify
             * @memberof NAlice.NData.TCentaurMainScreenGalleryMusicCardData
             * @static
             * @param {Object.<string,*>} message Plain object to verify
             * @returns {string|null} `null` if valid, otherwise the reason why it is not
             */
            TCentaurMainScreenGalleryMusicCardData.verify = function verify(message) {
                if (typeof message !== "object" || message === null)
                    return "object expected";
                if (message.Id != null && message.hasOwnProperty("Id"))
                    if (!$util.isString(message.Id))
                        return "Id: string expected";
                if (message.ImageUrl != null && message.hasOwnProperty("ImageUrl"))
                    if (!$util.isString(message.ImageUrl))
                        return "ImageUrl: string expected";
                if (message.Action != null && message.hasOwnProperty("Action"))
                    if (!$util.isString(message.Action))
                        return "Action: string expected";
                if (message.Type != null && message.hasOwnProperty("Type"))
                    if (!$util.isString(message.Type))
                        return "Type: string expected";
                if (message.Title != null && message.hasOwnProperty("Title"))
                    if (!$util.isString(message.Title))
                        return "Title: string expected";
                if (message.Modified != null && message.hasOwnProperty("Modified")) {
                    var error = $root.google.protobuf.StringValue.verify(message.Modified);
                    if (error)
                        return "Modified." + error;
                }
                if (message.LikesCount != null && message.hasOwnProperty("LikesCount")) {
                    var error = $root.google.protobuf.UInt32Value.verify(message.LikesCount);
                    if (error)
                        return "LikesCount." + error;
                }
                if (message.Genres != null && message.hasOwnProperty("Genres")) {
                    if (!Array.isArray(message.Genres))
                        return "Genres: array expected";
                    for (var i = 0; i < message.Genres.length; ++i)
                        if (!$util.isString(message.Genres[i]))
                            return "Genres: string[] expected";
                }
                if (message.ReleaseDate != null && message.hasOwnProperty("ReleaseDate")) {
                    var error = $root.google.protobuf.StringValue.verify(message.ReleaseDate);
                    if (error)
                        return "ReleaseDate." + error;
                }
                if (message.Artists != null && message.hasOwnProperty("Artists")) {
                    if (!Array.isArray(message.Artists))
                        return "Artists: array expected";
                    for (var i = 0; i < message.Artists.length; ++i) {
                        var error = $root.NAlice.NData.TCentaurMainScreenGalleryMusicCardData.TArtistInfo.verify(message.Artists[i]);
                        if (error)
                            return "Artists." + error;
                    }
                }
                if (message.BlockType != null && message.hasOwnProperty("BlockType"))
                    if (!$util.isString(message.BlockType))
                        return "BlockType: string expected";
                if (message.TypedAction != null && message.hasOwnProperty("TypedAction")) {
                    var error = $root.google.protobuf.Any.verify(message.TypedAction);
                    if (error)
                        return "TypedAction." + error;
                }
                return null;
            };

            /**
             * Creates a TCentaurMainScreenGalleryMusicCardData message from a plain object. Also converts values to their respective internal types.
             * @function fromObject
             * @memberof NAlice.NData.TCentaurMainScreenGalleryMusicCardData
             * @static
             * @param {Object.<string,*>} object Plain object
             * @returns {NAlice.NData.TCentaurMainScreenGalleryMusicCardData} TCentaurMainScreenGalleryMusicCardData
             */
            TCentaurMainScreenGalleryMusicCardData.fromObject = function fromObject(object) {
                if (object instanceof $root.NAlice.NData.TCentaurMainScreenGalleryMusicCardData)
                    return object;
                var message = new $root.NAlice.NData.TCentaurMainScreenGalleryMusicCardData();
                if (object.Id != null)
                    message.Id = String(object.Id);
                if (object.ImageUrl != null)
                    message.ImageUrl = String(object.ImageUrl);
                if (object.Action != null)
                    message.Action = String(object.Action);
                if (object.Type != null)
                    message.Type = String(object.Type);
                if (object.Title != null)
                    message.Title = String(object.Title);
                if (object.Modified != null) {
                    if (typeof object.Modified !== "object")
                        throw TypeError(".NAlice.NData.TCentaurMainScreenGalleryMusicCardData.Modified: object expected");
                    message.Modified = $root.google.protobuf.StringValue.fromObject(object.Modified);
                }
                if (object.LikesCount != null) {
                    if (typeof object.LikesCount !== "object")
                        throw TypeError(".NAlice.NData.TCentaurMainScreenGalleryMusicCardData.LikesCount: object expected");
                    message.LikesCount = $root.google.protobuf.UInt32Value.fromObject(object.LikesCount);
                }
                if (object.Genres) {
                    if (!Array.isArray(object.Genres))
                        throw TypeError(".NAlice.NData.TCentaurMainScreenGalleryMusicCardData.Genres: array expected");
                    message.Genres = [];
                    for (var i = 0; i < object.Genres.length; ++i)
                        message.Genres[i] = String(object.Genres[i]);
                }
                if (object.ReleaseDate != null) {
                    if (typeof object.ReleaseDate !== "object")
                        throw TypeError(".NAlice.NData.TCentaurMainScreenGalleryMusicCardData.ReleaseDate: object expected");
                    message.ReleaseDate = $root.google.protobuf.StringValue.fromObject(object.ReleaseDate);
                }
                if (object.Artists) {
                    if (!Array.isArray(object.Artists))
                        throw TypeError(".NAlice.NData.TCentaurMainScreenGalleryMusicCardData.Artists: array expected");
                    message.Artists = [];
                    for (var i = 0; i < object.Artists.length; ++i) {
                        if (typeof object.Artists[i] !== "object")
                            throw TypeError(".NAlice.NData.TCentaurMainScreenGalleryMusicCardData.Artists: object expected");
                        message.Artists[i] = $root.NAlice.NData.TCentaurMainScreenGalleryMusicCardData.TArtistInfo.fromObject(object.Artists[i]);
                    }
                }
                if (object.BlockType != null)
                    message.BlockType = String(object.BlockType);
                if (object.TypedAction != null) {
                    if (typeof object.TypedAction !== "object")
                        throw TypeError(".NAlice.NData.TCentaurMainScreenGalleryMusicCardData.TypedAction: object expected");
                    message.TypedAction = $root.google.protobuf.Any.fromObject(object.TypedAction);
                }
                return message;
            };

            /**
             * Creates a plain object from a TCentaurMainScreenGalleryMusicCardData message. Also converts values to other types if specified.
             * @function toObject
             * @memberof NAlice.NData.TCentaurMainScreenGalleryMusicCardData
             * @static
             * @param {NAlice.NData.TCentaurMainScreenGalleryMusicCardData} message TCentaurMainScreenGalleryMusicCardData
             * @param {$protobuf.IConversionOptions} [options] Conversion options
             * @returns {Object.<string,*>} Plain object
             */
            TCentaurMainScreenGalleryMusicCardData.toObject = function toObject(message, options) {
                if (!options)
                    options = {};
                var object = {};
                if (options.arrays || options.defaults) {
                    object.Genres = [];
                    object.Artists = [];
                }
                if (options.defaults) {
                    object.Id = "";
                    object.ImageUrl = "";
                    object.Action = "";
                    object.Type = "";
                    object.Title = "";
                    object.Modified = null;
                    object.LikesCount = null;
                    object.ReleaseDate = null;
                    object.BlockType = "";
                    object.TypedAction = null;
                }
                if (message.Id != null && message.hasOwnProperty("Id"))
                    object.Id = message.Id;
                if (message.ImageUrl != null && message.hasOwnProperty("ImageUrl"))
                    object.ImageUrl = message.ImageUrl;
                if (message.Action != null && message.hasOwnProperty("Action"))
                    object.Action = message.Action;
                if (message.Type != null && message.hasOwnProperty("Type"))
                    object.Type = message.Type;
                if (message.Title != null && message.hasOwnProperty("Title"))
                    object.Title = message.Title;
                if (message.Modified != null && message.hasOwnProperty("Modified"))
                    object.Modified = $root.google.protobuf.StringValue.toObject(message.Modified, options);
                if (message.LikesCount != null && message.hasOwnProperty("LikesCount"))
                    object.LikesCount = $root.google.protobuf.UInt32Value.toObject(message.LikesCount, options);
                if (message.Genres && message.Genres.length) {
                    object.Genres = [];
                    for (var j = 0; j < message.Genres.length; ++j)
                        object.Genres[j] = message.Genres[j];
                }
                if (message.ReleaseDate != null && message.hasOwnProperty("ReleaseDate"))
                    object.ReleaseDate = $root.google.protobuf.StringValue.toObject(message.ReleaseDate, options);
                if (message.Artists && message.Artists.length) {
                    object.Artists = [];
                    for (var j = 0; j < message.Artists.length; ++j)
                        object.Artists[j] = $root.NAlice.NData.TCentaurMainScreenGalleryMusicCardData.TArtistInfo.toObject(message.Artists[j], options);
                }
                if (message.BlockType != null && message.hasOwnProperty("BlockType"))
                    object.BlockType = message.BlockType;
                if (message.TypedAction != null && message.hasOwnProperty("TypedAction"))
                    object.TypedAction = $root.google.protobuf.Any.toObject(message.TypedAction, options);
                return object;
            };

            /**
             * Converts this TCentaurMainScreenGalleryMusicCardData to JSON.
             * @function toJSON
             * @memberof NAlice.NData.TCentaurMainScreenGalleryMusicCardData
             * @instance
             * @returns {Object.<string,*>} JSON object
             */
            TCentaurMainScreenGalleryMusicCardData.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            TCentaurMainScreenGalleryMusicCardData.TArtistInfo = (function() {

                /**
                 * Properties of a TArtistInfo.
                 * @memberof NAlice.NData.TCentaurMainScreenGalleryMusicCardData
                 * @interface ITArtistInfo
                 * @property {string|null} [Id] TArtistInfo Id
                 * @property {string|null} [Name] TArtistInfo Name
                 */

                /**
                 * Constructs a new TArtistInfo.
                 * @memberof NAlice.NData.TCentaurMainScreenGalleryMusicCardData
                 * @classdesc Represents a TArtistInfo.
                 * @implements ITArtistInfo
                 * @constructor
                 * @param {NAlice.NData.TCentaurMainScreenGalleryMusicCardData.ITArtistInfo=} [properties] Properties to set
                 */
                function TArtistInfo(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }

                /**
                 * TArtistInfo Id.
                 * @member {string} Id
                 * @memberof NAlice.NData.TCentaurMainScreenGalleryMusicCardData.TArtistInfo
                 * @instance
                 */
                TArtistInfo.prototype.Id = "";

                /**
                 * TArtistInfo Name.
                 * @member {string} Name
                 * @memberof NAlice.NData.TCentaurMainScreenGalleryMusicCardData.TArtistInfo
                 * @instance
                 */
                TArtistInfo.prototype.Name = "";

                /**
                 * Creates a new TArtistInfo instance using the specified properties.
                 * @function create
                 * @memberof NAlice.NData.TCentaurMainScreenGalleryMusicCardData.TArtistInfo
                 * @static
                 * @param {NAlice.NData.TCentaurMainScreenGalleryMusicCardData.ITArtistInfo=} [properties] Properties to set
                 * @returns {NAlice.NData.TCentaurMainScreenGalleryMusicCardData.TArtistInfo} TArtistInfo instance
                 */
                TArtistInfo.create = function create(properties) {
                    return new TArtistInfo(properties);
                };

                /**
                 * Encodes the specified TArtistInfo message. Does not implicitly {@link NAlice.NData.TCentaurMainScreenGalleryMusicCardData.TArtistInfo.verify|verify} messages.
                 * @function encode
                 * @memberof NAlice.NData.TCentaurMainScreenGalleryMusicCardData.TArtistInfo
                 * @static
                 * @param {NAlice.NData.TCentaurMainScreenGalleryMusicCardData.ITArtistInfo} message TArtistInfo message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                TArtistInfo.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.Id != null && Object.hasOwnProperty.call(message, "Id"))
                        writer.uint32(/* id 1, wireType 2 =*/10).string(message.Id);
                    if (message.Name != null && Object.hasOwnProperty.call(message, "Name"))
                        writer.uint32(/* id 2, wireType 2 =*/18).string(message.Name);
                    return writer;
                };

                /**
                 * Encodes the specified TArtistInfo message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurMainScreenGalleryMusicCardData.TArtistInfo.verify|verify} messages.
                 * @function encodeDelimited
                 * @memberof NAlice.NData.TCentaurMainScreenGalleryMusicCardData.TArtistInfo
                 * @static
                 * @param {NAlice.NData.TCentaurMainScreenGalleryMusicCardData.ITArtistInfo} message TArtistInfo message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                TArtistInfo.encodeDelimited = function encodeDelimited(message, writer) {
                    return this.encode(message, writer).ldelim();
                };

                /**
                 * Decodes a TArtistInfo message from the specified reader or buffer.
                 * @function decode
                 * @memberof NAlice.NData.TCentaurMainScreenGalleryMusicCardData.TArtistInfo
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {NAlice.NData.TCentaurMainScreenGalleryMusicCardData.TArtistInfo} TArtistInfo
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                TArtistInfo.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.NAlice.NData.TCentaurMainScreenGalleryMusicCardData.TArtistInfo();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.Id = reader.string();
                            break;
                        case 2:
                            message.Name = reader.string();
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };

                /**
                 * Decodes a TArtistInfo message from the specified reader or buffer, length delimited.
                 * @function decodeDelimited
                 * @memberof NAlice.NData.TCentaurMainScreenGalleryMusicCardData.TArtistInfo
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @returns {NAlice.NData.TCentaurMainScreenGalleryMusicCardData.TArtistInfo} TArtistInfo
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                TArtistInfo.decodeDelimited = function decodeDelimited(reader) {
                    if (!(reader instanceof $Reader))
                        reader = new $Reader(reader);
                    return this.decode(reader, reader.uint32());
                };

                /**
                 * Verifies a TArtistInfo message.
                 * @function verify
                 * @memberof NAlice.NData.TCentaurMainScreenGalleryMusicCardData.TArtistInfo
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                TArtistInfo.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.Id != null && message.hasOwnProperty("Id"))
                        if (!$util.isString(message.Id))
                            return "Id: string expected";
                    if (message.Name != null && message.hasOwnProperty("Name"))
                        if (!$util.isString(message.Name))
                            return "Name: string expected";
                    return null;
                };

                /**
                 * Creates a TArtistInfo message from a plain object. Also converts values to their respective internal types.
                 * @function fromObject
                 * @memberof NAlice.NData.TCentaurMainScreenGalleryMusicCardData.TArtistInfo
                 * @static
                 * @param {Object.<string,*>} object Plain object
                 * @returns {NAlice.NData.TCentaurMainScreenGalleryMusicCardData.TArtistInfo} TArtistInfo
                 */
                TArtistInfo.fromObject = function fromObject(object) {
                    if (object instanceof $root.NAlice.NData.TCentaurMainScreenGalleryMusicCardData.TArtistInfo)
                        return object;
                    var message = new $root.NAlice.NData.TCentaurMainScreenGalleryMusicCardData.TArtistInfo();
                    if (object.Id != null)
                        message.Id = String(object.Id);
                    if (object.Name != null)
                        message.Name = String(object.Name);
                    return message;
                };

                /**
                 * Creates a plain object from a TArtistInfo message. Also converts values to other types if specified.
                 * @function toObject
                 * @memberof NAlice.NData.TCentaurMainScreenGalleryMusicCardData.TArtistInfo
                 * @static
                 * @param {NAlice.NData.TCentaurMainScreenGalleryMusicCardData.TArtistInfo} message TArtistInfo
                 * @param {$protobuf.IConversionOptions} [options] Conversion options
                 * @returns {Object.<string,*>} Plain object
                 */
                TArtistInfo.toObject = function toObject(message, options) {
                    if (!options)
                        options = {};
                    var object = {};
                    if (options.defaults) {
                        object.Id = "";
                        object.Name = "";
                    }
                    if (message.Id != null && message.hasOwnProperty("Id"))
                        object.Id = message.Id;
                    if (message.Name != null && message.hasOwnProperty("Name"))
                        object.Name = message.Name;
                    return object;
                };

                /**
                 * Converts this TArtistInfo to JSON.
                 * @function toJSON
                 * @memberof NAlice.NData.TCentaurMainScreenGalleryMusicCardData.TArtistInfo
                 * @instance
                 * @returns {Object.<string,*>} JSON object
                 */
                TArtistInfo.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };

                return TArtistInfo;
            })();

            return TCentaurMainScreenGalleryMusicCardData;
        })();

        NData.TCentaurMainScreenGalleryVideoCardData = (function() {

            /**
             * Properties of a TCentaurMainScreenGalleryVideoCardData.
             * @memberof NAlice.NData
             * @interface ITCentaurMainScreenGalleryVideoCardData
             * @property {string|null} [Id] TCentaurMainScreenGalleryVideoCardData Id
             * @property {string|null} [ImageUrl] TCentaurMainScreenGalleryVideoCardData ImageUrl
             * @property {string|null} [Action] TCentaurMainScreenGalleryVideoCardData Action
             */

            /**
             * Constructs a new TCentaurMainScreenGalleryVideoCardData.
             * @memberof NAlice.NData
             * @classdesc Represents a TCentaurMainScreenGalleryVideoCardData.
             * @implements ITCentaurMainScreenGalleryVideoCardData
             * @constructor
             * @param {NAlice.NData.ITCentaurMainScreenGalleryVideoCardData=} [properties] Properties to set
             */
            function TCentaurMainScreenGalleryVideoCardData(properties) {
                if (properties)
                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                        if (properties[keys[i]] != null)
                            this[keys[i]] = properties[keys[i]];
            }

            /**
             * TCentaurMainScreenGalleryVideoCardData Id.
             * @member {string} Id
             * @memberof NAlice.NData.TCentaurMainScreenGalleryVideoCardData
             * @instance
             */
            TCentaurMainScreenGalleryVideoCardData.prototype.Id = "";

            /**
             * TCentaurMainScreenGalleryVideoCardData ImageUrl.
             * @member {string} ImageUrl
             * @memberof NAlice.NData.TCentaurMainScreenGalleryVideoCardData
             * @instance
             */
            TCentaurMainScreenGalleryVideoCardData.prototype.ImageUrl = "";

            /**
             * TCentaurMainScreenGalleryVideoCardData Action.
             * @member {string} Action
             * @memberof NAlice.NData.TCentaurMainScreenGalleryVideoCardData
             * @instance
             */
            TCentaurMainScreenGalleryVideoCardData.prototype.Action = "";

            /**
             * Creates a new TCentaurMainScreenGalleryVideoCardData instance using the specified properties.
             * @function create
             * @memberof NAlice.NData.TCentaurMainScreenGalleryVideoCardData
             * @static
             * @param {NAlice.NData.ITCentaurMainScreenGalleryVideoCardData=} [properties] Properties to set
             * @returns {NAlice.NData.TCentaurMainScreenGalleryVideoCardData} TCentaurMainScreenGalleryVideoCardData instance
             */
            TCentaurMainScreenGalleryVideoCardData.create = function create(properties) {
                return new TCentaurMainScreenGalleryVideoCardData(properties);
            };

            /**
             * Encodes the specified TCentaurMainScreenGalleryVideoCardData message. Does not implicitly {@link NAlice.NData.TCentaurMainScreenGalleryVideoCardData.verify|verify} messages.
             * @function encode
             * @memberof NAlice.NData.TCentaurMainScreenGalleryVideoCardData
             * @static
             * @param {NAlice.NData.ITCentaurMainScreenGalleryVideoCardData} message TCentaurMainScreenGalleryVideoCardData message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            TCentaurMainScreenGalleryVideoCardData.encode = function encode(message, writer) {
                if (!writer)
                    writer = $Writer.create();
                if (message.Id != null && Object.hasOwnProperty.call(message, "Id"))
                    writer.uint32(/* id 1, wireType 2 =*/10).string(message.Id);
                if (message.ImageUrl != null && Object.hasOwnProperty.call(message, "ImageUrl"))
                    writer.uint32(/* id 2, wireType 2 =*/18).string(message.ImageUrl);
                if (message.Action != null && Object.hasOwnProperty.call(message, "Action"))
                    writer.uint32(/* id 3, wireType 2 =*/26).string(message.Action);
                return writer;
            };

            /**
             * Encodes the specified TCentaurMainScreenGalleryVideoCardData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurMainScreenGalleryVideoCardData.verify|verify} messages.
             * @function encodeDelimited
             * @memberof NAlice.NData.TCentaurMainScreenGalleryVideoCardData
             * @static
             * @param {NAlice.NData.ITCentaurMainScreenGalleryVideoCardData} message TCentaurMainScreenGalleryVideoCardData message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            TCentaurMainScreenGalleryVideoCardData.encodeDelimited = function encodeDelimited(message, writer) {
                return this.encode(message, writer).ldelim();
            };

            /**
             * Decodes a TCentaurMainScreenGalleryVideoCardData message from the specified reader or buffer.
             * @function decode
             * @memberof NAlice.NData.TCentaurMainScreenGalleryVideoCardData
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @param {number} [length] Message length if known beforehand
             * @returns {NAlice.NData.TCentaurMainScreenGalleryVideoCardData} TCentaurMainScreenGalleryVideoCardData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            TCentaurMainScreenGalleryVideoCardData.decode = function decode(reader, length) {
                if (!(reader instanceof $Reader))
                    reader = $Reader.create(reader);
                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.NAlice.NData.TCentaurMainScreenGalleryVideoCardData();
                while (reader.pos < end) {
                    var tag = reader.uint32();
                    switch (tag >>> 3) {
                    case 1:
                        message.Id = reader.string();
                        break;
                    case 2:
                        message.ImageUrl = reader.string();
                        break;
                    case 3:
                        message.Action = reader.string();
                        break;
                    default:
                        reader.skipType(tag & 7);
                        break;
                    }
                }
                return message;
            };

            /**
             * Decodes a TCentaurMainScreenGalleryVideoCardData message from the specified reader or buffer, length delimited.
             * @function decodeDelimited
             * @memberof NAlice.NData.TCentaurMainScreenGalleryVideoCardData
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @returns {NAlice.NData.TCentaurMainScreenGalleryVideoCardData} TCentaurMainScreenGalleryVideoCardData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            TCentaurMainScreenGalleryVideoCardData.decodeDelimited = function decodeDelimited(reader) {
                if (!(reader instanceof $Reader))
                    reader = new $Reader(reader);
                return this.decode(reader, reader.uint32());
            };

            /**
             * Verifies a TCentaurMainScreenGalleryVideoCardData message.
             * @function verify
             * @memberof NAlice.NData.TCentaurMainScreenGalleryVideoCardData
             * @static
             * @param {Object.<string,*>} message Plain object to verify
             * @returns {string|null} `null` if valid, otherwise the reason why it is not
             */
            TCentaurMainScreenGalleryVideoCardData.verify = function verify(message) {
                if (typeof message !== "object" || message === null)
                    return "object expected";
                if (message.Id != null && message.hasOwnProperty("Id"))
                    if (!$util.isString(message.Id))
                        return "Id: string expected";
                if (message.ImageUrl != null && message.hasOwnProperty("ImageUrl"))
                    if (!$util.isString(message.ImageUrl))
                        return "ImageUrl: string expected";
                if (message.Action != null && message.hasOwnProperty("Action"))
                    if (!$util.isString(message.Action))
                        return "Action: string expected";
                return null;
            };

            /**
             * Creates a TCentaurMainScreenGalleryVideoCardData message from a plain object. Also converts values to their respective internal types.
             * @function fromObject
             * @memberof NAlice.NData.TCentaurMainScreenGalleryVideoCardData
             * @static
             * @param {Object.<string,*>} object Plain object
             * @returns {NAlice.NData.TCentaurMainScreenGalleryVideoCardData} TCentaurMainScreenGalleryVideoCardData
             */
            TCentaurMainScreenGalleryVideoCardData.fromObject = function fromObject(object) {
                if (object instanceof $root.NAlice.NData.TCentaurMainScreenGalleryVideoCardData)
                    return object;
                var message = new $root.NAlice.NData.TCentaurMainScreenGalleryVideoCardData();
                if (object.Id != null)
                    message.Id = String(object.Id);
                if (object.ImageUrl != null)
                    message.ImageUrl = String(object.ImageUrl);
                if (object.Action != null)
                    message.Action = String(object.Action);
                return message;
            };

            /**
             * Creates a plain object from a TCentaurMainScreenGalleryVideoCardData message. Also converts values to other types if specified.
             * @function toObject
             * @memberof NAlice.NData.TCentaurMainScreenGalleryVideoCardData
             * @static
             * @param {NAlice.NData.TCentaurMainScreenGalleryVideoCardData} message TCentaurMainScreenGalleryVideoCardData
             * @param {$protobuf.IConversionOptions} [options] Conversion options
             * @returns {Object.<string,*>} Plain object
             */
            TCentaurMainScreenGalleryVideoCardData.toObject = function toObject(message, options) {
                if (!options)
                    options = {};
                var object = {};
                if (options.defaults) {
                    object.Id = "";
                    object.ImageUrl = "";
                    object.Action = "";
                }
                if (message.Id != null && message.hasOwnProperty("Id"))
                    object.Id = message.Id;
                if (message.ImageUrl != null && message.hasOwnProperty("ImageUrl"))
                    object.ImageUrl = message.ImageUrl;
                if (message.Action != null && message.hasOwnProperty("Action"))
                    object.Action = message.Action;
                return object;
            };

            /**
             * Converts this TCentaurMainScreenGalleryVideoCardData to JSON.
             * @function toJSON
             * @memberof NAlice.NData.TCentaurMainScreenGalleryVideoCardData
             * @instance
             * @returns {Object.<string,*>} JSON object
             */
            TCentaurMainScreenGalleryVideoCardData.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            return TCentaurMainScreenGalleryVideoCardData;
        })();

        NData.TCentaurMainScreenWebviewCardData = (function() {

            /**
             * Properties of a TCentaurMainScreenWebviewCardData.
             * @memberof NAlice.NData
             * @interface ITCentaurMainScreenWebviewCardData
             * @property {string|null} [Id] TCentaurMainScreenWebviewCardData Id
             * @property {string|null} [ImageUrl] TCentaurMainScreenWebviewCardData ImageUrl
             * @property {string|null} [WebviewUrl] TCentaurMainScreenWebviewCardData WebviewUrl
             * @property {string|null} [Title] TCentaurMainScreenWebviewCardData Title
             */

            /**
             * Constructs a new TCentaurMainScreenWebviewCardData.
             * @memberof NAlice.NData
             * @classdesc Represents a TCentaurMainScreenWebviewCardData.
             * @implements ITCentaurMainScreenWebviewCardData
             * @constructor
             * @param {NAlice.NData.ITCentaurMainScreenWebviewCardData=} [properties] Properties to set
             */
            function TCentaurMainScreenWebviewCardData(properties) {
                if (properties)
                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                        if (properties[keys[i]] != null)
                            this[keys[i]] = properties[keys[i]];
            }

            /**
             * TCentaurMainScreenWebviewCardData Id.
             * @member {string} Id
             * @memberof NAlice.NData.TCentaurMainScreenWebviewCardData
             * @instance
             */
            TCentaurMainScreenWebviewCardData.prototype.Id = "";

            /**
             * TCentaurMainScreenWebviewCardData ImageUrl.
             * @member {string} ImageUrl
             * @memberof NAlice.NData.TCentaurMainScreenWebviewCardData
             * @instance
             */
            TCentaurMainScreenWebviewCardData.prototype.ImageUrl = "";

            /**
             * TCentaurMainScreenWebviewCardData WebviewUrl.
             * @member {string} WebviewUrl
             * @memberof NAlice.NData.TCentaurMainScreenWebviewCardData
             * @instance
             */
            TCentaurMainScreenWebviewCardData.prototype.WebviewUrl = "";

            /**
             * TCentaurMainScreenWebviewCardData Title.
             * @member {string} Title
             * @memberof NAlice.NData.TCentaurMainScreenWebviewCardData
             * @instance
             */
            TCentaurMainScreenWebviewCardData.prototype.Title = "";

            /**
             * Creates a new TCentaurMainScreenWebviewCardData instance using the specified properties.
             * @function create
             * @memberof NAlice.NData.TCentaurMainScreenWebviewCardData
             * @static
             * @param {NAlice.NData.ITCentaurMainScreenWebviewCardData=} [properties] Properties to set
             * @returns {NAlice.NData.TCentaurMainScreenWebviewCardData} TCentaurMainScreenWebviewCardData instance
             */
            TCentaurMainScreenWebviewCardData.create = function create(properties) {
                return new TCentaurMainScreenWebviewCardData(properties);
            };

            /**
             * Encodes the specified TCentaurMainScreenWebviewCardData message. Does not implicitly {@link NAlice.NData.TCentaurMainScreenWebviewCardData.verify|verify} messages.
             * @function encode
             * @memberof NAlice.NData.TCentaurMainScreenWebviewCardData
             * @static
             * @param {NAlice.NData.ITCentaurMainScreenWebviewCardData} message TCentaurMainScreenWebviewCardData message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            TCentaurMainScreenWebviewCardData.encode = function encode(message, writer) {
                if (!writer)
                    writer = $Writer.create();
                if (message.Id != null && Object.hasOwnProperty.call(message, "Id"))
                    writer.uint32(/* id 1, wireType 2 =*/10).string(message.Id);
                if (message.ImageUrl != null && Object.hasOwnProperty.call(message, "ImageUrl"))
                    writer.uint32(/* id 2, wireType 2 =*/18).string(message.ImageUrl);
                if (message.WebviewUrl != null && Object.hasOwnProperty.call(message, "WebviewUrl"))
                    writer.uint32(/* id 3, wireType 2 =*/26).string(message.WebviewUrl);
                if (message.Title != null && Object.hasOwnProperty.call(message, "Title"))
                    writer.uint32(/* id 4, wireType 2 =*/34).string(message.Title);
                return writer;
            };

            /**
             * Encodes the specified TCentaurMainScreenWebviewCardData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurMainScreenWebviewCardData.verify|verify} messages.
             * @function encodeDelimited
             * @memberof NAlice.NData.TCentaurMainScreenWebviewCardData
             * @static
             * @param {NAlice.NData.ITCentaurMainScreenWebviewCardData} message TCentaurMainScreenWebviewCardData message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            TCentaurMainScreenWebviewCardData.encodeDelimited = function encodeDelimited(message, writer) {
                return this.encode(message, writer).ldelim();
            };

            /**
             * Decodes a TCentaurMainScreenWebviewCardData message from the specified reader or buffer.
             * @function decode
             * @memberof NAlice.NData.TCentaurMainScreenWebviewCardData
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @param {number} [length] Message length if known beforehand
             * @returns {NAlice.NData.TCentaurMainScreenWebviewCardData} TCentaurMainScreenWebviewCardData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            TCentaurMainScreenWebviewCardData.decode = function decode(reader, length) {
                if (!(reader instanceof $Reader))
                    reader = $Reader.create(reader);
                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.NAlice.NData.TCentaurMainScreenWebviewCardData();
                while (reader.pos < end) {
                    var tag = reader.uint32();
                    switch (tag >>> 3) {
                    case 1:
                        message.Id = reader.string();
                        break;
                    case 2:
                        message.ImageUrl = reader.string();
                        break;
                    case 3:
                        message.WebviewUrl = reader.string();
                        break;
                    case 4:
                        message.Title = reader.string();
                        break;
                    default:
                        reader.skipType(tag & 7);
                        break;
                    }
                }
                return message;
            };

            /**
             * Decodes a TCentaurMainScreenWebviewCardData message from the specified reader or buffer, length delimited.
             * @function decodeDelimited
             * @memberof NAlice.NData.TCentaurMainScreenWebviewCardData
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @returns {NAlice.NData.TCentaurMainScreenWebviewCardData} TCentaurMainScreenWebviewCardData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            TCentaurMainScreenWebviewCardData.decodeDelimited = function decodeDelimited(reader) {
                if (!(reader instanceof $Reader))
                    reader = new $Reader(reader);
                return this.decode(reader, reader.uint32());
            };

            /**
             * Verifies a TCentaurMainScreenWebviewCardData message.
             * @function verify
             * @memberof NAlice.NData.TCentaurMainScreenWebviewCardData
             * @static
             * @param {Object.<string,*>} message Plain object to verify
             * @returns {string|null} `null` if valid, otherwise the reason why it is not
             */
            TCentaurMainScreenWebviewCardData.verify = function verify(message) {
                if (typeof message !== "object" || message === null)
                    return "object expected";
                if (message.Id != null && message.hasOwnProperty("Id"))
                    if (!$util.isString(message.Id))
                        return "Id: string expected";
                if (message.ImageUrl != null && message.hasOwnProperty("ImageUrl"))
                    if (!$util.isString(message.ImageUrl))
                        return "ImageUrl: string expected";
                if (message.WebviewUrl != null && message.hasOwnProperty("WebviewUrl"))
                    if (!$util.isString(message.WebviewUrl))
                        return "WebviewUrl: string expected";
                if (message.Title != null && message.hasOwnProperty("Title"))
                    if (!$util.isString(message.Title))
                        return "Title: string expected";
                return null;
            };

            /**
             * Creates a TCentaurMainScreenWebviewCardData message from a plain object. Also converts values to their respective internal types.
             * @function fromObject
             * @memberof NAlice.NData.TCentaurMainScreenWebviewCardData
             * @static
             * @param {Object.<string,*>} object Plain object
             * @returns {NAlice.NData.TCentaurMainScreenWebviewCardData} TCentaurMainScreenWebviewCardData
             */
            TCentaurMainScreenWebviewCardData.fromObject = function fromObject(object) {
                if (object instanceof $root.NAlice.NData.TCentaurMainScreenWebviewCardData)
                    return object;
                var message = new $root.NAlice.NData.TCentaurMainScreenWebviewCardData();
                if (object.Id != null)
                    message.Id = String(object.Id);
                if (object.ImageUrl != null)
                    message.ImageUrl = String(object.ImageUrl);
                if (object.WebviewUrl != null)
                    message.WebviewUrl = String(object.WebviewUrl);
                if (object.Title != null)
                    message.Title = String(object.Title);
                return message;
            };

            /**
             * Creates a plain object from a TCentaurMainScreenWebviewCardData message. Also converts values to other types if specified.
             * @function toObject
             * @memberof NAlice.NData.TCentaurMainScreenWebviewCardData
             * @static
             * @param {NAlice.NData.TCentaurMainScreenWebviewCardData} message TCentaurMainScreenWebviewCardData
             * @param {$protobuf.IConversionOptions} [options] Conversion options
             * @returns {Object.<string,*>} Plain object
             */
            TCentaurMainScreenWebviewCardData.toObject = function toObject(message, options) {
                if (!options)
                    options = {};
                var object = {};
                if (options.defaults) {
                    object.Id = "";
                    object.ImageUrl = "";
                    object.WebviewUrl = "";
                    object.Title = "";
                }
                if (message.Id != null && message.hasOwnProperty("Id"))
                    object.Id = message.Id;
                if (message.ImageUrl != null && message.hasOwnProperty("ImageUrl"))
                    object.ImageUrl = message.ImageUrl;
                if (message.WebviewUrl != null && message.hasOwnProperty("WebviewUrl"))
                    object.WebviewUrl = message.WebviewUrl;
                if (message.Title != null && message.hasOwnProperty("Title"))
                    object.Title = message.Title;
                return object;
            };

            /**
             * Converts this TCentaurMainScreenWebviewCardData to JSON.
             * @function toJSON
             * @memberof NAlice.NData.TCentaurMainScreenWebviewCardData
             * @instance
             * @returns {Object.<string,*>} JSON object
             */
            TCentaurMainScreenWebviewCardData.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            return TCentaurMainScreenWebviewCardData;
        })();

        NData.TCentaurMainScreenWebviewTabData = (function() {

            /**
             * Properties of a TCentaurMainScreenWebviewTabData.
             * @memberof NAlice.NData
             * @interface ITCentaurMainScreenWebviewTabData
             * @property {string|null} [Id] TCentaurMainScreenWebviewTabData Id
             * @property {string|null} [WebviewUrl] TCentaurMainScreenWebviewTabData WebviewUrl
             */

            /**
             * Constructs a new TCentaurMainScreenWebviewTabData.
             * @memberof NAlice.NData
             * @classdesc Represents a TCentaurMainScreenWebviewTabData.
             * @implements ITCentaurMainScreenWebviewTabData
             * @constructor
             * @param {NAlice.NData.ITCentaurMainScreenWebviewTabData=} [properties] Properties to set
             */
            function TCentaurMainScreenWebviewTabData(properties) {
                if (properties)
                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                        if (properties[keys[i]] != null)
                            this[keys[i]] = properties[keys[i]];
            }

            /**
             * TCentaurMainScreenWebviewTabData Id.
             * @member {string} Id
             * @memberof NAlice.NData.TCentaurMainScreenWebviewTabData
             * @instance
             */
            TCentaurMainScreenWebviewTabData.prototype.Id = "";

            /**
             * TCentaurMainScreenWebviewTabData WebviewUrl.
             * @member {string} WebviewUrl
             * @memberof NAlice.NData.TCentaurMainScreenWebviewTabData
             * @instance
             */
            TCentaurMainScreenWebviewTabData.prototype.WebviewUrl = "";

            /**
             * Creates a new TCentaurMainScreenWebviewTabData instance using the specified properties.
             * @function create
             * @memberof NAlice.NData.TCentaurMainScreenWebviewTabData
             * @static
             * @param {NAlice.NData.ITCentaurMainScreenWebviewTabData=} [properties] Properties to set
             * @returns {NAlice.NData.TCentaurMainScreenWebviewTabData} TCentaurMainScreenWebviewTabData instance
             */
            TCentaurMainScreenWebviewTabData.create = function create(properties) {
                return new TCentaurMainScreenWebviewTabData(properties);
            };

            /**
             * Encodes the specified TCentaurMainScreenWebviewTabData message. Does not implicitly {@link NAlice.NData.TCentaurMainScreenWebviewTabData.verify|verify} messages.
             * @function encode
             * @memberof NAlice.NData.TCentaurMainScreenWebviewTabData
             * @static
             * @param {NAlice.NData.ITCentaurMainScreenWebviewTabData} message TCentaurMainScreenWebviewTabData message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            TCentaurMainScreenWebviewTabData.encode = function encode(message, writer) {
                if (!writer)
                    writer = $Writer.create();
                if (message.Id != null && Object.hasOwnProperty.call(message, "Id"))
                    writer.uint32(/* id 1, wireType 2 =*/10).string(message.Id);
                if (message.WebviewUrl != null && Object.hasOwnProperty.call(message, "WebviewUrl"))
                    writer.uint32(/* id 2, wireType 2 =*/18).string(message.WebviewUrl);
                return writer;
            };

            /**
             * Encodes the specified TCentaurMainScreenWebviewTabData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurMainScreenWebviewTabData.verify|verify} messages.
             * @function encodeDelimited
             * @memberof NAlice.NData.TCentaurMainScreenWebviewTabData
             * @static
             * @param {NAlice.NData.ITCentaurMainScreenWebviewTabData} message TCentaurMainScreenWebviewTabData message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            TCentaurMainScreenWebviewTabData.encodeDelimited = function encodeDelimited(message, writer) {
                return this.encode(message, writer).ldelim();
            };

            /**
             * Decodes a TCentaurMainScreenWebviewTabData message from the specified reader or buffer.
             * @function decode
             * @memberof NAlice.NData.TCentaurMainScreenWebviewTabData
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @param {number} [length] Message length if known beforehand
             * @returns {NAlice.NData.TCentaurMainScreenWebviewTabData} TCentaurMainScreenWebviewTabData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            TCentaurMainScreenWebviewTabData.decode = function decode(reader, length) {
                if (!(reader instanceof $Reader))
                    reader = $Reader.create(reader);
                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.NAlice.NData.TCentaurMainScreenWebviewTabData();
                while (reader.pos < end) {
                    var tag = reader.uint32();
                    switch (tag >>> 3) {
                    case 1:
                        message.Id = reader.string();
                        break;
                    case 2:
                        message.WebviewUrl = reader.string();
                        break;
                    default:
                        reader.skipType(tag & 7);
                        break;
                    }
                }
                return message;
            };

            /**
             * Decodes a TCentaurMainScreenWebviewTabData message from the specified reader or buffer, length delimited.
             * @function decodeDelimited
             * @memberof NAlice.NData.TCentaurMainScreenWebviewTabData
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @returns {NAlice.NData.TCentaurMainScreenWebviewTabData} TCentaurMainScreenWebviewTabData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            TCentaurMainScreenWebviewTabData.decodeDelimited = function decodeDelimited(reader) {
                if (!(reader instanceof $Reader))
                    reader = new $Reader(reader);
                return this.decode(reader, reader.uint32());
            };

            /**
             * Verifies a TCentaurMainScreenWebviewTabData message.
             * @function verify
             * @memberof NAlice.NData.TCentaurMainScreenWebviewTabData
             * @static
             * @param {Object.<string,*>} message Plain object to verify
             * @returns {string|null} `null` if valid, otherwise the reason why it is not
             */
            TCentaurMainScreenWebviewTabData.verify = function verify(message) {
                if (typeof message !== "object" || message === null)
                    return "object expected";
                if (message.Id != null && message.hasOwnProperty("Id"))
                    if (!$util.isString(message.Id))
                        return "Id: string expected";
                if (message.WebviewUrl != null && message.hasOwnProperty("WebviewUrl"))
                    if (!$util.isString(message.WebviewUrl))
                        return "WebviewUrl: string expected";
                return null;
            };

            /**
             * Creates a TCentaurMainScreenWebviewTabData message from a plain object. Also converts values to their respective internal types.
             * @function fromObject
             * @memberof NAlice.NData.TCentaurMainScreenWebviewTabData
             * @static
             * @param {Object.<string,*>} object Plain object
             * @returns {NAlice.NData.TCentaurMainScreenWebviewTabData} TCentaurMainScreenWebviewTabData
             */
            TCentaurMainScreenWebviewTabData.fromObject = function fromObject(object) {
                if (object instanceof $root.NAlice.NData.TCentaurMainScreenWebviewTabData)
                    return object;
                var message = new $root.NAlice.NData.TCentaurMainScreenWebviewTabData();
                if (object.Id != null)
                    message.Id = String(object.Id);
                if (object.WebviewUrl != null)
                    message.WebviewUrl = String(object.WebviewUrl);
                return message;
            };

            /**
             * Creates a plain object from a TCentaurMainScreenWebviewTabData message. Also converts values to other types if specified.
             * @function toObject
             * @memberof NAlice.NData.TCentaurMainScreenWebviewTabData
             * @static
             * @param {NAlice.NData.TCentaurMainScreenWebviewTabData} message TCentaurMainScreenWebviewTabData
             * @param {$protobuf.IConversionOptions} [options] Conversion options
             * @returns {Object.<string,*>} Plain object
             */
            TCentaurMainScreenWebviewTabData.toObject = function toObject(message, options) {
                if (!options)
                    options = {};
                var object = {};
                if (options.defaults) {
                    object.Id = "";
                    object.WebviewUrl = "";
                }
                if (message.Id != null && message.hasOwnProperty("Id"))
                    object.Id = message.Id;
                if (message.WebviewUrl != null && message.hasOwnProperty("WebviewUrl"))
                    object.WebviewUrl = message.WebviewUrl;
                return object;
            };

            /**
             * Converts this TCentaurMainScreenWebviewTabData to JSON.
             * @function toJSON
             * @memberof NAlice.NData.TCentaurMainScreenWebviewTabData
             * @instance
             * @returns {Object.<string,*>} JSON object
             */
            TCentaurMainScreenWebviewTabData.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            return TCentaurMainScreenWebviewTabData;
        })();

        NData.TCentaurMainScreenDiscoveryTabData = (function() {

            /**
             * Properties of a TCentaurMainScreenDiscoveryTabData.
             * @memberof NAlice.NData
             * @interface ITCentaurMainScreenDiscoveryTabData
             * @property {string|null} [Id] TCentaurMainScreenDiscoveryTabData Id
             */

            /**
             * Constructs a new TCentaurMainScreenDiscoveryTabData.
             * @memberof NAlice.NData
             * @classdesc Represents a TCentaurMainScreenDiscoveryTabData.
             * @implements ITCentaurMainScreenDiscoveryTabData
             * @constructor
             * @param {NAlice.NData.ITCentaurMainScreenDiscoveryTabData=} [properties] Properties to set
             */
            function TCentaurMainScreenDiscoveryTabData(properties) {
                if (properties)
                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                        if (properties[keys[i]] != null)
                            this[keys[i]] = properties[keys[i]];
            }

            /**
             * TCentaurMainScreenDiscoveryTabData Id.
             * @member {string} Id
             * @memberof NAlice.NData.TCentaurMainScreenDiscoveryTabData
             * @instance
             */
            TCentaurMainScreenDiscoveryTabData.prototype.Id = "";

            /**
             * Creates a new TCentaurMainScreenDiscoveryTabData instance using the specified properties.
             * @function create
             * @memberof NAlice.NData.TCentaurMainScreenDiscoveryTabData
             * @static
             * @param {NAlice.NData.ITCentaurMainScreenDiscoveryTabData=} [properties] Properties to set
             * @returns {NAlice.NData.TCentaurMainScreenDiscoveryTabData} TCentaurMainScreenDiscoveryTabData instance
             */
            TCentaurMainScreenDiscoveryTabData.create = function create(properties) {
                return new TCentaurMainScreenDiscoveryTabData(properties);
            };

            /**
             * Encodes the specified TCentaurMainScreenDiscoveryTabData message. Does not implicitly {@link NAlice.NData.TCentaurMainScreenDiscoveryTabData.verify|verify} messages.
             * @function encode
             * @memberof NAlice.NData.TCentaurMainScreenDiscoveryTabData
             * @static
             * @param {NAlice.NData.ITCentaurMainScreenDiscoveryTabData} message TCentaurMainScreenDiscoveryTabData message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            TCentaurMainScreenDiscoveryTabData.encode = function encode(message, writer) {
                if (!writer)
                    writer = $Writer.create();
                if (message.Id != null && Object.hasOwnProperty.call(message, "Id"))
                    writer.uint32(/* id 1, wireType 2 =*/10).string(message.Id);
                return writer;
            };

            /**
             * Encodes the specified TCentaurMainScreenDiscoveryTabData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurMainScreenDiscoveryTabData.verify|verify} messages.
             * @function encodeDelimited
             * @memberof NAlice.NData.TCentaurMainScreenDiscoveryTabData
             * @static
             * @param {NAlice.NData.ITCentaurMainScreenDiscoveryTabData} message TCentaurMainScreenDiscoveryTabData message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            TCentaurMainScreenDiscoveryTabData.encodeDelimited = function encodeDelimited(message, writer) {
                return this.encode(message, writer).ldelim();
            };

            /**
             * Decodes a TCentaurMainScreenDiscoveryTabData message from the specified reader or buffer.
             * @function decode
             * @memberof NAlice.NData.TCentaurMainScreenDiscoveryTabData
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @param {number} [length] Message length if known beforehand
             * @returns {NAlice.NData.TCentaurMainScreenDiscoveryTabData} TCentaurMainScreenDiscoveryTabData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            TCentaurMainScreenDiscoveryTabData.decode = function decode(reader, length) {
                if (!(reader instanceof $Reader))
                    reader = $Reader.create(reader);
                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.NAlice.NData.TCentaurMainScreenDiscoveryTabData();
                while (reader.pos < end) {
                    var tag = reader.uint32();
                    switch (tag >>> 3) {
                    case 1:
                        message.Id = reader.string();
                        break;
                    default:
                        reader.skipType(tag & 7);
                        break;
                    }
                }
                return message;
            };

            /**
             * Decodes a TCentaurMainScreenDiscoveryTabData message from the specified reader or buffer, length delimited.
             * @function decodeDelimited
             * @memberof NAlice.NData.TCentaurMainScreenDiscoveryTabData
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @returns {NAlice.NData.TCentaurMainScreenDiscoveryTabData} TCentaurMainScreenDiscoveryTabData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            TCentaurMainScreenDiscoveryTabData.decodeDelimited = function decodeDelimited(reader) {
                if (!(reader instanceof $Reader))
                    reader = new $Reader(reader);
                return this.decode(reader, reader.uint32());
            };

            /**
             * Verifies a TCentaurMainScreenDiscoveryTabData message.
             * @function verify
             * @memberof NAlice.NData.TCentaurMainScreenDiscoveryTabData
             * @static
             * @param {Object.<string,*>} message Plain object to verify
             * @returns {string|null} `null` if valid, otherwise the reason why it is not
             */
            TCentaurMainScreenDiscoveryTabData.verify = function verify(message) {
                if (typeof message !== "object" || message === null)
                    return "object expected";
                if (message.Id != null && message.hasOwnProperty("Id"))
                    if (!$util.isString(message.Id))
                        return "Id: string expected";
                return null;
            };

            /**
             * Creates a TCentaurMainScreenDiscoveryTabData message from a plain object. Also converts values to their respective internal types.
             * @function fromObject
             * @memberof NAlice.NData.TCentaurMainScreenDiscoveryTabData
             * @static
             * @param {Object.<string,*>} object Plain object
             * @returns {NAlice.NData.TCentaurMainScreenDiscoveryTabData} TCentaurMainScreenDiscoveryTabData
             */
            TCentaurMainScreenDiscoveryTabData.fromObject = function fromObject(object) {
                if (object instanceof $root.NAlice.NData.TCentaurMainScreenDiscoveryTabData)
                    return object;
                var message = new $root.NAlice.NData.TCentaurMainScreenDiscoveryTabData();
                if (object.Id != null)
                    message.Id = String(object.Id);
                return message;
            };

            /**
             * Creates a plain object from a TCentaurMainScreenDiscoveryTabData message. Also converts values to other types if specified.
             * @function toObject
             * @memberof NAlice.NData.TCentaurMainScreenDiscoveryTabData
             * @static
             * @param {NAlice.NData.TCentaurMainScreenDiscoveryTabData} message TCentaurMainScreenDiscoveryTabData
             * @param {$protobuf.IConversionOptions} [options] Conversion options
             * @returns {Object.<string,*>} Plain object
             */
            TCentaurMainScreenDiscoveryTabData.toObject = function toObject(message, options) {
                if (!options)
                    options = {};
                var object = {};
                if (options.defaults)
                    object.Id = "";
                if (message.Id != null && message.hasOwnProperty("Id"))
                    object.Id = message.Id;
                return object;
            };

            /**
             * Converts this TCentaurMainScreenDiscoveryTabData to JSON.
             * @function toJSON
             * @memberof NAlice.NData.TCentaurMainScreenDiscoveryTabData
             * @instance
             * @returns {Object.<string,*>} JSON object
             */
            TCentaurMainScreenDiscoveryTabData.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            return TCentaurMainScreenDiscoveryTabData;
        })();

        NData.TCentaurMainScreenServicesTabData = (function() {

            /**
             * Properties of a TCentaurMainScreenServicesTabData.
             * @memberof NAlice.NData
             * @interface ITCentaurMainScreenServicesTabData
             * @property {string|null} [Id] TCentaurMainScreenServicesTabData Id
             * @property {Array.<NAlice.NData.ITCentaurMainScreenWebviewCardData>|null} [CentaurMainScreenWebviewCardData] TCentaurMainScreenServicesTabData CentaurMainScreenWebviewCardData
             */

            /**
             * Constructs a new TCentaurMainScreenServicesTabData.
             * @memberof NAlice.NData
             * @classdesc Represents a TCentaurMainScreenServicesTabData.
             * @implements ITCentaurMainScreenServicesTabData
             * @constructor
             * @param {NAlice.NData.ITCentaurMainScreenServicesTabData=} [properties] Properties to set
             */
            function TCentaurMainScreenServicesTabData(properties) {
                this.CentaurMainScreenWebviewCardData = [];
                if (properties)
                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                        if (properties[keys[i]] != null)
                            this[keys[i]] = properties[keys[i]];
            }

            /**
             * TCentaurMainScreenServicesTabData Id.
             * @member {string} Id
             * @memberof NAlice.NData.TCentaurMainScreenServicesTabData
             * @instance
             */
            TCentaurMainScreenServicesTabData.prototype.Id = "";

            /**
             * TCentaurMainScreenServicesTabData CentaurMainScreenWebviewCardData.
             * @member {Array.<NAlice.NData.ITCentaurMainScreenWebviewCardData>} CentaurMainScreenWebviewCardData
             * @memberof NAlice.NData.TCentaurMainScreenServicesTabData
             * @instance
             */
            TCentaurMainScreenServicesTabData.prototype.CentaurMainScreenWebviewCardData = $util.emptyArray;

            /**
             * Creates a new TCentaurMainScreenServicesTabData instance using the specified properties.
             * @function create
             * @memberof NAlice.NData.TCentaurMainScreenServicesTabData
             * @static
             * @param {NAlice.NData.ITCentaurMainScreenServicesTabData=} [properties] Properties to set
             * @returns {NAlice.NData.TCentaurMainScreenServicesTabData} TCentaurMainScreenServicesTabData instance
             */
            TCentaurMainScreenServicesTabData.create = function create(properties) {
                return new TCentaurMainScreenServicesTabData(properties);
            };

            /**
             * Encodes the specified TCentaurMainScreenServicesTabData message. Does not implicitly {@link NAlice.NData.TCentaurMainScreenServicesTabData.verify|verify} messages.
             * @function encode
             * @memberof NAlice.NData.TCentaurMainScreenServicesTabData
             * @static
             * @param {NAlice.NData.ITCentaurMainScreenServicesTabData} message TCentaurMainScreenServicesTabData message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            TCentaurMainScreenServicesTabData.encode = function encode(message, writer) {
                if (!writer)
                    writer = $Writer.create();
                if (message.Id != null && Object.hasOwnProperty.call(message, "Id"))
                    writer.uint32(/* id 1, wireType 2 =*/10).string(message.Id);
                if (message.CentaurMainScreenWebviewCardData != null && message.CentaurMainScreenWebviewCardData.length)
                    for (var i = 0; i < message.CentaurMainScreenWebviewCardData.length; ++i)
                        $root.NAlice.NData.TCentaurMainScreenWebviewCardData.encode(message.CentaurMainScreenWebviewCardData[i], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                return writer;
            };

            /**
             * Encodes the specified TCentaurMainScreenServicesTabData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurMainScreenServicesTabData.verify|verify} messages.
             * @function encodeDelimited
             * @memberof NAlice.NData.TCentaurMainScreenServicesTabData
             * @static
             * @param {NAlice.NData.ITCentaurMainScreenServicesTabData} message TCentaurMainScreenServicesTabData message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            TCentaurMainScreenServicesTabData.encodeDelimited = function encodeDelimited(message, writer) {
                return this.encode(message, writer).ldelim();
            };

            /**
             * Decodes a TCentaurMainScreenServicesTabData message from the specified reader or buffer.
             * @function decode
             * @memberof NAlice.NData.TCentaurMainScreenServicesTabData
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @param {number} [length] Message length if known beforehand
             * @returns {NAlice.NData.TCentaurMainScreenServicesTabData} TCentaurMainScreenServicesTabData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            TCentaurMainScreenServicesTabData.decode = function decode(reader, length) {
                if (!(reader instanceof $Reader))
                    reader = $Reader.create(reader);
                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.NAlice.NData.TCentaurMainScreenServicesTabData();
                while (reader.pos < end) {
                    var tag = reader.uint32();
                    switch (tag >>> 3) {
                    case 1:
                        message.Id = reader.string();
                        break;
                    case 2:
                        if (!(message.CentaurMainScreenWebviewCardData && message.CentaurMainScreenWebviewCardData.length))
                            message.CentaurMainScreenWebviewCardData = [];
                        message.CentaurMainScreenWebviewCardData.push($root.NAlice.NData.TCentaurMainScreenWebviewCardData.decode(reader, reader.uint32()));
                        break;
                    default:
                        reader.skipType(tag & 7);
                        break;
                    }
                }
                return message;
            };

            /**
             * Decodes a TCentaurMainScreenServicesTabData message from the specified reader or buffer, length delimited.
             * @function decodeDelimited
             * @memberof NAlice.NData.TCentaurMainScreenServicesTabData
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @returns {NAlice.NData.TCentaurMainScreenServicesTabData} TCentaurMainScreenServicesTabData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            TCentaurMainScreenServicesTabData.decodeDelimited = function decodeDelimited(reader) {
                if (!(reader instanceof $Reader))
                    reader = new $Reader(reader);
                return this.decode(reader, reader.uint32());
            };

            /**
             * Verifies a TCentaurMainScreenServicesTabData message.
             * @function verify
             * @memberof NAlice.NData.TCentaurMainScreenServicesTabData
             * @static
             * @param {Object.<string,*>} message Plain object to verify
             * @returns {string|null} `null` if valid, otherwise the reason why it is not
             */
            TCentaurMainScreenServicesTabData.verify = function verify(message) {
                if (typeof message !== "object" || message === null)
                    return "object expected";
                if (message.Id != null && message.hasOwnProperty("Id"))
                    if (!$util.isString(message.Id))
                        return "Id: string expected";
                if (message.CentaurMainScreenWebviewCardData != null && message.hasOwnProperty("CentaurMainScreenWebviewCardData")) {
                    if (!Array.isArray(message.CentaurMainScreenWebviewCardData))
                        return "CentaurMainScreenWebviewCardData: array expected";
                    for (var i = 0; i < message.CentaurMainScreenWebviewCardData.length; ++i) {
                        var error = $root.NAlice.NData.TCentaurMainScreenWebviewCardData.verify(message.CentaurMainScreenWebviewCardData[i]);
                        if (error)
                            return "CentaurMainScreenWebviewCardData." + error;
                    }
                }
                return null;
            };

            /**
             * Creates a TCentaurMainScreenServicesTabData message from a plain object. Also converts values to their respective internal types.
             * @function fromObject
             * @memberof NAlice.NData.TCentaurMainScreenServicesTabData
             * @static
             * @param {Object.<string,*>} object Plain object
             * @returns {NAlice.NData.TCentaurMainScreenServicesTabData} TCentaurMainScreenServicesTabData
             */
            TCentaurMainScreenServicesTabData.fromObject = function fromObject(object) {
                if (object instanceof $root.NAlice.NData.TCentaurMainScreenServicesTabData)
                    return object;
                var message = new $root.NAlice.NData.TCentaurMainScreenServicesTabData();
                if (object.Id != null)
                    message.Id = String(object.Id);
                if (object.CentaurMainScreenWebviewCardData) {
                    if (!Array.isArray(object.CentaurMainScreenWebviewCardData))
                        throw TypeError(".NAlice.NData.TCentaurMainScreenServicesTabData.CentaurMainScreenWebviewCardData: array expected");
                    message.CentaurMainScreenWebviewCardData = [];
                    for (var i = 0; i < object.CentaurMainScreenWebviewCardData.length; ++i) {
                        if (typeof object.CentaurMainScreenWebviewCardData[i] !== "object")
                            throw TypeError(".NAlice.NData.TCentaurMainScreenServicesTabData.CentaurMainScreenWebviewCardData: object expected");
                        message.CentaurMainScreenWebviewCardData[i] = $root.NAlice.NData.TCentaurMainScreenWebviewCardData.fromObject(object.CentaurMainScreenWebviewCardData[i]);
                    }
                }
                return message;
            };

            /**
             * Creates a plain object from a TCentaurMainScreenServicesTabData message. Also converts values to other types if specified.
             * @function toObject
             * @memberof NAlice.NData.TCentaurMainScreenServicesTabData
             * @static
             * @param {NAlice.NData.TCentaurMainScreenServicesTabData} message TCentaurMainScreenServicesTabData
             * @param {$protobuf.IConversionOptions} [options] Conversion options
             * @returns {Object.<string,*>} Plain object
             */
            TCentaurMainScreenServicesTabData.toObject = function toObject(message, options) {
                if (!options)
                    options = {};
                var object = {};
                if (options.arrays || options.defaults)
                    object.CentaurMainScreenWebviewCardData = [];
                if (options.defaults)
                    object.Id = "";
                if (message.Id != null && message.hasOwnProperty("Id"))
                    object.Id = message.Id;
                if (message.CentaurMainScreenWebviewCardData && message.CentaurMainScreenWebviewCardData.length) {
                    object.CentaurMainScreenWebviewCardData = [];
                    for (var j = 0; j < message.CentaurMainScreenWebviewCardData.length; ++j)
                        object.CentaurMainScreenWebviewCardData[j] = $root.NAlice.NData.TCentaurMainScreenWebviewCardData.toObject(message.CentaurMainScreenWebviewCardData[j], options);
                }
                return object;
            };

            /**
             * Converts this TCentaurMainScreenServicesTabData to JSON.
             * @function toJSON
             * @memberof NAlice.NData.TCentaurMainScreenServicesTabData
             * @instance
             * @returns {Object.<string,*>} JSON object
             */
            TCentaurMainScreenServicesTabData.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            return TCentaurMainScreenServicesTabData;
        })();

        NData.TCentaurMainScreenSmartHomeTabData = (function() {

            /**
             * Properties of a TCentaurMainScreenSmartHomeTabData.
             * @memberof NAlice.NData
             * @interface ITCentaurMainScreenSmartHomeTabData
             * @property {string|null} [Id] TCentaurMainScreenSmartHomeTabData Id
             * @property {NAlice.ITIoTUserInfo|null} [IoTUserData] TCentaurMainScreenSmartHomeTabData IoTUserData
             */

            /**
             * Constructs a new TCentaurMainScreenSmartHomeTabData.
             * @memberof NAlice.NData
             * @classdesc Represents a TCentaurMainScreenSmartHomeTabData.
             * @implements ITCentaurMainScreenSmartHomeTabData
             * @constructor
             * @param {NAlice.NData.ITCentaurMainScreenSmartHomeTabData=} [properties] Properties to set
             */
            function TCentaurMainScreenSmartHomeTabData(properties) {
                if (properties)
                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                        if (properties[keys[i]] != null)
                            this[keys[i]] = properties[keys[i]];
            }

            /**
             * TCentaurMainScreenSmartHomeTabData Id.
             * @member {string} Id
             * @memberof NAlice.NData.TCentaurMainScreenSmartHomeTabData
             * @instance
             */
            TCentaurMainScreenSmartHomeTabData.prototype.Id = "";

            /**
             * TCentaurMainScreenSmartHomeTabData IoTUserData.
             * @member {NAlice.ITIoTUserInfo|null|undefined} IoTUserData
             * @memberof NAlice.NData.TCentaurMainScreenSmartHomeTabData
             * @instance
             */
            TCentaurMainScreenSmartHomeTabData.prototype.IoTUserData = null;

            /**
             * Creates a new TCentaurMainScreenSmartHomeTabData instance using the specified properties.
             * @function create
             * @memberof NAlice.NData.TCentaurMainScreenSmartHomeTabData
             * @static
             * @param {NAlice.NData.ITCentaurMainScreenSmartHomeTabData=} [properties] Properties to set
             * @returns {NAlice.NData.TCentaurMainScreenSmartHomeTabData} TCentaurMainScreenSmartHomeTabData instance
             */
            TCentaurMainScreenSmartHomeTabData.create = function create(properties) {
                return new TCentaurMainScreenSmartHomeTabData(properties);
            };

            /**
             * Encodes the specified TCentaurMainScreenSmartHomeTabData message. Does not implicitly {@link NAlice.NData.TCentaurMainScreenSmartHomeTabData.verify|verify} messages.
             * @function encode
             * @memberof NAlice.NData.TCentaurMainScreenSmartHomeTabData
             * @static
             * @param {NAlice.NData.ITCentaurMainScreenSmartHomeTabData} message TCentaurMainScreenSmartHomeTabData message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            TCentaurMainScreenSmartHomeTabData.encode = function encode(message, writer) {
                if (!writer)
                    writer = $Writer.create();
                if (message.Id != null && Object.hasOwnProperty.call(message, "Id"))
                    writer.uint32(/* id 1, wireType 2 =*/10).string(message.Id);
                if (message.IoTUserData != null && Object.hasOwnProperty.call(message, "IoTUserData"))
                    $root.NAlice.TIoTUserInfo.encode(message.IoTUserData, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                return writer;
            };

            /**
             * Encodes the specified TCentaurMainScreenSmartHomeTabData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurMainScreenSmartHomeTabData.verify|verify} messages.
             * @function encodeDelimited
             * @memberof NAlice.NData.TCentaurMainScreenSmartHomeTabData
             * @static
             * @param {NAlice.NData.ITCentaurMainScreenSmartHomeTabData} message TCentaurMainScreenSmartHomeTabData message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            TCentaurMainScreenSmartHomeTabData.encodeDelimited = function encodeDelimited(message, writer) {
                return this.encode(message, writer).ldelim();
            };

            /**
             * Decodes a TCentaurMainScreenSmartHomeTabData message from the specified reader or buffer.
             * @function decode
             * @memberof NAlice.NData.TCentaurMainScreenSmartHomeTabData
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @param {number} [length] Message length if known beforehand
             * @returns {NAlice.NData.TCentaurMainScreenSmartHomeTabData} TCentaurMainScreenSmartHomeTabData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            TCentaurMainScreenSmartHomeTabData.decode = function decode(reader, length) {
                if (!(reader instanceof $Reader))
                    reader = $Reader.create(reader);
                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.NAlice.NData.TCentaurMainScreenSmartHomeTabData();
                while (reader.pos < end) {
                    var tag = reader.uint32();
                    switch (tag >>> 3) {
                    case 1:
                        message.Id = reader.string();
                        break;
                    case 2:
                        message.IoTUserData = $root.NAlice.TIoTUserInfo.decode(reader, reader.uint32());
                        break;
                    default:
                        reader.skipType(tag & 7);
                        break;
                    }
                }
                return message;
            };

            /**
             * Decodes a TCentaurMainScreenSmartHomeTabData message from the specified reader or buffer, length delimited.
             * @function decodeDelimited
             * @memberof NAlice.NData.TCentaurMainScreenSmartHomeTabData
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @returns {NAlice.NData.TCentaurMainScreenSmartHomeTabData} TCentaurMainScreenSmartHomeTabData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            TCentaurMainScreenSmartHomeTabData.decodeDelimited = function decodeDelimited(reader) {
                if (!(reader instanceof $Reader))
                    reader = new $Reader(reader);
                return this.decode(reader, reader.uint32());
            };

            /**
             * Verifies a TCentaurMainScreenSmartHomeTabData message.
             * @function verify
             * @memberof NAlice.NData.TCentaurMainScreenSmartHomeTabData
             * @static
             * @param {Object.<string,*>} message Plain object to verify
             * @returns {string|null} `null` if valid, otherwise the reason why it is not
             */
            TCentaurMainScreenSmartHomeTabData.verify = function verify(message) {
                if (typeof message !== "object" || message === null)
                    return "object expected";
                if (message.Id != null && message.hasOwnProperty("Id"))
                    if (!$util.isString(message.Id))
                        return "Id: string expected";
                if (message.IoTUserData != null && message.hasOwnProperty("IoTUserData")) {
                    var error = $root.NAlice.TIoTUserInfo.verify(message.IoTUserData);
                    if (error)
                        return "IoTUserData." + error;
                }
                return null;
            };

            /**
             * Creates a TCentaurMainScreenSmartHomeTabData message from a plain object. Also converts values to their respective internal types.
             * @function fromObject
             * @memberof NAlice.NData.TCentaurMainScreenSmartHomeTabData
             * @static
             * @param {Object.<string,*>} object Plain object
             * @returns {NAlice.NData.TCentaurMainScreenSmartHomeTabData} TCentaurMainScreenSmartHomeTabData
             */
            TCentaurMainScreenSmartHomeTabData.fromObject = function fromObject(object) {
                if (object instanceof $root.NAlice.NData.TCentaurMainScreenSmartHomeTabData)
                    return object;
                var message = new $root.NAlice.NData.TCentaurMainScreenSmartHomeTabData();
                if (object.Id != null)
                    message.Id = String(object.Id);
                if (object.IoTUserData != null) {
                    if (typeof object.IoTUserData !== "object")
                        throw TypeError(".NAlice.NData.TCentaurMainScreenSmartHomeTabData.IoTUserData: object expected");
                    message.IoTUserData = $root.NAlice.TIoTUserInfo.fromObject(object.IoTUserData);
                }
                return message;
            };

            /**
             * Creates a plain object from a TCentaurMainScreenSmartHomeTabData message. Also converts values to other types if specified.
             * @function toObject
             * @memberof NAlice.NData.TCentaurMainScreenSmartHomeTabData
             * @static
             * @param {NAlice.NData.TCentaurMainScreenSmartHomeTabData} message TCentaurMainScreenSmartHomeTabData
             * @param {$protobuf.IConversionOptions} [options] Conversion options
             * @returns {Object.<string,*>} Plain object
             */
            TCentaurMainScreenSmartHomeTabData.toObject = function toObject(message, options) {
                if (!options)
                    options = {};
                var object = {};
                if (options.defaults) {
                    object.Id = "";
                    object.IoTUserData = null;
                }
                if (message.Id != null && message.hasOwnProperty("Id"))
                    object.Id = message.Id;
                if (message.IoTUserData != null && message.hasOwnProperty("IoTUserData"))
                    object.IoTUserData = $root.NAlice.TIoTUserInfo.toObject(message.IoTUserData, options);
                return object;
            };

            /**
             * Converts this TCentaurMainScreenSmartHomeTabData to JSON.
             * @function toJSON
             * @memberof NAlice.NData.TCentaurMainScreenSmartHomeTabData
             * @instance
             * @returns {Object.<string,*>} JSON object
             */
            TCentaurMainScreenSmartHomeTabData.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            return TCentaurMainScreenSmartHomeTabData;
        })();

        NData.TCentaurWidgetCardData = (function() {

            /**
             * Properties of a TCentaurWidgetCardData.
             * @memberof NAlice.NData
             * @interface ITCentaurWidgetCardData
             * @property {string|null} [Id] TCentaurWidgetCardData Id
             * @property {string|null} [Action] TCentaurWidgetCardData Action
             * @property {NAlice.NData.TCentaurWidgetCardData.ITInfoCardData|null} [InfoCardData] TCentaurWidgetCardData InfoCardData
             * @property {NAlice.NData.TCentaurWidgetCardData.ITMusicCardData|null} [MusicCardData] TCentaurWidgetCardData MusicCardData
             * @property {NAlice.NData.TCentaurWidgetCardData.ITNewsCardData|null} [NewsCardData] TCentaurWidgetCardData NewsCardData
             * @property {NAlice.NData.TCentaurWidgetCardData.ITWeatherCardData|null} [WeatherCardData] TCentaurWidgetCardData WeatherCardData
             * @property {NAlice.NData.TCentaurWidgetCardData.ITYouTubeCardData|null} [YouTubeCardData] TCentaurWidgetCardData YouTubeCardData
             * @property {NAlice.NData.TCentaurWidgetCardData.ITVacantCardData|null} [VacantCardData] TCentaurWidgetCardData VacantCardData
             * @property {NAlice.NData.TCentaurWidgetCardData.ITTrafficCardData|null} [TrafficCardData] TCentaurWidgetCardData TrafficCardData
             * @property {NAlice.NData.TCentaurWidgetCardData.ITVideoCallCardData|null} [VideoCallCardData] TCentaurWidgetCardData VideoCallCardData
             * @property {NAlice.NData.TCentaurWidgetCardData.ITExternalSkillCardData|null} [ExternalSkillCardData] TCentaurWidgetCardData ExternalSkillCardData
             * @property {string|null} [LongTapAction] TCentaurWidgetCardData LongTapAction
             * @property {string|null} [DeleteWidgetAction] TCentaurWidgetCardData DeleteWidgetAction
             * @property {NAlice.NData.ITWidgetPosition|null} [MainScreenPosition] TCentaurWidgetCardData MainScreenPosition
             * @property {google.protobuf.IAny|null} [TypedAction] TCentaurWidgetCardData TypedAction
             * @property {google.protobuf.IAny|null} [LongTapTypedAction] TCentaurWidgetCardData LongTapTypedAction
             * @property {google.protobuf.IAny|null} [DeleteWidgetTypedAction] TCentaurWidgetCardData DeleteWidgetTypedAction
             */

            /**
             * Constructs a new TCentaurWidgetCardData.
             * @memberof NAlice.NData
             * @classdesc Represents a TCentaurWidgetCardData.
             * @implements ITCentaurWidgetCardData
             * @constructor
             * @param {NAlice.NData.ITCentaurWidgetCardData=} [properties] Properties to set
             */
            function TCentaurWidgetCardData(properties) {
                if (properties)
                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                        if (properties[keys[i]] != null)
                            this[keys[i]] = properties[keys[i]];
            }

            /**
             * TCentaurWidgetCardData Id.
             * @member {string} Id
             * @memberof NAlice.NData.TCentaurWidgetCardData
             * @instance
             */
            TCentaurWidgetCardData.prototype.Id = "";

            /**
             * TCentaurWidgetCardData Action.
             * @member {string} Action
             * @memberof NAlice.NData.TCentaurWidgetCardData
             * @instance
             */
            TCentaurWidgetCardData.prototype.Action = "";

            /**
             * TCentaurWidgetCardData InfoCardData.
             * @member {NAlice.NData.TCentaurWidgetCardData.ITInfoCardData|null|undefined} InfoCardData
             * @memberof NAlice.NData.TCentaurWidgetCardData
             * @instance
             */
            TCentaurWidgetCardData.prototype.InfoCardData = null;

            /**
             * TCentaurWidgetCardData MusicCardData.
             * @member {NAlice.NData.TCentaurWidgetCardData.ITMusicCardData|null|undefined} MusicCardData
             * @memberof NAlice.NData.TCentaurWidgetCardData
             * @instance
             */
            TCentaurWidgetCardData.prototype.MusicCardData = null;

            /**
             * TCentaurWidgetCardData NewsCardData.
             * @member {NAlice.NData.TCentaurWidgetCardData.ITNewsCardData|null|undefined} NewsCardData
             * @memberof NAlice.NData.TCentaurWidgetCardData
             * @instance
             */
            TCentaurWidgetCardData.prototype.NewsCardData = null;

            /**
             * TCentaurWidgetCardData WeatherCardData.
             * @member {NAlice.NData.TCentaurWidgetCardData.ITWeatherCardData|null|undefined} WeatherCardData
             * @memberof NAlice.NData.TCentaurWidgetCardData
             * @instance
             */
            TCentaurWidgetCardData.prototype.WeatherCardData = null;

            /**
             * TCentaurWidgetCardData YouTubeCardData.
             * @member {NAlice.NData.TCentaurWidgetCardData.ITYouTubeCardData|null|undefined} YouTubeCardData
             * @memberof NAlice.NData.TCentaurWidgetCardData
             * @instance
             */
            TCentaurWidgetCardData.prototype.YouTubeCardData = null;

            /**
             * TCentaurWidgetCardData VacantCardData.
             * @member {NAlice.NData.TCentaurWidgetCardData.ITVacantCardData|null|undefined} VacantCardData
             * @memberof NAlice.NData.TCentaurWidgetCardData
             * @instance
             */
            TCentaurWidgetCardData.prototype.VacantCardData = null;

            /**
             * TCentaurWidgetCardData TrafficCardData.
             * @member {NAlice.NData.TCentaurWidgetCardData.ITTrafficCardData|null|undefined} TrafficCardData
             * @memberof NAlice.NData.TCentaurWidgetCardData
             * @instance
             */
            TCentaurWidgetCardData.prototype.TrafficCardData = null;

            /**
             * TCentaurWidgetCardData VideoCallCardData.
             * @member {NAlice.NData.TCentaurWidgetCardData.ITVideoCallCardData|null|undefined} VideoCallCardData
             * @memberof NAlice.NData.TCentaurWidgetCardData
             * @instance
             */
            TCentaurWidgetCardData.prototype.VideoCallCardData = null;

            /**
             * TCentaurWidgetCardData ExternalSkillCardData.
             * @member {NAlice.NData.TCentaurWidgetCardData.ITExternalSkillCardData|null|undefined} ExternalSkillCardData
             * @memberof NAlice.NData.TCentaurWidgetCardData
             * @instance
             */
            TCentaurWidgetCardData.prototype.ExternalSkillCardData = null;

            /**
             * TCentaurWidgetCardData LongTapAction.
             * @member {string} LongTapAction
             * @memberof NAlice.NData.TCentaurWidgetCardData
             * @instance
             */
            TCentaurWidgetCardData.prototype.LongTapAction = "";

            /**
             * TCentaurWidgetCardData DeleteWidgetAction.
             * @member {string} DeleteWidgetAction
             * @memberof NAlice.NData.TCentaurWidgetCardData
             * @instance
             */
            TCentaurWidgetCardData.prototype.DeleteWidgetAction = "";

            /**
             * TCentaurWidgetCardData MainScreenPosition.
             * @member {NAlice.NData.ITWidgetPosition|null|undefined} MainScreenPosition
             * @memberof NAlice.NData.TCentaurWidgetCardData
             * @instance
             */
            TCentaurWidgetCardData.prototype.MainScreenPosition = null;

            /**
             * TCentaurWidgetCardData TypedAction.
             * @member {google.protobuf.IAny|null|undefined} TypedAction
             * @memberof NAlice.NData.TCentaurWidgetCardData
             * @instance
             */
            TCentaurWidgetCardData.prototype.TypedAction = null;

            /**
             * TCentaurWidgetCardData LongTapTypedAction.
             * @member {google.protobuf.IAny|null|undefined} LongTapTypedAction
             * @memberof NAlice.NData.TCentaurWidgetCardData
             * @instance
             */
            TCentaurWidgetCardData.prototype.LongTapTypedAction = null;

            /**
             * TCentaurWidgetCardData DeleteWidgetTypedAction.
             * @member {google.protobuf.IAny|null|undefined} DeleteWidgetTypedAction
             * @memberof NAlice.NData.TCentaurWidgetCardData
             * @instance
             */
            TCentaurWidgetCardData.prototype.DeleteWidgetTypedAction = null;

            // OneOf field names bound to virtual getters and setters
            var $oneOfFields;

            /**
             * TCentaurWidgetCardData CardData.
             * @member {"InfoCardData"|"MusicCardData"|"NewsCardData"|"WeatherCardData"|"YouTubeCardData"|"VacantCardData"|"TrafficCardData"|"VideoCallCardData"|"ExternalSkillCardData"|undefined} CardData
             * @memberof NAlice.NData.TCentaurWidgetCardData
             * @instance
             */
            Object.defineProperty(TCentaurWidgetCardData.prototype, "CardData", {
                get: $util.oneOfGetter($oneOfFields = ["InfoCardData", "MusicCardData", "NewsCardData", "WeatherCardData", "YouTubeCardData", "VacantCardData", "TrafficCardData", "VideoCallCardData", "ExternalSkillCardData"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            /**
             * Creates a new TCentaurWidgetCardData instance using the specified properties.
             * @function create
             * @memberof NAlice.NData.TCentaurWidgetCardData
             * @static
             * @param {NAlice.NData.ITCentaurWidgetCardData=} [properties] Properties to set
             * @returns {NAlice.NData.TCentaurWidgetCardData} TCentaurWidgetCardData instance
             */
            TCentaurWidgetCardData.create = function create(properties) {
                return new TCentaurWidgetCardData(properties);
            };

            /**
             * Encodes the specified TCentaurWidgetCardData message. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardData.verify|verify} messages.
             * @function encode
             * @memberof NAlice.NData.TCentaurWidgetCardData
             * @static
             * @param {NAlice.NData.ITCentaurWidgetCardData} message TCentaurWidgetCardData message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            TCentaurWidgetCardData.encode = function encode(message, writer) {
                if (!writer)
                    writer = $Writer.create();
                if (message.Id != null && Object.hasOwnProperty.call(message, "Id"))
                    writer.uint32(/* id 1, wireType 2 =*/10).string(message.Id);
                if (message.Action != null && Object.hasOwnProperty.call(message, "Action"))
                    writer.uint32(/* id 2, wireType 2 =*/18).string(message.Action);
                if (message.InfoCardData != null && Object.hasOwnProperty.call(message, "InfoCardData"))
                    $root.NAlice.NData.TCentaurWidgetCardData.TInfoCardData.encode(message.InfoCardData, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                if (message.MusicCardData != null && Object.hasOwnProperty.call(message, "MusicCardData"))
                    $root.NAlice.NData.TCentaurWidgetCardData.TMusicCardData.encode(message.MusicCardData, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
                if (message.NewsCardData != null && Object.hasOwnProperty.call(message, "NewsCardData"))
                    $root.NAlice.NData.TCentaurWidgetCardData.TNewsCardData.encode(message.NewsCardData, writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
                if (message.WeatherCardData != null && Object.hasOwnProperty.call(message, "WeatherCardData"))
                    $root.NAlice.NData.TCentaurWidgetCardData.TWeatherCardData.encode(message.WeatherCardData, writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
                if (message.YouTubeCardData != null && Object.hasOwnProperty.call(message, "YouTubeCardData"))
                    $root.NAlice.NData.TCentaurWidgetCardData.TYouTubeCardData.encode(message.YouTubeCardData, writer.uint32(/* id 7, wireType 2 =*/58).fork()).ldelim();
                if (message.VacantCardData != null && Object.hasOwnProperty.call(message, "VacantCardData"))
                    $root.NAlice.NData.TCentaurWidgetCardData.TVacantCardData.encode(message.VacantCardData, writer.uint32(/* id 8, wireType 2 =*/66).fork()).ldelim();
                if (message.LongTapAction != null && Object.hasOwnProperty.call(message, "LongTapAction"))
                    writer.uint32(/* id 9, wireType 2 =*/74).string(message.LongTapAction);
                if (message.TrafficCardData != null && Object.hasOwnProperty.call(message, "TrafficCardData"))
                    $root.NAlice.NData.TCentaurWidgetCardData.TTrafficCardData.encode(message.TrafficCardData, writer.uint32(/* id 10, wireType 2 =*/82).fork()).ldelim();
                if (message.VideoCallCardData != null && Object.hasOwnProperty.call(message, "VideoCallCardData"))
                    $root.NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.encode(message.VideoCallCardData, writer.uint32(/* id 11, wireType 2 =*/90).fork()).ldelim();
                if (message.ExternalSkillCardData != null && Object.hasOwnProperty.call(message, "ExternalSkillCardData"))
                    $root.NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.encode(message.ExternalSkillCardData, writer.uint32(/* id 12, wireType 2 =*/98).fork()).ldelim();
                if (message.DeleteWidgetAction != null && Object.hasOwnProperty.call(message, "DeleteWidgetAction"))
                    writer.uint32(/* id 13, wireType 2 =*/106).string(message.DeleteWidgetAction);
                if (message.MainScreenPosition != null && Object.hasOwnProperty.call(message, "MainScreenPosition"))
                    $root.NAlice.NData.TWidgetPosition.encode(message.MainScreenPosition, writer.uint32(/* id 14, wireType 2 =*/114).fork()).ldelim();
                if (message.TypedAction != null && Object.hasOwnProperty.call(message, "TypedAction"))
                    $root.google.protobuf.Any.encode(message.TypedAction, writer.uint32(/* id 15, wireType 2 =*/122).fork()).ldelim();
                if (message.LongTapTypedAction != null && Object.hasOwnProperty.call(message, "LongTapTypedAction"))
                    $root.google.protobuf.Any.encode(message.LongTapTypedAction, writer.uint32(/* id 16, wireType 2 =*/130).fork()).ldelim();
                if (message.DeleteWidgetTypedAction != null && Object.hasOwnProperty.call(message, "DeleteWidgetTypedAction"))
                    $root.google.protobuf.Any.encode(message.DeleteWidgetTypedAction, writer.uint32(/* id 17, wireType 2 =*/138).fork()).ldelim();
                return writer;
            };

            /**
             * Encodes the specified TCentaurWidgetCardData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardData.verify|verify} messages.
             * @function encodeDelimited
             * @memberof NAlice.NData.TCentaurWidgetCardData
             * @static
             * @param {NAlice.NData.ITCentaurWidgetCardData} message TCentaurWidgetCardData message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            TCentaurWidgetCardData.encodeDelimited = function encodeDelimited(message, writer) {
                return this.encode(message, writer).ldelim();
            };

            /**
             * Decodes a TCentaurWidgetCardData message from the specified reader or buffer.
             * @function decode
             * @memberof NAlice.NData.TCentaurWidgetCardData
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @param {number} [length] Message length if known beforehand
             * @returns {NAlice.NData.TCentaurWidgetCardData} TCentaurWidgetCardData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            TCentaurWidgetCardData.decode = function decode(reader, length) {
                if (!(reader instanceof $Reader))
                    reader = $Reader.create(reader);
                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.NAlice.NData.TCentaurWidgetCardData();
                while (reader.pos < end) {
                    var tag = reader.uint32();
                    switch (tag >>> 3) {
                    case 1:
                        message.Id = reader.string();
                        break;
                    case 2:
                        message.Action = reader.string();
                        break;
                    case 3:
                        message.InfoCardData = $root.NAlice.NData.TCentaurWidgetCardData.TInfoCardData.decode(reader, reader.uint32());
                        break;
                    case 4:
                        message.MusicCardData = $root.NAlice.NData.TCentaurWidgetCardData.TMusicCardData.decode(reader, reader.uint32());
                        break;
                    case 5:
                        message.NewsCardData = $root.NAlice.NData.TCentaurWidgetCardData.TNewsCardData.decode(reader, reader.uint32());
                        break;
                    case 6:
                        message.WeatherCardData = $root.NAlice.NData.TCentaurWidgetCardData.TWeatherCardData.decode(reader, reader.uint32());
                        break;
                    case 7:
                        message.YouTubeCardData = $root.NAlice.NData.TCentaurWidgetCardData.TYouTubeCardData.decode(reader, reader.uint32());
                        break;
                    case 8:
                        message.VacantCardData = $root.NAlice.NData.TCentaurWidgetCardData.TVacantCardData.decode(reader, reader.uint32());
                        break;
                    case 10:
                        message.TrafficCardData = $root.NAlice.NData.TCentaurWidgetCardData.TTrafficCardData.decode(reader, reader.uint32());
                        break;
                    case 11:
                        message.VideoCallCardData = $root.NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.decode(reader, reader.uint32());
                        break;
                    case 12:
                        message.ExternalSkillCardData = $root.NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.decode(reader, reader.uint32());
                        break;
                    case 9:
                        message.LongTapAction = reader.string();
                        break;
                    case 13:
                        message.DeleteWidgetAction = reader.string();
                        break;
                    case 14:
                        message.MainScreenPosition = $root.NAlice.NData.TWidgetPosition.decode(reader, reader.uint32());
                        break;
                    case 15:
                        message.TypedAction = $root.google.protobuf.Any.decode(reader, reader.uint32());
                        break;
                    case 16:
                        message.LongTapTypedAction = $root.google.protobuf.Any.decode(reader, reader.uint32());
                        break;
                    case 17:
                        message.DeleteWidgetTypedAction = $root.google.protobuf.Any.decode(reader, reader.uint32());
                        break;
                    default:
                        reader.skipType(tag & 7);
                        break;
                    }
                }
                return message;
            };

            /**
             * Decodes a TCentaurWidgetCardData message from the specified reader or buffer, length delimited.
             * @function decodeDelimited
             * @memberof NAlice.NData.TCentaurWidgetCardData
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @returns {NAlice.NData.TCentaurWidgetCardData} TCentaurWidgetCardData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            TCentaurWidgetCardData.decodeDelimited = function decodeDelimited(reader) {
                if (!(reader instanceof $Reader))
                    reader = new $Reader(reader);
                return this.decode(reader, reader.uint32());
            };

            /**
             * Verifies a TCentaurWidgetCardData message.
             * @function verify
             * @memberof NAlice.NData.TCentaurWidgetCardData
             * @static
             * @param {Object.<string,*>} message Plain object to verify
             * @returns {string|null} `null` if valid, otherwise the reason why it is not
             */
            TCentaurWidgetCardData.verify = function verify(message) {
                if (typeof message !== "object" || message === null)
                    return "object expected";
                var properties = {};
                if (message.Id != null && message.hasOwnProperty("Id"))
                    if (!$util.isString(message.Id))
                        return "Id: string expected";
                if (message.Action != null && message.hasOwnProperty("Action"))
                    if (!$util.isString(message.Action))
                        return "Action: string expected";
                if (message.InfoCardData != null && message.hasOwnProperty("InfoCardData")) {
                    properties.CardData = 1;
                    {
                        var error = $root.NAlice.NData.TCentaurWidgetCardData.TInfoCardData.verify(message.InfoCardData);
                        if (error)
                            return "InfoCardData." + error;
                    }
                }
                if (message.MusicCardData != null && message.hasOwnProperty("MusicCardData")) {
                    if (properties.CardData === 1)
                        return "CardData: multiple values";
                    properties.CardData = 1;
                    {
                        var error = $root.NAlice.NData.TCentaurWidgetCardData.TMusicCardData.verify(message.MusicCardData);
                        if (error)
                            return "MusicCardData." + error;
                    }
                }
                if (message.NewsCardData != null && message.hasOwnProperty("NewsCardData")) {
                    if (properties.CardData === 1)
                        return "CardData: multiple values";
                    properties.CardData = 1;
                    {
                        var error = $root.NAlice.NData.TCentaurWidgetCardData.TNewsCardData.verify(message.NewsCardData);
                        if (error)
                            return "NewsCardData." + error;
                    }
                }
                if (message.WeatherCardData != null && message.hasOwnProperty("WeatherCardData")) {
                    if (properties.CardData === 1)
                        return "CardData: multiple values";
                    properties.CardData = 1;
                    {
                        var error = $root.NAlice.NData.TCentaurWidgetCardData.TWeatherCardData.verify(message.WeatherCardData);
                        if (error)
                            return "WeatherCardData." + error;
                    }
                }
                if (message.YouTubeCardData != null && message.hasOwnProperty("YouTubeCardData")) {
                    if (properties.CardData === 1)
                        return "CardData: multiple values";
                    properties.CardData = 1;
                    {
                        var error = $root.NAlice.NData.TCentaurWidgetCardData.TYouTubeCardData.verify(message.YouTubeCardData);
                        if (error)
                            return "YouTubeCardData." + error;
                    }
                }
                if (message.VacantCardData != null && message.hasOwnProperty("VacantCardData")) {
                    if (properties.CardData === 1)
                        return "CardData: multiple values";
                    properties.CardData = 1;
                    {
                        var error = $root.NAlice.NData.TCentaurWidgetCardData.TVacantCardData.verify(message.VacantCardData);
                        if (error)
                            return "VacantCardData." + error;
                    }
                }
                if (message.TrafficCardData != null && message.hasOwnProperty("TrafficCardData")) {
                    if (properties.CardData === 1)
                        return "CardData: multiple values";
                    properties.CardData = 1;
                    {
                        var error = $root.NAlice.NData.TCentaurWidgetCardData.TTrafficCardData.verify(message.TrafficCardData);
                        if (error)
                            return "TrafficCardData." + error;
                    }
                }
                if (message.VideoCallCardData != null && message.hasOwnProperty("VideoCallCardData")) {
                    if (properties.CardData === 1)
                        return "CardData: multiple values";
                    properties.CardData = 1;
                    {
                        var error = $root.NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.verify(message.VideoCallCardData);
                        if (error)
                            return "VideoCallCardData." + error;
                    }
                }
                if (message.ExternalSkillCardData != null && message.hasOwnProperty("ExternalSkillCardData")) {
                    if (properties.CardData === 1)
                        return "CardData: multiple values";
                    properties.CardData = 1;
                    {
                        var error = $root.NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.verify(message.ExternalSkillCardData);
                        if (error)
                            return "ExternalSkillCardData." + error;
                    }
                }
                if (message.LongTapAction != null && message.hasOwnProperty("LongTapAction"))
                    if (!$util.isString(message.LongTapAction))
                        return "LongTapAction: string expected";
                if (message.DeleteWidgetAction != null && message.hasOwnProperty("DeleteWidgetAction"))
                    if (!$util.isString(message.DeleteWidgetAction))
                        return "DeleteWidgetAction: string expected";
                if (message.MainScreenPosition != null && message.hasOwnProperty("MainScreenPosition")) {
                    var error = $root.NAlice.NData.TWidgetPosition.verify(message.MainScreenPosition);
                    if (error)
                        return "MainScreenPosition." + error;
                }
                if (message.TypedAction != null && message.hasOwnProperty("TypedAction")) {
                    var error = $root.google.protobuf.Any.verify(message.TypedAction);
                    if (error)
                        return "TypedAction." + error;
                }
                if (message.LongTapTypedAction != null && message.hasOwnProperty("LongTapTypedAction")) {
                    var error = $root.google.protobuf.Any.verify(message.LongTapTypedAction);
                    if (error)
                        return "LongTapTypedAction." + error;
                }
                if (message.DeleteWidgetTypedAction != null && message.hasOwnProperty("DeleteWidgetTypedAction")) {
                    var error = $root.google.protobuf.Any.verify(message.DeleteWidgetTypedAction);
                    if (error)
                        return "DeleteWidgetTypedAction." + error;
                }
                return null;
            };

            /**
             * Creates a TCentaurWidgetCardData message from a plain object. Also converts values to their respective internal types.
             * @function fromObject
             * @memberof NAlice.NData.TCentaurWidgetCardData
             * @static
             * @param {Object.<string,*>} object Plain object
             * @returns {NAlice.NData.TCentaurWidgetCardData} TCentaurWidgetCardData
             */
            TCentaurWidgetCardData.fromObject = function fromObject(object) {
                if (object instanceof $root.NAlice.NData.TCentaurWidgetCardData)
                    return object;
                var message = new $root.NAlice.NData.TCentaurWidgetCardData();
                if (object.Id != null)
                    message.Id = String(object.Id);
                if (object.Action != null)
                    message.Action = String(object.Action);
                if (object.InfoCardData != null) {
                    if (typeof object.InfoCardData !== "object")
                        throw TypeError(".NAlice.NData.TCentaurWidgetCardData.InfoCardData: object expected");
                    message.InfoCardData = $root.NAlice.NData.TCentaurWidgetCardData.TInfoCardData.fromObject(object.InfoCardData);
                }
                if (object.MusicCardData != null) {
                    if (typeof object.MusicCardData !== "object")
                        throw TypeError(".NAlice.NData.TCentaurWidgetCardData.MusicCardData: object expected");
                    message.MusicCardData = $root.NAlice.NData.TCentaurWidgetCardData.TMusicCardData.fromObject(object.MusicCardData);
                }
                if (object.NewsCardData != null) {
                    if (typeof object.NewsCardData !== "object")
                        throw TypeError(".NAlice.NData.TCentaurWidgetCardData.NewsCardData: object expected");
                    message.NewsCardData = $root.NAlice.NData.TCentaurWidgetCardData.TNewsCardData.fromObject(object.NewsCardData);
                }
                if (object.WeatherCardData != null) {
                    if (typeof object.WeatherCardData !== "object")
                        throw TypeError(".NAlice.NData.TCentaurWidgetCardData.WeatherCardData: object expected");
                    message.WeatherCardData = $root.NAlice.NData.TCentaurWidgetCardData.TWeatherCardData.fromObject(object.WeatherCardData);
                }
                if (object.YouTubeCardData != null) {
                    if (typeof object.YouTubeCardData !== "object")
                        throw TypeError(".NAlice.NData.TCentaurWidgetCardData.YouTubeCardData: object expected");
                    message.YouTubeCardData = $root.NAlice.NData.TCentaurWidgetCardData.TYouTubeCardData.fromObject(object.YouTubeCardData);
                }
                if (object.VacantCardData != null) {
                    if (typeof object.VacantCardData !== "object")
                        throw TypeError(".NAlice.NData.TCentaurWidgetCardData.VacantCardData: object expected");
                    message.VacantCardData = $root.NAlice.NData.TCentaurWidgetCardData.TVacantCardData.fromObject(object.VacantCardData);
                }
                if (object.TrafficCardData != null) {
                    if (typeof object.TrafficCardData !== "object")
                        throw TypeError(".NAlice.NData.TCentaurWidgetCardData.TrafficCardData: object expected");
                    message.TrafficCardData = $root.NAlice.NData.TCentaurWidgetCardData.TTrafficCardData.fromObject(object.TrafficCardData);
                }
                if (object.VideoCallCardData != null) {
                    if (typeof object.VideoCallCardData !== "object")
                        throw TypeError(".NAlice.NData.TCentaurWidgetCardData.VideoCallCardData: object expected");
                    message.VideoCallCardData = $root.NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.fromObject(object.VideoCallCardData);
                }
                if (object.ExternalSkillCardData != null) {
                    if (typeof object.ExternalSkillCardData !== "object")
                        throw TypeError(".NAlice.NData.TCentaurWidgetCardData.ExternalSkillCardData: object expected");
                    message.ExternalSkillCardData = $root.NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.fromObject(object.ExternalSkillCardData);
                }
                if (object.LongTapAction != null)
                    message.LongTapAction = String(object.LongTapAction);
                if (object.DeleteWidgetAction != null)
                    message.DeleteWidgetAction = String(object.DeleteWidgetAction);
                if (object.MainScreenPosition != null) {
                    if (typeof object.MainScreenPosition !== "object")
                        throw TypeError(".NAlice.NData.TCentaurWidgetCardData.MainScreenPosition: object expected");
                    message.MainScreenPosition = $root.NAlice.NData.TWidgetPosition.fromObject(object.MainScreenPosition);
                }
                if (object.TypedAction != null) {
                    if (typeof object.TypedAction !== "object")
                        throw TypeError(".NAlice.NData.TCentaurWidgetCardData.TypedAction: object expected");
                    message.TypedAction = $root.google.protobuf.Any.fromObject(object.TypedAction);
                }
                if (object.LongTapTypedAction != null) {
                    if (typeof object.LongTapTypedAction !== "object")
                        throw TypeError(".NAlice.NData.TCentaurWidgetCardData.LongTapTypedAction: object expected");
                    message.LongTapTypedAction = $root.google.protobuf.Any.fromObject(object.LongTapTypedAction);
                }
                if (object.DeleteWidgetTypedAction != null) {
                    if (typeof object.DeleteWidgetTypedAction !== "object")
                        throw TypeError(".NAlice.NData.TCentaurWidgetCardData.DeleteWidgetTypedAction: object expected");
                    message.DeleteWidgetTypedAction = $root.google.protobuf.Any.fromObject(object.DeleteWidgetTypedAction);
                }
                return message;
            };

            /**
             * Creates a plain object from a TCentaurWidgetCardData message. Also converts values to other types if specified.
             * @function toObject
             * @memberof NAlice.NData.TCentaurWidgetCardData
             * @static
             * @param {NAlice.NData.TCentaurWidgetCardData} message TCentaurWidgetCardData
             * @param {$protobuf.IConversionOptions} [options] Conversion options
             * @returns {Object.<string,*>} Plain object
             */
            TCentaurWidgetCardData.toObject = function toObject(message, options) {
                if (!options)
                    options = {};
                var object = {};
                if (options.defaults) {
                    object.Id = "";
                    object.Action = "";
                    object.LongTapAction = "";
                    object.DeleteWidgetAction = "";
                    object.MainScreenPosition = null;
                    object.TypedAction = null;
                    object.LongTapTypedAction = null;
                    object.DeleteWidgetTypedAction = null;
                }
                if (message.Id != null && message.hasOwnProperty("Id"))
                    object.Id = message.Id;
                if (message.Action != null && message.hasOwnProperty("Action"))
                    object.Action = message.Action;
                if (message.InfoCardData != null && message.hasOwnProperty("InfoCardData")) {
                    object.InfoCardData = $root.NAlice.NData.TCentaurWidgetCardData.TInfoCardData.toObject(message.InfoCardData, options);
                    if (options.oneofs)
                        object.CardData = "InfoCardData";
                }
                if (message.MusicCardData != null && message.hasOwnProperty("MusicCardData")) {
                    object.MusicCardData = $root.NAlice.NData.TCentaurWidgetCardData.TMusicCardData.toObject(message.MusicCardData, options);
                    if (options.oneofs)
                        object.CardData = "MusicCardData";
                }
                if (message.NewsCardData != null && message.hasOwnProperty("NewsCardData")) {
                    object.NewsCardData = $root.NAlice.NData.TCentaurWidgetCardData.TNewsCardData.toObject(message.NewsCardData, options);
                    if (options.oneofs)
                        object.CardData = "NewsCardData";
                }
                if (message.WeatherCardData != null && message.hasOwnProperty("WeatherCardData")) {
                    object.WeatherCardData = $root.NAlice.NData.TCentaurWidgetCardData.TWeatherCardData.toObject(message.WeatherCardData, options);
                    if (options.oneofs)
                        object.CardData = "WeatherCardData";
                }
                if (message.YouTubeCardData != null && message.hasOwnProperty("YouTubeCardData")) {
                    object.YouTubeCardData = $root.NAlice.NData.TCentaurWidgetCardData.TYouTubeCardData.toObject(message.YouTubeCardData, options);
                    if (options.oneofs)
                        object.CardData = "YouTubeCardData";
                }
                if (message.VacantCardData != null && message.hasOwnProperty("VacantCardData")) {
                    object.VacantCardData = $root.NAlice.NData.TCentaurWidgetCardData.TVacantCardData.toObject(message.VacantCardData, options);
                    if (options.oneofs)
                        object.CardData = "VacantCardData";
                }
                if (message.LongTapAction != null && message.hasOwnProperty("LongTapAction"))
                    object.LongTapAction = message.LongTapAction;
                if (message.TrafficCardData != null && message.hasOwnProperty("TrafficCardData")) {
                    object.TrafficCardData = $root.NAlice.NData.TCentaurWidgetCardData.TTrafficCardData.toObject(message.TrafficCardData, options);
                    if (options.oneofs)
                        object.CardData = "TrafficCardData";
                }
                if (message.VideoCallCardData != null && message.hasOwnProperty("VideoCallCardData")) {
                    object.VideoCallCardData = $root.NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.toObject(message.VideoCallCardData, options);
                    if (options.oneofs)
                        object.CardData = "VideoCallCardData";
                }
                if (message.ExternalSkillCardData != null && message.hasOwnProperty("ExternalSkillCardData")) {
                    object.ExternalSkillCardData = $root.NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.toObject(message.ExternalSkillCardData, options);
                    if (options.oneofs)
                        object.CardData = "ExternalSkillCardData";
                }
                if (message.DeleteWidgetAction != null && message.hasOwnProperty("DeleteWidgetAction"))
                    object.DeleteWidgetAction = message.DeleteWidgetAction;
                if (message.MainScreenPosition != null && message.hasOwnProperty("MainScreenPosition"))
                    object.MainScreenPosition = $root.NAlice.NData.TWidgetPosition.toObject(message.MainScreenPosition, options);
                if (message.TypedAction != null && message.hasOwnProperty("TypedAction"))
                    object.TypedAction = $root.google.protobuf.Any.toObject(message.TypedAction, options);
                if (message.LongTapTypedAction != null && message.hasOwnProperty("LongTapTypedAction"))
                    object.LongTapTypedAction = $root.google.protobuf.Any.toObject(message.LongTapTypedAction, options);
                if (message.DeleteWidgetTypedAction != null && message.hasOwnProperty("DeleteWidgetTypedAction"))
                    object.DeleteWidgetTypedAction = $root.google.protobuf.Any.toObject(message.DeleteWidgetTypedAction, options);
                return object;
            };

            /**
             * Converts this TCentaurWidgetCardData to JSON.
             * @function toJSON
             * @memberof NAlice.NData.TCentaurWidgetCardData
             * @instance
             * @returns {Object.<string,*>} JSON object
             */
            TCentaurWidgetCardData.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            TCentaurWidgetCardData.TInfoCardData = (function() {

                /**
                 * Properties of a TInfoCardData.
                 * @memberof NAlice.NData.TCentaurWidgetCardData
                 * @interface ITInfoCardData
                 * @property {string|null} [Title] TInfoCardData Title
                 * @property {string|null} [Description] TInfoCardData Description
                 * @property {string|null} [Color] TInfoCardData Color
                 * @property {string|null} [ImageBackground] TInfoCardData ImageBackground
                 * @property {string|null} [Subcomment] TInfoCardData Subcomment
                 * @property {string|null} [Icon] TInfoCardData Icon
                 */

                /**
                 * Constructs a new TInfoCardData.
                 * @memberof NAlice.NData.TCentaurWidgetCardData
                 * @classdesc Represents a TInfoCardData.
                 * @implements ITInfoCardData
                 * @constructor
                 * @param {NAlice.NData.TCentaurWidgetCardData.ITInfoCardData=} [properties] Properties to set
                 */
                function TInfoCardData(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }

                /**
                 * TInfoCardData Title.
                 * @member {string} Title
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TInfoCardData
                 * @instance
                 */
                TInfoCardData.prototype.Title = "";

                /**
                 * TInfoCardData Description.
                 * @member {string} Description
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TInfoCardData
                 * @instance
                 */
                TInfoCardData.prototype.Description = "";

                /**
                 * TInfoCardData Color.
                 * @member {string} Color
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TInfoCardData
                 * @instance
                 */
                TInfoCardData.prototype.Color = "";

                /**
                 * TInfoCardData ImageBackground.
                 * @member {string} ImageBackground
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TInfoCardData
                 * @instance
                 */
                TInfoCardData.prototype.ImageBackground = "";

                /**
                 * TInfoCardData Subcomment.
                 * @member {string} Subcomment
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TInfoCardData
                 * @instance
                 */
                TInfoCardData.prototype.Subcomment = "";

                /**
                 * TInfoCardData Icon.
                 * @member {string} Icon
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TInfoCardData
                 * @instance
                 */
                TInfoCardData.prototype.Icon = "";

                /**
                 * Creates a new TInfoCardData instance using the specified properties.
                 * @function create
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TInfoCardData
                 * @static
                 * @param {NAlice.NData.TCentaurWidgetCardData.ITInfoCardData=} [properties] Properties to set
                 * @returns {NAlice.NData.TCentaurWidgetCardData.TInfoCardData} TInfoCardData instance
                 */
                TInfoCardData.create = function create(properties) {
                    return new TInfoCardData(properties);
                };

                /**
                 * Encodes the specified TInfoCardData message. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardData.TInfoCardData.verify|verify} messages.
                 * @function encode
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TInfoCardData
                 * @static
                 * @param {NAlice.NData.TCentaurWidgetCardData.ITInfoCardData} message TInfoCardData message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                TInfoCardData.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.Title != null && Object.hasOwnProperty.call(message, "Title"))
                        writer.uint32(/* id 1, wireType 2 =*/10).string(message.Title);
                    if (message.Description != null && Object.hasOwnProperty.call(message, "Description"))
                        writer.uint32(/* id 2, wireType 2 =*/18).string(message.Description);
                    if (message.Color != null && Object.hasOwnProperty.call(message, "Color"))
                        writer.uint32(/* id 3, wireType 2 =*/26).string(message.Color);
                    if (message.ImageBackground != null && Object.hasOwnProperty.call(message, "ImageBackground"))
                        writer.uint32(/* id 4, wireType 2 =*/34).string(message.ImageBackground);
                    if (message.Subcomment != null && Object.hasOwnProperty.call(message, "Subcomment"))
                        writer.uint32(/* id 5, wireType 2 =*/42).string(message.Subcomment);
                    if (message.Icon != null && Object.hasOwnProperty.call(message, "Icon"))
                        writer.uint32(/* id 6, wireType 2 =*/50).string(message.Icon);
                    return writer;
                };

                /**
                 * Encodes the specified TInfoCardData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardData.TInfoCardData.verify|verify} messages.
                 * @function encodeDelimited
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TInfoCardData
                 * @static
                 * @param {NAlice.NData.TCentaurWidgetCardData.ITInfoCardData} message TInfoCardData message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                TInfoCardData.encodeDelimited = function encodeDelimited(message, writer) {
                    return this.encode(message, writer).ldelim();
                };

                /**
                 * Decodes a TInfoCardData message from the specified reader or buffer.
                 * @function decode
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TInfoCardData
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {NAlice.NData.TCentaurWidgetCardData.TInfoCardData} TInfoCardData
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                TInfoCardData.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.NAlice.NData.TCentaurWidgetCardData.TInfoCardData();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.Title = reader.string();
                            break;
                        case 2:
                            message.Description = reader.string();
                            break;
                        case 3:
                            message.Color = reader.string();
                            break;
                        case 4:
                            message.ImageBackground = reader.string();
                            break;
                        case 5:
                            message.Subcomment = reader.string();
                            break;
                        case 6:
                            message.Icon = reader.string();
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };

                /**
                 * Decodes a TInfoCardData message from the specified reader or buffer, length delimited.
                 * @function decodeDelimited
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TInfoCardData
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @returns {NAlice.NData.TCentaurWidgetCardData.TInfoCardData} TInfoCardData
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                TInfoCardData.decodeDelimited = function decodeDelimited(reader) {
                    if (!(reader instanceof $Reader))
                        reader = new $Reader(reader);
                    return this.decode(reader, reader.uint32());
                };

                /**
                 * Verifies a TInfoCardData message.
                 * @function verify
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TInfoCardData
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                TInfoCardData.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.Title != null && message.hasOwnProperty("Title"))
                        if (!$util.isString(message.Title))
                            return "Title: string expected";
                    if (message.Description != null && message.hasOwnProperty("Description"))
                        if (!$util.isString(message.Description))
                            return "Description: string expected";
                    if (message.Color != null && message.hasOwnProperty("Color"))
                        if (!$util.isString(message.Color))
                            return "Color: string expected";
                    if (message.ImageBackground != null && message.hasOwnProperty("ImageBackground"))
                        if (!$util.isString(message.ImageBackground))
                            return "ImageBackground: string expected";
                    if (message.Subcomment != null && message.hasOwnProperty("Subcomment"))
                        if (!$util.isString(message.Subcomment))
                            return "Subcomment: string expected";
                    if (message.Icon != null && message.hasOwnProperty("Icon"))
                        if (!$util.isString(message.Icon))
                            return "Icon: string expected";
                    return null;
                };

                /**
                 * Creates a TInfoCardData message from a plain object. Also converts values to their respective internal types.
                 * @function fromObject
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TInfoCardData
                 * @static
                 * @param {Object.<string,*>} object Plain object
                 * @returns {NAlice.NData.TCentaurWidgetCardData.TInfoCardData} TInfoCardData
                 */
                TInfoCardData.fromObject = function fromObject(object) {
                    if (object instanceof $root.NAlice.NData.TCentaurWidgetCardData.TInfoCardData)
                        return object;
                    var message = new $root.NAlice.NData.TCentaurWidgetCardData.TInfoCardData();
                    if (object.Title != null)
                        message.Title = String(object.Title);
                    if (object.Description != null)
                        message.Description = String(object.Description);
                    if (object.Color != null)
                        message.Color = String(object.Color);
                    if (object.ImageBackground != null)
                        message.ImageBackground = String(object.ImageBackground);
                    if (object.Subcomment != null)
                        message.Subcomment = String(object.Subcomment);
                    if (object.Icon != null)
                        message.Icon = String(object.Icon);
                    return message;
                };

                /**
                 * Creates a plain object from a TInfoCardData message. Also converts values to other types if specified.
                 * @function toObject
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TInfoCardData
                 * @static
                 * @param {NAlice.NData.TCentaurWidgetCardData.TInfoCardData} message TInfoCardData
                 * @param {$protobuf.IConversionOptions} [options] Conversion options
                 * @returns {Object.<string,*>} Plain object
                 */
                TInfoCardData.toObject = function toObject(message, options) {
                    if (!options)
                        options = {};
                    var object = {};
                    if (options.defaults) {
                        object.Title = "";
                        object.Description = "";
                        object.Color = "";
                        object.ImageBackground = "";
                        object.Subcomment = "";
                        object.Icon = "";
                    }
                    if (message.Title != null && message.hasOwnProperty("Title"))
                        object.Title = message.Title;
                    if (message.Description != null && message.hasOwnProperty("Description"))
                        object.Description = message.Description;
                    if (message.Color != null && message.hasOwnProperty("Color"))
                        object.Color = message.Color;
                    if (message.ImageBackground != null && message.hasOwnProperty("ImageBackground"))
                        object.ImageBackground = message.ImageBackground;
                    if (message.Subcomment != null && message.hasOwnProperty("Subcomment"))
                        object.Subcomment = message.Subcomment;
                    if (message.Icon != null && message.hasOwnProperty("Icon"))
                        object.Icon = message.Icon;
                    return object;
                };

                /**
                 * Converts this TInfoCardData to JSON.
                 * @function toJSON
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TInfoCardData
                 * @instance
                 * @returns {Object.<string,*>} JSON object
                 */
                TInfoCardData.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };

                return TInfoCardData;
            })();

            TCentaurWidgetCardData.TMusicCardData = (function() {

                /**
                 * Properties of a TMusicCardData.
                 * @memberof NAlice.NData.TCentaurWidgetCardData
                 * @interface ITMusicCardData
                 * @property {string|null} [Name] TMusicCardData Name
                 * @property {string|null} [Color] TMusicCardData Color
                 * @property {string|null} [Cover] TMusicCardData Cover
                 * @property {google.protobuf.IStringValue|null} [Modified] TMusicCardData Modified
                 */

                /**
                 * Constructs a new TMusicCardData.
                 * @memberof NAlice.NData.TCentaurWidgetCardData
                 * @classdesc Represents a TMusicCardData.
                 * @implements ITMusicCardData
                 * @constructor
                 * @param {NAlice.NData.TCentaurWidgetCardData.ITMusicCardData=} [properties] Properties to set
                 */
                function TMusicCardData(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }

                /**
                 * TMusicCardData Name.
                 * @member {string} Name
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TMusicCardData
                 * @instance
                 */
                TMusicCardData.prototype.Name = "";

                /**
                 * TMusicCardData Color.
                 * @member {string} Color
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TMusicCardData
                 * @instance
                 */
                TMusicCardData.prototype.Color = "";

                /**
                 * TMusicCardData Cover.
                 * @member {string} Cover
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TMusicCardData
                 * @instance
                 */
                TMusicCardData.prototype.Cover = "";

                /**
                 * TMusicCardData Modified.
                 * @member {google.protobuf.IStringValue|null|undefined} Modified
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TMusicCardData
                 * @instance
                 */
                TMusicCardData.prototype.Modified = null;

                /**
                 * Creates a new TMusicCardData instance using the specified properties.
                 * @function create
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TMusicCardData
                 * @static
                 * @param {NAlice.NData.TCentaurWidgetCardData.ITMusicCardData=} [properties] Properties to set
                 * @returns {NAlice.NData.TCentaurWidgetCardData.TMusicCardData} TMusicCardData instance
                 */
                TMusicCardData.create = function create(properties) {
                    return new TMusicCardData(properties);
                };

                /**
                 * Encodes the specified TMusicCardData message. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardData.TMusicCardData.verify|verify} messages.
                 * @function encode
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TMusicCardData
                 * @static
                 * @param {NAlice.NData.TCentaurWidgetCardData.ITMusicCardData} message TMusicCardData message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                TMusicCardData.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.Name != null && Object.hasOwnProperty.call(message, "Name"))
                        writer.uint32(/* id 1, wireType 2 =*/10).string(message.Name);
                    if (message.Color != null && Object.hasOwnProperty.call(message, "Color"))
                        writer.uint32(/* id 2, wireType 2 =*/18).string(message.Color);
                    if (message.Cover != null && Object.hasOwnProperty.call(message, "Cover"))
                        writer.uint32(/* id 3, wireType 2 =*/26).string(message.Cover);
                    if (message.Modified != null && Object.hasOwnProperty.call(message, "Modified"))
                        $root.google.protobuf.StringValue.encode(message.Modified, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
                    return writer;
                };

                /**
                 * Encodes the specified TMusicCardData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardData.TMusicCardData.verify|verify} messages.
                 * @function encodeDelimited
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TMusicCardData
                 * @static
                 * @param {NAlice.NData.TCentaurWidgetCardData.ITMusicCardData} message TMusicCardData message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                TMusicCardData.encodeDelimited = function encodeDelimited(message, writer) {
                    return this.encode(message, writer).ldelim();
                };

                /**
                 * Decodes a TMusicCardData message from the specified reader or buffer.
                 * @function decode
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TMusicCardData
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {NAlice.NData.TCentaurWidgetCardData.TMusicCardData} TMusicCardData
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                TMusicCardData.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.NAlice.NData.TCentaurWidgetCardData.TMusicCardData();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.Name = reader.string();
                            break;
                        case 2:
                            message.Color = reader.string();
                            break;
                        case 3:
                            message.Cover = reader.string();
                            break;
                        case 4:
                            message.Modified = $root.google.protobuf.StringValue.decode(reader, reader.uint32());
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };

                /**
                 * Decodes a TMusicCardData message from the specified reader or buffer, length delimited.
                 * @function decodeDelimited
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TMusicCardData
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @returns {NAlice.NData.TCentaurWidgetCardData.TMusicCardData} TMusicCardData
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                TMusicCardData.decodeDelimited = function decodeDelimited(reader) {
                    if (!(reader instanceof $Reader))
                        reader = new $Reader(reader);
                    return this.decode(reader, reader.uint32());
                };

                /**
                 * Verifies a TMusicCardData message.
                 * @function verify
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TMusicCardData
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                TMusicCardData.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.Name != null && message.hasOwnProperty("Name"))
                        if (!$util.isString(message.Name))
                            return "Name: string expected";
                    if (message.Color != null && message.hasOwnProperty("Color"))
                        if (!$util.isString(message.Color))
                            return "Color: string expected";
                    if (message.Cover != null && message.hasOwnProperty("Cover"))
                        if (!$util.isString(message.Cover))
                            return "Cover: string expected";
                    if (message.Modified != null && message.hasOwnProperty("Modified")) {
                        var error = $root.google.protobuf.StringValue.verify(message.Modified);
                        if (error)
                            return "Modified." + error;
                    }
                    return null;
                };

                /**
                 * Creates a TMusicCardData message from a plain object. Also converts values to their respective internal types.
                 * @function fromObject
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TMusicCardData
                 * @static
                 * @param {Object.<string,*>} object Plain object
                 * @returns {NAlice.NData.TCentaurWidgetCardData.TMusicCardData} TMusicCardData
                 */
                TMusicCardData.fromObject = function fromObject(object) {
                    if (object instanceof $root.NAlice.NData.TCentaurWidgetCardData.TMusicCardData)
                        return object;
                    var message = new $root.NAlice.NData.TCentaurWidgetCardData.TMusicCardData();
                    if (object.Name != null)
                        message.Name = String(object.Name);
                    if (object.Color != null)
                        message.Color = String(object.Color);
                    if (object.Cover != null)
                        message.Cover = String(object.Cover);
                    if (object.Modified != null) {
                        if (typeof object.Modified !== "object")
                            throw TypeError(".NAlice.NData.TCentaurWidgetCardData.TMusicCardData.Modified: object expected");
                        message.Modified = $root.google.protobuf.StringValue.fromObject(object.Modified);
                    }
                    return message;
                };

                /**
                 * Creates a plain object from a TMusicCardData message. Also converts values to other types if specified.
                 * @function toObject
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TMusicCardData
                 * @static
                 * @param {NAlice.NData.TCentaurWidgetCardData.TMusicCardData} message TMusicCardData
                 * @param {$protobuf.IConversionOptions} [options] Conversion options
                 * @returns {Object.<string,*>} Plain object
                 */
                TMusicCardData.toObject = function toObject(message, options) {
                    if (!options)
                        options = {};
                    var object = {};
                    if (options.defaults) {
                        object.Name = "";
                        object.Color = "";
                        object.Cover = "";
                        object.Modified = null;
                    }
                    if (message.Name != null && message.hasOwnProperty("Name"))
                        object.Name = message.Name;
                    if (message.Color != null && message.hasOwnProperty("Color"))
                        object.Color = message.Color;
                    if (message.Cover != null && message.hasOwnProperty("Cover"))
                        object.Cover = message.Cover;
                    if (message.Modified != null && message.hasOwnProperty("Modified"))
                        object.Modified = $root.google.protobuf.StringValue.toObject(message.Modified, options);
                    return object;
                };

                /**
                 * Converts this TMusicCardData to JSON.
                 * @function toJSON
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TMusicCardData
                 * @instance
                 * @returns {Object.<string,*>} JSON object
                 */
                TMusicCardData.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };

                return TMusicCardData;
            })();

            TCentaurWidgetCardData.TNewsCardData = (function() {

                /**
                 * Properties of a TNewsCardData.
                 * @memberof NAlice.NData.TCentaurWidgetCardData
                 * @interface ITNewsCardData
                 * @property {string|null} [Title] TNewsCardData Title
                 * @property {string|null} [Content] TNewsCardData Content
                 * @property {string|null} [ImageUrl] TNewsCardData ImageUrl
                 * @property {string|null} [Topic] TNewsCardData Topic
                 */

                /**
                 * Constructs a new TNewsCardData.
                 * @memberof NAlice.NData.TCentaurWidgetCardData
                 * @classdesc Represents a TNewsCardData.
                 * @implements ITNewsCardData
                 * @constructor
                 * @param {NAlice.NData.TCentaurWidgetCardData.ITNewsCardData=} [properties] Properties to set
                 */
                function TNewsCardData(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }

                /**
                 * TNewsCardData Title.
                 * @member {string} Title
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TNewsCardData
                 * @instance
                 */
                TNewsCardData.prototype.Title = "";

                /**
                 * TNewsCardData Content.
                 * @member {string} Content
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TNewsCardData
                 * @instance
                 */
                TNewsCardData.prototype.Content = "";

                /**
                 * TNewsCardData ImageUrl.
                 * @member {string} ImageUrl
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TNewsCardData
                 * @instance
                 */
                TNewsCardData.prototype.ImageUrl = "";

                /**
                 * TNewsCardData Topic.
                 * @member {string} Topic
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TNewsCardData
                 * @instance
                 */
                TNewsCardData.prototype.Topic = "";

                /**
                 * Creates a new TNewsCardData instance using the specified properties.
                 * @function create
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TNewsCardData
                 * @static
                 * @param {NAlice.NData.TCentaurWidgetCardData.ITNewsCardData=} [properties] Properties to set
                 * @returns {NAlice.NData.TCentaurWidgetCardData.TNewsCardData} TNewsCardData instance
                 */
                TNewsCardData.create = function create(properties) {
                    return new TNewsCardData(properties);
                };

                /**
                 * Encodes the specified TNewsCardData message. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardData.TNewsCardData.verify|verify} messages.
                 * @function encode
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TNewsCardData
                 * @static
                 * @param {NAlice.NData.TCentaurWidgetCardData.ITNewsCardData} message TNewsCardData message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                TNewsCardData.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.Title != null && Object.hasOwnProperty.call(message, "Title"))
                        writer.uint32(/* id 1, wireType 2 =*/10).string(message.Title);
                    if (message.Content != null && Object.hasOwnProperty.call(message, "Content"))
                        writer.uint32(/* id 2, wireType 2 =*/18).string(message.Content);
                    if (message.ImageUrl != null && Object.hasOwnProperty.call(message, "ImageUrl"))
                        writer.uint32(/* id 3, wireType 2 =*/26).string(message.ImageUrl);
                    if (message.Topic != null && Object.hasOwnProperty.call(message, "Topic"))
                        writer.uint32(/* id 4, wireType 2 =*/34).string(message.Topic);
                    return writer;
                };

                /**
                 * Encodes the specified TNewsCardData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardData.TNewsCardData.verify|verify} messages.
                 * @function encodeDelimited
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TNewsCardData
                 * @static
                 * @param {NAlice.NData.TCentaurWidgetCardData.ITNewsCardData} message TNewsCardData message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                TNewsCardData.encodeDelimited = function encodeDelimited(message, writer) {
                    return this.encode(message, writer).ldelim();
                };

                /**
                 * Decodes a TNewsCardData message from the specified reader or buffer.
                 * @function decode
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TNewsCardData
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {NAlice.NData.TCentaurWidgetCardData.TNewsCardData} TNewsCardData
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                TNewsCardData.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.NAlice.NData.TCentaurWidgetCardData.TNewsCardData();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.Title = reader.string();
                            break;
                        case 2:
                            message.Content = reader.string();
                            break;
                        case 3:
                            message.ImageUrl = reader.string();
                            break;
                        case 4:
                            message.Topic = reader.string();
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };

                /**
                 * Decodes a TNewsCardData message from the specified reader or buffer, length delimited.
                 * @function decodeDelimited
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TNewsCardData
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @returns {NAlice.NData.TCentaurWidgetCardData.TNewsCardData} TNewsCardData
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                TNewsCardData.decodeDelimited = function decodeDelimited(reader) {
                    if (!(reader instanceof $Reader))
                        reader = new $Reader(reader);
                    return this.decode(reader, reader.uint32());
                };

                /**
                 * Verifies a TNewsCardData message.
                 * @function verify
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TNewsCardData
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                TNewsCardData.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.Title != null && message.hasOwnProperty("Title"))
                        if (!$util.isString(message.Title))
                            return "Title: string expected";
                    if (message.Content != null && message.hasOwnProperty("Content"))
                        if (!$util.isString(message.Content))
                            return "Content: string expected";
                    if (message.ImageUrl != null && message.hasOwnProperty("ImageUrl"))
                        if (!$util.isString(message.ImageUrl))
                            return "ImageUrl: string expected";
                    if (message.Topic != null && message.hasOwnProperty("Topic"))
                        if (!$util.isString(message.Topic))
                            return "Topic: string expected";
                    return null;
                };

                /**
                 * Creates a TNewsCardData message from a plain object. Also converts values to their respective internal types.
                 * @function fromObject
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TNewsCardData
                 * @static
                 * @param {Object.<string,*>} object Plain object
                 * @returns {NAlice.NData.TCentaurWidgetCardData.TNewsCardData} TNewsCardData
                 */
                TNewsCardData.fromObject = function fromObject(object) {
                    if (object instanceof $root.NAlice.NData.TCentaurWidgetCardData.TNewsCardData)
                        return object;
                    var message = new $root.NAlice.NData.TCentaurWidgetCardData.TNewsCardData();
                    if (object.Title != null)
                        message.Title = String(object.Title);
                    if (object.Content != null)
                        message.Content = String(object.Content);
                    if (object.ImageUrl != null)
                        message.ImageUrl = String(object.ImageUrl);
                    if (object.Topic != null)
                        message.Topic = String(object.Topic);
                    return message;
                };

                /**
                 * Creates a plain object from a TNewsCardData message. Also converts values to other types if specified.
                 * @function toObject
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TNewsCardData
                 * @static
                 * @param {NAlice.NData.TCentaurWidgetCardData.TNewsCardData} message TNewsCardData
                 * @param {$protobuf.IConversionOptions} [options] Conversion options
                 * @returns {Object.<string,*>} Plain object
                 */
                TNewsCardData.toObject = function toObject(message, options) {
                    if (!options)
                        options = {};
                    var object = {};
                    if (options.defaults) {
                        object.Title = "";
                        object.Content = "";
                        object.ImageUrl = "";
                        object.Topic = "";
                    }
                    if (message.Title != null && message.hasOwnProperty("Title"))
                        object.Title = message.Title;
                    if (message.Content != null && message.hasOwnProperty("Content"))
                        object.Content = message.Content;
                    if (message.ImageUrl != null && message.hasOwnProperty("ImageUrl"))
                        object.ImageUrl = message.ImageUrl;
                    if (message.Topic != null && message.hasOwnProperty("Topic"))
                        object.Topic = message.Topic;
                    return object;
                };

                /**
                 * Converts this TNewsCardData to JSON.
                 * @function toJSON
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TNewsCardData
                 * @instance
                 * @returns {Object.<string,*>} JSON object
                 */
                TNewsCardData.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };

                return TNewsCardData;
            })();

            TCentaurWidgetCardData.TWeatherCardData = (function() {

                /**
                 * Properties of a TWeatherCardData.
                 * @memberof NAlice.NData.TCentaurWidgetCardData
                 * @interface ITWeatherCardData
                 * @property {string|null} [City] TWeatherCardData City
                 * @property {number|null} [Temperature] TWeatherCardData Temperature
                 * @property {string|null} [Image] TWeatherCardData Image
                 * @property {string|null} [Comment] TWeatherCardData Comment
                 * @property {string|null} [Sunrise] TWeatherCardData Sunrise
                 * @property {string|null} [Sunset] TWeatherCardData Sunset
                 * @property {string|null} [UserTime] TWeatherCardData UserTime
                 * @property {NAlice.NData.ITWeatherCondition|null} [Condition] TWeatherCardData Condition
                 */

                /**
                 * Constructs a new TWeatherCardData.
                 * @memberof NAlice.NData.TCentaurWidgetCardData
                 * @classdesc Represents a TWeatherCardData.
                 * @implements ITWeatherCardData
                 * @constructor
                 * @param {NAlice.NData.TCentaurWidgetCardData.ITWeatherCardData=} [properties] Properties to set
                 */
                function TWeatherCardData(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }

                /**
                 * TWeatherCardData City.
                 * @member {string} City
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TWeatherCardData
                 * @instance
                 */
                TWeatherCardData.prototype.City = "";

                /**
                 * TWeatherCardData Temperature.
                 * @member {number} Temperature
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TWeatherCardData
                 * @instance
                 */
                TWeatherCardData.prototype.Temperature = 0;

                /**
                 * TWeatherCardData Image.
                 * @member {string} Image
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TWeatherCardData
                 * @instance
                 */
                TWeatherCardData.prototype.Image = "";

                /**
                 * TWeatherCardData Comment.
                 * @member {string} Comment
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TWeatherCardData
                 * @instance
                 */
                TWeatherCardData.prototype.Comment = "";

                /**
                 * TWeatherCardData Sunrise.
                 * @member {string} Sunrise
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TWeatherCardData
                 * @instance
                 */
                TWeatherCardData.prototype.Sunrise = "";

                /**
                 * TWeatherCardData Sunset.
                 * @member {string} Sunset
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TWeatherCardData
                 * @instance
                 */
                TWeatherCardData.prototype.Sunset = "";

                /**
                 * TWeatherCardData UserTime.
                 * @member {string} UserTime
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TWeatherCardData
                 * @instance
                 */
                TWeatherCardData.prototype.UserTime = "";

                /**
                 * TWeatherCardData Condition.
                 * @member {NAlice.NData.ITWeatherCondition|null|undefined} Condition
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TWeatherCardData
                 * @instance
                 */
                TWeatherCardData.prototype.Condition = null;

                /**
                 * Creates a new TWeatherCardData instance using the specified properties.
                 * @function create
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TWeatherCardData
                 * @static
                 * @param {NAlice.NData.TCentaurWidgetCardData.ITWeatherCardData=} [properties] Properties to set
                 * @returns {NAlice.NData.TCentaurWidgetCardData.TWeatherCardData} TWeatherCardData instance
                 */
                TWeatherCardData.create = function create(properties) {
                    return new TWeatherCardData(properties);
                };

                /**
                 * Encodes the specified TWeatherCardData message. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardData.TWeatherCardData.verify|verify} messages.
                 * @function encode
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TWeatherCardData
                 * @static
                 * @param {NAlice.NData.TCentaurWidgetCardData.ITWeatherCardData} message TWeatherCardData message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                TWeatherCardData.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.City != null && Object.hasOwnProperty.call(message, "City"))
                        writer.uint32(/* id 1, wireType 2 =*/10).string(message.City);
                    if (message.Temperature != null && Object.hasOwnProperty.call(message, "Temperature"))
                        writer.uint32(/* id 2, wireType 0 =*/16).int32(message.Temperature);
                    if (message.Image != null && Object.hasOwnProperty.call(message, "Image"))
                        writer.uint32(/* id 3, wireType 2 =*/26).string(message.Image);
                    if (message.Comment != null && Object.hasOwnProperty.call(message, "Comment"))
                        writer.uint32(/* id 4, wireType 2 =*/34).string(message.Comment);
                    if (message.Sunrise != null && Object.hasOwnProperty.call(message, "Sunrise"))
                        writer.uint32(/* id 5, wireType 2 =*/42).string(message.Sunrise);
                    if (message.Sunset != null && Object.hasOwnProperty.call(message, "Sunset"))
                        writer.uint32(/* id 6, wireType 2 =*/50).string(message.Sunset);
                    if (message.UserTime != null && Object.hasOwnProperty.call(message, "UserTime"))
                        writer.uint32(/* id 7, wireType 2 =*/58).string(message.UserTime);
                    if (message.Condition != null && Object.hasOwnProperty.call(message, "Condition"))
                        $root.NAlice.NData.TWeatherCondition.encode(message.Condition, writer.uint32(/* id 8, wireType 2 =*/66).fork()).ldelim();
                    return writer;
                };

                /**
                 * Encodes the specified TWeatherCardData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardData.TWeatherCardData.verify|verify} messages.
                 * @function encodeDelimited
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TWeatherCardData
                 * @static
                 * @param {NAlice.NData.TCentaurWidgetCardData.ITWeatherCardData} message TWeatherCardData message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                TWeatherCardData.encodeDelimited = function encodeDelimited(message, writer) {
                    return this.encode(message, writer).ldelim();
                };

                /**
                 * Decodes a TWeatherCardData message from the specified reader or buffer.
                 * @function decode
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TWeatherCardData
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {NAlice.NData.TCentaurWidgetCardData.TWeatherCardData} TWeatherCardData
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                TWeatherCardData.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.NAlice.NData.TCentaurWidgetCardData.TWeatherCardData();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.City = reader.string();
                            break;
                        case 2:
                            message.Temperature = reader.int32();
                            break;
                        case 3:
                            message.Image = reader.string();
                            break;
                        case 4:
                            message.Comment = reader.string();
                            break;
                        case 5:
                            message.Sunrise = reader.string();
                            break;
                        case 6:
                            message.Sunset = reader.string();
                            break;
                        case 7:
                            message.UserTime = reader.string();
                            break;
                        case 8:
                            message.Condition = $root.NAlice.NData.TWeatherCondition.decode(reader, reader.uint32());
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };

                /**
                 * Decodes a TWeatherCardData message from the specified reader or buffer, length delimited.
                 * @function decodeDelimited
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TWeatherCardData
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @returns {NAlice.NData.TCentaurWidgetCardData.TWeatherCardData} TWeatherCardData
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                TWeatherCardData.decodeDelimited = function decodeDelimited(reader) {
                    if (!(reader instanceof $Reader))
                        reader = new $Reader(reader);
                    return this.decode(reader, reader.uint32());
                };

                /**
                 * Verifies a TWeatherCardData message.
                 * @function verify
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TWeatherCardData
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                TWeatherCardData.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.City != null && message.hasOwnProperty("City"))
                        if (!$util.isString(message.City))
                            return "City: string expected";
                    if (message.Temperature != null && message.hasOwnProperty("Temperature"))
                        if (!$util.isInteger(message.Temperature))
                            return "Temperature: integer expected";
                    if (message.Image != null && message.hasOwnProperty("Image"))
                        if (!$util.isString(message.Image))
                            return "Image: string expected";
                    if (message.Comment != null && message.hasOwnProperty("Comment"))
                        if (!$util.isString(message.Comment))
                            return "Comment: string expected";
                    if (message.Sunrise != null && message.hasOwnProperty("Sunrise"))
                        if (!$util.isString(message.Sunrise))
                            return "Sunrise: string expected";
                    if (message.Sunset != null && message.hasOwnProperty("Sunset"))
                        if (!$util.isString(message.Sunset))
                            return "Sunset: string expected";
                    if (message.UserTime != null && message.hasOwnProperty("UserTime"))
                        if (!$util.isString(message.UserTime))
                            return "UserTime: string expected";
                    if (message.Condition != null && message.hasOwnProperty("Condition")) {
                        var error = $root.NAlice.NData.TWeatherCondition.verify(message.Condition);
                        if (error)
                            return "Condition." + error;
                    }
                    return null;
                };

                /**
                 * Creates a TWeatherCardData message from a plain object. Also converts values to their respective internal types.
                 * @function fromObject
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TWeatherCardData
                 * @static
                 * @param {Object.<string,*>} object Plain object
                 * @returns {NAlice.NData.TCentaurWidgetCardData.TWeatherCardData} TWeatherCardData
                 */
                TWeatherCardData.fromObject = function fromObject(object) {
                    if (object instanceof $root.NAlice.NData.TCentaurWidgetCardData.TWeatherCardData)
                        return object;
                    var message = new $root.NAlice.NData.TCentaurWidgetCardData.TWeatherCardData();
                    if (object.City != null)
                        message.City = String(object.City);
                    if (object.Temperature != null)
                        message.Temperature = object.Temperature | 0;
                    if (object.Image != null)
                        message.Image = String(object.Image);
                    if (object.Comment != null)
                        message.Comment = String(object.Comment);
                    if (object.Sunrise != null)
                        message.Sunrise = String(object.Sunrise);
                    if (object.Sunset != null)
                        message.Sunset = String(object.Sunset);
                    if (object.UserTime != null)
                        message.UserTime = String(object.UserTime);
                    if (object.Condition != null) {
                        if (typeof object.Condition !== "object")
                            throw TypeError(".NAlice.NData.TCentaurWidgetCardData.TWeatherCardData.Condition: object expected");
                        message.Condition = $root.NAlice.NData.TWeatherCondition.fromObject(object.Condition);
                    }
                    return message;
                };

                /**
                 * Creates a plain object from a TWeatherCardData message. Also converts values to other types if specified.
                 * @function toObject
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TWeatherCardData
                 * @static
                 * @param {NAlice.NData.TCentaurWidgetCardData.TWeatherCardData} message TWeatherCardData
                 * @param {$protobuf.IConversionOptions} [options] Conversion options
                 * @returns {Object.<string,*>} Plain object
                 */
                TWeatherCardData.toObject = function toObject(message, options) {
                    if (!options)
                        options = {};
                    var object = {};
                    if (options.defaults) {
                        object.City = "";
                        object.Temperature = 0;
                        object.Image = "";
                        object.Comment = "";
                        object.Sunrise = "";
                        object.Sunset = "";
                        object.UserTime = "";
                        object.Condition = null;
                    }
                    if (message.City != null && message.hasOwnProperty("City"))
                        object.City = message.City;
                    if (message.Temperature != null && message.hasOwnProperty("Temperature"))
                        object.Temperature = message.Temperature;
                    if (message.Image != null && message.hasOwnProperty("Image"))
                        object.Image = message.Image;
                    if (message.Comment != null && message.hasOwnProperty("Comment"))
                        object.Comment = message.Comment;
                    if (message.Sunrise != null && message.hasOwnProperty("Sunrise"))
                        object.Sunrise = message.Sunrise;
                    if (message.Sunset != null && message.hasOwnProperty("Sunset"))
                        object.Sunset = message.Sunset;
                    if (message.UserTime != null && message.hasOwnProperty("UserTime"))
                        object.UserTime = message.UserTime;
                    if (message.Condition != null && message.hasOwnProperty("Condition"))
                        object.Condition = $root.NAlice.NData.TWeatherCondition.toObject(message.Condition, options);
                    return object;
                };

                /**
                 * Converts this TWeatherCardData to JSON.
                 * @function toJSON
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TWeatherCardData
                 * @instance
                 * @returns {Object.<string,*>} JSON object
                 */
                TWeatherCardData.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };

                return TWeatherCardData;
            })();

            TCentaurWidgetCardData.TYouTubeCardData = (function() {

                /**
                 * Properties of a TYouTubeCardData.
                 * @memberof NAlice.NData.TCentaurWidgetCardData
                 * @interface ITYouTubeCardData
                 */

                /**
                 * Constructs a new TYouTubeCardData.
                 * @memberof NAlice.NData.TCentaurWidgetCardData
                 * @classdesc Represents a TYouTubeCardData.
                 * @implements ITYouTubeCardData
                 * @constructor
                 * @param {NAlice.NData.TCentaurWidgetCardData.ITYouTubeCardData=} [properties] Properties to set
                 */
                function TYouTubeCardData(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }

                /**
                 * Creates a new TYouTubeCardData instance using the specified properties.
                 * @function create
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TYouTubeCardData
                 * @static
                 * @param {NAlice.NData.TCentaurWidgetCardData.ITYouTubeCardData=} [properties] Properties to set
                 * @returns {NAlice.NData.TCentaurWidgetCardData.TYouTubeCardData} TYouTubeCardData instance
                 */
                TYouTubeCardData.create = function create(properties) {
                    return new TYouTubeCardData(properties);
                };

                /**
                 * Encodes the specified TYouTubeCardData message. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardData.TYouTubeCardData.verify|verify} messages.
                 * @function encode
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TYouTubeCardData
                 * @static
                 * @param {NAlice.NData.TCentaurWidgetCardData.ITYouTubeCardData} message TYouTubeCardData message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                TYouTubeCardData.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    return writer;
                };

                /**
                 * Encodes the specified TYouTubeCardData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardData.TYouTubeCardData.verify|verify} messages.
                 * @function encodeDelimited
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TYouTubeCardData
                 * @static
                 * @param {NAlice.NData.TCentaurWidgetCardData.ITYouTubeCardData} message TYouTubeCardData message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                TYouTubeCardData.encodeDelimited = function encodeDelimited(message, writer) {
                    return this.encode(message, writer).ldelim();
                };

                /**
                 * Decodes a TYouTubeCardData message from the specified reader or buffer.
                 * @function decode
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TYouTubeCardData
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {NAlice.NData.TCentaurWidgetCardData.TYouTubeCardData} TYouTubeCardData
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                TYouTubeCardData.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.NAlice.NData.TCentaurWidgetCardData.TYouTubeCardData();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };

                /**
                 * Decodes a TYouTubeCardData message from the specified reader or buffer, length delimited.
                 * @function decodeDelimited
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TYouTubeCardData
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @returns {NAlice.NData.TCentaurWidgetCardData.TYouTubeCardData} TYouTubeCardData
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                TYouTubeCardData.decodeDelimited = function decodeDelimited(reader) {
                    if (!(reader instanceof $Reader))
                        reader = new $Reader(reader);
                    return this.decode(reader, reader.uint32());
                };

                /**
                 * Verifies a TYouTubeCardData message.
                 * @function verify
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TYouTubeCardData
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                TYouTubeCardData.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    return null;
                };

                /**
                 * Creates a TYouTubeCardData message from a plain object. Also converts values to their respective internal types.
                 * @function fromObject
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TYouTubeCardData
                 * @static
                 * @param {Object.<string,*>} object Plain object
                 * @returns {NAlice.NData.TCentaurWidgetCardData.TYouTubeCardData} TYouTubeCardData
                 */
                TYouTubeCardData.fromObject = function fromObject(object) {
                    if (object instanceof $root.NAlice.NData.TCentaurWidgetCardData.TYouTubeCardData)
                        return object;
                    return new $root.NAlice.NData.TCentaurWidgetCardData.TYouTubeCardData();
                };

                /**
                 * Creates a plain object from a TYouTubeCardData message. Also converts values to other types if specified.
                 * @function toObject
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TYouTubeCardData
                 * @static
                 * @param {NAlice.NData.TCentaurWidgetCardData.TYouTubeCardData} message TYouTubeCardData
                 * @param {$protobuf.IConversionOptions} [options] Conversion options
                 * @returns {Object.<string,*>} Plain object
                 */
                TYouTubeCardData.toObject = function toObject() {
                    return {};
                };

                /**
                 * Converts this TYouTubeCardData to JSON.
                 * @function toJSON
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TYouTubeCardData
                 * @instance
                 * @returns {Object.<string,*>} JSON object
                 */
                TYouTubeCardData.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };

                return TYouTubeCardData;
            })();

            TCentaurWidgetCardData.TVacantCardData = (function() {

                /**
                 * Properties of a TVacantCardData.
                 * @memberof NAlice.NData.TCentaurWidgetCardData
                 * @interface ITVacantCardData
                 */

                /**
                 * Constructs a new TVacantCardData.
                 * @memberof NAlice.NData.TCentaurWidgetCardData
                 * @classdesc Represents a TVacantCardData.
                 * @implements ITVacantCardData
                 * @constructor
                 * @param {NAlice.NData.TCentaurWidgetCardData.ITVacantCardData=} [properties] Properties to set
                 */
                function TVacantCardData(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }

                /**
                 * Creates a new TVacantCardData instance using the specified properties.
                 * @function create
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TVacantCardData
                 * @static
                 * @param {NAlice.NData.TCentaurWidgetCardData.ITVacantCardData=} [properties] Properties to set
                 * @returns {NAlice.NData.TCentaurWidgetCardData.TVacantCardData} TVacantCardData instance
                 */
                TVacantCardData.create = function create(properties) {
                    return new TVacantCardData(properties);
                };

                /**
                 * Encodes the specified TVacantCardData message. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardData.TVacantCardData.verify|verify} messages.
                 * @function encode
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TVacantCardData
                 * @static
                 * @param {NAlice.NData.TCentaurWidgetCardData.ITVacantCardData} message TVacantCardData message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                TVacantCardData.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    return writer;
                };

                /**
                 * Encodes the specified TVacantCardData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardData.TVacantCardData.verify|verify} messages.
                 * @function encodeDelimited
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TVacantCardData
                 * @static
                 * @param {NAlice.NData.TCentaurWidgetCardData.ITVacantCardData} message TVacantCardData message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                TVacantCardData.encodeDelimited = function encodeDelimited(message, writer) {
                    return this.encode(message, writer).ldelim();
                };

                /**
                 * Decodes a TVacantCardData message from the specified reader or buffer.
                 * @function decode
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TVacantCardData
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {NAlice.NData.TCentaurWidgetCardData.TVacantCardData} TVacantCardData
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                TVacantCardData.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.NAlice.NData.TCentaurWidgetCardData.TVacantCardData();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };

                /**
                 * Decodes a TVacantCardData message from the specified reader or buffer, length delimited.
                 * @function decodeDelimited
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TVacantCardData
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @returns {NAlice.NData.TCentaurWidgetCardData.TVacantCardData} TVacantCardData
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                TVacantCardData.decodeDelimited = function decodeDelimited(reader) {
                    if (!(reader instanceof $Reader))
                        reader = new $Reader(reader);
                    return this.decode(reader, reader.uint32());
                };

                /**
                 * Verifies a TVacantCardData message.
                 * @function verify
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TVacantCardData
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                TVacantCardData.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    return null;
                };

                /**
                 * Creates a TVacantCardData message from a plain object. Also converts values to their respective internal types.
                 * @function fromObject
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TVacantCardData
                 * @static
                 * @param {Object.<string,*>} object Plain object
                 * @returns {NAlice.NData.TCentaurWidgetCardData.TVacantCardData} TVacantCardData
                 */
                TVacantCardData.fromObject = function fromObject(object) {
                    if (object instanceof $root.NAlice.NData.TCentaurWidgetCardData.TVacantCardData)
                        return object;
                    return new $root.NAlice.NData.TCentaurWidgetCardData.TVacantCardData();
                };

                /**
                 * Creates a plain object from a TVacantCardData message. Also converts values to other types if specified.
                 * @function toObject
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TVacantCardData
                 * @static
                 * @param {NAlice.NData.TCentaurWidgetCardData.TVacantCardData} message TVacantCardData
                 * @param {$protobuf.IConversionOptions} [options] Conversion options
                 * @returns {Object.<string,*>} Plain object
                 */
                TVacantCardData.toObject = function toObject() {
                    return {};
                };

                /**
                 * Converts this TVacantCardData to JSON.
                 * @function toJSON
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TVacantCardData
                 * @instance
                 * @returns {Object.<string,*>} JSON object
                 */
                TVacantCardData.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };

                return TVacantCardData;
            })();

            TCentaurWidgetCardData.TTrafficCardData = (function() {

                /**
                 * Properties of a TTrafficCardData.
                 * @memberof NAlice.NData.TCentaurWidgetCardData
                 * @interface ITTrafficCardData
                 * @property {string|null} [City] TTrafficCardData City
                 * @property {string|null} [Message] TTrafficCardData Message
                 * @property {string|null} [MapUrl] TTrafficCardData MapUrl
                 * @property {string|null} [ImageUrl] TTrafficCardData ImageUrl
                 * @property {string|null} [Level] TTrafficCardData Level
                 * @property {number|null} [Score] TTrafficCardData Score
                 * @property {Array.<NAlice.NData.TCentaurWidgetCardData.TTrafficCardData.ITTrafficForecastData>|null} [Forecast] TTrafficCardData Forecast
                 */

                /**
                 * Constructs a new TTrafficCardData.
                 * @memberof NAlice.NData.TCentaurWidgetCardData
                 * @classdesc Represents a TTrafficCardData.
                 * @implements ITTrafficCardData
                 * @constructor
                 * @param {NAlice.NData.TCentaurWidgetCardData.ITTrafficCardData=} [properties] Properties to set
                 */
                function TTrafficCardData(properties) {
                    this.Forecast = [];
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }

                /**
                 * TTrafficCardData City.
                 * @member {string} City
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TTrafficCardData
                 * @instance
                 */
                TTrafficCardData.prototype.City = "";

                /**
                 * TTrafficCardData Message.
                 * @member {string} Message
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TTrafficCardData
                 * @instance
                 */
                TTrafficCardData.prototype.Message = "";

                /**
                 * TTrafficCardData MapUrl.
                 * @member {string} MapUrl
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TTrafficCardData
                 * @instance
                 */
                TTrafficCardData.prototype.MapUrl = "";

                /**
                 * TTrafficCardData ImageUrl.
                 * @member {string} ImageUrl
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TTrafficCardData
                 * @instance
                 */
                TTrafficCardData.prototype.ImageUrl = "";

                /**
                 * TTrafficCardData Level.
                 * @member {string} Level
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TTrafficCardData
                 * @instance
                 */
                TTrafficCardData.prototype.Level = "";

                /**
                 * TTrafficCardData Score.
                 * @member {number} Score
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TTrafficCardData
                 * @instance
                 */
                TTrafficCardData.prototype.Score = 0;

                /**
                 * TTrafficCardData Forecast.
                 * @member {Array.<NAlice.NData.TCentaurWidgetCardData.TTrafficCardData.ITTrafficForecastData>} Forecast
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TTrafficCardData
                 * @instance
                 */
                TTrafficCardData.prototype.Forecast = $util.emptyArray;

                /**
                 * Creates a new TTrafficCardData instance using the specified properties.
                 * @function create
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TTrafficCardData
                 * @static
                 * @param {NAlice.NData.TCentaurWidgetCardData.ITTrafficCardData=} [properties] Properties to set
                 * @returns {NAlice.NData.TCentaurWidgetCardData.TTrafficCardData} TTrafficCardData instance
                 */
                TTrafficCardData.create = function create(properties) {
                    return new TTrafficCardData(properties);
                };

                /**
                 * Encodes the specified TTrafficCardData message. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardData.TTrafficCardData.verify|verify} messages.
                 * @function encode
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TTrafficCardData
                 * @static
                 * @param {NAlice.NData.TCentaurWidgetCardData.ITTrafficCardData} message TTrafficCardData message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                TTrafficCardData.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.City != null && Object.hasOwnProperty.call(message, "City"))
                        writer.uint32(/* id 1, wireType 2 =*/10).string(message.City);
                    if (message.Message != null && Object.hasOwnProperty.call(message, "Message"))
                        writer.uint32(/* id 2, wireType 2 =*/18).string(message.Message);
                    if (message.MapUrl != null && Object.hasOwnProperty.call(message, "MapUrl"))
                        writer.uint32(/* id 3, wireType 2 =*/26).string(message.MapUrl);
                    if (message.ImageUrl != null && Object.hasOwnProperty.call(message, "ImageUrl"))
                        writer.uint32(/* id 4, wireType 2 =*/34).string(message.ImageUrl);
                    if (message.Level != null && Object.hasOwnProperty.call(message, "Level"))
                        writer.uint32(/* id 5, wireType 2 =*/42).string(message.Level);
                    if (message.Score != null && Object.hasOwnProperty.call(message, "Score"))
                        writer.uint32(/* id 6, wireType 0 =*/48).int32(message.Score);
                    if (message.Forecast != null && message.Forecast.length)
                        for (var i = 0; i < message.Forecast.length; ++i)
                            $root.NAlice.NData.TCentaurWidgetCardData.TTrafficCardData.TTrafficForecastData.encode(message.Forecast[i], writer.uint32(/* id 7, wireType 2 =*/58).fork()).ldelim();
                    return writer;
                };

                /**
                 * Encodes the specified TTrafficCardData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardData.TTrafficCardData.verify|verify} messages.
                 * @function encodeDelimited
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TTrafficCardData
                 * @static
                 * @param {NAlice.NData.TCentaurWidgetCardData.ITTrafficCardData} message TTrafficCardData message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                TTrafficCardData.encodeDelimited = function encodeDelimited(message, writer) {
                    return this.encode(message, writer).ldelim();
                };

                /**
                 * Decodes a TTrafficCardData message from the specified reader or buffer.
                 * @function decode
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TTrafficCardData
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {NAlice.NData.TCentaurWidgetCardData.TTrafficCardData} TTrafficCardData
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                TTrafficCardData.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.NAlice.NData.TCentaurWidgetCardData.TTrafficCardData();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.City = reader.string();
                            break;
                        case 2:
                            message.Message = reader.string();
                            break;
                        case 3:
                            message.MapUrl = reader.string();
                            break;
                        case 4:
                            message.ImageUrl = reader.string();
                            break;
                        case 5:
                            message.Level = reader.string();
                            break;
                        case 6:
                            message.Score = reader.int32();
                            break;
                        case 7:
                            if (!(message.Forecast && message.Forecast.length))
                                message.Forecast = [];
                            message.Forecast.push($root.NAlice.NData.TCentaurWidgetCardData.TTrafficCardData.TTrafficForecastData.decode(reader, reader.uint32()));
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };

                /**
                 * Decodes a TTrafficCardData message from the specified reader or buffer, length delimited.
                 * @function decodeDelimited
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TTrafficCardData
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @returns {NAlice.NData.TCentaurWidgetCardData.TTrafficCardData} TTrafficCardData
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                TTrafficCardData.decodeDelimited = function decodeDelimited(reader) {
                    if (!(reader instanceof $Reader))
                        reader = new $Reader(reader);
                    return this.decode(reader, reader.uint32());
                };

                /**
                 * Verifies a TTrafficCardData message.
                 * @function verify
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TTrafficCardData
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                TTrafficCardData.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.City != null && message.hasOwnProperty("City"))
                        if (!$util.isString(message.City))
                            return "City: string expected";
                    if (message.Message != null && message.hasOwnProperty("Message"))
                        if (!$util.isString(message.Message))
                            return "Message: string expected";
                    if (message.MapUrl != null && message.hasOwnProperty("MapUrl"))
                        if (!$util.isString(message.MapUrl))
                            return "MapUrl: string expected";
                    if (message.ImageUrl != null && message.hasOwnProperty("ImageUrl"))
                        if (!$util.isString(message.ImageUrl))
                            return "ImageUrl: string expected";
                    if (message.Level != null && message.hasOwnProperty("Level"))
                        if (!$util.isString(message.Level))
                            return "Level: string expected";
                    if (message.Score != null && message.hasOwnProperty("Score"))
                        if (!$util.isInteger(message.Score))
                            return "Score: integer expected";
                    if (message.Forecast != null && message.hasOwnProperty("Forecast")) {
                        if (!Array.isArray(message.Forecast))
                            return "Forecast: array expected";
                        for (var i = 0; i < message.Forecast.length; ++i) {
                            var error = $root.NAlice.NData.TCentaurWidgetCardData.TTrafficCardData.TTrafficForecastData.verify(message.Forecast[i]);
                            if (error)
                                return "Forecast." + error;
                        }
                    }
                    return null;
                };

                /**
                 * Creates a TTrafficCardData message from a plain object. Also converts values to their respective internal types.
                 * @function fromObject
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TTrafficCardData
                 * @static
                 * @param {Object.<string,*>} object Plain object
                 * @returns {NAlice.NData.TCentaurWidgetCardData.TTrafficCardData} TTrafficCardData
                 */
                TTrafficCardData.fromObject = function fromObject(object) {
                    if (object instanceof $root.NAlice.NData.TCentaurWidgetCardData.TTrafficCardData)
                        return object;
                    var message = new $root.NAlice.NData.TCentaurWidgetCardData.TTrafficCardData();
                    if (object.City != null)
                        message.City = String(object.City);
                    if (object.Message != null)
                        message.Message = String(object.Message);
                    if (object.MapUrl != null)
                        message.MapUrl = String(object.MapUrl);
                    if (object.ImageUrl != null)
                        message.ImageUrl = String(object.ImageUrl);
                    if (object.Level != null)
                        message.Level = String(object.Level);
                    if (object.Score != null)
                        message.Score = object.Score | 0;
                    if (object.Forecast) {
                        if (!Array.isArray(object.Forecast))
                            throw TypeError(".NAlice.NData.TCentaurWidgetCardData.TTrafficCardData.Forecast: array expected");
                        message.Forecast = [];
                        for (var i = 0; i < object.Forecast.length; ++i) {
                            if (typeof object.Forecast[i] !== "object")
                                throw TypeError(".NAlice.NData.TCentaurWidgetCardData.TTrafficCardData.Forecast: object expected");
                            message.Forecast[i] = $root.NAlice.NData.TCentaurWidgetCardData.TTrafficCardData.TTrafficForecastData.fromObject(object.Forecast[i]);
                        }
                    }
                    return message;
                };

                /**
                 * Creates a plain object from a TTrafficCardData message. Also converts values to other types if specified.
                 * @function toObject
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TTrafficCardData
                 * @static
                 * @param {NAlice.NData.TCentaurWidgetCardData.TTrafficCardData} message TTrafficCardData
                 * @param {$protobuf.IConversionOptions} [options] Conversion options
                 * @returns {Object.<string,*>} Plain object
                 */
                TTrafficCardData.toObject = function toObject(message, options) {
                    if (!options)
                        options = {};
                    var object = {};
                    if (options.arrays || options.defaults)
                        object.Forecast = [];
                    if (options.defaults) {
                        object.City = "";
                        object.Message = "";
                        object.MapUrl = "";
                        object.ImageUrl = "";
                        object.Level = "";
                        object.Score = 0;
                    }
                    if (message.City != null && message.hasOwnProperty("City"))
                        object.City = message.City;
                    if (message.Message != null && message.hasOwnProperty("Message"))
                        object.Message = message.Message;
                    if (message.MapUrl != null && message.hasOwnProperty("MapUrl"))
                        object.MapUrl = message.MapUrl;
                    if (message.ImageUrl != null && message.hasOwnProperty("ImageUrl"))
                        object.ImageUrl = message.ImageUrl;
                    if (message.Level != null && message.hasOwnProperty("Level"))
                        object.Level = message.Level;
                    if (message.Score != null && message.hasOwnProperty("Score"))
                        object.Score = message.Score;
                    if (message.Forecast && message.Forecast.length) {
                        object.Forecast = [];
                        for (var j = 0; j < message.Forecast.length; ++j)
                            object.Forecast[j] = $root.NAlice.NData.TCentaurWidgetCardData.TTrafficCardData.TTrafficForecastData.toObject(message.Forecast[j], options);
                    }
                    return object;
                };

                /**
                 * Converts this TTrafficCardData to JSON.
                 * @function toJSON
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TTrafficCardData
                 * @instance
                 * @returns {Object.<string,*>} JSON object
                 */
                TTrafficCardData.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };

                TTrafficCardData.TTrafficForecastData = (function() {

                    /**
                     * Properties of a TTrafficForecastData.
                     * @memberof NAlice.NData.TCentaurWidgetCardData.TTrafficCardData
                     * @interface ITTrafficForecastData
                     * @property {number|null} [Hour] TTrafficForecastData Hour
                     * @property {number|null} [Score] TTrafficForecastData Score
                     */

                    /**
                     * Constructs a new TTrafficForecastData.
                     * @memberof NAlice.NData.TCentaurWidgetCardData.TTrafficCardData
                     * @classdesc Represents a TTrafficForecastData.
                     * @implements ITTrafficForecastData
                     * @constructor
                     * @param {NAlice.NData.TCentaurWidgetCardData.TTrafficCardData.ITTrafficForecastData=} [properties] Properties to set
                     */
                    function TTrafficForecastData(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }

                    /**
                     * TTrafficForecastData Hour.
                     * @member {number} Hour
                     * @memberof NAlice.NData.TCentaurWidgetCardData.TTrafficCardData.TTrafficForecastData
                     * @instance
                     */
                    TTrafficForecastData.prototype.Hour = 0;

                    /**
                     * TTrafficForecastData Score.
                     * @member {number} Score
                     * @memberof NAlice.NData.TCentaurWidgetCardData.TTrafficCardData.TTrafficForecastData
                     * @instance
                     */
                    TTrafficForecastData.prototype.Score = 0;

                    /**
                     * Creates a new TTrafficForecastData instance using the specified properties.
                     * @function create
                     * @memberof NAlice.NData.TCentaurWidgetCardData.TTrafficCardData.TTrafficForecastData
                     * @static
                     * @param {NAlice.NData.TCentaurWidgetCardData.TTrafficCardData.ITTrafficForecastData=} [properties] Properties to set
                     * @returns {NAlice.NData.TCentaurWidgetCardData.TTrafficCardData.TTrafficForecastData} TTrafficForecastData instance
                     */
                    TTrafficForecastData.create = function create(properties) {
                        return new TTrafficForecastData(properties);
                    };

                    /**
                     * Encodes the specified TTrafficForecastData message. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardData.TTrafficCardData.TTrafficForecastData.verify|verify} messages.
                     * @function encode
                     * @memberof NAlice.NData.TCentaurWidgetCardData.TTrafficCardData.TTrafficForecastData
                     * @static
                     * @param {NAlice.NData.TCentaurWidgetCardData.TTrafficCardData.ITTrafficForecastData} message TTrafficForecastData message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    TTrafficForecastData.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.Hour != null && Object.hasOwnProperty.call(message, "Hour"))
                            writer.uint32(/* id 1, wireType 0 =*/8).int32(message.Hour);
                        if (message.Score != null && Object.hasOwnProperty.call(message, "Score"))
                            writer.uint32(/* id 2, wireType 0 =*/16).int32(message.Score);
                        return writer;
                    };

                    /**
                     * Encodes the specified TTrafficForecastData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardData.TTrafficCardData.TTrafficForecastData.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof NAlice.NData.TCentaurWidgetCardData.TTrafficCardData.TTrafficForecastData
                     * @static
                     * @param {NAlice.NData.TCentaurWidgetCardData.TTrafficCardData.ITTrafficForecastData} message TTrafficForecastData message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    TTrafficForecastData.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };

                    /**
                     * Decodes a TTrafficForecastData message from the specified reader or buffer.
                     * @function decode
                     * @memberof NAlice.NData.TCentaurWidgetCardData.TTrafficCardData.TTrafficForecastData
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {NAlice.NData.TCentaurWidgetCardData.TTrafficCardData.TTrafficForecastData} TTrafficForecastData
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    TTrafficForecastData.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.NAlice.NData.TCentaurWidgetCardData.TTrafficCardData.TTrafficForecastData();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 1:
                                message.Hour = reader.int32();
                                break;
                            case 2:
                                message.Score = reader.int32();
                                break;
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };

                    /**
                     * Decodes a TTrafficForecastData message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof NAlice.NData.TCentaurWidgetCardData.TTrafficCardData.TTrafficForecastData
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {NAlice.NData.TCentaurWidgetCardData.TTrafficCardData.TTrafficForecastData} TTrafficForecastData
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    TTrafficForecastData.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };

                    /**
                     * Verifies a TTrafficForecastData message.
                     * @function verify
                     * @memberof NAlice.NData.TCentaurWidgetCardData.TTrafficCardData.TTrafficForecastData
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    TTrafficForecastData.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.Hour != null && message.hasOwnProperty("Hour"))
                            if (!$util.isInteger(message.Hour))
                                return "Hour: integer expected";
                        if (message.Score != null && message.hasOwnProperty("Score"))
                            if (!$util.isInteger(message.Score))
                                return "Score: integer expected";
                        return null;
                    };

                    /**
                     * Creates a TTrafficForecastData message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof NAlice.NData.TCentaurWidgetCardData.TTrafficCardData.TTrafficForecastData
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {NAlice.NData.TCentaurWidgetCardData.TTrafficCardData.TTrafficForecastData} TTrafficForecastData
                     */
                    TTrafficForecastData.fromObject = function fromObject(object) {
                        if (object instanceof $root.NAlice.NData.TCentaurWidgetCardData.TTrafficCardData.TTrafficForecastData)
                            return object;
                        var message = new $root.NAlice.NData.TCentaurWidgetCardData.TTrafficCardData.TTrafficForecastData();
                        if (object.Hour != null)
                            message.Hour = object.Hour | 0;
                        if (object.Score != null)
                            message.Score = object.Score | 0;
                        return message;
                    };

                    /**
                     * Creates a plain object from a TTrafficForecastData message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof NAlice.NData.TCentaurWidgetCardData.TTrafficCardData.TTrafficForecastData
                     * @static
                     * @param {NAlice.NData.TCentaurWidgetCardData.TTrafficCardData.TTrafficForecastData} message TTrafficForecastData
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    TTrafficForecastData.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.defaults) {
                            object.Hour = 0;
                            object.Score = 0;
                        }
                        if (message.Hour != null && message.hasOwnProperty("Hour"))
                            object.Hour = message.Hour;
                        if (message.Score != null && message.hasOwnProperty("Score"))
                            object.Score = message.Score;
                        return object;
                    };

                    /**
                     * Converts this TTrafficForecastData to JSON.
                     * @function toJSON
                     * @memberof NAlice.NData.TCentaurWidgetCardData.TTrafficCardData.TTrafficForecastData
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    TTrafficForecastData.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };

                    return TTrafficForecastData;
                })();

                return TTrafficCardData;
            })();

            TCentaurWidgetCardData.TVideoCallCardData = (function() {

                /**
                 * Properties of a TVideoCallCardData.
                 * @memberof NAlice.NData.TCentaurWidgetCardData
                 * @interface ITVideoCallCardData
                 * @property {NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.ITLoggedOutCardData|null} [LoggedOutCardData] TVideoCallCardData LoggedOutCardData
                 * @property {NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.ITLoggedInCardData|null} [LoggedInCardData] TVideoCallCardData LoggedInCardData
                 */

                /**
                 * Constructs a new TVideoCallCardData.
                 * @memberof NAlice.NData.TCentaurWidgetCardData
                 * @classdesc Represents a TVideoCallCardData.
                 * @implements ITVideoCallCardData
                 * @constructor
                 * @param {NAlice.NData.TCentaurWidgetCardData.ITVideoCallCardData=} [properties] Properties to set
                 */
                function TVideoCallCardData(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }

                /**
                 * TVideoCallCardData LoggedOutCardData.
                 * @member {NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.ITLoggedOutCardData|null|undefined} LoggedOutCardData
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData
                 * @instance
                 */
                TVideoCallCardData.prototype.LoggedOutCardData = null;

                /**
                 * TVideoCallCardData LoggedInCardData.
                 * @member {NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.ITLoggedInCardData|null|undefined} LoggedInCardData
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData
                 * @instance
                 */
                TVideoCallCardData.prototype.LoggedInCardData = null;

                // OneOf field names bound to virtual getters and setters
                var $oneOfFields;

                /**
                 * TVideoCallCardData CardTypeData.
                 * @member {"LoggedOutCardData"|"LoggedInCardData"|undefined} CardTypeData
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData
                 * @instance
                 */
                Object.defineProperty(TVideoCallCardData.prototype, "CardTypeData", {
                    get: $util.oneOfGetter($oneOfFields = ["LoggedOutCardData", "LoggedInCardData"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                /**
                 * Creates a new TVideoCallCardData instance using the specified properties.
                 * @function create
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData
                 * @static
                 * @param {NAlice.NData.TCentaurWidgetCardData.ITVideoCallCardData=} [properties] Properties to set
                 * @returns {NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData} TVideoCallCardData instance
                 */
                TVideoCallCardData.create = function create(properties) {
                    return new TVideoCallCardData(properties);
                };

                /**
                 * Encodes the specified TVideoCallCardData message. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.verify|verify} messages.
                 * @function encode
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData
                 * @static
                 * @param {NAlice.NData.TCentaurWidgetCardData.ITVideoCallCardData} message TVideoCallCardData message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                TVideoCallCardData.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.LoggedOutCardData != null && Object.hasOwnProperty.call(message, "LoggedOutCardData"))
                        $root.NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedOutCardData.encode(message.LoggedOutCardData, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                    if (message.LoggedInCardData != null && Object.hasOwnProperty.call(message, "LoggedInCardData"))
                        $root.NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.encode(message.LoggedInCardData, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                    return writer;
                };

                /**
                 * Encodes the specified TVideoCallCardData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.verify|verify} messages.
                 * @function encodeDelimited
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData
                 * @static
                 * @param {NAlice.NData.TCentaurWidgetCardData.ITVideoCallCardData} message TVideoCallCardData message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                TVideoCallCardData.encodeDelimited = function encodeDelimited(message, writer) {
                    return this.encode(message, writer).ldelim();
                };

                /**
                 * Decodes a TVideoCallCardData message from the specified reader or buffer.
                 * @function decode
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData} TVideoCallCardData
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                TVideoCallCardData.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.LoggedOutCardData = $root.NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedOutCardData.decode(reader, reader.uint32());
                            break;
                        case 2:
                            message.LoggedInCardData = $root.NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.decode(reader, reader.uint32());
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };

                /**
                 * Decodes a TVideoCallCardData message from the specified reader or buffer, length delimited.
                 * @function decodeDelimited
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @returns {NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData} TVideoCallCardData
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                TVideoCallCardData.decodeDelimited = function decodeDelimited(reader) {
                    if (!(reader instanceof $Reader))
                        reader = new $Reader(reader);
                    return this.decode(reader, reader.uint32());
                };

                /**
                 * Verifies a TVideoCallCardData message.
                 * @function verify
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                TVideoCallCardData.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    var properties = {};
                    if (message.LoggedOutCardData != null && message.hasOwnProperty("LoggedOutCardData")) {
                        properties.CardTypeData = 1;
                        {
                            var error = $root.NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedOutCardData.verify(message.LoggedOutCardData);
                            if (error)
                                return "LoggedOutCardData." + error;
                        }
                    }
                    if (message.LoggedInCardData != null && message.hasOwnProperty("LoggedInCardData")) {
                        if (properties.CardTypeData === 1)
                            return "CardTypeData: multiple values";
                        properties.CardTypeData = 1;
                        {
                            var error = $root.NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.verify(message.LoggedInCardData);
                            if (error)
                                return "LoggedInCardData." + error;
                        }
                    }
                    return null;
                };

                /**
                 * Creates a TVideoCallCardData message from a plain object. Also converts values to their respective internal types.
                 * @function fromObject
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData
                 * @static
                 * @param {Object.<string,*>} object Plain object
                 * @returns {NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData} TVideoCallCardData
                 */
                TVideoCallCardData.fromObject = function fromObject(object) {
                    if (object instanceof $root.NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData)
                        return object;
                    var message = new $root.NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData();
                    if (object.LoggedOutCardData != null) {
                        if (typeof object.LoggedOutCardData !== "object")
                            throw TypeError(".NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.LoggedOutCardData: object expected");
                        message.LoggedOutCardData = $root.NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedOutCardData.fromObject(object.LoggedOutCardData);
                    }
                    if (object.LoggedInCardData != null) {
                        if (typeof object.LoggedInCardData !== "object")
                            throw TypeError(".NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.LoggedInCardData: object expected");
                        message.LoggedInCardData = $root.NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.fromObject(object.LoggedInCardData);
                    }
                    return message;
                };

                /**
                 * Creates a plain object from a TVideoCallCardData message. Also converts values to other types if specified.
                 * @function toObject
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData
                 * @static
                 * @param {NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData} message TVideoCallCardData
                 * @param {$protobuf.IConversionOptions} [options] Conversion options
                 * @returns {Object.<string,*>} Plain object
                 */
                TVideoCallCardData.toObject = function toObject(message, options) {
                    if (!options)
                        options = {};
                    var object = {};
                    if (message.LoggedOutCardData != null && message.hasOwnProperty("LoggedOutCardData")) {
                        object.LoggedOutCardData = $root.NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedOutCardData.toObject(message.LoggedOutCardData, options);
                        if (options.oneofs)
                            object.CardTypeData = "LoggedOutCardData";
                    }
                    if (message.LoggedInCardData != null && message.hasOwnProperty("LoggedInCardData")) {
                        object.LoggedInCardData = $root.NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.toObject(message.LoggedInCardData, options);
                        if (options.oneofs)
                            object.CardTypeData = "LoggedInCardData";
                    }
                    return object;
                };

                /**
                 * Converts this TVideoCallCardData to JSON.
                 * @function toJSON
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData
                 * @instance
                 * @returns {Object.<string,*>} JSON object
                 */
                TVideoCallCardData.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };

                TVideoCallCardData.TLoggedOutCardData = (function() {

                    /**
                     * Properties of a TLoggedOutCardData.
                     * @memberof NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData
                     * @interface ITLoggedOutCardData
                     */

                    /**
                     * Constructs a new TLoggedOutCardData.
                     * @memberof NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData
                     * @classdesc Represents a TLoggedOutCardData.
                     * @implements ITLoggedOutCardData
                     * @constructor
                     * @param {NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.ITLoggedOutCardData=} [properties] Properties to set
                     */
                    function TLoggedOutCardData(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }

                    /**
                     * Creates a new TLoggedOutCardData instance using the specified properties.
                     * @function create
                     * @memberof NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedOutCardData
                     * @static
                     * @param {NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.ITLoggedOutCardData=} [properties] Properties to set
                     * @returns {NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedOutCardData} TLoggedOutCardData instance
                     */
                    TLoggedOutCardData.create = function create(properties) {
                        return new TLoggedOutCardData(properties);
                    };

                    /**
                     * Encodes the specified TLoggedOutCardData message. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedOutCardData.verify|verify} messages.
                     * @function encode
                     * @memberof NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedOutCardData
                     * @static
                     * @param {NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.ITLoggedOutCardData} message TLoggedOutCardData message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    TLoggedOutCardData.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        return writer;
                    };

                    /**
                     * Encodes the specified TLoggedOutCardData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedOutCardData.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedOutCardData
                     * @static
                     * @param {NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.ITLoggedOutCardData} message TLoggedOutCardData message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    TLoggedOutCardData.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };

                    /**
                     * Decodes a TLoggedOutCardData message from the specified reader or buffer.
                     * @function decode
                     * @memberof NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedOutCardData
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedOutCardData} TLoggedOutCardData
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    TLoggedOutCardData.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedOutCardData();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };

                    /**
                     * Decodes a TLoggedOutCardData message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedOutCardData
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedOutCardData} TLoggedOutCardData
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    TLoggedOutCardData.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };

                    /**
                     * Verifies a TLoggedOutCardData message.
                     * @function verify
                     * @memberof NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedOutCardData
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    TLoggedOutCardData.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        return null;
                    };

                    /**
                     * Creates a TLoggedOutCardData message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedOutCardData
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedOutCardData} TLoggedOutCardData
                     */
                    TLoggedOutCardData.fromObject = function fromObject(object) {
                        if (object instanceof $root.NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedOutCardData)
                            return object;
                        return new $root.NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedOutCardData();
                    };

                    /**
                     * Creates a plain object from a TLoggedOutCardData message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedOutCardData
                     * @static
                     * @param {NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedOutCardData} message TLoggedOutCardData
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    TLoggedOutCardData.toObject = function toObject() {
                        return {};
                    };

                    /**
                     * Converts this TLoggedOutCardData to JSON.
                     * @function toJSON
                     * @memberof NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedOutCardData
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    TLoggedOutCardData.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };

                    return TLoggedOutCardData;
                })();

                TVideoCallCardData.TLoggedInCardData = (function() {

                    /**
                     * Properties of a TLoggedInCardData.
                     * @memberof NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData
                     * @interface ITLoggedInCardData
                     * @property {NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.ITTelegramCardData|null} [TelegramCardData] TLoggedInCardData TelegramCardData
                     */

                    /**
                     * Constructs a new TLoggedInCardData.
                     * @memberof NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData
                     * @classdesc Represents a TLoggedInCardData.
                     * @implements ITLoggedInCardData
                     * @constructor
                     * @param {NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.ITLoggedInCardData=} [properties] Properties to set
                     */
                    function TLoggedInCardData(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }

                    /**
                     * TLoggedInCardData TelegramCardData.
                     * @member {NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.ITTelegramCardData|null|undefined} TelegramCardData
                     * @memberof NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData
                     * @instance
                     */
                    TLoggedInCardData.prototype.TelegramCardData = null;

                    // OneOf field names bound to virtual getters and setters
                    var $oneOfFields;

                    /**
                     * TLoggedInCardData ProviderData.
                     * @member {"TelegramCardData"|undefined} ProviderData
                     * @memberof NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData
                     * @instance
                     */
                    Object.defineProperty(TLoggedInCardData.prototype, "ProviderData", {
                        get: $util.oneOfGetter($oneOfFields = ["TelegramCardData"]),
                        set: $util.oneOfSetter($oneOfFields)
                    });

                    /**
                     * Creates a new TLoggedInCardData instance using the specified properties.
                     * @function create
                     * @memberof NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData
                     * @static
                     * @param {NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.ITLoggedInCardData=} [properties] Properties to set
                     * @returns {NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData} TLoggedInCardData instance
                     */
                    TLoggedInCardData.create = function create(properties) {
                        return new TLoggedInCardData(properties);
                    };

                    /**
                     * Encodes the specified TLoggedInCardData message. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.verify|verify} messages.
                     * @function encode
                     * @memberof NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData
                     * @static
                     * @param {NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.ITLoggedInCardData} message TLoggedInCardData message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    TLoggedInCardData.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.TelegramCardData != null && Object.hasOwnProperty.call(message, "TelegramCardData"))
                            $root.NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.TTelegramCardData.encode(message.TelegramCardData, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                        return writer;
                    };

                    /**
                     * Encodes the specified TLoggedInCardData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData
                     * @static
                     * @param {NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.ITLoggedInCardData} message TLoggedInCardData message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    TLoggedInCardData.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };

                    /**
                     * Decodes a TLoggedInCardData message from the specified reader or buffer.
                     * @function decode
                     * @memberof NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData} TLoggedInCardData
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    TLoggedInCardData.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 1:
                                message.TelegramCardData = $root.NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.TTelegramCardData.decode(reader, reader.uint32());
                                break;
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };

                    /**
                     * Decodes a TLoggedInCardData message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData} TLoggedInCardData
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    TLoggedInCardData.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };

                    /**
                     * Verifies a TLoggedInCardData message.
                     * @function verify
                     * @memberof NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    TLoggedInCardData.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        var properties = {};
                        if (message.TelegramCardData != null && message.hasOwnProperty("TelegramCardData")) {
                            properties.ProviderData = 1;
                            {
                                var error = $root.NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.TTelegramCardData.verify(message.TelegramCardData);
                                if (error)
                                    return "TelegramCardData." + error;
                            }
                        }
                        return null;
                    };

                    /**
                     * Creates a TLoggedInCardData message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData} TLoggedInCardData
                     */
                    TLoggedInCardData.fromObject = function fromObject(object) {
                        if (object instanceof $root.NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData)
                            return object;
                        var message = new $root.NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData();
                        if (object.TelegramCardData != null) {
                            if (typeof object.TelegramCardData !== "object")
                                throw TypeError(".NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.TelegramCardData: object expected");
                            message.TelegramCardData = $root.NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.TTelegramCardData.fromObject(object.TelegramCardData);
                        }
                        return message;
                    };

                    /**
                     * Creates a plain object from a TLoggedInCardData message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData
                     * @static
                     * @param {NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData} message TLoggedInCardData
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    TLoggedInCardData.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (message.TelegramCardData != null && message.hasOwnProperty("TelegramCardData")) {
                            object.TelegramCardData = $root.NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.TTelegramCardData.toObject(message.TelegramCardData, options);
                            if (options.oneofs)
                                object.ProviderData = "TelegramCardData";
                        }
                        return object;
                    };

                    /**
                     * Converts this TLoggedInCardData to JSON.
                     * @function toJSON
                     * @memberof NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    TLoggedInCardData.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };

                    TLoggedInCardData.TTelegramCardData = (function() {

                        /**
                         * Properties of a TTelegramCardData.
                         * @memberof NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData
                         * @interface ITTelegramCardData
                         * @property {string|null} [UserId] TTelegramCardData UserId
                         * @property {boolean|null} [ContactsUploaded] TTelegramCardData ContactsUploaded
                         * @property {Array.<NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.ITFavoriteContactData>|null} [FavoriteContactData] TTelegramCardData FavoriteContactData
                         */

                        /**
                         * Constructs a new TTelegramCardData.
                         * @memberof NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData
                         * @classdesc Represents a TTelegramCardData.
                         * @implements ITTelegramCardData
                         * @constructor
                         * @param {NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.ITTelegramCardData=} [properties] Properties to set
                         */
                        function TTelegramCardData(properties) {
                            this.FavoriteContactData = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * TTelegramCardData UserId.
                         * @member {string} UserId
                         * @memberof NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.TTelegramCardData
                         * @instance
                         */
                        TTelegramCardData.prototype.UserId = "";

                        /**
                         * TTelegramCardData ContactsUploaded.
                         * @member {boolean} ContactsUploaded
                         * @memberof NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.TTelegramCardData
                         * @instance
                         */
                        TTelegramCardData.prototype.ContactsUploaded = false;

                        /**
                         * TTelegramCardData FavoriteContactData.
                         * @member {Array.<NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.ITFavoriteContactData>} FavoriteContactData
                         * @memberof NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.TTelegramCardData
                         * @instance
                         */
                        TTelegramCardData.prototype.FavoriteContactData = $util.emptyArray;

                        /**
                         * Creates a new TTelegramCardData instance using the specified properties.
                         * @function create
                         * @memberof NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.TTelegramCardData
                         * @static
                         * @param {NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.ITTelegramCardData=} [properties] Properties to set
                         * @returns {NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.TTelegramCardData} TTelegramCardData instance
                         */
                        TTelegramCardData.create = function create(properties) {
                            return new TTelegramCardData(properties);
                        };

                        /**
                         * Encodes the specified TTelegramCardData message. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.TTelegramCardData.verify|verify} messages.
                         * @function encode
                         * @memberof NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.TTelegramCardData
                         * @static
                         * @param {NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.ITTelegramCardData} message TTelegramCardData message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        TTelegramCardData.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.UserId != null && Object.hasOwnProperty.call(message, "UserId"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.UserId);
                            if (message.ContactsUploaded != null && Object.hasOwnProperty.call(message, "ContactsUploaded"))
                                writer.uint32(/* id 2, wireType 0 =*/16).bool(message.ContactsUploaded);
                            if (message.FavoriteContactData != null && message.FavoriteContactData.length)
                                for (var i = 0; i < message.FavoriteContactData.length; ++i)
                                    $root.NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.TFavoriteContactData.encode(message.FavoriteContactData[i], writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                            return writer;
                        };

                        /**
                         * Encodes the specified TTelegramCardData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.TTelegramCardData.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.TTelegramCardData
                         * @static
                         * @param {NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.ITTelegramCardData} message TTelegramCardData message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        TTelegramCardData.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a TTelegramCardData message from the specified reader or buffer.
                         * @function decode
                         * @memberof NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.TTelegramCardData
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.TTelegramCardData} TTelegramCardData
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        TTelegramCardData.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.TTelegramCardData();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.UserId = reader.string();
                                    break;
                                case 2:
                                    message.ContactsUploaded = reader.bool();
                                    break;
                                case 3:
                                    if (!(message.FavoriteContactData && message.FavoriteContactData.length))
                                        message.FavoriteContactData = [];
                                    message.FavoriteContactData.push($root.NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.TFavoriteContactData.decode(reader, reader.uint32()));
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a TTelegramCardData message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.TTelegramCardData
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.TTelegramCardData} TTelegramCardData
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        TTelegramCardData.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a TTelegramCardData message.
                         * @function verify
                         * @memberof NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.TTelegramCardData
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        TTelegramCardData.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.UserId != null && message.hasOwnProperty("UserId"))
                                if (!$util.isString(message.UserId))
                                    return "UserId: string expected";
                            if (message.ContactsUploaded != null && message.hasOwnProperty("ContactsUploaded"))
                                if (typeof message.ContactsUploaded !== "boolean")
                                    return "ContactsUploaded: boolean expected";
                            if (message.FavoriteContactData != null && message.hasOwnProperty("FavoriteContactData")) {
                                if (!Array.isArray(message.FavoriteContactData))
                                    return "FavoriteContactData: array expected";
                                for (var i = 0; i < message.FavoriteContactData.length; ++i) {
                                    var error = $root.NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.TFavoriteContactData.verify(message.FavoriteContactData[i]);
                                    if (error)
                                        return "FavoriteContactData." + error;
                                }
                            }
                            return null;
                        };

                        /**
                         * Creates a TTelegramCardData message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.TTelegramCardData
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.TTelegramCardData} TTelegramCardData
                         */
                        TTelegramCardData.fromObject = function fromObject(object) {
                            if (object instanceof $root.NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.TTelegramCardData)
                                return object;
                            var message = new $root.NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.TTelegramCardData();
                            if (object.UserId != null)
                                message.UserId = String(object.UserId);
                            if (object.ContactsUploaded != null)
                                message.ContactsUploaded = Boolean(object.ContactsUploaded);
                            if (object.FavoriteContactData) {
                                if (!Array.isArray(object.FavoriteContactData))
                                    throw TypeError(".NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.TTelegramCardData.FavoriteContactData: array expected");
                                message.FavoriteContactData = [];
                                for (var i = 0; i < object.FavoriteContactData.length; ++i) {
                                    if (typeof object.FavoriteContactData[i] !== "object")
                                        throw TypeError(".NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.TTelegramCardData.FavoriteContactData: object expected");
                                    message.FavoriteContactData[i] = $root.NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.TFavoriteContactData.fromObject(object.FavoriteContactData[i]);
                                }
                            }
                            return message;
                        };

                        /**
                         * Creates a plain object from a TTelegramCardData message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.TTelegramCardData
                         * @static
                         * @param {NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.TTelegramCardData} message TTelegramCardData
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        TTelegramCardData.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.FavoriteContactData = [];
                            if (options.defaults) {
                                object.UserId = "";
                                object.ContactsUploaded = false;
                            }
                            if (message.UserId != null && message.hasOwnProperty("UserId"))
                                object.UserId = message.UserId;
                            if (message.ContactsUploaded != null && message.hasOwnProperty("ContactsUploaded"))
                                object.ContactsUploaded = message.ContactsUploaded;
                            if (message.FavoriteContactData && message.FavoriteContactData.length) {
                                object.FavoriteContactData = [];
                                for (var j = 0; j < message.FavoriteContactData.length; ++j)
                                    object.FavoriteContactData[j] = $root.NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.TFavoriteContactData.toObject(message.FavoriteContactData[j], options);
                            }
                            return object;
                        };

                        /**
                         * Converts this TTelegramCardData to JSON.
                         * @function toJSON
                         * @memberof NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.TTelegramCardData
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        TTelegramCardData.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return TTelegramCardData;
                    })();

                    TLoggedInCardData.TFavoriteContactData = (function() {

                        /**
                         * Properties of a TFavoriteContactData.
                         * @memberof NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData
                         * @interface ITFavoriteContactData
                         * @property {string|null} [DisplayName] TFavoriteContactData DisplayName
                         * @property {string|null} [UserId] TFavoriteContactData UserId
                         * @property {string|null} [LookupKey] TFavoriteContactData LookupKey
                         */

                        /**
                         * Constructs a new TFavoriteContactData.
                         * @memberof NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData
                         * @classdesc Represents a TFavoriteContactData.
                         * @implements ITFavoriteContactData
                         * @constructor
                         * @param {NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.ITFavoriteContactData=} [properties] Properties to set
                         */
                        function TFavoriteContactData(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * TFavoriteContactData DisplayName.
                         * @member {string} DisplayName
                         * @memberof NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.TFavoriteContactData
                         * @instance
                         */
                        TFavoriteContactData.prototype.DisplayName = "";

                        /**
                         * TFavoriteContactData UserId.
                         * @member {string} UserId
                         * @memberof NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.TFavoriteContactData
                         * @instance
                         */
                        TFavoriteContactData.prototype.UserId = "";

                        /**
                         * TFavoriteContactData LookupKey.
                         * @member {string} LookupKey
                         * @memberof NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.TFavoriteContactData
                         * @instance
                         */
                        TFavoriteContactData.prototype.LookupKey = "";

                        /**
                         * Creates a new TFavoriteContactData instance using the specified properties.
                         * @function create
                         * @memberof NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.TFavoriteContactData
                         * @static
                         * @param {NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.ITFavoriteContactData=} [properties] Properties to set
                         * @returns {NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.TFavoriteContactData} TFavoriteContactData instance
                         */
                        TFavoriteContactData.create = function create(properties) {
                            return new TFavoriteContactData(properties);
                        };

                        /**
                         * Encodes the specified TFavoriteContactData message. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.TFavoriteContactData.verify|verify} messages.
                         * @function encode
                         * @memberof NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.TFavoriteContactData
                         * @static
                         * @param {NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.ITFavoriteContactData} message TFavoriteContactData message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        TFavoriteContactData.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.DisplayName != null && Object.hasOwnProperty.call(message, "DisplayName"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.DisplayName);
                            if (message.UserId != null && Object.hasOwnProperty.call(message, "UserId"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.UserId);
                            if (message.LookupKey != null && Object.hasOwnProperty.call(message, "LookupKey"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.LookupKey);
                            return writer;
                        };

                        /**
                         * Encodes the specified TFavoriteContactData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.TFavoriteContactData.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.TFavoriteContactData
                         * @static
                         * @param {NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.ITFavoriteContactData} message TFavoriteContactData message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        TFavoriteContactData.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a TFavoriteContactData message from the specified reader or buffer.
                         * @function decode
                         * @memberof NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.TFavoriteContactData
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.TFavoriteContactData} TFavoriteContactData
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        TFavoriteContactData.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.TFavoriteContactData();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.DisplayName = reader.string();
                                    break;
                                case 2:
                                    message.UserId = reader.string();
                                    break;
                                case 3:
                                    message.LookupKey = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a TFavoriteContactData message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.TFavoriteContactData
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.TFavoriteContactData} TFavoriteContactData
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        TFavoriteContactData.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a TFavoriteContactData message.
                         * @function verify
                         * @memberof NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.TFavoriteContactData
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        TFavoriteContactData.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.DisplayName != null && message.hasOwnProperty("DisplayName"))
                                if (!$util.isString(message.DisplayName))
                                    return "DisplayName: string expected";
                            if (message.UserId != null && message.hasOwnProperty("UserId"))
                                if (!$util.isString(message.UserId))
                                    return "UserId: string expected";
                            if (message.LookupKey != null && message.hasOwnProperty("LookupKey"))
                                if (!$util.isString(message.LookupKey))
                                    return "LookupKey: string expected";
                            return null;
                        };

                        /**
                         * Creates a TFavoriteContactData message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.TFavoriteContactData
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.TFavoriteContactData} TFavoriteContactData
                         */
                        TFavoriteContactData.fromObject = function fromObject(object) {
                            if (object instanceof $root.NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.TFavoriteContactData)
                                return object;
                            var message = new $root.NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.TFavoriteContactData();
                            if (object.DisplayName != null)
                                message.DisplayName = String(object.DisplayName);
                            if (object.UserId != null)
                                message.UserId = String(object.UserId);
                            if (object.LookupKey != null)
                                message.LookupKey = String(object.LookupKey);
                            return message;
                        };

                        /**
                         * Creates a plain object from a TFavoriteContactData message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.TFavoriteContactData
                         * @static
                         * @param {NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.TFavoriteContactData} message TFavoriteContactData
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        TFavoriteContactData.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.DisplayName = "";
                                object.UserId = "";
                                object.LookupKey = "";
                            }
                            if (message.DisplayName != null && message.hasOwnProperty("DisplayName"))
                                object.DisplayName = message.DisplayName;
                            if (message.UserId != null && message.hasOwnProperty("UserId"))
                                object.UserId = message.UserId;
                            if (message.LookupKey != null && message.hasOwnProperty("LookupKey"))
                                object.LookupKey = message.LookupKey;
                            return object;
                        };

                        /**
                         * Converts this TFavoriteContactData to JSON.
                         * @function toJSON
                         * @memberof NAlice.NData.TCentaurWidgetCardData.TVideoCallCardData.TLoggedInCardData.TFavoriteContactData
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        TFavoriteContactData.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return TFavoriteContactData;
                    })();

                    return TLoggedInCardData;
                })();

                return TVideoCallCardData;
            })();

            TCentaurWidgetCardData.TExternalSkillCardData = (function() {

                /**
                 * Properties of a TExternalSkillCardData.
                 * @memberof NAlice.NData.TCentaurWidgetCardData
                 * @interface ITExternalSkillCardData
                 * @property {NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.ITWidgetGalleryData|null} [widgetGalleryData] TExternalSkillCardData widgetGalleryData
                 * @property {NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.ITMainScreenData|null} [mainScreenData] TExternalSkillCardData mainScreenData
                 * @property {NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.ITSkillInfo|null} [skillInfo] TExternalSkillCardData skillInfo
                 */

                /**
                 * Constructs a new TExternalSkillCardData.
                 * @memberof NAlice.NData.TCentaurWidgetCardData
                 * @classdesc Represents a TExternalSkillCardData.
                 * @implements ITExternalSkillCardData
                 * @constructor
                 * @param {NAlice.NData.TCentaurWidgetCardData.ITExternalSkillCardData=} [properties] Properties to set
                 */
                function TExternalSkillCardData(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }

                /**
                 * TExternalSkillCardData widgetGalleryData.
                 * @member {NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.ITWidgetGalleryData|null|undefined} widgetGalleryData
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData
                 * @instance
                 */
                TExternalSkillCardData.prototype.widgetGalleryData = null;

                /**
                 * TExternalSkillCardData mainScreenData.
                 * @member {NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.ITMainScreenData|null|undefined} mainScreenData
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData
                 * @instance
                 */
                TExternalSkillCardData.prototype.mainScreenData = null;

                /**
                 * TExternalSkillCardData skillInfo.
                 * @member {NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.ITSkillInfo|null|undefined} skillInfo
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData
                 * @instance
                 */
                TExternalSkillCardData.prototype.skillInfo = null;

                // OneOf field names bound to virtual getters and setters
                var $oneOfFields;

                /**
                 * TExternalSkillCardData SkillCardData.
                 * @member {"widgetGalleryData"|"mainScreenData"|undefined} SkillCardData
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData
                 * @instance
                 */
                Object.defineProperty(TExternalSkillCardData.prototype, "SkillCardData", {
                    get: $util.oneOfGetter($oneOfFields = ["widgetGalleryData", "mainScreenData"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                /**
                 * Creates a new TExternalSkillCardData instance using the specified properties.
                 * @function create
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData
                 * @static
                 * @param {NAlice.NData.TCentaurWidgetCardData.ITExternalSkillCardData=} [properties] Properties to set
                 * @returns {NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData} TExternalSkillCardData instance
                 */
                TExternalSkillCardData.create = function create(properties) {
                    return new TExternalSkillCardData(properties);
                };

                /**
                 * Encodes the specified TExternalSkillCardData message. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.verify|verify} messages.
                 * @function encode
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData
                 * @static
                 * @param {NAlice.NData.TCentaurWidgetCardData.ITExternalSkillCardData} message TExternalSkillCardData message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                TExternalSkillCardData.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.widgetGalleryData != null && Object.hasOwnProperty.call(message, "widgetGalleryData"))
                        $root.NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TWidgetGalleryData.encode(message.widgetGalleryData, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                    if (message.mainScreenData != null && Object.hasOwnProperty.call(message, "mainScreenData"))
                        $root.NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData.encode(message.mainScreenData, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                    if (message.skillInfo != null && Object.hasOwnProperty.call(message, "skillInfo"))
                        $root.NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TSkillInfo.encode(message.skillInfo, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                    return writer;
                };

                /**
                 * Encodes the specified TExternalSkillCardData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.verify|verify} messages.
                 * @function encodeDelimited
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData
                 * @static
                 * @param {NAlice.NData.TCentaurWidgetCardData.ITExternalSkillCardData} message TExternalSkillCardData message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                TExternalSkillCardData.encodeDelimited = function encodeDelimited(message, writer) {
                    return this.encode(message, writer).ldelim();
                };

                /**
                 * Decodes a TExternalSkillCardData message from the specified reader or buffer.
                 * @function decode
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData} TExternalSkillCardData
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                TExternalSkillCardData.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.widgetGalleryData = $root.NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TWidgetGalleryData.decode(reader, reader.uint32());
                            break;
                        case 2:
                            message.mainScreenData = $root.NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData.decode(reader, reader.uint32());
                            break;
                        case 3:
                            message.skillInfo = $root.NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TSkillInfo.decode(reader, reader.uint32());
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };

                /**
                 * Decodes a TExternalSkillCardData message from the specified reader or buffer, length delimited.
                 * @function decodeDelimited
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @returns {NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData} TExternalSkillCardData
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                TExternalSkillCardData.decodeDelimited = function decodeDelimited(reader) {
                    if (!(reader instanceof $Reader))
                        reader = new $Reader(reader);
                    return this.decode(reader, reader.uint32());
                };

                /**
                 * Verifies a TExternalSkillCardData message.
                 * @function verify
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                TExternalSkillCardData.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    var properties = {};
                    if (message.widgetGalleryData != null && message.hasOwnProperty("widgetGalleryData")) {
                        properties.SkillCardData = 1;
                        {
                            var error = $root.NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TWidgetGalleryData.verify(message.widgetGalleryData);
                            if (error)
                                return "widgetGalleryData." + error;
                        }
                    }
                    if (message.mainScreenData != null && message.hasOwnProperty("mainScreenData")) {
                        if (properties.SkillCardData === 1)
                            return "SkillCardData: multiple values";
                        properties.SkillCardData = 1;
                        {
                            var error = $root.NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData.verify(message.mainScreenData);
                            if (error)
                                return "mainScreenData." + error;
                        }
                    }
                    if (message.skillInfo != null && message.hasOwnProperty("skillInfo")) {
                        var error = $root.NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TSkillInfo.verify(message.skillInfo);
                        if (error)
                            return "skillInfo." + error;
                    }
                    return null;
                };

                /**
                 * Creates a TExternalSkillCardData message from a plain object. Also converts values to their respective internal types.
                 * @function fromObject
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData
                 * @static
                 * @param {Object.<string,*>} object Plain object
                 * @returns {NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData} TExternalSkillCardData
                 */
                TExternalSkillCardData.fromObject = function fromObject(object) {
                    if (object instanceof $root.NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData)
                        return object;
                    var message = new $root.NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData();
                    if (object.widgetGalleryData != null) {
                        if (typeof object.widgetGalleryData !== "object")
                            throw TypeError(".NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.widgetGalleryData: object expected");
                        message.widgetGalleryData = $root.NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TWidgetGalleryData.fromObject(object.widgetGalleryData);
                    }
                    if (object.mainScreenData != null) {
                        if (typeof object.mainScreenData !== "object")
                            throw TypeError(".NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.mainScreenData: object expected");
                        message.mainScreenData = $root.NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData.fromObject(object.mainScreenData);
                    }
                    if (object.skillInfo != null) {
                        if (typeof object.skillInfo !== "object")
                            throw TypeError(".NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.skillInfo: object expected");
                        message.skillInfo = $root.NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TSkillInfo.fromObject(object.skillInfo);
                    }
                    return message;
                };

                /**
                 * Creates a plain object from a TExternalSkillCardData message. Also converts values to other types if specified.
                 * @function toObject
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData
                 * @static
                 * @param {NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData} message TExternalSkillCardData
                 * @param {$protobuf.IConversionOptions} [options] Conversion options
                 * @returns {Object.<string,*>} Plain object
                 */
                TExternalSkillCardData.toObject = function toObject(message, options) {
                    if (!options)
                        options = {};
                    var object = {};
                    if (options.defaults)
                        object.skillInfo = null;
                    if (message.widgetGalleryData != null && message.hasOwnProperty("widgetGalleryData")) {
                        object.widgetGalleryData = $root.NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TWidgetGalleryData.toObject(message.widgetGalleryData, options);
                        if (options.oneofs)
                            object.SkillCardData = "widgetGalleryData";
                    }
                    if (message.mainScreenData != null && message.hasOwnProperty("mainScreenData")) {
                        object.mainScreenData = $root.NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData.toObject(message.mainScreenData, options);
                        if (options.oneofs)
                            object.SkillCardData = "mainScreenData";
                    }
                    if (message.skillInfo != null && message.hasOwnProperty("skillInfo"))
                        object.skillInfo = $root.NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TSkillInfo.toObject(message.skillInfo, options);
                    return object;
                };

                /**
                 * Converts this TExternalSkillCardData to JSON.
                 * @function toJSON
                 * @memberof NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData
                 * @instance
                 * @returns {Object.<string,*>} JSON object
                 */
                TExternalSkillCardData.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };

                TExternalSkillCardData.TSkillInfo = (function() {

                    /**
                     * Properties of a TSkillInfo.
                     * @memberof NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData
                     * @interface ITSkillInfo
                     * @property {string|null} [Name] TSkillInfo Name
                     * @property {string|null} [Logo] TSkillInfo Logo
                     * @property {string|null} [SkillId] TSkillInfo SkillId
                     */

                    /**
                     * Constructs a new TSkillInfo.
                     * @memberof NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData
                     * @classdesc Represents a TSkillInfo.
                     * @implements ITSkillInfo
                     * @constructor
                     * @param {NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.ITSkillInfo=} [properties] Properties to set
                     */
                    function TSkillInfo(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }

                    /**
                     * TSkillInfo Name.
                     * @member {string} Name
                     * @memberof NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TSkillInfo
                     * @instance
                     */
                    TSkillInfo.prototype.Name = "";

                    /**
                     * TSkillInfo Logo.
                     * @member {string} Logo
                     * @memberof NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TSkillInfo
                     * @instance
                     */
                    TSkillInfo.prototype.Logo = "";

                    /**
                     * TSkillInfo SkillId.
                     * @member {string} SkillId
                     * @memberof NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TSkillInfo
                     * @instance
                     */
                    TSkillInfo.prototype.SkillId = "";

                    /**
                     * Creates a new TSkillInfo instance using the specified properties.
                     * @function create
                     * @memberof NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TSkillInfo
                     * @static
                     * @param {NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.ITSkillInfo=} [properties] Properties to set
                     * @returns {NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TSkillInfo} TSkillInfo instance
                     */
                    TSkillInfo.create = function create(properties) {
                        return new TSkillInfo(properties);
                    };

                    /**
                     * Encodes the specified TSkillInfo message. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TSkillInfo.verify|verify} messages.
                     * @function encode
                     * @memberof NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TSkillInfo
                     * @static
                     * @param {NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.ITSkillInfo} message TSkillInfo message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    TSkillInfo.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.Name != null && Object.hasOwnProperty.call(message, "Name"))
                            writer.uint32(/* id 1, wireType 2 =*/10).string(message.Name);
                        if (message.Logo != null && Object.hasOwnProperty.call(message, "Logo"))
                            writer.uint32(/* id 2, wireType 2 =*/18).string(message.Logo);
                        if (message.SkillId != null && Object.hasOwnProperty.call(message, "SkillId"))
                            writer.uint32(/* id 3, wireType 2 =*/26).string(message.SkillId);
                        return writer;
                    };

                    /**
                     * Encodes the specified TSkillInfo message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TSkillInfo.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TSkillInfo
                     * @static
                     * @param {NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.ITSkillInfo} message TSkillInfo message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    TSkillInfo.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };

                    /**
                     * Decodes a TSkillInfo message from the specified reader or buffer.
                     * @function decode
                     * @memberof NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TSkillInfo
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TSkillInfo} TSkillInfo
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    TSkillInfo.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TSkillInfo();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 1:
                                message.Name = reader.string();
                                break;
                            case 2:
                                message.Logo = reader.string();
                                break;
                            case 3:
                                message.SkillId = reader.string();
                                break;
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };

                    /**
                     * Decodes a TSkillInfo message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TSkillInfo
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TSkillInfo} TSkillInfo
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    TSkillInfo.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };

                    /**
                     * Verifies a TSkillInfo message.
                     * @function verify
                     * @memberof NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TSkillInfo
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    TSkillInfo.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.Name != null && message.hasOwnProperty("Name"))
                            if (!$util.isString(message.Name))
                                return "Name: string expected";
                        if (message.Logo != null && message.hasOwnProperty("Logo"))
                            if (!$util.isString(message.Logo))
                                return "Logo: string expected";
                        if (message.SkillId != null && message.hasOwnProperty("SkillId"))
                            if (!$util.isString(message.SkillId))
                                return "SkillId: string expected";
                        return null;
                    };

                    /**
                     * Creates a TSkillInfo message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TSkillInfo
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TSkillInfo} TSkillInfo
                     */
                    TSkillInfo.fromObject = function fromObject(object) {
                        if (object instanceof $root.NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TSkillInfo)
                            return object;
                        var message = new $root.NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TSkillInfo();
                        if (object.Name != null)
                            message.Name = String(object.Name);
                        if (object.Logo != null)
                            message.Logo = String(object.Logo);
                        if (object.SkillId != null)
                            message.SkillId = String(object.SkillId);
                        return message;
                    };

                    /**
                     * Creates a plain object from a TSkillInfo message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TSkillInfo
                     * @static
                     * @param {NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TSkillInfo} message TSkillInfo
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    TSkillInfo.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.defaults) {
                            object.Name = "";
                            object.Logo = "";
                            object.SkillId = "";
                        }
                        if (message.Name != null && message.hasOwnProperty("Name"))
                            object.Name = message.Name;
                        if (message.Logo != null && message.hasOwnProperty("Logo"))
                            object.Logo = message.Logo;
                        if (message.SkillId != null && message.hasOwnProperty("SkillId"))
                            object.SkillId = message.SkillId;
                        return object;
                    };

                    /**
                     * Converts this TSkillInfo to JSON.
                     * @function toJSON
                     * @memberof NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TSkillInfo
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    TSkillInfo.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };

                    return TSkillInfo;
                })();

                TExternalSkillCardData.TWidgetGalleryData = (function() {

                    /**
                     * Properties of a TWidgetGalleryData.
                     * @memberof NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData
                     * @interface ITWidgetGalleryData
                     */

                    /**
                     * Constructs a new TWidgetGalleryData.
                     * @memberof NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData
                     * @classdesc Represents a TWidgetGalleryData.
                     * @implements ITWidgetGalleryData
                     * @constructor
                     * @param {NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.ITWidgetGalleryData=} [properties] Properties to set
                     */
                    function TWidgetGalleryData(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }

                    /**
                     * Creates a new TWidgetGalleryData instance using the specified properties.
                     * @function create
                     * @memberof NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TWidgetGalleryData
                     * @static
                     * @param {NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.ITWidgetGalleryData=} [properties] Properties to set
                     * @returns {NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TWidgetGalleryData} TWidgetGalleryData instance
                     */
                    TWidgetGalleryData.create = function create(properties) {
                        return new TWidgetGalleryData(properties);
                    };

                    /**
                     * Encodes the specified TWidgetGalleryData message. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TWidgetGalleryData.verify|verify} messages.
                     * @function encode
                     * @memberof NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TWidgetGalleryData
                     * @static
                     * @param {NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.ITWidgetGalleryData} message TWidgetGalleryData message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    TWidgetGalleryData.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        return writer;
                    };

                    /**
                     * Encodes the specified TWidgetGalleryData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TWidgetGalleryData.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TWidgetGalleryData
                     * @static
                     * @param {NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.ITWidgetGalleryData} message TWidgetGalleryData message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    TWidgetGalleryData.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };

                    /**
                     * Decodes a TWidgetGalleryData message from the specified reader or buffer.
                     * @function decode
                     * @memberof NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TWidgetGalleryData
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TWidgetGalleryData} TWidgetGalleryData
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    TWidgetGalleryData.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TWidgetGalleryData();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };

                    /**
                     * Decodes a TWidgetGalleryData message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TWidgetGalleryData
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TWidgetGalleryData} TWidgetGalleryData
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    TWidgetGalleryData.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };

                    /**
                     * Verifies a TWidgetGalleryData message.
                     * @function verify
                     * @memberof NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TWidgetGalleryData
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    TWidgetGalleryData.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        return null;
                    };

                    /**
                     * Creates a TWidgetGalleryData message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TWidgetGalleryData
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TWidgetGalleryData} TWidgetGalleryData
                     */
                    TWidgetGalleryData.fromObject = function fromObject(object) {
                        if (object instanceof $root.NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TWidgetGalleryData)
                            return object;
                        return new $root.NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TWidgetGalleryData();
                    };

                    /**
                     * Creates a plain object from a TWidgetGalleryData message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TWidgetGalleryData
                     * @static
                     * @param {NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TWidgetGalleryData} message TWidgetGalleryData
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    TWidgetGalleryData.toObject = function toObject() {
                        return {};
                    };

                    /**
                     * Converts this TWidgetGalleryData to JSON.
                     * @function toJSON
                     * @memberof NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TWidgetGalleryData
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    TWidgetGalleryData.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };

                    return TWidgetGalleryData;
                })();

                TExternalSkillCardData.TMainScreenData = (function() {

                    /**
                     * Properties of a TMainScreenData.
                     * @memberof NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData
                     * @interface ITMainScreenData
                     * @property {string|null} [Title] TMainScreenData Title
                     * @property {string|null} [Text] TMainScreenData Text
                     * @property {string|null} [ImageUrl] TMainScreenData ImageUrl
                     * @property {Array.<NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData.ITButton>|null} [buttons] TMainScreenData buttons
                     */

                    /**
                     * Constructs a new TMainScreenData.
                     * @memberof NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData
                     * @classdesc Represents a TMainScreenData.
                     * @implements ITMainScreenData
                     * @constructor
                     * @param {NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.ITMainScreenData=} [properties] Properties to set
                     */
                    function TMainScreenData(properties) {
                        this.buttons = [];
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }

                    /**
                     * TMainScreenData Title.
                     * @member {string} Title
                     * @memberof NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData
                     * @instance
                     */
                    TMainScreenData.prototype.Title = "";

                    /**
                     * TMainScreenData Text.
                     * @member {string} Text
                     * @memberof NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData
                     * @instance
                     */
                    TMainScreenData.prototype.Text = "";

                    /**
                     * TMainScreenData ImageUrl.
                     * @member {string} ImageUrl
                     * @memberof NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData
                     * @instance
                     */
                    TMainScreenData.prototype.ImageUrl = "";

                    /**
                     * TMainScreenData buttons.
                     * @member {Array.<NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData.ITButton>} buttons
                     * @memberof NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData
                     * @instance
                     */
                    TMainScreenData.prototype.buttons = $util.emptyArray;

                    /**
                     * Creates a new TMainScreenData instance using the specified properties.
                     * @function create
                     * @memberof NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData
                     * @static
                     * @param {NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.ITMainScreenData=} [properties] Properties to set
                     * @returns {NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData} TMainScreenData instance
                     */
                    TMainScreenData.create = function create(properties) {
                        return new TMainScreenData(properties);
                    };

                    /**
                     * Encodes the specified TMainScreenData message. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData.verify|verify} messages.
                     * @function encode
                     * @memberof NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData
                     * @static
                     * @param {NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.ITMainScreenData} message TMainScreenData message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    TMainScreenData.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.Title != null && Object.hasOwnProperty.call(message, "Title"))
                            writer.uint32(/* id 1, wireType 2 =*/10).string(message.Title);
                        if (message.Text != null && Object.hasOwnProperty.call(message, "Text"))
                            writer.uint32(/* id 2, wireType 2 =*/18).string(message.Text);
                        if (message.ImageUrl != null && Object.hasOwnProperty.call(message, "ImageUrl"))
                            writer.uint32(/* id 3, wireType 2 =*/26).string(message.ImageUrl);
                        if (message.buttons != null && message.buttons.length)
                            for (var i = 0; i < message.buttons.length; ++i)
                                $root.NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData.TButton.encode(message.buttons[i], writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
                        return writer;
                    };

                    /**
                     * Encodes the specified TMainScreenData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData
                     * @static
                     * @param {NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.ITMainScreenData} message TMainScreenData message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    TMainScreenData.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };

                    /**
                     * Decodes a TMainScreenData message from the specified reader or buffer.
                     * @function decode
                     * @memberof NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData} TMainScreenData
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    TMainScreenData.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 1:
                                message.Title = reader.string();
                                break;
                            case 2:
                                message.Text = reader.string();
                                break;
                            case 3:
                                message.ImageUrl = reader.string();
                                break;
                            case 4:
                                if (!(message.buttons && message.buttons.length))
                                    message.buttons = [];
                                message.buttons.push($root.NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData.TButton.decode(reader, reader.uint32()));
                                break;
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };

                    /**
                     * Decodes a TMainScreenData message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData} TMainScreenData
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    TMainScreenData.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };

                    /**
                     * Verifies a TMainScreenData message.
                     * @function verify
                     * @memberof NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    TMainScreenData.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.Title != null && message.hasOwnProperty("Title"))
                            if (!$util.isString(message.Title))
                                return "Title: string expected";
                        if (message.Text != null && message.hasOwnProperty("Text"))
                            if (!$util.isString(message.Text))
                                return "Text: string expected";
                        if (message.ImageUrl != null && message.hasOwnProperty("ImageUrl"))
                            if (!$util.isString(message.ImageUrl))
                                return "ImageUrl: string expected";
                        if (message.buttons != null && message.hasOwnProperty("buttons")) {
                            if (!Array.isArray(message.buttons))
                                return "buttons: array expected";
                            for (var i = 0; i < message.buttons.length; ++i) {
                                var error = $root.NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData.TButton.verify(message.buttons[i]);
                                if (error)
                                    return "buttons." + error;
                            }
                        }
                        return null;
                    };

                    /**
                     * Creates a TMainScreenData message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData} TMainScreenData
                     */
                    TMainScreenData.fromObject = function fromObject(object) {
                        if (object instanceof $root.NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData)
                            return object;
                        var message = new $root.NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData();
                        if (object.Title != null)
                            message.Title = String(object.Title);
                        if (object.Text != null)
                            message.Text = String(object.Text);
                        if (object.ImageUrl != null)
                            message.ImageUrl = String(object.ImageUrl);
                        if (object.buttons) {
                            if (!Array.isArray(object.buttons))
                                throw TypeError(".NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData.buttons: array expected");
                            message.buttons = [];
                            for (var i = 0; i < object.buttons.length; ++i) {
                                if (typeof object.buttons[i] !== "object")
                                    throw TypeError(".NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData.buttons: object expected");
                                message.buttons[i] = $root.NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData.TButton.fromObject(object.buttons[i]);
                            }
                        }
                        return message;
                    };

                    /**
                     * Creates a plain object from a TMainScreenData message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData
                     * @static
                     * @param {NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData} message TMainScreenData
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    TMainScreenData.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.arrays || options.defaults)
                            object.buttons = [];
                        if (options.defaults) {
                            object.Title = "";
                            object.Text = "";
                            object.ImageUrl = "";
                        }
                        if (message.Title != null && message.hasOwnProperty("Title"))
                            object.Title = message.Title;
                        if (message.Text != null && message.hasOwnProperty("Text"))
                            object.Text = message.Text;
                        if (message.ImageUrl != null && message.hasOwnProperty("ImageUrl"))
                            object.ImageUrl = message.ImageUrl;
                        if (message.buttons && message.buttons.length) {
                            object.buttons = [];
                            for (var j = 0; j < message.buttons.length; ++j)
                                object.buttons[j] = $root.NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData.TButton.toObject(message.buttons[j], options);
                        }
                        return object;
                    };

                    /**
                     * Converts this TMainScreenData to JSON.
                     * @function toJSON
                     * @memberof NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    TMainScreenData.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };

                    TMainScreenData.TButton = (function() {

                        /**
                         * Properties of a TButton.
                         * @memberof NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData
                         * @interface ITButton
                         * @property {string|null} [Text] TButton Text
                         * @property {string|null} [Url] TButton Url
                         * @property {string|null} [Payload] TButton Payload
                         */

                        /**
                         * Constructs a new TButton.
                         * @memberof NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData
                         * @classdesc Represents a TButton.
                         * @implements ITButton
                         * @constructor
                         * @param {NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData.ITButton=} [properties] Properties to set
                         */
                        function TButton(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * TButton Text.
                         * @member {string} Text
                         * @memberof NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData.TButton
                         * @instance
                         */
                        TButton.prototype.Text = "";

                        /**
                         * TButton Url.
                         * @member {string} Url
                         * @memberof NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData.TButton
                         * @instance
                         */
                        TButton.prototype.Url = "";

                        /**
                         * TButton Payload.
                         * @member {string} Payload
                         * @memberof NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData.TButton
                         * @instance
                         */
                        TButton.prototype.Payload = "";

                        /**
                         * Creates a new TButton instance using the specified properties.
                         * @function create
                         * @memberof NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData.TButton
                         * @static
                         * @param {NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData.ITButton=} [properties] Properties to set
                         * @returns {NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData.TButton} TButton instance
                         */
                        TButton.create = function create(properties) {
                            return new TButton(properties);
                        };

                        /**
                         * Encodes the specified TButton message. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData.TButton.verify|verify} messages.
                         * @function encode
                         * @memberof NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData.TButton
                         * @static
                         * @param {NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData.ITButton} message TButton message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        TButton.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.Text != null && Object.hasOwnProperty.call(message, "Text"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.Text);
                            if (message.Url != null && Object.hasOwnProperty.call(message, "Url"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.Url);
                            if (message.Payload != null && Object.hasOwnProperty.call(message, "Payload"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.Payload);
                            return writer;
                        };

                        /**
                         * Encodes the specified TButton message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData.TButton.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData.TButton
                         * @static
                         * @param {NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData.ITButton} message TButton message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        TButton.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a TButton message from the specified reader or buffer.
                         * @function decode
                         * @memberof NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData.TButton
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData.TButton} TButton
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        TButton.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData.TButton();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.Text = reader.string();
                                    break;
                                case 2:
                                    message.Url = reader.string();
                                    break;
                                case 3:
                                    message.Payload = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a TButton message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData.TButton
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData.TButton} TButton
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        TButton.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a TButton message.
                         * @function verify
                         * @memberof NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData.TButton
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        TButton.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.Text != null && message.hasOwnProperty("Text"))
                                if (!$util.isString(message.Text))
                                    return "Text: string expected";
                            if (message.Url != null && message.hasOwnProperty("Url"))
                                if (!$util.isString(message.Url))
                                    return "Url: string expected";
                            if (message.Payload != null && message.hasOwnProperty("Payload"))
                                if (!$util.isString(message.Payload))
                                    return "Payload: string expected";
                            return null;
                        };

                        /**
                         * Creates a TButton message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData.TButton
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData.TButton} TButton
                         */
                        TButton.fromObject = function fromObject(object) {
                            if (object instanceof $root.NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData.TButton)
                                return object;
                            var message = new $root.NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData.TButton();
                            if (object.Text != null)
                                message.Text = String(object.Text);
                            if (object.Url != null)
                                message.Url = String(object.Url);
                            if (object.Payload != null)
                                message.Payload = String(object.Payload);
                            return message;
                        };

                        /**
                         * Creates a plain object from a TButton message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData.TButton
                         * @static
                         * @param {NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData.TButton} message TButton
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        TButton.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.Text = "";
                                object.Url = "";
                                object.Payload = "";
                            }
                            if (message.Text != null && message.hasOwnProperty("Text"))
                                object.Text = message.Text;
                            if (message.Url != null && message.hasOwnProperty("Url"))
                                object.Url = message.Url;
                            if (message.Payload != null && message.hasOwnProperty("Payload"))
                                object.Payload = message.Payload;
                            return object;
                        };

                        /**
                         * Converts this TButton to JSON.
                         * @function toJSON
                         * @memberof NAlice.NData.TCentaurWidgetCardData.TExternalSkillCardData.TMainScreenData.TButton
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        TButton.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return TButton;
                    })();

                    return TMainScreenData;
                })();

                return TExternalSkillCardData;
            })();

            return TCentaurWidgetCardData;
        })();

        NData.TCentaurWidgetCardItem = (function() {

            /**
             * Properties of a TCentaurWidgetCardItem.
             * @memberof NAlice.NData
             * @interface ITCentaurWidgetCardItem
             * @property {string|null} [Id] TCentaurWidgetCardItem Id
             * @property {NAlice.NData.ITCentaurWidgetCardData|null} [CardData] TCentaurWidgetCardItem CardData
             * @property {NAlice.ITDiv2Card|null} [Div2Card] TCentaurWidgetCardItem Div2Card
             * @property {NAlice.ITDiv2Card|null} [Div2CardCompact] TCentaurWidgetCardItem Div2CardCompact
             * @property {string|null} [OpenWidgetGalleryAction] TCentaurWidgetCardItem OpenWidgetGalleryAction
             */

            /**
             * Constructs a new TCentaurWidgetCardItem.
             * @memberof NAlice.NData
             * @classdesc Represents a TCentaurWidgetCardItem.
             * @implements ITCentaurWidgetCardItem
             * @constructor
             * @param {NAlice.NData.ITCentaurWidgetCardItem=} [properties] Properties to set
             */
            function TCentaurWidgetCardItem(properties) {
                if (properties)
                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                        if (properties[keys[i]] != null)
                            this[keys[i]] = properties[keys[i]];
            }

            /**
             * TCentaurWidgetCardItem Id.
             * @member {string} Id
             * @memberof NAlice.NData.TCentaurWidgetCardItem
             * @instance
             */
            TCentaurWidgetCardItem.prototype.Id = "";

            /**
             * TCentaurWidgetCardItem CardData.
             * @member {NAlice.NData.ITCentaurWidgetCardData|null|undefined} CardData
             * @memberof NAlice.NData.TCentaurWidgetCardItem
             * @instance
             */
            TCentaurWidgetCardItem.prototype.CardData = null;

            /**
             * TCentaurWidgetCardItem Div2Card.
             * @member {NAlice.ITDiv2Card|null|undefined} Div2Card
             * @memberof NAlice.NData.TCentaurWidgetCardItem
             * @instance
             */
            TCentaurWidgetCardItem.prototype.Div2Card = null;

            /**
             * TCentaurWidgetCardItem Div2CardCompact.
             * @member {NAlice.ITDiv2Card|null|undefined} Div2CardCompact
             * @memberof NAlice.NData.TCentaurWidgetCardItem
             * @instance
             */
            TCentaurWidgetCardItem.prototype.Div2CardCompact = null;

            /**
             * TCentaurWidgetCardItem OpenWidgetGalleryAction.
             * @member {string} OpenWidgetGalleryAction
             * @memberof NAlice.NData.TCentaurWidgetCardItem
             * @instance
             */
            TCentaurWidgetCardItem.prototype.OpenWidgetGalleryAction = "";

            /**
             * Creates a new TCentaurWidgetCardItem instance using the specified properties.
             * @function create
             * @memberof NAlice.NData.TCentaurWidgetCardItem
             * @static
             * @param {NAlice.NData.ITCentaurWidgetCardItem=} [properties] Properties to set
             * @returns {NAlice.NData.TCentaurWidgetCardItem} TCentaurWidgetCardItem instance
             */
            TCentaurWidgetCardItem.create = function create(properties) {
                return new TCentaurWidgetCardItem(properties);
            };

            /**
             * Encodes the specified TCentaurWidgetCardItem message. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardItem.verify|verify} messages.
             * @function encode
             * @memberof NAlice.NData.TCentaurWidgetCardItem
             * @static
             * @param {NAlice.NData.ITCentaurWidgetCardItem} message TCentaurWidgetCardItem message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            TCentaurWidgetCardItem.encode = function encode(message, writer) {
                if (!writer)
                    writer = $Writer.create();
                if (message.Id != null && Object.hasOwnProperty.call(message, "Id"))
                    writer.uint32(/* id 1, wireType 2 =*/10).string(message.Id);
                if (message.CardData != null && Object.hasOwnProperty.call(message, "CardData"))
                    $root.NAlice.NData.TCentaurWidgetCardData.encode(message.CardData, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                if (message.Div2Card != null && Object.hasOwnProperty.call(message, "Div2Card"))
                    $root.NAlice.TDiv2Card.encode(message.Div2Card, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                if (message.Div2CardCompact != null && Object.hasOwnProperty.call(message, "Div2CardCompact"))
                    $root.NAlice.TDiv2Card.encode(message.Div2CardCompact, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
                if (message.OpenWidgetGalleryAction != null && Object.hasOwnProperty.call(message, "OpenWidgetGalleryAction"))
                    writer.uint32(/* id 5, wireType 2 =*/42).string(message.OpenWidgetGalleryAction);
                return writer;
            };

            /**
             * Encodes the specified TCentaurWidgetCardItem message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardItem.verify|verify} messages.
             * @function encodeDelimited
             * @memberof NAlice.NData.TCentaurWidgetCardItem
             * @static
             * @param {NAlice.NData.ITCentaurWidgetCardItem} message TCentaurWidgetCardItem message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            TCentaurWidgetCardItem.encodeDelimited = function encodeDelimited(message, writer) {
                return this.encode(message, writer).ldelim();
            };

            /**
             * Decodes a TCentaurWidgetCardItem message from the specified reader or buffer.
             * @function decode
             * @memberof NAlice.NData.TCentaurWidgetCardItem
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @param {number} [length] Message length if known beforehand
             * @returns {NAlice.NData.TCentaurWidgetCardItem} TCentaurWidgetCardItem
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            TCentaurWidgetCardItem.decode = function decode(reader, length) {
                if (!(reader instanceof $Reader))
                    reader = $Reader.create(reader);
                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.NAlice.NData.TCentaurWidgetCardItem();
                while (reader.pos < end) {
                    var tag = reader.uint32();
                    switch (tag >>> 3) {
                    case 1:
                        message.Id = reader.string();
                        break;
                    case 2:
                        message.CardData = $root.NAlice.NData.TCentaurWidgetCardData.decode(reader, reader.uint32());
                        break;
                    case 3:
                        message.Div2Card = $root.NAlice.TDiv2Card.decode(reader, reader.uint32());
                        break;
                    case 4:
                        message.Div2CardCompact = $root.NAlice.TDiv2Card.decode(reader, reader.uint32());
                        break;
                    case 5:
                        message.OpenWidgetGalleryAction = reader.string();
                        break;
                    default:
                        reader.skipType(tag & 7);
                        break;
                    }
                }
                return message;
            };

            /**
             * Decodes a TCentaurWidgetCardItem message from the specified reader or buffer, length delimited.
             * @function decodeDelimited
             * @memberof NAlice.NData.TCentaurWidgetCardItem
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @returns {NAlice.NData.TCentaurWidgetCardItem} TCentaurWidgetCardItem
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            TCentaurWidgetCardItem.decodeDelimited = function decodeDelimited(reader) {
                if (!(reader instanceof $Reader))
                    reader = new $Reader(reader);
                return this.decode(reader, reader.uint32());
            };

            /**
             * Verifies a TCentaurWidgetCardItem message.
             * @function verify
             * @memberof NAlice.NData.TCentaurWidgetCardItem
             * @static
             * @param {Object.<string,*>} message Plain object to verify
             * @returns {string|null} `null` if valid, otherwise the reason why it is not
             */
            TCentaurWidgetCardItem.verify = function verify(message) {
                if (typeof message !== "object" || message === null)
                    return "object expected";
                if (message.Id != null && message.hasOwnProperty("Id"))
                    if (!$util.isString(message.Id))
                        return "Id: string expected";
                if (message.CardData != null && message.hasOwnProperty("CardData")) {
                    var error = $root.NAlice.NData.TCentaurWidgetCardData.verify(message.CardData);
                    if (error)
                        return "CardData." + error;
                }
                if (message.Div2Card != null && message.hasOwnProperty("Div2Card")) {
                    var error = $root.NAlice.TDiv2Card.verify(message.Div2Card);
                    if (error)
                        return "Div2Card." + error;
                }
                if (message.Div2CardCompact != null && message.hasOwnProperty("Div2CardCompact")) {
                    var error = $root.NAlice.TDiv2Card.verify(message.Div2CardCompact);
                    if (error)
                        return "Div2CardCompact." + error;
                }
                if (message.OpenWidgetGalleryAction != null && message.hasOwnProperty("OpenWidgetGalleryAction"))
                    if (!$util.isString(message.OpenWidgetGalleryAction))
                        return "OpenWidgetGalleryAction: string expected";
                return null;
            };

            /**
             * Creates a TCentaurWidgetCardItem message from a plain object. Also converts values to their respective internal types.
             * @function fromObject
             * @memberof NAlice.NData.TCentaurWidgetCardItem
             * @static
             * @param {Object.<string,*>} object Plain object
             * @returns {NAlice.NData.TCentaurWidgetCardItem} TCentaurWidgetCardItem
             */
            TCentaurWidgetCardItem.fromObject = function fromObject(object) {
                if (object instanceof $root.NAlice.NData.TCentaurWidgetCardItem)
                    return object;
                var message = new $root.NAlice.NData.TCentaurWidgetCardItem();
                if (object.Id != null)
                    message.Id = String(object.Id);
                if (object.CardData != null) {
                    if (typeof object.CardData !== "object")
                        throw TypeError(".NAlice.NData.TCentaurWidgetCardItem.CardData: object expected");
                    message.CardData = $root.NAlice.NData.TCentaurWidgetCardData.fromObject(object.CardData);
                }
                if (object.Div2Card != null) {
                    if (typeof object.Div2Card !== "object")
                        throw TypeError(".NAlice.NData.TCentaurWidgetCardItem.Div2Card: object expected");
                    message.Div2Card = $root.NAlice.TDiv2Card.fromObject(object.Div2Card);
                }
                if (object.Div2CardCompact != null) {
                    if (typeof object.Div2CardCompact !== "object")
                        throw TypeError(".NAlice.NData.TCentaurWidgetCardItem.Div2CardCompact: object expected");
                    message.Div2CardCompact = $root.NAlice.TDiv2Card.fromObject(object.Div2CardCompact);
                }
                if (object.OpenWidgetGalleryAction != null)
                    message.OpenWidgetGalleryAction = String(object.OpenWidgetGalleryAction);
                return message;
            };

            /**
             * Creates a plain object from a TCentaurWidgetCardItem message. Also converts values to other types if specified.
             * @function toObject
             * @memberof NAlice.NData.TCentaurWidgetCardItem
             * @static
             * @param {NAlice.NData.TCentaurWidgetCardItem} message TCentaurWidgetCardItem
             * @param {$protobuf.IConversionOptions} [options] Conversion options
             * @returns {Object.<string,*>} Plain object
             */
            TCentaurWidgetCardItem.toObject = function toObject(message, options) {
                if (!options)
                    options = {};
                var object = {};
                if (options.defaults) {
                    object.Id = "";
                    object.CardData = null;
                    object.Div2Card = null;
                    object.Div2CardCompact = null;
                    object.OpenWidgetGalleryAction = "";
                }
                if (message.Id != null && message.hasOwnProperty("Id"))
                    object.Id = message.Id;
                if (message.CardData != null && message.hasOwnProperty("CardData"))
                    object.CardData = $root.NAlice.NData.TCentaurWidgetCardData.toObject(message.CardData, options);
                if (message.Div2Card != null && message.hasOwnProperty("Div2Card"))
                    object.Div2Card = $root.NAlice.TDiv2Card.toObject(message.Div2Card, options);
                if (message.Div2CardCompact != null && message.hasOwnProperty("Div2CardCompact"))
                    object.Div2CardCompact = $root.NAlice.TDiv2Card.toObject(message.Div2CardCompact, options);
                if (message.OpenWidgetGalleryAction != null && message.hasOwnProperty("OpenWidgetGalleryAction"))
                    object.OpenWidgetGalleryAction = message.OpenWidgetGalleryAction;
                return object;
            };

            /**
             * Converts this TCentaurWidgetCardItem to JSON.
             * @function toJSON
             * @memberof NAlice.NData.TCentaurWidgetCardItem
             * @instance
             * @returns {Object.<string,*>} JSON object
             */
            TCentaurWidgetCardItem.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            return TCentaurWidgetCardItem;
        })();

        NData.TCentaurWidgetCardItemData = (function() {

            /**
             * Properties of a TCentaurWidgetCardItemData.
             * @memberof NAlice.NData
             * @interface ITCentaurWidgetCardItemData
             * @property {string|null} [WidgetType] TCentaurWidgetCardItemData WidgetType
             * @property {Array.<NAlice.NData.ITCentaurWidgetCardItem>|null} [CentaurWidgetCardItems] TCentaurWidgetCardItemData CentaurWidgetCardItems
             */

            /**
             * Constructs a new TCentaurWidgetCardItemData.
             * @memberof NAlice.NData
             * @classdesc Represents a TCentaurWidgetCardItemData.
             * @implements ITCentaurWidgetCardItemData
             * @constructor
             * @param {NAlice.NData.ITCentaurWidgetCardItemData=} [properties] Properties to set
             */
            function TCentaurWidgetCardItemData(properties) {
                this.CentaurWidgetCardItems = [];
                if (properties)
                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                        if (properties[keys[i]] != null)
                            this[keys[i]] = properties[keys[i]];
            }

            /**
             * TCentaurWidgetCardItemData WidgetType.
             * @member {string} WidgetType
             * @memberof NAlice.NData.TCentaurWidgetCardItemData
             * @instance
             */
            TCentaurWidgetCardItemData.prototype.WidgetType = "";

            /**
             * TCentaurWidgetCardItemData CentaurWidgetCardItems.
             * @member {Array.<NAlice.NData.ITCentaurWidgetCardItem>} CentaurWidgetCardItems
             * @memberof NAlice.NData.TCentaurWidgetCardItemData
             * @instance
             */
            TCentaurWidgetCardItemData.prototype.CentaurWidgetCardItems = $util.emptyArray;

            /**
             * Creates a new TCentaurWidgetCardItemData instance using the specified properties.
             * @function create
             * @memberof NAlice.NData.TCentaurWidgetCardItemData
             * @static
             * @param {NAlice.NData.ITCentaurWidgetCardItemData=} [properties] Properties to set
             * @returns {NAlice.NData.TCentaurWidgetCardItemData} TCentaurWidgetCardItemData instance
             */
            TCentaurWidgetCardItemData.create = function create(properties) {
                return new TCentaurWidgetCardItemData(properties);
            };

            /**
             * Encodes the specified TCentaurWidgetCardItemData message. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardItemData.verify|verify} messages.
             * @function encode
             * @memberof NAlice.NData.TCentaurWidgetCardItemData
             * @static
             * @param {NAlice.NData.ITCentaurWidgetCardItemData} message TCentaurWidgetCardItemData message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            TCentaurWidgetCardItemData.encode = function encode(message, writer) {
                if (!writer)
                    writer = $Writer.create();
                if (message.WidgetType != null && Object.hasOwnProperty.call(message, "WidgetType"))
                    writer.uint32(/* id 1, wireType 2 =*/10).string(message.WidgetType);
                if (message.CentaurWidgetCardItems != null && message.CentaurWidgetCardItems.length)
                    for (var i = 0; i < message.CentaurWidgetCardItems.length; ++i)
                        $root.NAlice.NData.TCentaurWidgetCardItem.encode(message.CentaurWidgetCardItems[i], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                return writer;
            };

            /**
             * Encodes the specified TCentaurWidgetCardItemData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurWidgetCardItemData.verify|verify} messages.
             * @function encodeDelimited
             * @memberof NAlice.NData.TCentaurWidgetCardItemData
             * @static
             * @param {NAlice.NData.ITCentaurWidgetCardItemData} message TCentaurWidgetCardItemData message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            TCentaurWidgetCardItemData.encodeDelimited = function encodeDelimited(message, writer) {
                return this.encode(message, writer).ldelim();
            };

            /**
             * Decodes a TCentaurWidgetCardItemData message from the specified reader or buffer.
             * @function decode
             * @memberof NAlice.NData.TCentaurWidgetCardItemData
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @param {number} [length] Message length if known beforehand
             * @returns {NAlice.NData.TCentaurWidgetCardItemData} TCentaurWidgetCardItemData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            TCentaurWidgetCardItemData.decode = function decode(reader, length) {
                if (!(reader instanceof $Reader))
                    reader = $Reader.create(reader);
                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.NAlice.NData.TCentaurWidgetCardItemData();
                while (reader.pos < end) {
                    var tag = reader.uint32();
                    switch (tag >>> 3) {
                    case 1:
                        message.WidgetType = reader.string();
                        break;
                    case 2:
                        if (!(message.CentaurWidgetCardItems && message.CentaurWidgetCardItems.length))
                            message.CentaurWidgetCardItems = [];
                        message.CentaurWidgetCardItems.push($root.NAlice.NData.TCentaurWidgetCardItem.decode(reader, reader.uint32()));
                        break;
                    default:
                        reader.skipType(tag & 7);
                        break;
                    }
                }
                return message;
            };

            /**
             * Decodes a TCentaurWidgetCardItemData message from the specified reader or buffer, length delimited.
             * @function decodeDelimited
             * @memberof NAlice.NData.TCentaurWidgetCardItemData
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @returns {NAlice.NData.TCentaurWidgetCardItemData} TCentaurWidgetCardItemData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            TCentaurWidgetCardItemData.decodeDelimited = function decodeDelimited(reader) {
                if (!(reader instanceof $Reader))
                    reader = new $Reader(reader);
                return this.decode(reader, reader.uint32());
            };

            /**
             * Verifies a TCentaurWidgetCardItemData message.
             * @function verify
             * @memberof NAlice.NData.TCentaurWidgetCardItemData
             * @static
             * @param {Object.<string,*>} message Plain object to verify
             * @returns {string|null} `null` if valid, otherwise the reason why it is not
             */
            TCentaurWidgetCardItemData.verify = function verify(message) {
                if (typeof message !== "object" || message === null)
                    return "object expected";
                if (message.WidgetType != null && message.hasOwnProperty("WidgetType"))
                    if (!$util.isString(message.WidgetType))
                        return "WidgetType: string expected";
                if (message.CentaurWidgetCardItems != null && message.hasOwnProperty("CentaurWidgetCardItems")) {
                    if (!Array.isArray(message.CentaurWidgetCardItems))
                        return "CentaurWidgetCardItems: array expected";
                    for (var i = 0; i < message.CentaurWidgetCardItems.length; ++i) {
                        var error = $root.NAlice.NData.TCentaurWidgetCardItem.verify(message.CentaurWidgetCardItems[i]);
                        if (error)
                            return "CentaurWidgetCardItems." + error;
                    }
                }
                return null;
            };

            /**
             * Creates a TCentaurWidgetCardItemData message from a plain object. Also converts values to their respective internal types.
             * @function fromObject
             * @memberof NAlice.NData.TCentaurWidgetCardItemData
             * @static
             * @param {Object.<string,*>} object Plain object
             * @returns {NAlice.NData.TCentaurWidgetCardItemData} TCentaurWidgetCardItemData
             */
            TCentaurWidgetCardItemData.fromObject = function fromObject(object) {
                if (object instanceof $root.NAlice.NData.TCentaurWidgetCardItemData)
                    return object;
                var message = new $root.NAlice.NData.TCentaurWidgetCardItemData();
                if (object.WidgetType != null)
                    message.WidgetType = String(object.WidgetType);
                if (object.CentaurWidgetCardItems) {
                    if (!Array.isArray(object.CentaurWidgetCardItems))
                        throw TypeError(".NAlice.NData.TCentaurWidgetCardItemData.CentaurWidgetCardItems: array expected");
                    message.CentaurWidgetCardItems = [];
                    for (var i = 0; i < object.CentaurWidgetCardItems.length; ++i) {
                        if (typeof object.CentaurWidgetCardItems[i] !== "object")
                            throw TypeError(".NAlice.NData.TCentaurWidgetCardItemData.CentaurWidgetCardItems: object expected");
                        message.CentaurWidgetCardItems[i] = $root.NAlice.NData.TCentaurWidgetCardItem.fromObject(object.CentaurWidgetCardItems[i]);
                    }
                }
                return message;
            };

            /**
             * Creates a plain object from a TCentaurWidgetCardItemData message. Also converts values to other types if specified.
             * @function toObject
             * @memberof NAlice.NData.TCentaurWidgetCardItemData
             * @static
             * @param {NAlice.NData.TCentaurWidgetCardItemData} message TCentaurWidgetCardItemData
             * @param {$protobuf.IConversionOptions} [options] Conversion options
             * @returns {Object.<string,*>} Plain object
             */
            TCentaurWidgetCardItemData.toObject = function toObject(message, options) {
                if (!options)
                    options = {};
                var object = {};
                if (options.arrays || options.defaults)
                    object.CentaurWidgetCardItems = [];
                if (options.defaults)
                    object.WidgetType = "";
                if (message.WidgetType != null && message.hasOwnProperty("WidgetType"))
                    object.WidgetType = message.WidgetType;
                if (message.CentaurWidgetCardItems && message.CentaurWidgetCardItems.length) {
                    object.CentaurWidgetCardItems = [];
                    for (var j = 0; j < message.CentaurWidgetCardItems.length; ++j)
                        object.CentaurWidgetCardItems[j] = $root.NAlice.NData.TCentaurWidgetCardItem.toObject(message.CentaurWidgetCardItems[j], options);
                }
                return object;
            };

            /**
             * Converts this TCentaurWidgetCardItemData to JSON.
             * @function toJSON
             * @memberof NAlice.NData.TCentaurWidgetCardItemData
             * @instance
             * @returns {Object.<string,*>} JSON object
             */
            TCentaurWidgetCardItemData.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            return TCentaurWidgetCardItemData;
        })();

        NData.TCentaurScenarioWidgetData = (function() {

            /**
             * Properties of a TCentaurScenarioWidgetData.
             * @memberof NAlice.NData
             * @interface ITCentaurScenarioWidgetData
             * @property {string|null} [WidgetType] TCentaurScenarioWidgetData WidgetType
             * @property {Array.<NAlice.NData.ITCentaurWidgetCardData>|null} [WidgetCards] TCentaurScenarioWidgetData WidgetCards
             */

            /**
             * Constructs a new TCentaurScenarioWidgetData.
             * @memberof NAlice.NData
             * @classdesc Represents a TCentaurScenarioWidgetData.
             * @implements ITCentaurScenarioWidgetData
             * @constructor
             * @param {NAlice.NData.ITCentaurScenarioWidgetData=} [properties] Properties to set
             */
            function TCentaurScenarioWidgetData(properties) {
                this.WidgetCards = [];
                if (properties)
                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                        if (properties[keys[i]] != null)
                            this[keys[i]] = properties[keys[i]];
            }

            /**
             * TCentaurScenarioWidgetData WidgetType.
             * @member {string} WidgetType
             * @memberof NAlice.NData.TCentaurScenarioWidgetData
             * @instance
             */
            TCentaurScenarioWidgetData.prototype.WidgetType = "";

            /**
             * TCentaurScenarioWidgetData WidgetCards.
             * @member {Array.<NAlice.NData.ITCentaurWidgetCardData>} WidgetCards
             * @memberof NAlice.NData.TCentaurScenarioWidgetData
             * @instance
             */
            TCentaurScenarioWidgetData.prototype.WidgetCards = $util.emptyArray;

            /**
             * Creates a new TCentaurScenarioWidgetData instance using the specified properties.
             * @function create
             * @memberof NAlice.NData.TCentaurScenarioWidgetData
             * @static
             * @param {NAlice.NData.ITCentaurScenarioWidgetData=} [properties] Properties to set
             * @returns {NAlice.NData.TCentaurScenarioWidgetData} TCentaurScenarioWidgetData instance
             */
            TCentaurScenarioWidgetData.create = function create(properties) {
                return new TCentaurScenarioWidgetData(properties);
            };

            /**
             * Encodes the specified TCentaurScenarioWidgetData message. Does not implicitly {@link NAlice.NData.TCentaurScenarioWidgetData.verify|verify} messages.
             * @function encode
             * @memberof NAlice.NData.TCentaurScenarioWidgetData
             * @static
             * @param {NAlice.NData.ITCentaurScenarioWidgetData} message TCentaurScenarioWidgetData message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            TCentaurScenarioWidgetData.encode = function encode(message, writer) {
                if (!writer)
                    writer = $Writer.create();
                if (message.WidgetType != null && Object.hasOwnProperty.call(message, "WidgetType"))
                    writer.uint32(/* id 1, wireType 2 =*/10).string(message.WidgetType);
                if (message.WidgetCards != null && message.WidgetCards.length)
                    for (var i = 0; i < message.WidgetCards.length; ++i)
                        $root.NAlice.NData.TCentaurWidgetCardData.encode(message.WidgetCards[i], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                return writer;
            };

            /**
             * Encodes the specified TCentaurScenarioWidgetData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurScenarioWidgetData.verify|verify} messages.
             * @function encodeDelimited
             * @memberof NAlice.NData.TCentaurScenarioWidgetData
             * @static
             * @param {NAlice.NData.ITCentaurScenarioWidgetData} message TCentaurScenarioWidgetData message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            TCentaurScenarioWidgetData.encodeDelimited = function encodeDelimited(message, writer) {
                return this.encode(message, writer).ldelim();
            };

            /**
             * Decodes a TCentaurScenarioWidgetData message from the specified reader or buffer.
             * @function decode
             * @memberof NAlice.NData.TCentaurScenarioWidgetData
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @param {number} [length] Message length if known beforehand
             * @returns {NAlice.NData.TCentaurScenarioWidgetData} TCentaurScenarioWidgetData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            TCentaurScenarioWidgetData.decode = function decode(reader, length) {
                if (!(reader instanceof $Reader))
                    reader = $Reader.create(reader);
                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.NAlice.NData.TCentaurScenarioWidgetData();
                while (reader.pos < end) {
                    var tag = reader.uint32();
                    switch (tag >>> 3) {
                    case 1:
                        message.WidgetType = reader.string();
                        break;
                    case 2:
                        if (!(message.WidgetCards && message.WidgetCards.length))
                            message.WidgetCards = [];
                        message.WidgetCards.push($root.NAlice.NData.TCentaurWidgetCardData.decode(reader, reader.uint32()));
                        break;
                    default:
                        reader.skipType(tag & 7);
                        break;
                    }
                }
                return message;
            };

            /**
             * Decodes a TCentaurScenarioWidgetData message from the specified reader or buffer, length delimited.
             * @function decodeDelimited
             * @memberof NAlice.NData.TCentaurScenarioWidgetData
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @returns {NAlice.NData.TCentaurScenarioWidgetData} TCentaurScenarioWidgetData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            TCentaurScenarioWidgetData.decodeDelimited = function decodeDelimited(reader) {
                if (!(reader instanceof $Reader))
                    reader = new $Reader(reader);
                return this.decode(reader, reader.uint32());
            };

            /**
             * Verifies a TCentaurScenarioWidgetData message.
             * @function verify
             * @memberof NAlice.NData.TCentaurScenarioWidgetData
             * @static
             * @param {Object.<string,*>} message Plain object to verify
             * @returns {string|null} `null` if valid, otherwise the reason why it is not
             */
            TCentaurScenarioWidgetData.verify = function verify(message) {
                if (typeof message !== "object" || message === null)
                    return "object expected";
                if (message.WidgetType != null && message.hasOwnProperty("WidgetType"))
                    if (!$util.isString(message.WidgetType))
                        return "WidgetType: string expected";
                if (message.WidgetCards != null && message.hasOwnProperty("WidgetCards")) {
                    if (!Array.isArray(message.WidgetCards))
                        return "WidgetCards: array expected";
                    for (var i = 0; i < message.WidgetCards.length; ++i) {
                        var error = $root.NAlice.NData.TCentaurWidgetCardData.verify(message.WidgetCards[i]);
                        if (error)
                            return "WidgetCards." + error;
                    }
                }
                return null;
            };

            /**
             * Creates a TCentaurScenarioWidgetData message from a plain object. Also converts values to their respective internal types.
             * @function fromObject
             * @memberof NAlice.NData.TCentaurScenarioWidgetData
             * @static
             * @param {Object.<string,*>} object Plain object
             * @returns {NAlice.NData.TCentaurScenarioWidgetData} TCentaurScenarioWidgetData
             */
            TCentaurScenarioWidgetData.fromObject = function fromObject(object) {
                if (object instanceof $root.NAlice.NData.TCentaurScenarioWidgetData)
                    return object;
                var message = new $root.NAlice.NData.TCentaurScenarioWidgetData();
                if (object.WidgetType != null)
                    message.WidgetType = String(object.WidgetType);
                if (object.WidgetCards) {
                    if (!Array.isArray(object.WidgetCards))
                        throw TypeError(".NAlice.NData.TCentaurScenarioWidgetData.WidgetCards: array expected");
                    message.WidgetCards = [];
                    for (var i = 0; i < object.WidgetCards.length; ++i) {
                        if (typeof object.WidgetCards[i] !== "object")
                            throw TypeError(".NAlice.NData.TCentaurScenarioWidgetData.WidgetCards: object expected");
                        message.WidgetCards[i] = $root.NAlice.NData.TCentaurWidgetCardData.fromObject(object.WidgetCards[i]);
                    }
                }
                return message;
            };

            /**
             * Creates a plain object from a TCentaurScenarioWidgetData message. Also converts values to other types if specified.
             * @function toObject
             * @memberof NAlice.NData.TCentaurScenarioWidgetData
             * @static
             * @param {NAlice.NData.TCentaurScenarioWidgetData} message TCentaurScenarioWidgetData
             * @param {$protobuf.IConversionOptions} [options] Conversion options
             * @returns {Object.<string,*>} Plain object
             */
            TCentaurScenarioWidgetData.toObject = function toObject(message, options) {
                if (!options)
                    options = {};
                var object = {};
                if (options.arrays || options.defaults)
                    object.WidgetCards = [];
                if (options.defaults)
                    object.WidgetType = "";
                if (message.WidgetType != null && message.hasOwnProperty("WidgetType"))
                    object.WidgetType = message.WidgetType;
                if (message.WidgetCards && message.WidgetCards.length) {
                    object.WidgetCards = [];
                    for (var j = 0; j < message.WidgetCards.length; ++j)
                        object.WidgetCards[j] = $root.NAlice.NData.TCentaurWidgetCardData.toObject(message.WidgetCards[j], options);
                }
                return object;
            };

            /**
             * Converts this TCentaurScenarioWidgetData to JSON.
             * @function toJSON
             * @memberof NAlice.NData.TCentaurScenarioWidgetData
             * @instance
             * @returns {Object.<string,*>} JSON object
             */
            TCentaurScenarioWidgetData.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            return TCentaurScenarioWidgetData;
        })();

        NData.TCentaurMainScreenMyScreenData = (function() {

            /**
             * Properties of a TCentaurMainScreenMyScreenData.
             * @memberof NAlice.NData
             * @interface ITCentaurMainScreenMyScreenData
             * @property {string|null} [Id] TCentaurMainScreenMyScreenData Id
             * @property {Array.<NAlice.NData.TCentaurMainScreenMyScreenData.ITColumn>|null} [Columns] TCentaurMainScreenMyScreenData Columns
             */

            /**
             * Constructs a new TCentaurMainScreenMyScreenData.
             * @memberof NAlice.NData
             * @classdesc Represents a TCentaurMainScreenMyScreenData.
             * @implements ITCentaurMainScreenMyScreenData
             * @constructor
             * @param {NAlice.NData.ITCentaurMainScreenMyScreenData=} [properties] Properties to set
             */
            function TCentaurMainScreenMyScreenData(properties) {
                this.Columns = [];
                if (properties)
                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                        if (properties[keys[i]] != null)
                            this[keys[i]] = properties[keys[i]];
            }

            /**
             * TCentaurMainScreenMyScreenData Id.
             * @member {string} Id
             * @memberof NAlice.NData.TCentaurMainScreenMyScreenData
             * @instance
             */
            TCentaurMainScreenMyScreenData.prototype.Id = "";

            /**
             * TCentaurMainScreenMyScreenData Columns.
             * @member {Array.<NAlice.NData.TCentaurMainScreenMyScreenData.ITColumn>} Columns
             * @memberof NAlice.NData.TCentaurMainScreenMyScreenData
             * @instance
             */
            TCentaurMainScreenMyScreenData.prototype.Columns = $util.emptyArray;

            /**
             * Creates a new TCentaurMainScreenMyScreenData instance using the specified properties.
             * @function create
             * @memberof NAlice.NData.TCentaurMainScreenMyScreenData
             * @static
             * @param {NAlice.NData.ITCentaurMainScreenMyScreenData=} [properties] Properties to set
             * @returns {NAlice.NData.TCentaurMainScreenMyScreenData} TCentaurMainScreenMyScreenData instance
             */
            TCentaurMainScreenMyScreenData.create = function create(properties) {
                return new TCentaurMainScreenMyScreenData(properties);
            };

            /**
             * Encodes the specified TCentaurMainScreenMyScreenData message. Does not implicitly {@link NAlice.NData.TCentaurMainScreenMyScreenData.verify|verify} messages.
             * @function encode
             * @memberof NAlice.NData.TCentaurMainScreenMyScreenData
             * @static
             * @param {NAlice.NData.ITCentaurMainScreenMyScreenData} message TCentaurMainScreenMyScreenData message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            TCentaurMainScreenMyScreenData.encode = function encode(message, writer) {
                if (!writer)
                    writer = $Writer.create();
                if (message.Id != null && Object.hasOwnProperty.call(message, "Id"))
                    writer.uint32(/* id 1, wireType 2 =*/10).string(message.Id);
                if (message.Columns != null && message.Columns.length)
                    for (var i = 0; i < message.Columns.length; ++i)
                        $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.encode(message.Columns[i], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                return writer;
            };

            /**
             * Encodes the specified TCentaurMainScreenMyScreenData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurMainScreenMyScreenData.verify|verify} messages.
             * @function encodeDelimited
             * @memberof NAlice.NData.TCentaurMainScreenMyScreenData
             * @static
             * @param {NAlice.NData.ITCentaurMainScreenMyScreenData} message TCentaurMainScreenMyScreenData message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            TCentaurMainScreenMyScreenData.encodeDelimited = function encodeDelimited(message, writer) {
                return this.encode(message, writer).ldelim();
            };

            /**
             * Decodes a TCentaurMainScreenMyScreenData message from the specified reader or buffer.
             * @function decode
             * @memberof NAlice.NData.TCentaurMainScreenMyScreenData
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @param {number} [length] Message length if known beforehand
             * @returns {NAlice.NData.TCentaurMainScreenMyScreenData} TCentaurMainScreenMyScreenData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            TCentaurMainScreenMyScreenData.decode = function decode(reader, length) {
                if (!(reader instanceof $Reader))
                    reader = $Reader.create(reader);
                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.NAlice.NData.TCentaurMainScreenMyScreenData();
                while (reader.pos < end) {
                    var tag = reader.uint32();
                    switch (tag >>> 3) {
                    case 1:
                        message.Id = reader.string();
                        break;
                    case 2:
                        if (!(message.Columns && message.Columns.length))
                            message.Columns = [];
                        message.Columns.push($root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.decode(reader, reader.uint32()));
                        break;
                    default:
                        reader.skipType(tag & 7);
                        break;
                    }
                }
                return message;
            };

            /**
             * Decodes a TCentaurMainScreenMyScreenData message from the specified reader or buffer, length delimited.
             * @function decodeDelimited
             * @memberof NAlice.NData.TCentaurMainScreenMyScreenData
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @returns {NAlice.NData.TCentaurMainScreenMyScreenData} TCentaurMainScreenMyScreenData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            TCentaurMainScreenMyScreenData.decodeDelimited = function decodeDelimited(reader) {
                if (!(reader instanceof $Reader))
                    reader = new $Reader(reader);
                return this.decode(reader, reader.uint32());
            };

            /**
             * Verifies a TCentaurMainScreenMyScreenData message.
             * @function verify
             * @memberof NAlice.NData.TCentaurMainScreenMyScreenData
             * @static
             * @param {Object.<string,*>} message Plain object to verify
             * @returns {string|null} `null` if valid, otherwise the reason why it is not
             */
            TCentaurMainScreenMyScreenData.verify = function verify(message) {
                if (typeof message !== "object" || message === null)
                    return "object expected";
                if (message.Id != null && message.hasOwnProperty("Id"))
                    if (!$util.isString(message.Id))
                        return "Id: string expected";
                if (message.Columns != null && message.hasOwnProperty("Columns")) {
                    if (!Array.isArray(message.Columns))
                        return "Columns: array expected";
                    for (var i = 0; i < message.Columns.length; ++i) {
                        var error = $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.verify(message.Columns[i]);
                        if (error)
                            return "Columns." + error;
                    }
                }
                return null;
            };

            /**
             * Creates a TCentaurMainScreenMyScreenData message from a plain object. Also converts values to their respective internal types.
             * @function fromObject
             * @memberof NAlice.NData.TCentaurMainScreenMyScreenData
             * @static
             * @param {Object.<string,*>} object Plain object
             * @returns {NAlice.NData.TCentaurMainScreenMyScreenData} TCentaurMainScreenMyScreenData
             */
            TCentaurMainScreenMyScreenData.fromObject = function fromObject(object) {
                if (object instanceof $root.NAlice.NData.TCentaurMainScreenMyScreenData)
                    return object;
                var message = new $root.NAlice.NData.TCentaurMainScreenMyScreenData();
                if (object.Id != null)
                    message.Id = String(object.Id);
                if (object.Columns) {
                    if (!Array.isArray(object.Columns))
                        throw TypeError(".NAlice.NData.TCentaurMainScreenMyScreenData.Columns: array expected");
                    message.Columns = [];
                    for (var i = 0; i < object.Columns.length; ++i) {
                        if (typeof object.Columns[i] !== "object")
                            throw TypeError(".NAlice.NData.TCentaurMainScreenMyScreenData.Columns: object expected");
                        message.Columns[i] = $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.fromObject(object.Columns[i]);
                    }
                }
                return message;
            };

            /**
             * Creates a plain object from a TCentaurMainScreenMyScreenData message. Also converts values to other types if specified.
             * @function toObject
             * @memberof NAlice.NData.TCentaurMainScreenMyScreenData
             * @static
             * @param {NAlice.NData.TCentaurMainScreenMyScreenData} message TCentaurMainScreenMyScreenData
             * @param {$protobuf.IConversionOptions} [options] Conversion options
             * @returns {Object.<string,*>} Plain object
             */
            TCentaurMainScreenMyScreenData.toObject = function toObject(message, options) {
                if (!options)
                    options = {};
                var object = {};
                if (options.arrays || options.defaults)
                    object.Columns = [];
                if (options.defaults)
                    object.Id = "";
                if (message.Id != null && message.hasOwnProperty("Id"))
                    object.Id = message.Id;
                if (message.Columns && message.Columns.length) {
                    object.Columns = [];
                    for (var j = 0; j < message.Columns.length; ++j)
                        object.Columns[j] = $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.toObject(message.Columns[j], options);
                }
                return object;
            };

            /**
             * Converts this TCentaurMainScreenMyScreenData to JSON.
             * @function toJSON
             * @memberof NAlice.NData.TCentaurMainScreenMyScreenData
             * @instance
             * @returns {Object.<string,*>} JSON object
             */
            TCentaurMainScreenMyScreenData.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            TCentaurMainScreenMyScreenData.TColumn = (function() {

                /**
                 * Properties of a TColumn.
                 * @memberof NAlice.NData.TCentaurMainScreenMyScreenData
                 * @interface ITColumn
                 * @property {Array.<NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.ITCardData>|null} [Cards] TColumn Cards
                 * @property {Array.<NAlice.NData.ITCentaurWidgetCardData>|null} [WidgetCards] TColumn WidgetCards
                 * @property {Array.<NAlice.NData.ITCentaurWidgetCardItem>|null} [WidgetCardItems] TColumn WidgetCardItems
                 */

                /**
                 * Constructs a new TColumn.
                 * @memberof NAlice.NData.TCentaurMainScreenMyScreenData
                 * @classdesc Represents a TColumn.
                 * @implements ITColumn
                 * @constructor
                 * @param {NAlice.NData.TCentaurMainScreenMyScreenData.ITColumn=} [properties] Properties to set
                 */
                function TColumn(properties) {
                    this.Cards = [];
                    this.WidgetCards = [];
                    this.WidgetCardItems = [];
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }

                /**
                 * TColumn Cards.
                 * @member {Array.<NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.ITCardData>} Cards
                 * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn
                 * @instance
                 */
                TColumn.prototype.Cards = $util.emptyArray;

                /**
                 * TColumn WidgetCards.
                 * @member {Array.<NAlice.NData.ITCentaurWidgetCardData>} WidgetCards
                 * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn
                 * @instance
                 */
                TColumn.prototype.WidgetCards = $util.emptyArray;

                /**
                 * TColumn WidgetCardItems.
                 * @member {Array.<NAlice.NData.ITCentaurWidgetCardItem>} WidgetCardItems
                 * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn
                 * @instance
                 */
                TColumn.prototype.WidgetCardItems = $util.emptyArray;

                /**
                 * Creates a new TColumn instance using the specified properties.
                 * @function create
                 * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn
                 * @static
                 * @param {NAlice.NData.TCentaurMainScreenMyScreenData.ITColumn=} [properties] Properties to set
                 * @returns {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn} TColumn instance
                 */
                TColumn.create = function create(properties) {
                    return new TColumn(properties);
                };

                /**
                 * Encodes the specified TColumn message. Does not implicitly {@link NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.verify|verify} messages.
                 * @function encode
                 * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn
                 * @static
                 * @param {NAlice.NData.TCentaurMainScreenMyScreenData.ITColumn} message TColumn message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                TColumn.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.Cards != null && message.Cards.length)
                        for (var i = 0; i < message.Cards.length; ++i)
                            $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.encode(message.Cards[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                    if (message.WidgetCards != null && message.WidgetCards.length)
                        for (var i = 0; i < message.WidgetCards.length; ++i)
                            $root.NAlice.NData.TCentaurWidgetCardData.encode(message.WidgetCards[i], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                    if (message.WidgetCardItems != null && message.WidgetCardItems.length)
                        for (var i = 0; i < message.WidgetCardItems.length; ++i)
                            $root.NAlice.NData.TCentaurWidgetCardItem.encode(message.WidgetCardItems[i], writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                    return writer;
                };

                /**
                 * Encodes the specified TColumn message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.verify|verify} messages.
                 * @function encodeDelimited
                 * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn
                 * @static
                 * @param {NAlice.NData.TCentaurMainScreenMyScreenData.ITColumn} message TColumn message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                TColumn.encodeDelimited = function encodeDelimited(message, writer) {
                    return this.encode(message, writer).ldelim();
                };

                /**
                 * Decodes a TColumn message from the specified reader or buffer.
                 * @function decode
                 * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn} TColumn
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                TColumn.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            if (!(message.Cards && message.Cards.length))
                                message.Cards = [];
                            message.Cards.push($root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.decode(reader, reader.uint32()));
                            break;
                        case 2:
                            if (!(message.WidgetCards && message.WidgetCards.length))
                                message.WidgetCards = [];
                            message.WidgetCards.push($root.NAlice.NData.TCentaurWidgetCardData.decode(reader, reader.uint32()));
                            break;
                        case 3:
                            if (!(message.WidgetCardItems && message.WidgetCardItems.length))
                                message.WidgetCardItems = [];
                            message.WidgetCardItems.push($root.NAlice.NData.TCentaurWidgetCardItem.decode(reader, reader.uint32()));
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };

                /**
                 * Decodes a TColumn message from the specified reader or buffer, length delimited.
                 * @function decodeDelimited
                 * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @returns {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn} TColumn
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                TColumn.decodeDelimited = function decodeDelimited(reader) {
                    if (!(reader instanceof $Reader))
                        reader = new $Reader(reader);
                    return this.decode(reader, reader.uint32());
                };

                /**
                 * Verifies a TColumn message.
                 * @function verify
                 * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                TColumn.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.Cards != null && message.hasOwnProperty("Cards")) {
                        if (!Array.isArray(message.Cards))
                            return "Cards: array expected";
                        for (var i = 0; i < message.Cards.length; ++i) {
                            var error = $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.verify(message.Cards[i]);
                            if (error)
                                return "Cards." + error;
                        }
                    }
                    if (message.WidgetCards != null && message.hasOwnProperty("WidgetCards")) {
                        if (!Array.isArray(message.WidgetCards))
                            return "WidgetCards: array expected";
                        for (var i = 0; i < message.WidgetCards.length; ++i) {
                            var error = $root.NAlice.NData.TCentaurWidgetCardData.verify(message.WidgetCards[i]);
                            if (error)
                                return "WidgetCards." + error;
                        }
                    }
                    if (message.WidgetCardItems != null && message.hasOwnProperty("WidgetCardItems")) {
                        if (!Array.isArray(message.WidgetCardItems))
                            return "WidgetCardItems: array expected";
                        for (var i = 0; i < message.WidgetCardItems.length; ++i) {
                            var error = $root.NAlice.NData.TCentaurWidgetCardItem.verify(message.WidgetCardItems[i]);
                            if (error)
                                return "WidgetCardItems." + error;
                        }
                    }
                    return null;
                };

                /**
                 * Creates a TColumn message from a plain object. Also converts values to their respective internal types.
                 * @function fromObject
                 * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn
                 * @static
                 * @param {Object.<string,*>} object Plain object
                 * @returns {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn} TColumn
                 */
                TColumn.fromObject = function fromObject(object) {
                    if (object instanceof $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn)
                        return object;
                    var message = new $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn();
                    if (object.Cards) {
                        if (!Array.isArray(object.Cards))
                            throw TypeError(".NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.Cards: array expected");
                        message.Cards = [];
                        for (var i = 0; i < object.Cards.length; ++i) {
                            if (typeof object.Cards[i] !== "object")
                                throw TypeError(".NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.Cards: object expected");
                            message.Cards[i] = $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.fromObject(object.Cards[i]);
                        }
                    }
                    if (object.WidgetCards) {
                        if (!Array.isArray(object.WidgetCards))
                            throw TypeError(".NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.WidgetCards: array expected");
                        message.WidgetCards = [];
                        for (var i = 0; i < object.WidgetCards.length; ++i) {
                            if (typeof object.WidgetCards[i] !== "object")
                                throw TypeError(".NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.WidgetCards: object expected");
                            message.WidgetCards[i] = $root.NAlice.NData.TCentaurWidgetCardData.fromObject(object.WidgetCards[i]);
                        }
                    }
                    if (object.WidgetCardItems) {
                        if (!Array.isArray(object.WidgetCardItems))
                            throw TypeError(".NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.WidgetCardItems: array expected");
                        message.WidgetCardItems = [];
                        for (var i = 0; i < object.WidgetCardItems.length; ++i) {
                            if (typeof object.WidgetCardItems[i] !== "object")
                                throw TypeError(".NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.WidgetCardItems: object expected");
                            message.WidgetCardItems[i] = $root.NAlice.NData.TCentaurWidgetCardItem.fromObject(object.WidgetCardItems[i]);
                        }
                    }
                    return message;
                };

                /**
                 * Creates a plain object from a TColumn message. Also converts values to other types if specified.
                 * @function toObject
                 * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn
                 * @static
                 * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn} message TColumn
                 * @param {$protobuf.IConversionOptions} [options] Conversion options
                 * @returns {Object.<string,*>} Plain object
                 */
                TColumn.toObject = function toObject(message, options) {
                    if (!options)
                        options = {};
                    var object = {};
                    if (options.arrays || options.defaults) {
                        object.Cards = [];
                        object.WidgetCards = [];
                        object.WidgetCardItems = [];
                    }
                    if (message.Cards && message.Cards.length) {
                        object.Cards = [];
                        for (var j = 0; j < message.Cards.length; ++j)
                            object.Cards[j] = $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.toObject(message.Cards[j], options);
                    }
                    if (message.WidgetCards && message.WidgetCards.length) {
                        object.WidgetCards = [];
                        for (var j = 0; j < message.WidgetCards.length; ++j)
                            object.WidgetCards[j] = $root.NAlice.NData.TCentaurWidgetCardData.toObject(message.WidgetCards[j], options);
                    }
                    if (message.WidgetCardItems && message.WidgetCardItems.length) {
                        object.WidgetCardItems = [];
                        for (var j = 0; j < message.WidgetCardItems.length; ++j)
                            object.WidgetCardItems[j] = $root.NAlice.NData.TCentaurWidgetCardItem.toObject(message.WidgetCardItems[j], options);
                    }
                    return object;
                };

                /**
                 * Converts this TColumn to JSON.
                 * @function toJSON
                 * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn
                 * @instance
                 * @returns {Object.<string,*>} JSON object
                 */
                TColumn.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };

                TColumn.TCardData = (function() {

                    /**
                     * Properties of a TCardData.
                     * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn
                     * @interface ITCardData
                     * @property {string|null} [Id] TCardData Id
                     * @property {string|null} [Action] TCardData Action
                     * @property {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITInfoCardData|null} [InfoCardData] TCardData InfoCardData
                     * @property {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITMusicCardData|null} [MusicCardData] TCardData MusicCardData
                     * @property {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITNewsCardData|null} [NewsCardData] TCardData NewsCardData
                     * @property {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITWeatherCardData|null} [WeatherCardData] TCardData WeatherCardData
                     * @property {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITYouTubeCardData|null} [YouTubeCardData] TCardData YouTubeCardData
                     * @property {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITVacantCardData|null} [VacantCardData] TCardData VacantCardData
                     * @property {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITTrafficCardData|null} [TrafficCardData] TCardData TrafficCardData
                     * @property {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITVideoCallCardData|null} [VideoCallCardData] TCardData VideoCallCardData
                     * @property {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITExternalSkillCardData|null} [ExternalSkillCardData] TCardData ExternalSkillCardData
                     * @property {string|null} [LongTapAction] TCardData LongTapAction
                     * @property {string|null} [DeleteWidgetAction] TCardData DeleteWidgetAction
                     * @property {google.protobuf.IAny|null} [TypedAction] TCardData TypedAction
                     * @property {google.protobuf.IAny|null} [LongTapTypedAction] TCardData LongTapTypedAction
                     * @property {google.protobuf.IAny|null} [DeleteWidgetTypedAction] TCardData DeleteWidgetTypedAction
                     */

                    /**
                     * Constructs a new TCardData.
                     * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn
                     * @classdesc Represents a TCardData.
                     * @implements ITCardData
                     * @constructor
                     * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.ITCardData=} [properties] Properties to set
                     */
                    function TCardData(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }

                    /**
                     * TCardData Id.
                     * @member {string} Id
                     * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData
                     * @instance
                     */
                    TCardData.prototype.Id = "";

                    /**
                     * TCardData Action.
                     * @member {string} Action
                     * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData
                     * @instance
                     */
                    TCardData.prototype.Action = "";

                    /**
                     * TCardData InfoCardData.
                     * @member {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITInfoCardData|null|undefined} InfoCardData
                     * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData
                     * @instance
                     */
                    TCardData.prototype.InfoCardData = null;

                    /**
                     * TCardData MusicCardData.
                     * @member {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITMusicCardData|null|undefined} MusicCardData
                     * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData
                     * @instance
                     */
                    TCardData.prototype.MusicCardData = null;

                    /**
                     * TCardData NewsCardData.
                     * @member {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITNewsCardData|null|undefined} NewsCardData
                     * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData
                     * @instance
                     */
                    TCardData.prototype.NewsCardData = null;

                    /**
                     * TCardData WeatherCardData.
                     * @member {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITWeatherCardData|null|undefined} WeatherCardData
                     * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData
                     * @instance
                     */
                    TCardData.prototype.WeatherCardData = null;

                    /**
                     * TCardData YouTubeCardData.
                     * @member {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITYouTubeCardData|null|undefined} YouTubeCardData
                     * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData
                     * @instance
                     */
                    TCardData.prototype.YouTubeCardData = null;

                    /**
                     * TCardData VacantCardData.
                     * @member {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITVacantCardData|null|undefined} VacantCardData
                     * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData
                     * @instance
                     */
                    TCardData.prototype.VacantCardData = null;

                    /**
                     * TCardData TrafficCardData.
                     * @member {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITTrafficCardData|null|undefined} TrafficCardData
                     * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData
                     * @instance
                     */
                    TCardData.prototype.TrafficCardData = null;

                    /**
                     * TCardData VideoCallCardData.
                     * @member {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITVideoCallCardData|null|undefined} VideoCallCardData
                     * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData
                     * @instance
                     */
                    TCardData.prototype.VideoCallCardData = null;

                    /**
                     * TCardData ExternalSkillCardData.
                     * @member {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITExternalSkillCardData|null|undefined} ExternalSkillCardData
                     * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData
                     * @instance
                     */
                    TCardData.prototype.ExternalSkillCardData = null;

                    /**
                     * TCardData LongTapAction.
                     * @member {string} LongTapAction
                     * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData
                     * @instance
                     */
                    TCardData.prototype.LongTapAction = "";

                    /**
                     * TCardData DeleteWidgetAction.
                     * @member {string} DeleteWidgetAction
                     * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData
                     * @instance
                     */
                    TCardData.prototype.DeleteWidgetAction = "";

                    /**
                     * TCardData TypedAction.
                     * @member {google.protobuf.IAny|null|undefined} TypedAction
                     * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData
                     * @instance
                     */
                    TCardData.prototype.TypedAction = null;

                    /**
                     * TCardData LongTapTypedAction.
                     * @member {google.protobuf.IAny|null|undefined} LongTapTypedAction
                     * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData
                     * @instance
                     */
                    TCardData.prototype.LongTapTypedAction = null;

                    /**
                     * TCardData DeleteWidgetTypedAction.
                     * @member {google.protobuf.IAny|null|undefined} DeleteWidgetTypedAction
                     * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData
                     * @instance
                     */
                    TCardData.prototype.DeleteWidgetTypedAction = null;

                    // OneOf field names bound to virtual getters and setters
                    var $oneOfFields;

                    /**
                     * TCardData CardData.
                     * @member {"InfoCardData"|"MusicCardData"|"NewsCardData"|"WeatherCardData"|"YouTubeCardData"|"VacantCardData"|"TrafficCardData"|"VideoCallCardData"|"ExternalSkillCardData"|undefined} CardData
                     * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData
                     * @instance
                     */
                    Object.defineProperty(TCardData.prototype, "CardData", {
                        get: $util.oneOfGetter($oneOfFields = ["InfoCardData", "MusicCardData", "NewsCardData", "WeatherCardData", "YouTubeCardData", "VacantCardData", "TrafficCardData", "VideoCallCardData", "ExternalSkillCardData"]),
                        set: $util.oneOfSetter($oneOfFields)
                    });

                    /**
                     * Creates a new TCardData instance using the specified properties.
                     * @function create
                     * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData
                     * @static
                     * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.ITCardData=} [properties] Properties to set
                     * @returns {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData} TCardData instance
                     */
                    TCardData.create = function create(properties) {
                        return new TCardData(properties);
                    };

                    /**
                     * Encodes the specified TCardData message. Does not implicitly {@link NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.verify|verify} messages.
                     * @function encode
                     * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData
                     * @static
                     * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.ITCardData} message TCardData message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    TCardData.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.Id != null && Object.hasOwnProperty.call(message, "Id"))
                            writer.uint32(/* id 1, wireType 2 =*/10).string(message.Id);
                        if (message.Action != null && Object.hasOwnProperty.call(message, "Action"))
                            writer.uint32(/* id 2, wireType 2 =*/18).string(message.Action);
                        if (message.InfoCardData != null && Object.hasOwnProperty.call(message, "InfoCardData"))
                            $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TInfoCardData.encode(message.InfoCardData, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                        if (message.MusicCardData != null && Object.hasOwnProperty.call(message, "MusicCardData"))
                            $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TMusicCardData.encode(message.MusicCardData, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
                        if (message.NewsCardData != null && Object.hasOwnProperty.call(message, "NewsCardData"))
                            $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TNewsCardData.encode(message.NewsCardData, writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
                        if (message.WeatherCardData != null && Object.hasOwnProperty.call(message, "WeatherCardData"))
                            $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TWeatherCardData.encode(message.WeatherCardData, writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
                        if (message.YouTubeCardData != null && Object.hasOwnProperty.call(message, "YouTubeCardData"))
                            $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TYouTubeCardData.encode(message.YouTubeCardData, writer.uint32(/* id 7, wireType 2 =*/58).fork()).ldelim();
                        if (message.VacantCardData != null && Object.hasOwnProperty.call(message, "VacantCardData"))
                            $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVacantCardData.encode(message.VacantCardData, writer.uint32(/* id 8, wireType 2 =*/66).fork()).ldelim();
                        if (message.LongTapAction != null && Object.hasOwnProperty.call(message, "LongTapAction"))
                            writer.uint32(/* id 9, wireType 2 =*/74).string(message.LongTapAction);
                        if (message.TrafficCardData != null && Object.hasOwnProperty.call(message, "TrafficCardData"))
                            $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData.encode(message.TrafficCardData, writer.uint32(/* id 10, wireType 2 =*/82).fork()).ldelim();
                        if (message.VideoCallCardData != null && Object.hasOwnProperty.call(message, "VideoCallCardData"))
                            $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.encode(message.VideoCallCardData, writer.uint32(/* id 11, wireType 2 =*/90).fork()).ldelim();
                        if (message.ExternalSkillCardData != null && Object.hasOwnProperty.call(message, "ExternalSkillCardData"))
                            $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.encode(message.ExternalSkillCardData, writer.uint32(/* id 12, wireType 2 =*/98).fork()).ldelim();
                        if (message.DeleteWidgetAction != null && Object.hasOwnProperty.call(message, "DeleteWidgetAction"))
                            writer.uint32(/* id 13, wireType 2 =*/106).string(message.DeleteWidgetAction);
                        if (message.TypedAction != null && Object.hasOwnProperty.call(message, "TypedAction"))
                            $root.google.protobuf.Any.encode(message.TypedAction, writer.uint32(/* id 14, wireType 2 =*/114).fork()).ldelim();
                        if (message.LongTapTypedAction != null && Object.hasOwnProperty.call(message, "LongTapTypedAction"))
                            $root.google.protobuf.Any.encode(message.LongTapTypedAction, writer.uint32(/* id 15, wireType 2 =*/122).fork()).ldelim();
                        if (message.DeleteWidgetTypedAction != null && Object.hasOwnProperty.call(message, "DeleteWidgetTypedAction"))
                            $root.google.protobuf.Any.encode(message.DeleteWidgetTypedAction, writer.uint32(/* id 16, wireType 2 =*/130).fork()).ldelim();
                        return writer;
                    };

                    /**
                     * Encodes the specified TCardData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData
                     * @static
                     * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.ITCardData} message TCardData message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    TCardData.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };

                    /**
                     * Decodes a TCardData message from the specified reader or buffer.
                     * @function decode
                     * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData} TCardData
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    TCardData.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 1:
                                message.Id = reader.string();
                                break;
                            case 2:
                                message.Action = reader.string();
                                break;
                            case 3:
                                message.InfoCardData = $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TInfoCardData.decode(reader, reader.uint32());
                                break;
                            case 4:
                                message.MusicCardData = $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TMusicCardData.decode(reader, reader.uint32());
                                break;
                            case 5:
                                message.NewsCardData = $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TNewsCardData.decode(reader, reader.uint32());
                                break;
                            case 6:
                                message.WeatherCardData = $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TWeatherCardData.decode(reader, reader.uint32());
                                break;
                            case 7:
                                message.YouTubeCardData = $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TYouTubeCardData.decode(reader, reader.uint32());
                                break;
                            case 8:
                                message.VacantCardData = $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVacantCardData.decode(reader, reader.uint32());
                                break;
                            case 10:
                                message.TrafficCardData = $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData.decode(reader, reader.uint32());
                                break;
                            case 11:
                                message.VideoCallCardData = $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.decode(reader, reader.uint32());
                                break;
                            case 12:
                                message.ExternalSkillCardData = $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.decode(reader, reader.uint32());
                                break;
                            case 9:
                                message.LongTapAction = reader.string();
                                break;
                            case 13:
                                message.DeleteWidgetAction = reader.string();
                                break;
                            case 14:
                                message.TypedAction = $root.google.protobuf.Any.decode(reader, reader.uint32());
                                break;
                            case 15:
                                message.LongTapTypedAction = $root.google.protobuf.Any.decode(reader, reader.uint32());
                                break;
                            case 16:
                                message.DeleteWidgetTypedAction = $root.google.protobuf.Any.decode(reader, reader.uint32());
                                break;
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };

                    /**
                     * Decodes a TCardData message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData} TCardData
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    TCardData.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };

                    /**
                     * Verifies a TCardData message.
                     * @function verify
                     * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    TCardData.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        var properties = {};
                        if (message.Id != null && message.hasOwnProperty("Id"))
                            if (!$util.isString(message.Id))
                                return "Id: string expected";
                        if (message.Action != null && message.hasOwnProperty("Action"))
                            if (!$util.isString(message.Action))
                                return "Action: string expected";
                        if (message.InfoCardData != null && message.hasOwnProperty("InfoCardData")) {
                            properties.CardData = 1;
                            {
                                var error = $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TInfoCardData.verify(message.InfoCardData);
                                if (error)
                                    return "InfoCardData." + error;
                            }
                        }
                        if (message.MusicCardData != null && message.hasOwnProperty("MusicCardData")) {
                            if (properties.CardData === 1)
                                return "CardData: multiple values";
                            properties.CardData = 1;
                            {
                                var error = $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TMusicCardData.verify(message.MusicCardData);
                                if (error)
                                    return "MusicCardData." + error;
                            }
                        }
                        if (message.NewsCardData != null && message.hasOwnProperty("NewsCardData")) {
                            if (properties.CardData === 1)
                                return "CardData: multiple values";
                            properties.CardData = 1;
                            {
                                var error = $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TNewsCardData.verify(message.NewsCardData);
                                if (error)
                                    return "NewsCardData." + error;
                            }
                        }
                        if (message.WeatherCardData != null && message.hasOwnProperty("WeatherCardData")) {
                            if (properties.CardData === 1)
                                return "CardData: multiple values";
                            properties.CardData = 1;
                            {
                                var error = $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TWeatherCardData.verify(message.WeatherCardData);
                                if (error)
                                    return "WeatherCardData." + error;
                            }
                        }
                        if (message.YouTubeCardData != null && message.hasOwnProperty("YouTubeCardData")) {
                            if (properties.CardData === 1)
                                return "CardData: multiple values";
                            properties.CardData = 1;
                            {
                                var error = $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TYouTubeCardData.verify(message.YouTubeCardData);
                                if (error)
                                    return "YouTubeCardData." + error;
                            }
                        }
                        if (message.VacantCardData != null && message.hasOwnProperty("VacantCardData")) {
                            if (properties.CardData === 1)
                                return "CardData: multiple values";
                            properties.CardData = 1;
                            {
                                var error = $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVacantCardData.verify(message.VacantCardData);
                                if (error)
                                    return "VacantCardData." + error;
                            }
                        }
                        if (message.TrafficCardData != null && message.hasOwnProperty("TrafficCardData")) {
                            if (properties.CardData === 1)
                                return "CardData: multiple values";
                            properties.CardData = 1;
                            {
                                var error = $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData.verify(message.TrafficCardData);
                                if (error)
                                    return "TrafficCardData." + error;
                            }
                        }
                        if (message.VideoCallCardData != null && message.hasOwnProperty("VideoCallCardData")) {
                            if (properties.CardData === 1)
                                return "CardData: multiple values";
                            properties.CardData = 1;
                            {
                                var error = $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.verify(message.VideoCallCardData);
                                if (error)
                                    return "VideoCallCardData." + error;
                            }
                        }
                        if (message.ExternalSkillCardData != null && message.hasOwnProperty("ExternalSkillCardData")) {
                            if (properties.CardData === 1)
                                return "CardData: multiple values";
                            properties.CardData = 1;
                            {
                                var error = $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.verify(message.ExternalSkillCardData);
                                if (error)
                                    return "ExternalSkillCardData." + error;
                            }
                        }
                        if (message.LongTapAction != null && message.hasOwnProperty("LongTapAction"))
                            if (!$util.isString(message.LongTapAction))
                                return "LongTapAction: string expected";
                        if (message.DeleteWidgetAction != null && message.hasOwnProperty("DeleteWidgetAction"))
                            if (!$util.isString(message.DeleteWidgetAction))
                                return "DeleteWidgetAction: string expected";
                        if (message.TypedAction != null && message.hasOwnProperty("TypedAction")) {
                            var error = $root.google.protobuf.Any.verify(message.TypedAction);
                            if (error)
                                return "TypedAction." + error;
                        }
                        if (message.LongTapTypedAction != null && message.hasOwnProperty("LongTapTypedAction")) {
                            var error = $root.google.protobuf.Any.verify(message.LongTapTypedAction);
                            if (error)
                                return "LongTapTypedAction." + error;
                        }
                        if (message.DeleteWidgetTypedAction != null && message.hasOwnProperty("DeleteWidgetTypedAction")) {
                            var error = $root.google.protobuf.Any.verify(message.DeleteWidgetTypedAction);
                            if (error)
                                return "DeleteWidgetTypedAction." + error;
                        }
                        return null;
                    };

                    /**
                     * Creates a TCardData message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData} TCardData
                     */
                    TCardData.fromObject = function fromObject(object) {
                        if (object instanceof $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData)
                            return object;
                        var message = new $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData();
                        if (object.Id != null)
                            message.Id = String(object.Id);
                        if (object.Action != null)
                            message.Action = String(object.Action);
                        if (object.InfoCardData != null) {
                            if (typeof object.InfoCardData !== "object")
                                throw TypeError(".NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.InfoCardData: object expected");
                            message.InfoCardData = $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TInfoCardData.fromObject(object.InfoCardData);
                        }
                        if (object.MusicCardData != null) {
                            if (typeof object.MusicCardData !== "object")
                                throw TypeError(".NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.MusicCardData: object expected");
                            message.MusicCardData = $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TMusicCardData.fromObject(object.MusicCardData);
                        }
                        if (object.NewsCardData != null) {
                            if (typeof object.NewsCardData !== "object")
                                throw TypeError(".NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.NewsCardData: object expected");
                            message.NewsCardData = $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TNewsCardData.fromObject(object.NewsCardData);
                        }
                        if (object.WeatherCardData != null) {
                            if (typeof object.WeatherCardData !== "object")
                                throw TypeError(".NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.WeatherCardData: object expected");
                            message.WeatherCardData = $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TWeatherCardData.fromObject(object.WeatherCardData);
                        }
                        if (object.YouTubeCardData != null) {
                            if (typeof object.YouTubeCardData !== "object")
                                throw TypeError(".NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.YouTubeCardData: object expected");
                            message.YouTubeCardData = $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TYouTubeCardData.fromObject(object.YouTubeCardData);
                        }
                        if (object.VacantCardData != null) {
                            if (typeof object.VacantCardData !== "object")
                                throw TypeError(".NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.VacantCardData: object expected");
                            message.VacantCardData = $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVacantCardData.fromObject(object.VacantCardData);
                        }
                        if (object.TrafficCardData != null) {
                            if (typeof object.TrafficCardData !== "object")
                                throw TypeError(".NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TrafficCardData: object expected");
                            message.TrafficCardData = $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData.fromObject(object.TrafficCardData);
                        }
                        if (object.VideoCallCardData != null) {
                            if (typeof object.VideoCallCardData !== "object")
                                throw TypeError(".NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.VideoCallCardData: object expected");
                            message.VideoCallCardData = $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.fromObject(object.VideoCallCardData);
                        }
                        if (object.ExternalSkillCardData != null) {
                            if (typeof object.ExternalSkillCardData !== "object")
                                throw TypeError(".NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ExternalSkillCardData: object expected");
                            message.ExternalSkillCardData = $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.fromObject(object.ExternalSkillCardData);
                        }
                        if (object.LongTapAction != null)
                            message.LongTapAction = String(object.LongTapAction);
                        if (object.DeleteWidgetAction != null)
                            message.DeleteWidgetAction = String(object.DeleteWidgetAction);
                        if (object.TypedAction != null) {
                            if (typeof object.TypedAction !== "object")
                                throw TypeError(".NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TypedAction: object expected");
                            message.TypedAction = $root.google.protobuf.Any.fromObject(object.TypedAction);
                        }
                        if (object.LongTapTypedAction != null) {
                            if (typeof object.LongTapTypedAction !== "object")
                                throw TypeError(".NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.LongTapTypedAction: object expected");
                            message.LongTapTypedAction = $root.google.protobuf.Any.fromObject(object.LongTapTypedAction);
                        }
                        if (object.DeleteWidgetTypedAction != null) {
                            if (typeof object.DeleteWidgetTypedAction !== "object")
                                throw TypeError(".NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.DeleteWidgetTypedAction: object expected");
                            message.DeleteWidgetTypedAction = $root.google.protobuf.Any.fromObject(object.DeleteWidgetTypedAction);
                        }
                        return message;
                    };

                    /**
                     * Creates a plain object from a TCardData message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData
                     * @static
                     * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData} message TCardData
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    TCardData.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.defaults) {
                            object.Id = "";
                            object.Action = "";
                            object.LongTapAction = "";
                            object.DeleteWidgetAction = "";
                            object.TypedAction = null;
                            object.LongTapTypedAction = null;
                            object.DeleteWidgetTypedAction = null;
                        }
                        if (message.Id != null && message.hasOwnProperty("Id"))
                            object.Id = message.Id;
                        if (message.Action != null && message.hasOwnProperty("Action"))
                            object.Action = message.Action;
                        if (message.InfoCardData != null && message.hasOwnProperty("InfoCardData")) {
                            object.InfoCardData = $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TInfoCardData.toObject(message.InfoCardData, options);
                            if (options.oneofs)
                                object.CardData = "InfoCardData";
                        }
                        if (message.MusicCardData != null && message.hasOwnProperty("MusicCardData")) {
                            object.MusicCardData = $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TMusicCardData.toObject(message.MusicCardData, options);
                            if (options.oneofs)
                                object.CardData = "MusicCardData";
                        }
                        if (message.NewsCardData != null && message.hasOwnProperty("NewsCardData")) {
                            object.NewsCardData = $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TNewsCardData.toObject(message.NewsCardData, options);
                            if (options.oneofs)
                                object.CardData = "NewsCardData";
                        }
                        if (message.WeatherCardData != null && message.hasOwnProperty("WeatherCardData")) {
                            object.WeatherCardData = $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TWeatherCardData.toObject(message.WeatherCardData, options);
                            if (options.oneofs)
                                object.CardData = "WeatherCardData";
                        }
                        if (message.YouTubeCardData != null && message.hasOwnProperty("YouTubeCardData")) {
                            object.YouTubeCardData = $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TYouTubeCardData.toObject(message.YouTubeCardData, options);
                            if (options.oneofs)
                                object.CardData = "YouTubeCardData";
                        }
                        if (message.VacantCardData != null && message.hasOwnProperty("VacantCardData")) {
                            object.VacantCardData = $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVacantCardData.toObject(message.VacantCardData, options);
                            if (options.oneofs)
                                object.CardData = "VacantCardData";
                        }
                        if (message.LongTapAction != null && message.hasOwnProperty("LongTapAction"))
                            object.LongTapAction = message.LongTapAction;
                        if (message.TrafficCardData != null && message.hasOwnProperty("TrafficCardData")) {
                            object.TrafficCardData = $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData.toObject(message.TrafficCardData, options);
                            if (options.oneofs)
                                object.CardData = "TrafficCardData";
                        }
                        if (message.VideoCallCardData != null && message.hasOwnProperty("VideoCallCardData")) {
                            object.VideoCallCardData = $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.toObject(message.VideoCallCardData, options);
                            if (options.oneofs)
                                object.CardData = "VideoCallCardData";
                        }
                        if (message.ExternalSkillCardData != null && message.hasOwnProperty("ExternalSkillCardData")) {
                            object.ExternalSkillCardData = $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.toObject(message.ExternalSkillCardData, options);
                            if (options.oneofs)
                                object.CardData = "ExternalSkillCardData";
                        }
                        if (message.DeleteWidgetAction != null && message.hasOwnProperty("DeleteWidgetAction"))
                            object.DeleteWidgetAction = message.DeleteWidgetAction;
                        if (message.TypedAction != null && message.hasOwnProperty("TypedAction"))
                            object.TypedAction = $root.google.protobuf.Any.toObject(message.TypedAction, options);
                        if (message.LongTapTypedAction != null && message.hasOwnProperty("LongTapTypedAction"))
                            object.LongTapTypedAction = $root.google.protobuf.Any.toObject(message.LongTapTypedAction, options);
                        if (message.DeleteWidgetTypedAction != null && message.hasOwnProperty("DeleteWidgetTypedAction"))
                            object.DeleteWidgetTypedAction = $root.google.protobuf.Any.toObject(message.DeleteWidgetTypedAction, options);
                        return object;
                    };

                    /**
                     * Converts this TCardData to JSON.
                     * @function toJSON
                     * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    TCardData.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };

                    TCardData.TInfoCardData = (function() {

                        /**
                         * Properties of a TInfoCardData.
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData
                         * @interface ITInfoCardData
                         * @property {string|null} [Title] TInfoCardData Title
                         * @property {string|null} [Description] TInfoCardData Description
                         * @property {string|null} [Color] TInfoCardData Color
                         * @property {string|null} [ImageBackground] TInfoCardData ImageBackground
                         * @property {string|null} [Subcomment] TInfoCardData Subcomment
                         * @property {string|null} [Icon] TInfoCardData Icon
                         */

                        /**
                         * Constructs a new TInfoCardData.
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData
                         * @classdesc Represents a TInfoCardData.
                         * @implements ITInfoCardData
                         * @constructor
                         * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITInfoCardData=} [properties] Properties to set
                         */
                        function TInfoCardData(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * TInfoCardData Title.
                         * @member {string} Title
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TInfoCardData
                         * @instance
                         */
                        TInfoCardData.prototype.Title = "";

                        /**
                         * TInfoCardData Description.
                         * @member {string} Description
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TInfoCardData
                         * @instance
                         */
                        TInfoCardData.prototype.Description = "";

                        /**
                         * TInfoCardData Color.
                         * @member {string} Color
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TInfoCardData
                         * @instance
                         */
                        TInfoCardData.prototype.Color = "";

                        /**
                         * TInfoCardData ImageBackground.
                         * @member {string} ImageBackground
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TInfoCardData
                         * @instance
                         */
                        TInfoCardData.prototype.ImageBackground = "";

                        /**
                         * TInfoCardData Subcomment.
                         * @member {string} Subcomment
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TInfoCardData
                         * @instance
                         */
                        TInfoCardData.prototype.Subcomment = "";

                        /**
                         * TInfoCardData Icon.
                         * @member {string} Icon
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TInfoCardData
                         * @instance
                         */
                        TInfoCardData.prototype.Icon = "";

                        /**
                         * Creates a new TInfoCardData instance using the specified properties.
                         * @function create
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TInfoCardData
                         * @static
                         * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITInfoCardData=} [properties] Properties to set
                         * @returns {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TInfoCardData} TInfoCardData instance
                         */
                        TInfoCardData.create = function create(properties) {
                            return new TInfoCardData(properties);
                        };

                        /**
                         * Encodes the specified TInfoCardData message. Does not implicitly {@link NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TInfoCardData.verify|verify} messages.
                         * @function encode
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TInfoCardData
                         * @static
                         * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITInfoCardData} message TInfoCardData message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        TInfoCardData.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.Title != null && Object.hasOwnProperty.call(message, "Title"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.Title);
                            if (message.Description != null && Object.hasOwnProperty.call(message, "Description"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.Description);
                            if (message.Color != null && Object.hasOwnProperty.call(message, "Color"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.Color);
                            if (message.ImageBackground != null && Object.hasOwnProperty.call(message, "ImageBackground"))
                                writer.uint32(/* id 4, wireType 2 =*/34).string(message.ImageBackground);
                            if (message.Subcomment != null && Object.hasOwnProperty.call(message, "Subcomment"))
                                writer.uint32(/* id 5, wireType 2 =*/42).string(message.Subcomment);
                            if (message.Icon != null && Object.hasOwnProperty.call(message, "Icon"))
                                writer.uint32(/* id 6, wireType 2 =*/50).string(message.Icon);
                            return writer;
                        };

                        /**
                         * Encodes the specified TInfoCardData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TInfoCardData.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TInfoCardData
                         * @static
                         * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITInfoCardData} message TInfoCardData message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        TInfoCardData.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a TInfoCardData message from the specified reader or buffer.
                         * @function decode
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TInfoCardData
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TInfoCardData} TInfoCardData
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        TInfoCardData.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TInfoCardData();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.Title = reader.string();
                                    break;
                                case 2:
                                    message.Description = reader.string();
                                    break;
                                case 3:
                                    message.Color = reader.string();
                                    break;
                                case 4:
                                    message.ImageBackground = reader.string();
                                    break;
                                case 5:
                                    message.Subcomment = reader.string();
                                    break;
                                case 6:
                                    message.Icon = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a TInfoCardData message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TInfoCardData
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TInfoCardData} TInfoCardData
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        TInfoCardData.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a TInfoCardData message.
                         * @function verify
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TInfoCardData
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        TInfoCardData.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.Title != null && message.hasOwnProperty("Title"))
                                if (!$util.isString(message.Title))
                                    return "Title: string expected";
                            if (message.Description != null && message.hasOwnProperty("Description"))
                                if (!$util.isString(message.Description))
                                    return "Description: string expected";
                            if (message.Color != null && message.hasOwnProperty("Color"))
                                if (!$util.isString(message.Color))
                                    return "Color: string expected";
                            if (message.ImageBackground != null && message.hasOwnProperty("ImageBackground"))
                                if (!$util.isString(message.ImageBackground))
                                    return "ImageBackground: string expected";
                            if (message.Subcomment != null && message.hasOwnProperty("Subcomment"))
                                if (!$util.isString(message.Subcomment))
                                    return "Subcomment: string expected";
                            if (message.Icon != null && message.hasOwnProperty("Icon"))
                                if (!$util.isString(message.Icon))
                                    return "Icon: string expected";
                            return null;
                        };

                        /**
                         * Creates a TInfoCardData message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TInfoCardData
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TInfoCardData} TInfoCardData
                         */
                        TInfoCardData.fromObject = function fromObject(object) {
                            if (object instanceof $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TInfoCardData)
                                return object;
                            var message = new $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TInfoCardData();
                            if (object.Title != null)
                                message.Title = String(object.Title);
                            if (object.Description != null)
                                message.Description = String(object.Description);
                            if (object.Color != null)
                                message.Color = String(object.Color);
                            if (object.ImageBackground != null)
                                message.ImageBackground = String(object.ImageBackground);
                            if (object.Subcomment != null)
                                message.Subcomment = String(object.Subcomment);
                            if (object.Icon != null)
                                message.Icon = String(object.Icon);
                            return message;
                        };

                        /**
                         * Creates a plain object from a TInfoCardData message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TInfoCardData
                         * @static
                         * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TInfoCardData} message TInfoCardData
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        TInfoCardData.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.Title = "";
                                object.Description = "";
                                object.Color = "";
                                object.ImageBackground = "";
                                object.Subcomment = "";
                                object.Icon = "";
                            }
                            if (message.Title != null && message.hasOwnProperty("Title"))
                                object.Title = message.Title;
                            if (message.Description != null && message.hasOwnProperty("Description"))
                                object.Description = message.Description;
                            if (message.Color != null && message.hasOwnProperty("Color"))
                                object.Color = message.Color;
                            if (message.ImageBackground != null && message.hasOwnProperty("ImageBackground"))
                                object.ImageBackground = message.ImageBackground;
                            if (message.Subcomment != null && message.hasOwnProperty("Subcomment"))
                                object.Subcomment = message.Subcomment;
                            if (message.Icon != null && message.hasOwnProperty("Icon"))
                                object.Icon = message.Icon;
                            return object;
                        };

                        /**
                         * Converts this TInfoCardData to JSON.
                         * @function toJSON
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TInfoCardData
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        TInfoCardData.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return TInfoCardData;
                    })();

                    TCardData.TMusicCardData = (function() {

                        /**
                         * Properties of a TMusicCardData.
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData
                         * @interface ITMusicCardData
                         * @property {string|null} [Name] TMusicCardData Name
                         * @property {string|null} [Color] TMusicCardData Color
                         * @property {string|null} [Cover] TMusicCardData Cover
                         * @property {google.protobuf.IStringValue|null} [Modified] TMusicCardData Modified
                         */

                        /**
                         * Constructs a new TMusicCardData.
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData
                         * @classdesc Represents a TMusicCardData.
                         * @implements ITMusicCardData
                         * @constructor
                         * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITMusicCardData=} [properties] Properties to set
                         */
                        function TMusicCardData(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * TMusicCardData Name.
                         * @member {string} Name
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TMusicCardData
                         * @instance
                         */
                        TMusicCardData.prototype.Name = "";

                        /**
                         * TMusicCardData Color.
                         * @member {string} Color
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TMusicCardData
                         * @instance
                         */
                        TMusicCardData.prototype.Color = "";

                        /**
                         * TMusicCardData Cover.
                         * @member {string} Cover
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TMusicCardData
                         * @instance
                         */
                        TMusicCardData.prototype.Cover = "";

                        /**
                         * TMusicCardData Modified.
                         * @member {google.protobuf.IStringValue|null|undefined} Modified
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TMusicCardData
                         * @instance
                         */
                        TMusicCardData.prototype.Modified = null;

                        /**
                         * Creates a new TMusicCardData instance using the specified properties.
                         * @function create
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TMusicCardData
                         * @static
                         * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITMusicCardData=} [properties] Properties to set
                         * @returns {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TMusicCardData} TMusicCardData instance
                         */
                        TMusicCardData.create = function create(properties) {
                            return new TMusicCardData(properties);
                        };

                        /**
                         * Encodes the specified TMusicCardData message. Does not implicitly {@link NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TMusicCardData.verify|verify} messages.
                         * @function encode
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TMusicCardData
                         * @static
                         * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITMusicCardData} message TMusicCardData message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        TMusicCardData.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.Name != null && Object.hasOwnProperty.call(message, "Name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.Name);
                            if (message.Color != null && Object.hasOwnProperty.call(message, "Color"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.Color);
                            if (message.Cover != null && Object.hasOwnProperty.call(message, "Cover"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.Cover);
                            if (message.Modified != null && Object.hasOwnProperty.call(message, "Modified"))
                                $root.google.protobuf.StringValue.encode(message.Modified, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
                            return writer;
                        };

                        /**
                         * Encodes the specified TMusicCardData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TMusicCardData.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TMusicCardData
                         * @static
                         * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITMusicCardData} message TMusicCardData message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        TMusicCardData.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a TMusicCardData message from the specified reader or buffer.
                         * @function decode
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TMusicCardData
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TMusicCardData} TMusicCardData
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        TMusicCardData.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TMusicCardData();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.Name = reader.string();
                                    break;
                                case 2:
                                    message.Color = reader.string();
                                    break;
                                case 3:
                                    message.Cover = reader.string();
                                    break;
                                case 4:
                                    message.Modified = $root.google.protobuf.StringValue.decode(reader, reader.uint32());
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a TMusicCardData message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TMusicCardData
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TMusicCardData} TMusicCardData
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        TMusicCardData.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a TMusicCardData message.
                         * @function verify
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TMusicCardData
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        TMusicCardData.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.Name != null && message.hasOwnProperty("Name"))
                                if (!$util.isString(message.Name))
                                    return "Name: string expected";
                            if (message.Color != null && message.hasOwnProperty("Color"))
                                if (!$util.isString(message.Color))
                                    return "Color: string expected";
                            if (message.Cover != null && message.hasOwnProperty("Cover"))
                                if (!$util.isString(message.Cover))
                                    return "Cover: string expected";
                            if (message.Modified != null && message.hasOwnProperty("Modified")) {
                                var error = $root.google.protobuf.StringValue.verify(message.Modified);
                                if (error)
                                    return "Modified." + error;
                            }
                            return null;
                        };

                        /**
                         * Creates a TMusicCardData message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TMusicCardData
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TMusicCardData} TMusicCardData
                         */
                        TMusicCardData.fromObject = function fromObject(object) {
                            if (object instanceof $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TMusicCardData)
                                return object;
                            var message = new $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TMusicCardData();
                            if (object.Name != null)
                                message.Name = String(object.Name);
                            if (object.Color != null)
                                message.Color = String(object.Color);
                            if (object.Cover != null)
                                message.Cover = String(object.Cover);
                            if (object.Modified != null) {
                                if (typeof object.Modified !== "object")
                                    throw TypeError(".NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TMusicCardData.Modified: object expected");
                                message.Modified = $root.google.protobuf.StringValue.fromObject(object.Modified);
                            }
                            return message;
                        };

                        /**
                         * Creates a plain object from a TMusicCardData message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TMusicCardData
                         * @static
                         * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TMusicCardData} message TMusicCardData
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        TMusicCardData.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.Name = "";
                                object.Color = "";
                                object.Cover = "";
                                object.Modified = null;
                            }
                            if (message.Name != null && message.hasOwnProperty("Name"))
                                object.Name = message.Name;
                            if (message.Color != null && message.hasOwnProperty("Color"))
                                object.Color = message.Color;
                            if (message.Cover != null && message.hasOwnProperty("Cover"))
                                object.Cover = message.Cover;
                            if (message.Modified != null && message.hasOwnProperty("Modified"))
                                object.Modified = $root.google.protobuf.StringValue.toObject(message.Modified, options);
                            return object;
                        };

                        /**
                         * Converts this TMusicCardData to JSON.
                         * @function toJSON
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TMusicCardData
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        TMusicCardData.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return TMusicCardData;
                    })();

                    TCardData.TNewsCardData = (function() {

                        /**
                         * Properties of a TNewsCardData.
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData
                         * @interface ITNewsCardData
                         * @property {string|null} [Title] TNewsCardData Title
                         * @property {string|null} [Content] TNewsCardData Content
                         * @property {string|null} [ImageUrl] TNewsCardData ImageUrl
                         * @property {string|null} [Topic] TNewsCardData Topic
                         */

                        /**
                         * Constructs a new TNewsCardData.
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData
                         * @classdesc Represents a TNewsCardData.
                         * @implements ITNewsCardData
                         * @constructor
                         * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITNewsCardData=} [properties] Properties to set
                         */
                        function TNewsCardData(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * TNewsCardData Title.
                         * @member {string} Title
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TNewsCardData
                         * @instance
                         */
                        TNewsCardData.prototype.Title = "";

                        /**
                         * TNewsCardData Content.
                         * @member {string} Content
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TNewsCardData
                         * @instance
                         */
                        TNewsCardData.prototype.Content = "";

                        /**
                         * TNewsCardData ImageUrl.
                         * @member {string} ImageUrl
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TNewsCardData
                         * @instance
                         */
                        TNewsCardData.prototype.ImageUrl = "";

                        /**
                         * TNewsCardData Topic.
                         * @member {string} Topic
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TNewsCardData
                         * @instance
                         */
                        TNewsCardData.prototype.Topic = "";

                        /**
                         * Creates a new TNewsCardData instance using the specified properties.
                         * @function create
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TNewsCardData
                         * @static
                         * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITNewsCardData=} [properties] Properties to set
                         * @returns {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TNewsCardData} TNewsCardData instance
                         */
                        TNewsCardData.create = function create(properties) {
                            return new TNewsCardData(properties);
                        };

                        /**
                         * Encodes the specified TNewsCardData message. Does not implicitly {@link NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TNewsCardData.verify|verify} messages.
                         * @function encode
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TNewsCardData
                         * @static
                         * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITNewsCardData} message TNewsCardData message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        TNewsCardData.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.Title != null && Object.hasOwnProperty.call(message, "Title"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.Title);
                            if (message.Content != null && Object.hasOwnProperty.call(message, "Content"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.Content);
                            if (message.ImageUrl != null && Object.hasOwnProperty.call(message, "ImageUrl"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.ImageUrl);
                            if (message.Topic != null && Object.hasOwnProperty.call(message, "Topic"))
                                writer.uint32(/* id 4, wireType 2 =*/34).string(message.Topic);
                            return writer;
                        };

                        /**
                         * Encodes the specified TNewsCardData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TNewsCardData.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TNewsCardData
                         * @static
                         * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITNewsCardData} message TNewsCardData message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        TNewsCardData.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a TNewsCardData message from the specified reader or buffer.
                         * @function decode
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TNewsCardData
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TNewsCardData} TNewsCardData
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        TNewsCardData.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TNewsCardData();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.Title = reader.string();
                                    break;
                                case 2:
                                    message.Content = reader.string();
                                    break;
                                case 3:
                                    message.ImageUrl = reader.string();
                                    break;
                                case 4:
                                    message.Topic = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a TNewsCardData message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TNewsCardData
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TNewsCardData} TNewsCardData
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        TNewsCardData.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a TNewsCardData message.
                         * @function verify
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TNewsCardData
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        TNewsCardData.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.Title != null && message.hasOwnProperty("Title"))
                                if (!$util.isString(message.Title))
                                    return "Title: string expected";
                            if (message.Content != null && message.hasOwnProperty("Content"))
                                if (!$util.isString(message.Content))
                                    return "Content: string expected";
                            if (message.ImageUrl != null && message.hasOwnProperty("ImageUrl"))
                                if (!$util.isString(message.ImageUrl))
                                    return "ImageUrl: string expected";
                            if (message.Topic != null && message.hasOwnProperty("Topic"))
                                if (!$util.isString(message.Topic))
                                    return "Topic: string expected";
                            return null;
                        };

                        /**
                         * Creates a TNewsCardData message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TNewsCardData
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TNewsCardData} TNewsCardData
                         */
                        TNewsCardData.fromObject = function fromObject(object) {
                            if (object instanceof $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TNewsCardData)
                                return object;
                            var message = new $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TNewsCardData();
                            if (object.Title != null)
                                message.Title = String(object.Title);
                            if (object.Content != null)
                                message.Content = String(object.Content);
                            if (object.ImageUrl != null)
                                message.ImageUrl = String(object.ImageUrl);
                            if (object.Topic != null)
                                message.Topic = String(object.Topic);
                            return message;
                        };

                        /**
                         * Creates a plain object from a TNewsCardData message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TNewsCardData
                         * @static
                         * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TNewsCardData} message TNewsCardData
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        TNewsCardData.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.Title = "";
                                object.Content = "";
                                object.ImageUrl = "";
                                object.Topic = "";
                            }
                            if (message.Title != null && message.hasOwnProperty("Title"))
                                object.Title = message.Title;
                            if (message.Content != null && message.hasOwnProperty("Content"))
                                object.Content = message.Content;
                            if (message.ImageUrl != null && message.hasOwnProperty("ImageUrl"))
                                object.ImageUrl = message.ImageUrl;
                            if (message.Topic != null && message.hasOwnProperty("Topic"))
                                object.Topic = message.Topic;
                            return object;
                        };

                        /**
                         * Converts this TNewsCardData to JSON.
                         * @function toJSON
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TNewsCardData
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        TNewsCardData.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return TNewsCardData;
                    })();

                    TCardData.TWeatherCardData = (function() {

                        /**
                         * Properties of a TWeatherCardData.
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData
                         * @interface ITWeatherCardData
                         * @property {string|null} [City] TWeatherCardData City
                         * @property {number|null} [Temperature] TWeatherCardData Temperature
                         * @property {string|null} [Image] TWeatherCardData Image
                         * @property {string|null} [Comment] TWeatherCardData Comment
                         * @property {string|null} [Sunrise] TWeatherCardData Sunrise
                         * @property {string|null} [Sunset] TWeatherCardData Sunset
                         * @property {string|null} [UserTime] TWeatherCardData UserTime
                         * @property {NAlice.NData.ITWeatherCondition|null} [Condition] TWeatherCardData Condition
                         */

                        /**
                         * Constructs a new TWeatherCardData.
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData
                         * @classdesc Represents a TWeatherCardData.
                         * @implements ITWeatherCardData
                         * @constructor
                         * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITWeatherCardData=} [properties] Properties to set
                         */
                        function TWeatherCardData(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * TWeatherCardData City.
                         * @member {string} City
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TWeatherCardData
                         * @instance
                         */
                        TWeatherCardData.prototype.City = "";

                        /**
                         * TWeatherCardData Temperature.
                         * @member {number} Temperature
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TWeatherCardData
                         * @instance
                         */
                        TWeatherCardData.prototype.Temperature = 0;

                        /**
                         * TWeatherCardData Image.
                         * @member {string} Image
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TWeatherCardData
                         * @instance
                         */
                        TWeatherCardData.prototype.Image = "";

                        /**
                         * TWeatherCardData Comment.
                         * @member {string} Comment
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TWeatherCardData
                         * @instance
                         */
                        TWeatherCardData.prototype.Comment = "";

                        /**
                         * TWeatherCardData Sunrise.
                         * @member {string} Sunrise
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TWeatherCardData
                         * @instance
                         */
                        TWeatherCardData.prototype.Sunrise = "";

                        /**
                         * TWeatherCardData Sunset.
                         * @member {string} Sunset
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TWeatherCardData
                         * @instance
                         */
                        TWeatherCardData.prototype.Sunset = "";

                        /**
                         * TWeatherCardData UserTime.
                         * @member {string} UserTime
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TWeatherCardData
                         * @instance
                         */
                        TWeatherCardData.prototype.UserTime = "";

                        /**
                         * TWeatherCardData Condition.
                         * @member {NAlice.NData.ITWeatherCondition|null|undefined} Condition
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TWeatherCardData
                         * @instance
                         */
                        TWeatherCardData.prototype.Condition = null;

                        /**
                         * Creates a new TWeatherCardData instance using the specified properties.
                         * @function create
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TWeatherCardData
                         * @static
                         * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITWeatherCardData=} [properties] Properties to set
                         * @returns {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TWeatherCardData} TWeatherCardData instance
                         */
                        TWeatherCardData.create = function create(properties) {
                            return new TWeatherCardData(properties);
                        };

                        /**
                         * Encodes the specified TWeatherCardData message. Does not implicitly {@link NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TWeatherCardData.verify|verify} messages.
                         * @function encode
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TWeatherCardData
                         * @static
                         * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITWeatherCardData} message TWeatherCardData message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        TWeatherCardData.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.City != null && Object.hasOwnProperty.call(message, "City"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.City);
                            if (message.Temperature != null && Object.hasOwnProperty.call(message, "Temperature"))
                                writer.uint32(/* id 2, wireType 0 =*/16).int32(message.Temperature);
                            if (message.Image != null && Object.hasOwnProperty.call(message, "Image"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.Image);
                            if (message.Comment != null && Object.hasOwnProperty.call(message, "Comment"))
                                writer.uint32(/* id 4, wireType 2 =*/34).string(message.Comment);
                            if (message.Sunrise != null && Object.hasOwnProperty.call(message, "Sunrise"))
                                writer.uint32(/* id 5, wireType 2 =*/42).string(message.Sunrise);
                            if (message.Sunset != null && Object.hasOwnProperty.call(message, "Sunset"))
                                writer.uint32(/* id 6, wireType 2 =*/50).string(message.Sunset);
                            if (message.UserTime != null && Object.hasOwnProperty.call(message, "UserTime"))
                                writer.uint32(/* id 7, wireType 2 =*/58).string(message.UserTime);
                            if (message.Condition != null && Object.hasOwnProperty.call(message, "Condition"))
                                $root.NAlice.NData.TWeatherCondition.encode(message.Condition, writer.uint32(/* id 8, wireType 2 =*/66).fork()).ldelim();
                            return writer;
                        };

                        /**
                         * Encodes the specified TWeatherCardData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TWeatherCardData.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TWeatherCardData
                         * @static
                         * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITWeatherCardData} message TWeatherCardData message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        TWeatherCardData.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a TWeatherCardData message from the specified reader or buffer.
                         * @function decode
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TWeatherCardData
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TWeatherCardData} TWeatherCardData
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        TWeatherCardData.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TWeatherCardData();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.City = reader.string();
                                    break;
                                case 2:
                                    message.Temperature = reader.int32();
                                    break;
                                case 3:
                                    message.Image = reader.string();
                                    break;
                                case 4:
                                    message.Comment = reader.string();
                                    break;
                                case 5:
                                    message.Sunrise = reader.string();
                                    break;
                                case 6:
                                    message.Sunset = reader.string();
                                    break;
                                case 7:
                                    message.UserTime = reader.string();
                                    break;
                                case 8:
                                    message.Condition = $root.NAlice.NData.TWeatherCondition.decode(reader, reader.uint32());
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a TWeatherCardData message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TWeatherCardData
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TWeatherCardData} TWeatherCardData
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        TWeatherCardData.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a TWeatherCardData message.
                         * @function verify
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TWeatherCardData
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        TWeatherCardData.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.City != null && message.hasOwnProperty("City"))
                                if (!$util.isString(message.City))
                                    return "City: string expected";
                            if (message.Temperature != null && message.hasOwnProperty("Temperature"))
                                if (!$util.isInteger(message.Temperature))
                                    return "Temperature: integer expected";
                            if (message.Image != null && message.hasOwnProperty("Image"))
                                if (!$util.isString(message.Image))
                                    return "Image: string expected";
                            if (message.Comment != null && message.hasOwnProperty("Comment"))
                                if (!$util.isString(message.Comment))
                                    return "Comment: string expected";
                            if (message.Sunrise != null && message.hasOwnProperty("Sunrise"))
                                if (!$util.isString(message.Sunrise))
                                    return "Sunrise: string expected";
                            if (message.Sunset != null && message.hasOwnProperty("Sunset"))
                                if (!$util.isString(message.Sunset))
                                    return "Sunset: string expected";
                            if (message.UserTime != null && message.hasOwnProperty("UserTime"))
                                if (!$util.isString(message.UserTime))
                                    return "UserTime: string expected";
                            if (message.Condition != null && message.hasOwnProperty("Condition")) {
                                var error = $root.NAlice.NData.TWeatherCondition.verify(message.Condition);
                                if (error)
                                    return "Condition." + error;
                            }
                            return null;
                        };

                        /**
                         * Creates a TWeatherCardData message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TWeatherCardData
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TWeatherCardData} TWeatherCardData
                         */
                        TWeatherCardData.fromObject = function fromObject(object) {
                            if (object instanceof $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TWeatherCardData)
                                return object;
                            var message = new $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TWeatherCardData();
                            if (object.City != null)
                                message.City = String(object.City);
                            if (object.Temperature != null)
                                message.Temperature = object.Temperature | 0;
                            if (object.Image != null)
                                message.Image = String(object.Image);
                            if (object.Comment != null)
                                message.Comment = String(object.Comment);
                            if (object.Sunrise != null)
                                message.Sunrise = String(object.Sunrise);
                            if (object.Sunset != null)
                                message.Sunset = String(object.Sunset);
                            if (object.UserTime != null)
                                message.UserTime = String(object.UserTime);
                            if (object.Condition != null) {
                                if (typeof object.Condition !== "object")
                                    throw TypeError(".NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TWeatherCardData.Condition: object expected");
                                message.Condition = $root.NAlice.NData.TWeatherCondition.fromObject(object.Condition);
                            }
                            return message;
                        };

                        /**
                         * Creates a plain object from a TWeatherCardData message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TWeatherCardData
                         * @static
                         * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TWeatherCardData} message TWeatherCardData
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        TWeatherCardData.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.City = "";
                                object.Temperature = 0;
                                object.Image = "";
                                object.Comment = "";
                                object.Sunrise = "";
                                object.Sunset = "";
                                object.UserTime = "";
                                object.Condition = null;
                            }
                            if (message.City != null && message.hasOwnProperty("City"))
                                object.City = message.City;
                            if (message.Temperature != null && message.hasOwnProperty("Temperature"))
                                object.Temperature = message.Temperature;
                            if (message.Image != null && message.hasOwnProperty("Image"))
                                object.Image = message.Image;
                            if (message.Comment != null && message.hasOwnProperty("Comment"))
                                object.Comment = message.Comment;
                            if (message.Sunrise != null && message.hasOwnProperty("Sunrise"))
                                object.Sunrise = message.Sunrise;
                            if (message.Sunset != null && message.hasOwnProperty("Sunset"))
                                object.Sunset = message.Sunset;
                            if (message.UserTime != null && message.hasOwnProperty("UserTime"))
                                object.UserTime = message.UserTime;
                            if (message.Condition != null && message.hasOwnProperty("Condition"))
                                object.Condition = $root.NAlice.NData.TWeatherCondition.toObject(message.Condition, options);
                            return object;
                        };

                        /**
                         * Converts this TWeatherCardData to JSON.
                         * @function toJSON
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TWeatherCardData
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        TWeatherCardData.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return TWeatherCardData;
                    })();

                    TCardData.TYouTubeCardData = (function() {

                        /**
                         * Properties of a TYouTubeCardData.
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData
                         * @interface ITYouTubeCardData
                         */

                        /**
                         * Constructs a new TYouTubeCardData.
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData
                         * @classdesc Represents a TYouTubeCardData.
                         * @implements ITYouTubeCardData
                         * @constructor
                         * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITYouTubeCardData=} [properties] Properties to set
                         */
                        function TYouTubeCardData(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * Creates a new TYouTubeCardData instance using the specified properties.
                         * @function create
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TYouTubeCardData
                         * @static
                         * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITYouTubeCardData=} [properties] Properties to set
                         * @returns {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TYouTubeCardData} TYouTubeCardData instance
                         */
                        TYouTubeCardData.create = function create(properties) {
                            return new TYouTubeCardData(properties);
                        };

                        /**
                         * Encodes the specified TYouTubeCardData message. Does not implicitly {@link NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TYouTubeCardData.verify|verify} messages.
                         * @function encode
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TYouTubeCardData
                         * @static
                         * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITYouTubeCardData} message TYouTubeCardData message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        TYouTubeCardData.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            return writer;
                        };

                        /**
                         * Encodes the specified TYouTubeCardData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TYouTubeCardData.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TYouTubeCardData
                         * @static
                         * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITYouTubeCardData} message TYouTubeCardData message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        TYouTubeCardData.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a TYouTubeCardData message from the specified reader or buffer.
                         * @function decode
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TYouTubeCardData
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TYouTubeCardData} TYouTubeCardData
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        TYouTubeCardData.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TYouTubeCardData();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a TYouTubeCardData message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TYouTubeCardData
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TYouTubeCardData} TYouTubeCardData
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        TYouTubeCardData.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a TYouTubeCardData message.
                         * @function verify
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TYouTubeCardData
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        TYouTubeCardData.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            return null;
                        };

                        /**
                         * Creates a TYouTubeCardData message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TYouTubeCardData
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TYouTubeCardData} TYouTubeCardData
                         */
                        TYouTubeCardData.fromObject = function fromObject(object) {
                            if (object instanceof $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TYouTubeCardData)
                                return object;
                            return new $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TYouTubeCardData();
                        };

                        /**
                         * Creates a plain object from a TYouTubeCardData message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TYouTubeCardData
                         * @static
                         * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TYouTubeCardData} message TYouTubeCardData
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        TYouTubeCardData.toObject = function toObject() {
                            return {};
                        };

                        /**
                         * Converts this TYouTubeCardData to JSON.
                         * @function toJSON
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TYouTubeCardData
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        TYouTubeCardData.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return TYouTubeCardData;
                    })();

                    TCardData.TVacantCardData = (function() {

                        /**
                         * Properties of a TVacantCardData.
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData
                         * @interface ITVacantCardData
                         */

                        /**
                         * Constructs a new TVacantCardData.
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData
                         * @classdesc Represents a TVacantCardData.
                         * @implements ITVacantCardData
                         * @constructor
                         * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITVacantCardData=} [properties] Properties to set
                         */
                        function TVacantCardData(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * Creates a new TVacantCardData instance using the specified properties.
                         * @function create
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVacantCardData
                         * @static
                         * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITVacantCardData=} [properties] Properties to set
                         * @returns {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVacantCardData} TVacantCardData instance
                         */
                        TVacantCardData.create = function create(properties) {
                            return new TVacantCardData(properties);
                        };

                        /**
                         * Encodes the specified TVacantCardData message. Does not implicitly {@link NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVacantCardData.verify|verify} messages.
                         * @function encode
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVacantCardData
                         * @static
                         * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITVacantCardData} message TVacantCardData message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        TVacantCardData.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            return writer;
                        };

                        /**
                         * Encodes the specified TVacantCardData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVacantCardData.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVacantCardData
                         * @static
                         * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITVacantCardData} message TVacantCardData message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        TVacantCardData.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a TVacantCardData message from the specified reader or buffer.
                         * @function decode
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVacantCardData
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVacantCardData} TVacantCardData
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        TVacantCardData.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVacantCardData();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a TVacantCardData message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVacantCardData
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVacantCardData} TVacantCardData
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        TVacantCardData.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a TVacantCardData message.
                         * @function verify
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVacantCardData
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        TVacantCardData.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            return null;
                        };

                        /**
                         * Creates a TVacantCardData message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVacantCardData
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVacantCardData} TVacantCardData
                         */
                        TVacantCardData.fromObject = function fromObject(object) {
                            if (object instanceof $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVacantCardData)
                                return object;
                            return new $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVacantCardData();
                        };

                        /**
                         * Creates a plain object from a TVacantCardData message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVacantCardData
                         * @static
                         * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVacantCardData} message TVacantCardData
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        TVacantCardData.toObject = function toObject() {
                            return {};
                        };

                        /**
                         * Converts this TVacantCardData to JSON.
                         * @function toJSON
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVacantCardData
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        TVacantCardData.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return TVacantCardData;
                    })();

                    TCardData.TTrafficCardData = (function() {

                        /**
                         * Properties of a TTrafficCardData.
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData
                         * @interface ITTrafficCardData
                         * @property {string|null} [City] TTrafficCardData City
                         * @property {string|null} [Message] TTrafficCardData Message
                         * @property {string|null} [MapUrl] TTrafficCardData MapUrl
                         * @property {string|null} [ImageUrl] TTrafficCardData ImageUrl
                         * @property {string|null} [Level] TTrafficCardData Level
                         * @property {number|null} [Score] TTrafficCardData Score
                         * @property {Array.<NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData.ITTrafficForecastData>|null} [Forecast] TTrafficCardData Forecast
                         */

                        /**
                         * Constructs a new TTrafficCardData.
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData
                         * @classdesc Represents a TTrafficCardData.
                         * @implements ITTrafficCardData
                         * @constructor
                         * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITTrafficCardData=} [properties] Properties to set
                         */
                        function TTrafficCardData(properties) {
                            this.Forecast = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * TTrafficCardData City.
                         * @member {string} City
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData
                         * @instance
                         */
                        TTrafficCardData.prototype.City = "";

                        /**
                         * TTrafficCardData Message.
                         * @member {string} Message
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData
                         * @instance
                         */
                        TTrafficCardData.prototype.Message = "";

                        /**
                         * TTrafficCardData MapUrl.
                         * @member {string} MapUrl
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData
                         * @instance
                         */
                        TTrafficCardData.prototype.MapUrl = "";

                        /**
                         * TTrafficCardData ImageUrl.
                         * @member {string} ImageUrl
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData
                         * @instance
                         */
                        TTrafficCardData.prototype.ImageUrl = "";

                        /**
                         * TTrafficCardData Level.
                         * @member {string} Level
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData
                         * @instance
                         */
                        TTrafficCardData.prototype.Level = "";

                        /**
                         * TTrafficCardData Score.
                         * @member {number} Score
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData
                         * @instance
                         */
                        TTrafficCardData.prototype.Score = 0;

                        /**
                         * TTrafficCardData Forecast.
                         * @member {Array.<NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData.ITTrafficForecastData>} Forecast
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData
                         * @instance
                         */
                        TTrafficCardData.prototype.Forecast = $util.emptyArray;

                        /**
                         * Creates a new TTrafficCardData instance using the specified properties.
                         * @function create
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData
                         * @static
                         * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITTrafficCardData=} [properties] Properties to set
                         * @returns {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData} TTrafficCardData instance
                         */
                        TTrafficCardData.create = function create(properties) {
                            return new TTrafficCardData(properties);
                        };

                        /**
                         * Encodes the specified TTrafficCardData message. Does not implicitly {@link NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData.verify|verify} messages.
                         * @function encode
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData
                         * @static
                         * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITTrafficCardData} message TTrafficCardData message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        TTrafficCardData.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.City != null && Object.hasOwnProperty.call(message, "City"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.City);
                            if (message.Message != null && Object.hasOwnProperty.call(message, "Message"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.Message);
                            if (message.MapUrl != null && Object.hasOwnProperty.call(message, "MapUrl"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.MapUrl);
                            if (message.ImageUrl != null && Object.hasOwnProperty.call(message, "ImageUrl"))
                                writer.uint32(/* id 4, wireType 2 =*/34).string(message.ImageUrl);
                            if (message.Level != null && Object.hasOwnProperty.call(message, "Level"))
                                writer.uint32(/* id 5, wireType 2 =*/42).string(message.Level);
                            if (message.Score != null && Object.hasOwnProperty.call(message, "Score"))
                                writer.uint32(/* id 6, wireType 0 =*/48).int32(message.Score);
                            if (message.Forecast != null && message.Forecast.length)
                                for (var i = 0; i < message.Forecast.length; ++i)
                                    $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData.TTrafficForecastData.encode(message.Forecast[i], writer.uint32(/* id 7, wireType 2 =*/58).fork()).ldelim();
                            return writer;
                        };

                        /**
                         * Encodes the specified TTrafficCardData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData
                         * @static
                         * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITTrafficCardData} message TTrafficCardData message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        TTrafficCardData.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a TTrafficCardData message from the specified reader or buffer.
                         * @function decode
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData} TTrafficCardData
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        TTrafficCardData.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.City = reader.string();
                                    break;
                                case 2:
                                    message.Message = reader.string();
                                    break;
                                case 3:
                                    message.MapUrl = reader.string();
                                    break;
                                case 4:
                                    message.ImageUrl = reader.string();
                                    break;
                                case 5:
                                    message.Level = reader.string();
                                    break;
                                case 6:
                                    message.Score = reader.int32();
                                    break;
                                case 7:
                                    if (!(message.Forecast && message.Forecast.length))
                                        message.Forecast = [];
                                    message.Forecast.push($root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData.TTrafficForecastData.decode(reader, reader.uint32()));
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a TTrafficCardData message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData} TTrafficCardData
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        TTrafficCardData.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a TTrafficCardData message.
                         * @function verify
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        TTrafficCardData.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.City != null && message.hasOwnProperty("City"))
                                if (!$util.isString(message.City))
                                    return "City: string expected";
                            if (message.Message != null && message.hasOwnProperty("Message"))
                                if (!$util.isString(message.Message))
                                    return "Message: string expected";
                            if (message.MapUrl != null && message.hasOwnProperty("MapUrl"))
                                if (!$util.isString(message.MapUrl))
                                    return "MapUrl: string expected";
                            if (message.ImageUrl != null && message.hasOwnProperty("ImageUrl"))
                                if (!$util.isString(message.ImageUrl))
                                    return "ImageUrl: string expected";
                            if (message.Level != null && message.hasOwnProperty("Level"))
                                if (!$util.isString(message.Level))
                                    return "Level: string expected";
                            if (message.Score != null && message.hasOwnProperty("Score"))
                                if (!$util.isInteger(message.Score))
                                    return "Score: integer expected";
                            if (message.Forecast != null && message.hasOwnProperty("Forecast")) {
                                if (!Array.isArray(message.Forecast))
                                    return "Forecast: array expected";
                                for (var i = 0; i < message.Forecast.length; ++i) {
                                    var error = $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData.TTrafficForecastData.verify(message.Forecast[i]);
                                    if (error)
                                        return "Forecast." + error;
                                }
                            }
                            return null;
                        };

                        /**
                         * Creates a TTrafficCardData message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData} TTrafficCardData
                         */
                        TTrafficCardData.fromObject = function fromObject(object) {
                            if (object instanceof $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData)
                                return object;
                            var message = new $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData();
                            if (object.City != null)
                                message.City = String(object.City);
                            if (object.Message != null)
                                message.Message = String(object.Message);
                            if (object.MapUrl != null)
                                message.MapUrl = String(object.MapUrl);
                            if (object.ImageUrl != null)
                                message.ImageUrl = String(object.ImageUrl);
                            if (object.Level != null)
                                message.Level = String(object.Level);
                            if (object.Score != null)
                                message.Score = object.Score | 0;
                            if (object.Forecast) {
                                if (!Array.isArray(object.Forecast))
                                    throw TypeError(".NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData.Forecast: array expected");
                                message.Forecast = [];
                                for (var i = 0; i < object.Forecast.length; ++i) {
                                    if (typeof object.Forecast[i] !== "object")
                                        throw TypeError(".NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData.Forecast: object expected");
                                    message.Forecast[i] = $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData.TTrafficForecastData.fromObject(object.Forecast[i]);
                                }
                            }
                            return message;
                        };

                        /**
                         * Creates a plain object from a TTrafficCardData message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData
                         * @static
                         * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData} message TTrafficCardData
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        TTrafficCardData.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.Forecast = [];
                            if (options.defaults) {
                                object.City = "";
                                object.Message = "";
                                object.MapUrl = "";
                                object.ImageUrl = "";
                                object.Level = "";
                                object.Score = 0;
                            }
                            if (message.City != null && message.hasOwnProperty("City"))
                                object.City = message.City;
                            if (message.Message != null && message.hasOwnProperty("Message"))
                                object.Message = message.Message;
                            if (message.MapUrl != null && message.hasOwnProperty("MapUrl"))
                                object.MapUrl = message.MapUrl;
                            if (message.ImageUrl != null && message.hasOwnProperty("ImageUrl"))
                                object.ImageUrl = message.ImageUrl;
                            if (message.Level != null && message.hasOwnProperty("Level"))
                                object.Level = message.Level;
                            if (message.Score != null && message.hasOwnProperty("Score"))
                                object.Score = message.Score;
                            if (message.Forecast && message.Forecast.length) {
                                object.Forecast = [];
                                for (var j = 0; j < message.Forecast.length; ++j)
                                    object.Forecast[j] = $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData.TTrafficForecastData.toObject(message.Forecast[j], options);
                            }
                            return object;
                        };

                        /**
                         * Converts this TTrafficCardData to JSON.
                         * @function toJSON
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        TTrafficCardData.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        TTrafficCardData.TTrafficForecastData = (function() {

                            /**
                             * Properties of a TTrafficForecastData.
                             * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData
                             * @interface ITTrafficForecastData
                             * @property {number|null} [Hour] TTrafficForecastData Hour
                             * @property {number|null} [Score] TTrafficForecastData Score
                             */

                            /**
                             * Constructs a new TTrafficForecastData.
                             * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData
                             * @classdesc Represents a TTrafficForecastData.
                             * @implements ITTrafficForecastData
                             * @constructor
                             * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData.ITTrafficForecastData=} [properties] Properties to set
                             */
                            function TTrafficForecastData(properties) {
                                if (properties)
                                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                        if (properties[keys[i]] != null)
                                            this[keys[i]] = properties[keys[i]];
                            }

                            /**
                             * TTrafficForecastData Hour.
                             * @member {number} Hour
                             * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData.TTrafficForecastData
                             * @instance
                             */
                            TTrafficForecastData.prototype.Hour = 0;

                            /**
                             * TTrafficForecastData Score.
                             * @member {number} Score
                             * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData.TTrafficForecastData
                             * @instance
                             */
                            TTrafficForecastData.prototype.Score = 0;

                            /**
                             * Creates a new TTrafficForecastData instance using the specified properties.
                             * @function create
                             * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData.TTrafficForecastData
                             * @static
                             * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData.ITTrafficForecastData=} [properties] Properties to set
                             * @returns {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData.TTrafficForecastData} TTrafficForecastData instance
                             */
                            TTrafficForecastData.create = function create(properties) {
                                return new TTrafficForecastData(properties);
                            };

                            /**
                             * Encodes the specified TTrafficForecastData message. Does not implicitly {@link NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData.TTrafficForecastData.verify|verify} messages.
                             * @function encode
                             * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData.TTrafficForecastData
                             * @static
                             * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData.ITTrafficForecastData} message TTrafficForecastData message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            TTrafficForecastData.encode = function encode(message, writer) {
                                if (!writer)
                                    writer = $Writer.create();
                                if (message.Hour != null && Object.hasOwnProperty.call(message, "Hour"))
                                    writer.uint32(/* id 1, wireType 0 =*/8).int32(message.Hour);
                                if (message.Score != null && Object.hasOwnProperty.call(message, "Score"))
                                    writer.uint32(/* id 2, wireType 0 =*/16).int32(message.Score);
                                return writer;
                            };

                            /**
                             * Encodes the specified TTrafficForecastData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData.TTrafficForecastData.verify|verify} messages.
                             * @function encodeDelimited
                             * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData.TTrafficForecastData
                             * @static
                             * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData.ITTrafficForecastData} message TTrafficForecastData message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            TTrafficForecastData.encodeDelimited = function encodeDelimited(message, writer) {
                                return this.encode(message, writer).ldelim();
                            };

                            /**
                             * Decodes a TTrafficForecastData message from the specified reader or buffer.
                             * @function decode
                             * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData.TTrafficForecastData
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @param {number} [length] Message length if known beforehand
                             * @returns {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData.TTrafficForecastData} TTrafficForecastData
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            TTrafficForecastData.decode = function decode(reader, length) {
                                if (!(reader instanceof $Reader))
                                    reader = $Reader.create(reader);
                                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData.TTrafficForecastData();
                                while (reader.pos < end) {
                                    var tag = reader.uint32();
                                    switch (tag >>> 3) {
                                    case 1:
                                        message.Hour = reader.int32();
                                        break;
                                    case 2:
                                        message.Score = reader.int32();
                                        break;
                                    default:
                                        reader.skipType(tag & 7);
                                        break;
                                    }
                                }
                                return message;
                            };

                            /**
                             * Decodes a TTrafficForecastData message from the specified reader or buffer, length delimited.
                             * @function decodeDelimited
                             * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData.TTrafficForecastData
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @returns {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData.TTrafficForecastData} TTrafficForecastData
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            TTrafficForecastData.decodeDelimited = function decodeDelimited(reader) {
                                if (!(reader instanceof $Reader))
                                    reader = new $Reader(reader);
                                return this.decode(reader, reader.uint32());
                            };

                            /**
                             * Verifies a TTrafficForecastData message.
                             * @function verify
                             * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData.TTrafficForecastData
                             * @static
                             * @param {Object.<string,*>} message Plain object to verify
                             * @returns {string|null} `null` if valid, otherwise the reason why it is not
                             */
                            TTrafficForecastData.verify = function verify(message) {
                                if (typeof message !== "object" || message === null)
                                    return "object expected";
                                if (message.Hour != null && message.hasOwnProperty("Hour"))
                                    if (!$util.isInteger(message.Hour))
                                        return "Hour: integer expected";
                                if (message.Score != null && message.hasOwnProperty("Score"))
                                    if (!$util.isInteger(message.Score))
                                        return "Score: integer expected";
                                return null;
                            };

                            /**
                             * Creates a TTrafficForecastData message from a plain object. Also converts values to their respective internal types.
                             * @function fromObject
                             * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData.TTrafficForecastData
                             * @static
                             * @param {Object.<string,*>} object Plain object
                             * @returns {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData.TTrafficForecastData} TTrafficForecastData
                             */
                            TTrafficForecastData.fromObject = function fromObject(object) {
                                if (object instanceof $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData.TTrafficForecastData)
                                    return object;
                                var message = new $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData.TTrafficForecastData();
                                if (object.Hour != null)
                                    message.Hour = object.Hour | 0;
                                if (object.Score != null)
                                    message.Score = object.Score | 0;
                                return message;
                            };

                            /**
                             * Creates a plain object from a TTrafficForecastData message. Also converts values to other types if specified.
                             * @function toObject
                             * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData.TTrafficForecastData
                             * @static
                             * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData.TTrafficForecastData} message TTrafficForecastData
                             * @param {$protobuf.IConversionOptions} [options] Conversion options
                             * @returns {Object.<string,*>} Plain object
                             */
                            TTrafficForecastData.toObject = function toObject(message, options) {
                                if (!options)
                                    options = {};
                                var object = {};
                                if (options.defaults) {
                                    object.Hour = 0;
                                    object.Score = 0;
                                }
                                if (message.Hour != null && message.hasOwnProperty("Hour"))
                                    object.Hour = message.Hour;
                                if (message.Score != null && message.hasOwnProperty("Score"))
                                    object.Score = message.Score;
                                return object;
                            };

                            /**
                             * Converts this TTrafficForecastData to JSON.
                             * @function toJSON
                             * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TTrafficCardData.TTrafficForecastData
                             * @instance
                             * @returns {Object.<string,*>} JSON object
                             */
                            TTrafficForecastData.prototype.toJSON = function toJSON() {
                                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                            };

                            return TTrafficForecastData;
                        })();

                        return TTrafficCardData;
                    })();

                    TCardData.TVideoCallCardData = (function() {

                        /**
                         * Properties of a TVideoCallCardData.
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData
                         * @interface ITVideoCallCardData
                         * @property {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.ITLoggedOutCardData|null} [LoggedOutCardData] TVideoCallCardData LoggedOutCardData
                         * @property {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.ITLoggedInCardData|null} [LoggedInCardData] TVideoCallCardData LoggedInCardData
                         */

                        /**
                         * Constructs a new TVideoCallCardData.
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData
                         * @classdesc Represents a TVideoCallCardData.
                         * @implements ITVideoCallCardData
                         * @constructor
                         * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITVideoCallCardData=} [properties] Properties to set
                         */
                        function TVideoCallCardData(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * TVideoCallCardData LoggedOutCardData.
                         * @member {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.ITLoggedOutCardData|null|undefined} LoggedOutCardData
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData
                         * @instance
                         */
                        TVideoCallCardData.prototype.LoggedOutCardData = null;

                        /**
                         * TVideoCallCardData LoggedInCardData.
                         * @member {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.ITLoggedInCardData|null|undefined} LoggedInCardData
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData
                         * @instance
                         */
                        TVideoCallCardData.prototype.LoggedInCardData = null;

                        // OneOf field names bound to virtual getters and setters
                        var $oneOfFields;

                        /**
                         * TVideoCallCardData CardTypeData.
                         * @member {"LoggedOutCardData"|"LoggedInCardData"|undefined} CardTypeData
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData
                         * @instance
                         */
                        Object.defineProperty(TVideoCallCardData.prototype, "CardTypeData", {
                            get: $util.oneOfGetter($oneOfFields = ["LoggedOutCardData", "LoggedInCardData"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });

                        /**
                         * Creates a new TVideoCallCardData instance using the specified properties.
                         * @function create
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData
                         * @static
                         * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITVideoCallCardData=} [properties] Properties to set
                         * @returns {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData} TVideoCallCardData instance
                         */
                        TVideoCallCardData.create = function create(properties) {
                            return new TVideoCallCardData(properties);
                        };

                        /**
                         * Encodes the specified TVideoCallCardData message. Does not implicitly {@link NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.verify|verify} messages.
                         * @function encode
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData
                         * @static
                         * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITVideoCallCardData} message TVideoCallCardData message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        TVideoCallCardData.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.LoggedOutCardData != null && Object.hasOwnProperty.call(message, "LoggedOutCardData"))
                                $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedOutCardData.encode(message.LoggedOutCardData, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.LoggedInCardData != null && Object.hasOwnProperty.call(message, "LoggedInCardData"))
                                $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.encode(message.LoggedInCardData, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                            return writer;
                        };

                        /**
                         * Encodes the specified TVideoCallCardData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData
                         * @static
                         * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITVideoCallCardData} message TVideoCallCardData message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        TVideoCallCardData.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a TVideoCallCardData message from the specified reader or buffer.
                         * @function decode
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData} TVideoCallCardData
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        TVideoCallCardData.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.LoggedOutCardData = $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedOutCardData.decode(reader, reader.uint32());
                                    break;
                                case 2:
                                    message.LoggedInCardData = $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.decode(reader, reader.uint32());
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a TVideoCallCardData message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData} TVideoCallCardData
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        TVideoCallCardData.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a TVideoCallCardData message.
                         * @function verify
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        TVideoCallCardData.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            var properties = {};
                            if (message.LoggedOutCardData != null && message.hasOwnProperty("LoggedOutCardData")) {
                                properties.CardTypeData = 1;
                                {
                                    var error = $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedOutCardData.verify(message.LoggedOutCardData);
                                    if (error)
                                        return "LoggedOutCardData." + error;
                                }
                            }
                            if (message.LoggedInCardData != null && message.hasOwnProperty("LoggedInCardData")) {
                                if (properties.CardTypeData === 1)
                                    return "CardTypeData: multiple values";
                                properties.CardTypeData = 1;
                                {
                                    var error = $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.verify(message.LoggedInCardData);
                                    if (error)
                                        return "LoggedInCardData." + error;
                                }
                            }
                            return null;
                        };

                        /**
                         * Creates a TVideoCallCardData message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData} TVideoCallCardData
                         */
                        TVideoCallCardData.fromObject = function fromObject(object) {
                            if (object instanceof $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData)
                                return object;
                            var message = new $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData();
                            if (object.LoggedOutCardData != null) {
                                if (typeof object.LoggedOutCardData !== "object")
                                    throw TypeError(".NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.LoggedOutCardData: object expected");
                                message.LoggedOutCardData = $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedOutCardData.fromObject(object.LoggedOutCardData);
                            }
                            if (object.LoggedInCardData != null) {
                                if (typeof object.LoggedInCardData !== "object")
                                    throw TypeError(".NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.LoggedInCardData: object expected");
                                message.LoggedInCardData = $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.fromObject(object.LoggedInCardData);
                            }
                            return message;
                        };

                        /**
                         * Creates a plain object from a TVideoCallCardData message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData
                         * @static
                         * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData} message TVideoCallCardData
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        TVideoCallCardData.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (message.LoggedOutCardData != null && message.hasOwnProperty("LoggedOutCardData")) {
                                object.LoggedOutCardData = $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedOutCardData.toObject(message.LoggedOutCardData, options);
                                if (options.oneofs)
                                    object.CardTypeData = "LoggedOutCardData";
                            }
                            if (message.LoggedInCardData != null && message.hasOwnProperty("LoggedInCardData")) {
                                object.LoggedInCardData = $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.toObject(message.LoggedInCardData, options);
                                if (options.oneofs)
                                    object.CardTypeData = "LoggedInCardData";
                            }
                            return object;
                        };

                        /**
                         * Converts this TVideoCallCardData to JSON.
                         * @function toJSON
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        TVideoCallCardData.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        TVideoCallCardData.TLoggedOutCardData = (function() {

                            /**
                             * Properties of a TLoggedOutCardData.
                             * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData
                             * @interface ITLoggedOutCardData
                             */

                            /**
                             * Constructs a new TLoggedOutCardData.
                             * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData
                             * @classdesc Represents a TLoggedOutCardData.
                             * @implements ITLoggedOutCardData
                             * @constructor
                             * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.ITLoggedOutCardData=} [properties] Properties to set
                             */
                            function TLoggedOutCardData(properties) {
                                if (properties)
                                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                        if (properties[keys[i]] != null)
                                            this[keys[i]] = properties[keys[i]];
                            }

                            /**
                             * Creates a new TLoggedOutCardData instance using the specified properties.
                             * @function create
                             * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedOutCardData
                             * @static
                             * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.ITLoggedOutCardData=} [properties] Properties to set
                             * @returns {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedOutCardData} TLoggedOutCardData instance
                             */
                            TLoggedOutCardData.create = function create(properties) {
                                return new TLoggedOutCardData(properties);
                            };

                            /**
                             * Encodes the specified TLoggedOutCardData message. Does not implicitly {@link NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedOutCardData.verify|verify} messages.
                             * @function encode
                             * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedOutCardData
                             * @static
                             * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.ITLoggedOutCardData} message TLoggedOutCardData message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            TLoggedOutCardData.encode = function encode(message, writer) {
                                if (!writer)
                                    writer = $Writer.create();
                                return writer;
                            };

                            /**
                             * Encodes the specified TLoggedOutCardData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedOutCardData.verify|verify} messages.
                             * @function encodeDelimited
                             * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedOutCardData
                             * @static
                             * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.ITLoggedOutCardData} message TLoggedOutCardData message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            TLoggedOutCardData.encodeDelimited = function encodeDelimited(message, writer) {
                                return this.encode(message, writer).ldelim();
                            };

                            /**
                             * Decodes a TLoggedOutCardData message from the specified reader or buffer.
                             * @function decode
                             * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedOutCardData
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @param {number} [length] Message length if known beforehand
                             * @returns {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedOutCardData} TLoggedOutCardData
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            TLoggedOutCardData.decode = function decode(reader, length) {
                                if (!(reader instanceof $Reader))
                                    reader = $Reader.create(reader);
                                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedOutCardData();
                                while (reader.pos < end) {
                                    var tag = reader.uint32();
                                    switch (tag >>> 3) {
                                    default:
                                        reader.skipType(tag & 7);
                                        break;
                                    }
                                }
                                return message;
                            };

                            /**
                             * Decodes a TLoggedOutCardData message from the specified reader or buffer, length delimited.
                             * @function decodeDelimited
                             * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedOutCardData
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @returns {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedOutCardData} TLoggedOutCardData
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            TLoggedOutCardData.decodeDelimited = function decodeDelimited(reader) {
                                if (!(reader instanceof $Reader))
                                    reader = new $Reader(reader);
                                return this.decode(reader, reader.uint32());
                            };

                            /**
                             * Verifies a TLoggedOutCardData message.
                             * @function verify
                             * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedOutCardData
                             * @static
                             * @param {Object.<string,*>} message Plain object to verify
                             * @returns {string|null} `null` if valid, otherwise the reason why it is not
                             */
                            TLoggedOutCardData.verify = function verify(message) {
                                if (typeof message !== "object" || message === null)
                                    return "object expected";
                                return null;
                            };

                            /**
                             * Creates a TLoggedOutCardData message from a plain object. Also converts values to their respective internal types.
                             * @function fromObject
                             * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedOutCardData
                             * @static
                             * @param {Object.<string,*>} object Plain object
                             * @returns {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedOutCardData} TLoggedOutCardData
                             */
                            TLoggedOutCardData.fromObject = function fromObject(object) {
                                if (object instanceof $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedOutCardData)
                                    return object;
                                return new $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedOutCardData();
                            };

                            /**
                             * Creates a plain object from a TLoggedOutCardData message. Also converts values to other types if specified.
                             * @function toObject
                             * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedOutCardData
                             * @static
                             * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedOutCardData} message TLoggedOutCardData
                             * @param {$protobuf.IConversionOptions} [options] Conversion options
                             * @returns {Object.<string,*>} Plain object
                             */
                            TLoggedOutCardData.toObject = function toObject() {
                                return {};
                            };

                            /**
                             * Converts this TLoggedOutCardData to JSON.
                             * @function toJSON
                             * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedOutCardData
                             * @instance
                             * @returns {Object.<string,*>} JSON object
                             */
                            TLoggedOutCardData.prototype.toJSON = function toJSON() {
                                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                            };

                            return TLoggedOutCardData;
                        })();

                        TVideoCallCardData.TLoggedInCardData = (function() {

                            /**
                             * Properties of a TLoggedInCardData.
                             * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData
                             * @interface ITLoggedInCardData
                             * @property {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.ITTelegramCardData|null} [TelegramCardData] TLoggedInCardData TelegramCardData
                             */

                            /**
                             * Constructs a new TLoggedInCardData.
                             * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData
                             * @classdesc Represents a TLoggedInCardData.
                             * @implements ITLoggedInCardData
                             * @constructor
                             * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.ITLoggedInCardData=} [properties] Properties to set
                             */
                            function TLoggedInCardData(properties) {
                                if (properties)
                                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                        if (properties[keys[i]] != null)
                                            this[keys[i]] = properties[keys[i]];
                            }

                            /**
                             * TLoggedInCardData TelegramCardData.
                             * @member {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.ITTelegramCardData|null|undefined} TelegramCardData
                             * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData
                             * @instance
                             */
                            TLoggedInCardData.prototype.TelegramCardData = null;

                            // OneOf field names bound to virtual getters and setters
                            var $oneOfFields;

                            /**
                             * TLoggedInCardData ProviderData.
                             * @member {"TelegramCardData"|undefined} ProviderData
                             * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData
                             * @instance
                             */
                            Object.defineProperty(TLoggedInCardData.prototype, "ProviderData", {
                                get: $util.oneOfGetter($oneOfFields = ["TelegramCardData"]),
                                set: $util.oneOfSetter($oneOfFields)
                            });

                            /**
                             * Creates a new TLoggedInCardData instance using the specified properties.
                             * @function create
                             * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData
                             * @static
                             * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.ITLoggedInCardData=} [properties] Properties to set
                             * @returns {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData} TLoggedInCardData instance
                             */
                            TLoggedInCardData.create = function create(properties) {
                                return new TLoggedInCardData(properties);
                            };

                            /**
                             * Encodes the specified TLoggedInCardData message. Does not implicitly {@link NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.verify|verify} messages.
                             * @function encode
                             * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData
                             * @static
                             * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.ITLoggedInCardData} message TLoggedInCardData message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            TLoggedInCardData.encode = function encode(message, writer) {
                                if (!writer)
                                    writer = $Writer.create();
                                if (message.TelegramCardData != null && Object.hasOwnProperty.call(message, "TelegramCardData"))
                                    $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.TTelegramCardData.encode(message.TelegramCardData, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                                return writer;
                            };

                            /**
                             * Encodes the specified TLoggedInCardData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.verify|verify} messages.
                             * @function encodeDelimited
                             * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData
                             * @static
                             * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.ITLoggedInCardData} message TLoggedInCardData message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            TLoggedInCardData.encodeDelimited = function encodeDelimited(message, writer) {
                                return this.encode(message, writer).ldelim();
                            };

                            /**
                             * Decodes a TLoggedInCardData message from the specified reader or buffer.
                             * @function decode
                             * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @param {number} [length] Message length if known beforehand
                             * @returns {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData} TLoggedInCardData
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            TLoggedInCardData.decode = function decode(reader, length) {
                                if (!(reader instanceof $Reader))
                                    reader = $Reader.create(reader);
                                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData();
                                while (reader.pos < end) {
                                    var tag = reader.uint32();
                                    switch (tag >>> 3) {
                                    case 1:
                                        message.TelegramCardData = $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.TTelegramCardData.decode(reader, reader.uint32());
                                        break;
                                    default:
                                        reader.skipType(tag & 7);
                                        break;
                                    }
                                }
                                return message;
                            };

                            /**
                             * Decodes a TLoggedInCardData message from the specified reader or buffer, length delimited.
                             * @function decodeDelimited
                             * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @returns {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData} TLoggedInCardData
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            TLoggedInCardData.decodeDelimited = function decodeDelimited(reader) {
                                if (!(reader instanceof $Reader))
                                    reader = new $Reader(reader);
                                return this.decode(reader, reader.uint32());
                            };

                            /**
                             * Verifies a TLoggedInCardData message.
                             * @function verify
                             * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData
                             * @static
                             * @param {Object.<string,*>} message Plain object to verify
                             * @returns {string|null} `null` if valid, otherwise the reason why it is not
                             */
                            TLoggedInCardData.verify = function verify(message) {
                                if (typeof message !== "object" || message === null)
                                    return "object expected";
                                var properties = {};
                                if (message.TelegramCardData != null && message.hasOwnProperty("TelegramCardData")) {
                                    properties.ProviderData = 1;
                                    {
                                        var error = $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.TTelegramCardData.verify(message.TelegramCardData);
                                        if (error)
                                            return "TelegramCardData." + error;
                                    }
                                }
                                return null;
                            };

                            /**
                             * Creates a TLoggedInCardData message from a plain object. Also converts values to their respective internal types.
                             * @function fromObject
                             * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData
                             * @static
                             * @param {Object.<string,*>} object Plain object
                             * @returns {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData} TLoggedInCardData
                             */
                            TLoggedInCardData.fromObject = function fromObject(object) {
                                if (object instanceof $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData)
                                    return object;
                                var message = new $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData();
                                if (object.TelegramCardData != null) {
                                    if (typeof object.TelegramCardData !== "object")
                                        throw TypeError(".NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.TelegramCardData: object expected");
                                    message.TelegramCardData = $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.TTelegramCardData.fromObject(object.TelegramCardData);
                                }
                                return message;
                            };

                            /**
                             * Creates a plain object from a TLoggedInCardData message. Also converts values to other types if specified.
                             * @function toObject
                             * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData
                             * @static
                             * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData} message TLoggedInCardData
                             * @param {$protobuf.IConversionOptions} [options] Conversion options
                             * @returns {Object.<string,*>} Plain object
                             */
                            TLoggedInCardData.toObject = function toObject(message, options) {
                                if (!options)
                                    options = {};
                                var object = {};
                                if (message.TelegramCardData != null && message.hasOwnProperty("TelegramCardData")) {
                                    object.TelegramCardData = $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.TTelegramCardData.toObject(message.TelegramCardData, options);
                                    if (options.oneofs)
                                        object.ProviderData = "TelegramCardData";
                                }
                                return object;
                            };

                            /**
                             * Converts this TLoggedInCardData to JSON.
                             * @function toJSON
                             * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData
                             * @instance
                             * @returns {Object.<string,*>} JSON object
                             */
                            TLoggedInCardData.prototype.toJSON = function toJSON() {
                                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                            };

                            TLoggedInCardData.TTelegramCardData = (function() {

                                /**
                                 * Properties of a TTelegramCardData.
                                 * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData
                                 * @interface ITTelegramCardData
                                 * @property {string|null} [UserId] TTelegramCardData UserId
                                 * @property {boolean|null} [ContactsUploaded] TTelegramCardData ContactsUploaded
                                 * @property {Array.<NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.ITFavoriteContactData>|null} [FavoriteContactData] TTelegramCardData FavoriteContactData
                                 */

                                /**
                                 * Constructs a new TTelegramCardData.
                                 * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData
                                 * @classdesc Represents a TTelegramCardData.
                                 * @implements ITTelegramCardData
                                 * @constructor
                                 * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.ITTelegramCardData=} [properties] Properties to set
                                 */
                                function TTelegramCardData(properties) {
                                    this.FavoriteContactData = [];
                                    if (properties)
                                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                            if (properties[keys[i]] != null)
                                                this[keys[i]] = properties[keys[i]];
                                }

                                /**
                                 * TTelegramCardData UserId.
                                 * @member {string} UserId
                                 * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.TTelegramCardData
                                 * @instance
                                 */
                                TTelegramCardData.prototype.UserId = "";

                                /**
                                 * TTelegramCardData ContactsUploaded.
                                 * @member {boolean} ContactsUploaded
                                 * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.TTelegramCardData
                                 * @instance
                                 */
                                TTelegramCardData.prototype.ContactsUploaded = false;

                                /**
                                 * TTelegramCardData FavoriteContactData.
                                 * @member {Array.<NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.ITFavoriteContactData>} FavoriteContactData
                                 * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.TTelegramCardData
                                 * @instance
                                 */
                                TTelegramCardData.prototype.FavoriteContactData = $util.emptyArray;

                                /**
                                 * Creates a new TTelegramCardData instance using the specified properties.
                                 * @function create
                                 * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.TTelegramCardData
                                 * @static
                                 * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.ITTelegramCardData=} [properties] Properties to set
                                 * @returns {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.TTelegramCardData} TTelegramCardData instance
                                 */
                                TTelegramCardData.create = function create(properties) {
                                    return new TTelegramCardData(properties);
                                };

                                /**
                                 * Encodes the specified TTelegramCardData message. Does not implicitly {@link NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.TTelegramCardData.verify|verify} messages.
                                 * @function encode
                                 * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.TTelegramCardData
                                 * @static
                                 * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.ITTelegramCardData} message TTelegramCardData message or plain object to encode
                                 * @param {$protobuf.Writer} [writer] Writer to encode to
                                 * @returns {$protobuf.Writer} Writer
                                 */
                                TTelegramCardData.encode = function encode(message, writer) {
                                    if (!writer)
                                        writer = $Writer.create();
                                    if (message.UserId != null && Object.hasOwnProperty.call(message, "UserId"))
                                        writer.uint32(/* id 1, wireType 2 =*/10).string(message.UserId);
                                    if (message.ContactsUploaded != null && Object.hasOwnProperty.call(message, "ContactsUploaded"))
                                        writer.uint32(/* id 2, wireType 0 =*/16).bool(message.ContactsUploaded);
                                    if (message.FavoriteContactData != null && message.FavoriteContactData.length)
                                        for (var i = 0; i < message.FavoriteContactData.length; ++i)
                                            $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.TFavoriteContactData.encode(message.FavoriteContactData[i], writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                                    return writer;
                                };

                                /**
                                 * Encodes the specified TTelegramCardData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.TTelegramCardData.verify|verify} messages.
                                 * @function encodeDelimited
                                 * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.TTelegramCardData
                                 * @static
                                 * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.ITTelegramCardData} message TTelegramCardData message or plain object to encode
                                 * @param {$protobuf.Writer} [writer] Writer to encode to
                                 * @returns {$protobuf.Writer} Writer
                                 */
                                TTelegramCardData.encodeDelimited = function encodeDelimited(message, writer) {
                                    return this.encode(message, writer).ldelim();
                                };

                                /**
                                 * Decodes a TTelegramCardData message from the specified reader or buffer.
                                 * @function decode
                                 * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.TTelegramCardData
                                 * @static
                                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                                 * @param {number} [length] Message length if known beforehand
                                 * @returns {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.TTelegramCardData} TTelegramCardData
                                 * @throws {Error} If the payload is not a reader or valid buffer
                                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                                 */
                                TTelegramCardData.decode = function decode(reader, length) {
                                    if (!(reader instanceof $Reader))
                                        reader = $Reader.create(reader);
                                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.TTelegramCardData();
                                    while (reader.pos < end) {
                                        var tag = reader.uint32();
                                        switch (tag >>> 3) {
                                        case 1:
                                            message.UserId = reader.string();
                                            break;
                                        case 2:
                                            message.ContactsUploaded = reader.bool();
                                            break;
                                        case 3:
                                            if (!(message.FavoriteContactData && message.FavoriteContactData.length))
                                                message.FavoriteContactData = [];
                                            message.FavoriteContactData.push($root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.TFavoriteContactData.decode(reader, reader.uint32()));
                                            break;
                                        default:
                                            reader.skipType(tag & 7);
                                            break;
                                        }
                                    }
                                    return message;
                                };

                                /**
                                 * Decodes a TTelegramCardData message from the specified reader or buffer, length delimited.
                                 * @function decodeDelimited
                                 * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.TTelegramCardData
                                 * @static
                                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                                 * @returns {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.TTelegramCardData} TTelegramCardData
                                 * @throws {Error} If the payload is not a reader or valid buffer
                                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                                 */
                                TTelegramCardData.decodeDelimited = function decodeDelimited(reader) {
                                    if (!(reader instanceof $Reader))
                                        reader = new $Reader(reader);
                                    return this.decode(reader, reader.uint32());
                                };

                                /**
                                 * Verifies a TTelegramCardData message.
                                 * @function verify
                                 * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.TTelegramCardData
                                 * @static
                                 * @param {Object.<string,*>} message Plain object to verify
                                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                                 */
                                TTelegramCardData.verify = function verify(message) {
                                    if (typeof message !== "object" || message === null)
                                        return "object expected";
                                    if (message.UserId != null && message.hasOwnProperty("UserId"))
                                        if (!$util.isString(message.UserId))
                                            return "UserId: string expected";
                                    if (message.ContactsUploaded != null && message.hasOwnProperty("ContactsUploaded"))
                                        if (typeof message.ContactsUploaded !== "boolean")
                                            return "ContactsUploaded: boolean expected";
                                    if (message.FavoriteContactData != null && message.hasOwnProperty("FavoriteContactData")) {
                                        if (!Array.isArray(message.FavoriteContactData))
                                            return "FavoriteContactData: array expected";
                                        for (var i = 0; i < message.FavoriteContactData.length; ++i) {
                                            var error = $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.TFavoriteContactData.verify(message.FavoriteContactData[i]);
                                            if (error)
                                                return "FavoriteContactData." + error;
                                        }
                                    }
                                    return null;
                                };

                                /**
                                 * Creates a TTelegramCardData message from a plain object. Also converts values to their respective internal types.
                                 * @function fromObject
                                 * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.TTelegramCardData
                                 * @static
                                 * @param {Object.<string,*>} object Plain object
                                 * @returns {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.TTelegramCardData} TTelegramCardData
                                 */
                                TTelegramCardData.fromObject = function fromObject(object) {
                                    if (object instanceof $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.TTelegramCardData)
                                        return object;
                                    var message = new $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.TTelegramCardData();
                                    if (object.UserId != null)
                                        message.UserId = String(object.UserId);
                                    if (object.ContactsUploaded != null)
                                        message.ContactsUploaded = Boolean(object.ContactsUploaded);
                                    if (object.FavoriteContactData) {
                                        if (!Array.isArray(object.FavoriteContactData))
                                            throw TypeError(".NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.TTelegramCardData.FavoriteContactData: array expected");
                                        message.FavoriteContactData = [];
                                        for (var i = 0; i < object.FavoriteContactData.length; ++i) {
                                            if (typeof object.FavoriteContactData[i] !== "object")
                                                throw TypeError(".NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.TTelegramCardData.FavoriteContactData: object expected");
                                            message.FavoriteContactData[i] = $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.TFavoriteContactData.fromObject(object.FavoriteContactData[i]);
                                        }
                                    }
                                    return message;
                                };

                                /**
                                 * Creates a plain object from a TTelegramCardData message. Also converts values to other types if specified.
                                 * @function toObject
                                 * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.TTelegramCardData
                                 * @static
                                 * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.TTelegramCardData} message TTelegramCardData
                                 * @param {$protobuf.IConversionOptions} [options] Conversion options
                                 * @returns {Object.<string,*>} Plain object
                                 */
                                TTelegramCardData.toObject = function toObject(message, options) {
                                    if (!options)
                                        options = {};
                                    var object = {};
                                    if (options.arrays || options.defaults)
                                        object.FavoriteContactData = [];
                                    if (options.defaults) {
                                        object.UserId = "";
                                        object.ContactsUploaded = false;
                                    }
                                    if (message.UserId != null && message.hasOwnProperty("UserId"))
                                        object.UserId = message.UserId;
                                    if (message.ContactsUploaded != null && message.hasOwnProperty("ContactsUploaded"))
                                        object.ContactsUploaded = message.ContactsUploaded;
                                    if (message.FavoriteContactData && message.FavoriteContactData.length) {
                                        object.FavoriteContactData = [];
                                        for (var j = 0; j < message.FavoriteContactData.length; ++j)
                                            object.FavoriteContactData[j] = $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.TFavoriteContactData.toObject(message.FavoriteContactData[j], options);
                                    }
                                    return object;
                                };

                                /**
                                 * Converts this TTelegramCardData to JSON.
                                 * @function toJSON
                                 * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.TTelegramCardData
                                 * @instance
                                 * @returns {Object.<string,*>} JSON object
                                 */
                                TTelegramCardData.prototype.toJSON = function toJSON() {
                                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                                };

                                return TTelegramCardData;
                            })();

                            TLoggedInCardData.TFavoriteContactData = (function() {

                                /**
                                 * Properties of a TFavoriteContactData.
                                 * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData
                                 * @interface ITFavoriteContactData
                                 * @property {string|null} [DisplayName] TFavoriteContactData DisplayName
                                 * @property {string|null} [UserId] TFavoriteContactData UserId
                                 * @property {string|null} [LookupKey] TFavoriteContactData LookupKey
                                 */

                                /**
                                 * Constructs a new TFavoriteContactData.
                                 * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData
                                 * @classdesc Represents a TFavoriteContactData.
                                 * @implements ITFavoriteContactData
                                 * @constructor
                                 * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.ITFavoriteContactData=} [properties] Properties to set
                                 */
                                function TFavoriteContactData(properties) {
                                    if (properties)
                                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                            if (properties[keys[i]] != null)
                                                this[keys[i]] = properties[keys[i]];
                                }

                                /**
                                 * TFavoriteContactData DisplayName.
                                 * @member {string} DisplayName
                                 * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.TFavoriteContactData
                                 * @instance
                                 */
                                TFavoriteContactData.prototype.DisplayName = "";

                                /**
                                 * TFavoriteContactData UserId.
                                 * @member {string} UserId
                                 * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.TFavoriteContactData
                                 * @instance
                                 */
                                TFavoriteContactData.prototype.UserId = "";

                                /**
                                 * TFavoriteContactData LookupKey.
                                 * @member {string} LookupKey
                                 * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.TFavoriteContactData
                                 * @instance
                                 */
                                TFavoriteContactData.prototype.LookupKey = "";

                                /**
                                 * Creates a new TFavoriteContactData instance using the specified properties.
                                 * @function create
                                 * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.TFavoriteContactData
                                 * @static
                                 * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.ITFavoriteContactData=} [properties] Properties to set
                                 * @returns {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.TFavoriteContactData} TFavoriteContactData instance
                                 */
                                TFavoriteContactData.create = function create(properties) {
                                    return new TFavoriteContactData(properties);
                                };

                                /**
                                 * Encodes the specified TFavoriteContactData message. Does not implicitly {@link NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.TFavoriteContactData.verify|verify} messages.
                                 * @function encode
                                 * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.TFavoriteContactData
                                 * @static
                                 * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.ITFavoriteContactData} message TFavoriteContactData message or plain object to encode
                                 * @param {$protobuf.Writer} [writer] Writer to encode to
                                 * @returns {$protobuf.Writer} Writer
                                 */
                                TFavoriteContactData.encode = function encode(message, writer) {
                                    if (!writer)
                                        writer = $Writer.create();
                                    if (message.DisplayName != null && Object.hasOwnProperty.call(message, "DisplayName"))
                                        writer.uint32(/* id 1, wireType 2 =*/10).string(message.DisplayName);
                                    if (message.UserId != null && Object.hasOwnProperty.call(message, "UserId"))
                                        writer.uint32(/* id 2, wireType 2 =*/18).string(message.UserId);
                                    if (message.LookupKey != null && Object.hasOwnProperty.call(message, "LookupKey"))
                                        writer.uint32(/* id 3, wireType 2 =*/26).string(message.LookupKey);
                                    return writer;
                                };

                                /**
                                 * Encodes the specified TFavoriteContactData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.TFavoriteContactData.verify|verify} messages.
                                 * @function encodeDelimited
                                 * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.TFavoriteContactData
                                 * @static
                                 * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.ITFavoriteContactData} message TFavoriteContactData message or plain object to encode
                                 * @param {$protobuf.Writer} [writer] Writer to encode to
                                 * @returns {$protobuf.Writer} Writer
                                 */
                                TFavoriteContactData.encodeDelimited = function encodeDelimited(message, writer) {
                                    return this.encode(message, writer).ldelim();
                                };

                                /**
                                 * Decodes a TFavoriteContactData message from the specified reader or buffer.
                                 * @function decode
                                 * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.TFavoriteContactData
                                 * @static
                                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                                 * @param {number} [length] Message length if known beforehand
                                 * @returns {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.TFavoriteContactData} TFavoriteContactData
                                 * @throws {Error} If the payload is not a reader or valid buffer
                                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                                 */
                                TFavoriteContactData.decode = function decode(reader, length) {
                                    if (!(reader instanceof $Reader))
                                        reader = $Reader.create(reader);
                                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.TFavoriteContactData();
                                    while (reader.pos < end) {
                                        var tag = reader.uint32();
                                        switch (tag >>> 3) {
                                        case 1:
                                            message.DisplayName = reader.string();
                                            break;
                                        case 2:
                                            message.UserId = reader.string();
                                            break;
                                        case 3:
                                            message.LookupKey = reader.string();
                                            break;
                                        default:
                                            reader.skipType(tag & 7);
                                            break;
                                        }
                                    }
                                    return message;
                                };

                                /**
                                 * Decodes a TFavoriteContactData message from the specified reader or buffer, length delimited.
                                 * @function decodeDelimited
                                 * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.TFavoriteContactData
                                 * @static
                                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                                 * @returns {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.TFavoriteContactData} TFavoriteContactData
                                 * @throws {Error} If the payload is not a reader or valid buffer
                                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                                 */
                                TFavoriteContactData.decodeDelimited = function decodeDelimited(reader) {
                                    if (!(reader instanceof $Reader))
                                        reader = new $Reader(reader);
                                    return this.decode(reader, reader.uint32());
                                };

                                /**
                                 * Verifies a TFavoriteContactData message.
                                 * @function verify
                                 * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.TFavoriteContactData
                                 * @static
                                 * @param {Object.<string,*>} message Plain object to verify
                                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                                 */
                                TFavoriteContactData.verify = function verify(message) {
                                    if (typeof message !== "object" || message === null)
                                        return "object expected";
                                    if (message.DisplayName != null && message.hasOwnProperty("DisplayName"))
                                        if (!$util.isString(message.DisplayName))
                                            return "DisplayName: string expected";
                                    if (message.UserId != null && message.hasOwnProperty("UserId"))
                                        if (!$util.isString(message.UserId))
                                            return "UserId: string expected";
                                    if (message.LookupKey != null && message.hasOwnProperty("LookupKey"))
                                        if (!$util.isString(message.LookupKey))
                                            return "LookupKey: string expected";
                                    return null;
                                };

                                /**
                                 * Creates a TFavoriteContactData message from a plain object. Also converts values to their respective internal types.
                                 * @function fromObject
                                 * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.TFavoriteContactData
                                 * @static
                                 * @param {Object.<string,*>} object Plain object
                                 * @returns {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.TFavoriteContactData} TFavoriteContactData
                                 */
                                TFavoriteContactData.fromObject = function fromObject(object) {
                                    if (object instanceof $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.TFavoriteContactData)
                                        return object;
                                    var message = new $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.TFavoriteContactData();
                                    if (object.DisplayName != null)
                                        message.DisplayName = String(object.DisplayName);
                                    if (object.UserId != null)
                                        message.UserId = String(object.UserId);
                                    if (object.LookupKey != null)
                                        message.LookupKey = String(object.LookupKey);
                                    return message;
                                };

                                /**
                                 * Creates a plain object from a TFavoriteContactData message. Also converts values to other types if specified.
                                 * @function toObject
                                 * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.TFavoriteContactData
                                 * @static
                                 * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.TFavoriteContactData} message TFavoriteContactData
                                 * @param {$protobuf.IConversionOptions} [options] Conversion options
                                 * @returns {Object.<string,*>} Plain object
                                 */
                                TFavoriteContactData.toObject = function toObject(message, options) {
                                    if (!options)
                                        options = {};
                                    var object = {};
                                    if (options.defaults) {
                                        object.DisplayName = "";
                                        object.UserId = "";
                                        object.LookupKey = "";
                                    }
                                    if (message.DisplayName != null && message.hasOwnProperty("DisplayName"))
                                        object.DisplayName = message.DisplayName;
                                    if (message.UserId != null && message.hasOwnProperty("UserId"))
                                        object.UserId = message.UserId;
                                    if (message.LookupKey != null && message.hasOwnProperty("LookupKey"))
                                        object.LookupKey = message.LookupKey;
                                    return object;
                                };

                                /**
                                 * Converts this TFavoriteContactData to JSON.
                                 * @function toJSON
                                 * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TVideoCallCardData.TLoggedInCardData.TFavoriteContactData
                                 * @instance
                                 * @returns {Object.<string,*>} JSON object
                                 */
                                TFavoriteContactData.prototype.toJSON = function toJSON() {
                                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                                };

                                return TFavoriteContactData;
                            })();

                            return TLoggedInCardData;
                        })();

                        return TVideoCallCardData;
                    })();

                    TCardData.TExternalSkillCardData = (function() {

                        /**
                         * Properties of a TExternalSkillCardData.
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData
                         * @interface ITExternalSkillCardData
                         * @property {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.ITWidgetGalleryData|null} [widgetGalleryData] TExternalSkillCardData widgetGalleryData
                         * @property {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.ITMainScreenData|null} [mainScreenData] TExternalSkillCardData mainScreenData
                         * @property {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.ITSkillInfo|null} [skillInfo] TExternalSkillCardData skillInfo
                         */

                        /**
                         * Constructs a new TExternalSkillCardData.
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData
                         * @classdesc Represents a TExternalSkillCardData.
                         * @implements ITExternalSkillCardData
                         * @constructor
                         * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITExternalSkillCardData=} [properties] Properties to set
                         */
                        function TExternalSkillCardData(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * TExternalSkillCardData widgetGalleryData.
                         * @member {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.ITWidgetGalleryData|null|undefined} widgetGalleryData
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData
                         * @instance
                         */
                        TExternalSkillCardData.prototype.widgetGalleryData = null;

                        /**
                         * TExternalSkillCardData mainScreenData.
                         * @member {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.ITMainScreenData|null|undefined} mainScreenData
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData
                         * @instance
                         */
                        TExternalSkillCardData.prototype.mainScreenData = null;

                        /**
                         * TExternalSkillCardData skillInfo.
                         * @member {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.ITSkillInfo|null|undefined} skillInfo
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData
                         * @instance
                         */
                        TExternalSkillCardData.prototype.skillInfo = null;

                        // OneOf field names bound to virtual getters and setters
                        var $oneOfFields;

                        /**
                         * TExternalSkillCardData SkillCardData.
                         * @member {"widgetGalleryData"|"mainScreenData"|undefined} SkillCardData
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData
                         * @instance
                         */
                        Object.defineProperty(TExternalSkillCardData.prototype, "SkillCardData", {
                            get: $util.oneOfGetter($oneOfFields = ["widgetGalleryData", "mainScreenData"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });

                        /**
                         * Creates a new TExternalSkillCardData instance using the specified properties.
                         * @function create
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData
                         * @static
                         * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITExternalSkillCardData=} [properties] Properties to set
                         * @returns {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData} TExternalSkillCardData instance
                         */
                        TExternalSkillCardData.create = function create(properties) {
                            return new TExternalSkillCardData(properties);
                        };

                        /**
                         * Encodes the specified TExternalSkillCardData message. Does not implicitly {@link NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.verify|verify} messages.
                         * @function encode
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData
                         * @static
                         * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITExternalSkillCardData} message TExternalSkillCardData message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        TExternalSkillCardData.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.widgetGalleryData != null && Object.hasOwnProperty.call(message, "widgetGalleryData"))
                                $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.TWidgetGalleryData.encode(message.widgetGalleryData, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.mainScreenData != null && Object.hasOwnProperty.call(message, "mainScreenData"))
                                $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.TMainScreenData.encode(message.mainScreenData, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                            if (message.skillInfo != null && Object.hasOwnProperty.call(message, "skillInfo"))
                                $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.TSkillInfo.encode(message.skillInfo, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                            return writer;
                        };

                        /**
                         * Encodes the specified TExternalSkillCardData message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData
                         * @static
                         * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.ITExternalSkillCardData} message TExternalSkillCardData message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        TExternalSkillCardData.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a TExternalSkillCardData message from the specified reader or buffer.
                         * @function decode
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData} TExternalSkillCardData
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        TExternalSkillCardData.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.widgetGalleryData = $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.TWidgetGalleryData.decode(reader, reader.uint32());
                                    break;
                                case 2:
                                    message.mainScreenData = $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.TMainScreenData.decode(reader, reader.uint32());
                                    break;
                                case 3:
                                    message.skillInfo = $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.TSkillInfo.decode(reader, reader.uint32());
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a TExternalSkillCardData message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData} TExternalSkillCardData
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        TExternalSkillCardData.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a TExternalSkillCardData message.
                         * @function verify
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        TExternalSkillCardData.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            var properties = {};
                            if (message.widgetGalleryData != null && message.hasOwnProperty("widgetGalleryData")) {
                                properties.SkillCardData = 1;
                                {
                                    var error = $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.TWidgetGalleryData.verify(message.widgetGalleryData);
                                    if (error)
                                        return "widgetGalleryData." + error;
                                }
                            }
                            if (message.mainScreenData != null && message.hasOwnProperty("mainScreenData")) {
                                if (properties.SkillCardData === 1)
                                    return "SkillCardData: multiple values";
                                properties.SkillCardData = 1;
                                {
                                    var error = $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.TMainScreenData.verify(message.mainScreenData);
                                    if (error)
                                        return "mainScreenData." + error;
                                }
                            }
                            if (message.skillInfo != null && message.hasOwnProperty("skillInfo")) {
                                var error = $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.TSkillInfo.verify(message.skillInfo);
                                if (error)
                                    return "skillInfo." + error;
                            }
                            return null;
                        };

                        /**
                         * Creates a TExternalSkillCardData message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData} TExternalSkillCardData
                         */
                        TExternalSkillCardData.fromObject = function fromObject(object) {
                            if (object instanceof $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData)
                                return object;
                            var message = new $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData();
                            if (object.widgetGalleryData != null) {
                                if (typeof object.widgetGalleryData !== "object")
                                    throw TypeError(".NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.widgetGalleryData: object expected");
                                message.widgetGalleryData = $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.TWidgetGalleryData.fromObject(object.widgetGalleryData);
                            }
                            if (object.mainScreenData != null) {
                                if (typeof object.mainScreenData !== "object")
                                    throw TypeError(".NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.mainScreenData: object expected");
                                message.mainScreenData = $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.TMainScreenData.fromObject(object.mainScreenData);
                            }
                            if (object.skillInfo != null) {
                                if (typeof object.skillInfo !== "object")
                                    throw TypeError(".NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.skillInfo: object expected");
                                message.skillInfo = $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.TSkillInfo.fromObject(object.skillInfo);
                            }
                            return message;
                        };

                        /**
                         * Creates a plain object from a TExternalSkillCardData message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData
                         * @static
                         * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData} message TExternalSkillCardData
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        TExternalSkillCardData.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.skillInfo = null;
                            if (message.widgetGalleryData != null && message.hasOwnProperty("widgetGalleryData")) {
                                object.widgetGalleryData = $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.TWidgetGalleryData.toObject(message.widgetGalleryData, options);
                                if (options.oneofs)
                                    object.SkillCardData = "widgetGalleryData";
                            }
                            if (message.mainScreenData != null && message.hasOwnProperty("mainScreenData")) {
                                object.mainScreenData = $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.TMainScreenData.toObject(message.mainScreenData, options);
                                if (options.oneofs)
                                    object.SkillCardData = "mainScreenData";
                            }
                            if (message.skillInfo != null && message.hasOwnProperty("skillInfo"))
                                object.skillInfo = $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.TSkillInfo.toObject(message.skillInfo, options);
                            return object;
                        };

                        /**
                         * Converts this TExternalSkillCardData to JSON.
                         * @function toJSON
                         * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        TExternalSkillCardData.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        TExternalSkillCardData.TSkillInfo = (function() {

                            /**
                             * Properties of a TSkillInfo.
                             * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData
                             * @interface ITSkillInfo
                             * @property {string|null} [Name] TSkillInfo Name
                             * @property {string|null} [Logo] TSkillInfo Logo
                             * @property {string|null} [SkillId] TSkillInfo SkillId
                             */

                            /**
                             * Constructs a new TSkillInfo.
                             * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData
                             * @classdesc Represents a TSkillInfo.
                             * @implements ITSkillInfo
                             * @constructor
                             * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.ITSkillInfo=} [properties] Properties to set
                             */
                            function TSkillInfo(properties) {
                                if (properties)
                                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                        if (properties[keys[i]] != null)
                                            this[keys[i]] = properties[keys[i]];
                            }

                            /**
                             * TSkillInfo Name.
                             * @member {string} Name
                             * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.TSkillInfo
                             * @instance
                             */
                            TSkillInfo.prototype.Name = "";

                            /**
                             * TSkillInfo Logo.
                             * @member {string} Logo
                             * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.TSkillInfo
                             * @instance
                             */
                            TSkillInfo.prototype.Logo = "";

                            /**
                             * TSkillInfo SkillId.
                             * @member {string} SkillId
                             * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.TSkillInfo
                             * @instance
                             */
                            TSkillInfo.prototype.SkillId = "";

                            /**
                             * Creates a new TSkillInfo instance using the specified properties.
                             * @function create
                             * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.TSkillInfo
                             * @static
                             * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.ITSkillInfo=} [properties] Properties to set
                             * @returns {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.TSkillInfo} TSkillInfo instance
                             */
                            TSkillInfo.create = function create(properties) {
                                return new TSkillInfo(properties);
                            };

                            /**
                             * Encodes the specified TSkillInfo message. Does not implicitly {@link NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.TSkillInfo.verify|verify} messages.
                             * @function encode
                             * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.TSkillInfo
                             * @static
                             * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.ITSkillInfo} message TSkillInfo message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            TSkillInfo.encode = function encode(message, writer) {
                                if (!writer)
                                    writer = $Writer.create();
                                if (message.Name != null && Object.hasOwnProperty.call(message, "Name"))
                                    writer.uint32(/* id 1, wireType 2 =*/10).string(message.Name);
                                if (message.Logo != null && Object.hasOwnProperty.call(message, "Logo"))
                                    writer.uint32(/* id 2, wireType 2 =*/18).string(message.Logo);
                                if (message.SkillId != null && Object.hasOwnProperty.call(message, "SkillId"))
                                    writer.uint32(/* id 3, wireType 2 =*/26).string(message.SkillId);
                                return writer;
                            };

                            /**
                             * Encodes the specified TSkillInfo message, length delimited. Does not implicitly {@link NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.TSkillInfo.verify|verify} messages.
                             * @function encodeDelimited
                             * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.TSkillInfo
                             * @static
                             * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.ITSkillInfo} message TSkillInfo message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            TSkillInfo.encodeDelimited = function encodeDelimited(message, writer) {
                                return this.encode(message, writer).ldelim();
                            };

                            /**
                             * Decodes a TSkillInfo message from the specified reader or buffer.
                             * @function decode
                             * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.TSkillInfo
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @param {number} [length] Message length if known beforehand
                             * @returns {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.TSkillInfo} TSkillInfo
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            TSkillInfo.decode = function decode(reader, length) {
                                if (!(reader instanceof $Reader))
                                    reader = $Reader.create(reader);
                                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.TSkillInfo();
                                while (reader.pos < end) {
                                    var tag = reader.uint32();
                                    switch (tag >>> 3) {
                                    case 1:
                                        message.Name = reader.string();
                                        break;
                                    case 2:
                                        message.Logo = reader.string();
                                        break;
                                    case 3:
                                        message.SkillId = reader.string();
                                        break;
                                    default:
                                        reader.skipType(tag & 7);
                                        break;
                                    }
                                }
                                return message;
                            };

                            /**
                             * Decodes a TSkillInfo message from the specified reader or buffer, length delimited.
                             * @function decodeDelimited
                             * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.TSkillInfo
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @returns {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.TSkillInfo} TSkillInfo
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            TSkillInfo.decodeDelimited = function decodeDelimited(reader) {
                                if (!(reader instanceof $Reader))
                                    reader = new $Reader(reader);
                                return this.decode(reader, reader.uint32());
                            };

                            /**
                             * Verifies a TSkillInfo message.
                             * @function verify
                             * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.TSkillInfo
                             * @static
                             * @param {Object.<string,*>} message Plain object to verify
                             * @returns {string|null} `null` if valid, otherwise the reason why it is not
                             */
                            TSkillInfo.verify = function verify(message) {
                                if (typeof message !== "object" || message === null)
                                    return "object expected";
                                if (message.Name != null && message.hasOwnProperty("Name"))
                                    if (!$util.isString(message.Name))
                                        return "Name: string expected";
                                if (message.Logo != null && message.hasOwnProperty("Logo"))
                                    if (!$util.isString(message.Logo))
                                        return "Logo: string expected";
                                if (message.SkillId != null && message.hasOwnProperty("SkillId"))
                                    if (!$util.isString(message.SkillId))
                                        return "SkillId: string expected";
                                return null;
                            };

                            /**
                             * Creates a TSkillInfo message from a plain object. Also converts values to their respective internal types.
                             * @function fromObject
                             * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.TSkillInfo
                             * @static
                             * @param {Object.<string,*>} object Plain object
                             * @returns {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.TSkillInfo} TSkillInfo
                             */
                            TSkillInfo.fromObject = function fromObject(object) {
                                if (object instanceof $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.TSkillInfo)
                                    return object;
                                var message = new $root.NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.TSkillInfo();
                                if (object.Name != null)
                                    message.Name = String(object.Name);
                                if (object.Logo != null)
                                    message.Logo = String(object.Logo);
                                if (object.SkillId != null)
                                    message.SkillId = String(object.SkillId);
                                return message;
                            };

                            /**
                             * Creates a plain object from a TSkillInfo message. Also converts values to other types if specified.
                             * @function toObject
                             * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.TSkillInfo
                             * @static
                             * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.TSkillInfo} message TSkillInfo
                             * @param {$protobuf.IConversionOptions} [options] Conversion options
                             * @returns {Object.<string,*>} Plain object
                             */
                            TSkillInfo.toObject = function toObject(message, options) {
                                if (!options)
                                    options = {};
                                var object = {};
                                if (options.defaults) {
                                    object.Name = "";
                                    object.Logo = "";
                                    object.SkillId = "";
                                }
                                if (message.Name != null && message.hasOwnProperty("Name"))
                                    object.Name = message.Name;
                                if (message.Logo != null && message.hasOwnProperty("Logo"))
                                    object.Logo = message.Logo;
                                if (message.SkillId != null && message.hasOwnProperty("SkillId"))
                                    object.SkillId = message.SkillId;
                                return object;
                            };

                            /**
                             * Converts this TSkillInfo to JSON.
                             * @function toJSON
                             * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.TSkillInfo
                             * @instance
                             * @returns {Object.<string,*>} JSON object
                             */
                            TSkillInfo.prototype.toJSON = function toJSON() {
                                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                            };

                            return TSkillInfo;
                        })();

                        TExternalSkillCardData.TWidgetGalleryData = (function() {

                            /**
                             * Properties of a TWidgetGalleryData.
                             * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData
                             * @interface ITWidgetGalleryData
                             */

                            /**
                             * Constructs a new TWidgetGalleryData.
                             * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData
                             * @classdesc Represents a TWidgetGalleryData.
                             * @implements ITWidgetGalleryData
                             * @constructor
                             * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.ITWidgetGalleryData=} [properties] Properties to set
                             */
                            function TWidgetGalleryData(properties) {
                                if (properties)
                                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                        if (properties[keys[i]] != null)
                                            this[keys[i]] = properties[keys[i]];
                            }

                            /**
                             * Creates a new TWidgetGalleryData instance using the specified properties.
                             * @function create
                             * @memberof NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.TWidgetGalleryData
                             * @static
                             * @param {NAlice.NData.TCentaurMainScreenMyScreenData.TColumn.TCardData.TExternalSkillCardData.ITWidgetGalleryData=} [properties] Properties to set
                             * @returns {NAlice.NData.TCentaurMainSc